/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.LibC;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXHandler;
import org.jruby.ext.posix.Passwd;

public abstract class BasePOSIX
implements POSIX {
    protected LibC libc;
    protected POSIXHandler handler;

    public BasePOSIX(LibC libc, POSIXHandler handler) {
        this.libc = libc;
        this.handler = handler;
    }

    @Override
    public int chmod(String filename, int mode) {
        return this.libc.chmod(filename, mode);
    }

    @Override
    public int chown(String filename, int user, int group) {
        return this.libc.chown(filename, user, group);
    }

    @Override
    public int getegid() {
        return this.libc.getegid();
    }

    @Override
    public int geteuid() {
        return this.libc.geteuid();
    }

    @Override
    public int getgid() {
        return this.libc.getgid();
    }

    @Override
    public String getlogin() {
        return this.libc.getlogin();
    }

    @Override
    public int getpgid() {
        return this.libc.getpgid();
    }

    @Override
    public int getpgrp() {
        return this.libc.getpgrp();
    }

    @Override
    public int getpid() {
        return this.libc.getpid();
    }

    @Override
    public int getppid() {
        return this.libc.getppid();
    }

    @Override
    public Passwd getpwent() {
        return this.libc.getpwent();
    }

    @Override
    public int getuid() {
        return this.libc.getuid();
    }

    @Override
    public int setegid(int egid) {
        return this.libc.setegid(egid);
    }

    @Override
    public int seteuid(int euid) {
        return this.libc.seteuid(euid);
    }

    @Override
    public int setgid(int gid) {
        return this.libc.setgid(gid);
    }

    @Override
    public int getpgid(int pid) {
        return this.libc.getpgid(pid);
    }

    @Override
    public int setpgid(int pid, int pgid) {
        return this.libc.setpgid(pid, pgid);
    }

    @Override
    public int setpgrp(int pid, int pgrp) {
        return this.libc.setpgrp(pid, pgrp);
    }

    @Override
    public int setsid() {
        return this.libc.setsid();
    }

    @Override
    public int setuid(int uid) {
        return this.libc.setuid(uid);
    }

    @Override
    public int kill(int pid, int signal) {
        return this.libc.kill(pid, signal);
    }

    @Override
    public int lchmod(String filename, int mode) {
        return this.libc.lchmod(filename, mode);
    }

    @Override
    public int lchown(String filename, int user, int group) {
        return this.libc.lchown(filename, user, group);
    }

    @Override
    public int link(String oldpath, String newpath) {
        return this.libc.link(oldpath, newpath);
    }

    @Override
    public FileStat lstat(String path) {
        FileStat stat = this.allocateStat();
        if (this.libc.lstat(path, stat) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, path);
        }
        return stat;
    }

    @Override
    public int mkdir(String path, int mode) {
        return this.libc.mkdir(path, mode);
    }

    @Override
    public FileStat stat(String path) {
        FileStat stat = this.allocateStat();
        if (this.libc.stat(path, stat) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, path);
        }
        return stat;
    }

    @Override
    public int symlink(String oldpath, String newpath) {
        return this.libc.symlink(oldpath, newpath);
    }

    @Override
    public String readlink(String oldpath) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(256);
        int result = this.libc.readlink(oldpath, buffer, buffer.capacity());
        if (result == -1) {
            return null;
        }
        buffer.position(0);
        buffer.limit(result);
        return Charset.forName("ASCII").decode(buffer).toString();
    }

    @Override
    public int umask(int mask) {
        return this.libc.umask(mask);
    }

    @Override
    public int fork() {
        return this.libc.fork();
    }

    @Override
    public int waitpid(int pid, int[] status, int flags) {
        return this.libc.waitpid(pid, status, pid);
    }

    @Override
    public int wait(int[] status) {
        return this.libc.wait(status);
    }

    @Override
    public int getpriority(int which, int who) {
        return this.libc.getpriority(which, who);
    }

    @Override
    public int setpriority(int which, int who, int prio) {
        return this.libc.setpriority(which, who, prio);
    }

    public abstract FileStat allocateStat();
}

