/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.runtime.load.Library;

public class LateLoadingLibrary
implements Library {
    private String libraryName;
    private String className;
    private ClassLoader classLoader;

    public LateLoadingLibrary(String libraryName, String className, ClassLoader classLoader) {
        this.libraryName = libraryName;
        this.className = className;
        this.classLoader = classLoader;
    }

    @Override
    public void load(Ruby runtime, boolean wrap) throws IOException {
        try {
            if (this.classLoader == null && Ruby.isSecurityRestricted()) {
                this.classLoader = runtime.getInstanceConfig().getLoader();
            }
            Library library = (Library)this.classLoader.loadClass(this.className).newInstance();
            library.load(runtime, wrap);
        }
        catch (Throwable e) {
            throw runtime.newLoadError("library `" + this.libraryName + "' could not be loaded: " + e);
        }
    }
}

