/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import org.jruby.Ruby;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.compiler.ASTCompiler;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.MethodCompiler;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DefaultMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.JavaNameMangler;

public class JITCompiler {
    public static void runJIT(DefaultMethod method, Ruby runtime, ThreadContext context, String name) {
        if (method.getCallCount() >= 0) {
            try {
                method.setCallCount(method.getCallCount() + 1);
                if (method.getCallCount() >= runtime.getInstanceConfig().getJitThreshold()) {
                    MethodCompiler methodCompiler;
                    String cleanName = JavaNameMangler.mangleStringForCleanJavaIdentifier(name);
                    String filename = "__eval__";
                    Node bodyNode = method.getBodyNode();
                    final ArgsNode argsNode = method.getArgsNode();
                    StaticScope staticScope = method.getStaticScope();
                    if (bodyNode != null) {
                        filename = bodyNode.getPosition().getFile();
                    } else if (argsNode != null) {
                        filename = argsNode.getPosition().getFile();
                    }
                    StandardASMCompiler asmCompiler = new StandardASMCompiler(cleanName + method.hashCode() + "_" + context.hashCode(), filename);
                    asmCompiler.startScript(staticScope);
                    final ASTCompiler compiler = new ASTCompiler();
                    CompilerCallback args = new CompilerCallback(){

                        @Override
                        public void call(MethodCompiler context) {
                            compiler.compileArgs(argsNode, context);
                        }
                    };
                    ASTInspector inspector = new ASTInspector();
                    inspector.inspect(bodyNode);
                    inspector.inspect(argsNode);
                    CallConfiguration jitCallConfig = null;
                    if (bodyNode != null) {
                        methodCompiler = asmCompiler.startMethod("__file__", args, staticScope, inspector);
                        compiler.compile(bodyNode, methodCompiler);
                    } else if (argsNode != null && (argsNode.getRequiredArgsCount() > 0 || argsNode.getOptionalArgsCount() > 0)) {
                        methodCompiler = asmCompiler.startMethod("__file__", args, staticScope, inspector);
                        methodCompiler.loadNil();
                    } else {
                        methodCompiler = asmCompiler.startMethod("__file__", null, staticScope, inspector);
                        methodCompiler.loadNil();
                        jitCallConfig = CallConfiguration.NO_FRAME_NO_SCOPE;
                    }
                    methodCompiler.endMethod();
                    asmCompiler.endScript();
                    Class<?> sourceClass = asmCompiler.loadClass(new JRubyClassLoader(runtime.getJRubyClassLoader()));
                    if (jitCallConfig == null) {
                        jitCallConfig = !inspector.hasClosure() && !inspector.hasScopeAwareMethods() ? CallConfiguration.FRAME_ONLY : CallConfiguration.FRAME_AND_SCOPE;
                    }
                    Script jitCompiledScript = (Script)sourceClass.newInstance();
                    if (runtime.getInstanceConfig().isJitLogging()) {
                        String className = method.getImplementationClass().getBaseName();
                        if (className == null) {
                            className = "<anon class>";
                        }
                        System.err.println("compiled: " + className + "." + name);
                    }
                    method.setJITCallConfig(jitCallConfig);
                    method.setJITCompiledScript(jitCompiledScript);
                    method.setCallCount(-1);
                }
            }
            catch (Exception e) {
                if (runtime.getInstanceConfig().isJitLoggingVerbose()) {
                    String className = method.getImplementationClass().getBaseName();
                    if (className == null) {
                        className = "<anon class>";
                    }
                    System.err.println("could not compile: " + className + "." + name + " because of: \"" + e.getMessage() + '\"');
                }
                method.setCallCount(-1);
            }
        }
    }
}

