/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;

public class FixnumNode
extends Node
implements ILiteralNode {
    private long value;
    private RubyFixnum fixnum;

    public FixnumNode(ISourcePosition position, long value) {
        super(position, NodeType.FIXNUMNODE);
        this.value = value;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitFixnumNode(this);
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        if (this.fixnum != null) {
            this.fixnum = null;
        }
        this.value = value;
    }

    public RubyFixnum getFixnum(Ruby runtime) {
        if (this.fixnum == null) {
            this.fixnum = RubyFixnum.newFixnum(runtime, this.value);
            return this.fixnum;
        }
        return this.fixnum;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }
}

