/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Region;
import org.joni.encoding.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class RubyStringScanner
extends RubyObject {
    private RubyString str;
    private int pos = 0;
    private int lastPos = -1;
    private Region regs;
    private int beg = -1;
    private int end = -1;
    private static final int MATCHED_STR_SCN_F = 2048;
    private static ObjectAllocator STRINGSCANNER_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyStringScanner(runtime, klass);
        }
    };
    private static final int INSPECT_LENGTH = 5;

    public static RubyClass createScannerClass(Ruby runtime) {
        RubyClass scannerClass = runtime.defineClass("StringScanner", runtime.getObject(), STRINGSCANNER_ALLOCATOR);
        scannerClass.defineAnnotatedMethods(RubyStringScanner.class);
        scannerClass.setConstant("Version", runtime.newString("0.7.0").freeze());
        scannerClass.setConstant("Id", runtime.newString("$Id: strscan.c 13506 2007-09-24 08:56:24Z nobu $").freeze());
        return scannerClass;
    }

    private void clearMatched() {
        this.flags &= 0xFFFFF7FF;
    }

    private void setMatched() {
        this.flags |= 0x800;
    }

    private boolean isMatched() {
        return (this.flags & 0x800) != 0;
    }

    private void check() {
        if (this.str == null) {
            throw this.getRuntime().newArgumentError("uninitialized StringScanner object");
        }
    }

    protected RubyStringScanner(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    @JRubyMethod(name={"initialize"}, required=1, optional=1, frame=true)
    public IRubyObject initialize(IRubyObject[] args, Block unusedBlock) {
        Arity.checkArgumentCount(this.getRuntime(), args, 1, 2);
        this.str = args[0].convertToString();
        return this;
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject other) {
        if (this == other) {
            return this;
        }
        if (!(other instanceof RubyStringScanner)) {
            throw this.getRuntime().newTypeError("wrong argument type " + other.getMetaClass() + " (expected StringScanner)");
        }
        RubyStringScanner otherScanner = (RubyStringScanner)other;
        this.str = otherScanner.str;
        this.pos = otherScanner.pos;
        this.lastPos = otherScanner.lastPos;
        this.flags = otherScanner.flags;
        this.regs = otherScanner.regs != null ? otherScanner.regs.clone() : null;
        this.beg = otherScanner.beg;
        this.end = otherScanner.end;
        return this;
    }

    @JRubyMethod(name={"reset"})
    public IRubyObject reset() {
        this.check();
        this.pos = 0;
        this.clearMatched();
        return this;
    }

    @JRubyMethod(name={"terminate"})
    public IRubyObject terminate() {
        this.check();
        this.pos = this.str.getByteList().realSize;
        this.clearMatched();
        return this;
    }

    @JRubyMethod(name={"clear"})
    public IRubyObject clear() {
        this.check();
        this.getRuntime().getWarnings().warn("StringScanner#clear is obsolete; use #terminate instead");
        return this.terminate();
    }

    @JRubyMethod(name={"string"})
    public RubyString string() {
        return this.str;
    }

    @JRubyMethod(name={"string="}, required=1)
    public IRubyObject set_string(IRubyObject str) {
        this.str = (RubyString)str.convertToString().strDup().freeze();
        this.pos = 0;
        this.clearMatched();
        return str;
    }

    @JRubyMethod(name={"concat", "<<"}, required=1)
    public IRubyObject concat(IRubyObject obj) {
        this.check();
        this.str.append(obj);
        return this;
    }

    @JRubyMethod(name={"pos"})
    public RubyFixnum pos() {
        this.check();
        return RubyFixnum.newFixnum(this.getRuntime(), this.pos);
    }

    @JRubyMethod(name={"pos="}, required=1)
    public IRubyObject set_pos(IRubyObject pos) {
        this.check();
        int i = RubyNumeric.num2int(pos);
        int size = this.str.getByteList().realSize;
        if (i < 0) {
            i += size;
        }
        if (i < 0 || i > size) {
            throw this.getRuntime().newRangeError("index out of range.");
        }
        this.pos = i;
        return RubyFixnum.newFixnum(this.getRuntime(), i);
    }

    private IRubyObject extractRange(int beg, int end) {
        int size = this.str.getByteList().realSize;
        if (beg > size) {
            return this.getRuntime().getNil();
        }
        if (end > size) {
            end = size;
        }
        return this.str.makeShared(beg, end - beg);
    }

    private IRubyObject extractBegLen(int beg, int len) {
        int size = this.str.getByteList().realSize;
        if (beg > size) {
            return this.getRuntime().getNil();
        }
        if (beg + len > size) {
            len = size - beg;
        }
        return this.str.makeShared(beg, len);
    }

    private IRubyObject scan(IRubyObject regex, boolean succptr, boolean getstr, boolean headonly) {
        if (!(regex instanceof RubyRegexp)) {
            throw this.getRuntime().newTypeError("wrong argument type " + regex.getMetaClass() + " (expected Regexp)");
        }
        this.check();
        Regex pattern = ((RubyRegexp)regex).getPattern();
        this.clearMatched();
        int rest = this.str.getByteList().realSize - this.pos;
        if (rest < 0) {
            return this.getRuntime().getNil();
        }
        ByteList value = this.str.getByteList();
        Matcher matcher = pattern.matcher(value.bytes, value.begin + this.pos, value.begin + value.realSize);
        int ret = headonly ? matcher.match(value.begin + this.pos, value.begin + value.realSize, 0) : matcher.search(value.begin + this.pos, value.begin + value.realSize, 0);
        this.regs = matcher.getRegion();
        if (this.regs == null) {
            this.beg = matcher.getBegin();
            this.end = matcher.getEnd();
        } else {
            this.beg = this.regs.beg[0];
            this.end = this.regs.end[0];
        }
        if (ret < 0) {
            return this.getRuntime().getNil();
        }
        this.setMatched();
        this.lastPos = this.pos;
        if (succptr) {
            this.pos += this.end;
        }
        return getstr ? this.extractBegLen(this.lastPos, this.end) : RubyFixnum.newFixnum(this.getRuntime(), this.end);
    }

    @JRubyMethod(name={"scan"}, required=1)
    public IRubyObject scan(IRubyObject regex) {
        return this.scan(regex, true, true, true);
    }

    @JRubyMethod(name={"match?"}, required=1)
    public IRubyObject match_p(IRubyObject regex) {
        return this.scan(regex, false, false, true);
    }

    @JRubyMethod(name={"skip"}, required=1)
    public IRubyObject skip(IRubyObject regex) {
        return this.scan(regex, true, false, true);
    }

    @JRubyMethod(name={"check"}, required=1)
    public IRubyObject check(IRubyObject regex) {
        return this.scan(regex, false, true, true);
    }

    @JRubyMethod(name={"scan_full"}, required=3)
    public IRubyObject scan_full(IRubyObject regex, IRubyObject s, IRubyObject f) {
        return this.scan(regex, s.isTrue(), f.isTrue(), true);
    }

    @JRubyMethod(name={"scan_until"}, required=1)
    public IRubyObject scan_until(IRubyObject regex) {
        return this.scan(regex, true, true, false);
    }

    @JRubyMethod(name={"exist?"}, required=1)
    public IRubyObject exist_p(IRubyObject regex) {
        return this.scan(regex, false, false, false);
    }

    @JRubyMethod(name={"skip_until"}, required=1)
    public IRubyObject skip_until(IRubyObject regex) {
        return this.scan(regex, true, false, false);
    }

    @JRubyMethod(name={"check_until"}, required=1)
    public IRubyObject check_until(IRubyObject regex) {
        return this.scan(regex, false, true, false);
    }

    @JRubyMethod(name={"search_full"}, required=3)
    public IRubyObject search_full(IRubyObject regex, IRubyObject s, IRubyObject f) {
        return this.scan(regex, s.isTrue(), f.isTrue(), false);
    }

    private void adjustRegisters() {
        this.beg = 0;
        this.end = this.pos - this.lastPos;
        this.regs = null;
    }

    @JRubyMethod(name={"getch"})
    public IRubyObject getch() {
        this.check();
        this.clearMatched();
        ByteList value = this.str.getByteList();
        if (this.pos >= value.realSize) {
            return this.getRuntime().getNil();
        }
        Encoding enc = this.getRuntime().getKCode().getEncoding();
        int len = enc.isSingleByte() ? 1 : enc.length(value.bytes[value.begin + this.pos]);
        if (this.pos + len > value.realSize) {
            len = value.realSize - this.pos;
        }
        this.lastPos = this.pos;
        this.pos += len;
        this.setMatched();
        this.adjustRegisters();
        return this.extractRange(this.lastPos + this.beg, this.lastPos + this.end);
    }

    @JRubyMethod(name={"get_byte"})
    public IRubyObject get_byte() {
        this.check();
        this.clearMatched();
        if (this.pos >= this.str.getByteList().realSize) {
            return this.getRuntime().getNil();
        }
        this.lastPos = this.pos++;
        this.setMatched();
        this.adjustRegisters();
        return this.extractRange(this.lastPos + this.beg, this.lastPos + this.end);
    }

    @JRubyMethod(name={"getbyte"})
    public IRubyObject getbyte() {
        this.getRuntime().getWarnings().warn("StringScanner#getbyte is obsolete; use #get_byte instead");
        return this.getbyte();
    }

    @JRubyMethod(name={"peek"}, required=1)
    public IRubyObject peek(IRubyObject length) {
        this.check();
        int len = RubyNumeric.num2int(length);
        ByteList value = this.str.getByteList();
        if (this.pos >= value.realSize) {
            return RubyString.newEmptyString(this.getRuntime()).infectBy(this.str);
        }
        if (this.pos + len > value.realSize) {
            len = value.realSize - this.pos;
        }
        return this.extractBegLen(this.pos, len);
    }

    @JRubyMethod(name={"peep"}, required=1)
    public IRubyObject peep(IRubyObject length) {
        this.getRuntime().getWarnings().warn("StringScanner#peep is obsolete; use #peek instead");
        return this.peek(length);
    }

    @JRubyMethod(name={"unscan"})
    public IRubyObject unscan() {
        this.check();
        if (!this.isMatched()) {
            throw this.getRuntime().newEOFError("unscan failed: previous match had failed");
        }
        this.pos = this.lastPos;
        this.clearMatched();
        return this;
    }

    @JRubyMethod(name={"beginning_of_line?"}, alias={"bol?"})
    public IRubyObject bol_p() {
        this.check();
        ByteList value = this.str.getByteList();
        if (this.pos > value.realSize) {
            return this.getRuntime().getNil();
        }
        if (this.pos == 0) {
            return this.getRuntime().getTrue();
        }
        return value.bytes[value.begin + this.pos - 1] == 10 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"eos?"})
    public RubyBoolean eos_p() {
        this.check();
        return this.pos >= this.str.getByteList().realSize ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p() {
        this.getRuntime().getWarnings().warn("StringScanner#empty? is obsolete; use #eos? instead");
        return this.eos_p();
    }

    @JRubyMethod(name={"rest?"})
    public RubyBoolean rest_p() {
        this.check();
        return this.pos >= this.str.getByteList().realSize ? this.getRuntime().getFalse() : this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"matched?"})
    public RubyBoolean matched_p() {
        this.check();
        return this.isMatched() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"matched"})
    public IRubyObject matched() {
        this.check();
        if (!this.isMatched()) {
            return this.getRuntime().getNil();
        }
        return this.extractRange(this.lastPos + this.beg, this.lastPos + this.end);
    }

    @JRubyMethod(name={"matched_size"})
    public IRubyObject matched_size() {
        this.check();
        if (!this.isMatched()) {
            return this.getRuntime().getNil();
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.end - this.beg);
    }

    @JRubyMethod(name={"matchedsize"})
    public IRubyObject matchedsize() {
        this.getRuntime().getWarnings().warn("StringScanner#matchedsize is obsolete; use #matched_size instead");
        return this.matched_size();
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject op_aref(IRubyObject idx) {
        int numRegs;
        this.check();
        if (!this.isMatched()) {
            return this.getRuntime().getNil();
        }
        int i = RubyNumeric.num2int(idx);
        int n = numRegs = this.regs == null ? 1 : this.regs.numRegs;
        if (i < 0) {
            i += numRegs;
        }
        if (i < 0 || i >= numRegs) {
            return this.getRuntime().getNil();
        }
        if (this.regs == null) {
            assert (i == 0);
            if (this.beg == -1) {
                return this.getRuntime().getNil();
            }
            return this.extractRange(this.lastPos + this.beg, this.lastPos + this.end);
        }
        if (this.regs.beg[i] == -1) {
            return this.getRuntime().getNil();
        }
        return this.extractRange(this.lastPos + this.regs.beg[i], this.lastPos + this.regs.end[i]);
    }

    @JRubyMethod(name={"pre_match"})
    public IRubyObject pre_match() {
        this.check();
        if (!this.isMatched()) {
            return this.getRuntime().getNil();
        }
        return this.extractRange(0, this.lastPos + this.beg);
    }

    @JRubyMethod(name={"post_match"})
    public IRubyObject post_match() {
        this.check();
        if (!this.isMatched()) {
            return this.getRuntime().getNil();
        }
        return this.extractRange(this.lastPos + this.end, this.str.getByteList().realSize);
    }

    @JRubyMethod(name={"rest"})
    public IRubyObject rest() {
        this.check();
        ByteList value = this.str.getByteList();
        if (this.pos >= value.realSize) {
            return RubyString.newEmptyString(this.getRuntime()).infectBy(this.str);
        }
        return this.extractRange(this.pos, value.realSize);
    }

    @JRubyMethod(name={"rest_size"})
    public RubyFixnum rest_size() {
        this.check();
        ByteList value = this.str.getByteList();
        if (this.pos >= value.realSize) {
            return RubyFixnum.zero(this.getRuntime());
        }
        return RubyFixnum.newFixnum(this.getRuntime(), value.realSize - this.pos);
    }

    @JRubyMethod(name={"restsize"})
    public RubyFixnum restsize() {
        this.getRuntime().getWarnings().warn("StringScanner#restsize is obsolete; use #rest_size instead");
        return this.rest_size();
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        if (this.str == null) {
            return this.inspect("(uninitialized)");
        }
        if (this.pos >= this.str.getByteList().realSize) {
            return this.inspect("fin");
        }
        if (this.pos == 0) {
            return this.inspect(this.pos + "/" + this.str.getByteList().realSize + " @ " + this.inspect2());
        }
        return this.inspect(this.pos + "/" + this.str.getByteList().realSize + " " + this.inspect1() + " @ " + this.inspect2());
    }

    private IRubyObject inspect(String msg) {
        RubyString result = this.getRuntime().newString("#<" + this.getMetaClass() + " " + msg + ">");
        if (this.str != null) {
            result.infectBy(this.str);
        }
        return result;
    }

    private IRubyObject inspect1() {
        if (this.pos == 0) {
            return RubyString.newEmptyString(this.getRuntime());
        }
        if (this.pos > 5) {
            return RubyString.newString(this.getRuntime(), "...".getBytes()).append(this.str.substr(this.pos - 5, 5)).inspect();
        }
        return this.str.substr(0, this.pos).inspect();
    }

    private IRubyObject inspect2() {
        if (this.pos >= this.str.getByteList().realSize) {
            return RubyString.newEmptyString(this.getRuntime());
        }
        int len = this.str.getByteList().realSize - this.pos;
        if (len > 5) {
            return ((RubyString)this.str.substr(this.pos, 5)).cat("...".getBytes()).inspect();
        }
        return this.str.substr(this.pos, len).inspect();
    }

    @JRubyMethod(name={"must_C_version"}, meta=true)
    public static IRubyObject mustCversion(IRubyObject recv) {
        return recv;
    }
}

