/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyNameError;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyNoMethodError
extends RubyNameError {
    private IRubyObject args;
    private static ObjectAllocator NOMETHODERROR_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyNoMethodError(runtime, klass);
        }
    };

    public static RubyClass createNoMethodErrorClass(Ruby runtime, RubyClass nameErrorClass) {
        RubyClass noMethodErrorClass = runtime.defineClass("NoMethodError", nameErrorClass, NOMETHODERROR_ALLOCATOR);
        noMethodErrorClass.defineAnnotatedMethods(RubyNoMethodError.class);
        return noMethodErrorClass;
    }

    protected RubyNoMethodError(Ruby runtime, RubyClass exceptionClass) {
        super(runtime, exceptionClass, exceptionClass.getName().toString());
        this.args = runtime.getNil();
    }

    public RubyNoMethodError(Ruby runtime, RubyClass exceptionClass, String message, String name, IRubyObject args) {
        super(runtime, exceptionClass, message, name);
        this.args = args;
    }

    @Override
    @JRubyMethod(name={"initialize"}, optional=3, frame=true)
    public IRubyObject initialize(IRubyObject[] args, Block block) {
        if (args.length > 2) {
            this.args = args[args.length - 1];
            IRubyObject[] tmpArgs = new IRubyObject[args.length - 1];
            System.arraycopy(args, 0, tmpArgs, 0, tmpArgs.length);
            args = tmpArgs;
        } else {
            this.args = this.getRuntime().getNil();
        }
        super.initialize(args, block);
        return this;
    }

    @JRubyMethod(name={"args"})
    public IRubyObject args() {
        return this.args;
    }
}

