/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.CompatVersion;
import org.jruby.IncludedModuleWrapper;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyKernel;
import org.jruby.RubyMethod;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyUnboundMethod;
import org.jruby.anno.JRubyMethod;
import org.jruby.compiler.ASTInspector;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.AliasMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.FullFunctionCallbackMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.internal.runtime.methods.MethodMethod;
import org.jruby.internal.runtime.methods.ProcMethod;
import org.jruby.internal.runtime.methods.SimpleCallbackMethod;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.internal.runtime.methods.WrapperMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.Dispatcher;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.callback.Callback;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ClassProvider;
import org.jruby.util.IdUtil;

public class RubyModule
extends RubyObject {
    static ObjectAllocator MODULE_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyModule(runtime, klass);
        }
    };
    protected RubyClass superClass;
    public int index;
    public Dispatcher dispatcher = Dispatcher.DEFAULT_DISPATCHER;
    public KindOf kindOf = KindOf.DEFAULT_KIND_OF;
    public final int id;
    public RubyModule parent;
    protected String classId;
    protected final ReentrantLock variableWriteLock = new ReentrantLock();
    protected volatile transient ConstantTableEntry[] constantTable = new ConstantTableEntry[8];
    protected transient int constantTableSize;
    protected transient int constantTableThreshold = 6;
    private final Map<String, DynamicMethod> methods = new ConcurrentHashMap<String, DynamicMethod>(12, 2.0f, 1);
    private transient List<ClassProvider> classProviders;
    private static MethodFactory.MethodDefiningCallback methodDefiningCallback = new MethodFactory.MethodDefiningCallback(){

        @Override
        public void define(RubyModule module, Method method, DynamicMethod dynamicMethod) {
            block17: {
                String baseName;
                JRubyMethod jrubyMethod;
                block18: {
                    String baseName2;
                    jrubyMethod = method.getAnnotation(JRubyMethod.class);
                    if (jrubyMethod.frame()) {
                        for (String name : jrubyMethod.name()) {
                            ASTInspector.FRAME_AWARE_METHODS.add(name);
                        }
                    }
                    if (jrubyMethod.compat() != CompatVersion.BOTH && module.getRuntime().getInstanceConfig().getCompatVersion() != jrubyMethod.compat()) break block17;
                    RubyClass metaClass = module.metaClass;
                    if (!jrubyMethod.meta()) break block18;
                    if (jrubyMethod.name().length == 0) {
                        baseName2 = method.getName();
                        metaClass.addMethod(baseName2, dynamicMethod);
                    } else {
                        baseName2 = jrubyMethod.name()[0];
                        String[] stringArray = jrubyMethod.name();
                        int name = stringArray.length;
                        for (int i = 0; i < name; ++i) {
                            String name2 = stringArray[i];
                            metaClass.addMethod(name2, dynamicMethod);
                        }
                    }
                    if (jrubyMethod.alias().length <= 0) break block17;
                    for (String alias : jrubyMethod.alias()) {
                        metaClass.defineAlias(alias, baseName2);
                    }
                    break block17;
                }
                if (jrubyMethod.name().length == 0) {
                    baseName = method.getName();
                    module.addMethod(method.getName(), dynamicMethod);
                } else {
                    baseName = jrubyMethod.name()[0];
                    String[] stringArray = jrubyMethod.name();
                    int name = stringArray.length;
                    for (int i = 0; i < name; ++i) {
                        String name3 = stringArray[i];
                        module.addMethod(name3, dynamicMethod);
                    }
                }
                if (jrubyMethod.alias().length > 0) {
                    for (String alias : jrubyMethod.alias()) {
                        module.defineAlias(alias, baseName);
                    }
                }
                if (jrubyMethod.module()) {
                    DynamicMethod moduleMethod = dynamicMethod.dup();
                    moduleMethod.setVisibility(Visibility.PUBLIC);
                    RubyClass singletonClass = module.getSingletonClass();
                    if (jrubyMethod.name().length == 0) {
                        baseName = method.getName();
                        singletonClass.addMethod(method.getName(), moduleMethod);
                    } else {
                        baseName = jrubyMethod.name()[0];
                        String[] stringArray = jrubyMethod.name();
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String name = stringArray[i];
                            singletonClass.addMethod(name, moduleMethod);
                        }
                    }
                    if (jrubyMethod.alias().length > 0) {
                        for (String alias : jrubyMethod.alias()) {
                            singletonClass.defineAlias(alias, baseName);
                        }
                    }
                }
            }
        }
    };
    protected static final String ERR_INSECURE_SET_CLASS_VAR = "Insecure: can't modify class variable";
    protected static final String ERR_FROZEN_CVAR_TYPE = "class/module ";
    protected static final String ERR_INSECURE_SET_CONSTANT = "Insecure: can't modify constant";
    protected static final String ERR_FROZEN_CONST_TYPE = "class/module ";
    protected static final int CONSTANT_TABLE_DEFAULT_CAPACITY = 8;
    protected static final int CONSTANT_TABLE_MAXIMUM_CAPACITY = 0x40000000;
    protected static final float CONSTANT_TABLE_LOAD_FACTOR = 0.75f;

    public static RubyClass createModuleClass(Ruby runtime, RubyClass moduleClass) {
        moduleClass.index = 12;
        moduleClass.kindOf = new KindOf(){

            @Override
            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyModule;
            }
        };
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyModule.class);
        moduleClass.defineAnnotatedMethods(RubyModule.class);
        moduleClass.dispatcher = callbackFactory.createDispatcher(moduleClass);
        callbackFactory = runtime.callbackFactory(RubyKernel.class);
        moduleClass.defineFastMethod("autoload", callbackFactory.getFastSingletonMethod("autoload", RubyKernel.IRUBY_OBJECT, RubyKernel.IRUBY_OBJECT));
        moduleClass.defineFastMethod("autoload?", callbackFactory.getFastSingletonMethod("autoload_p", RubyKernel.IRUBY_OBJECT));
        return moduleClass;
    }

    @Override
    public int getNativeTypeIndex() {
        return 12;
    }

    @Override
    public boolean isModule() {
        return true;
    }

    @Override
    public boolean isClass() {
        return false;
    }

    public boolean isSingleton() {
        return false;
    }

    public boolean isInstance(IRubyObject object) {
        return this.kindOf.isKindOf(object, this);
    }

    protected RubyModule(Ruby runtime, RubyClass metaClass, boolean objectSpace) {
        super(runtime, metaClass, objectSpace);
        this.id = runtime.allocModuleId();
        this.setFlag(2048, !this.isClass());
    }

    protected RubyModule(Ruby runtime, RubyClass metaClass) {
        this(runtime, metaClass, runtime.isObjectSpaceEnabled());
    }

    protected RubyModule(Ruby runtime) {
        this(runtime, runtime.getModule());
    }

    public boolean needsImplementer() {
        return this.getFlag(2048);
    }

    public static RubyModule newModule(Ruby runtime) {
        return new RubyModule(runtime);
    }

    public static RubyModule newModule(Ruby runtime, String name, RubyModule parent, boolean setParent) {
        RubyModule module = RubyModule.newModule(runtime);
        module.setBaseName(name);
        if (setParent) {
            module.setParent(parent);
        }
        parent.setConstant(name, module);
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addClassProvider(ClassProvider provider) {
        if (this.classProviders == null) {
            List<ClassProvider> cp = Collections.synchronizedList(new ArrayList());
            cp.add(provider);
            this.classProviders = cp;
        } else {
            List<ClassProvider> list = this.classProviders;
            synchronized (list) {
                if (!this.classProviders.contains(provider)) {
                    this.classProviders.add(provider);
                }
            }
        }
    }

    public void removeClassProvider(ClassProvider provider) {
        if (this.classProviders != null) {
            this.classProviders.remove(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyClass searchProvidersForClass(String name, RubyClass superClazz) {
        if (this.classProviders != null) {
            List<ClassProvider> list = this.classProviders;
            synchronized (list) {
                for (ClassProvider classProvider : this.classProviders) {
                    RubyClass clazz = classProvider.defineClassUnder(this, name, superClazz);
                    if (clazz == null) continue;
                    return clazz;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyModule searchProvidersForModule(String name) {
        if (this.classProviders != null) {
            List<ClassProvider> list = this.classProviders;
            synchronized (list) {
                for (ClassProvider classProvider : this.classProviders) {
                    RubyModule module = classProvider.defineModuleUnder(this, name);
                    if (module == null) continue;
                    return module;
                }
            }
        }
        return null;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public RubyClass getSuperClass() {
        return this.superClass;
    }

    protected void setSuperClass(RubyClass superClass) {
        this.superClass = superClass;
    }

    public RubyModule getParent() {
        return this.parent;
    }

    public void setParent(RubyModule parent) {
        this.parent = parent;
    }

    public Map getMethods() {
        return this.methods;
    }

    public void putMethod(Object name, DynamicMethod method) {
        this.dispatcher.clearIndex(MethodIndex.getIndex((String)name));
        this.getMethods().put(name, method);
    }

    public boolean isIncluded() {
        return false;
    }

    public RubyModule getNonIncludedClass() {
        return this;
    }

    public String getBaseName() {
        return this.classId;
    }

    public void setBaseName(String name) {
        this.classId = name;
    }

    public String getName() {
        if (this.getBaseName() == null) {
            if (this.isClass()) {
                return "#<Class:01x" + Integer.toHexString(System.identityHashCode(this)) + ">";
            }
            return "#<Module:01x" + Integer.toHexString(System.identityHashCode(this)) + ">";
        }
        StringBuffer result = new StringBuffer(this.getBaseName());
        RubyClass objectClass = this.getRuntime().getObject();
        for (RubyModule p = this.getParent(); p != null && p != objectClass; p = p.getParent()) {
            String pName = p.getBaseName();
            if (pName == null) {
                pName = p.getName();
            }
            result.insert(0, "::").insert(0, pName);
        }
        return result.toString();
    }

    public IncludedModuleWrapper newIncludeClass(RubyClass superClazz) {
        IncludedModuleWrapper includedModule = new IncludedModuleWrapper(this.getRuntime(), superClazz, this);
        if (this.getSuperClass() != null) {
            includedModule.includeModule(this.getSuperClass());
        }
        return includedModule;
    }

    public RubyClass getClass(String name) {
        IRubyObject module = this.getConstantAt(name);
        if (module instanceof RubyClass) {
            return (RubyClass)module;
        }
        return null;
    }

    public RubyClass fastGetClass(String internedName) {
        IRubyObject module = this.fastGetConstantAt(internedName);
        if (module instanceof RubyClass) {
            return (RubyClass)module;
        }
        return null;
    }

    public synchronized void includeModule(IRubyObject arg) {
        assert (arg != null);
        this.testFrozen("module");
        if (!this.isTaint()) {
            this.getRuntime().secure(4);
        }
        if (!(arg instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("Wrong argument type " + arg.getMetaClass().getName() + " (expected Module).");
        }
        RubyModule module = (RubyModule)arg;
        if (this.isSame(module)) {
            return;
        }
        this.infectBy(module);
        this.doIncludeModule(module);
    }

    public void defineMethod(String name, Callback method) {
        Visibility visibility = name.equals("initialize") ? Visibility.PRIVATE : Visibility.PUBLIC;
        this.addMethod(name, new FullFunctionCallbackMethod(this, method, visibility));
    }

    public void defineAnnotatedMethod(Class clazz, String name) {
        boolean foundMethod = false;
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(name) || !this.defineAnnotatedMethod(method, MethodFactory.createFactory(this.getRuntime().getJRubyClassLoader()))) continue;
            foundMethod = true;
        }
        if (!foundMethod) {
            throw new RuntimeException("No JRubyMethod present for method " + name + "on class " + clazz.getName());
        }
    }

    public void defineAnnotatedMethods(Class clazz) {
        if (RubyInstanceConfig.INDEXED_METHODS) {
            this.defineAnnotatedMethodsIndexed(clazz);
        } else {
            this.defineAnnotatedMethodsIndividually(clazz);
        }
    }

    public void defineAnnotatedMethodsIndividually(Class clazz) {
        Method[] declaredMethods = clazz.getDeclaredMethods();
        MethodFactory methodFactory = MethodFactory.createFactory(this.getRuntime().getJRubyClassLoader());
        for (Method method : declaredMethods) {
            this.defineAnnotatedMethod(method, methodFactory);
        }
    }

    private void defineAnnotatedMethodsIndexed(Class clazz) {
        MethodFactory methodFactory = MethodFactory.createFactory(this.getRuntime().getJRubyClassLoader());
        methodFactory.defineIndexedAnnotatedMethods(this, clazz, methodDefiningCallback);
    }

    public boolean defineAnnotatedMethod(Method method, MethodFactory methodFactory) {
        JRubyMethod jrubyMethod = method.getAnnotation(JRubyMethod.class);
        if (jrubyMethod == null) {
            return false;
        }
        if (jrubyMethod.compat() == CompatVersion.BOTH || this.getRuntime().getInstanceConfig().getCompatVersion() == jrubyMethod.compat()) {
            DynamicMethod dynamicMethod = methodFactory.getAnnotatedMethod(this, method);
            methodDefiningCallback.define(this, method, dynamicMethod);
            return true;
        }
        return false;
    }

    public void defineFastMethod(String name, Callback method) {
        Visibility visibility = name.equals("initialize") ? Visibility.PRIVATE : Visibility.PUBLIC;
        this.addMethod(name, new SimpleCallbackMethod(this, method, visibility));
    }

    public void defineFastMethod(String name, Callback method, Visibility visibility) {
        this.addMethod(name, new SimpleCallbackMethod(this, method, visibility));
    }

    public void definePrivateMethod(String name, Callback method) {
        this.addMethod(name, new FullFunctionCallbackMethod(this, method, Visibility.PRIVATE));
    }

    public void defineFastPrivateMethod(String name, Callback method) {
        this.addMethod(name, new SimpleCallbackMethod(this, method, Visibility.PRIVATE));
    }

    public void defineFastProtectedMethod(String name, Callback method) {
        this.addMethod(name, new SimpleCallbackMethod(this, method, Visibility.PROTECTED));
    }

    public void undefineMethod(String name) {
        this.addMethod(name, UndefinedMethod.getInstance());
    }

    public void undef(String name) {
        DynamicMethod method;
        Ruby runtime = this.getRuntime();
        if (this == runtime.getObject()) {
            runtime.secure(4);
        }
        if (runtime.getSafeLevel() >= 4 && !this.isTaint()) {
            throw new SecurityException("Insecure: can't undef");
        }
        this.testFrozen("module");
        if (name.equals("__id__") || name.equals("__send__")) {
            this.getRuntime().getWarnings().warn("undefining `" + name + "' may cause serious problem");
        }
        if ((method = this.searchMethod(name)).isUndefined()) {
            String s0 = " class";
            RubyModule c = this;
            if (c.isSingleton()) {
                IRubyObject obj = ((MetaClass)c).getAttached();
                if (obj != null && obj instanceof RubyModule) {
                    c = (RubyModule)obj;
                    s0 = "";
                }
            } else if (c.isModule()) {
                s0 = " module";
            }
            throw this.getRuntime().newNameError("Undefined method " + name + " for" + s0 + " '" + c.getName() + "'", name);
        }
        this.addMethod(name, UndefinedMethod.getInstance());
        if (this.isSingleton()) {
            IRubyObject singleton = ((MetaClass)this).getAttached();
            singleton.callMethod(runtime.getCurrentContext(), "singleton_method_undefined", this.getRuntime().newSymbol(name));
        } else {
            this.callMethod(runtime.getCurrentContext(), "method_undefined", this.getRuntime().newSymbol(name));
        }
    }

    @JRubyMethod(name={"include?"}, required=1)
    public IRubyObject include_p(IRubyObject arg) {
        if (!arg.isModule()) {
            throw this.getRuntime().newTypeError(arg, this.getRuntime().getModule());
        }
        for (RubyModule p = this; p != null; p = p.getSuperClass()) {
            if (!(p instanceof IncludedModuleWrapper) || ((IncludedModuleWrapper)p).getNonIncludedClass() != arg) continue;
            return this.getRuntime().newBoolean(true);
        }
        return this.getRuntime().newBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMethod(String name, DynamicMethod method) {
        if (this == this.getRuntime().getObject()) {
            this.getRuntime().secure(4);
        }
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't define method");
        }
        this.testFrozen("class/module");
        Map map = this.getMethods();
        synchronized (map) {
            DynamicMethod existingMethod = (DynamicMethod)this.getMethods().remove(name);
            if (existingMethod != null) {
                this.getRuntime().getCacheMap().remove(name, existingMethod);
            }
            this.putMethod(name, method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMethod(String name) {
        if (this == this.getRuntime().getObject()) {
            this.getRuntime().secure(4);
        }
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't remove method");
        }
        this.testFrozen("class/module");
        Map map = this.getMethods();
        synchronized (map) {
            DynamicMethod method = (DynamicMethod)this.getMethods().remove(name);
            if (method == null) {
                throw this.getRuntime().newNameError("method '" + name + "' not defined in " + this.getName(), name);
            }
            this.getRuntime().getCacheMap().remove(name, method);
        }
        if (this.isSingleton()) {
            IRubyObject singleton = ((MetaClass)this).getAttached();
            singleton.callMethod(this.getRuntime().getCurrentContext(), "singleton_method_removed", this.getRuntime().newSymbol(name));
        } else {
            this.callMethod(this.getRuntime().getCurrentContext(), "method_removed", this.getRuntime().newSymbol(name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicMethod searchMethod(String name) {
        for (RubyModule searchModule = this; searchModule != null; searchModule = searchModule.getSuperClass()) {
            Map map = searchModule.getMethods();
            synchronized (map) {
                DynamicMethod method = (DynamicMethod)searchModule.getMethods().get(name);
                if (method != null) {
                    return method;
                }
                continue;
            }
        }
        return UndefinedMethod.getInstance();
    }

    public DynamicMethod retrieveMethod(String name) {
        return (DynamicMethod)this.getMethods().get(name);
    }

    public RubyModule findImplementer(RubyModule clazz) {
        for (RubyModule searchModule = this; searchModule != null; searchModule = searchModule.getSuperClass()) {
            if (!searchModule.isSame(clazz)) continue;
            return searchModule;
        }
        return null;
    }

    public void addModuleFunction(String name, DynamicMethod method) {
        this.addMethod(name, method);
        this.getSingletonClass().addMethod(name, method);
    }

    public void defineModuleFunction(String name, Callback method) {
        this.definePrivateMethod(name, method);
        this.getSingletonClass().defineMethod(name, method);
    }

    public void definePublicModuleFunction(String name, Callback method) {
        this.defineMethod(name, method);
        this.getSingletonClass().defineMethod(name, method);
    }

    public void defineFastModuleFunction(String name, Callback method) {
        this.defineFastPrivateMethod(name, method);
        this.getSingletonClass().defineFastMethod(name, method);
    }

    public void defineFastPublicModuleFunction(String name, Callback method) {
        this.defineFastMethod(name, method);
        this.getSingletonClass().defineFastMethod(name, method);
    }

    public synchronized void defineAlias(String name, String oldName) {
        this.testFrozen("module");
        if (oldName.equals(name)) {
            return;
        }
        if (this == this.getRuntime().getObject()) {
            this.getRuntime().secure(4);
        }
        DynamicMethod method = this.searchMethod(oldName);
        DynamicMethod oldMethod = this.searchMethod(name);
        if (method.isUndefined()) {
            if (this.isModule()) {
                method = this.getRuntime().getObject().searchMethod(oldName);
            }
            if (method.isUndefined()) {
                throw this.getRuntime().newNameError("undefined method `" + oldName + "' for " + (this.isModule() ? "module" : "class") + " `" + this.getName() + "'", oldName);
            }
        }
        this.getRuntime().getCacheMap().remove(name, method);
        this.getRuntime().getCacheMap().remove(name, oldMethod);
        this.getRuntime().getCacheMap().remove(name, oldMethod.getRealMethod());
        this.putMethod(name, new AliasMethod(this, method, oldName));
    }

    public RubyClass defineOrGetClassUnder(String name, RubyClass superClazz) {
        RubyClass clazz;
        Ruby runtime = this.getRuntime();
        IRubyObject classObj = this.getConstantAt(name);
        if (classObj != null) {
            if (!(classObj instanceof RubyClass)) {
                throw runtime.newTypeError(name + " is not a class");
            }
            clazz = (RubyClass)classObj;
            if (superClazz != null) {
                RubyClass tmp;
                for (tmp = clazz.getSuperClass(); tmp != null && tmp.isIncluded(); tmp = tmp.getSuperClass()) {
                }
                if (tmp != null) {
                    tmp = tmp.getRealClass();
                }
                if (tmp != superClazz) {
                    throw runtime.newTypeError("superclass mismatch for class " + name);
                }
            }
            if (runtime.getSafeLevel() >= 4) {
                throw runtime.newTypeError("extending class prohibited");
            }
        } else if (this.classProviders == null || (clazz = this.searchProvidersForClass(name, superClazz)) == null) {
            if (superClazz == null) {
                superClazz = runtime.getObject();
            }
            clazz = RubyClass.newClass(runtime, superClazz, name, superClazz.getAllocator(), this, true);
        }
        return clazz;
    }

    public RubyModule defineOrGetModuleUnder(String name) {
        RubyModule module;
        Ruby runtime = this.getRuntime();
        IRubyObject moduleObj = this.getConstantAt(name);
        if (moduleObj != null) {
            if (!moduleObj.isModule()) {
                throw runtime.newTypeError(name + " is not a module");
            }
            if (runtime.getSafeLevel() >= 4) {
                throw runtime.newSecurityError("extending module prohibited");
            }
            module = (RubyModule)moduleObj;
        } else if (this.classProviders == null || (module = this.searchProvidersForModule(name)) == null) {
            module = RubyModule.newModule(runtime, name, this, true);
        }
        return module;
    }

    public RubyClass defineClassUnder(String name, RubyClass superClass, ObjectAllocator allocator) {
        return this.getRuntime().defineClassUnder(name, superClass, allocator, this);
    }

    public RubyModule defineModuleUnder(String name) {
        return this.getRuntime().defineModuleUnder(name, this);
    }

    private void addAccessor(String internedName, boolean readable, boolean writeable) {
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        final Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        Visibility attributeScope = context.getCurrentVisibility();
        if (attributeScope != Visibility.PRIVATE && attributeScope == Visibility.MODULE_FUNCTION) {
            attributeScope = Visibility.PRIVATE;
        }
        final String variableName = ("@" + internedName).intern();
        if (readable) {
            this.addMethod(internedName, new JavaMethod(this, Visibility.PUBLIC){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
                    IRubyObject variable;
                    if (args.length != 0) {
                        Arity.raiseArgumentError(runtime, args.length, 0, 0);
                    }
                    return (variable = self.getInstanceVariables().fastGetInstanceVariable(variableName)) == null ? runtime.getNil() : variable;
                }

                @Override
                public Arity getArity() {
                    return Arity.noArguments();
                }
            });
            this.callMethod(context, "method_added", runtime.fastNewSymbol(internedName));
        }
        if (writeable) {
            internedName = (internedName + "=").intern();
            this.addMethod(internedName, new JavaMethod(this, Visibility.PUBLIC){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
                    if (args.length != 1) {
                        Arity.raiseArgumentError(runtime, args.length, 1, 1);
                    }
                    return self.getInstanceVariables().fastSetInstanceVariable(variableName, args[0]);
                }

                @Override
                public Arity getArity() {
                    return Arity.singleArgument();
                }
            });
            this.callMethod(context, "method_added", runtime.fastNewSymbol(internedName));
        }
    }

    public void setMethodVisibility(IRubyObject[] methods, Visibility visibility) {
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't change method visibility");
        }
        for (int i = 0; i < methods.length; ++i) {
            this.exportMethod(methods[i].asJavaString(), visibility);
        }
    }

    public void exportMethod(String name, Visibility visibility) {
        DynamicMethod method;
        if (this == this.getRuntime().getObject()) {
            this.getRuntime().secure(4);
        }
        if ((method = this.searchMethod(name)).isUndefined()) {
            throw this.getRuntime().newNameError("undefined method '" + name + "' for " + (this.isModule() ? "module" : "class") + " '" + this.getName() + "'", name);
        }
        if (method.getVisibility() != visibility) {
            if (this == method.getImplementationClass()) {
                method.setVisibility(visibility);
            } else {
                this.addMethod(name, new WrapperMethod(this, method, visibility));
            }
        }
    }

    public boolean isMethodBound(String name, boolean checkVisibility) {
        DynamicMethod method = this.searchMethod(name);
        if (!method.isUndefined()) {
            return !checkVisibility || method.getVisibility() != Visibility.PRIVATE;
        }
        return false;
    }

    public IRubyObject newMethod(IRubyObject receiver, String name, boolean bound) {
        DynamicMethod method = this.searchMethod(name);
        if (method.isUndefined()) {
            throw this.getRuntime().newNameError("undefined method `" + name + "' for class `" + this.getName() + "'", name);
        }
        RubyMethod newMethod = null;
        newMethod = bound ? RubyMethod.newMethod(method.getImplementationClass(), name, this, name, method, receiver) : RubyUnboundMethod.newUnboundMethod(method.getImplementationClass(), name, this, name, method);
        newMethod.infectBy(this);
        return newMethod;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(name={"define_method"}, required=1, optional=1, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject define_method(IRubyObject[] args, Block block) {
        void var3_11;
        RubyProc proc;
        if (args.length < 1 || args.length > 2) {
            throw this.getRuntime().newArgumentError("wrong # of arguments(" + args.length + " for 1)");
        }
        String name = args[0].asJavaString().intern();
        DynamicMethod newMethod = null;
        ThreadContext tc = this.getRuntime().getCurrentContext();
        Visibility visibility = tc.getCurrentVisibility();
        if (visibility == Visibility.MODULE_FUNCTION) {
            visibility = Visibility.PRIVATE;
        }
        if (args.length == 1) {
            RubyProc rubyProc = proc = this.getRuntime().newProc(Block.Type.LAMBDA, block);
            proc.getBlock().type = Block.Type.LAMBDA;
            newMethod = this.createProcMethod(name, visibility, proc);
        } else {
            if (args.length != 2) throw this.getRuntime().newArgumentError("wrong # of arguments(" + args.length + " for 1)");
            if (this.getRuntime().getProc().isInstance(args[1])) {
                RubyProc rubyProc = proc = (RubyProc)args[1];
                newMethod = this.createProcMethod(name, visibility, proc);
            } else {
                RubyMethod method;
                if (!this.getRuntime().getMethod().isInstance(args[1])) throw this.getRuntime().newTypeError("wrong argument type " + args[1].getType().getName() + " (expected Proc/Method)");
                RubyMethod rubyMethod = method = (RubyMethod)args[1];
                newMethod = new MethodMethod(this, method.unbind(null), visibility);
            }
        }
        this.addMethod(name, newMethod);
        RubySymbol symbol = this.getRuntime().fastNewSymbol(name);
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (tc.getPreviousVisibility() == Visibility.MODULE_FUNCTION) {
            this.getSingletonClass().addMethod(name, new WrapperMethod((RubyModule)this.getSingletonClass(), newMethod, Visibility.PUBLIC));
        }
        if (this.isSingleton()) {
            IRubyObject singleton = ((MetaClass)this).getAttached();
            singleton.callMethod(context, "singleton_method_added", symbol);
            return var3_11;
        } else {
            this.callMethod(context, "method_added", symbol);
        }
        return var3_11;
    }

    private DynamicMethod createProcMethod(String name, Visibility visibility, RubyProc proc) {
        proc.getBlock().getBinding().getFrame().setKlazz(this);
        proc.getBlock().getBinding().getFrame().setName(name);
        proc.getBlock().getBody().getStaticScope().setArgumentScope(true);
        proc.getBlock().getBody().getStaticScope().setRequiredArgs(proc.getBlock().arity().required());
        return new ProcMethod(this, proc, visibility);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject executeUnder(Callback method, IRubyObject[] args, Block block) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        context.preExecuteUnder(this, block);
        try {
            IRubyObject iRubyObject = method.execute(this, args, block);
            return iRubyObject;
        }
        finally {
            context.postExecuteUnder();
        }
    }

    @JRubyMethod(name={"name"})
    public RubyString name() {
        return this.getRuntime().newString(this.getBaseName() == null ? "" : this.getName());
    }

    protected IRubyObject cloneMethods(RubyModule clone) {
        RubyModule realType = this.getNonIncludedClass();
        for (Map.Entry entry : this.getMethods().entrySet()) {
            DynamicMethod method = (DynamicMethod)entry.getValue();
            if (method.getImplementationClass() != realType && !(method instanceof UndefinedMethod)) continue;
            DynamicMethod clonedMethod = method.dup();
            clonedMethod.setImplementationClass(clone);
            clone.putMethod(entry.getKey(), clonedMethod);
        }
        return clone;
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject original) {
        super.initialize_copy(original);
        RubyModule originalModule = (RubyModule)original;
        if (!this.getMetaClass().isSingleton()) {
            this.setMetaClass(originalModule.getSingletonClassClone());
        }
        this.setSuperClass(originalModule.getSuperClass());
        if (originalModule.hasVariables()) {
            this.syncVariables(originalModule.getVariableList());
        }
        originalModule.cloneMethods(this);
        return this;
    }

    @JRubyMethod(name={"included_modules"})
    public RubyArray included_modules() {
        RubyArray ary = this.getRuntime().newArray();
        for (RubyClass p = this.getSuperClass(); p != null; p = p.getSuperClass()) {
            if (!p.isIncluded()) continue;
            ary.append(p.getNonIncludedClass());
        }
        return ary;
    }

    @JRubyMethod(name={"ancestors"})
    public RubyArray ancestors() {
        RubyArray ary = this.getRuntime().newArray(this.getAncestorList());
        return ary;
    }

    public List<IRubyObject> getAncestorList() {
        ArrayList<IRubyObject> list = new ArrayList<IRubyObject>();
        for (RubyModule p = this; p != null; p = p.getSuperClass()) {
            if (p.isSingleton()) continue;
            list.add(p.getNonIncludedClass());
        }
        return list;
    }

    public boolean hasModuleInHierarchy(RubyModule type) {
        for (RubyModule p = this; p != null; p = p.getSuperClass()) {
            if (p.getNonIncludedClass() != type) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.id);
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        if (this.isSingleton()) {
            IRubyObject attached = ((MetaClass)this).getAttached();
            StringBuffer buffer = new StringBuffer("#<Class:");
            if (attached instanceof RubyClass || attached instanceof RubyModule) {
                buffer.append(attached.inspect());
            } else {
                buffer.append(attached.anyToString());
            }
            buffer.append(">");
            return this.getRuntime().newString(buffer.toString());
        }
        return this.getRuntime().newString(this.getName());
    }

    @Override
    @JRubyMethod(name={"==="}, required=1)
    public RubyBoolean op_eqq(IRubyObject obj) {
        return this.getRuntime().newBoolean(this.isInstance(obj));
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(IRubyObject other) {
        return super.op_equal(other);
    }

    @Override
    @JRubyMethod(name={"freeze"})
    public IRubyObject freeze() {
        this.to_s();
        return super.freeze();
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(IRubyObject obj) {
        if (!(obj instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("compared with non class/module");
        }
        if (this.isKindOfModule((RubyModule)obj)) {
            return this.getRuntime().getTrue();
        }
        if (((RubyModule)obj).isKindOfModule(this)) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(IRubyObject obj) {
        return obj == this ? this.getRuntime().getFalse() : this.op_le(obj);
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(IRubyObject obj) {
        if (!(obj instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("compared with non class/module");
        }
        return ((RubyModule)obj).op_le(this);
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(IRubyObject obj) {
        return this == obj ? this.getRuntime().getFalse() : this.op_ge(obj);
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(IRubyObject obj) {
        if (this == obj) {
            return this.getRuntime().newFixnum(0L);
        }
        if (!(obj instanceof RubyModule)) {
            return this.getRuntime().getNil();
        }
        RubyModule module = (RubyModule)obj;
        if (module.isKindOfModule(this)) {
            return this.getRuntime().newFixnum(1L);
        }
        if (this.isKindOfModule(module)) {
            return this.getRuntime().newFixnum(-1L);
        }
        return this.getRuntime().getNil();
    }

    public boolean isKindOfModule(RubyModule type) {
        for (RubyModule p = this; p != null; p = p.getSuperClass()) {
            if (!p.isSame(type)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSame(RubyModule module) {
        return this == module;
    }

    @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(Block block) {
        if (block.isGiven()) {
            block.getBinding().setVisibility(Visibility.PUBLIC);
            block.yield(this.getRuntime().getCurrentContext(), null, this, this, false);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"attr"}, required=1, optional=1, visibility=Visibility.PRIVATE)
    public IRubyObject attr(IRubyObject[] args) {
        Arity.checkArgumentCount(this.getRuntime(), args, 1, 2);
        boolean writeable = args.length > 1 ? args[1].isTrue() : false;
        this.addAccessor(args[0].asJavaString().intern(), true, writeable);
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"attr_reader"}, rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject attr_reader(IRubyObject[] args) {
        for (int i = 0; i < args.length; ++i) {
            this.addAccessor(args[i].asJavaString().intern(), true, false);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"attr_writer"}, rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject attr_writer(IRubyObject[] args) {
        for (int i = 0; i < args.length; ++i) {
            this.addAccessor(args[i].asJavaString().intern(), false, true);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"attr_accessor"}, rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject attr_accessor(IRubyObject[] args) {
        for (int i = 0; i < args.length; ++i) {
            this.addAccessor(args[i].asJavaString().intern(), true, true);
        }
        return this.getRuntime().getNil();
    }

    private RubyArray instance_methods(IRubyObject[] args, Visibility visibility, boolean not) {
        boolean includeSuper = args.length > 0 ? args[0].isTrue() : true;
        RubyArray ary = this.getRuntime().newArray();
        HashSet<String> seen = new HashSet<String>();
        for (RubyModule type = this; type != null; type = type.getSuperClass()) {
            RubyModule realType = type.getNonIncludedClass();
            for (Map.Entry entry : type.getMethods().entrySet()) {
                DynamicMethod method = (DynamicMethod)entry.getValue();
                String methodName = (String)entry.getKey();
                if (seen.contains(methodName)) continue;
                seen.add(methodName);
                if (method.getImplementationClass() != realType || (not || method.getVisibility() != visibility) && (!not || method.getVisibility() == visibility) || method.isUndefined()) continue;
                ary.append(this.getRuntime().newString(methodName));
            }
            if (!includeSuper) break;
        }
        return ary;
    }

    @JRubyMethod(name={"instance_methods"}, optional=1)
    public RubyArray instance_methods(IRubyObject[] args) {
        return this.instance_methods(args, Visibility.PRIVATE, true);
    }

    @JRubyMethod(name={"public_instance_methods"}, optional=1)
    public RubyArray public_instance_methods(IRubyObject[] args) {
        return this.instance_methods(args, Visibility.PUBLIC, false);
    }

    @JRubyMethod(name={"instance_method"}, required=1)
    public IRubyObject instance_method(IRubyObject symbol) {
        return this.newMethod(null, symbol.asJavaString(), false);
    }

    @JRubyMethod(name={"protected_instance_methods"}, optional=1)
    public RubyArray protected_instance_methods(IRubyObject[] args) {
        return this.instance_methods(args, Visibility.PROTECTED, false);
    }

    @JRubyMethod(name={"private_instance_methods"}, optional=1)
    public RubyArray private_instance_methods(IRubyObject[] args) {
        return this.instance_methods(args, Visibility.PRIVATE, false);
    }

    @JRubyMethod(name={"append_features"}, required=1, visibility=Visibility.PRIVATE)
    public RubyModule append_features(IRubyObject module) {
        if (!(module instanceof RubyModule)) {
            throw this.getRuntime().newTypeError(module, this.getRuntime().getClassClass());
        }
        ((RubyModule)module).includeModule(this);
        return this;
    }

    @JRubyMethod(name={"extend_object"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject extend_object(IRubyObject obj) {
        obj.getSingletonClass().includeModule(this);
        return obj;
    }

    @JRubyMethod(name={"include"}, required=1, rest=true, visibility=Visibility.PRIVATE)
    public RubyModule include(IRubyObject[] modules) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        int i = modules.length;
        while (--i >= 0) {
            IRubyObject obj = modules[i];
            if (obj.isModule()) continue;
            throw this.getRuntime().newTypeError(obj, this.getRuntime().getModule());
        }
        for (i = modules.length - 1; i >= 0; --i) {
            modules[i].callMethod(context, "append_features", this);
            modules[i].callMethod(context, "included", this);
        }
        return this;
    }

    @JRubyMethod(name={"included"}, required=1)
    public IRubyObject included(IRubyObject other) {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"extended"}, required=1, frame=true)
    public IRubyObject extended(IRubyObject other, Block block) {
        return this.getRuntime().getNil();
    }

    private void setVisibility(IRubyObject[] args, Visibility visibility) {
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't change method visibility");
        }
        if (args.length == 0) {
            this.getRuntime().getCurrentContext().setCurrentVisibility(visibility);
        } else {
            this.setMethodVisibility(args, visibility);
        }
    }

    @JRubyMethod(name={"public"}, rest=true, visibility=Visibility.PRIVATE)
    public RubyModule rbPublic(IRubyObject[] args) {
        this.setVisibility(args, Visibility.PUBLIC);
        return this;
    }

    @JRubyMethod(name={"protected"}, rest=true, visibility=Visibility.PRIVATE)
    public RubyModule rbProtected(IRubyObject[] args) {
        this.setVisibility(args, Visibility.PROTECTED);
        return this;
    }

    @JRubyMethod(name={"private"}, rest=true, visibility=Visibility.PRIVATE)
    public RubyModule rbPrivate(IRubyObject[] args) {
        this.setVisibility(args, Visibility.PRIVATE);
        return this;
    }

    @JRubyMethod(name={"module_function"}, rest=true, visibility=Visibility.PRIVATE)
    public RubyModule module_function(IRubyObject[] args) {
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't change method visibility");
        }
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (args.length == 0) {
            context.setCurrentVisibility(Visibility.MODULE_FUNCTION);
        } else {
            this.setMethodVisibility(args, Visibility.PRIVATE);
            for (int i = 0; i < args.length; ++i) {
                String name = args[i].asJavaString();
                DynamicMethod method = this.searchMethod(name);
                assert (!method.isUndefined()) : "undefined method '" + name + "'";
                this.getSingletonClass().addMethod(name, new WrapperMethod((RubyModule)this.getSingletonClass(), method, Visibility.PUBLIC));
                this.callMethod(context, "singleton_method_added", this.getRuntime().fastNewSymbol(name));
            }
        }
        return this;
    }

    @JRubyMethod(name={"method_added"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject method_added(IRubyObject nothing) {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"method_removed"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject method_removed(IRubyObject nothing) {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"method_undefined"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject method_undefined(IRubyObject nothing) {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"method_defined?"}, required=1)
    public RubyBoolean method_defined_p(IRubyObject symbol) {
        return this.isMethodBound(symbol.asJavaString(), true) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"public_method_defined?"}, required=1)
    public IRubyObject public_method_defined(IRubyObject symbol) {
        DynamicMethod method = this.searchMethod(symbol.asJavaString());
        return this.getRuntime().newBoolean(!method.isUndefined() && method.getVisibility() == Visibility.PUBLIC);
    }

    @JRubyMethod(name={"protected_method_defined?"}, required=1)
    public IRubyObject protected_method_defined(IRubyObject symbol) {
        DynamicMethod method = this.searchMethod(symbol.asJavaString());
        return this.getRuntime().newBoolean(!method.isUndefined() && method.getVisibility() == Visibility.PROTECTED);
    }

    @JRubyMethod(name={"private_method_defined?"}, required=1)
    public IRubyObject private_method_defined(IRubyObject symbol) {
        DynamicMethod method = this.searchMethod(symbol.asJavaString());
        return this.getRuntime().newBoolean(!method.isUndefined() && method.getVisibility() == Visibility.PRIVATE);
    }

    @JRubyMethod(name={"public_class_method"}, rest=true)
    public RubyModule public_class_method(IRubyObject[] args) {
        this.getMetaClass().setMethodVisibility(args, Visibility.PUBLIC);
        return this;
    }

    @JRubyMethod(name={"private_class_method"}, rest=true)
    public RubyModule private_class_method(IRubyObject[] args) {
        this.getMetaClass().setMethodVisibility(args, Visibility.PRIVATE);
        return this;
    }

    @JRubyMethod(name={"alias_method"}, required=2, visibility=Visibility.PRIVATE)
    public RubyModule alias_method(IRubyObject newId, IRubyObject oldId) {
        this.defineAlias(newId.asJavaString(), oldId.asJavaString());
        this.callMethod(this.getRuntime().getCurrentContext(), "method_added", newId);
        return this;
    }

    @JRubyMethod(name={"undef_method"}, required=1, rest=true, visibility=Visibility.PRIVATE)
    public RubyModule undef_method(IRubyObject[] args) {
        for (int i = 0; i < args.length; ++i) {
            this.undef(args[i].asJavaString());
        }
        return this;
    }

    @JRubyMethod(name={"module_eval", "class_eval"}, optional=3, frame=true)
    public IRubyObject module_eval(IRubyObject[] args, Block block) {
        return this.specificEval(this, args, block);
    }

    @JRubyMethod(name={"remove_method"}, required=1, rest=true, visibility=Visibility.PRIVATE)
    public RubyModule remove_method(IRubyObject[] args) {
        for (int i = 0; i < args.length; ++i) {
            this.removeMethod(args[i].asJavaString());
        }
        return this;
    }

    public static void marshalTo(RubyModule module, MarshalStream output) throws IOException {
        output.registerLinkTarget(module);
        output.writeString(MarshalStream.getPathFromClass(module));
    }

    public static RubyModule unmarshalFrom(UnmarshalStream input) throws IOException {
        String name = RubyString.byteListToString(input.unmarshalString());
        RubyModule result = UnmarshalStream.getModuleFromPath(input.getRuntime(), name);
        input.registerLinkTarget(result);
        return result;
    }

    @JRubyMethod(name={"nesting"}, frame=true, meta=true)
    public static RubyArray nesting(IRubyObject recv, Block block) {
        Ruby runtime = recv.getRuntime();
        RubyClass object = runtime.getObject();
        StaticScope scope = runtime.getCurrentContext().getCurrentScope().getStaticScope();
        RubyArray result = runtime.newArray();
        StaticScope current = scope;
        while (current.getModule() != object) {
            result.append(current.getModule());
            current = current.getPreviousCRefScope();
        }
        return result;
    }

    private void doIncludeModule(RubyModule includedModule) {
        boolean skip = false;
        RubyModule currentModule = this;
        while (includedModule != null) {
            if (this.getNonIncludedClass() == includedModule.getNonIncludedClass()) {
                throw this.getRuntime().newArgumentError("cyclic include detected");
            }
            boolean superclassSeen = false;
            for (RubyClass superClass = this.getSuperClass(); superClass != null; superClass = superClass.getSuperClass()) {
                if (superClass instanceof IncludedModuleWrapper) {
                    if (superClass.getNonIncludedClass() != includedModule.getNonIncludedClass()) continue;
                    if (!superclassSeen) {
                        currentModule = superClass;
                    }
                    skip = true;
                    break;
                }
                superclassSeen = true;
            }
            if (!skip) {
                this.getRuntime().getCacheMap().moduleIncluded(currentModule, includedModule);
                currentModule.setSuperClass(new IncludedModuleWrapper(this.getRuntime(), currentModule.getSuperClass(), includedModule.getNonIncludedClass()));
                currentModule = currentModule.getSuperClass();
            }
            includedModule = includedModule.getSuperClass();
            skip = false;
        }
    }

    @JRubyMethod(name={"class_variable_defined?"}, required=1)
    public IRubyObject class_variable_defined_p(IRubyObject var) {
        String internedName = this.validateClassVariable(var.asJavaString());
        RubyModule module = this;
        do {
            if (!module.fastHasClassVariable(internedName)) continue;
            return this.getRuntime().getTrue();
        } while ((module = module.getSuperClass()) != null);
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"class_variable_get"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject class_variable_get(IRubyObject var) {
        return this.fastGetClassVar(this.validateClassVariable(var.asJavaString()).intern());
    }

    @JRubyMethod(name={"class_variable_set"}, required=2, visibility=Visibility.PRIVATE)
    public IRubyObject class_variable_set(IRubyObject var, IRubyObject value) {
        return this.fastSetClassVar(this.validateClassVariable(var.asJavaString()).intern(), value);
    }

    @JRubyMethod(name={"remove_class_variable"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject remove_class_variable(IRubyObject name) {
        String javaName = this.validateClassVariable(name.asJavaString());
        IRubyObject value = this.deleteClassVariable(javaName);
        if (value != null) {
            return value;
        }
        if (this.fastIsClassVarDefined(javaName)) {
            throw this.cannotRemoveError(javaName);
        }
        throw this.getRuntime().newNameError("class variable " + javaName + " not defined for " + this.getName(), javaName);
    }

    @JRubyMethod(name={"class_variables"})
    public RubyArray class_variables() {
        HashSet<String> names = new HashSet<String>();
        for (RubyModule p = this; p != null; p = p.getSuperClass()) {
            for (String name : p.getClassVariableNameList()) {
                names.add(name);
            }
        }
        Ruby runtime = this.getRuntime();
        RubyArray ary = runtime.newArray();
        for (String name : names) {
            ary.add(runtime.newString(name));
        }
        return ary;
    }

    @JRubyMethod(name={"const_defined?"}, required=1)
    public RubyBoolean const_defined_p(IRubyObject symbol) {
        return this.getRuntime().newBoolean(this.fastIsConstantDefined(this.validateConstant(symbol.asJavaString()).intern()));
    }

    @JRubyMethod(name={"const_get"}, required=1)
    public IRubyObject const_get(IRubyObject symbol) {
        return this.fastGetConstant(this.validateConstant(symbol.asJavaString()).intern());
    }

    @JRubyMethod(name={"const_set"}, required=2)
    public IRubyObject const_set(IRubyObject symbol, IRubyObject value) {
        return this.fastSetConstant(this.validateConstant(symbol.asJavaString()).intern(), value);
    }

    @JRubyMethod(name={"remove_const"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject remove_const(IRubyObject name) {
        String id = this.validateConstant(name.asJavaString());
        IRubyObject value = this.deleteConstant(id);
        if (value != null) {
            if (value != this.getRuntime().getUndef()) {
                return value;
            }
            this.getRuntime().getLoadService().removeAutoLoadFor(this.getName() + "::" + id);
            return this.getRuntime().getNil();
        }
        if (this.hasConstantInHierarchy(id)) {
            throw this.cannotRemoveError(id);
        }
        throw this.getRuntime().newNameError("constant " + id + " not defined for " + this.getName(), id);
    }

    private boolean hasConstantInHierarchy(String name) {
        for (RubyModule p = this; p != null; p = p.getSuperClass()) {
            if (!p.hasConstant(name)) continue;
            return true;
        }
        return false;
    }

    @JRubyMethod(name={"const_missing"}, required=1, frame=true)
    public IRubyObject const_missing(IRubyObject name, Block block) {
        if (this != this.getRuntime().getObject()) {
            throw this.getRuntime().newNameError("uninitialized constant " + this.getName() + "::" + name.asJavaString(), "" + this.getName() + "::" + name.asJavaString());
        }
        throw this.getRuntime().newNameError("uninitialized constant " + name.asJavaString(), name.asJavaString());
    }

    @JRubyMethod(name={"constants"})
    public RubyArray constants() {
        Ruby runtime = this.getRuntime();
        RubyArray array = runtime.newArray();
        RubyClass objectClass = runtime.getObject();
        if (this.getRuntime().getModule() == this) {
            for (String name : objectClass.getStoredConstantNameList()) {
                array.add(runtime.newString(name));
            }
        } else if (objectClass == this) {
            for (String name : this.getStoredConstantNameList()) {
                array.add(runtime.newString(name));
            }
        } else {
            HashSet<String> names = new HashSet<String>();
            for (RubyModule p = this; p != null; p = p.getSuperClass()) {
                if (objectClass == p) continue;
                for (String name : p.getStoredConstantNameList()) {
                    names.add(name);
                }
            }
            for (String name : names) {
                array.add(runtime.newString(name));
            }
        }
        return array;
    }

    public IRubyObject setClassVar(String name, IRubyObject value) {
        RubyModule module = this;
        do {
            if (!module.hasClassVariable(name)) continue;
            return module.storeClassVariable(name, value);
        } while ((module = module.getSuperClass()) != null);
        return this.storeClassVariable(name, value);
    }

    public IRubyObject fastSetClassVar(String internedName, IRubyObject value) {
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        RubyModule module = this;
        do {
            if (!module.fastHasClassVariable(internedName)) continue;
            return module.fastStoreClassVariable(internedName, value);
        } while ((module = module.getSuperClass()) != null);
        return this.fastStoreClassVariable(internedName, value);
    }

    public IRubyObject getClassVar(String name) {
        assert (IdUtil.isClassVariable(name));
        RubyModule module = this;
        do {
            IRubyObject value;
            if ((value = module.variableTableFetch(name)) == null) continue;
            return value;
        } while ((module = module.getSuperClass()) != null);
        throw this.getRuntime().newNameError("uninitialized class variable " + name + " in " + this.getName(), name);
    }

    public IRubyObject fastGetClassVar(String internedName) {
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        assert (IdUtil.isClassVariable(internedName));
        RubyModule module = this;
        do {
            IRubyObject value;
            if ((value = module.variableTableFastFetch(internedName)) == null) continue;
            return value;
        } while ((module = module.getSuperClass()) != null);
        throw this.getRuntime().newNameError("uninitialized class variable " + internedName + " in " + this.getName(), internedName);
    }

    public boolean isClassVarDefined(String name) {
        RubyModule module = this;
        do {
            if (!module.hasClassVariable(name)) continue;
            return true;
        } while ((module = module.getSuperClass()) != null);
        return false;
    }

    public boolean fastIsClassVarDefined(String internedName) {
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        RubyModule module = this;
        do {
            if (!module.fastHasClassVariable(internedName)) continue;
            return true;
        } while ((module = module.getSuperClass()) != null);
        return false;
    }

    public IRubyObject removeCvar(IRubyObject name) {
        String internedName = this.validateClassVariable(name.asJavaString());
        IRubyObject value = this.deleteClassVariable(internedName);
        if (value != null) {
            return value;
        }
        if (this.fastIsClassVarDefined(internedName)) {
            throw this.cannotRemoveError(internedName);
        }
        throw this.getRuntime().newNameError("class variable " + internedName + " not defined for " + this.getName(), internedName);
    }

    public IRubyObject getConstantAt(String name) {
        IRubyObject value = this.fetchConstant(name);
        if (value != this.getRuntime().getUndef()) {
            return value;
        }
        this.deleteConstant(name);
        return this.getRuntime().getLoadService().autoload(this.getName() + "::" + name);
    }

    public IRubyObject fastGetConstantAt(String internedName) {
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        IRubyObject value = this.fastFetchConstant(internedName);
        if (value != this.getRuntime().getUndef()) {
            return value;
        }
        this.deleteConstant(internedName);
        return this.getRuntime().getLoadService().autoload(this.getName() + "::" + internedName);
    }

    public IRubyObject getConstant(String name) {
        assert (IdUtil.isConstant(name));
        IRubyObject undef = this.getRuntime().getUndef();
        boolean retryForModule = false;
        RubyModule p = this;
        while (true) {
            if (p != null) {
                IRubyObject value = p.constantTableFetch(name);
                if (value != null) {
                    if (value != undef) {
                        return value;
                    }
                    p.deleteConstant(name);
                    if (this.getRuntime().getLoadService().autoload(p.getName() + "::" + name) != null) continue;
                } else {
                    p = p.getSuperClass();
                    continue;
                }
            }
            if (retryForModule || this.isClass()) break;
            retryForModule = true;
            p = this.getRuntime().getObject();
        }
        return this.callMethod(this.getRuntime().getCurrentContext(), "const_missing", this.getRuntime().newSymbol(name));
    }

    public IRubyObject fastGetConstant(String internedName) {
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        assert (IdUtil.isConstant(internedName));
        IRubyObject undef = this.getRuntime().getUndef();
        boolean retryForModule = false;
        RubyModule p = this;
        while (true) {
            if (p != null) {
                IRubyObject value = p.constantTableFastFetch(internedName);
                if (value != null) {
                    if (value != undef) {
                        return value;
                    }
                    p.deleteConstant(internedName);
                    if (this.getRuntime().getLoadService().autoload(p.getName() + "::" + internedName) != null) continue;
                } else {
                    p = p.getSuperClass();
                    continue;
                }
            }
            if (retryForModule || this.isClass()) break;
            retryForModule = true;
            p = this.getRuntime().getObject();
        }
        return this.callMethod(this.getRuntime().getCurrentContext(), "const_missing", this.getRuntime().fastNewSymbol(internedName));
    }

    public IRubyObject getConstantFrom(String name) {
        return this.fastGetConstantFrom(name.intern());
    }

    public IRubyObject fastGetConstantFrom(String internedName) {
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        assert (IdUtil.isConstant(internedName));
        RubyClass objectClass = this.getRuntime().getObject();
        IRubyObject undef = this.getRuntime().getUndef();
        RubyModule p = this;
        while (p != null) {
            IRubyObject value = p.constantTableFastFetch(internedName);
            if (value != null) {
                if (value != undef) {
                    if (p == objectClass && this != objectClass) {
                        this.getRuntime().getWarnings().warn("toplevel constant " + internedName + " referenced by " + this.getName() + "::" + internedName);
                    }
                    return value;
                }
                p.deleteConstant(internedName);
                if (this.getRuntime().getLoadService().autoload(p.getName() + "::" + internedName) != null) continue;
                break;
            }
            p = p.getSuperClass();
        }
        return this.callMethod(this.getRuntime().getCurrentContext(), "const_missing", this.getRuntime().fastNewSymbol(internedName));
    }

    public IRubyObject setConstant(String name, IRubyObject value) {
        RubyModule module;
        IRubyObject oldValue = this.fetchConstant(name);
        if (oldValue != null) {
            if (oldValue == this.getRuntime().getUndef()) {
                this.getRuntime().getLoadService().removeAutoLoadFor(this.getName() + "::" + name);
            } else {
                this.getRuntime().getWarnings().warn("already initialized constant " + name);
            }
        }
        this.storeConstant(name, value);
        if (value instanceof RubyModule && (module = (RubyModule)value).getBaseName() == null) {
            module.setBaseName(name);
            module.setParent(this);
        }
        return value;
    }

    public IRubyObject fastSetConstant(String internedName, IRubyObject value) {
        RubyModule module;
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        IRubyObject oldValue = this.fastFetchConstant(internedName);
        if (oldValue != null) {
            if (oldValue == this.getRuntime().getUndef()) {
                this.getRuntime().getLoadService().removeAutoLoadFor(this.getName() + "::" + internedName);
            } else {
                this.getRuntime().getWarnings().warn("already initialized constant " + internedName);
            }
        }
        this.fastStoreConstant(internedName, value);
        if (value instanceof RubyModule && (module = (RubyModule)value).getBaseName() == null) {
            module.setBaseName(internedName);
            module.setParent(this);
        }
        return value;
    }

    public void defineConstant(String name, IRubyObject value) {
        assert (value != null);
        if (this == this.getRuntime().getClassClass()) {
            this.getRuntime().secure(4);
        }
        if (!IdUtil.isValidConstantName(name)) {
            throw this.getRuntime().newNameError("bad constant name " + name, name);
        }
        this.setConstant(name, value);
    }

    public boolean isConstantDefined(String name) {
        assert (IdUtil.isConstant(name));
        boolean isObject = this == this.getRuntime().getObject();
        IRubyObject undef = this.getRuntime().getUndef();
        RubyModule module = this;
        do {
            IRubyObject value;
            if ((value = module.constantTableFetch(name)) == null) continue;
            if (value != undef) {
                return true;
            }
            return this.getRuntime().getLoadService().autoloadFor(module.getName() + "::" + name) != null;
        } while (isObject && (module = module.getSuperClass()) != null);
        return false;
    }

    public boolean fastIsConstantDefined(String internedName) {
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        assert (IdUtil.isConstant(internedName));
        boolean isObject = this == this.getRuntime().getObject();
        IRubyObject undef = this.getRuntime().getUndef();
        RubyModule module = this;
        do {
            IRubyObject value;
            if ((value = module.constantTableFastFetch(internedName)) == null) continue;
            if (value != undef) {
                return true;
            }
            return this.getRuntime().getLoadService().autoloadFor(module.getName() + "::" + internedName) != null;
        } while (isObject && (module = module.getSuperClass()) != null);
        return false;
    }

    private RaiseException cannotRemoveError(String id) {
        return this.getRuntime().newNameError("cannot remove " + id + " for " + this.getName(), id);
    }

    public boolean hasInternalModuleVariable(String name) {
        RubyModule module = this;
        do {
            if (!module.hasInternalVariable(name)) continue;
            return true;
        } while ((module = module.getSuperClass()) != null);
        return false;
    }

    public IRubyObject searchInternalModuleVariable(String name) {
        RubyModule module = this;
        do {
            IRubyObject value;
            if ((value = module.getInternalVariable(name)) == null) continue;
            return value;
        } while ((module = module.getSuperClass()) != null);
        return null;
    }

    public void setInternalModuleVariable(String name, IRubyObject value) {
        RubyModule module = this;
        do {
            if (!module.hasInternalVariable(name)) continue;
            module.setInternalVariable(name, value);
            return;
        } while ((module = module.getSuperClass()) != null);
        this.setInternalVariable(name, value);
    }

    public boolean hasClassVariable(String name) {
        assert (IdUtil.isClassVariable(name));
        return this.variableTableContains(name);
    }

    public boolean fastHasClassVariable(String internedName) {
        assert (IdUtil.isClassVariable(internedName));
        return this.variableTableFastContains(internedName);
    }

    public IRubyObject fetchClassVariable(String name) {
        assert (IdUtil.isClassVariable(name));
        return this.variableTableFetch(name);
    }

    public IRubyObject fastFetchClassVariable(String internedName) {
        assert (IdUtil.isClassVariable(internedName));
        return this.variableTableFastFetch(internedName);
    }

    public IRubyObject storeClassVariable(String name, IRubyObject value) {
        assert (IdUtil.isClassVariable(name) && value != null);
        this.ensureClassVariablesSettable();
        return this.variableTableStore(name, value);
    }

    public IRubyObject fastStoreClassVariable(String internedName, IRubyObject value) {
        assert (IdUtil.isClassVariable(internedName) && value != null);
        this.ensureClassVariablesSettable();
        return this.variableTableFastStore(internedName, value);
    }

    public IRubyObject deleteClassVariable(String name) {
        assert (IdUtil.isClassVariable(name));
        this.ensureClassVariablesSettable();
        return this.variableTableRemove(name);
    }

    public List<Variable<IRubyObject>> getClassVariableList() {
        ArrayList<Variable<IRubyObject>> list = new ArrayList<Variable<IRubyObject>>();
        RubyObject.VariableTableEntry[] table = this.variableTableGetTable();
        int i = table.length;
        while (--i >= 0) {
            RubyObject.VariableTableEntry e = table[i];
            while (e != null) {
                if (IdUtil.isClassVariable(e.name)) {
                    IRubyObject readValue = e.value;
                    if (readValue == null) {
                        readValue = this.variableTableReadLocked(e);
                    }
                    list.add(new VariableEntry<IRubyObject>(e.name, readValue));
                }
                e = e.next;
            }
        }
        return list;
    }

    public List<String> getClassVariableNameList() {
        ArrayList<String> list = new ArrayList<String>();
        RubyObject.VariableTableEntry[] table = this.variableTableGetTable();
        int i = table.length;
        while (--i >= 0) {
            RubyObject.VariableTableEntry e = table[i];
            while (e != null) {
                if (IdUtil.isClassVariable(e.name)) {
                    list.add(e.name);
                }
                e = e.next;
            }
        }
        return list;
    }

    protected final String validateClassVariable(String name) {
        if (IdUtil.isValidClassVariableName(name)) {
            return name;
        }
        throw this.getRuntime().newNameError("`" + name + "' is not allowed as a class variable name", name);
    }

    protected final void ensureClassVariablesSettable() {
        if (!this.isFrozen() && (this.getRuntime().getSafeLevel() < 4 || this.isTaint())) {
            return;
        }
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError(ERR_INSECURE_SET_CONSTANT);
        }
        if (this.isFrozen()) {
            if (this instanceof RubyModule) {
                throw this.getRuntime().newFrozenError("class/module ");
            }
            throw this.getRuntime().newFrozenError("");
        }
    }

    public boolean hasConstant(String name) {
        assert (IdUtil.isConstant(name));
        return this.constantTableContains(name);
    }

    public boolean fastHasConstant(String internedName) {
        assert (IdUtil.isConstant(internedName));
        return this.constantTableFastContains(internedName);
    }

    public IRubyObject fetchConstant(String name) {
        assert (IdUtil.isConstant(name));
        return this.constantTableFetch(name);
    }

    public IRubyObject fastFetchConstant(String internedName) {
        assert (IdUtil.isConstant(internedName));
        return this.constantTableFastFetch(internedName);
    }

    public IRubyObject storeConstant(String name, IRubyObject value) {
        assert (IdUtil.isConstant(name) && value != null);
        this.ensureConstantsSettable();
        return this.constantTableStore(name, value);
    }

    public IRubyObject fastStoreConstant(String internedName, IRubyObject value) {
        assert (IdUtil.isConstant(internedName) && value != null);
        this.ensureConstantsSettable();
        return this.constantTableFastStore(internedName, value);
    }

    public IRubyObject deleteConstant(String name) {
        assert (IdUtil.isConstant(name));
        this.ensureConstantsSettable();
        return this.constantTableRemove(name);
    }

    public List<Variable<IRubyObject>> getStoredConstantList() {
        ArrayList<Variable<IRubyObject>> list = new ArrayList<Variable<IRubyObject>>();
        ConstantTableEntry[] table = this.constantTableGetTable();
        int i = table.length;
        while (--i >= 0) {
            ConstantTableEntry e = table[i];
            while (e != null) {
                list.add(e);
                e = e.next;
            }
        }
        return list;
    }

    public List<String> getStoredConstantNameList() {
        ArrayList<String> list = new ArrayList<String>();
        ConstantTableEntry[] table = this.constantTableGetTable();
        int i = table.length;
        while (--i >= 0) {
            ConstantTableEntry e = table[i];
            while (e != null) {
                list.add(e.name);
                e = e.next;
            }
        }
        return list;
    }

    protected final String validateConstant(String name) {
        if (IdUtil.isValidConstantName(name)) {
            return name;
        }
        throw this.getRuntime().newNameError("wrong constant name " + name, name);
    }

    protected final void ensureConstantsSettable() {
        if (!this.isFrozen() && (this.getRuntime().getSafeLevel() < 4 || this.isTaint())) {
            return;
        }
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError(ERR_INSECURE_SET_CONSTANT);
        }
        if (this.isFrozen()) {
            if (this instanceof RubyModule) {
                throw this.getRuntime().newFrozenError("class/module ");
            }
            throw this.getRuntime().newFrozenError("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRubyObject variableTableStore(String name, IRubyObject value) {
        int hash = name.hashCode();
        ReentrantLock lock = this.variableWriteLock;
        lock.lock();
        try {
            RubyObject.VariableTableEntry[] table = this.variableTable;
            if (this.variableTable == null) {
                RubyObject.VariableTableEntry e;
                table = new RubyObject.VariableTableEntry[8];
                table[hash & 7] = e = new RubyObject.VariableTableEntry(hash, name.intern(), value, null);
                this.variableTableThreshold = 6;
                this.variableTableSize = 1;
                this.variableTable = table;
                IRubyObject iRubyObject = value;
                return iRubyObject;
            }
            int potentialNewSize = this.variableTableSize + 1;
            if (potentialNewSize > this.variableTableThreshold) {
                table = this.variableTableRehash();
            }
            int index = hash & table.length - 1;
            RubyObject.VariableTableEntry e = table[index];
            while (e != null) {
                if (hash == e.hash && name.equals(e.name)) {
                    e.value = value;
                    IRubyObject iRubyObject = value;
                    return iRubyObject;
                }
                e = e.next;
            }
            table[index] = e = new RubyObject.VariableTableEntry(hash, name.intern(), value, table[index]);
            this.variableTableSize = potentialNewSize;
            this.variableTable = table;
        }
        finally {
            lock.unlock();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRubyObject variableTableFastStore(String internedName, IRubyObject value) {
        assert (internedName == internedName.intern()) : internedName + " not interned";
        int hash = internedName.hashCode();
        ReentrantLock lock = this.variableWriteLock;
        lock.lock();
        try {
            RubyObject.VariableTableEntry[] table = this.variableTable;
            if (this.variableTable == null) {
                RubyObject.VariableTableEntry e;
                table = new RubyObject.VariableTableEntry[8];
                table[hash & 7] = e = new RubyObject.VariableTableEntry(hash, internedName, value, null);
                this.variableTableThreshold = 6;
                this.variableTableSize = 1;
                this.variableTable = table;
                IRubyObject iRubyObject = value;
                return iRubyObject;
            }
            int potentialNewSize = this.variableTableSize + 1;
            if (potentialNewSize > this.variableTableThreshold) {
                table = this.variableTableRehash();
            }
            int index = hash & table.length - 1;
            RubyObject.VariableTableEntry e = table[index];
            while (e != null) {
                if (internedName == e.name) {
                    e.value = value;
                    IRubyObject iRubyObject = value;
                    return iRubyObject;
                }
                e = e.next;
            }
            table[index] = e = new RubyObject.VariableTableEntry(hash, internedName, value, table[index]);
            this.variableTableSize = potentialNewSize;
            this.variableTable = table;
        }
        finally {
            lock.unlock();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRubyObject variableTableRemove(String name) {
        ReentrantLock lock = this.variableWriteLock;
        lock.lock();
        try {
            RubyObject.VariableTableEntry[] table = this.variableTable;
            if (this.variableTable != null) {
                RubyObject.VariableTableEntry first;
                int hash = name.hashCode();
                int index = hash & table.length - 1;
                RubyObject.VariableTableEntry e = first = table[index];
                while (e != null) {
                    if (hash == e.hash && name.equals(e.name)) {
                        IRubyObject oldValue = e.value;
                        RubyObject.VariableTableEntry newFirst = e.next;
                        RubyObject.VariableTableEntry p = first;
                        while (p != e) {
                            newFirst = new RubyObject.VariableTableEntry(p.hash, p.name, p.value, newFirst);
                            p = p.next;
                        }
                        table[index] = newFirst;
                        --this.variableTableSize;
                        this.variableTable = table;
                        IRubyObject iRubyObject = oldValue;
                        return iRubyObject;
                    }
                    e = e.next;
                }
            }
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRubyObject variableTableReadLocked(RubyObject.VariableTableEntry entry) {
        ReentrantLock lock = this.variableWriteLock;
        lock.lock();
        try {
            IRubyObject iRubyObject = entry.value;
            return iRubyObject;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void variableTableSync(List<Variable<IRubyObject>> vars) {
        ReentrantLock lock = this.variableWriteLock;
        lock.lock();
        try {
            this.variableTableSize = 0;
            this.variableTableThreshold = 6;
            this.variableTable = new RubyObject.VariableTableEntry[8];
            for (Variable<IRubyObject> var : vars) {
                assert (!var.isConstant() && var.getValue() != null);
                this.variableTableStore(var.getName(), var.getValue());
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syncVariables(List<Variable<IRubyObject>> variables) {
        ArrayList<Variable<IRubyObject>> constants = new ArrayList<Variable<IRubyObject>>(variables.size());
        Iterator<Variable<IRubyObject>> iter = variables.iterator();
        while (iter.hasNext()) {
            Variable<IRubyObject> var = iter.next();
            if (!var.isConstant()) continue;
            constants.add(var);
            iter.remove();
        }
        ReentrantLock lock = this.variableWriteLock;
        lock.lock();
        try {
            this.variableTableSync(variables);
            this.constantTableSync(constants);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    @Deprecated
    public Map getVariableMap() {
        Map map = this.variableTableGetMap();
        this.constantTableGetMap(map);
        return map;
    }

    @Override
    public boolean hasVariables() {
        return this.variableTableGetSize() > 0 || this.constantTableGetSize() > 0;
    }

    @Override
    public int getVariableCount() {
        return this.variableTableGetSize() + this.constantTableGetSize();
    }

    @Override
    public List<Variable<IRubyObject>> getVariableList() {
        Object e;
        RubyObject.VariableTableEntry[] vtable = this.variableTableGetTable();
        ConstantTableEntry[] ctable = this.constantTableGetTable();
        ArrayList<Variable<IRubyObject>> list = new ArrayList<Variable<IRubyObject>>();
        int i = vtable.length;
        while (--i >= 0) {
            e = vtable[i];
            while (e != null) {
                IRubyObject readValue = ((RubyObject.VariableTableEntry)e).value;
                if (readValue == null) {
                    readValue = this.variableTableReadLocked((RubyObject.VariableTableEntry)e);
                }
                list.add(new VariableEntry<IRubyObject>(((RubyObject.VariableTableEntry)e).name, readValue));
                e = ((RubyObject.VariableTableEntry)e).next;
            }
        }
        i = ctable.length;
        while (--i >= 0) {
            e = ctable[i];
            while (e != null) {
                list.add((Variable<IRubyObject>)e);
                e = ((ConstantTableEntry)e).next;
            }
        }
        return list;
    }

    @Override
    public List<String> getVariableNameList() {
        Object e;
        RubyObject.VariableTableEntry[] vtable = this.variableTableGetTable();
        ConstantTableEntry[] ctable = this.constantTableGetTable();
        ArrayList<String> list = new ArrayList<String>();
        int i = vtable.length;
        while (--i >= 0) {
            e = vtable[i];
            while (e != null) {
                list.add(((RubyObject.VariableTableEntry)e).name);
                e = ((RubyObject.VariableTableEntry)e).next;
            }
        }
        i = ctable.length;
        while (--i >= 0) {
            e = ctable[i];
            while (e != null) {
                list.add(((ConstantTableEntry)e).name);
                e = ((ConstantTableEntry)e).next;
            }
        }
        return list;
    }

    protected boolean constantTableContains(String name) {
        int hash = name.hashCode();
        ConstantTableEntry[] table = this.constantTable;
        ConstantTableEntry e = this.constantTable[hash & table.length - 1];
        while (e != null) {
            if (hash == e.hash && name.equals(e.name)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    protected boolean constantTableFastContains(String internedName) {
        ConstantTableEntry[] table = this.constantTable;
        ConstantTableEntry e = this.constantTable[internedName.hashCode() & table.length - 1];
        while (e != null) {
            if (internedName == e.name) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    protected IRubyObject constantTableFetch(String name) {
        int hash = name.hashCode();
        ConstantTableEntry[] table = this.constantTable;
        ConstantTableEntry e = this.constantTable[hash & table.length - 1];
        while (e != null) {
            if (hash == e.hash && name.equals(e.name)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected IRubyObject constantTableFastFetch(String internedName) {
        ConstantTableEntry[] table = this.constantTable;
        ConstantTableEntry e = this.constantTable[internedName.hashCode() & table.length - 1];
        while (e != null) {
            if (internedName == e.name) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject constantTableStore(String name, IRubyObject value) {
        int hash = name.hashCode();
        ReentrantLock lock = this.variableWriteLock;
        lock.lock();
        try {
            ConstantTableEntry first;
            int potentialNewSize = this.constantTableSize + 1;
            ConstantTableEntry[] table = potentialNewSize > this.constantTableThreshold ? this.constantTableRehash() : this.constantTable;
            int index = hash & table.length - 1;
            ConstantTableEntry e = first = table[index];
            while (e != null) {
                if (hash == e.hash && name.equals(e.name)) {
                    if (value == e.value) {
                        IRubyObject iRubyObject = value;
                        return iRubyObject;
                    }
                    ConstantTableEntry newFirst = new ConstantTableEntry(e.hash, e.name, value, e.next);
                    ConstantTableEntry n = first;
                    while (n != e) {
                        newFirst = new ConstantTableEntry(n.hash, n.name, n.value, newFirst);
                        n = n.next;
                    }
                    table[index] = newFirst;
                    this.constantTable = table;
                    IRubyObject iRubyObject = value;
                    return iRubyObject;
                }
                e = e.next;
            }
            table[index] = new ConstantTableEntry(hash, name.intern(), value, table[index]);
            this.constantTableSize = potentialNewSize;
            this.constantTable = table;
        }
        finally {
            lock.unlock();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject constantTableFastStore(String internedName, IRubyObject value) {
        assert (internedName == internedName.intern()) : internedName + " not interned";
        int hash = internedName.hashCode();
        ReentrantLock lock = this.variableWriteLock;
        lock.lock();
        try {
            ConstantTableEntry first;
            int potentialNewSize = this.constantTableSize + 1;
            ConstantTableEntry[] table = potentialNewSize > this.constantTableThreshold ? this.constantTableRehash() : this.constantTable;
            int index = hash & table.length - 1;
            ConstantTableEntry e = first = table[index];
            while (e != null) {
                if (internedName == e.name) {
                    if (value == e.value) {
                        IRubyObject iRubyObject = value;
                        return iRubyObject;
                    }
                    ConstantTableEntry newFirst = new ConstantTableEntry(e.hash, e.name, value, e.next);
                    ConstantTableEntry n = first;
                    while (n != e) {
                        newFirst = new ConstantTableEntry(n.hash, n.name, n.value, newFirst);
                        n = n.next;
                    }
                    table[index] = newFirst;
                    this.constantTable = table;
                    IRubyObject iRubyObject = value;
                    return iRubyObject;
                }
                e = e.next;
            }
            table[index] = new ConstantTableEntry(hash, internedName, value, table[index]);
            this.constantTableSize = potentialNewSize;
            this.constantTable = table;
        }
        finally {
            lock.unlock();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject constantTableRemove(String name) {
        ReentrantLock lock = this.variableWriteLock;
        lock.lock();
        try {
            ConstantTableEntry[] table = this.constantTable;
            if (this.constantTable != null) {
                ConstantTableEntry first;
                int hash = name.hashCode();
                int index = hash & table.length - 1;
                ConstantTableEntry e = first = table[index];
                while (e != null) {
                    if (hash == e.hash && name.equals(e.name)) {
                        IRubyObject oldValue = e.value;
                        ConstantTableEntry newFirst = e.next;
                        ConstantTableEntry p = first;
                        while (p != e) {
                            newFirst = new ConstantTableEntry(p.hash, p.name, p.value, newFirst);
                            p = p.next;
                        }
                        table[index] = newFirst;
                        --this.constantTableSize;
                        this.constantTable = table;
                        IRubyObject iRubyObject = oldValue;
                        return iRubyObject;
                    }
                    e = e.next;
                }
            }
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    protected ConstantTableEntry[] constantTableGetTable() {
        return this.constantTable;
    }

    protected int constantTableGetSize() {
        if (this.constantTable != null) {
            return this.constantTableSize;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void constantTableSync(List<Variable<IRubyObject>> vars) {
        ReentrantLock lock = this.variableWriteLock;
        lock.lock();
        try {
            this.constantTableSize = 0;
            this.constantTableThreshold = 6;
            this.constantTable = new ConstantTableEntry[8];
            for (Variable<IRubyObject> var : vars) {
                assert (var.isConstant() && var.getValue() != null);
                this.constantTableStore(var.getName(), var.getValue());
            }
        }
        finally {
            lock.unlock();
        }
    }

    private final ConstantTableEntry[] constantTableRehash() {
        ConstantTableEntry[] oldTable = this.constantTable;
        int oldCapacity = oldTable.length;
        if (oldCapacity >= 0x40000000) {
            return oldTable;
        }
        int newCapacity = oldCapacity << 1;
        ConstantTableEntry[] newTable = new ConstantTableEntry[newCapacity];
        this.constantTableThreshold = (int)((float)newCapacity * 0.75f);
        int sizeMask = newCapacity - 1;
        int i = oldCapacity;
        while (--i >= 0) {
            int k;
            ConstantTableEntry e = oldTable[i];
            if (e == null) continue;
            ConstantTableEntry next = e.next;
            int idx = e.hash & sizeMask;
            if (next == null) {
                newTable[idx] = e;
                continue;
            }
            ConstantTableEntry lastRun = e;
            int lastIdx = idx;
            ConstantTableEntry last = next;
            while (last != null) {
                k = last.hash & sizeMask;
                if (k != lastIdx) {
                    lastIdx = k;
                    lastRun = last;
                }
                last = last.next;
            }
            newTable[lastIdx] = lastRun;
            ConstantTableEntry p = e;
            while (p != lastRun) {
                ConstantTableEntry m;
                k = p.hash & sizeMask;
                newTable[k] = m = new ConstantTableEntry(p.hash, p.name, p.value, newTable[k]);
                p = p.next;
            }
        }
        this.constantTable = newTable;
        return newTable;
    }

    protected Map constantTableGetMap() {
        HashMap<String, IRubyObject> map = new HashMap<String, IRubyObject>();
        ConstantTableEntry[] table = this.constantTable;
        if (this.constantTable != null) {
            int i = table.length;
            while (--i >= 0) {
                ConstantTableEntry e = table[i];
                while (e != null) {
                    map.put(e.name, e.value);
                    e = e.next;
                }
            }
        }
        return map;
    }

    protected Map constantTableGetMap(Map map) {
        ConstantTableEntry[] table = this.constantTable;
        if (this.constantTable != null) {
            int i = table.length;
            while (--i >= 0) {
                ConstantTableEntry e = table[i];
                while (e != null) {
                    map.put(e.name, e.value);
                    e = e.next;
                }
            }
        }
        return map;
    }

    protected static final class ConstantTableEntry
    implements Variable<IRubyObject> {
        final int hash;
        final String name;
        final IRubyObject value;
        final ConstantTableEntry next;

        ConstantTableEntry(int hash, String name, IRubyObject value, ConstantTableEntry next) {
            this.hash = hash;
            this.name = name;
            this.value = value;
            this.next = next;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public IRubyObject getValue() {
            return this.value;
        }

        @Override
        public final boolean isClassVariable() {
            return false;
        }

        @Override
        public final boolean isConstant() {
            return true;
        }

        @Override
        public final boolean isInstanceVariable() {
            return false;
        }

        @Override
        public final boolean isRubyVariable() {
            return true;
        }
    }

    public static class KindOf {
        public static final KindOf DEFAULT_KIND_OF = new KindOf();

        public boolean isKindOf(IRubyObject obj, RubyModule type) {
            return obj.getMetaClass().hasModuleInHierarchy(type);
        }
    }
}

