/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubyUnboundMethod;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodBlock;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyMethod
extends RubyObject {
    protected RubyModule implementationModule;
    protected String methodName;
    protected RubyModule originModule;
    protected String originName;
    protected DynamicMethod method;
    protected IRubyObject receiver;

    protected RubyMethod(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    public static RubyClass createMethodClass(Ruby runtime) {
        RubyClass methodClass = runtime.defineClass("Method", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setMethod(methodClass);
        methodClass.defineAnnotatedMethods(RubyMethod.class);
        return methodClass;
    }

    public static RubyMethod newMethod(RubyModule implementationModule, String methodName, RubyModule originModule, String originName, DynamicMethod method, IRubyObject receiver) {
        Ruby runtime = implementationModule.getRuntime();
        RubyMethod newMethod = new RubyMethod(runtime, runtime.getMethod());
        newMethod.implementationModule = implementationModule;
        newMethod.methodName = methodName;
        newMethod.originModule = originModule;
        newMethod.originName = originName;
        newMethod.method = method.getRealMethod();
        newMethod.receiver = receiver;
        return newMethod;
    }

    @JRubyMethod(name={"call", "[]"}, rest=true, frame=true)
    public IRubyObject call(IRubyObject[] args, Block block) {
        assert (args != null);
        ThreadContext tc = this.getRuntime().getCurrentContext();
        this.method.getArity().checkArity(this.getRuntime(), args);
        return this.method.call(tc, this.receiver, this.implementationModule, this.methodName, args, block);
    }

    @JRubyMethod(name={"arity"})
    public RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.method.getArity().getValue());
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public RubyBoolean op_equal(IRubyObject other) {
        if (!(other instanceof RubyMethod)) {
            return this.getRuntime().getFalse();
        }
        RubyMethod otherMethod = (RubyMethod)other;
        return this.getRuntime().newBoolean(this.method.getRealMethod() == otherMethod.method.getRealMethod() && this.receiver == otherMethod.receiver);
    }

    @Override
    @JRubyMethod(name={"clone"})
    public RubyMethod rbClone() {
        return RubyMethod.newMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.method, this.receiver);
    }

    @JRubyMethod(name={"to_proc"}, frame=true)
    public IRubyObject to_proc(Block unusedBlock) {
        CallbackFactory f = this.getRuntime().callbackFactory(RubyMethod.class);
        Ruby r = this.getRuntime();
        ThreadContext tc = r.getCurrentContext();
        Block block = MethodBlock.createMethodBlock(tc, tc.getCurrentScope().cloneScope(), f.getBlockMethod("bmcall"), this, r.getTopSelf());
        while (true) {
            try {
                return f.getSingletonMethod("mproc").execute(this.getRuntime().getNil(), IRubyObject.NULL_ARRAY, block);
            }
            catch (JumpException.BreakJump bj) {
                return (IRubyObject)bj.getValue();
            }
            catch (JumpException.ReturnJump rj) {
                return (IRubyObject)rj.getValue();
            }
            catch (JumpException.RetryJump retryJump) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject mproc(IRubyObject recv, Block block) {
        Ruby runtime = recv.getRuntime();
        ThreadContext tc = runtime.getCurrentContext();
        tc.preMproc();
        try {
            RubyProc rubyProc = RubyKernel.proc(recv, block);
            return rubyProc;
        }
        finally {
            tc.postMproc();
        }
    }

    public static IRubyObject bmcall(IRubyObject blockArg, IRubyObject arg1, IRubyObject self, Block unusedBlock) {
        if (blockArg instanceof RubyArray) {
            return ((RubyMethod)arg1).call(((RubyArray)blockArg).toJavaArray(), Block.NULL_BLOCK);
        }
        return ((RubyMethod)arg1).call(new IRubyObject[]{blockArg}, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"unbind"}, frame=true)
    public RubyUnboundMethod unbind(Block unusedBlock) {
        RubyUnboundMethod unboundMethod = RubyUnboundMethod.newUnboundMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.method);
        unboundMethod.infectBy(this);
        return unboundMethod;
    }

    @Override
    @JRubyMethod(name={"inspect", "to_s"})
    public IRubyObject inspect() {
        StringBuilder buf = new StringBuilder("#<");
        int delimeter = 35;
        buf.append(this.getMetaClass().getRealClass().getName()).append(": ");
        if (this.originModule.isSingleton()) {
            IRubyObject attached = ((MetaClass)this.originModule).getAttached();
            if (this.receiver == this.getRuntime().getNil()) {
                buf.append(this.implementationModule.getName());
            } else if (this.receiver == attached) {
                buf.append(attached.inspect().toString());
                delimeter = 46;
            } else {
                buf.append(this.receiver.inspect().toString());
                buf.append('(').append(attached.inspect().toString()).append(')');
                delimeter = 46;
            }
        } else {
            buf.append(this.originModule.getName());
            if (this.implementationModule != this.originModule) {
                buf.append('(').append(this.implementationModule.getName()).append(')');
            }
        }
        buf.append((char)delimeter).append(this.methodName).append('>');
        RubyString str = this.getRuntime().newString(buf.toString());
        str.setTaint(this.isTaint());
        return str;
    }
}

