/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.channels.Channel;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.HashSet;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProcess;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.IOHandler;
import org.jruby.util.IOHandlerJavaIO;
import org.jruby.util.IOHandlerNio;
import org.jruby.util.IOHandlerNull;
import org.jruby.util.IOHandlerProcess;
import org.jruby.util.IOHandlerSeekable;
import org.jruby.util.IOHandlerUnseekable;
import org.jruby.util.IOModes;
import org.jruby.util.ShellLauncher;

public class RubyIO
extends RubyObject {
    public static final int STDIN = 0;
    public static final int STDOUT = 1;
    public static final int STDERR = 2;
    protected IOHandler handler;
    protected IOModes modes = null;
    protected int lineNumber = 0;
    protected boolean isOpen = true;
    private boolean atEOF = false;
    protected static int fileno = 2;
    private static ObjectAllocator IO_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyIO(runtime, klass);
        }
    };

    public void registerIOHandler(IOHandler newHandler) {
        this.getRuntime().getIoHandlers().put(new Integer(newHandler.getFileno()), new WeakReference<IOHandler>(newHandler));
    }

    public void unregisterIOHandler(int aFileno) {
        this.getRuntime().getIoHandlers().remove(new Integer(aFileno));
    }

    public IOHandler getIOHandlerByFileno(int aFileno) {
        Reference reference = this.getRuntime().getIoHandlers().get(new Integer(aFileno));
        if (reference == null) {
            return null;
        }
        return (IOHandler)reference.get();
    }

    public static int getNewFileno() {
        return ++fileno;
    }

    public RubyIO(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    public RubyIO(Ruby runtime, OutputStream outputStream) {
        super(runtime, runtime.getIO());
        if (outputStream == null) {
            throw runtime.newIOError("Opening invalid stream");
        }
        try {
            this.handler = new IOHandlerUnseekable(runtime, null, outputStream);
        }
        catch (IOException e) {
            throw runtime.newIOError(e.getMessage());
        }
        this.modes = this.handler.getModes();
        this.registerIOHandler(this.handler);
    }

    public RubyIO(Ruby runtime, InputStream inputStream) {
        super(runtime, runtime.getIO());
        if (inputStream == null) {
            throw runtime.newIOError("Opening invalid stream");
        }
        try {
            this.handler = new IOHandlerUnseekable(runtime, inputStream, null);
        }
        catch (IOException e) {
            throw runtime.newIOError(e.getMessage());
        }
        this.modes = this.handler.getModes();
        this.registerIOHandler(this.handler);
    }

    public RubyIO(Ruby runtime, Channel channel) {
        super(runtime, runtime.getIO());
        if (channel == null) {
            throw runtime.newIOError("Opening invalid stream");
        }
        try {
            this.handler = new IOHandlerNio(runtime, channel);
        }
        catch (IOException e) {
            throw runtime.newIOError(e.getMessage());
        }
        this.modes = this.handler.getModes();
        this.registerIOHandler(this.handler);
    }

    public RubyIO(Ruby runtime, Process process) {
        super(runtime, runtime.getIO());
        this.modes = new IOModes(runtime, "w+");
        try {
            this.handler = new IOHandlerProcess(runtime, process, this.modes);
        }
        catch (IOException e) {
            throw runtime.newIOError(e.getMessage());
        }
        this.modes = this.handler.getModes();
        this.registerIOHandler(this.handler);
    }

    public RubyIO(Ruby runtime, int descriptor) {
        super(runtime, runtime.getIO());
        try {
            this.handler = new IOHandlerUnseekable(runtime, descriptor);
        }
        catch (IOHandler.BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        this.modes = this.handler.getModes();
        this.registerIOHandler(this.handler);
    }

    public static RubyClass createIOClass(Ruby runtime) {
        RubyClass ioClass = runtime.defineClass("IO", runtime.getObject(), IO_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyIO.class);
        ioClass.kindOf = new RubyModule.KindOf(){

            @Override
            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyIO;
            }
        };
        ioClass.includeModule(runtime.getEnumerable());
        ioClass.defineAnnotatedMethods(RubyIO.class);
        ioClass.fastSetConstant("SEEK_SET", runtime.newFixnum(0L));
        ioClass.fastSetConstant("SEEK_CUR", runtime.newFixnum(1L));
        ioClass.fastSetConstant("SEEK_END", runtime.newFixnum(2L));
        ioClass.dispatcher = callbackFactory.createDispatcher(ioClass);
        return ioClass;
    }

    public static IRubyObject fdOpen(Ruby runtime, int descriptor) {
        return new RubyIO(runtime, descriptor);
    }

    protected void checkWriteable() {
        if (!this.isOpen() || !this.modes.isWritable()) {
            throw this.getRuntime().newIOError("not opened for writing");
        }
    }

    protected void checkReadable() {
        if (!this.isOpen() || !this.modes.isReadable()) {
            throw this.getRuntime().newIOError("not opened for reading");
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public OutputStream getOutStream() {
        if (this.handler instanceof IOHandlerJavaIO) {
            return ((IOHandlerJavaIO)this.handler).getOutputStream();
        }
        return null;
    }

    public InputStream getInStream() {
        if (this.handler instanceof IOHandlerJavaIO) {
            return ((IOHandlerJavaIO)this.handler).getInputStream();
        }
        return null;
    }

    public Channel getChannel() {
        if (this.handler instanceof IOHandlerNio) {
            return ((IOHandlerNio)this.handler).getChannel();
        }
        return null;
    }

    @JRubyMethod(name={"reopen"}, required=1, optional=1)
    public IRubyObject reopen(IRubyObject[] args) {
        if (args.length < 1) {
            throw this.getRuntime().newArgumentError("wrong number of arguments");
        }
        if (this.getRuntime().getIO().isInstance(args[0])) {
            RubyIO ios = (RubyIO)args[0];
            int keepFileno = this.handler.getFileno();
            if (this.handler.isOpen()) {
                try {
                    this.handler.close();
                }
                catch (IOHandler.BadDescriptorException e) {
                    throw this.getRuntime().newErrnoEBADFError();
                }
                catch (EOFException e) {
                    return this.getRuntime().getNil();
                }
                catch (IOException e) {
                    throw this.getRuntime().newIOError(e.getMessage());
                }
            }
            try {
                this.handler = ios.handler.cloneIOHandler();
            }
            catch (IOHandler.InvalidValueException e) {
                throw this.getRuntime().newErrnoEINVALError();
            }
            catch (IOHandler.PipeException e) {
                throw this.getRuntime().newErrnoESPIPEError();
            }
            catch (FileNotFoundException e) {
                throw this.getRuntime().newErrnoENOENTError();
            }
            catch (IOException e) {
                throw this.getRuntime().newIOError(e.getMessage());
            }
            this.handler.setFileno(keepFileno);
            this.registerIOHandler(this.handler);
        } else if (this.getRuntime().getString().isInstance(args[0])) {
            String path = ((RubyString)args[0]).toString();
            IOModes newModes = null;
            if (args.length > 1) {
                if (!this.getRuntime().getString().isInstance(args[1])) {
                    throw this.getRuntime().newTypeError(args[1], this.getRuntime().getString());
                }
                newModes = new IOModes(this.getRuntime(), ((RubyString)args[1]).toString());
            }
            try {
                if (this.handler != null && this.handler.isOpen()) {
                    this.close();
                }
                if (newModes != null) {
                    this.modes = newModes;
                }
                this.handler = "/dev/null".equals(path) ? new IOHandlerNull(this.getRuntime(), this.modes) : new IOHandlerSeekable(this.getRuntime(), path, this.modes);
                this.registerIOHandler(this.handler);
            }
            catch (IOHandler.InvalidValueException e) {
                throw this.getRuntime().newErrnoEINVALError();
            }
            catch (IOException e) {
                throw this.getRuntime().newIOError(e.toString());
            }
        }
        this.isOpen = true;
        return this;
    }

    private ByteList getSeparatorForGets(IRubyObject[] args) {
        ByteList separator;
        IRubyObject sepVal = args.length > 0 ? args[0] : this.getRuntime().getRecordSeparatorVar().get();
        ByteList byteList = separator = sepVal.isNil() ? null : ((RubyString)sepVal).getByteList();
        if (separator != null && separator.realSize == 0) {
            separator = IOHandler.PARAGRAPH_DELIMETER;
        }
        return separator;
    }

    public IRubyObject internalGets(IRubyObject[] args) {
        return this.internalGets(this.getSeparatorForGets(args));
    }

    public IRubyObject internalGets(ByteList separator) {
        this.checkReadable();
        try {
            ByteList newLine = this.handler.gets(separator);
            if (newLine != null) {
                ++this.lineNumber;
                this.getRuntime().getGlobalVariables().set("$.", this.getRuntime().newFixnum(this.lineNumber));
                RubyString result = RubyString.newString(this.getRuntime(), newLine);
                result.taint();
                return result;
            }
            return this.getRuntime().getNil();
        }
        catch (EOFException e) {
            return this.getRuntime().getNil();
        }
        catch (IOHandler.BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
    }

    @JRubyMethod(name={"initialize"}, required=1, optional=1, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args, Block unusedBlock) {
        IOHandler existingIOHandler;
        int count = Arity.checkArgumentCount(this.getRuntime(), args, 1, 2);
        int newFileno = RubyNumeric.fix2int(args[0]);
        String mode = null;
        if (count > 1) {
            mode = args[1].convertToString().toString();
        }
        if ((existingIOHandler = this.getIOHandlerByFileno(newFileno)) == null) {
            if (mode == null) {
                mode = "r";
            }
            try {
                this.handler = new IOHandlerUnseekable(this.getRuntime(), newFileno, mode);
            }
            catch (IOHandler.BadDescriptorException e) {
                throw this.getRuntime().newErrnoEBADFError();
            }
            this.modes = new IOModes(this.getRuntime(), mode);
            this.registerIOHandler(this.handler);
        } else {
            this.handler = existingIOHandler;
            this.modes = mode == null ? this.handler.getModes() : new IOModes(this.getRuntime(), mode);
            try {
                this.handler.reset(this.modes);
            }
            catch (IOHandler.InvalidValueException e) {
                throw this.getRuntime().newErrnoEINVALError();
            }
            catch (IOException e) {
                throw this.getRuntime().newIOError(e.getMessage());
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"open"}, required=1, optional=1, frame=true, meta=true)
    public static IRubyObject open(IRubyObject recv, IRubyObject[] args, Block block) {
        Ruby runtime = recv.getRuntime();
        RubyIO io = new RubyIO(runtime, (RubyClass)recv);
        io.initialize(args, block);
        if (block.isGiven()) {
            try {
                IRubyObject iRubyObject = block.yield(runtime.getCurrentContext(), io);
                return iRubyObject;
            }
            finally {
                io.close();
            }
        }
        return io;
    }

    @JRubyMethod(name={"binmode"})
    public IRubyObject binmode() {
        return this;
    }

    @JRubyMethod(name={"syswrite"}, required=1)
    public IRubyObject syswrite(IRubyObject obj) {
        try {
            if (obj instanceof RubyString) {
                return this.getRuntime().newFixnum(this.handler.syswrite(((RubyString)obj).getByteList()));
            }
            return this.getRuntime().newFixnum(this.handler.syswrite(((RubyString)obj.callMethod(obj.getRuntime().getCurrentContext(), MethodIndex.TO_S, "to_s")).getByteList()));
        }
        catch (IOHandler.BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newSystemCallError(e.getMessage());
        }
    }

    @JRubyMethod(name={"write"}, required=1)
    public IRubyObject write(IRubyObject obj) {
        this.checkWriteable();
        try {
            if (obj instanceof RubyString) {
                return this.getRuntime().newFixnum(this.handler.write(((RubyString)obj).getByteList()));
            }
            return this.getRuntime().newFixnum(this.handler.write(((RubyString)obj.callMethod(obj.getRuntime().getCurrentContext(), MethodIndex.TO_S, "to_s")).getByteList()));
        }
        catch (IOHandler.BadDescriptorException e) {
            return RubyFixnum.zero(this.getRuntime());
        }
        catch (IOException e) {
            String message = e.getMessage();
            if (message != null) {
                if (message.equals("Broken pipe")) {
                    throw this.getRuntime().newErrnoEPIPEError();
                }
                if (message.equals("not opened for writing")) {
                    throw this.getRuntime().newIOError(message);
                }
            }
            if (this.getRuntime().getDebug().isTrue()) {
                this.getRuntime().getWarnings().warn("swallowed IO exception: " + e.toString());
                e.printStackTrace();
            }
            return RubyFixnum.zero(this.getRuntime());
        }
    }

    @JRubyMethod(name={"<<"}, required=1)
    public IRubyObject op_concat(IRubyObject anObject) {
        IRubyObject strObject = anObject.callMethod(this.getRuntime().getCurrentContext(), MethodIndex.TO_S, "to_s");
        this.write(strObject);
        return this;
    }

    @JRubyMethod(name={"fileno"}, alias={"to_i"})
    public RubyFixnum fileno() {
        return this.getRuntime().newFixnum(this.handler.getFileno());
    }

    @JRubyMethod(name={"lineno"})
    public RubyFixnum lineno() {
        return this.getRuntime().newFixnum(this.lineNumber);
    }

    @JRubyMethod(name={"lineno="}, required=1)
    public RubyFixnum lineno_set(IRubyObject newLineNumber) {
        this.lineNumber = RubyNumeric.fix2int(newLineNumber);
        return (RubyFixnum)newLineNumber;
    }

    @JRubyMethod(name={"sync"})
    public RubyBoolean sync() {
        return this.getRuntime().newBoolean(this.handler.isSync());
    }

    @JRubyMethod(name={"pid"})
    public IRubyObject pid() {
        int pid = this.handler.pid();
        return pid == -1 ? this.getRuntime().getNil() : this.getRuntime().newFixnum(pid);
    }

    public boolean hasPendingBuffered() {
        return this.handler.hasPendingBuffered();
    }

    @JRubyMethod(name={"pos", "tell"})
    public RubyFixnum pos() {
        try {
            return this.getRuntime().newFixnum(this.handler.pos());
        }
        catch (IOHandler.PipeException e) {
            throw this.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
    }

    @JRubyMethod(name={"pos="}, required=1)
    public RubyFixnum pos_set(IRubyObject newPosition) {
        long offset = RubyNumeric.fix2long(newPosition);
        if (offset < 0L) {
            throw this.getRuntime().newSystemCallError("Negative seek offset");
        }
        try {
            this.handler.seek(offset, 0);
        }
        catch (IOHandler.InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (IOHandler.PipeException e) {
            throw this.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        return (RubyFixnum)newPosition;
    }

    @JRubyMethod(name={"print"}, rest=true)
    public IRubyObject print(IRubyObject[] args) {
        if (args.length == 0) {
            args = new IRubyObject[]{this.getRuntime().getCurrentContext().getCurrentFrame().getLastLine()};
        }
        IRubyObject fs = this.getRuntime().getGlobalVariables().get("$,");
        IRubyObject rs = this.getRuntime().getGlobalVariables().get("$\\");
        ThreadContext context = this.getRuntime().getCurrentContext();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0 && !fs.isNil()) {
                this.callMethod(context, "write", fs);
            }
            if (args[i].isNil()) {
                this.callMethod(context, "write", this.getRuntime().newString("nil"));
                continue;
            }
            this.callMethod(context, "write", args[i]);
        }
        if (!rs.isNil()) {
            this.callMethod(context, "write", rs);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"printf"}, required=1, rest=true)
    public IRubyObject printf(IRubyObject[] args) {
        Arity.checkArgumentCount(this.getRuntime(), args, 1, -1);
        this.callMethod(this.getRuntime().getCurrentContext(), "write", RubyKernel.sprintf(this, args));
        return this.getRuntime().getNil();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(name={"putc"}, required=1)
    public IRubyObject putc(IRubyObject object) {
        int c;
        if (this.getRuntime().getString().isInstance(object)) {
            String value = ((RubyString)object).toString();
            if (value.length() <= 0) throw this.getRuntime().newTypeError("Cannot convert String to Integer");
            c = value.charAt(0);
        } else {
            c = this.getRuntime().getFixnum().isInstance(object) ? RubyNumeric.fix2int(object) : RubyNumeric.fix2int(object.callMethod(this.getRuntime().getCurrentContext(), MethodIndex.TO_I, "to_i"));
        }
        try {
            this.handler.putc(c);
            return object;
        }
        catch (IOHandler.BadDescriptorException e) {
            return RubyFixnum.zero(this.getRuntime());
        }
        catch (IOException e) {
            return RubyFixnum.zero(this.getRuntime());
        }
    }

    @JRubyMethod(name={"seek"}, required=1, optional=1)
    public RubyFixnum seek(IRubyObject[] args) {
        if (args.length == 0) {
            throw this.getRuntime().newArgumentError("wrong number of arguments");
        }
        long offset = RubyNumeric.fix2long(args[0]);
        int type = 0;
        if (args.length > 1) {
            type = RubyNumeric.fix2int(args[1].convertToInteger());
        }
        try {
            this.handler.seek(offset, type);
        }
        catch (IOHandler.InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (IOHandler.PipeException e) {
            throw this.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"rewind"})
    public RubyFixnum rewind() {
        try {
            this.handler.rewind();
        }
        catch (IOHandler.InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (IOHandler.PipeException e) {
            throw this.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        this.lineNumber = 0;
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"fsync"})
    public RubyFixnum fsync() {
        this.checkWriteable();
        try {
            this.handler.sync();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        catch (IOHandler.BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"sync="}, required=1)
    public IRubyObject sync_set(IRubyObject newSync) {
        this.handler.setIsSync(newSync.isTrue());
        return this;
    }

    @JRubyMethod(name={"eof?", "eof"})
    public RubyBoolean eof_p() {
        try {
            boolean isEOF = this.handler.isEOF();
            return isEOF ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }
        catch (IOHandler.BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
    }

    @JRubyMethod(name={"tty?", "isatty?"})
    public RubyBoolean tty_p() {
        int fileno = this.handler.getFileno();
        if (fileno == 1 || fileno == 0 || fileno == 2) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject original) {
        if (this == original) {
            return this;
        }
        RubyIO originalIO = (RubyIO)original;
        this.handler = originalIO.handler;
        this.modes = (IOModes)originalIO.modes.clone();
        return this;
    }

    @JRubyMethod(name={"closed?"})
    public RubyBoolean closed_p() {
        return this.isOpen() ? this.getRuntime().getFalse() : this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() {
        this.isOpen = false;
        try {
            this.handler.close();
        }
        catch (IOHandler.BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        this.unregisterIOHandler(this.handler.getFileno());
        return this;
    }

    @JRubyMethod(name={"close_write"})
    public IRubyObject close_write() {
        if (this.handler instanceof IOHandlerProcess) {
            IOHandlerProcess processHandler = (IOHandlerProcess)this.handler;
            try {
                processHandler.getOutputStream().close();
            }
            catch (IOException e) {
                throw this.getRuntime().newIOError(e.getMessage());
            }
        }
        return this;
    }

    @JRubyMethod(name={"flush"})
    public RubyIO flush() {
        try {
            this.handler.flush();
        }
        catch (IOHandler.BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        return this;
    }

    @JRubyMethod(name={"gets"}, optional=1)
    public IRubyObject gets(IRubyObject[] args) {
        IRubyObject result = this.internalGets(args);
        if (!result.isNil()) {
            this.getRuntime().getCurrentContext().getCurrentFrame().setLastLine(result);
        }
        return result;
    }

    public boolean getBlocking() {
        if (!(this.handler instanceof IOHandlerNio)) {
            return true;
        }
        return ((IOHandlerNio)this.handler).getBlocking();
    }

    @JRubyMethod(name={"fcntl"}, required=2)
    public IRubyObject fcntl(IRubyObject cmd, IRubyObject arg) throws IOException {
        long realCmd = cmd.convertToInteger().getLongValue();
        if (!(arg instanceof RubyNumeric)) {
            return this.getRuntime().newFixnum(0L);
        }
        long realArg = ((RubyNumeric)arg).getLongValue();
        if (realCmd == 1L) {
            boolean block = true;
            if ((realArg & 0x800L) == 2048L) {
                block = false;
            }
            if (!(this.handler instanceof IOHandlerNio)) {
                throw this.getRuntime().newNotImplementedError("FCNTL only works with Nio based handlers");
            }
            try {
                ((IOHandlerNio)this.handler).setBlocking(block);
            }
            catch (IOException e) {
                throw this.getRuntime().newIOError(e.getMessage());
            }
        }
        return this.getRuntime().newFixnum(0L);
    }

    @JRubyMethod(name={"puts"}, rest=true)
    public IRubyObject puts(IRubyObject[] args) {
        Arity.checkArgumentCount(this.getRuntime(), args, 0, -1);
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (args.length == 0) {
            this.callMethod(context, "write", this.getRuntime().newString("\n"));
            return this.getRuntime().getNil();
        }
        for (int i = 0; i < args.length; ++i) {
            String line;
            if (args[i].isNil()) {
                line = "nil";
            } else if (this.getRuntime().isInspecting(args[i])) {
                line = "[...]";
            } else {
                if (args[i] instanceof RubyArray) {
                    this.inspectPuts((RubyArray)args[i]);
                    continue;
                }
                line = args[i].toString();
            }
            this.callMethod(context, "write", this.getRuntime().newString(line));
            if (line.endsWith("\n")) continue;
            this.callMethod(context, "write", this.getRuntime().newString("\n"));
        }
        return this.getRuntime().getNil();
    }

    private IRubyObject inspectPuts(RubyArray array) {
        try {
            this.getRuntime().registerInspecting(array);
            IRubyObject iRubyObject = this.puts(array.toJavaArray());
            return iRubyObject;
        }
        finally {
            this.getRuntime().unregisterInspecting(array);
        }
    }

    @JRubyMethod(name={"readline"}, optional=1)
    public IRubyObject readline(IRubyObject[] args) {
        IRubyObject line = this.gets(args);
        if (line.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return line;
    }

    @JRubyMethod(name={"getc"})
    public IRubyObject getc() {
        this.checkReadable();
        try {
            int c = this.handler.getc();
            return c == -1 ? this.getRuntime().getNil() : this.getRuntime().newFixnum(c);
        }
        catch (IOHandler.BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
    }

    @JRubyMethod(name={"ungetc"}, required=1)
    public IRubyObject ungetc(IRubyObject number) {
        this.handler.ungetc(RubyNumeric.fix2int(number));
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"readpartial"}, required=1, optional=1)
    public IRubyObject readpartial(IRubyObject[] args) {
        if (!(this.handler instanceof IOHandlerNio)) {
            throw this.getRuntime().newNotImplementedError("readpartial only works with Nio based handlers");
        }
        try {
            ByteList buf = ((IOHandlerNio)this.handler).readpartial(RubyNumeric.fix2int(args[0]));
            RubyString strbuf = RubyString.newString(this.getRuntime(), buf == null ? new ByteList(ByteList.NULL_ARRAY) : buf);
            if (args.length > 1) {
                args[1].callMethod(this.getRuntime().getCurrentContext(), MethodIndex.OP_LSHIFT, "<<", strbuf);
                return args[1];
            }
            return strbuf;
        }
        catch (IOHandler.BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            return this.getRuntime().getNil();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
    }

    @JRubyMethod(name={"sysread"}, required=1, optional=1)
    public IRubyObject sysread(IRubyObject[] args) {
        Arity.checkArgumentCount(this.getRuntime(), args, 1, 2);
        int len = (int)RubyNumeric.num2long(args[0]);
        if (len < 0) {
            throw this.getRuntime().newArgumentError("Negative size");
        }
        try {
            RubyString str;
            if (args.length == 1 || args[1].isNil()) {
                if (len == 0) {
                    return RubyString.newString(this.getRuntime(), "");
                }
                str = RubyString.newString(this.getRuntime(), this.handler.sysread(len));
            } else {
                str = args[1].convertToString();
                if (len == 0) {
                    str.setValue(new ByteList());
                    return str;
                }
                str.setValue(this.handler.sysread(len));
            }
            str.setTaint(true);
            return str;
        }
        catch (IOHandler.BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException e) {
            if ("File not open".equals(e.getMessage())) {
                throw this.getRuntime().newIOError(e.getMessage());
            }
            throw this.getRuntime().newSystemCallError(e.getMessage());
        }
    }

    @JRubyMethod(name={"read"}, rest=true)
    public IRubyObject read(IRubyObject[] args) {
        int argCount = Arity.checkArgumentCount(this.getRuntime(), args, 0, 2);
        RubyString callerBuffer = null;
        boolean readEntireStream = argCount == 0 || args[0].isNil();
        try {
            ByteList buf;
            if (this.atEOF && this.handler.isEOF()) {
                throw new EOFException();
            }
            if (argCount == 2) {
                RubyString rubyString = callerBuffer = !args[1].isNil() ? args[1].convertToString() : this.getRuntime().newString();
            }
            if (readEntireStream) {
                buf = this.handler.getsEntireStream();
            } else {
                long len = RubyNumeric.num2long(args[0]);
                if (len < 0L) {
                    throw this.getRuntime().newArgumentError("negative length " + len + " given");
                }
                if (len == 0L) {
                    RubyString rubyString = this.getRuntime().newString("");
                    return rubyString;
                }
                buf = this.handler.read((int)len);
            }
            if (buf == null) {
                throw new EOFException();
            }
            this.atEOF = false;
            if (callerBuffer != null) {
                callerBuffer.setValue(buf);
                RubyString rubyString = callerBuffer;
                return rubyString;
            }
            RubyString rubyString = RubyString.newString(this.getRuntime(), buf);
            return rubyString;
        }
        catch (IOHandler.BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            this.atEOF = true;
            if (callerBuffer != null) {
                callerBuffer.setValue("");
                RubyString rubyString = readEntireStream ? callerBuffer : this.getRuntime().getNil();
                return rubyString;
            }
            IRubyObject iRubyObject = readEntireStream ? this.getRuntime().newString("") : this.getRuntime().getNil();
            return iRubyObject;
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        finally {
            if (readEntireStream) {
                this.atEOF = true;
            }
        }
    }

    @JRubyMethod(name={"readchar"})
    public IRubyObject readchar() {
        this.checkReadable();
        try {
            int c = this.handler.getc();
            if (c == -1) {
                throw this.getRuntime().newEOFError();
            }
            return this.getRuntime().newFixnum(c);
        }
        catch (IOHandler.BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
    }

    @JRubyMethod(name={"each_byte"}, frame=true)
    public IRubyObject each_byte(Block block) {
        try {
            ThreadContext context = this.getRuntime().getCurrentContext();
            int c = this.handler.getc();
            while (c != -1) {
                assert (c < 256);
                block.yield(context, this.getRuntime().newFixnum(c));
                c = this.handler.getc();
            }
            return this.getRuntime().getNil();
        }
        catch (IOHandler.BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            return this.getRuntime().getNil();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
    }

    @JRubyMethod(name={"each_line", "each"}, optional=1, frame=true)
    public RubyIO each_line(IRubyObject[] args, Block block) {
        Arity.checkArgumentCount(this.getRuntime(), args, 0, 1);
        ThreadContext context = this.getRuntime().getCurrentContext();
        ByteList separator = this.getSeparatorForGets(args);
        IRubyObject line = this.internalGets(separator);
        while (!line.isNil()) {
            block.yield(context, line);
            line = this.internalGets(separator);
        }
        return this;
    }

    @JRubyMethod(name={"readlines"}, optional=1)
    public RubyArray readlines(IRubyObject[] args) {
        IRubyObject line;
        ByteList separator;
        if (args.length > 0) {
            if (!this.getRuntime().getNilClass().isInstance(args[0]) && !this.getRuntime().getString().isInstance(args[0])) {
                throw this.getRuntime().newTypeError(args[0], this.getRuntime().getString());
            }
            separator = this.getSeparatorForGets(new IRubyObject[]{args[0]});
        } else {
            separator = this.getSeparatorForGets(IRubyObject.NULL_ARRAY);
        }
        RubyArray result = this.getRuntime().newArray();
        while (!(line = this.internalGets(separator)).isNil()) {
            result.append(line);
        }
        return result;
    }

    @JRubyMethod(name={"to_io"})
    public RubyIO to_io() {
        return this;
    }

    @Override
    public String toString() {
        return "RubyIO(" + this.modes + ", " + fileno + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"foreach"}, required=1, rest=true, frame=true, meta=true)
    public static IRubyObject foreach(IRubyObject recv, IRubyObject[] args, Block block) {
        Ruby runtime = recv.getRuntime();
        int count = Arity.checkArgumentCount(runtime, args, 1, -1);
        RubyString filename = args[0].convertToString();
        runtime.checkSafeString(filename);
        RubyIO io = (RubyIO)RubyFile.open(recv, new IRubyObject[]{filename}, false, block);
        if (!io.isNil() && io.isOpen()) {
            try {
                IRubyObject[] newArgs = new IRubyObject[count - 1];
                System.arraycopy(args, 1, newArgs, 0, count - 1);
                IRubyObject nextLine = io.internalGets(newArgs);
                while (!nextLine.isNil()) {
                    block.yield(runtime.getCurrentContext(), nextLine);
                    nextLine = io.internalGets(newArgs);
                }
            }
            finally {
                io.close();
            }
        }
        return runtime.getNil();
    }

    private static RubyIO registerSelect(Selector selector, IRubyObject obj, int ops) throws IOException {
        RubyIO ioObj;
        if (!(obj instanceof RubyIO)) {
            if (!obj.respondsTo("to_io")) {
                return null;
            }
            ioObj = (RubyIO)obj.callMethod(obj.getRuntime().getCurrentContext(), "to_io");
        } else {
            ioObj = (RubyIO)obj;
        }
        Channel channel = ioObj.getChannel();
        if (channel == null || !(channel instanceof SelectableChannel)) {
            return null;
        }
        ((SelectableChannel)channel).configureBlocking(false);
        int real_ops = ((SelectableChannel)channel).validOps() & ops;
        SelectionKey key = ((SelectableChannel)channel).keyFor(selector);
        if (key == null) {
            ((SelectableChannel)channel).register(selector, real_ops, obj);
        } else {
            key.interestOps(key.interestOps() | real_ops);
        }
        return ioObj;
    }

    @JRubyMethod(name={"select"}, required=1, optional=3, meta=true)
    public static IRubyObject select(IRubyObject recv, IRubyObject[] args) {
        return RubyIO.select_static(recv.getRuntime(), args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject select_static(Ruby runtime, IRubyObject[] args) {
        try {
            boolean atLeastOneDescriptor = false;
            HashSet<IRubyObject> pending = new HashSet<IRubyObject>();
            Selector selector = Selector.open();
            if (!args[0].isNil()) {
                atLeastOneDescriptor = true;
                for (IRubyObject obj : ((RubyArray)args[0]).getList()) {
                    RubyIO ioObj = RubyIO.registerSelect(selector, obj, 17);
                    if (ioObj == null || !ioObj.hasPendingBuffered()) continue;
                    pending.add(obj);
                }
            }
            if (args.length > 1 && !args[1].isNil()) {
                atLeastOneDescriptor = true;
                for (IRubyObject obj : ((RubyArray)args[1]).getList()) {
                    RubyIO.registerSelect(selector, obj, 4);
                }
            }
            if (args.length > 2 && !args[2].isNil()) {
                atLeastOneDescriptor = true;
            }
            long timeout = 0L;
            if (args.length > 3 && !args[3].isNil() && (timeout = args[3] instanceof RubyFloat ? Math.round(((RubyFloat)args[3]).getDoubleValue() * 1000.0) : Math.round(((RubyFixnum)args[3]).getDoubleValue() * 1000.0)) < 0L) {
                throw runtime.newArgumentError("negative timeout given");
            }
            if (!atLeastOneDescriptor) {
                return runtime.getNil();
            }
            if (pending.isEmpty()) {
                if (args.length > 3) {
                    if (timeout == 0L) {
                        selector.selectNow();
                    } else {
                        selector.select(timeout);
                    }
                } else {
                    selector.select();
                }
            } else {
                selector.selectNow();
            }
            ArrayList<Object> r = new ArrayList<Object>();
            ArrayList<Object> w = new ArrayList<Object>();
            ArrayList e = new ArrayList();
            for (SelectionKey key : selector.selectedKeys()) {
                if ((key.interestOps() & key.readyOps() & 0x19) != 0) {
                    r.add(key.attachment());
                    pending.remove(key.attachment());
                }
                if ((key.interestOps() & key.readyOps() & 4) == 0) continue;
                w.add(key.attachment());
            }
            r.addAll(pending);
            for (SelectionKey key : selector.keys()) {
                SelectableChannel channel = key.channel();
                Object object = channel.blockingLock();
                synchronized (object) {
                    boolean blocking = ((RubyIO)key.attachment()).getBlocking();
                    key.cancel();
                    channel.configureBlocking(blocking);
                }
            }
            selector.close();
            if (r.size() == 0 && w.size() == 0 && e.size() == 0) {
                return runtime.getNil();
            }
            ArrayList<RubyArray> ret = new ArrayList<RubyArray>();
            ret.add(RubyArray.newArray(runtime, r));
            ret.add(RubyArray.newArray(runtime, w));
            ret.add(RubyArray.newArray(runtime, e));
            return RubyArray.newArray(runtime, ret);
        }
        catch (IOException e) {
            throw runtime.newIOError(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"read"}, required=1, optional=2, meta=true)
    public static IRubyObject read(IRubyObject recv, IRubyObject[] args, Block block) {
        Ruby runtime = recv.getRuntime();
        Arity.checkArgumentCount(runtime, args, 1, 3);
        IRubyObject[] fileArguments = new IRubyObject[]{args[0]};
        IRubyObject[] readArguments = args.length >= 2 ? new IRubyObject[]{args[1].convertToInteger()} : new IRubyObject[]{};
        try (RubyIO file = (RubyIO)RubyKernel.open(recv, fileArguments, block);){
            if (args.length == 3) {
                file.seek(new IRubyObject[]{args[2].convertToInteger()});
            }
            IRubyObject iRubyObject = file.read(readArguments);
            return iRubyObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"readlines"}, required=1, optional=1, meta=true)
    public static RubyArray readlines(IRubyObject recv, IRubyObject[] args, Block block) {
        IRubyObject[] iRubyObjectArray;
        int count = Arity.checkArgumentCount(recv.getRuntime(), args, 1, 2);
        IRubyObject[] fileArguments = new IRubyObject[]{args[0]};
        if (count >= 2) {
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
            iRubyObjectArray = iRubyObjectArray2;
            iRubyObjectArray2[0] = args[1];
        } else {
            iRubyObjectArray = IRubyObject.NULL_ARRAY;
        }
        IRubyObject[] separatorArguments = iRubyObjectArray;
        try (RubyIO file = (RubyIO)RubyKernel.open(recv, fileArguments, block);){
            RubyArray rubyArray = file.readlines(separatorArguments);
            return rubyArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(name={"popen"}, required=1, optional=1, meta=true)
    public static IRubyObject popen(IRubyObject recv, IRubyObject[] args, Block block) {
        IRubyObject iRubyObject;
        Ruby runtime = recv.getRuntime();
        Arity.checkArgumentCount(runtime, args, 1, 2);
        RubyString cmdObj = args[0].convertToString();
        runtime.checkSafeString(cmdObj);
        Process process = new ShellLauncher(runtime).run(cmdObj);
        RubyIO io = new RubyIO(runtime, process);
        if (!block.isGiven()) return io;
        try {
            iRubyObject = block.yield(runtime.getCurrentContext(), io);
            io.close();
        }
        catch (Throwable throwable) {
            try {
                io.close();
                runtime.getGlobalVariables().set("$?", RubyProcess.RubyStatus.newProcessStatus(runtime, process.waitFor() * 256));
                throw throwable;
            }
            catch (IOException e) {
                throw runtime.newIOErrorFromException(e);
            }
            catch (InterruptedException e) {
                throw runtime.newThreadError("unexpected interrupt");
            }
        }
        runtime.getGlobalVariables().set("$?", RubyProcess.RubyStatus.newProcessStatus(runtime, process.waitFor() * 256));
        return iRubyObject;
    }

    @JRubyMethod(name={"pipe"}, meta=true)
    public static IRubyObject pipe(IRubyObject recv) throws Exception {
        Ruby runtime = recv.getRuntime();
        Pipe pipe = Pipe.open();
        return runtime.newArrayNoCopy(new IRubyObject[]{new RubyIO(runtime, pipe.source()), new RubyIO(runtime, pipe.sink())});
    }

    public IRubyObject ready() {
        try {
            if (!this.handler.isOpen() || !this.handler.isReadable() || this.handler.isEOF()) {
                return this.getRuntime().getFalse();
            }
            int avail = this.handler.ready();
            if (avail > 0) {
                return this.getRuntime().newFixnum(avail);
            }
        }
        catch (Exception anyEx) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject io_wait() {
        try {
            if (this.handler.isEOF()) {
                return this.getRuntime().getNil();
            }
            this.handler.waitUntilReady();
        }
        catch (Exception anyEx) {
            return this.getRuntime().getNil();
        }
        return this;
    }
}

