/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.collections.WeakHashSet;

public class RubyClass
extends RubyModule {
    public static final ObjectAllocator CLASS_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            RubyClass clazz = new RubyClass(runtime);
            clazz.allocator = ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR;
            return clazz;
        }
    };
    private final Ruby runtime;
    private ObjectAllocator allocator;
    protected ObjectMarshal marshal;
    private Set<RubyClass> subclasses;
    protected static final ObjectMarshal DEFAULT_OBJECT_MARSHAL = new ObjectMarshal(){

        @Override
        public void marshalTo(Ruby runtime, Object obj, RubyClass type, MarshalStream marshalStream) throws IOException {
            IRubyObject object = (IRubyObject)obj;
            marshalStream.registerLinkTarget(object);
            marshalStream.dumpVariables(object.getVariableList());
        }

        @Override
        public Object unmarshalFrom(Ruby runtime, RubyClass type, UnmarshalStream unmarshalStream) throws IOException {
            IRubyObject result = type.allocate();
            unmarshalStream.registerLinkTarget(result);
            unmarshalStream.defaultVariablesUnmarshal(result);
            return result;
        }
    };

    public static void createClassClass(Ruby runtime, RubyClass classClass) {
        classClass.index = 13;
        classClass.kindOf = new RubyModule.KindOf(){

            @Override
            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyClass;
            }
        };
        classClass.undefineMethod("module_function");
        classClass.undefineMethod("append_features");
        classClass.undefineMethod("extend_object");
        classClass.defineAnnotatedMethods(RubyClass.class);
    }

    public ObjectAllocator getAllocator() {
        return this.allocator;
    }

    public void setAllocator(ObjectAllocator allocator) {
        this.allocator = allocator;
    }

    @JRubyMethod(name={"allocate"})
    public IRubyObject allocate() {
        if (this.superClass == null) {
            throw this.runtime.newTypeError("can't instantiate uninitialized class");
        }
        IRubyObject obj = this.allocator.allocate(this.runtime, this);
        if (obj.getMetaClass().getRealClass() != this.getRealClass()) {
            throw this.runtime.newTypeError("wrong instance allocation");
        }
        return obj;
    }

    @Override
    public int getNativeTypeIndex() {
        return 13;
    }

    @Override
    public boolean isModule() {
        return false;
    }

    @Override
    public boolean isClass() {
        return true;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    public static RubyClass createBootstrapClass(Ruby runtime, String name, RubyClass superClass, ObjectAllocator allocator) {
        RubyClass obj;
        if (superClass == null) {
            obj = new RubyClass(runtime);
            obj.marshal = DEFAULT_OBJECT_MARSHAL;
            obj.setConstant(name, obj);
        } else {
            obj = new RubyClass(runtime, superClass);
            runtime.getObject().setConstant(name, obj);
        }
        obj.setAllocator(allocator);
        obj.setBaseName(name);
        return obj;
    }

    protected RubyClass(Ruby runtime, RubyClass superClass, boolean objectSpace) {
        super(runtime, runtime.getClassClass(), objectSpace);
        this.runtime = runtime;
        this.superClass = superClass;
    }

    protected RubyClass(Ruby runtime) {
        super(runtime, runtime.getClassClass());
        this.runtime = runtime;
        this.index = 13;
    }

    protected RubyClass(Ruby runtime, RubyClass superClazz) {
        this(runtime);
        this.superClass = superClazz;
        this.marshal = superClazz.marshal;
        superClazz.addSubclass(this);
        this.infectBy(this.superClass);
    }

    public static RubyClass newClass(Ruby runtime, RubyClass superClass) {
        if (superClass == runtime.getClassClass()) {
            throw runtime.newTypeError("can't make subclass of Class");
        }
        if (superClass.isSingleton()) {
            throw runtime.newTypeError("can't make subclass of virtual class");
        }
        return new RubyClass(runtime, superClass);
    }

    public static RubyClass newClass(Ruby runtime, RubyClass superClass, String name, ObjectAllocator allocator, RubyModule parent, boolean setParent) {
        RubyClass clazz = RubyClass.newClass(runtime, superClass);
        clazz.setBaseName(name);
        clazz.setAllocator(allocator);
        clazz.makeMetaClass(superClass.getMetaClass());
        if (setParent) {
            clazz.setParent(parent);
        }
        parent.setConstant(name, clazz);
        clazz.inherit(superClass);
        return clazz;
    }

    @Override
    public RubyClass makeMetaClass(RubyClass superClass) {
        if (this.isSingleton()) {
            MetaClass klass = new MetaClass(this.getRuntime(), superClass);
            this.setMetaClass(klass);
            klass.setAttached(this);
            klass.setMetaClass(klass);
            klass.setSuperClass(this.getSuperClass().getRealClass().getMetaClass());
            return klass;
        }
        return super.makeMetaClass(superClass);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, int methodIndex, String name, IRubyObject[] args, CallType callType, Block block) {
        if (context.getRuntime().hasEventHooks()) {
            return this.invoke(context, self, name, args, callType, block);
        }
        return this.dispatcher.callMethod(context, self, this, methodIndex, name, args, callType, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name, IRubyObject[] args, CallType callType, Block block) {
        assert (args != null);
        DynamicMethod method = null;
        method = this.searchMethod(name);
        if (method.isUndefined() || !name.equals("method_missing") && !method.isCallableFrom(context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method, name, args, context.getFrameSelf(), callType, block);
        }
        return method.call(context, self, this, name, args, block);
    }

    @JRubyMethod(name={"new"}, rest=true, frame=true)
    public IRubyObject newInstance(IRubyObject[] args, Block block) {
        IRubyObject obj = this.allocate();
        obj.callMethod(this.getRuntime().getCurrentContext(), "initialize", args, block);
        return obj;
    }

    @JRubyMethod(name={"initialize"}, optional=1, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args, Block block) {
        IRubyObject superObject;
        if (this.superClass != null) {
            System.out.println(this.classId);
            throw this.getRuntime().newTypeError("already initialized class");
        }
        if (Arity.checkArgumentCount(this.getRuntime(), args, 0, 1) == 0) {
            superObject = this.getRuntime().getObject();
        } else {
            superObject = args[0];
            RubyClass.checkInheritable(superObject);
        }
        IRubyObject superClazz = superObject;
        this.superClass = superClazz;
        this.allocator = ((RubyClass)superClazz).allocator;
        this.makeMetaClass(((RubyObject)superClazz).getMetaClass());
        this.marshal = ((RubyClass)superClazz).marshal;
        ((RubyClass)superClazz).addSubclass(this);
        super.initialize(block);
        this.inherit((RubyClass)superClazz);
        return this;
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject original) {
        if (this.superClass != null) {
            throw this.runtime.newTypeError("already initialized class");
        }
        if (original instanceof MetaClass) {
            throw this.getRuntime().newTypeError("can't copy singleton class");
        }
        super.initialize_copy(original);
        this.allocator = ((RubyClass)original).allocator;
        return this;
    }

    public IRubyObject subclasses(IRubyObject[] args) {
        boolean recursive = false;
        if (args.length == 1) {
            if (args[0] instanceof RubyBoolean) {
                recursive = args[0].isTrue();
            } else {
                this.getRuntime().newTypeError(args[0], this.getRuntime().fastGetClass("Boolean"));
            }
        }
        return RubyArray.newArray(this.getRuntime(), this.subclasses(recursive)).freeze();
    }

    public Collection subclasses(boolean includeDescendants) {
        if (this.subclasses != null) {
            ArrayList<RubyClass> mine = new ArrayList<RubyClass>(this.subclasses);
            if (includeDescendants) {
                for (RubyClass i : this.subclasses) {
                    mine.addAll(i.subclasses(includeDescendants));
                }
            }
            return mine;
        }
        return Collections.EMPTY_LIST;
    }

    public synchronized void addSubclass(RubyClass subclass) {
        if (this.subclasses == null) {
            this.subclasses = new WeakHashSet<RubyClass>();
        }
        this.subclasses.add(subclass);
    }

    @Override
    public Ruby getRuntime() {
        return this.runtime;
    }

    public RubyClass getRealClass() {
        return this;
    }

    @JRubyMethod(name={"inherited"}, required=1)
    public IRubyObject inherited(IRubyObject arg) {
        return this.getRuntime().getNil();
    }

    public void inherit(RubyClass superClazz) {
        if (superClazz == null) {
            superClazz = this.getRuntime().getObject();
        }
        superClazz.callMethod(this.getRuntime().getCurrentContext(), "inherited", this);
    }

    @JRubyMethod(name={"superclass"})
    public IRubyObject superclass() {
        RubyClass superClazz = this.superClass;
        if (superClazz == null) {
            throw this.runtime.newTypeError("uninitialized class");
        }
        if (this.isSingleton()) {
            superClazz = this.metaClass;
        }
        while (superClazz != null && superClazz.isIncluded()) {
            superClazz = superClazz.superClass;
        }
        return superClazz != null ? superClazz : this.getRuntime().getNil();
    }

    public static void checkInheritable(IRubyObject superClass) {
        if (!(superClass instanceof RubyClass)) {
            throw superClass.getRuntime().newTypeError("superclass must be a Class (" + superClass.getMetaClass() + " given)");
        }
        if (((RubyClass)superClass).isSingleton()) {
            throw superClass.getRuntime().newTypeError("can't make subclass of virtual class");
        }
    }

    public final ObjectMarshal getMarshal() {
        return this.marshal;
    }

    public final void setMarshal(ObjectMarshal marshal) {
        this.marshal = marshal;
    }

    public final void marshal(Object obj, MarshalStream marshalStream) throws IOException {
        this.getMarshal().marshalTo(this.getRuntime(), obj, this, marshalStream);
    }

    public final Object unmarshal(UnmarshalStream unmarshalStream) throws IOException {
        return this.getMarshal().unmarshalFrom(this.getRuntime(), this, unmarshalStream);
    }

    public static void marshalTo(RubyClass clazz, MarshalStream output) throws IOException {
        output.registerLinkTarget(clazz);
        output.writeString(MarshalStream.getPathFromClass(clazz));
    }

    public static RubyClass unmarshalFrom(UnmarshalStream input) throws IOException {
        String name = RubyString.byteListToString(input.unmarshalString());
        RubyClass result = UnmarshalStream.getClassFromPath(input.getRuntime(), name);
        input.registerLinkTarget(result);
        return result;
    }
}

