/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jruby.CompatVersion;
import org.jruby.Finalizable;
import org.jruby.IErrno;
import org.jruby.NativeException;
import org.jruby.Profile;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBinding;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyClassPathVariable;
import org.jruby.RubyComparable;
import org.jruby.RubyContinuation;
import org.jruby.RubyDir;
import org.jruby.RubyEnumerable;
import org.jruby.RubyException;
import org.jruby.RubyFile;
import org.jruby.RubyFileStat;
import org.jruby.RubyFileTest;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyGC;
import org.jruby.RubyGlobal;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyMarshal;
import org.jruby.RubyMatchData;
import org.jruby.RubyMath;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyNameError;
import org.jruby.RubyNil;
import org.jruby.RubyNoMethodError;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyObjectSpace;
import org.jruby.RubyPrecision;
import org.jruby.RubyProc;
import org.jruby.RubyProcess;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubySignal;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.RubySystemCallError;
import org.jruby.RubySystemExit;
import org.jruby.RubyThread;
import org.jruby.RubyThreadGroup;
import org.jruby.RubyTime;
import org.jruby.RubyUnboundMethod;
import org.jruby.RubyUndef;
import org.jruby.TopSelfFactory;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.executable.RubiniusRunner;
import org.jruby.ast.executable.Script;
import org.jruby.ast.executable.YARVCompiledRunner;
import org.jruby.common.RubyWarnings;
import org.jruby.compiler.ASTCompiler;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.compiler.yarv.StandardYARVCompiler;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.LateLoadingLibrary;
import org.jruby.ext.posix.JRubyPOSIXHandler;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXFactory;
import org.jruby.ext.socket.RubySocket;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.internal.runtime.ThreadService;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaSupport;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.libraries.RbConfigLibrary;
import org.jruby.parser.Parser;
import org.jruby.parser.ParserConfiguration;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.CacheMap;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.EventHook;
import org.jruby.runtime.GlobalVariable;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectSpace;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LoadService;
import org.jruby.util.ByteList;
import org.jruby.util.IOHandler;
import org.jruby.util.IOInputStream;
import org.jruby.util.IOOutputStream;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.KCode;
import org.jruby.util.NormalizedFile;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.SimpleSampler;

public final class Ruby {
    private static String[] BUILTIN_LIBRARIES = new String[]{"fcntl", "yaml", "yaml/syck", "jsignal"};
    private CacheMap cacheMap = new CacheMap();
    private ThreadService threadService;
    private Hashtable<Object, Object> runtimeInformation;
    private POSIX posix;
    private int stackTraces = 0;
    private ObjectSpace objectSpace = new ObjectSpace();
    public final RubyFixnum[] fixnumCache = new RubyFixnum[256];
    private final RubySymbol.SymbolTable symbolTable = new RubySymbol.SymbolTable(this);
    private Hashtable<Integer, WeakReference<IOHandler>> ioHandlers = new Hashtable();
    private long randomSeed = 0L;
    private long randomSeedSequence = 0L;
    private Random random = new Random();
    private ArrayList<EventHook> eventHooks = new ArrayList();
    private boolean hasEventHooks;
    private boolean globalAbortOnExceptionEnabled = false;
    private boolean doNotReverseLookupEnabled = false;
    private final boolean objectSpaceEnabled;
    private static ThreadLocal<Ruby> currentRuntime = new ThreadLocal();
    public static final boolean RUNTIME_THREADLOCAL = SafePropertyAccessor.getBoolean("jruby.runtime.threadlocal");
    private long globalState = 1L;
    private int safeLevel = 0;
    private IRubyObject undef;
    private RubyClass objectClass;
    private RubyClass moduleClass;
    private RubyClass classClass;
    private RubyModule kernelModule;
    private RubyClass nilClass;
    private RubyClass trueClass;
    private RubyClass falseClass;
    private RubyModule comparableModule;
    private RubyClass numericClass;
    private RubyClass floatClass;
    private RubyClass integerClass;
    private RubyClass fixnumClass;
    private RubyModule enumerableModule;
    private RubyClass arrayClass;
    private RubyClass hashClass;
    private RubyClass rangeClass;
    private RubyClass stringClass;
    private RubyClass symbolClass;
    private RubyNil nilObject;
    private RubyBoolean trueObject;
    private RubyBoolean falseObject;
    private RubyClass procClass;
    private RubyClass bindingClass;
    private RubyClass methodClass;
    private RubyClass unboundMethodClass;
    private RubyClass matchDataClass;
    private RubyClass regexpClass;
    private RubyClass timeClass;
    private RubyModule mathModule;
    private RubyModule marshalModule;
    private RubyClass bignumClass;
    private RubyClass dirClass;
    private RubyModule etcModule;
    private RubyClass fileClass;
    private RubyClass fileStatClass;
    private RubyModule fileTestModule;
    private RubyClass ioClass;
    private RubyClass threadClass;
    private RubyClass threadGroupClass;
    private RubyClass continuationClass;
    private RubyClass structClass;
    private IRubyObject tmsStruct;
    private IRubyObject passwdStruct;
    private RubyModule gcModule;
    private RubyModule objectSpaceModule;
    private RubyModule processModule;
    private RubyClass procStatusClass;
    private RubyModule procUIDModule;
    private RubyModule procGIDModule;
    private RubyModule procSysModule;
    private RubyModule precisionModule;
    private RubyClass exceptionClass;
    private RubyClass standardError;
    private RubyClass systemCallError;
    private RubyModule errnoModule;
    private IRubyObject topSelf;
    private GlobalVariable recordSeparatorVar;
    private String currentDirectory;
    private long startTime = System.currentTimeMillis();
    private RubyInstanceConfig config;
    private InputStream in;
    private PrintStream out;
    private PrintStream err;
    private IRubyObject verbose;
    private IRubyObject debug;
    private JavaSupport javaSupport;
    private JRubyClassLoader jrubyClassLoader;
    private static boolean securityRestricted = false;
    private Parser parser = new Parser(this);
    private LoadService loadService;
    private GlobalVariables globalVariables = new GlobalVariables(this);
    private RubyWarnings warnings = new RubyWarnings(this);
    private Stack<RubyProc> atExitBlocks = new Stack();
    private Profile profile;
    private String jrubyHome;
    private KCode kcode = KCode.NONE;
    private AtomicInteger symbolLastId = new AtomicInteger(128);
    private AtomicInteger moduleLastId = new AtomicInteger(0);
    private Object respondToMethod;
    private Map<Finalizable, Object> finalizers;
    private Map<Finalizable, Object> internalFinalizers;
    private final Object finalizersMutex = new Object();
    private final Object internalFinalizersMutex = new Object();
    private String[] argv;
    private final CallTraceFuncHook callTraceFuncHook = new CallTraceFuncHook();
    private ThreadLocal<Map<Object, Object>> inspect = new ThreadLocal();

    public int allocSymbolId() {
        return this.symbolLastId.incrementAndGet();
    }

    public int allocModuleId() {
        return this.moduleLastId.incrementAndGet();
    }

    private Ruby(RubyInstanceConfig config) {
        this.config = config;
        this.threadService = new ThreadService(this);
        if (config.isSamplingEnabled()) {
            SimpleSampler.registerThreadContext(this.threadService.getCurrentContext());
        }
        this.in = config.getInput();
        this.out = config.getOutput();
        this.err = config.getError();
        this.objectSpaceEnabled = config.isObjectSpaceEnabled();
        this.profile = config.getProfile();
        this.currentDirectory = config.getCurrentDirectory();
        this.jrubyClassLoader = config.getJRubyClassLoader();
        this.argv = config.getArgv();
    }

    public static Ruby getDefaultInstance() {
        return Ruby.newInstance();
    }

    public static Ruby newInstance() {
        return Ruby.newInstance(new RubyInstanceConfig());
    }

    public static Ruby newInstance(RubyInstanceConfig config) {
        Ruby ruby = new Ruby(config);
        ruby.init();
        if (RUNTIME_THREADLOCAL) {
            Ruby.setCurrentInstance(ruby);
        }
        return ruby;
    }

    public static Ruby getCurrentInstance() {
        return currentRuntime.get();
    }

    public static void setCurrentInstance(Ruby runtime) {
        currentRuntime.set(runtime);
    }

    public static Ruby newInstance(InputStream in, PrintStream out, PrintStream err) {
        RubyInstanceConfig config = new RubyInstanceConfig();
        config.setInput(in);
        config.setOutput(out);
        config.setError(err);
        return Ruby.newInstance(config);
    }

    public IRubyObject evalFile(InputStream in, String name) {
        return this.eval(this.parseFile(in, name, this.getCurrentContext().getCurrentScope()));
    }

    public IRubyObject evalScriptlet(String script) {
        return this.eval(this.parseEval(script, "<script>", this.getCurrentContext().getCurrentScope(), 0));
    }

    public IRubyObject eval(Node node) {
        try {
            ThreadContext tc = this.getCurrentContext();
            return ASTInterpreter.eval(this, tc, node, tc.getFrameSelf(), Block.NULL_BLOCK);
        }
        catch (JumpException.ReturnJump rj) {
            throw this.newLocalJumpError("return", (IRubyObject)rj.getValue(), "unexpected return");
        }
        catch (JumpException.BreakJump bj) {
            throw this.newLocalJumpError("break", (IRubyObject)bj.getValue(), "unexpected break");
        }
        catch (JumpException.RedoJump rj) {
            throw this.newLocalJumpError("redo", (IRubyObject)rj.getValue(), "unexpected redo");
        }
    }

    public IRubyObject executeScript(String script, String filename) {
        byte[] bytes;
        try {
            bytes = script.getBytes(KCode.NONE.getKCode());
        }
        catch (UnsupportedEncodingException e) {
            bytes = script.getBytes();
        }
        Node node = this.parseInline(new ByteArrayInputStream(bytes), filename, null);
        this.getCurrentContext().getCurrentFrame().setPosition(node.getPosition());
        return this.runNormally(node, false);
    }

    public void runFromMain(InputStream in, String filename) {
        if (this.config.isYARVEnabled()) {
            new YARVCompiledRunner(this, in, filename).run();
        } else if (this.config.isRubiniusEnabled()) {
            new RubiniusRunner(this, in, filename).run();
        } else {
            Node scriptNode = this.config.isInlineScript() ? this.parseInline(in, filename, this.getCurrentContext().getCurrentScope()) : this.parseFile(in, filename, this.getCurrentContext().getCurrentScope());
            this.getCurrentContext().getCurrentFrame().setPosition(scriptNode.getPosition());
            if (this.config.isAssumePrinting() || this.config.isAssumeLoop()) {
                this.runWithGetsLoop(scriptNode, this.config.isAssumePrinting(), this.config.isProcessLineEnds(), this.config.isSplit(), this.config.isYARVCompileEnabled());
            } else {
                this.runNormally(scriptNode, this.config.isYARVCompileEnabled());
            }
        }
    }

    public IRubyObject runWithGetsLoop(Node scriptNode, boolean printing, boolean processLineEnds, boolean split, boolean yarvCompile) {
        ThreadContext context = this.getCurrentContext();
        Script script = null;
        YARVCompiledRunner runner = null;
        boolean compile = this.getInstanceConfig().getCompileMode().shouldPrecompileCLI();
        if (compile || !yarvCompile) {
            script = this.tryCompile(scriptNode);
            if (compile && script == null) {
                return this.getNil();
            }
        } else if (yarvCompile) {
            runner = this.tryCompileYarv(scriptNode);
        }
        if (processLineEnds) {
            this.getGlobalVariables().set("$\\", this.getGlobalVariables().get("$/"));
        }
        block4: while (RubyKernel.gets(this.getTopSelf(), IRubyObject.NULL_ARRAY).isTrue()) {
            while (true) {
                try {
                    if (processLineEnds) {
                        this.getGlobalVariables().get("$_").callMethod(context, "chop!");
                    }
                    if (split) {
                        this.getGlobalVariables().set("$F", this.getGlobalVariables().get("$_").callMethod(context, "split"));
                    }
                    if (script != null) {
                        this.runScript(script);
                    } else if (runner != null) {
                        this.runYarv(runner);
                    } else {
                        this.runInterpreter(scriptNode);
                    }
                    if (!printing) continue block4;
                    RubyKernel.print(this.getKernel(), new IRubyObject[]{this.getGlobalVariables().get("$_")});
                    continue block4;
                }
                catch (JumpException.RedoJump redoJump) {
                    continue;
                }
                catch (JumpException.NextJump nj) {
                    continue block4;
                }
                catch (JumpException.BreakJump bj) {
                    return (IRubyObject)bj.getValue();
                }
                break;
            }
        }
        return this.getNil();
    }

    public IRubyObject runNormally(Node scriptNode, boolean yarvCompile) {
        Script script = null;
        YARVCompiledRunner runner = null;
        boolean compile = this.getInstanceConfig().getCompileMode().shouldPrecompileCLI();
        boolean forceCompile = this.getInstanceConfig().getCompileMode().shouldPrecompileAll();
        if (compile) {
            script = this.tryCompile(scriptNode);
            if (forceCompile && script == null) {
                System.err.println("Error, could not compile; pass -J-Djruby.jit.logging.verbose=true for more details");
                return this.getNil();
            }
        } else if (yarvCompile) {
            runner = this.tryCompileYarv(scriptNode);
        }
        if (script != null) {
            return this.runScript(script);
        }
        if (runner != null) {
            return this.runYarv(runner);
        }
        return this.runInterpreter(scriptNode);
    }

    private Script tryCompile(Node node) {
        return this.tryCompile(node, new JRubyClassLoader(this.getJRubyClassLoader()));
    }

    private Script tryCompile(Node node, JRubyClassLoader classLoader) {
        Script script;
        block11: {
            script = null;
            try {
                String filename = node.getPosition().getFile();
                String classname = JavaNameMangler.mangledFilenameForStartupClasspath(filename);
                ASTInspector inspector = new ASTInspector();
                inspector.inspect(node);
                StandardASMCompiler asmCompiler = new StandardASMCompiler(classname, filename);
                ASTCompiler compiler = new ASTCompiler();
                compiler.compileRoot(node, asmCompiler, inspector);
                script = (Script)asmCompiler.loadClass(classLoader).newInstance();
                if (this.config.isJitLogging()) {
                    System.err.println("compiled: " + node.getPosition().getFile());
                }
            }
            catch (NotCompilableException nce) {
                if (this.config.isJitLoggingVerbose()) {
                    System.err.println("Error -- Not compileable: " + nce.getMessage());
                    nce.printStackTrace();
                }
            }
            catch (ClassNotFoundException e) {
                if (this.config.isJitLoggingVerbose()) {
                    System.err.println("Error -- Not compileable: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            catch (InstantiationException e) {
                if (this.config.isJitLoggingVerbose()) {
                    System.err.println("Error -- Not compileable: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            catch (IllegalAccessException e) {
                if (this.config.isJitLoggingVerbose()) {
                    System.err.println("Error -- Not compileable: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            catch (Throwable t) {
                if (!this.config.isJitLoggingVerbose()) break block11;
                System.err.println("could not compile: " + node.getPosition().getFile() + " because of: \"" + t.getMessage() + "\"");
                t.printStackTrace();
            }
        }
        return script;
    }

    private YARVCompiledRunner tryCompileYarv(Node node) {
        try {
            StandardYARVCompiler compiler = new StandardYARVCompiler(this);
            ASTCompiler.getYARVCompiler().compile(node, compiler);
            ISourcePosition p = node.getPosition();
            if (p == null && node instanceof RootNode) {
                p = ((RootNode)node).getBodyNode().getPosition();
            }
            return new YARVCompiledRunner(this, compiler.getInstructionSequence("<main>", p.getFile(), "toplevel"));
        }
        catch (NotCompilableException nce) {
            System.err.println("Error -- Not compileable: " + nce.getMessage());
            return null;
        }
        catch (JumpException.ReturnJump rj) {
            return null;
        }
    }

    private IRubyObject runScript(Script script) {
        ThreadContext context = this.getCurrentContext();
        try {
            return script.load(this.getCurrentContext(), context.getFrameSelf(), IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
        }
        catch (JumpException.ReturnJump rj) {
            return (IRubyObject)rj.getValue();
        }
    }

    private IRubyObject runYarv(YARVCompiledRunner runner) {
        try {
            return runner.run();
        }
        catch (JumpException.ReturnJump rj) {
            return (IRubyObject)rj.getValue();
        }
    }

    private IRubyObject runInterpreter(Node scriptNode) {
        ThreadContext context = this.getCurrentContext();
        try {
            return ASTInterpreter.eval(this, context, scriptNode, this.getTopSelf(), Block.NULL_BLOCK);
        }
        catch (JumpException.ReturnJump rj) {
            return (IRubyObject)rj.getValue();
        }
    }

    Object getRespondToMethod() {
        return this.respondToMethod;
    }

    void setRespondToMethod(Object rtm) {
        this.respondToMethod = rtm;
    }

    public IRubyObject getUndef() {
        return this.undef;
    }

    public RubyModule getEtc() {
        return this.etcModule;
    }

    public void setEtc(RubyModule etcModule) {
        this.etcModule = etcModule;
    }

    public RubyClass getObject() {
        return this.objectClass;
    }

    public RubyClass getModule() {
        return this.moduleClass;
    }

    public RubyClass getClassClass() {
        return this.classClass;
    }

    public RubyModule getKernel() {
        return this.kernelModule;
    }

    void setKernel(RubyModule kernelModule) {
        this.kernelModule = kernelModule;
    }

    public RubyModule getComparable() {
        return this.comparableModule;
    }

    void setComparable(RubyModule comparableModule) {
        this.comparableModule = comparableModule;
    }

    public RubyClass getNumeric() {
        return this.numericClass;
    }

    void setNumeric(RubyClass numericClass) {
        this.numericClass = numericClass;
    }

    public RubyClass getFloat() {
        return this.floatClass;
    }

    void setFloat(RubyClass floatClass) {
        this.floatClass = floatClass;
    }

    public RubyClass getInteger() {
        return this.integerClass;
    }

    void setInteger(RubyClass integerClass) {
        this.integerClass = integerClass;
    }

    public RubyClass getFixnum() {
        return this.fixnumClass;
    }

    void setFixnum(RubyClass fixnumClass) {
        this.fixnumClass = fixnumClass;
    }

    public RubyModule getEnumerable() {
        return this.enumerableModule;
    }

    void setEnumerable(RubyModule enumerableModule) {
        this.enumerableModule = enumerableModule;
    }

    public RubyClass getString() {
        return this.stringClass;
    }

    void setString(RubyClass stringClass) {
        this.stringClass = stringClass;
    }

    public RubyClass getSymbol() {
        return this.symbolClass;
    }

    void setSymbol(RubyClass symbolClass) {
        this.symbolClass = symbolClass;
    }

    public RubyClass getArray() {
        return this.arrayClass;
    }

    void setArray(RubyClass arrayClass) {
        this.arrayClass = arrayClass;
    }

    public RubyClass getHash() {
        return this.hashClass;
    }

    void setHash(RubyClass hashClass) {
        this.hashClass = hashClass;
    }

    public RubyClass getRange() {
        return this.rangeClass;
    }

    void setRange(RubyClass rangeClass) {
        this.rangeClass = rangeClass;
    }

    public RubyBoolean getTrue() {
        return this.trueObject;
    }

    public RubyBoolean getFalse() {
        return this.falseObject;
    }

    public IRubyObject getNil() {
        return this.nilObject;
    }

    public RubyClass getNilClass() {
        return this.nilClass;
    }

    void setNilClass(RubyClass nilClass) {
        this.nilClass = nilClass;
    }

    public RubyClass getTrueClass() {
        return this.trueClass;
    }

    void setTrueClass(RubyClass trueClass) {
        this.trueClass = trueClass;
    }

    public RubyClass getFalseClass() {
        return this.falseClass;
    }

    void setFalseClass(RubyClass falseClass) {
        this.falseClass = falseClass;
    }

    public RubyClass getProc() {
        return this.procClass;
    }

    void setProc(RubyClass procClass) {
        this.procClass = procClass;
    }

    public RubyClass getBinding() {
        return this.bindingClass;
    }

    void setBinding(RubyClass bindingClass) {
        this.bindingClass = bindingClass;
    }

    public RubyClass getMethod() {
        return this.methodClass;
    }

    void setMethod(RubyClass methodClass) {
        this.methodClass = methodClass;
    }

    public RubyClass getUnboundMethod() {
        return this.unboundMethodClass;
    }

    void setUnboundMethod(RubyClass unboundMethodClass) {
        this.unboundMethodClass = unboundMethodClass;
    }

    public RubyClass getMatchData() {
        return this.matchDataClass;
    }

    void setMatchData(RubyClass matchDataClass) {
        this.matchDataClass = matchDataClass;
    }

    public RubyClass getRegexp() {
        return this.regexpClass;
    }

    void setRegexp(RubyClass regexpClass) {
        this.regexpClass = regexpClass;
    }

    public RubyClass getTime() {
        return this.timeClass;
    }

    void setTime(RubyClass timeClass) {
        this.timeClass = timeClass;
    }

    public RubyModule getMath() {
        return this.mathModule;
    }

    void setMath(RubyModule mathModule) {
        this.mathModule = mathModule;
    }

    public RubyModule getMarshal() {
        return this.marshalModule;
    }

    void setMarshal(RubyModule marshalModule) {
        this.marshalModule = marshalModule;
    }

    public RubyClass getBignum() {
        return this.bignumClass;
    }

    void setBignum(RubyClass bignumClass) {
        this.bignumClass = bignumClass;
    }

    public RubyClass getDir() {
        return this.dirClass;
    }

    void setDir(RubyClass dirClass) {
        this.dirClass = dirClass;
    }

    public RubyClass getFile() {
        return this.fileClass;
    }

    void setFile(RubyClass fileClass) {
        this.fileClass = fileClass;
    }

    public RubyClass getFileStat() {
        return this.fileStatClass;
    }

    void setFileStat(RubyClass fileStatClass) {
        this.fileStatClass = fileStatClass;
    }

    public RubyModule getFileTest() {
        return this.fileTestModule;
    }

    void setFileTest(RubyModule fileTestModule) {
        this.fileTestModule = fileTestModule;
    }

    public RubyClass getIO() {
        return this.ioClass;
    }

    void setIO(RubyClass ioClass) {
        this.ioClass = ioClass;
    }

    public RubyClass getThread() {
        return this.threadClass;
    }

    void setThread(RubyClass threadClass) {
        this.threadClass = threadClass;
    }

    public RubyClass getThreadGroup() {
        return this.threadGroupClass;
    }

    void setThreadGroup(RubyClass threadGroupClass) {
        this.threadGroupClass = threadGroupClass;
    }

    public RubyClass getContinuation() {
        return this.continuationClass;
    }

    void setContinuation(RubyClass continuationClass) {
        this.continuationClass = continuationClass;
    }

    public RubyClass getStructClass() {
        return this.structClass;
    }

    void setStructClass(RubyClass structClass) {
        this.structClass = structClass;
    }

    public IRubyObject getTmsStruct() {
        return this.tmsStruct;
    }

    void setTmsStruct(RubyClass tmsStruct) {
        this.tmsStruct = tmsStruct;
    }

    public IRubyObject getPasswdStruct() {
        return this.passwdStruct;
    }

    void setPasswdStruct(RubyClass passwdStruct) {
        this.passwdStruct = passwdStruct;
    }

    public RubyModule getGC() {
        return this.gcModule;
    }

    void setGC(RubyModule gcModule) {
        this.gcModule = gcModule;
    }

    public RubyModule getObjectSpaceModule() {
        return this.objectSpaceModule;
    }

    void setObjectSpaceModule(RubyModule objectSpaceModule) {
        this.objectSpaceModule = objectSpaceModule;
    }

    public RubyModule getProcess() {
        return this.processModule;
    }

    void setProcess(RubyModule processModule) {
        this.processModule = processModule;
    }

    public RubyClass getProcStatus() {
        return this.procStatusClass;
    }

    void setProcStatus(RubyClass procStatusClass) {
        this.procStatusClass = procStatusClass;
    }

    public RubyModule getProcUID() {
        return this.procUIDModule;
    }

    void setProcUID(RubyModule procUIDModule) {
        this.procUIDModule = procUIDModule;
    }

    public RubyModule getProcGID() {
        return this.procGIDModule;
    }

    void setProcGID(RubyModule procGIDModule) {
        this.procGIDModule = procGIDModule;
    }

    public RubyModule getProcSysModule() {
        return this.procSysModule;
    }

    void setProcSys(RubyModule procSysModule) {
        this.procSysModule = procSysModule;
    }

    public RubyModule getPrecision() {
        return this.precisionModule;
    }

    void setPrecision(RubyModule precisionModule) {
        this.precisionModule = precisionModule;
    }

    public RubyClass getException() {
        return this.exceptionClass;
    }

    void setException(RubyClass exceptionClass) {
        this.exceptionClass = exceptionClass;
    }

    public RubyClass getStandardError() {
        return this.standardError;
    }

    public RubyModule getModule(String name) {
        return (RubyModule)this.objectClass.getConstantAt(name);
    }

    public RubyModule fastGetModule(String internedName) {
        return (RubyModule)this.objectClass.fastGetConstantAt(internedName);
    }

    public RubyClass getClass(String name) {
        return this.objectClass.getClass(name);
    }

    public RubyClass fastGetClass(String internedName) {
        return this.objectClass.fastGetClass(internedName);
    }

    public RubyClass defineClass(String name, RubyClass superClass, ObjectAllocator allocator) {
        IRubyObject classObj = this.objectClass.getConstantAt(name);
        if (classObj != null) {
            if (!(classObj instanceof RubyClass)) {
                throw this.newTypeError(name + " is not a class");
            }
            RubyClass klazz = (RubyClass)classObj;
            if (klazz.getSuperClass().getRealClass() != superClass) {
                throw this.newNameError(name + " is already defined", name);
            }
            return klazz;
        }
        if (superClass == null) {
            this.warnings.warn("no super class for `" + name + "', Object assumed");
            superClass = this.objectClass;
        }
        return RubyClass.newClass(this, superClass, name, allocator, this.objectClass, false);
    }

    public RubyClass defineClassUnder(String name, RubyClass superClass, ObjectAllocator allocator, RubyModule parent) {
        IRubyObject classObj = parent.getConstantAt(name);
        if (classObj != null) {
            if (!(classObj instanceof RubyClass)) {
                throw this.newTypeError(name + " is not a class");
            }
            RubyClass klazz = (RubyClass)classObj;
            if (klazz.getSuperClass().getRealClass() != superClass) {
                throw this.newNameError(name + " is already defined", name);
            }
            if (klazz.getAllocator() != allocator) {
                klazz.setAllocator(allocator);
            }
            return klazz;
        }
        if (superClass == null) {
            this.warnings.warn("no super class for `" + parent.getName() + "::" + name + "', Object assumed");
            superClass = this.objectClass;
        }
        return RubyClass.newClass(this, superClass, name, allocator, parent, true);
    }

    public RubyModule defineModule(String name) {
        IRubyObject moduleObj = this.objectClass.getConstantAt(name);
        if (moduleObj != null) {
            if (moduleObj.isModule()) {
                return (RubyModule)moduleObj;
            }
            throw this.newTypeError(moduleObj.getMetaClass().getName() + " is not a module");
        }
        return RubyModule.newModule(this, name, this.objectClass, false);
    }

    public RubyModule defineModuleUnder(String name, RubyModule parent) {
        IRubyObject moduleObj = parent.getConstantAt(name);
        if (moduleObj != null) {
            if (moduleObj.isModule()) {
                return (RubyModule)moduleObj;
            }
            throw this.newTypeError(parent.getName() + "::" + moduleObj.getMetaClass().getName() + " is not a module");
        }
        return RubyModule.newModule(this, name, parent, true);
    }

    public RubyModule getOrCreateModule(String name) {
        IRubyObject module = this.objectClass.getConstantAt(name);
        if (module == null) {
            module = this.defineModule(name);
        } else {
            if (this.getSafeLevel() >= 4) {
                throw this.newSecurityError("Extending module prohibited.");
            }
            if (!module.isModule()) {
                throw this.newTypeError(name + " is not a Module");
            }
        }
        return (RubyModule)module;
    }

    public int getSafeLevel() {
        return this.safeLevel;
    }

    public void setSafeLevel(int safeLevel) {
        this.safeLevel = safeLevel;
    }

    public KCode getKCode() {
        return this.kcode;
    }

    public void setKCode(KCode kcode) {
        this.kcode = kcode;
    }

    public void secure(int level) {
        if (level <= this.safeLevel) {
            throw this.newSecurityError("Insecure operation '" + this.getCurrentContext().getFrameName() + "' at level " + this.safeLevel);
        }
    }

    public void checkSafeString(IRubyObject object) {
        if (this.getSafeLevel() > 0 && object.isTaint()) {
            ThreadContext tc = this.getCurrentContext();
            if (tc.getFrameName() != null) {
                throw this.newSecurityError("Insecure operation - " + tc.getFrameName());
            }
            throw this.newSecurityError("Insecure operation: -r");
        }
        this.secure(4);
        if (!(object instanceof RubyString)) {
            throw this.newTypeError("wrong argument type " + object.getMetaClass().getName() + " (expected String)");
        }
    }

    public CacheMap getCacheMap() {
        return this.cacheMap;
    }

    public Map<Object, Object> getRuntimeInformation() {
        return this.runtimeInformation == null ? (this.runtimeInformation = new Hashtable()) : this.runtimeInformation;
    }

    public void defineGlobalConstant(String name, IRubyObject value) {
        this.objectClass.defineConstant(name, value);
    }

    public boolean isClassDefined(String name) {
        return this.getModule(name) != null;
    }

    public IRubyObject getTopSelf() {
        return this.topSelf;
    }

    public void setCurrentDirectory(String dir) {
        this.currentDirectory = dir;
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    private void init() {
        ThreadContext tc = this.getCurrentContext();
        this.posix = POSIXFactory.getPOSIX(new JRubyPOSIXHandler(this), RubyInstanceConfig.nativeEnabled);
        this.defineGlobalVERBOSE();
        this.defineGlobalDEBUG();
        this.javaSupport = new JavaSupport(this);
        tc.preInitCoreClasses();
        this.initCoreClasses();
        tc.getCurrentScope().getStaticScope().setModule(this.objectClass);
        this.verbose = this.falseObject;
        this.debug = this.falseObject;
        this.initLibraries();
        this.topSelf = TopSelfFactory.createTopSelf(this);
        tc.preInitBuiltinClasses(this.objectClass, this.topSelf);
        RubyGlobal.createGlobals(this);
        this.defineGlobalConstant("TRUE", this.trueObject);
        this.defineGlobalConstant("FALSE", this.falseObject);
        this.defineGlobalConstant("NIL", this.nilObject);
        this.getObject().defineConstant("TOPLEVEL_BINDING", this.newBinding());
        RubyKernel.autoload(this.topSelf, this.newSymbol("Java"), this.newString("java"));
    }

    private void initLibraries() {
        this.loadService = this.config.createLoadService(this);
        this.registerBuiltin("java.rb", new Library(){

            @Override
            public void load(Ruby runtime, boolean wrap) throws IOException {
                Java.createJavaModule(runtime);
                runtime.getLoadService().smartLoad("builtin/javasupport");
                RubyClassPathVariable.createClassPathVariable(runtime);
            }
        });
        this.registerBuiltin("socket.rb", new RubySocket.Service());
        this.registerBuiltin("rbconfig.rb", new RbConfigLibrary());
        for (int i = 0; i < BUILTIN_LIBRARIES.length; ++i) {
            if (!this.profile.allowBuiltin(BUILTIN_LIBRARIES[i])) continue;
            this.loadService.registerRubyBuiltin(BUILTIN_LIBRARIES[i]);
        }
        this.registerBuiltin("jruby.rb", new LateLoadingLibrary("jruby", "org.jruby.libraries.JRubyLibrary", this.getJRubyClassLoader()));
        this.registerBuiltin("jruby/ext.rb", new LateLoadingLibrary("jruby/ext", "org.jruby.RubyJRuby$ExtLibrary", this.getJRubyClassLoader()));
        this.registerBuiltin("iconv.rb", new LateLoadingLibrary("iconv", "org.jruby.libraries.IConvLibrary", this.getJRubyClassLoader()));
        this.registerBuiltin("nkf.rb", new LateLoadingLibrary("nkf", "org.jruby.libraries.NKFLibrary", this.getJRubyClassLoader()));
        this.registerBuiltin("stringio.rb", new LateLoadingLibrary("stringio", "org.jruby.libraries.StringIOLibrary", this.getJRubyClassLoader()));
        this.registerBuiltin("strscan.rb", new LateLoadingLibrary("strscan", "org.jruby.libraries.StringScannerLibrary", this.getJRubyClassLoader()));
        this.registerBuiltin("zlib.rb", new LateLoadingLibrary("zlib", "org.jruby.libraries.ZlibLibrary", this.getJRubyClassLoader()));
        this.registerBuiltin("yaml_internal.rb", new LateLoadingLibrary("yaml_internal", "org.jruby.libraries.YamlLibrary", this.getJRubyClassLoader()));
        this.registerBuiltin("enumerator.rb", new LateLoadingLibrary("enumerator", "org.jruby.libraries.EnumeratorLibrary", this.getJRubyClassLoader()));
        this.registerBuiltin("generator_internal.rb", new LateLoadingLibrary("generator_internal", "org.jruby.ext.Generator$Service", this.getJRubyClassLoader()));
        this.registerBuiltin("readline.rb", new LateLoadingLibrary("readline", "org.jruby.ext.Readline$Service", this.getJRubyClassLoader()));
        this.registerBuiltin("thread.so", new LateLoadingLibrary("thread", "org.jruby.libraries.ThreadLibrary", this.getJRubyClassLoader()));
        this.registerBuiltin("openssl.so", new Library(){

            @Override
            public void load(Ruby runtime, boolean wrap) throws IOException {
                runtime.getLoadService().require("jruby/openssl/stub");
            }
        });
        this.registerBuiltin("digest.so", new LateLoadingLibrary("digest", "org.jruby.libraries.DigestLibrary", this.getJRubyClassLoader()));
        this.registerBuiltin("digest.rb", new LateLoadingLibrary("digest", "org.jruby.libraries.DigestLibrary", this.getJRubyClassLoader()));
        this.registerBuiltin("digest/md5.rb", new LateLoadingLibrary("digest/md5", "org.jruby.libraries.DigestLibrary$MD5", this.getJRubyClassLoader()));
        this.registerBuiltin("digest/rmd160.rb", new LateLoadingLibrary("digest/rmd160", "org.jruby.libraries.DigestLibrary$RMD160", this.getJRubyClassLoader()));
        this.registerBuiltin("digest/sha1.rb", new LateLoadingLibrary("digest/sha1", "org.jruby.libraries.DigestLibrary$SHA1", this.getJRubyClassLoader()));
        this.registerBuiltin("digest/sha2.rb", new LateLoadingLibrary("digest/sha2", "org.jruby.libraries.DigestLibrary$SHA2", this.getJRubyClassLoader()));
        this.registerBuiltin("bigdecimal.rb", new LateLoadingLibrary("bigdecimal", "org.jruby.libraries.BigDecimalLibrary", this.getJRubyClassLoader()));
        this.registerBuiltin("io/wait.so", new LateLoadingLibrary("io/wait", "org.jruby.libraries.IOWaitLibrary", this.getJRubyClassLoader()));
        this.registerBuiltin("etc.so", new LateLoadingLibrary("etc", "org.jruby.libraries.EtcLibrary", this.getJRubyClassLoader()));
        this.registerBuiltin("weakref.rb", new LateLoadingLibrary("weakref", "org.jruby.ext.WeakRef$WeakRefLibrary", this.getJRubyClassLoader()));
        if (this.config.getCompatVersion() == CompatVersion.RUBY1_9) {
            this.registerBuiltin("fiber.so", new LateLoadingLibrary("fiber", "org.jruby.libraries.FiberLibrary", this.getJRubyClassLoader()));
        }
    }

    private void registerBuiltin(String nm, Library lib) {
        if (this.profile.allowBuiltin(nm)) {
            this.loadService.registerBuiltin(nm, lib);
        }
    }

    private void initCoreClasses() {
        this.undef = new RubyUndef();
        this.objectClass = RubyClass.createBootstrapClass(this, "Object", null, RubyObject.OBJECT_ALLOCATOR);
        this.moduleClass = RubyClass.createBootstrapClass(this, "Module", this.objectClass, RubyModule.MODULE_ALLOCATOR);
        this.classClass = RubyClass.createBootstrapClass(this, "Class", this.moduleClass, RubyClass.CLASS_ALLOCATOR);
        this.objectClass.setMetaClass(this.classClass);
        this.moduleClass.setMetaClass(this.classClass);
        this.classClass.setMetaClass(this.classClass);
        RubyClass metaClass = this.objectClass.makeMetaClass(this.classClass);
        metaClass = this.moduleClass.makeMetaClass(metaClass);
        metaClass = this.classClass.makeMetaClass(metaClass);
        RubyObject.createObjectClass(this, this.objectClass);
        RubyModule.createModuleClass(this, this.moduleClass);
        RubyClass.createClassClass(this, this.classClass);
        RubyKernel.createKernelModule(this);
        this.objectClass.includeModule(this.kernelModule);
        RubyNil.createNilClass(this);
        RubyBoolean.createFalseClass(this);
        RubyBoolean.createTrueClass(this);
        this.nilObject = new RubyNil(this);
        this.falseObject = new RubyBoolean(this, false);
        this.trueObject = new RubyBoolean(this, true);
        RubyComparable.createComparable(this);
        RubyEnumerable.createEnumerableModule(this);
        RubyString.createStringClass(this);
        RubySymbol.createSymbolClass(this);
        if (this.profile.allowClass("ThreadGroup")) {
            RubyThreadGroup.createThreadGroupClass(this);
        }
        if (this.profile.allowClass("Thread")) {
            RubyThread.createThreadClass(this);
        }
        if (this.profile.allowClass("Exception")) {
            RubyException.createExceptionClass(this);
        }
        if (this.profile.allowModule("Precision")) {
            RubyPrecision.createPrecisionModule(this);
        }
        if (this.profile.allowClass("Numeric")) {
            RubyNumeric.createNumericClass(this);
        }
        if (this.profile.allowClass("Integer")) {
            RubyInteger.createIntegerClass(this);
        }
        if (this.profile.allowClass("Fixnum")) {
            RubyFixnum.createFixnumClass(this);
        }
        if (this.profile.allowClass("Hash")) {
            RubyHash.createHashClass(this);
        }
        if (this.profile.allowClass("Array")) {
            RubyArray.createArrayClass(this);
        }
        RubyArray argvArray = this.newArray();
        for (int i = 0; i < this.argv.length; ++i) {
            argvArray.add(this.newString(this.argv[i]));
        }
        this.defineGlobalConstant("ARGV", argvArray);
        this.getGlobalVariables().defineReadonly("$*", new ValueAccessor(argvArray));
        if (this.profile.allowClass("Float")) {
            RubyFloat.createFloatClass(this);
        }
        if (this.profile.allowClass("Bignum")) {
            RubyBignum.createBignumClass(this);
        }
        this.ioClass = RubyIO.createIOClass(this);
        if (this.profile.allowClass("Struct")) {
            RubyStruct.createStructClass(this);
        }
        if (this.profile.allowClass("Tms")) {
            this.tmsStruct = RubyStruct.newInstance(this.structClass, new IRubyObject[]{this.newString("Tms"), this.newSymbol("utime"), this.newSymbol("stime"), this.newSymbol("cutime"), this.newSymbol("cstime")}, Block.NULL_BLOCK);
        }
        if (this.profile.allowClass("Binding")) {
            RubyBinding.createBindingClass(this);
        }
        if (this.profile.allowModule("Math")) {
            RubyMath.createMathModule(this);
        }
        if (this.profile.allowClass("Regexp")) {
            RubyRegexp.createRegexpClass(this);
        }
        if (this.profile.allowClass("Range")) {
            RubyRange.createRangeClass(this);
        }
        if (this.profile.allowModule("ObjectSpace")) {
            RubyObjectSpace.createObjectSpaceModule(this);
        }
        if (this.profile.allowModule("GC")) {
            RubyGC.createGCModule(this);
        }
        if (this.profile.allowClass("Proc")) {
            RubyProc.createProcClass(this);
        }
        if (this.profile.allowClass("Method")) {
            RubyMethod.createMethodClass(this);
        }
        if (this.profile.allowClass("MatchData")) {
            RubyMatchData.createMatchDataClass(this);
        }
        if (this.profile.allowModule("Marshal")) {
            RubyMarshal.createMarshalModule(this);
        }
        if (this.profile.allowClass("Dir")) {
            RubyDir.createDirClass(this);
        }
        if (this.profile.allowModule("FileTest")) {
            RubyFileTest.createFileTestModule(this);
        }
        if (this.profile.allowClass("File")) {
            RubyFile.createFileClass(this);
        }
        if (this.profile.allowClass("File::Stat")) {
            RubyFileStat.createFileStatClass(this);
        }
        if (this.profile.allowModule("Process")) {
            RubyProcess.createProcessModule(this);
        }
        if (this.profile.allowClass("Time")) {
            RubyTime.createTimeClass(this);
        }
        if (this.profile.allowClass("UnboundMethod")) {
            RubyUnboundMethod.defineUnboundMethodClass(this);
        }
        RubyClass runtimeError = null;
        RubyClass ioError = null;
        RubyClass scriptError = null;
        RubyClass nameError = null;
        RubyClass signalException = null;
        RubyClass rangeError = null;
        if (this.profile.allowClass("StandardError")) {
            this.standardError = this.defineClass("StandardError", this.exceptionClass, this.exceptionClass.getAllocator());
        }
        if (this.profile.allowClass("RuntimeError")) {
            runtimeError = this.defineClass("RuntimeError", this.standardError, this.standardError.getAllocator());
        }
        if (this.profile.allowClass("IOError")) {
            ioError = this.defineClass("IOError", this.standardError, this.standardError.getAllocator());
        }
        if (this.profile.allowClass("ScriptError")) {
            scriptError = this.defineClass("ScriptError", this.exceptionClass, this.exceptionClass.getAllocator());
        }
        if (this.profile.allowClass("NameError")) {
            nameError = RubyNameError.createNameErrorClass(this, this.standardError);
        }
        if (this.profile.allowClass("NoMethodError")) {
            RubyNoMethodError.createNoMethodErrorClass(this, nameError);
        }
        if (this.profile.allowClass("RangeError")) {
            rangeError = this.defineClass("RangeError", this.standardError, this.standardError.getAllocator());
        }
        if (this.profile.allowClass("SystemExit")) {
            RubySystemExit.createSystemExitClass(this, this.exceptionClass);
        }
        if (this.profile.allowClass("Fatal")) {
            this.defineClass("Fatal", this.exceptionClass, this.exceptionClass.getAllocator());
        }
        if (this.profile.allowClass("SignalException")) {
            signalException = this.defineClass("SignalException", this.exceptionClass, this.exceptionClass.getAllocator());
        }
        if (this.profile.allowClass("Interrupt")) {
            this.defineClass("Interrupt", signalException, signalException.getAllocator());
        }
        if (this.profile.allowClass("TypeError")) {
            this.defineClass("TypeError", this.standardError, this.standardError.getAllocator());
        }
        if (this.profile.allowClass("ArgumentError")) {
            this.defineClass("ArgumentError", this.standardError, this.standardError.getAllocator());
        }
        if (this.profile.allowClass("IndexError")) {
            this.defineClass("IndexError", this.standardError, this.standardError.getAllocator());
        }
        if (this.profile.allowClass("SyntaxError")) {
            this.defineClass("SyntaxError", scriptError, scriptError.getAllocator());
        }
        if (this.profile.allowClass("LoadError")) {
            this.defineClass("LoadError", scriptError, scriptError.getAllocator());
        }
        if (this.profile.allowClass("NotImplementedError")) {
            this.defineClass("NotImplementedError", scriptError, scriptError.getAllocator());
        }
        if (this.profile.allowClass("SecurityError")) {
            this.defineClass("SecurityError", this.standardError, this.standardError.getAllocator());
        }
        if (this.profile.allowClass("NoMemoryError")) {
            this.defineClass("NoMemoryError", this.exceptionClass, this.exceptionClass.getAllocator());
        }
        if (this.profile.allowClass("RegexpError")) {
            this.defineClass("RegexpError", this.standardError, this.standardError.getAllocator());
        }
        if (this.profile.allowClass("EOFError")) {
            this.defineClass("EOFError", ioError, ioError.getAllocator());
        }
        if (this.profile.allowClass("LocalJumpError")) {
            RubyLocalJumpError.createLocalJumpErrorClass(this, this.standardError);
        }
        if (this.profile.allowClass("ThreadError")) {
            this.defineClass("ThreadError", this.standardError, this.standardError.getAllocator());
        }
        if (this.profile.allowClass("SystemStackError")) {
            this.defineClass("SystemStackError", this.standardError, this.standardError.getAllocator());
        }
        if (this.profile.allowClass("ZeroDivisionError")) {
            this.defineClass("ZeroDivisionError", this.standardError, this.standardError.getAllocator());
        }
        if (this.profile.allowClass("FloatDomainError")) {
            this.defineClass("FloatDomainError", rangeError, rangeError.getAllocator());
        }
        if (this.profile.allowClass("NativeException")) {
            NativeException.createClass(this, runtimeError);
        }
        if (this.profile.allowClass("SystemCallError")) {
            this.systemCallError = RubySystemCallError.createSystemCallErrorClass(this, this.standardError);
        }
        if (this.profile.allowModule("Errno")) {
            this.errnoModule = this.defineModule("Errno");
        }
        this.initErrnoErrors();
        if (this.profile.allowClass("Data")) {
            this.defineClass("Data", this.objectClass, this.objectClass.getAllocator());
        }
        if (!Ruby.isSecurityRestricted() && this.profile.allowModule("Signal")) {
            RubySignal.createSignal(this);
        }
        if (this.profile.allowClass("Continuation")) {
            RubyContinuation.createContinuation(this);
        }
    }

    private void initErrnoErrors() {
        Field[] fields = IErrno.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                this.createSysErr(fields[i].getInt(IErrno.class), fields[i].getName());
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Someone defined a non-public constant in IErrno.java", e);
            }
        }
    }

    private void createSysErr(int i, String name) {
        if (this.profile.allowClass(name)) {
            this.errnoModule.defineClassUnder(name, this.systemCallError, this.systemCallError.getAllocator()).defineConstant("Errno", this.newFixnum(i));
        }
    }

    public IRubyObject getVerbose() {
        return this.verbose;
    }

    public void setVerbose(IRubyObject verbose) {
        this.verbose = verbose;
    }

    public IRubyObject getDebug() {
        return this.debug;
    }

    public void setDebug(IRubyObject debug) {
        this.debug = debug;
    }

    public JavaSupport getJavaSupport() {
        return this.javaSupport;
    }

    public JRubyClassLoader getJRubyClassLoader() {
        if (!Ruby.isSecurityRestricted() && this.jrubyClassLoader == null) {
            this.jrubyClassLoader = new JRubyClassLoader(this.config.getLoader());
        }
        return this.jrubyClassLoader;
    }

    public void defineVariable(final GlobalVariable variable) {
        this.globalVariables.define(variable.name(), new IAccessor(){

            @Override
            public IRubyObject getValue() {
                return variable.get();
            }

            @Override
            public IRubyObject setValue(IRubyObject newValue) {
                return variable.set(newValue);
            }
        });
    }

    public void defineReadonlyVariable(String name, IRubyObject value) {
        this.globalVariables.defineReadonly(name, new ValueAccessor(value));
    }

    public Node parseFile(InputStream in, String file, DynamicScope scope) {
        return this.parser.parse(file, in, scope, new ParserConfiguration(0, false, false, true));
    }

    public Node parseInline(InputStream in, String file, DynamicScope scope) {
        return this.parser.parse(file, in, scope, new ParserConfiguration(0, false, true));
    }

    public Node parseEval(String content, String file, DynamicScope scope, int lineNumber) {
        byte[] bytes;
        try {
            bytes = content.getBytes(KCode.NONE.getKCode());
        }
        catch (UnsupportedEncodingException e) {
            bytes = content.getBytes();
        }
        return this.parser.parse(file, new ByteArrayInputStream(bytes), scope, new ParserConfiguration(lineNumber, false));
    }

    public Node parse(String content, String file, DynamicScope scope, int lineNumber, boolean extraPositionInformation) {
        byte[] bytes;
        try {
            bytes = content.getBytes(KCode.NONE.getKCode());
        }
        catch (UnsupportedEncodingException e) {
            bytes = content.getBytes();
        }
        return this.parser.parse(file, new ByteArrayInputStream(bytes), scope, new ParserConfiguration(lineNumber, extraPositionInformation, false));
    }

    public Node parseEval(ByteList content, String file, DynamicScope scope, int lineNumber) {
        return this.parser.parse(file, content, scope, new ParserConfiguration(lineNumber, false));
    }

    public Node parse(ByteList content, String file, DynamicScope scope, int lineNumber, boolean extraPositionInformation) {
        return this.parser.parse(file, content, scope, new ParserConfiguration(lineNumber, extraPositionInformation, false));
    }

    public ThreadService getThreadService() {
        return this.threadService;
    }

    public ThreadContext getCurrentContext() {
        return this.threadService.getCurrentContext();
    }

    public LoadService getLoadService() {
        return this.loadService;
    }

    public RubyWarnings getWarnings() {
        return this.warnings;
    }

    public PrintStream getErrorStream() {
        return new PrintStream(new IOOutputStream(this.getGlobalVariables().get("$stderr")));
    }

    public InputStream getInputStream() {
        return new IOInputStream(this.getGlobalVariables().get("$stdin"));
    }

    public PrintStream getOutputStream() {
        return new PrintStream(new IOOutputStream(this.getGlobalVariables().get("$stdout")));
    }

    public RubyModule getClassFromPath(String path) {
        RubyModule c = this.getObject();
        if (path.length() == 0 || path.charAt(0) == '#') {
            throw this.newTypeError("can't retrieve anonymous class " + path);
        }
        int pbeg = 0;
        int p = 0;
        int l = path.length();
        while (p < l) {
            IRubyObject cc;
            while (p < l && path.charAt(p) != ':') {
                ++p;
            }
            String str = path.substring(pbeg, p);
            if (p < l && path.charAt(p) == ':') {
                if (p + 1 < l && path.charAt(p + 1) != ':') {
                    throw this.newTypeError("undefined class/module " + path.substring(pbeg, p));
                }
                pbeg = p += 2;
            }
            if (!((cc = c.getConstant(str)) instanceof RubyModule)) {
                throw this.newTypeError("" + path + " does not refer to class/module");
            }
            c = (RubyModule)cc;
        }
        return c;
    }

    public void printError(RubyException excp) {
        if (excp == null || excp.isNil()) {
            return;
        }
        ThreadContext tc = this.getCurrentContext();
        IRubyObject backtrace = excp.callMethod(tc, "backtrace");
        PrintStream errorStream = this.getErrorStream();
        if (backtrace.isNil() || !(backtrace instanceof RubyArray)) {
            if (tc.getSourceFile() != null) {
                errorStream.print(tc.getPosition());
            } else {
                errorStream.print(tc.getSourceLine());
            }
        } else if (((RubyArray)backtrace).getLength() == 0) {
            this.printErrorPos(errorStream);
        } else {
            IRubyObject mesg = ((RubyArray)backtrace).first(IRubyObject.NULL_ARRAY);
            if (mesg.isNil()) {
                this.printErrorPos(errorStream);
            } else {
                errorStream.print(mesg);
            }
        }
        RubyClass type = excp.getMetaClass();
        String info = excp.toString();
        if (type == this.fastGetClass("RuntimeError") && (info == null || info.length() == 0)) {
            errorStream.print(": unhandled exception\n");
        } else {
            String path = type.getName();
            if (info.length() == 0) {
                errorStream.print(": " + path + '\n');
            } else {
                if (path.startsWith("#")) {
                    path = null;
                }
                String tail = null;
                if (info.indexOf("\n") != -1) {
                    tail = info.substring(info.indexOf("\n") + 1);
                    info = info.substring(0, info.indexOf("\n"));
                }
                errorStream.print(": " + info);
                if (path != null) {
                    errorStream.print(" (" + path + ")\n");
                }
                if (tail != null) {
                    errorStream.print(tail + '\n');
                }
            }
        }
        excp.printBacktrace(errorStream);
    }

    private void printErrorPos(PrintStream errorStream) {
        ThreadContext tc = this.getCurrentContext();
        if (tc.getSourceFile() != null) {
            if (tc.getFrameName() != null) {
                errorStream.print(tc.getPosition());
                errorStream.print(":in '" + tc.getFrameName() + '\'');
            } else if (tc.getSourceLine() != 0) {
                errorStream.print(tc.getPosition());
            } else {
                errorStream.print(tc.getSourceFile());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(String scriptName, InputStream in, boolean wrap) {
        File f;
        if (!Ruby.isSecurityRestricted() && (f = new File(scriptName)).exists() && !f.isAbsolute() && !scriptName.startsWith("./")) {
            scriptName = "./" + scriptName;
        }
        IRubyObject self = null;
        self = wrap ? TopSelfFactory.createTopSelf(this) : this.getTopSelf();
        ThreadContext context = this.getCurrentContext();
        try {
            this.secure(4);
            context.preNodeEval(this.objectClass, self);
            Node node = this.parseFile(in, scriptName, null);
            ASTInterpreter.eval(this, context, node, self, Block.NULL_BLOCK);
        }
        catch (JumpException.ReturnJump rj) {
            return;
        }
        finally {
            context.postNodeEval();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileAndLoadFile(String filename, InputStream in, boolean wrap) {
        IRubyObject self = null;
        self = wrap ? TopSelfFactory.createTopSelf(this) : this.getTopSelf();
        ThreadContext context = this.getCurrentContext();
        try {
            this.secure(4);
            context.preNodeEval(this.objectClass, self);
            Node scriptNode = this.parseFile(in, filename, null);
            Script script = this.tryCompile(scriptNode, new JRubyClassLoader(this.jrubyClassLoader));
            if (script == null) {
                System.err.println("Error, could not compile; pass -J-Djruby.jit.logging.verbose=true for more details");
            }
            this.runScript(script);
        }
        catch (JumpException.ReturnJump rj) {
            return;
        }
        finally {
            context.postNodeEval();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadScript(Script script) {
        IRubyObject self = this.getTopSelf();
        ThreadContext context = this.getCurrentContext();
        try {
            this.secure(4);
            context.preNodeEval(this.objectClass, self);
            script.load(context, self, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
        }
        catch (JumpException.ReturnJump rj) {
            return;
        }
        finally {
            context.postNodeEval();
        }
    }

    public void addEventHook(EventHook hook) {
        this.eventHooks.add(hook);
        this.hasEventHooks = true;
    }

    public void removeEventHook(EventHook hook) {
        this.eventHooks.remove(hook);
        this.hasEventHooks = !this.eventHooks.isEmpty();
    }

    public void setTraceFunction(RubyProc traceFunction) {
        this.removeEventHook(this.callTraceFuncHook);
        if (traceFunction == null) {
            return;
        }
        this.callTraceFuncHook.setTraceFunc(traceFunction);
        this.addEventHook(this.callTraceFuncHook);
    }

    public void callEventHooks(ThreadContext context, int event, String file, int line, String name, IRubyObject type) {
        for (EventHook eventHook : this.eventHooks) {
            if (!eventHook.isInterestedInEvent(event)) continue;
            eventHook.event(context, event, file, line, name, type);
        }
    }

    public boolean hasEventHooks() {
        return this.hasEventHooks;
    }

    public GlobalVariables getGlobalVariables() {
        return this.globalVariables;
    }

    public void setGlobalVariables(GlobalVariables globalVariables) {
        this.globalVariables = globalVariables;
    }

    public CallbackFactory callbackFactory(Class<?> type) {
        return CallbackFactory.createFactory(this, type);
    }

    public IRubyObject pushExitBlock(RubyProc proc) {
        this.atExitBlocks.push(proc);
        return proc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInternalFinalizer(Finalizable finalizer) {
        Object object = this.internalFinalizersMutex;
        synchronized (object) {
            if (this.internalFinalizers == null) {
                this.internalFinalizers = new WeakHashMap<Finalizable, Object>();
            }
            this.internalFinalizers.put(finalizer, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFinalizer(Finalizable finalizer) {
        Object object = this.finalizersMutex;
        synchronized (object) {
            if (this.finalizers == null) {
                this.finalizers = new WeakHashMap<Finalizable, Object>();
            }
            this.finalizers.put(finalizer, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInternalFinalizer(Finalizable finalizer) {
        Object object = this.internalFinalizersMutex;
        synchronized (object) {
            if (this.internalFinalizers != null) {
                this.internalFinalizers.remove(finalizer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFinalizer(Finalizable finalizer) {
        Object object = this.finalizersMutex;
        synchronized (object) {
            if (this.finalizers != null) {
                this.finalizers.remove(finalizer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() {
        Iterator<Finalizable> finalIter;
        Object object;
        while (!this.atExitBlocks.empty()) {
            RubyProc proc = this.atExitBlocks.pop();
            proc.call(IRubyObject.NULL_ARRAY);
        }
        if (this.finalizers != null) {
            object = this.finalizers;
            synchronized (object) {
                finalIter = new ArrayList<Finalizable>(this.finalizers.keySet()).iterator();
                while (finalIter.hasNext()) {
                    finalIter.next().finalize();
                    finalIter.remove();
                }
            }
        }
        object = this.internalFinalizersMutex;
        synchronized (object) {
            if (this.internalFinalizers != null) {
                finalIter = new ArrayList<Finalizable>(this.internalFinalizers.keySet()).iterator();
                while (finalIter.hasNext()) {
                    finalIter.next().finalize();
                    finalIter.remove();
                }
            }
        }
    }

    public RubyArray newEmptyArray() {
        return RubyArray.newEmptyArray(this);
    }

    public RubyArray newArray() {
        return RubyArray.newArray(this);
    }

    public RubyArray newArrayLight() {
        return RubyArray.newArrayLight(this);
    }

    public RubyArray newArray(IRubyObject object) {
        return RubyArray.newArray(this, object);
    }

    public RubyArray newArray(IRubyObject car, IRubyObject cdr) {
        return RubyArray.newArray(this, car, cdr);
    }

    public RubyArray newArray(IRubyObject[] objects) {
        return RubyArray.newArray(this, objects);
    }

    public RubyArray newArrayNoCopy(IRubyObject[] objects) {
        return RubyArray.newArrayNoCopy(this, objects);
    }

    public RubyArray newArrayNoCopyLight(IRubyObject[] objects) {
        return RubyArray.newArrayNoCopyLight(this, objects);
    }

    public RubyArray newArray(List<IRubyObject> list) {
        return RubyArray.newArray(this, list);
    }

    public RubyArray newArray(int size) {
        return RubyArray.newArray(this, size);
    }

    public RubyBoolean newBoolean(boolean value) {
        return RubyBoolean.newBoolean(this, value);
    }

    public RubyFileStat newFileStat(String filename, boolean lstat) {
        return RubyFileStat.newFileStat(this, filename, lstat);
    }

    public RubyFixnum newFixnum(long value) {
        return RubyFixnum.newFixnum(this, value);
    }

    public RubyFloat newFloat(double value) {
        return RubyFloat.newFloat(this, value);
    }

    public RubyNumeric newNumeric() {
        return RubyNumeric.newNumeric(this);
    }

    public RubyProc newProc(Block.Type type, Block block) {
        if (type != Block.Type.LAMBDA && block.getProcObject() != null) {
            return block.getProcObject();
        }
        RubyProc proc = RubyProc.newProc(this, type);
        proc.callInit(IRubyObject.NULL_ARRAY, block);
        return proc;
    }

    public RubyBinding newBinding() {
        return RubyBinding.newBinding(this);
    }

    public RubyBinding newBinding(Binding binding) {
        return RubyBinding.newBinding(this, binding);
    }

    public RubyString newString() {
        return RubyString.newString(this, "");
    }

    public RubyString newString(String string) {
        return RubyString.newString(this, string);
    }

    public RubyString newString(ByteList byteList) {
        return RubyString.newString(this, byteList);
    }

    public RubyString newStringShared(ByteList byteList) {
        return RubyString.newStringShared(this, byteList);
    }

    public RubySymbol newSymbol(String name) {
        return this.symbolTable.getSymbol(name);
    }

    public RubySymbol fastNewSymbol(String internedName) {
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        return this.symbolTable.fastGetSymbol(internedName);
    }

    public RubyTime newTime(long milliseconds) {
        return RubyTime.newTime(this, milliseconds);
    }

    public RaiseException newRuntimeError(String message) {
        return this.newRaiseException(this.fastGetClass("RuntimeError"), message);
    }

    public RaiseException newArgumentError(String message) {
        return this.newRaiseException(this.fastGetClass("ArgumentError"), message);
    }

    public RaiseException newArgumentError(int got, int expected) {
        return this.newRaiseException(this.fastGetClass("ArgumentError"), "wrong # of arguments(" + got + " for " + expected + ")");
    }

    public RaiseException newErrnoEBADFError() {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("EBADF"), "Bad file descriptor");
    }

    public RaiseException newErrnoEPIPEError() {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("EPIPE"), "Broken pipe");
    }

    public RaiseException newErrnoECONNREFUSEDError() {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("ECONNREFUSED"), "Connection refused");
    }

    public RaiseException newErrnoEADDRINUSEError() {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("EADDRINUSE"), "Address in use");
    }

    public RaiseException newErrnoEINVALError() {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("EINVAL"), "Invalid file");
    }

    public RaiseException newErrnoENOENTError() {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("ENOENT"), "File not found");
    }

    public RaiseException newErrnoEACCESError(String message) {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("EACCES"), message);
    }

    public RaiseException newErrnoEAGAINError(String message) {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("EAGAIN"), message);
    }

    public RaiseException newErrnoEISDirError() {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("EISDIR"), "Is a directory");
    }

    public RaiseException newErrnoESPIPEError() {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("ESPIPE"), "Illegal seek");
    }

    public RaiseException newErrnoEBADFError(String message) {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("EBADF"), message);
    }

    public RaiseException newErrnoEINVALError(String message) {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("EINVAL"), message);
    }

    public RaiseException newErrnoENOTDIRError(String message) {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("ENOTDIR"), message);
    }

    public RaiseException newErrnoENOENTError(String message) {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("ENOENT"), message);
    }

    public RaiseException newErrnoESPIPEError(String message) {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("ESPIPE"), message);
    }

    public RaiseException newErrnoEEXISTError(String message) {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("EEXIST"), message);
    }

    public RaiseException newErrnoEDOMError(String message) {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("EDOM"), "Domain error - " + message);
    }

    public RaiseException newErrnoECHILDError() {
        return this.newRaiseException(this.fastGetModule("Errno").fastGetClass("ECHILD"), "No child processes");
    }

    public RaiseException newIndexError(String message) {
        return this.newRaiseException(this.fastGetClass("IndexError"), message);
    }

    public RaiseException newSecurityError(String message) {
        return this.newRaiseException(this.fastGetClass("SecurityError"), message);
    }

    public RaiseException newSystemCallError(String message) {
        return this.newRaiseException(this.fastGetClass("SystemCallError"), message);
    }

    public RaiseException newTypeError(String message) {
        return this.newRaiseException(this.fastGetClass("TypeError"), message);
    }

    public RaiseException newThreadError(String message) {
        return this.newRaiseException(this.fastGetClass("ThreadError"), message);
    }

    public RaiseException newSyntaxError(String message) {
        return this.newRaiseException(this.fastGetClass("SyntaxError"), message);
    }

    public RaiseException newRegexpError(String message) {
        return this.newRaiseException(this.fastGetClass("RegexpError"), message);
    }

    public RaiseException newRangeError(String message) {
        return this.newRaiseException(this.fastGetClass("RangeError"), message);
    }

    public RaiseException newNotImplementedError(String message) {
        return this.newRaiseException(this.fastGetClass("NotImplementedError"), message);
    }

    public RaiseException newInvalidEncoding(String message) {
        return this.newRaiseException(this.fastGetClass("Iconv").fastGetClass("InvalidEncoding"), message);
    }

    public RaiseException newNoMethodError(String message, String name, IRubyObject args) {
        return new RaiseException(new RubyNoMethodError(this, this.fastGetClass("NoMethodError"), message, name, args), true);
    }

    public RaiseException newNameError(String message, String name) {
        return new RaiseException(new RubyNameError(this, this.fastGetClass("NameError"), message, name), true);
    }

    public RaiseException newLocalJumpError(String reason, IRubyObject exitValue, String message) {
        return new RaiseException(new RubyLocalJumpError(this, this.fastGetClass("LocalJumpError"), message, reason, exitValue), true);
    }

    public RaiseException newLoadError(String message) {
        return this.newRaiseException(this.fastGetClass("LoadError"), message);
    }

    public RaiseException newFrozenError(String objectType) {
        return this.newRaiseException(this.fastGetClass("TypeError"), "can't modify frozen " + objectType);
    }

    public RaiseException newSystemStackError(String message) {
        return this.newRaiseException(this.fastGetClass("SystemStackError"), message);
    }

    public RaiseException newSystemExit(int status) {
        return new RaiseException(RubySystemExit.newInstance(this, status));
    }

    public RaiseException newIOError(String message) {
        return this.newRaiseException(this.fastGetClass("IOError"), message);
    }

    public RaiseException newStandardError(String message) {
        return this.newRaiseException(this.fastGetClass("StandardError"), message);
    }

    public RaiseException newIOErrorFromException(IOException ioe) {
        return this.newRaiseException(this.fastGetClass("IOError"), ioe.getMessage());
    }

    public RaiseException newTypeError(IRubyObject receivedObject, RubyClass expectedType) {
        return this.newRaiseException(this.fastGetClass("TypeError"), "wrong argument type " + receivedObject.getMetaClass().getRealClass() + " (expected " + expectedType + ")");
    }

    public RaiseException newEOFError() {
        return this.newRaiseException(this.fastGetClass("EOFError"), "End of file reached");
    }

    public RaiseException newEOFError(String message) {
        return this.newRaiseException(this.fastGetClass("EOFError"), message);
    }

    public RaiseException newZeroDivisionError() {
        return this.newRaiseException(this.fastGetClass("ZeroDivisionError"), "divided by 0");
    }

    public RaiseException newFloatDomainError(String message) {
        return this.newRaiseException(this.fastGetClass("FloatDomainError"), message);
    }

    private RaiseException newRaiseException(RubyClass exceptionClass, String message) {
        RaiseException re = new RaiseException(this, exceptionClass, message, true);
        return re;
    }

    public RubySymbol.SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public void setStackTraces(int stackTraces) {
        this.stackTraces = stackTraces;
    }

    public int getStackTraces() {
        return this.stackTraces;
    }

    public void setRandomSeed(long randomSeed) {
        this.randomSeed = randomSeed;
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    public Random getRandom() {
        return this.random;
    }

    public ObjectSpace getObjectSpace() {
        return this.objectSpace;
    }

    public Hashtable<Integer, WeakReference<IOHandler>> getIoHandlers() {
        return this.ioHandlers;
    }

    public long incrementRandomSeedSequence() {
        return this.randomSeedSequence++;
    }

    public InputStream getIn() {
        return this.in;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public PrintStream getErr() {
        return this.err;
    }

    public boolean isGlobalAbortOnExceptionEnabled() {
        return this.globalAbortOnExceptionEnabled;
    }

    public void setGlobalAbortOnExceptionEnabled(boolean enable) {
        this.globalAbortOnExceptionEnabled = enable;
    }

    public boolean isDoNotReverseLookupEnabled() {
        return this.doNotReverseLookupEnabled;
    }

    public void setDoNotReverseLookupEnabled(boolean b) {
        this.doNotReverseLookupEnabled = b;
    }

    public void registerInspecting(Object obj) {
        Map<Object, Object> val = this.inspect.get();
        if (val == null) {
            val = new IdentityHashMap<Object, Object>();
            this.inspect.set(val);
        }
        val.put(obj, null);
    }

    public boolean isInspecting(Object obj) {
        Map<Object, Object> val = this.inspect.get();
        return val == null ? false : val.containsKey(obj);
    }

    public void unregisterInspecting(Object obj) {
        Map<Object, Object> val = this.inspect.get();
        if (val != null) {
            val.remove(obj);
        }
    }

    public boolean isObjectSpaceEnabled() {
        return this.objectSpaceEnabled;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public String getJRubyHome() {
        if (this.jrubyHome == null) {
            if (Ruby.isSecurityRestricted()) {
                return "SECURITY RESTRICTED";
            }
            this.jrubyHome = this.verifyHome(SafePropertyAccessor.getProperty("jruby.home", SafePropertyAccessor.getProperty("user.home") + "/.jruby"));
        }
        try {
            return new NormalizedFile(this.jrubyHome).getCanonicalPath();
        }
        catch (IOException iOException) {
            return new NormalizedFile(this.jrubyHome).getAbsolutePath();
        }
    }

    public void setJRubyHome(String home) {
        this.jrubyHome = this.verifyHome(home);
    }

    private String verifyHome(String home) {
        NormalizedFile f;
        if (home.equals(".")) {
            home = System.getProperty("user.dir");
        }
        if (!(f = new NormalizedFile(home)).isAbsolute()) {
            home = f.getAbsolutePath();
        }
        f.mkdirs();
        return home;
    }

    public RubyInstanceConfig getInstanceConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getGlobalState() {
        Ruby ruby = this;
        synchronized (ruby) {
            return this.globalState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incGlobalState() {
        Ruby ruby = this;
        synchronized (ruby) {
            this.globalState = this.globalState + 1L & 0xFFFFFFFF8FFFFFFFL;
        }
    }

    public static boolean isSecurityRestricted() {
        return securityRestricted;
    }

    public static void setSecurityRestricted(boolean restricted) {
        securityRestricted = restricted;
    }

    public POSIX getPosix() {
        return this.posix;
    }

    private void defineGlobalVERBOSE() {
        this.getGlobalVariables().define("$VERBOSE", new IAccessor(){

            @Override
            public IRubyObject getValue() {
                return Ruby.this.getVerbose();
            }

            @Override
            public IRubyObject setValue(IRubyObject newValue) {
                if (newValue.isNil()) {
                    Ruby.this.setVerbose(newValue);
                } else {
                    Ruby.this.setVerbose(Ruby.this.newBoolean(newValue != Ruby.this.getFalse()));
                }
                return newValue;
            }
        });
    }

    private void defineGlobalDEBUG() {
        IAccessor d = new IAccessor(){

            @Override
            public IRubyObject getValue() {
                return Ruby.this.getDebug();
            }

            @Override
            public IRubyObject setValue(IRubyObject newValue) {
                if (newValue.isNil()) {
                    Ruby.this.setDebug(newValue);
                } else {
                    Ruby.this.setDebug(Ruby.this.newBoolean(newValue != Ruby.this.getFalse()));
                }
                return newValue;
            }
        };
        this.getGlobalVariables().define("$DEBUG", d);
        this.getGlobalVariables().define("$-d", d);
    }

    public void setRecordSeparatorVar(GlobalVariable recordSeparatorVar) {
        this.recordSeparatorVar = recordSeparatorVar;
    }

    public GlobalVariable getRecordSeparatorVar() {
        return this.recordSeparatorVar;
    }

    static {
        if (SafePropertyAccessor.isSecurityProtected("jruby.reflection")) {
            securityRestricted = true;
        } else {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                try {
                    sm.checkCreateClassLoader();
                }
                catch (SecurityException se) {
                    securityRestricted = true;
                }
            }
        }
    }

    public class CallTraceFuncHook
    implements EventHook {
        private RubyProc traceFunc;

        public void setTraceFunc(RubyProc traceFunc) {
            this.traceFunc = traceFunc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void event(ThreadContext context, int event, String file, int line, String name, IRubyObject type) {
            if (!context.isWithinTrace()) {
                if (file == null) {
                    file = "(ruby)";
                }
                if (type == null) {
                    type = Ruby.this.getFalse();
                }
                RubyBinding binding = RubyBinding.newBinding(Ruby.this);
                context.preTrace();
                try {
                    this.traceFunc.call(new IRubyObject[]{Ruby.this.newString(EVENT_NAMES[event]), Ruby.this.newString(file), Ruby.this.newFixnum(line + 1), name != null ? Ruby.this.newSymbol(name) : Ruby.this.getNil(), binding, type});
                }
                finally {
                    context.postTrace();
                }
            }
        }

        @Override
        public boolean isInterestedInEvent(int event) {
            return true;
        }
    }
}

