/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.joni.Analyser;
import org.joni.BitStatus;
import org.joni.CodeRangeBuffer;
import org.joni.Option;
import org.joni.ScanEnvironment;
import org.joni.UnsetAddrList;
import org.joni.ast.AnchorNode;
import org.joni.ast.BackRefNode;
import org.joni.ast.CClassNode;
import org.joni.ast.CTypeNode;
import org.joni.ast.CallNode;
import org.joni.ast.ConsAltNode;
import org.joni.ast.EncloseNode;
import org.joni.ast.Node;
import org.joni.ast.QuantifierNode;
import org.joni.ast.StringNode;

final class Compiler
extends Analyser {
    private static final int REPEAT_RANGE_ALLOC = 8;
    private static final int QUANTIFIER_EXPAND_LIMIT_SIZE = 50;

    protected Compiler(ScanEnvironment env, byte[] bytes, int p, int end) {
        super(env, bytes, p, end);
    }

    protected final void compile() {
        this.regex.state = -1;
        this.reset();
        this.regex.code = new int[(this.stop - this.p) * 2 + 1];
        this.regex.codeLength = 0;
        this.regex.numMem = 0;
        this.regex.numRepeat = 0;
        this.regex.numNullCheck = 0;
        this.regex.repeatRangeLo = null;
        this.regex.repeatRangeHi = null;
        this.regex.numCombExpCheck = 0;
        this.parse();
        if (this.env.numNamed > 0 && this.syntax.captureOnlyNamedGroup() && !Option.isCaptureGroup(this.regex.options)) {
            if (this.env.numNamed != this.env.numMem) {
                this.root = this.disableNoNameGroupCapture(this.root);
            } else {
                this.numberedRefCheck(this.root);
            }
        }
        if (this.env.numCall > 0) {
            this.env.unsetAddrList = new UnsetAddrList(this.env.numCall);
            this.setupSubExpCall(this.root);
            this.subexpRecursiveCheckTrav(this.root);
            this.subexpInfRecursiveCheckTrav(this.root);
            this.regex.numCall = this.env.numCall;
        } else {
            this.regex.numCall = 0;
        }
        this.setupTree(this.root, 0);
        this.regex.captureHistory = this.env.captureHistory;
        this.regex.btMemStart = this.env.btMemStart;
        this.regex.btMemEnd = this.env.btMemEnd;
        if (Option.isFindCondition(this.regex.options)) {
            this.regex.btMemEnd = BitStatus.bsAll();
        } else {
            this.regex.btMemEnd = this.env.btMemEnd;
            this.regex.btMemEnd |= this.regex.captureHistory;
        }
        this.regex.clearOptimizeInfo();
        this.setOptimizedInfoFromTree(this.root);
        this.env.memNodes = null;
        this.compileTree(this.root);
        this.addOpcode(1);
        this.addOpcode(0);
        if (this.env.unsetAddrList != null) {
            this.env.unsetAddrList.fix(this.regex);
            this.env.unsetAddrList = null;
        }
        this.regex.stackPopLevel = this.regex.numRepeat != 0 || this.regex.btMemEnd != 0 ? 2 : (this.regex.btMemStart != 0 ? 1 : 0);
        this.regex.state = 0;
    }

    private boolean isNeedStrLenOpExact(int op) {
        return op == 7 || op == 11 || op == 12 || op == 13 || op == 15 || op == 106;
    }

    private int selectStrOpcode(int mbLength, int strLength, boolean ignoreCase) {
        int op;
        if (ignoreCase) {
            switch (strLength) {
                case 1: {
                    op = this.enc.toLowerCaseTable() != null ? 105 : 14;
                    break;
                }
                default: {
                    op = this.enc.toLowerCaseTable() != null ? 106 : 15;
                    break;
                }
            }
        } else {
            block3 : switch (mbLength) {
                case 1: {
                    switch (strLength) {
                        case 1: {
                            op = 2;
                            break block3;
                        }
                        case 2: {
                            op = 3;
                            break block3;
                        }
                        case 3: {
                            op = 4;
                            break block3;
                        }
                        case 4: {
                            op = 5;
                            break block3;
                        }
                        case 5: {
                            op = 6;
                            break block3;
                        }
                    }
                    op = 7;
                    break;
                }
                case 2: {
                    switch (strLength) {
                        case 1: {
                            op = 8;
                            break block3;
                        }
                        case 2: {
                            op = 9;
                            break block3;
                        }
                        case 3: {
                            op = 10;
                            break block3;
                        }
                    }
                    op = 11;
                    break;
                }
                case 3: {
                    op = 12;
                }
                default: {
                    op = 13;
                }
            }
        }
        return op;
    }

    private void compileTreeEmptyCheck(Node node, int emptyInfo) {
        int savedNumNullCheck = this.regex.numNullCheck;
        if (emptyInfo != 0) {
            this.addOpcode(66);
            this.addMemNum(this.regex.numNullCheck);
            ++this.regex.numNullCheck;
        }
        this.compileTree(node);
        if (emptyInfo != 0) {
            switch (emptyInfo) {
                case 1: {
                    this.addOpcode(67);
                    break;
                }
                case 2: {
                    this.addOpcode(68);
                    break;
                }
                case 3: {
                    this.addOpcode(69);
                }
            }
            this.addMemNum(savedNumNullCheck);
        }
    }

    private void compileCall(CallNode node) {
        this.addOpcode(79);
        node.unsetAddrList.add(this.regex.codeLength, node.target);
        this.addAbsAddr(0);
    }

    private void compileTreeNTimes(Node node, int n) {
        for (int i = 0; i < n; ++i) {
            this.compileTree(node);
        }
    }

    private int addCompileStringlength(byte[] bytes, int p, int mbLength, int strLength, boolean ignoreCase) {
        int op = this.selectStrOpcode(mbLength, strLength, ignoreCase);
        int len = 1;
        if (op == 13) {
            ++len;
        }
        if (this.isNeedStrLenOpExact(op)) {
            ++len;
        }
        return len += mbLength * strLength;
    }

    private void addCompileString(byte[] bytes, int p, int mbLength, int strLength, boolean ignoreCase) {
        int op = this.selectStrOpcode(mbLength, strLength, ignoreCase);
        this.addOpcode(op);
        if (op == 13) {
            this.addLength(mbLength);
        }
        if (this.isNeedStrLenOpExact(op)) {
            if (op == 15 || op == 106) {
                this.addLength(mbLength * strLength);
            } else {
                this.addOpcode(strLength);
            }
        }
        this.regex.addBytes(bytes, p, mbLength * strLength);
    }

    private int compileLengthStringNode(Node node) {
        int prev;
        StringNode sn = (StringNode)node;
        if (sn.length() <= 0) {
            return 0;
        }
        boolean ambig = sn.isAmbig();
        int p = prev = sn.p;
        int end = sn.end;
        byte[] bytes = sn.bytes;
        int prevLen = this.enc.length(bytes[p]);
        p += prevLen;
        int slen = 1;
        int rlen = 0;
        while (p < end) {
            int len = this.enc.length(bytes[p]);
            if (len == prevLen) {
                ++slen;
            } else {
                int r = this.addCompileStringlength(bytes, prev, prevLen, slen, ambig);
                rlen += r;
                prev = p;
                slen = 1;
                prevLen = len;
            }
            p += len;
        }
        int r = this.addCompileStringlength(bytes, prev, prevLen, slen, ambig);
        return rlen += r;
    }

    private int compileLengthStringRawNode(StringNode sn) {
        if (sn.length() <= 0) {
            return 0;
        }
        return this.addCompileStringlength(sn.bytes, sn.p, 1, sn.length(), false);
    }

    private void compileStringNode(Node node) {
        int prev;
        StringNode sn = (StringNode)node;
        if (sn.length() <= 0) {
            return;
        }
        boolean ambig = sn.isAmbig();
        int p = prev = sn.p;
        int end = sn.end;
        byte[] bytes = sn.bytes;
        int prevLen = this.enc.length(bytes[p]);
        p += prevLen;
        int slen = 1;
        while (p < end) {
            int len = this.enc.length(bytes[p]);
            if (len == prevLen) {
                ++slen;
            } else {
                this.addCompileString(bytes, prev, prevLen, slen, ambig);
                prev = p;
                slen = 1;
                prevLen = len;
            }
            p += len;
        }
        this.addCompileString(bytes, prev, prevLen, slen, ambig);
    }

    private void compileStringRawNode(StringNode sn) {
        if (sn.length() <= 0) {
            return;
        }
        this.addCompileString(sn.bytes, sn.p, 1, sn.length(), false);
    }

    private void addMultiByteCClass(CodeRangeBuffer mbuf) {
        this.addLength(mbuf.used);
        this.regex.addInts(mbuf.p, mbuf.used);
    }

    private int compileLengthCClassNode(CClassNode cc) {
        int len;
        if (cc.isShare()) {
            return 2;
        }
        if (cc.mbuf == null) {
            len = 9;
        } else {
            len = this.enc.minLength() > 1 || cc.bs.isEmpty() ? 1 : 9;
            len += 1 + cc.mbuf.used;
        }
        return len;
    }

    private void compileCClassNode(CClassNode cc) {
        if (cc.isShare()) {
            this.addOpcode(22);
            this.addPointer(cc);
            return;
        }
        if (cc.mbuf == null) {
            if (cc.isNot()) {
                this.addOpcode(this.enc.isSingleByte() ? 97 : 19);
            } else {
                this.addOpcode(this.enc.isSingleByte() ? 96 : 16);
            }
            this.regex.addInts(cc.bs.bits, 8);
        } else if (this.enc.minLength() > 1 || cc.bs.isEmpty()) {
            if (cc.isNot()) {
                this.addOpcode(20);
            } else {
                this.addOpcode(17);
            }
            this.addMultiByteCClass(cc.mbuf);
        } else {
            if (cc.isNot()) {
                this.addOpcode(21);
            } else {
                this.addOpcode(18);
            }
            this.regex.addInts(cc.bs.bits, 8);
            this.addMultiByteCClass(cc.mbuf);
        }
    }

    private void entryRepeatRange(int id, int lower, int upper) {
        if (this.regex.repeatRangeLo == null) {
            this.regex.repeatRangeLo = new int[8];
            this.regex.repeatRangeHi = new int[8];
        } else if (id >= this.regex.repeatRangeLo.length) {
            int[] tmp = new int[this.regex.repeatRangeLo.length + 8];
            System.arraycopy(this.regex.repeatRangeLo, 0, tmp, 0, this.regex.repeatRangeLo.length);
            this.regex.repeatRangeLo = tmp;
            tmp = new int[this.regex.repeatRangeHi.length + 8];
            System.arraycopy(this.regex.repeatRangeHi, 0, tmp, 0, this.regex.repeatRangeHi.length);
            this.regex.repeatRangeHi = tmp;
        }
        this.regex.repeatRangeLo[id] = lower;
        this.regex.repeatRangeHi[id] = QuantifierNode.isRepeatInfinite(upper) ? Integer.MAX_VALUE : upper;
    }

    private void compileRangeRepeatNode(QuantifierNode qn, int targetLen, int emptyInfo) {
        int numRepeat = this.regex.numRepeat;
        this.addOpcode(qn.greedy ? 60 : 61);
        this.addMemNum(numRepeat);
        ++this.regex.numRepeat;
        this.addRelAddr(targetLen + 2);
        this.entryRepeatRange(numRepeat, qn.lower, qn.upper);
        this.compileTreeEmptyCheck(qn.target, emptyInfo);
        if (this.regex.numCall > 0 || qn.isInRepeat()) {
            this.addOpcode(qn.greedy ? 64 : 65);
        } else {
            this.addOpcode(qn.greedy ? 62 : 63);
        }
        this.addMemNum(numRepeat);
    }

    private static boolean cknOn(int ckn) {
        return ckn > 0;
    }

    private int compileCECLengthQuantifierNode(QuantifierNode qn) {
        int len;
        int cklen;
        boolean infinite = QuantifierNode.isRepeatInfinite(qn.upper);
        int emptyInfo = qn.targetEmptyInfo;
        int tlen = this.compileLengthTree(qn.target);
        int ckn = this.regex.numCombExpCheck > 0 ? qn.combExpCheckNum : 0;
        int n = cklen = Compiler.cknOn(ckn) ? 1 : 0;
        if (qn.target.getType() == 3 && qn.greedy && infinite) {
            if (qn.nextHeadExact != null && !Compiler.cknOn(ckn)) {
                return 2 + tlen * qn.lower + cklen;
            }
            return 1 + tlen * qn.lower + cklen;
        }
        int modTLen = emptyInfo != 0 ? tlen + 4 : tlen;
        if (infinite && qn.lower <= 1) {
            if (qn.greedy) {
                len = qn.lower == 1 ? 2 : 0;
                len += 2 + cklen + modTLen + 2;
            } else {
                len = qn.lower == 0 ? 2 : 0;
                len += modTLen + 2 + cklen;
            }
        } else if (qn.upper == 0) {
            len = qn.isRefered ? 2 + tlen : 0;
        } else if (qn.upper == 1 && qn.greedy) {
            len = qn.lower == 0 ? (Compiler.cknOn(ckn) ? 3 + tlen : 2 + tlen) : tlen;
        } else if (!qn.greedy && qn.upper == 1 && qn.lower == 0) {
            len = 2 + cklen + 2 + tlen;
        } else {
            len = 2 + modTLen + 1 + 1 + 1;
            if (Compiler.cknOn(ckn)) {
                len += 2;
            }
        }
        return len;
    }

    private void compileCECQuantifierNode(QuantifierNode qn) {
        int ckn;
        boolean infinite = QuantifierNode.isRepeatInfinite(qn.upper);
        int emptyInfo = qn.targetEmptyInfo;
        int tlen = this.compileLengthTree(qn.target);
        int n = ckn = this.regex.numCombExpCheck > 0 ? qn.combExpCheckNum : 0;
        if (qn.isAnyCharStar()) {
            this.compileTreeNTimes(qn.target, qn.lower);
            if (qn.nextHeadExact != null && !Compiler.cknOn(ckn)) {
                if (Option.isMultiline(this.regex.options)) {
                    this.addOpcode(this.enc.isSingleByte() ? 93 : 28);
                } else {
                    this.addOpcode(this.enc.isSingleByte() ? 92 : 27);
                }
                if (Compiler.cknOn(ckn)) {
                    this.addStateCheckNum(ckn);
                }
                StringNode sn = (StringNode)qn.nextHeadExact;
                this.regex.addBytes(sn.bytes, sn.p, 1);
                return;
            }
            if (Option.isMultiline(this.regex.options)) {
                if (Compiler.cknOn(ckn)) {
                    this.addOpcode(this.enc.isSingleByte() ? 95 : 85);
                } else {
                    this.addOpcode(this.enc.isSingleByte() ? 91 : 26);
                }
            } else if (Compiler.cknOn(ckn)) {
                this.addOpcode(this.enc.isSingleByte() ? 94 : 84);
            } else {
                this.addOpcode(this.enc.isSingleByte() ? 90 : 25);
            }
            if (Compiler.cknOn(ckn)) {
                this.addStateCheckNum(ckn);
            }
            return;
        }
        int modTLen = emptyInfo != 0 ? tlen + 4 : tlen;
        if (infinite && qn.lower <= 1) {
            if (qn.greedy) {
                if (qn.lower == 1) {
                    this.addOpcodeRelAddr(55, Compiler.cknOn(ckn) ? 3 : 2);
                }
                if (Compiler.cknOn(ckn)) {
                    this.addOpcode(81);
                    this.addStateCheckNum(ckn);
                    this.addRelAddr(modTLen + 2);
                } else {
                    this.addOpcodeRelAddr(56, modTLen + 2);
                }
                this.compileTreeEmptyCheck(qn.target, emptyInfo);
                this.addOpcodeRelAddr(55, -(modTLen + 2 + (Compiler.cknOn(ckn) ? 3 : 2)));
            } else {
                if (qn.lower == 0) {
                    this.addOpcodeRelAddr(55, modTLen);
                }
                this.compileTreeEmptyCheck(qn.target, emptyInfo);
                if (Compiler.cknOn(ckn)) {
                    this.addOpcode(82);
                    this.addStateCheckNum(ckn);
                    this.addRelAddr(-(modTLen + 3));
                } else {
                    this.addOpcodeRelAddr(56, -(modTLen + 2));
                }
            }
        } else if (qn.upper == 0) {
            if (qn.isRefered) {
                this.addOpcodeRelAddr(55, tlen);
                this.compileTree(qn.target);
            }
        } else if (qn.upper == 1 && qn.greedy) {
            if (qn.lower == 0) {
                if (Compiler.cknOn(ckn)) {
                    this.addOpcode(81);
                    this.addStateCheckNum(ckn);
                    this.addRelAddr(tlen);
                } else {
                    this.addOpcodeRelAddr(56, tlen);
                }
            }
            this.compileTree(qn.target);
        } else if (!qn.greedy && qn.upper == 1 && qn.lower == 0) {
            if (Compiler.cknOn(ckn)) {
                this.addOpcode(81);
                this.addStateCheckNum(ckn);
                this.addRelAddr(2);
            } else {
                this.addOpcodeRelAddr(56, 2);
            }
            this.addOpcodeRelAddr(55, tlen);
            this.compileTree(qn.target);
        } else {
            this.compileRangeRepeatNode(qn, modTLen, emptyInfo);
            if (Compiler.cknOn(ckn)) {
                this.addOpcode(83);
                this.addStateCheckNum(ckn);
            }
        }
    }

    private int compileLengthQuantifierNode(QuantifierNode qn) {
        return this.compileNonCECLengthQuantifierNode(qn);
    }

    private int compileNonCECLengthQuantifierNode(QuantifierNode qn) {
        int len;
        boolean infinite = QuantifierNode.isRepeatInfinite(qn.upper);
        int emptyInfo = qn.targetEmptyInfo;
        int tlen = this.compileLengthTree(qn.target);
        if (qn.target.getType() == 3 && qn.greedy && infinite) {
            if (qn.nextHeadExact != null) {
                return 2 + tlen * qn.lower;
            }
            return 1 + tlen * qn.lower;
        }
        int modTLen = 0;
        modTLen = emptyInfo != 0 ? tlen + 4 : tlen;
        if (infinite && (qn.lower <= 1 || tlen * qn.lower <= 50)) {
            len = qn.lower == 1 && tlen > 50 ? 2 : tlen * qn.lower;
            len = qn.greedy ? (qn.headExact != null ? (len += 3 + modTLen + 2) : (qn.nextHeadExact != null ? (len += 3 + modTLen + 2) : (len += 2 + modTLen + 2))) : (len += 2 + modTLen + 2);
        } else if (qn.upper == 0 && qn.isRefered) {
            len = 2 + tlen;
        } else if (!infinite && qn.greedy && (qn.upper == 1 || (tlen + 2) * qn.upper <= 50)) {
            len = tlen * qn.lower;
            len += (2 + tlen) * (qn.upper - qn.lower);
        } else {
            len = !qn.greedy && qn.upper == 1 && qn.lower == 0 ? 4 + tlen : 2 + modTLen + 1 + 1 + 1;
        }
        return len;
    }

    private void compileQuantifierNode(QuantifierNode qn) {
        this.compileNonCECQuantifierNode(qn);
    }

    private void compileNonCECQuantifierNode(QuantifierNode qn) {
        boolean infinite = QuantifierNode.isRepeatInfinite(qn.upper);
        int emptyInfo = qn.targetEmptyInfo;
        int tlen = this.compileLengthTree(qn.target);
        if (qn.isAnyCharStar()) {
            this.compileTreeNTimes(qn.target, qn.lower);
            if (qn.nextHeadExact != null) {
                if (Option.isMultiline(this.regex.options)) {
                    this.addOpcode(this.enc.isSingleByte() ? 93 : 28);
                } else {
                    this.addOpcode(this.enc.isSingleByte() ? 92 : 27);
                }
                StringNode sn = (StringNode)qn.nextHeadExact;
                this.regex.addBytes(sn.bytes, sn.p, 1);
                return;
            }
            if (Option.isMultiline(this.regex.options)) {
                this.addOpcode(this.enc.isSingleByte() ? 91 : 26);
            } else {
                this.addOpcode(this.enc.isSingleByte() ? 90 : 25);
            }
            return;
        }
        int modTLen = emptyInfo != 0 ? tlen + 4 : tlen;
        if (infinite && (qn.lower <= 1 || tlen * qn.lower <= 50)) {
            if (qn.lower == 1 && tlen > 50) {
                if (qn.greedy) {
                    if (qn.headExact != null) {
                        this.addOpcodeRelAddr(55, 3);
                    } else if (qn.nextHeadExact != null) {
                        this.addOpcodeRelAddr(55, 3);
                    } else {
                        this.addOpcodeRelAddr(55, 2);
                    }
                } else {
                    this.addOpcodeRelAddr(55, 2);
                }
            } else {
                this.compileTreeNTimes(qn.target, qn.lower);
            }
            if (qn.greedy) {
                if (qn.headExact != null) {
                    this.addOpcodeRelAddr(58, modTLen + 2);
                    StringNode sn = (StringNode)qn.headExact;
                    this.regex.addBytes(sn.bytes, sn.p, 1);
                    this.compileTreeEmptyCheck(qn.target, emptyInfo);
                    this.addOpcodeRelAddr(55, -(modTLen + 2 + 3));
                } else if (qn.nextHeadExact != null) {
                    this.addOpcodeRelAddr(59, modTLen + 2);
                    StringNode sn = (StringNode)qn.nextHeadExact;
                    this.regex.addBytes(sn.bytes, sn.p, 1);
                    this.compileTreeEmptyCheck(qn.target, emptyInfo);
                    this.addOpcodeRelAddr(55, -(modTLen + 2 + 3));
                } else {
                    this.addOpcodeRelAddr(56, modTLen + 2);
                    this.compileTreeEmptyCheck(qn.target, emptyInfo);
                    this.addOpcodeRelAddr(55, -(modTLen + 2 + 2));
                }
            } else {
                this.addOpcodeRelAddr(55, modTLen);
                this.compileTreeEmptyCheck(qn.target, emptyInfo);
                this.addOpcodeRelAddr(56, -(modTLen + 2));
            }
        } else if (qn.upper == 0 && qn.isRefered) {
            this.addOpcodeRelAddr(55, tlen);
            this.compileTree(qn.target);
        } else if (!infinite && qn.greedy && (qn.upper == 1 || (tlen + 2) * qn.upper <= 50)) {
            int n = qn.upper - qn.lower;
            this.compileTreeNTimes(qn.target, qn.lower);
            for (int i = 0; i < n; ++i) {
                this.addOpcodeRelAddr(56, (n - i) * tlen + (n - i - 1) * 2);
                this.compileTree(qn.target);
            }
        } else if (!qn.greedy && qn.upper == 1 && qn.lower == 0) {
            this.addOpcodeRelAddr(56, 2);
            this.addOpcodeRelAddr(55, tlen);
            this.compileTree(qn.target);
        } else {
            this.compileRangeRepeatNode(qn, modTLen, emptyInfo);
        }
    }

    private int compileLengthOptionNode(EncloseNode node) {
        int prev = this.regex.options;
        this.regex.options = node.option;
        int tlen = this.compileLengthTree(node.target);
        this.regex.options = prev;
        if (Option.isDynamic(prev ^ node.option)) {
            return 5 + tlen + 2;
        }
        return tlen;
    }

    private void compileOptionNode(EncloseNode node) {
        int prev = this.regex.options;
        if (Option.isDynamic(prev ^ node.option)) {
            this.addOpcodeOption(86, node.option);
            this.addOpcodeOption(87, prev);
            this.addOpcode(54);
        }
        this.regex.options = node.option;
        this.compileTree(node.target);
        this.regex.options = prev;
        if (Option.isDynamic(prev ^ node.option)) {
            this.addOpcodeOption(87, prev);
        }
    }

    private int compileLengthEncloseNode(EncloseNode node) {
        int len;
        if (node.isOption()) {
            return this.compileLengthOptionNode(node);
        }
        int tlen = node.target != null ? this.compileLengthTree(node.target) : 0;
        switch (node.type) {
            case 1: {
                if (node.isCalled()) {
                    len = 2 + tlen + 2 + 2 + 1;
                    if (BitStatus.bsAt(this.regex.btMemEnd, node.regNum)) {
                        len += node.isRecursion() ? 2 : 2;
                        break;
                    }
                    len += node.isRecursion() ? 2 : 2;
                    break;
                }
                len = BitStatus.bsAt(this.regex.btMemStart, node.regNum) ? 2 : 2;
                len += tlen + (BitStatus.bsAt(this.regex.btMemEnd, node.regNum) ? 2 : 2);
                break;
            }
            case 4: {
                if (node.isStopBtSimpleRepeat()) {
                    QuantifierNode qn = (QuantifierNode)node.target;
                    tlen = this.compileLengthTree(qn.target);
                    len = tlen * qn.lower + 2 + tlen + 1 + 2;
                    break;
                }
                len = 1 + tlen + 1;
                break;
            }
            default: {
                this.newInternalException("internal parser error (bug)");
                return 0;
            }
        }
        return len;
    }

    private void compileEncloseNode(EncloseNode node) {
        if (node.isOption()) {
            this.compileOptionNode(node);
            return;
        }
        switch (node.type) {
            case 1: {
                if (node.isCalled()) {
                    this.addOpcode(79);
                    node.callAddr = this.regex.codeLength + 1 + 2;
                    node.setAddrFixed();
                    this.addAbsAddr(node.callAddr);
                    int len = this.compileLengthTree(node.target);
                    len += 3;
                    len = BitStatus.bsAt(this.regex.btMemEnd, node.regNum) ? (len += node.isRecursion() ? 2 : 2) : (len += node.isRecursion() ? 2 : 2);
                    this.addOpcodeRelAddr(55, len);
                }
                if (BitStatus.bsAt(this.regex.btMemStart, node.regNum)) {
                    this.addOpcode(49);
                } else {
                    this.addOpcode(48);
                }
                this.addMemNum(node.regNum);
                this.compileTree(node.target);
                if (node.isCalled()) {
                    if (BitStatus.bsAt(this.regex.btMemEnd, node.regNum)) {
                        this.addOpcode(node.isRecursion() ? 51 : 50);
                    } else {
                        this.addOpcode(node.isRecursion() ? 53 : 52);
                    }
                    this.addMemNum(node.regNum);
                    this.addOpcode(80);
                    break;
                }
                if (BitStatus.bsAt(this.regex.btMemEnd, node.regNum)) {
                    this.addOpcode(50);
                } else {
                    this.addOpcode(52);
                }
                this.addMemNum(node.regNum);
                break;
            }
            case 4: {
                if (node.isStopBtSimpleRepeat()) {
                    QuantifierNode qn = (QuantifierNode)node.target;
                    this.compileTreeNTimes(qn.target, qn.lower);
                    int len = this.compileLengthTree(qn.target);
                    this.addOpcodeRelAddr(56, len + 1 + 2);
                    this.compileTree(qn.target);
                    this.addOpcode(57);
                    this.addOpcodeRelAddr(55, -(2 + len + 1 + 2));
                    break;
                }
                this.addOpcode(74);
                this.compileTree(node.target);
                this.addOpcode(75);
                break;
            }
            default: {
                this.newInternalException("internal parser error (bug)");
            }
        }
    }

    private int compileLengthAnchorNode(AnchorNode node) {
        int len;
        int tlen = node.target != null ? this.compileLengthTree(node.target) : 0;
        switch (node.type) {
            case 1024: {
                len = 1 + tlen + 1;
                break;
            }
            case 2048: {
                len = 2 + tlen + 1;
                break;
            }
            case 4096: {
                len = 2 + tlen;
                break;
            }
            case 8192: {
                len = 3 + tlen + 1;
                break;
            }
            default: {
                len = 1;
            }
        }
        return len;
    }

    private void compileAnchorNode(AnchorNode node) {
        switch (node.type) {
            case 1: {
                this.addOpcode(35);
                break;
            }
            case 8: {
                this.addOpcode(36);
                break;
            }
            case 2: {
                this.addOpcode(37);
                break;
            }
            case 32: {
                this.addOpcode(38);
                break;
            }
            case 16: {
                this.addOpcode(39);
                break;
            }
            case 4: {
                this.addOpcode(40);
                break;
            }
            case 64: {
                this.addOpcode(this.enc.isSingleByte() ? 100 : 31);
                break;
            }
            case 128: {
                this.addOpcode(this.enc.isSingleByte() ? 101 : 32);
                break;
            }
            case 256: {
                this.addOpcode(this.enc.isSingleByte() ? 102 : 33);
                break;
            }
            case 512: {
                this.addOpcode(this.enc.isSingleByte() ? 103 : 34);
                break;
            }
            case 1024: {
                this.addOpcode(70);
                this.compileTree(node.target);
                this.addOpcode(71);
                break;
            }
            case 2048: {
                int len = this.compileLengthTree(node.target);
                this.addOpcodeRelAddr(72, len + 1);
                this.compileTree(node.target);
                this.addOpcode(73);
                break;
            }
            case 4096: {
                int n;
                this.addOpcode(this.enc.isSingleByte() ? 104 : 76);
                if (node.charLength < 0) {
                    n = this.getCharLengthTree(node.target);
                    if (this.returnCode != 0) {
                        this.newSyntaxException("invalid pattern in look-behind");
                    }
                } else {
                    n = node.charLength;
                }
                this.addLength(n);
                this.compileTree(node.target);
                break;
            }
            case 8192: {
                int n;
                int len = this.compileLengthTree(node.target);
                this.addOpcodeRelAddr(77, len + 1);
                if (node.charLength < 0) {
                    n = this.getCharLengthTree(node.target);
                    if (this.returnCode != 0) {
                        this.newSyntaxException("invalid pattern in look-behind");
                    }
                } else {
                    n = node.charLength;
                }
                this.addLength(n);
                this.compileTree(node.target);
                this.addOpcode(78);
                break;
            }
            default: {
                this.newInternalException("internal parser error (bug)");
            }
        }
    }

    private int compileLengthTree(Node node) {
        int len = 0;
        switch (node.getType()) {
            case 8: {
                ConsAltNode lin = (ConsAltNode)node;
                do {
                    len += this.compileLengthTree(lin.car);
                } while ((lin = lin.cdr) != null);
                break;
            }
            case 9: {
                ConsAltNode aln = (ConsAltNode)node;
                int n = 0;
                do {
                    len += this.compileLengthTree(aln.car);
                    ++n;
                } while ((aln = aln.cdr) != null);
                len += 4 * (n - 1);
                break;
            }
            case 0: {
                StringNode sn = (StringNode)node;
                if (sn.isRaw()) {
                    len = this.compileLengthStringRawNode(sn);
                    break;
                }
                len = this.compileLengthStringNode(sn);
                break;
            }
            case 1: {
                len = this.compileLengthCClassNode((CClassNode)node);
                break;
            }
            case 2: 
            case 3: {
                len = 1;
                break;
            }
            case 4: {
                BackRefNode br = (BackRefNode)node;
                if (br.isNestLevel()) {
                    len = 4 + 1 * br.backNum;
                    break;
                }
                if (br.backNum == 1) {
                    len = !Option.isIgnoreCase(this.regex.options) && br.back[0] <= 2 ? 1 : 2;
                    break;
                }
                len = 2 + 1 * br.backNum;
                break;
            }
            case 10: {
                len = 2;
                break;
            }
            case 5: {
                len = this.compileLengthQuantifierNode((QuantifierNode)node);
                break;
            }
            case 6: {
                len = this.compileLengthEncloseNode((EncloseNode)node);
                break;
            }
            case 7: {
                len = this.compileLengthAnchorNode((AnchorNode)node);
                break;
            }
            default: {
                this.newInternalException("internal parser error (bug)");
            }
        }
        return len;
    }

    private void compileTree(Node node) {
        int len = 0;
        block0 : switch (node.getType()) {
            case 8: {
                ConsAltNode lin = (ConsAltNode)node;
                do {
                    this.compileTree(lin.car);
                } while ((lin = lin.cdr) != null);
                break;
            }
            case 9: {
                ConsAltNode aln = (ConsAltNode)node;
                do {
                    len += this.compileLengthTree(aln.car);
                    if (aln.cdr == null) continue;
                    len += 4;
                } while ((aln = aln.cdr) != null);
                int pos = this.regex.codeLength + len;
                aln = (ConsAltNode)node;
                do {
                    len = this.compileLengthTree(aln.car);
                    if (aln.cdr != null) {
                        this.addOpcodeRelAddr(56, len + 2);
                    }
                    this.compileTree(aln.car);
                    if (aln.cdr == null) continue;
                    len = pos - (this.regex.codeLength + 2);
                    this.addOpcodeRelAddr(55, len);
                } while ((aln = aln.cdr) != null);
                break;
            }
            case 0: {
                StringNode sn = (StringNode)node;
                if (sn.isRaw()) {
                    this.compileStringRawNode(sn);
                    break;
                }
                this.compileStringNode(sn);
                break;
            }
            case 1: {
                this.compileCClassNode((CClassNode)node);
                break;
            }
            case 2: {
                int op;
                CTypeNode cn = (CTypeNode)node;
                switch (cn.ctype) {
                    case 12: {
                        if (cn.not) {
                            op = this.enc.isSingleByte() ? 99 : 30;
                            break;
                        }
                        op = this.enc.isSingleByte() ? 98 : 29;
                        break;
                    }
                    default: {
                        this.newInternalException("internal parser error (bug)");
                        return;
                    }
                }
                this.addOpcode(op);
                break;
            }
            case 3: {
                if (Option.isMultiline(this.regex.options)) {
                    this.addOpcode(this.enc.isSingleByte() ? 89 : 24);
                    break;
                }
                this.addOpcode(this.enc.isSingleByte() ? 88 : 23);
                break;
            }
            case 4: {
                BackRefNode br = (BackRefNode)node;
                if (br.isNestLevel()) {
                    this.addOpcode(47);
                    this.addOption(this.regex.options & 1);
                    this.addLength(br.nestLevel);
                    this.addLength(br.backNum);
                    for (int i = br.backNum - 1; i >= 0; --i) {
                        this.addMemNum(br.back[i]);
                    }
                } else {
                    if (br.backNum == 1) {
                        if (Option.isIgnoreCase(this.regex.options)) {
                            this.addOpcode(44);
                            this.addMemNum(br.back[0]);
                            break;
                        }
                        switch (br.back[0]) {
                            case 1: {
                                this.addOpcode(41);
                                break block0;
                            }
                            case 2: {
                                this.addOpcode(42);
                                break block0;
                            }
                        }
                        this.addOpcode(43);
                        this.addOpcode(br.back[0]);
                        break;
                    }
                    if (Option.isIgnoreCase(this.regex.options)) {
                        this.addOpcode(46);
                    } else {
                        this.addOpcode(45);
                    }
                    this.addLength(br.backNum);
                    for (int i = br.backNum - 1; i >= 0; --i) {
                        this.addMemNum(br.back[i]);
                    }
                }
                break;
            }
            case 10: {
                this.compileCall((CallNode)node);
                break;
            }
            case 5: {
                this.compileQuantifierNode((QuantifierNode)node);
                break;
            }
            case 6: {
                this.compileEncloseNode((EncloseNode)node);
                break;
            }
            case 7: {
                this.compileAnchorNode((AnchorNode)node);
                break;
            }
            default: {
                this.newInternalException("internal parser error (bug)");
            }
        }
    }

    void addOpcode(int opcode) {
        this.regex.addInt(opcode);
        switch (opcode) {
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 70: 
            case 72: 
            case 74: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                this.regex.stackNeeded = true;
            }
        }
    }

    void addStateCheckNum(int num) {
        this.regex.addInt(num);
    }

    void addRelAddr(int addr) {
        this.regex.addInt(addr);
    }

    void addAbsAddr(int addr) {
        this.regex.addInt(addr);
    }

    void addLength(int length) {
        this.regex.addInt(length);
    }

    void addMemNum(int num) {
        this.regex.addInt(num);
    }

    void addPointer(Object o) {
        this.regex.addObject(o);
    }

    void addOption(int option) {
        this.regex.addInt(option);
    }

    void addOpcodeRelAddr(int opcode, int addr) {
        this.addOpcode(opcode);
        this.addRelAddr(addr);
    }

    void addOpcodeOption(int opcode, int option) {
        this.addOpcode(opcode);
        this.addOption(option);
    }
}

