/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.FromNativeContext;
import com.sun.jna.Native;
import com.sun.jna.NativeMapped;

public class NativeLong
extends Number
implements NativeMapped {
    public static final int SIZE = Native.LONG_SIZE;
    private final Number value;

    public NativeLong() {
        this(0L);
    }

    public NativeLong(long value) {
        if (SIZE == 4) {
            long masked = value & Integer.MIN_VALUE;
            if (masked != 0L && masked != Integer.MIN_VALUE) {
                throw new IllegalArgumentException("Argument exceeds native long capacity");
            }
            this.value = new Integer((int)(value & 0xFFFFFFFFFFFFFFFFL));
        } else {
            this.value = new Long(value);
        }
    }

    public Object toNative() {
        return this.value;
    }

    public Object fromNative(Object nativeValue, FromNativeContext context) {
        return new NativeLong(((Number)nativeValue).longValue());
    }

    public Class nativeType() {
        Class clazz = SIZE == 4 ? Integer.class : Long.class;
        return clazz;
    }

    public int intValue() {
        return this.value.intValue();
    }

    public long longValue() {
        return this.value.longValue();
    }

    public float floatValue() {
        return this.value.floatValue();
    }

    public double doubleValue() {
        return this.value.doubleValue();
    }

    public boolean equals(Object rhs) {
        return rhs instanceof NativeLong && this.value.equals(((NativeLong)rhs).value);
    }

    public String toString() {
        return this.value.toString();
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

