/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.scope;

import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;

public class NoVarsDynamicScope
extends DynamicScope {
    public NoVarsDynamicScope(StaticScope staticScope, DynamicScope parent) {
        super(staticScope, parent);
    }

    public NoVarsDynamicScope(StaticScope staticScope) {
        super(staticScope);
    }

    @Override
    public void growIfNeeded() {
        assert (this.staticScope.getNumberOfVariables() == 0) : "NoVarsDynamicScope cannot be grown; use ManyVarsDynamicScope";
    }

    @Override
    public DynamicScope cloneScope() {
        return new NoVarsDynamicScope(this.staticScope, this.parent);
    }

    @Override
    public IRubyObject[] getValues() {
        return IRubyObject.NULL_ARRAY;
    }

    @Override
    public IRubyObject getValue(int offset, int depth) {
        return this.parent.getValue(offset, depth - 1);
    }

    @Override
    public IRubyObject getValueOrNil(int offset, int depth, IRubyObject nil) {
        return this.parent.getValueOrNil(offset, depth - 1, nil);
    }

    @Override
    public IRubyObject getValueDepthZeroOrNil(int offset, IRubyObject nil) {
        assert (false) : "NoVarsDynamicScope only supports scopes with no variables";
        return null;
    }

    @Override
    public IRubyObject getValueZeroDepthZeroOrNil(IRubyObject nil) {
        assert (false) : "NoVarsDynamicScope only supports scopes with no variables";
        return null;
    }

    @Override
    public IRubyObject getValueOneDepthZeroOrNil(IRubyObject nil) {
        assert (false) : "NoVarsDynamicScope only supports scopes with no variables";
        return null;
    }

    @Override
    public void setValue(int offset, IRubyObject value, int depth) {
        this.parent.setValue(offset, value, depth - 1);
    }

    @Override
    public void setValueDepthZero(IRubyObject value, int offset) {
        throw new RuntimeException("NoVarsDynamicScope only supports scopes with no variables");
    }

    @Override
    public void setValueZeroDepthZero(IRubyObject value) {
        assert (false) : "NoVarsDynamicScope only supports scopes with no variables";
    }

    @Override
    public void setValueOneDepthZero(IRubyObject value) {
        assert (false) : "NoVarsDynamicScope only supports scopes with no variables";
    }

    @Override
    public void setArgValues(IRubyObject[] values, int size) {
        assert (size == 0) : "NoVarsDynamicScope only supports scopes with no variables";
    }

    @Override
    public IRubyObject[] getArgValues() {
        if (!this.staticScope.isArgumentScope()) {
            return this.parent.getArgValues();
        }
        int totalArgs = this.staticScope.getRequiredArgs() + this.staticScope.getOptionalArgs();
        assert (totalArgs == 0) : "NoVarsDynamicScope only supports scopes with no variables";
        return IRubyObject.NULL_ARRAY;
    }

    @Override
    public String toString(StringBuffer buf, String indent) {
        buf.append(indent).append("Static Type[" + this.hashCode() + "]: " + (this.staticScope instanceof BlockStaticScope ? "block" : "local") + " []");
        if (this.parent != null) {
            buf.append("\n");
            this.parent.toString(buf, indent + "  ");
        }
        return buf.toString();
    }
}

