/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jruby.RubyModule;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.WeakIdentityHashMap;

public class ObjectSpace {
    private ReferenceQueue deadReferences = new ReferenceQueue();
    private WeakReferenceListNode top;
    private ReferenceQueue deadIdentityReferences = new ReferenceQueue();
    private final Map identities = new HashMap();
    private final Map identitiesByObject = new WeakIdentityHashMap();
    private long maxId = 4L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long idOf(IRubyObject rubyObject) {
        Map map = this.identities;
        synchronized (map) {
            Long longId = (Long)this.identitiesByObject.get(rubyObject);
            if (longId == null) {
                longId = this.createId(rubyObject);
            }
            return longId;
        }
    }

    private Long createId(IRubyObject object) {
        this.cleanIdentities();
        this.maxId += 2L;
        Long longMaxId = new Long(this.maxId);
        this.identities.put(longMaxId, new IdReference(object, this.maxId, this.deadIdentityReferences));
        this.identitiesByObject.put(object, longMaxId);
        return longMaxId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject id2ref(long id) {
        Map map = this.identities;
        synchronized (map) {
            this.cleanIdentities();
            IdReference reference = (IdReference)this.identities.get(new Long(id));
            if (reference == null) {
                return null;
            }
            return (IRubyObject)reference.get();
        }
    }

    private void cleanIdentities() {
        IdReference ref;
        while ((ref = (IdReference)this.deadIdentityReferences.poll()) != null) {
            this.identities.remove(new Long(ref.id()));
        }
    }

    public void addFinalizer(IRubyObject object, IRubyObject proc) {
        object.addFinalizer(proc);
    }

    public void removeFinalizers(long id) {
        IRubyObject object = this.id2ref(id);
        if (object != null) {
            object.removeFinalizers();
        }
    }

    public synchronized void add(IRubyObject object) {
        this.cleanup();
        this.top = new WeakReferenceListNode(object, this.deadReferences, this.top);
    }

    public synchronized Iterator iterator(RubyModule rubyClass) {
        final ArrayList<WeakReferenceListNode> objList = new ArrayList<WeakReferenceListNode>();
        WeakReferenceListNode current = this.top;
        while (current != null) {
            IRubyObject obj = (IRubyObject)current.get();
            if (obj != null && rubyClass.isInstance(obj)) {
                objList.add(current);
            }
            current = current.nextNode;
        }
        return new Iterator(){
            private Iterator iter;
            {
                this.iter = objList.iterator();
            }

            @Override
            public boolean hasNext() {
                throw new UnsupportedOperationException();
            }

            public Object next() {
                WeakReferenceListNode node;
                Object obj = null;
                while (this.iter.hasNext() && (obj = (node = (WeakReferenceListNode)this.iter.next()).get()) == null) {
                }
                return obj;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private synchronized void cleanup() {
        WeakReferenceListNode reference;
        while ((reference = (WeakReferenceListNode)this.deadReferences.poll()) != null) {
            reference.remove();
        }
    }

    private static class IdReference
    extends WeakReference {
        private final long id;

        public IdReference(IRubyObject object, long id, ReferenceQueue queue) {
            super(object, queue);
            this.id = id;
        }

        public long id() {
            return this.id;
        }
    }

    private class WeakReferenceListNode
    extends WeakReference {
        private WeakReferenceListNode prevNode;
        private WeakReferenceListNode nextNode;

        public WeakReferenceListNode(Object ref, ReferenceQueue queue, WeakReferenceListNode next) {
            super(ref, queue);
            this.nextNode = next;
            if (next != null) {
                next.prevNode = this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            ObjectSpace objectSpace = ObjectSpace.this;
            synchronized (objectSpace) {
                if (this.prevNode != null) {
                    this.prevNode.nextNode = this.nextNode;
                } else {
                    ObjectSpace.this.top = this.nextNode;
                }
                if (this.nextNode != null) {
                    this.nextNode.prevNode = this.prevNode;
                }
            }
        }
    }
}

