/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.ObjectProxyCache;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;

public class JavaSupport {
    private static final Map<String, Class> PRIMITIVE_CLASSES = new HashMap<String, Class>();
    private final Ruby runtime;
    private final Map<String, RubyProc> exceptionHandlers = new HashMap<String, RubyProc>();
    private final ObjectProxyCache<IRubyObject, RubyClass> objectProxyCache = new ObjectProxyCache<IRubyObject, RubyClass>(ObjectProxyCache.ReferenceType.WEAK){

        @Override
        public IRubyObject allocateProxy(Object javaObject, RubyClass clazz) {
            IRubyObject proxy = clazz.allocate();
            proxy.getInstanceVariables().fastSetInstanceVariable("@java_object", JavaObject.wrap(clazz.getRuntime(), javaObject));
            return proxy;
        }
    };
    private final ConcurrentHashMap<Class, JavaClass> javaClassCache = new ConcurrentHashMap(128);
    private final Map matchCache = Collections.synchronizedMap(new HashMap(128));
    private Callback concreteProxyCallback;
    private RubyModule javaModule;
    private RubyModule javaUtilitiesModule;
    private RubyClass javaObjectClass;
    private RubyClass javaClassClass;
    private RubyClass javaArrayClass;
    private RubyClass javaProxyClass;
    private RubyModule javaInterfaceTemplate;
    private RubyModule packageModuleTemplate;
    private RubyClass arrayProxyClass;
    private RubyClass concreteProxyClass;

    public static Class getPrimitiveClass(String primitiveType) {
        return PRIMITIVE_CLASSES.get(primitiveType);
    }

    public JavaSupport(Ruby ruby) {
        this.runtime = ruby;
    }

    final synchronized void setConcreteProxyCallback(Callback concreteProxyCallback) {
        if (this.concreteProxyCallback == null) {
            this.concreteProxyCallback = concreteProxyCallback;
        }
    }

    final Callback getConcreteProxyCallback() {
        return this.concreteProxyCallback;
    }

    final Map getMatchCache() {
        return this.matchCache;
    }

    private Class loadJavaClass(String className) throws ClassNotFoundException {
        Class primitiveClass = PRIMITIVE_CLASSES.get(className);
        if (primitiveClass == null) {
            if (!Ruby.isSecurityRestricted()) {
                return Class.forName(className, true, this.runtime.getJRubyClassLoader());
            }
            return Class.forName(className);
        }
        return primitiveClass;
    }

    public Class loadJavaClassVerbose(String className) {
        try {
            return this.loadJavaClass(className);
        }
        catch (ClassNotFoundException cnfExcptn) {
            throw this.runtime.newNameError("cannot load Java class " + className, className, cnfExcptn);
        }
        catch (ExceptionInInitializerError eiie) {
            throw this.runtime.newNameError("cannot initialize Java class " + className, className, eiie);
        }
        catch (LinkageError le) {
            throw this.runtime.newNameError("cannot link Java class " + className, className, le);
        }
        catch (SecurityException se) {
            throw this.runtime.newNameError("security: cannot load Java class " + className, className, se);
        }
    }

    public Class loadJavaClassQuiet(String className) {
        try {
            return this.loadJavaClass(className);
        }
        catch (ClassNotFoundException cnfExcptn) {
            throw this.runtime.newNameError("cannot load Java class " + className, className, cnfExcptn, false);
        }
        catch (ExceptionInInitializerError eiie) {
            throw this.runtime.newNameError("cannot initialize Java class " + className, className, eiie, false);
        }
        catch (LinkageError le) {
            throw this.runtime.newNameError("cannot link Java class " + className, className, le, false);
        }
        catch (SecurityException se) {
            throw this.runtime.newNameError("security: cannot load Java class " + className, className, se, false);
        }
    }

    public JavaClass getJavaClassFromCache(Class clazz) {
        return this.javaClassCache.get(clazz);
    }

    public void putJavaClassIntoCache(JavaClass clazz) {
        this.javaClassCache.put(clazz.javaClass(), clazz);
    }

    public void defineExceptionHandler(String exceptionClass, RubyProc handler) {
        this.exceptionHandlers.put(exceptionClass, handler);
    }

    public void handleNativeException(Throwable exception) {
        Class<?> excptnClass;
        if (exception instanceof RaiseException) {
            throw (RaiseException)exception;
        }
        RubyProc handler = this.exceptionHandlers.get(excptnClass.getName());
        for (excptnClass = exception.getClass(); handler == null && excptnClass != Throwable.class; excptnClass = excptnClass.getSuperclass()) {
        }
        if (handler == null) {
            throw this.createRaiseException(exception);
        }
        handler.call(this.runtime.getCurrentContext(), new IRubyObject[]{JavaUtil.convertJavaToRuby(this.runtime, exception)});
    }

    private RaiseException createRaiseException(Throwable exception) {
        RaiseException re = RaiseException.createNativeRaiseException(this.runtime, exception);
        return re;
    }

    public ObjectProxyCache<IRubyObject, RubyClass> getObjectProxyCache() {
        return this.objectProxyCache;
    }

    public RubyModule getJavaModule() {
        if (this.javaModule == null) {
            this.javaModule = this.runtime.fastGetModule("Java");
        }
        return this.javaModule;
    }

    public RubyModule getJavaUtilitiesModule() {
        if (this.javaUtilitiesModule == null) {
            this.javaUtilitiesModule = this.runtime.fastGetModule("JavaUtilities");
        }
        return this.javaUtilitiesModule;
    }

    public RubyClass getJavaObjectClass() {
        if (this.javaObjectClass == null) {
            this.javaObjectClass = this.getJavaModule().fastGetClass("JavaObject");
        }
        return this.javaObjectClass;
    }

    public RubyClass getJavaArrayClass() {
        if (this.javaArrayClass == null) {
            this.javaArrayClass = this.getJavaModule().fastGetClass("JavaArray");
        }
        return this.javaArrayClass;
    }

    public RubyClass getJavaClassClass() {
        if (this.javaClassClass == null) {
            this.javaClassClass = this.getJavaModule().fastGetClass("JavaClass");
        }
        return this.javaClassClass;
    }

    public RubyModule getJavaInterfaceTemplate() {
        if (this.javaInterfaceTemplate == null) {
            this.javaInterfaceTemplate = this.runtime.fastGetModule("JavaInterfaceTemplate");
        }
        return this.javaInterfaceTemplate;
    }

    public RubyModule getPackageModuleTemplate() {
        if (this.packageModuleTemplate == null) {
            this.packageModuleTemplate = this.runtime.fastGetModule("JavaPackageModuleTemplate");
        }
        return this.packageModuleTemplate;
    }

    public RubyClass getJavaProxyClass() {
        if (this.javaProxyClass == null) {
            this.javaProxyClass = this.runtime.fastGetClass("JavaProxy");
        }
        return this.javaProxyClass;
    }

    public RubyClass getConcreteProxyClass() {
        if (this.concreteProxyClass == null) {
            this.concreteProxyClass = this.runtime.fastGetClass("ConcreteJavaProxy");
        }
        return this.concreteProxyClass;
    }

    public RubyClass getArrayProxyClass() {
        if (this.arrayProxyClass == null) {
            this.arrayProxyClass = this.runtime.fastGetClass("ArrayJavaProxy");
        }
        return this.arrayProxyClass;
    }

    static {
        PRIMITIVE_CLASSES.put("boolean", Boolean.TYPE);
        PRIMITIVE_CLASSES.put("byte", Byte.TYPE);
        PRIMITIVE_CLASSES.put("char", Character.TYPE);
        PRIMITIVE_CLASSES.put("short", Short.TYPE);
        PRIMITIVE_CLASSES.put("int", Integer.TYPE);
        PRIMITIVE_CLASSES.put("long", Long.TYPE);
        PRIMITIVE_CLASSES.put("float", Float.TYPE);
        PRIMITIVE_CLASSES.put("double", Double.TYPE);
    }
}

