/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaClass;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaObject
extends RubyObject {
    private static Object NULL_LOCK = new Object();
    private final Object value;

    protected JavaObject(Ruby runtime, RubyClass rubyClass, Object value) {
        super(runtime, rubyClass);
        this.value = value;
    }

    protected JavaObject(Ruby runtime, Object value) {
        this(runtime, runtime.getJavaSupport().getJavaObjectClass(), value);
    }

    public static JavaObject wrap(Ruby runtime, Object value) {
        if (value != null) {
            if (value instanceof Class) {
                return JavaClass.get(runtime, (Class)value);
            }
            if (value.getClass().isArray()) {
                return new JavaArray(runtime, value);
            }
        }
        return new JavaObject(runtime, value);
    }

    @Override
    public Class<?> getJavaClass() {
        return this.value != null ? this.value.getClass() : Void.TYPE;
    }

    public Object getValue() {
        return this.value;
    }

    public static RubyClass createJavaObjectClass(Ruby runtime, RubyModule javaModule) {
        RubyClass result = javaModule.defineClassUnder("JavaObject", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        JavaObject.registerRubyMethods(runtime, result);
        result.getMetaClass().undefineMethod("new");
        result.getMetaClass().undefineMethod("allocate");
        result.setMarshal(ObjectMarshal.NOT_MARSHALABLE_MARSHAL);
        return result;
    }

    protected static void registerRubyMethods(Ruby runtime, RubyClass result) {
        result.defineAnnotatedMethods(JavaObject.class);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof JavaObject && this.value == ((JavaObject)other).value;
    }

    @Override
    public int hashCode() {
        if (this.value != null) {
            return this.value.hashCode();
        }
        return 0;
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    @Override
    @JRubyMethod
    public IRubyObject to_s() {
        if (this.value != null) {
            String stringValue = this.value.toString();
            if (stringValue != null) {
                return RubyString.newUnicodeString(this.getRuntime(), this.value.toString());
            }
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newString("");
    }

    @JRubyMethod(name={"==", "eql?"}, required=1)
    public IRubyObject op_equal(IRubyObject other) {
        if (!(other instanceof JavaObject) && !((other = other.getInstanceVariables().fastGetInstanceVariable("@java_object")) instanceof JavaObject)) {
            return this.getRuntime().getFalse();
        }
        if (this.getValue() == null && ((JavaObject)other).getValue() == null) {
            return this.getRuntime().getTrue();
        }
        boolean isEqual = this.getValue().equals(((JavaObject)other).getValue());
        return isEqual ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"equal?"}, required=1)
    public IRubyObject same(IRubyObject other) {
        if (!(other instanceof JavaObject) && !((other = other.getInstanceVariables().fastGetInstanceVariable("@java_object")) instanceof JavaObject)) {
            return this.getRuntime().getFalse();
        }
        if (this.getValue() == null && ((JavaObject)other).getValue() == null) {
            return this.getRuntime().getTrue();
        }
        boolean isSame = this.getValue() == ((JavaObject)other).getValue();
        return isSame ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod
    public RubyString java_type() {
        return this.getRuntime().newString(this.getJavaClass().getName());
    }

    @JRubyMethod
    public IRubyObject java_class() {
        return JavaClass.get(this.getRuntime(), this.getJavaClass());
    }

    @JRubyMethod
    public RubyFixnum length() {
        throw this.getRuntime().newTypeError("not a java array");
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject aref(IRubyObject index) {
        throw this.getRuntime().newTypeError("not a java array");
    }

    @JRubyMethod(name={"[]="}, required=2)
    public IRubyObject aset(IRubyObject index, IRubyObject someValue) {
        throw this.getRuntime().newTypeError("not a java array");
    }

    @JRubyMethod(name={"fill"}, required=3)
    public IRubyObject afill(IRubyObject beginIndex, IRubyObject endIndex, IRubyObject someValue) {
        throw this.getRuntime().newTypeError("not a java array");
    }

    @JRubyMethod(name={"java_proxy?"})
    public IRubyObject is_java_proxy() {
        return this.getRuntime().getTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"synchronized"})
    public IRubyObject ruby_synchronized(ThreadContext context, Block block) {
        Object lock = this.getValue();
        Object object = lock != null ? lock : NULL_LOCK;
        synchronized (object) {
            return block.yield(context, null);
        }
    }
}

