/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaAccessibleObject;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaConstructor
extends JavaCallable {
    private final Constructor<?> constructor;
    private final Class<?>[] parameterTypes;

    public static RubyClass createJavaConstructorClass(Ruby runtime, RubyModule javaModule) {
        RubyClass result = javaModule.defineClassUnder("JavaConstructor", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(JavaConstructor.class);
        JavaAccessibleObject.registerRubyMethods(runtime, result);
        JavaCallable.registerRubyMethods(runtime, result);
        result.defineFastMethod("new_instance", callbackFactory.getFastOptMethod("new_instance"));
        result.defineFastMethod("type_parameters", callbackFactory.getFastMethod("type_parameters"));
        result.defineFastMethod("return_type", callbackFactory.getFastMethod("return_type"));
        return result;
    }

    public JavaConstructor(Ruby runtime, Constructor<?> constructor) {
        super(runtime, runtime.getJavaSupport().getJavaModule().fastGetClass("JavaConstructor"));
        this.constructor = constructor;
        this.parameterTypes = constructor.getParameterTypes();
    }

    public static JavaConstructor create(Ruby runtime, Constructor<?> constructor) {
        return new JavaConstructor(runtime, constructor);
    }

    public static JavaConstructor getMatchingConstructor(Ruby runtime, Class<?> javaClass, Class<?>[] argumentTypes) {
        try {
            return JavaConstructor.create(runtime, javaClass.getConstructor(argumentTypes));
        }
        catch (NoSuchMethodException e) {
            block2: for (Constructor<?> ctor : javaClass.getConstructors()) {
                Class<?>[] targetTypes = ctor.getParameterTypes();
                if (targetTypes.length != argumentTypes.length) continue;
                if (targetTypes.length == 0 && argumentTypes.length == 0) {
                    return JavaConstructor.create(runtime, ctor);
                }
                boolean found = true;
                for (int i = 0; i < argumentTypes.length; ++i) {
                    if (i >= targetTypes.length) {
                        found = false;
                    }
                    if (!targetTypes[i].isAssignableFrom(argumentTypes[i])) {
                        found = false;
                        continue block2;
                    }
                    found = true;
                }
                if (!found) continue;
                return JavaConstructor.create(runtime, ctor);
            }
            return null;
        }
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof JavaConstructor && this.constructor == ((JavaConstructor)other).constructor;
    }

    @Override
    public int hashCode() {
        return this.constructor.hashCode();
    }

    @Override
    public int getArity() {
        return this.parameterTypes.length;
    }

    @Override
    protected String nameOnInspection() {
        return this.getType().toString();
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public Class<?>[] getExceptionTypes() {
        return this.constructor.getExceptionTypes();
    }

    @Override
    public Type[] getGenericParameterTypes() {
        return this.constructor.getGenericParameterTypes();
    }

    @Override
    public Type[] getGenericExceptionTypes() {
        return this.constructor.getGenericExceptionTypes();
    }

    @Override
    public Annotation[][] getParameterAnnotations() {
        return this.constructor.getParameterAnnotations();
    }

    @Override
    public boolean isVarArgs() {
        return this.constructor.isVarArgs();
    }

    @Override
    public int getModifiers() {
        return this.constructor.getModifiers();
    }

    @Override
    public String toGenericString() {
        return this.constructor.toGenericString();
    }

    @Override
    protected AccessibleObject accessibleObject() {
        return this.constructor;
    }

    public IRubyObject type_parameters() {
        return Java.getInstance(this.getRuntime(), this.constructor.getTypeParameters());
    }

    public IRubyObject return_type() {
        return this.getRuntime().getNil();
    }

    public IRubyObject new_instance(IRubyObject[] args) {
        int length = args.length;
        Class<?>[] types = this.parameterTypes;
        if (length != types.length) {
            throw this.getRuntime().newArgumentError(length, types.length);
        }
        Object[] constructorArguments = new Object[length];
        int i = length;
        while (--i >= 0) {
            constructorArguments[i] = JavaUtil.convertArgument(this.getRuntime(), args[i], types[i]);
        }
        try {
            Object result = this.constructor.newInstance(constructorArguments);
            return JavaObject.wrap(this.getRuntime(), result);
        }
        catch (IllegalArgumentException iae) {
            throw this.getRuntime().newTypeError("expected " + this.argument_types().inspect() + ", got [" + constructorArguments[0].getClass().getName() + ", ...]");
        }
        catch (IllegalAccessException iae) {
            throw this.getRuntime().newTypeError("illegal access");
        }
        catch (InvocationTargetException ite) {
            this.getRuntime().getJavaSupport().handleNativeException(ite.getTargetException());
            assert (false);
            return null;
        }
        catch (InstantiationException ie) {
            throw this.getRuntime().newTypeError("can't make instance of " + this.constructor.getDeclaringClass().getName());
        }
    }
}

