/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaConstructor;
import org.jruby.javasupport.JavaField;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaSupport;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;
import org.jruby.util.ByteList;
import org.jruby.util.IdUtil;
import org.jruby.util.collections.IntHashMap;

public class JavaClass
extends JavaObject {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Method[] EMPTY_METHOD_ARRAY = new Method[0];
    private static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    private static final Map<String, AssignedName> RESERVED_NAMES = new HashMap<String, AssignedName>();
    private static final Map<String, AssignedName> STATIC_RESERVED_NAMES;
    private static final Map<String, AssignedName> INSTANCE_RESERVED_NAMES;
    private final RubyModule JAVA_UTILITIES = this.getRuntime().getJavaSupport().getJavaUtilitiesModule();
    private Map<String, AssignedName> staticAssignedNames;
    private Map<String, AssignedName> instanceAssignedNames;
    private Map<String, NamedCallback> staticCallbacks;
    private Map<String, NamedCallback> instanceCallbacks;
    private List<ConstantField> constantFields;
    private volatile RubyArray constructors;
    private volatile ArrayList<IRubyObject> proxyExtenders;
    private volatile RubyModule proxyModule;
    private volatile RubyClass proxyClass;
    private RubyModule unfinishedProxyModule;
    private RubyClass unfinishedProxyClass;
    private final ReentrantLock proxyLock = new ReentrantLock();
    private static final Pattern JAVA_PROPERTY_CHOPPER;
    private static final Pattern CAMEL_CASE_SPLITTER;
    private static final Callback __jsend_method;

    public RubyModule getProxyModule() {
        RubyModule proxy = this.proxyModule;
        if (proxy != null) {
            return proxy;
        }
        if (this.proxyLock.isHeldByCurrentThread()) {
            return this.unfinishedProxyModule;
        }
        return null;
    }

    public RubyClass getProxyClass() {
        RubyClass proxy = this.proxyClass;
        if (proxy != null) {
            return proxy;
        }
        if (this.proxyLock.isHeldByCurrentThread()) {
            return this.unfinishedProxyClass;
        }
        return null;
    }

    public void lockProxy() {
        this.proxyLock.lock();
    }

    public void unlockProxy() {
        this.proxyLock.unlock();
    }

    protected Map<String, AssignedName> getStaticAssignedNames() {
        return this.staticAssignedNames;
    }

    protected Map<String, AssignedName> getInstanceAssignedNames() {
        return this.instanceAssignedNames;
    }

    private JavaClass(Ruby runtime, Class<?> javaClass) {
        super(runtime, runtime.getJavaSupport().getJavaClassClass(), javaClass);
        if (javaClass.isInterface()) {
            this.initializeInterface(javaClass);
        } else if (!javaClass.isArray() && !javaClass.isPrimitive()) {
            this.initializeClass(javaClass);
        }
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof JavaClass && this.getValue() == ((JavaClass)other).getValue();
    }

    private void initializeInterface(Class<?> javaClass) {
        HashMap<String, AssignedName> staticNames = new HashMap<String, AssignedName>(STATIC_RESERVED_NAMES);
        ArrayList<ConstantField> constantFields = new ArrayList<ConstantField>();
        Field[] fields = EMPTY_FIELD_ARRAY;
        try {
            fields = javaClass.getDeclaredFields();
        }
        catch (SecurityException e) {
            try {
                fields = javaClass.getFields();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        int i = fields.length;
        while (--i >= 0) {
            Field field = fields[i];
            if (javaClass != field.getDeclaringClass() || !ConstantField.isConstant(field)) continue;
            constantFields.add(new ConstantField(field));
        }
        this.staticAssignedNames = staticNames;
        this.constantFields = constantFields;
    }

    private void initializeClass(Class<?> javaClass) {
        AssignedName assignedName;
        HashMap<Object, Object> instanceNames;
        HashMap<Object, Object> staticNames;
        Class<?> superclass = javaClass.getSuperclass();
        if (superclass == null) {
            staticNames = new HashMap<String, AssignedName>();
            instanceNames = new HashMap<String, AssignedName>();
        } else {
            JavaClass superJavaClass = JavaClass.get(this.getRuntime(), superclass);
            staticNames = new HashMap<String, AssignedName>(superJavaClass.getStaticAssignedNames());
            instanceNames = new HashMap<String, AssignedName>(superJavaClass.getInstanceAssignedNames());
        }
        staticNames.putAll(STATIC_RESERVED_NAMES);
        instanceNames.putAll(INSTANCE_RESERVED_NAMES);
        HashMap<String, NamedCallback> staticCallbacks = new HashMap<String, NamedCallback>();
        HashMap<String, NamedCallback> instanceCallbacks = new HashMap<String, NamedCallback>();
        ArrayList<ConstantField> constantFields = new ArrayList<ConstantField>();
        Field[] fields = EMPTY_FIELD_ARRAY;
        try {
            fields = javaClass.getFields();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        int i = fields.length;
        while (--i >= 0) {
            String setName;
            Field field = fields[i];
            if (javaClass != field.getDeclaringClass()) continue;
            if (ConstantField.isConstant(field)) {
                constantFields.add(new ConstantField(field));
                continue;
            }
            String name = field.getName();
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers)) {
                assignedName = (AssignedName)staticNames.get(name);
                if (assignedName != null && assignedName.type < 2) continue;
                staticNames.put(name, new AssignedName(name, 2));
                staticCallbacks.put(name, new StaticFieldGetter(name, field));
                if (Modifier.isFinal(modifiers)) continue;
                setName = name + '=';
                staticCallbacks.put(setName, new StaticFieldSetter(setName, field));
                continue;
            }
            assignedName = (AssignedName)instanceNames.get(name);
            if (assignedName != null && assignedName.type < 2) continue;
            instanceNames.put(name, new AssignedName(name, 2));
            instanceCallbacks.put(name, new InstanceFieldGetter(name, field));
            if (Modifier.isFinal(modifiers)) continue;
            setName = name + '=';
            instanceCallbacks.put(setName, new InstanceFieldSetter(setName, field));
        }
        Method[] methods = EMPTY_METHOD_ARRAY;
        for (Class<?> c = javaClass; c != null; c = c.getSuperclass()) {
            try {
                methods = javaClass.getMethods();
                break;
            }
            catch (SecurityException name) {
                continue;
            }
        }
        int i2 = methods.length;
        while (--i2 >= 0) {
            MethodCallback invoker;
            Method method = methods[i2];
            String name = method.getName();
            if (Modifier.isStatic(method.getModifiers())) {
                assignedName = (AssignedName)staticNames.get(name);
                if (assignedName == null) {
                    staticNames.put(name, new AssignedName(name, 1));
                } else {
                    if (assignedName.type < 1) continue;
                    if (assignedName.type != 1) {
                        staticCallbacks.remove(name);
                        staticCallbacks.remove(name + '=');
                        staticNames.put(name, new AssignedName(name, 1));
                    }
                }
                invoker = (StaticMethodInvoker)staticCallbacks.get(name);
                if (invoker == null) {
                    invoker = new StaticMethodInvoker(name);
                    staticCallbacks.put(name, invoker);
                }
                invoker.addMethod(method, javaClass);
                continue;
            }
            assignedName = (AssignedName)instanceNames.get(name);
            if (assignedName == null) {
                instanceNames.put(name, new AssignedName(name, 1));
            } else {
                if (assignedName.type < 1) continue;
                if (assignedName.type != 1) {
                    instanceCallbacks.remove(name);
                    instanceCallbacks.remove(name + '=');
                    instanceNames.put(name, new AssignedName(name, 1));
                }
            }
            invoker = (InstanceMethodInvoker)instanceCallbacks.get(name);
            if (invoker == null) {
                invoker = new InstanceMethodInvoker(name);
                instanceCallbacks.put(name, invoker);
            }
            invoker.addMethod(method, javaClass);
        }
        this.staticAssignedNames = staticNames;
        this.instanceAssignedNames = instanceNames;
        this.staticCallbacks = staticCallbacks;
        this.instanceCallbacks = instanceCallbacks;
        this.constantFields = constantFields;
    }

    public void setupProxy(RubyClass proxy) {
        assert (this.proxyLock.isHeldByCurrentThread());
        proxy.defineFastMethod("__jsend!", __jsend_method);
        Class javaClass = this.javaClass();
        if (javaClass.isInterface()) {
            this.setupInterfaceProxy(proxy);
            return;
        }
        assert (this.proxyClass == null);
        this.unfinishedProxyClass = proxy;
        if (javaClass.isArray() || javaClass.isPrimitive()) {
            this.proxyClass = proxy;
            this.proxyModule = proxy;
            return;
        }
        for (ConstantField field : this.constantFields) {
            field.install(proxy);
        }
        for (NamedCallback callback : this.staticCallbacks.values()) {
            if (callback.type == 2 && callback.hasLocalMethod()) {
                JavaClass.assignAliases((MethodCallback)callback, this.staticAssignedNames);
            }
            callback.install(proxy);
        }
        for (NamedCallback callback : this.instanceCallbacks.values()) {
            if (callback.type == 4 && callback.hasLocalMethod()) {
                JavaClass.assignAliases((MethodCallback)callback, this.instanceAssignedNames);
            }
            callback.install(proxy);
        }
        Class<?>[] classes = EMPTY_CLASS_ARRAY;
        try {
            classes = javaClass.getClasses();
        }
        catch (SecurityException callback) {
            // empty catch block
        }
        int i = classes.length;
        while (--i >= 0) {
            Class<?> clazz;
            String simpleName;
            if (javaClass != classes[i].getDeclaringClass() || (simpleName = JavaClass.getSimpleName(clazz = classes[i])).length() == 0 || !IdUtil.isConstant(simpleName) || proxy.getConstantAt(simpleName) != null) continue;
            proxy.setConstant(simpleName, Java.get_proxy_class(this.JAVA_UTILITIES, JavaClass.get(this.getRuntime(), clazz)));
        }
        this.proxyClass = proxy;
        this.proxyModule = proxy;
        this.applyProxyExtenders();
    }

    private static void assignAliases(MethodCallback callback, Map<String, AssignedName> assignedNames) {
        String name = callback.name;
        JavaClass.addUnassignedAlias(JavaClass.getRubyCasedName(name), assignedNames, callback);
        if (name.length() <= 3 && !name.startsWith("is")) {
            return;
        }
        String javaPropertyName = JavaClass.getJavaPropertyName(name);
        if (javaPropertyName == null) {
            return;
        }
        for (Method method : callback.methods) {
            String rubyName;
            Class<?>[] argTypes = method.getParameterTypes();
            Class<?> resultType = method.getReturnType();
            int argCount = argTypes.length;
            if (argCount == 0) {
                if (name.startsWith("get")) {
                    JavaClass.addUnassignedAlias(JavaClass.getRubyCasedName(name).substring(4), assignedNames, callback);
                    JavaClass.addUnassignedAlias(javaPropertyName, assignedNames, callback);
                    continue;
                }
                if (resultType != Boolean.TYPE || !name.startsWith("is")) continue;
                rubyName = JavaClass.getRubyCasedName(name).substring(3);
                if (rubyName != null) {
                    JavaClass.addUnassignedAlias(rubyName, assignedNames, callback);
                    JavaClass.addUnassignedAlias(rubyName + '?', assignedNames, callback);
                }
                if (javaPropertyName.equals(rubyName)) continue;
                JavaClass.addUnassignedAlias(javaPropertyName, assignedNames, callback);
                JavaClass.addUnassignedAlias(javaPropertyName + '?', assignedNames, callback);
                continue;
            }
            if (argCount != 1) continue;
            if (argTypes[0] == Integer.TYPE && name.startsWith("get")) {
                JavaClass.addUnassignedAlias(JavaClass.getRubyCasedName(name).substring(4), assignedNames, callback);
                JavaClass.addUnassignedAlias(javaPropertyName, assignedNames, callback);
                continue;
            }
            if (resultType != Void.TYPE || !name.startsWith("set")) continue;
            rubyName = JavaClass.getRubyCasedName(name).substring(4);
            if (rubyName != null) {
                JavaClass.addUnassignedAlias(rubyName + '=', assignedNames, callback);
            }
            if (javaPropertyName.equals(rubyName)) continue;
            JavaClass.addUnassignedAlias(javaPropertyName + '=', assignedNames, callback);
        }
    }

    private static void addUnassignedAlias(String name, Map<String, AssignedName> assignedNames, MethodCallback callback) {
        if (name != null) {
            AssignedName assignedName = assignedNames.get(name);
            if (assignedName == null) {
                callback.addAlias(name);
                assignedNames.put(name, new AssignedName(name, 5));
            } else if (assignedName.type == 5) {
                callback.addAlias(name);
            } else if (assignedName.type > 5) {
                callback.addAlias(name);
                assignedNames.put(name, new AssignedName(name, 5));
            }
        }
    }

    public static String getJavaPropertyName(String beanMethodName) {
        Matcher m = JAVA_PROPERTY_CHOPPER.matcher(beanMethodName);
        if (!m.find()) {
            return null;
        }
        String javaPropertyName = m.group(2).toLowerCase() + m.group(3);
        return javaPropertyName;
    }

    public static String getRubyCasedName(String javaCasedName) {
        Matcher m = CAMEL_CASE_SPLITTER.matcher(javaCasedName);
        String rubyCasedName = m.replaceAll("$1_$2").toLowerCase();
        if (rubyCasedName.equals(javaCasedName)) {
            return null;
        }
        return rubyCasedName;
    }

    private void setupInterfaceProxy(RubyClass proxy) {
        assert (this.javaClass().isInterface());
        assert (this.proxyLock.isHeldByCurrentThread());
        assert (this.proxyClass == null);
        this.proxyClass = proxy;
    }

    public void setupInterfaceModule(RubyModule module) {
        assert (this.javaClass().isInterface());
        assert (this.proxyLock.isHeldByCurrentThread());
        assert (this.proxyModule == null);
        this.unfinishedProxyModule = module;
        Class javaClass = this.javaClass();
        for (ConstantField field : this.constantFields) {
            field.install(module);
        }
        Class<?>[] classes = EMPTY_CLASS_ARRAY;
        try {
            classes = javaClass.getClasses();
        }
        catch (SecurityException field) {
            // empty catch block
        }
        int i = classes.length;
        while (--i >= 0) {
            Class<?> clazz;
            String simpleName;
            if (javaClass != classes[i].getDeclaringClass() || (simpleName = JavaClass.getSimpleName(clazz = classes[i])).length() == 0 || !IdUtil.isConstant(simpleName) || module.getConstantAt(simpleName) != null) continue;
            module.const_set(this.getRuntime().newString(simpleName), Java.get_proxy_class(this.JAVA_UTILITIES, JavaClass.get(this.getRuntime(), clazz)));
        }
        this.proxyModule = module;
        this.applyProxyExtenders();
    }

    public void addProxyExtender(IRubyObject extender) {
        this.lockProxy();
        try {
            if (!extender.respondsTo("extend_proxy")) {
                throw this.getRuntime().newTypeError("proxy extender must have an extend_proxy method");
            }
            if (this.proxyModule == null) {
                if (this.proxyExtenders == null) {
                    this.proxyExtenders = new ArrayList();
                }
                this.proxyExtenders.add(extender);
            } else {
                this.getRuntime().getWarnings().warn(IRubyWarnings.ID.PROXY_EXTENDED_LATE, " proxy extender added after proxy class created for " + this, new Object[0]);
                this.extendProxy(extender);
            }
        }
        finally {
            this.unlockProxy();
        }
    }

    private void applyProxyExtenders() {
        ArrayList<IRubyObject> extenders = this.proxyExtenders;
        if (extenders != null) {
            for (IRubyObject extender : extenders) {
                this.extendProxy(extender);
            }
            this.proxyExtenders = null;
        }
    }

    private void extendProxy(IRubyObject extender) {
        extender.callMethod(this.getRuntime().getCurrentContext(), "extend_proxy", this.proxyModule);
    }

    @JRubyMethod(required=1)
    public IRubyObject extend_proxy(IRubyObject extender) {
        this.addProxyExtender(extender);
        return this.getRuntime().getNil();
    }

    public static JavaClass get(Ruby runtime, Class<?> klass) {
        JavaClass javaClass = runtime.getJavaSupport().getJavaClassFromCache(klass);
        if (javaClass == null) {
            javaClass = JavaClass.createJavaClass(runtime, klass);
        }
        return javaClass;
    }

    public static RubyArray getRubyArray(Ruby runtime, Class<?>[] classes) {
        IRubyObject[] javaClasses = new IRubyObject[classes.length];
        int i = classes.length;
        while (--i >= 0) {
            javaClasses[i] = JavaClass.get(runtime, classes[i]);
        }
        return runtime.newArrayNoCopy(javaClasses);
    }

    private static synchronized JavaClass createJavaClass(Ruby runtime, Class<?> klass) {
        JavaClass javaClass = runtime.getJavaSupport().getJavaClassFromCache(klass);
        if (javaClass == null) {
            javaClass = new JavaClass(runtime, klass);
            runtime.getJavaSupport().putJavaClassIntoCache(javaClass);
        }
        return javaClass;
    }

    public static RubyClass createJavaClassClass(Ruby runtime, RubyModule javaModule) {
        RubyClass result = javaModule.defineClassUnder("JavaClass", javaModule.fastGetClass("JavaObject"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.includeModule(runtime.fastGetModule("Comparable"));
        result.defineAnnotatedMethods(JavaClass.class);
        result.getMetaClass().undefineMethod("new");
        result.getMetaClass().undefineMethod("allocate");
        return result;
    }

    public static synchronized JavaClass forNameVerbose(Ruby runtime, String className) {
        Class klass = runtime.getJavaSupport().loadJavaClassVerbose(className);
        return JavaClass.get(runtime, klass);
    }

    public static synchronized JavaClass forNameQuiet(Ruby runtime, String className) {
        Class klass = runtime.getJavaSupport().loadJavaClassQuiet(className);
        return JavaClass.get(runtime, klass);
    }

    @JRubyMethod(name={"for_name"}, required=1, meta=true)
    public static JavaClass for_name(IRubyObject recv, IRubyObject name) {
        return JavaClass.forNameVerbose(recv.getRuntime(), name.asJavaString());
    }

    @JRubyMethod
    public RubyModule ruby_class() {
        return Java.getProxyClass(this.getRuntime(), this);
    }

    @JRubyMethod(name={"public?"})
    public RubyBoolean public_p() {
        return this.getRuntime().newBoolean(Modifier.isPublic(this.javaClass().getModifiers()));
    }

    @JRubyMethod(name={"protected?"})
    public RubyBoolean protected_p() {
        return this.getRuntime().newBoolean(Modifier.isProtected(this.javaClass().getModifiers()));
    }

    @JRubyMethod(name={"private?"})
    public RubyBoolean private_p() {
        return this.getRuntime().newBoolean(Modifier.isPrivate(this.javaClass().getModifiers()));
    }

    public Class javaClass() {
        return (Class)this.getValue();
    }

    @JRubyMethod(name={"final?"})
    public RubyBoolean final_p() {
        return this.getRuntime().newBoolean(Modifier.isFinal(this.javaClass().getModifiers()));
    }

    @JRubyMethod(name={"interface?"})
    public RubyBoolean interface_p() {
        return this.getRuntime().newBoolean(this.javaClass().isInterface());
    }

    @JRubyMethod(name={"array?"})
    public RubyBoolean array_p() {
        return this.getRuntime().newBoolean(this.javaClass().isArray());
    }

    @JRubyMethod(name={"enum?"})
    public RubyBoolean enum_p() {
        return this.getRuntime().newBoolean(this.javaClass().isEnum());
    }

    @JRubyMethod(name={"annotation?"})
    public RubyBoolean annotation_p() {
        return this.getRuntime().newBoolean(this.javaClass().isAnnotation());
    }

    @JRubyMethod(name={"anonymous_class?"})
    public RubyBoolean anonymous_class_p() {
        return this.getRuntime().newBoolean(this.javaClass().isAnonymousClass());
    }

    @JRubyMethod(name={"local_class?"})
    public RubyBoolean local_class_p() {
        return this.getRuntime().newBoolean(this.javaClass().isLocalClass());
    }

    @JRubyMethod(name={"member_class?"})
    public RubyBoolean member_class_p() {
        return this.getRuntime().newBoolean(this.javaClass().isMemberClass());
    }

    @JRubyMethod(name={"synthetic?"})
    public IRubyObject synthetic_p() {
        return this.getRuntime().newBoolean(this.javaClass().isSynthetic());
    }

    @JRubyMethod(name={"name", "to_s"})
    public RubyString name() {
        return this.getRuntime().newString(this.javaClass().getName());
    }

    @JRubyMethod
    public IRubyObject canonical_name() {
        String canonicalName = this.javaClass().getCanonicalName();
        if (canonicalName != null) {
            return this.getRuntime().newString(canonicalName);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"package"})
    public IRubyObject get_package() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getPackage());
    }

    @JRubyMethod
    public IRubyObject class_loader() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getClassLoader());
    }

    @JRubyMethod
    public IRubyObject protection_domain() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getProtectionDomain());
    }

    @JRubyMethod(required=1)
    public IRubyObject resource(IRubyObject name) {
        return Java.getInstance(this.getRuntime(), this.javaClass().getResource(name.asJavaString()));
    }

    @JRubyMethod(required=1)
    public IRubyObject resource_as_stream(IRubyObject name) {
        return Java.getInstance(this.getRuntime(), this.javaClass().getResourceAsStream(name.asJavaString()));
    }

    @JRubyMethod(required=1)
    public IRubyObject resource_as_string(IRubyObject name) {
        InputStream in = this.javaClass().getResourceAsStream(name.asJavaString());
        if (in == null) {
            return this.getRuntime().getNil();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buf = new byte[4096];
            while ((len = in.read(buf)) >= 0) {
                out.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            throw this.getRuntime().newIOErrorFromException(e);
        }
        return this.getRuntime().newString(new ByteList(out.toByteArray(), false));
    }

    @JRubyMethod(required=1)
    public IRubyObject annotation(IRubyObject annoClass) {
        if (!(annoClass instanceof JavaClass)) {
            throw this.getRuntime().newTypeError(annoClass, this.getRuntime().getJavaSupport().getJavaClassClass());
        }
        return Java.getInstance(this.getRuntime(), this.javaClass().getAnnotation(((JavaClass)annoClass).javaClass()));
    }

    @JRubyMethod
    public IRubyObject annotations() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getAnnotations());
    }

    @JRubyMethod(name={"annotations?"})
    public RubyBoolean annotations_p() {
        return this.getRuntime().newBoolean(this.javaClass().getAnnotations().length > 0);
    }

    @JRubyMethod
    public IRubyObject declared_annotations() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getDeclaredAnnotations());
    }

    @JRubyMethod(name={"declared_annotations?"})
    public RubyBoolean declared_annotations_p() {
        return this.getRuntime().newBoolean(this.javaClass().getDeclaredAnnotations().length > 0);
    }

    @JRubyMethod(name={"annotation_present?"}, required=1)
    public IRubyObject annotation_present_p(IRubyObject annoClass) {
        if (!(annoClass instanceof JavaClass)) {
            throw this.getRuntime().newTypeError(annoClass, this.getRuntime().getJavaSupport().getJavaClassClass());
        }
        return this.getRuntime().newBoolean(this.javaClass().isAnnotationPresent(((JavaClass)annoClass).javaClass()));
    }

    @JRubyMethod
    public IRubyObject modifiers() {
        return this.getRuntime().newFixnum(this.javaClass().getModifiers());
    }

    @JRubyMethod
    public IRubyObject declaring_class() {
        Class<?> clazz = this.javaClass().getDeclaringClass();
        if (clazz != null) {
            return JavaClass.get(this.getRuntime(), clazz);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject enclosing_class() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getEnclosingClass());
    }

    @JRubyMethod
    public IRubyObject enclosing_constructor() {
        Constructor<?> ctor = this.javaClass().getEnclosingConstructor();
        if (ctor != null) {
            return new JavaConstructor(this.getRuntime(), ctor);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject enclosing_method() {
        Method meth = this.javaClass().getEnclosingMethod();
        if (meth != null) {
            return new JavaMethod(this.getRuntime(), meth);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject enum_constants() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getEnumConstants());
    }

    @JRubyMethod
    public IRubyObject generic_interfaces() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getGenericInterfaces());
    }

    @JRubyMethod
    public IRubyObject generic_superclass() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getGenericSuperclass());
    }

    @JRubyMethod
    public IRubyObject type_parameters() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getTypeParameters());
    }

    @JRubyMethod
    public IRubyObject signers() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getSigners());
    }

    private static String getSimpleName(Class<?> clazz) {
        if (clazz.isArray()) {
            return JavaClass.getSimpleName(clazz.getComponentType()) + "[]";
        }
        String className = clazz.getName();
        int len = className.length();
        int i = className.lastIndexOf(36);
        if (i != -1) {
            while (++i < len && Character.isDigit(className.charAt(i))) {
            }
            return className.substring(i);
        }
        return className.substring(className.lastIndexOf(46) + 1);
    }

    @JRubyMethod
    public RubyString simple_name() {
        return this.getRuntime().newString(JavaClass.getSimpleName(this.javaClass()));
    }

    @JRubyMethod
    public IRubyObject superclass() {
        Class superclass = this.javaClass().getSuperclass();
        if (superclass == null) {
            return this.getRuntime().getNil();
        }
        return JavaClass.get(this.getRuntime(), superclass);
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public RubyFixnum op_cmp(IRubyObject other) {
        if (!(other instanceof JavaClass)) {
            throw this.getRuntime().newTypeError("<=> requires JavaClass (" + other.getType() + " given)");
        }
        JavaClass otherClass = (JavaClass)other;
        if (this.javaClass() == otherClass.javaClass()) {
            return this.getRuntime().newFixnum(0L);
        }
        if (otherClass.javaClass().isAssignableFrom(this.javaClass())) {
            return this.getRuntime().newFixnum(-1L);
        }
        return this.getRuntime().newFixnum(1L);
    }

    @JRubyMethod
    public RubyArray java_instance_methods() {
        return this.java_methods(this.javaClass().getMethods(), false);
    }

    @JRubyMethod
    public RubyArray declared_instance_methods() {
        return this.java_methods(this.javaClass().getDeclaredMethods(), false);
    }

    private RubyArray java_methods(Method[] methods, boolean isStatic) {
        RubyArray result = this.getRuntime().newArray(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (isStatic != Modifier.isStatic(method.getModifiers())) continue;
            result.append(JavaMethod.create(this.getRuntime(), method));
        }
        return result;
    }

    @JRubyMethod
    public RubyArray java_class_methods() {
        return this.java_methods(this.javaClass().getMethods(), true);
    }

    @JRubyMethod
    public RubyArray declared_class_methods() {
        return this.java_methods(this.javaClass().getDeclaredMethods(), true);
    }

    @JRubyMethod(required=1, rest=true)
    public JavaMethod java_method(IRubyObject[] args) throws ClassNotFoundException {
        String methodName = args[0].asJavaString();
        Class<?>[] argumentTypes = this.buildArgumentTypes(args);
        return JavaMethod.create(this.getRuntime(), this.javaClass(), methodName, argumentTypes);
    }

    @JRubyMethod(required=1, rest=true)
    public JavaMethod declared_method(IRubyObject[] args) throws ClassNotFoundException {
        String methodName = args[0].asJavaString();
        Class<?>[] argumentTypes = this.buildArgumentTypes(args);
        return JavaMethod.createDeclared(this.getRuntime(), this.javaClass(), methodName, argumentTypes);
    }

    @JRubyMethod(required=1, rest=true)
    public JavaCallable declared_method_smart(IRubyObject[] args) throws ClassNotFoundException {
        String methodName = args[0].asJavaString();
        Class<?>[] argumentTypes = this.buildArgumentTypes(args);
        JavaCallable callable = JavaClass.getMatchingCallable(this.getRuntime(), this.javaClass(), methodName, argumentTypes);
        if (callable != null) {
            return callable;
        }
        throw this.getRuntime().newNameError("undefined method '" + methodName + "' for class '" + this.javaClass().getName() + "'", methodName);
    }

    public static JavaCallable getMatchingCallable(Ruby runtime, Class<?> javaClass, String methodName, Class<?>[] argumentTypes) {
        if ("<init>".equals(methodName)) {
            return JavaConstructor.getMatchingConstructor(runtime, javaClass, argumentTypes);
        }
        return JavaMethod.getMatchingDeclaredMethod(runtime, javaClass, methodName, argumentTypes);
    }

    private Class<?>[] buildArgumentTypes(IRubyObject[] args) throws ClassNotFoundException {
        if (args.length < 1) {
            throw this.getRuntime().newArgumentError(args.length, 1);
        }
        Class[] argumentTypes = new Class[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            JavaClass type = args[i] instanceof JavaClass ? (JavaClass)args[i] : (args[i].respondsTo("java_class") ? (JavaClass)args[i].callMethod(this.getRuntime().getCurrentContext(), "java_class") : JavaClass.for_name(this, args[i]));
            argumentTypes[i - 1] = type.javaClass();
        }
        return argumentTypes;
    }

    @JRubyMethod
    public RubyArray constructors() {
        RubyArray ctors = this.constructors;
        if (ctors != null) {
            return ctors;
        }
        this.constructors = this.buildConstructors(this.javaClass().getConstructors());
        return this.constructors;
    }

    @JRubyMethod
    public RubyArray classes() {
        return JavaClass.getRubyArray(this.getRuntime(), this.javaClass().getClasses());
    }

    @JRubyMethod
    public RubyArray declared_classes() {
        Ruby runtime = this.getRuntime();
        RubyArray result = runtime.newArray();
        Class javaClass = this.javaClass();
        try {
            Class<?>[] classes = javaClass.getDeclaredClasses();
            for (int i = 0; i < classes.length; ++i) {
                if (!Modifier.isPublic(classes[i].getModifiers())) continue;
                result.append(JavaClass.get(runtime, classes[i]));
            }
        }
        catch (SecurityException e) {
            try {
                Class<?>[] classes = javaClass.getClasses();
                for (int i = 0; i < classes.length; ++i) {
                    if (javaClass != classes[i].getDeclaringClass()) continue;
                    result.append(JavaClass.get(runtime, classes[i]));
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return result;
    }

    @JRubyMethod
    public RubyArray declared_constructors() {
        return this.buildConstructors(this.javaClass().getDeclaredConstructors());
    }

    private RubyArray buildConstructors(Constructor<?>[] constructors) {
        RubyArray result = this.getRuntime().newArray(constructors.length);
        for (int i = 0; i < constructors.length; ++i) {
            result.append(new JavaConstructor(this.getRuntime(), constructors[i]));
        }
        return result;
    }

    @JRubyMethod(rest=true)
    public JavaConstructor constructor(IRubyObject[] args) {
        try {
            Class<?>[] parameterTypes = this.buildClassArgs(args);
            Constructor constructor = this.javaClass().getConstructor(parameterTypes);
            return new JavaConstructor(this.getRuntime(), constructor);
        }
        catch (NoSuchMethodException nsme) {
            throw this.getRuntime().newNameError("no matching java constructor", null);
        }
    }

    @JRubyMethod(rest=true)
    public JavaConstructor declared_constructor(IRubyObject[] args) {
        try {
            Class<?>[] parameterTypes = this.buildClassArgs(args);
            Constructor constructor = this.javaClass().getDeclaredConstructor(parameterTypes);
            return new JavaConstructor(this.getRuntime(), constructor);
        }
        catch (NoSuchMethodException nsme) {
            throw this.getRuntime().newNameError("no matching java constructor", null);
        }
    }

    private Class<?>[] buildClassArgs(IRubyObject[] args) {
        JavaSupport javaSupport = this.getRuntime().getJavaSupport();
        Class[] parameterTypes = new Class[args.length];
        int i = args.length;
        while (--i >= 0) {
            String name = args[i].asJavaString();
            parameterTypes[i] = javaSupport.loadJavaClassVerbose(name);
        }
        return parameterTypes;
    }

    @JRubyMethod
    public JavaClass array_class() {
        return JavaClass.get(this.getRuntime(), Array.newInstance(this.javaClass(), 0).getClass());
    }

    @JRubyMethod(required=1)
    public JavaObject new_array(IRubyObject lengthArgument) {
        if (lengthArgument instanceof RubyInteger) {
            int length = (int)((RubyInteger)lengthArgument).getLongValue();
            return new JavaArray(this.getRuntime(), Array.newInstance(this.javaClass(), length));
        }
        if (lengthArgument instanceof RubyArray) {
            List list = ((RubyArray)lengthArgument).getList();
            int length = list.size();
            if (length == 0) {
                throw this.getRuntime().newArgumentError("empty dimensions specifier for java array");
            }
            int[] dimensions = new int[length];
            int i = length;
            while (--i >= 0) {
                IRubyObject dimensionLength = (IRubyObject)list.get(i);
                if (!(dimensionLength instanceof RubyInteger)) {
                    throw this.getRuntime().newTypeError(dimensionLength, this.getRuntime().getInteger());
                }
                dimensions[i] = (int)((RubyInteger)dimensionLength).getLongValue();
            }
            return new JavaArray(this.getRuntime(), Array.newInstance(this.javaClass(), dimensions));
        }
        throw this.getRuntime().newArgumentError("invalid length or dimensions specifier for java array - must be Integer or Array of Integer");
    }

    @JRubyMethod
    public RubyArray fields() {
        return this.buildFieldResults(this.javaClass().getFields());
    }

    @JRubyMethod
    public RubyArray declared_fields() {
        return this.buildFieldResults(this.javaClass().getDeclaredFields());
    }

    private RubyArray buildFieldResults(Field[] fields) {
        RubyArray result = this.getRuntime().newArray(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            result.append(new JavaField(this.getRuntime(), fields[i]));
        }
        return result;
    }

    @JRubyMethod(required=1)
    public JavaField field(IRubyObject name) {
        String stringName = name.asJavaString();
        try {
            Field field = this.javaClass().getField(stringName);
            return new JavaField(this.getRuntime(), field);
        }
        catch (NoSuchFieldException nsfe) {
            throw this.undefinedFieldError(stringName);
        }
    }

    @JRubyMethod(required=1)
    public JavaField declared_field(IRubyObject name) {
        String stringName = name.asJavaString();
        try {
            Field field = this.javaClass().getDeclaredField(stringName);
            return new JavaField(this.getRuntime(), field);
        }
        catch (NoSuchFieldException nsfe) {
            throw this.undefinedFieldError(stringName);
        }
    }

    private RaiseException undefinedFieldError(String name) {
        return this.getRuntime().newNameError("undefined field '" + name + "' for class '" + this.javaClass().getName() + "'", name);
    }

    @JRubyMethod
    public RubyArray interfaces() {
        return JavaClass.getRubyArray(this.getRuntime(), this.javaClass().getInterfaces());
    }

    @JRubyMethod(name={"primitive?"})
    public RubyBoolean primitive_p() {
        return this.getRuntime().newBoolean(this.isPrimitive());
    }

    @JRubyMethod(name={"assignable_from?"}, required=1)
    public RubyBoolean assignable_from_p(IRubyObject other) {
        if (!(other instanceof JavaClass)) {
            throw this.getRuntime().newTypeError("assignable_from requires JavaClass (" + other.getType() + " given)");
        }
        Class otherClass = ((JavaClass)other).javaClass();
        return JavaClass.assignable(this.javaClass(), otherClass) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    static boolean assignable(Class<?> thisClass, Class<?> otherClass) {
        if (!thisClass.isPrimitive() && otherClass == Void.TYPE || thisClass.isAssignableFrom(otherClass)) {
            return true;
        }
        otherClass = JavaUtil.primitiveToWrapper(otherClass);
        if ((thisClass = JavaUtil.primitiveToWrapper(thisClass)).isAssignableFrom(otherClass)) {
            return true;
        }
        if (Number.class.isAssignableFrom(thisClass)) {
            if (Number.class.isAssignableFrom(otherClass)) {
                return true;
            }
            if (otherClass.equals(Character.class)) {
                return true;
            }
        }
        return thisClass.equals(Character.class) && Number.class.isAssignableFrom(otherClass);
    }

    private boolean isPrimitive() {
        return this.javaClass().isPrimitive();
    }

    @JRubyMethod
    public JavaClass component_type() {
        if (!this.javaClass().isArray()) {
            throw this.getRuntime().newTypeError("not a java array-class");
        }
        return JavaClass.get(this.getRuntime(), this.javaClass().getComponentType());
    }

    static {
        RESERVED_NAMES.put("__id__", new AssignedName("__id__", 0));
        RESERVED_NAMES.put("__send__", new AssignedName("__send__", 0));
        RESERVED_NAMES.put("class", new AssignedName("class", 0));
        RESERVED_NAMES.put("initialize", new AssignedName("initialize", 0));
        RESERVED_NAMES.put("object_id", new AssignedName("object_id", 0));
        RESERVED_NAMES.put("private", new AssignedName("private", 0));
        RESERVED_NAMES.put("protected", new AssignedName("protected", 0));
        RESERVED_NAMES.put("public", new AssignedName("public", 0));
        RESERVED_NAMES.put("id", new AssignedName("id", 4));
        STATIC_RESERVED_NAMES = new HashMap<String, AssignedName>(RESERVED_NAMES);
        STATIC_RESERVED_NAMES.put("new", new AssignedName("new", 0));
        INSTANCE_RESERVED_NAMES = new HashMap<String, AssignedName>(RESERVED_NAMES);
        JAVA_PROPERTY_CHOPPER = Pattern.compile("(get|set|is)([A-Z0-9])(.*)");
        CAMEL_CASE_SPLITTER = Pattern.compile("([a-z][0-9]*)([A-Z])");
        __jsend_method = new Callback(){

            @Override
            public IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
                String name = args[0].asJavaString();
                DynamicMethod method = self.getMetaClass().searchMethod(name);
                int v = method.getArity().getValue();
                IRubyObject[] newArgs = new IRubyObject[args.length - 1];
                System.arraycopy(args, 1, newArgs, 0, newArgs.length);
                if (v < 0 || v == newArgs.length) {
                    return RuntimeHelpers.invoke(self.getRuntime().getCurrentContext(), self, name, newArgs, CallType.FUNCTIONAL, block);
                }
                RubyClass superClass = self.getMetaClass().getSuperClass();
                return RuntimeHelpers.invokeAs(self.getRuntime().getCurrentContext(), superClass, self, name, newArgs, CallType.SUPER, block);
            }

            @Override
            public Arity getArity() {
                return Arity.optional();
            }
        };
    }

    private static class ConstantField {
        static final int CONSTANT = 25;
        final Field field;

        ConstantField(Field field) {
            this.field = field;
        }

        void install(RubyModule proxy) {
            if (proxy.fastGetConstantAt(this.field.getName()) == null) {
                JavaField javaField = new JavaField(proxy.getRuntime(), this.field);
                proxy.const_set(javaField.name(), Java.java_to_ruby(proxy, javaField.static_value(), Block.NULL_BLOCK));
            }
        }

        static boolean isConstant(Field field) {
            return (field.getModifiers() & 0x19) == 25 && Character.isUpperCase(field.getName().charAt(0));
        }
    }

    private class InstanceMethodInvoker
    extends MethodCallback {
        InstanceMethodInvoker() {
        }

        InstanceMethodInvoker(String name) {
            super(name, 4);
        }

        @Override
        void install(RubyClass proxy) {
            if (this.hasLocalMethod()) {
                proxy.defineFastMethod(this.name, this, this.visibility);
                if (this.aliases != null && this.isPublic()) {
                    proxy.defineAliases(this.aliases, this.name);
                    this.aliases = null;
                }
            }
        }

        @Override
        public synchronized IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
            this.createJavaMethods(self.getRuntime());
            int len = args.length;
            if (block.isGiven()) {
                ++len;
                IRubyObject[] newArgs = new IRubyObject[args.length + 1];
                System.arraycopy(args, 0, newArgs, 0, args.length);
                newArgs[args.length] = RubyProc.newProc(self.getRuntime(), block, Block.Type.LAMBDA);
                args = newArgs;
            }
            IRubyObject[] convertedArgs = new IRubyObject[len + 1];
            convertedArgs[0] = self.getInstanceVariables().fastGetInstanceVariable("@java_object");
            int i = len;
            if (block.isGiven()) {
                convertedArgs[len] = args[len - 1];
                --i;
            }
            while (--i >= 0) {
                convertedArgs[i + 1] = Java.ruby_to_java(self, args[i], Block.NULL_BLOCK);
            }
            if (this.javaMethods == null) {
                return Java.java_to_ruby(self, this.javaMethod.invoke(convertedArgs), Block.NULL_BLOCK);
            }
            int argsTypeHash = 0;
            i = len;
            while (--i >= 0) {
                argsTypeHash += 3 * args[i].getMetaClass().id;
            }
            IRubyObject match = (IRubyObject)this.matchingMethods.get(argsTypeHash);
            if (match == null) {
                RubyArray methods = (RubyArray)this.javaMethods.get(len);
                if (methods == null) {
                    this.raiseNoMatchingMethodError(self, convertedArgs, 1);
                }
                match = Java.matching_method_internal(JavaClass.this.JAVA_UTILITIES, methods, convertedArgs, 1, len);
                this.matchingMethods.put(argsTypeHash, match);
            }
            return Java.java_to_ruby(self, ((JavaMethod)match).invoke(convertedArgs), Block.NULL_BLOCK);
        }

        @Override
        public Arity getArity() {
            return Arity.OPTIONAL;
        }
    }

    private class StaticMethodInvoker
    extends MethodCallback {
        StaticMethodInvoker() {
        }

        StaticMethodInvoker(String name) {
            super(name, 2);
        }

        @Override
        void install(RubyClass proxy) {
            if (this.hasLocalMethod()) {
                RubyClass singleton = proxy.getSingletonClass();
                singleton.defineFastMethod(this.name, this, this.visibility);
                if (this.aliases != null && this.isPublic()) {
                    singleton.defineAliases(this.aliases, this.name);
                    this.aliases = null;
                }
            }
        }

        @Override
        public synchronized IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
            this.createJavaMethods(self.getRuntime());
            int len = args.length;
            IRubyObject[] convertedArgs = new IRubyObject[len];
            int i = len;
            while (--i >= 0) {
                convertedArgs[i] = Java.ruby_to_java(self, args[i], Block.NULL_BLOCK);
            }
            if (this.javaMethods == null) {
                return Java.java_to_ruby(self, this.javaMethod.invoke_static(convertedArgs), Block.NULL_BLOCK);
            }
            int argsTypeHash = 0;
            int i2 = len;
            while (--i2 >= 0) {
                argsTypeHash += 3 * args[i2].getMetaClass().id;
            }
            IRubyObject match = (IRubyObject)this.matchingMethods.get(argsTypeHash);
            if (match == null) {
                RubyArray methods = (RubyArray)this.javaMethods.get(len);
                if (methods == null) {
                    this.raiseNoMatchingMethodError(self, convertedArgs, 0);
                }
                match = Java.matching_method_internal(JavaClass.this.JAVA_UTILITIES, methods, convertedArgs, 0, len);
            }
            return Java.java_to_ruby(self, ((JavaMethod)match).invoke_static(convertedArgs), Block.NULL_BLOCK);
        }

        @Override
        public Arity getArity() {
            return Arity.OPTIONAL;
        }
    }

    private static abstract class MethodCallback
    extends NamedCallback {
        private boolean haveLocalMethod;
        private List<Method> methods;
        protected List<String> aliases;
        protected JavaMethod javaMethod;
        protected IntHashMap javaMethods;
        protected IntHashMap matchingMethods;

        MethodCallback() {
        }

        MethodCallback(String name, int type) {
            super(name, type);
        }

        void addMethod(Method method, Class<?> javaClass) {
            if (this.methods == null) {
                this.methods = new ArrayList<Method>();
            }
            this.methods.add(method);
            this.haveLocalMethod |= javaClass == method.getDeclaringClass();
        }

        void addAlias(String alias) {
            if (this.aliases == null) {
                this.aliases = new ArrayList<String>();
            }
            if (!this.aliases.contains(alias)) {
                this.aliases.add(alias);
            }
        }

        @Override
        boolean hasLocalMethod() {
            return this.haveLocalMethod;
        }

        synchronized void createJavaMethods(Ruby runtime) {
            if (this.methods != null) {
                if (this.methods.size() == 1) {
                    this.javaMethod = JavaMethod.create(runtime, this.methods.get(0));
                } else {
                    this.javaMethods = new IntHashMap();
                    this.matchingMethods = new IntHashMap();
                    for (Method method : this.methods) {
                        int arity = method.getParameterTypes().length;
                        RubyArray methodsForArity = (RubyArray)this.javaMethods.get(arity);
                        if (methodsForArity == null) {
                            methodsForArity = RubyArray.newArrayLight(runtime);
                            this.javaMethods.put(arity, methodsForArity);
                        }
                        methodsForArity.append(JavaMethod.create(runtime, method));
                    }
                }
                this.methods = null;
            }
        }

        void raiseNoMatchingMethodError(IRubyObject proxy, IRubyObject[] args, int start) {
            int len = args.length;
            ArrayList<Object> argTypes = new ArrayList<Object>(len - start);
            for (int i = start; i < len; ++i) {
                argTypes.add(((JavaClass)((JavaObject)args[i]).java_class()).getValue());
            }
            throw proxy.getRuntime().newNameError("no " + this.name + " with arguments matching " + argTypes + " on object " + proxy.callMethod(proxy.getRuntime().getCurrentContext(), "inspect"), null);
        }
    }

    private class InstanceFieldSetter
    extends FieldCallback {
        InstanceFieldSetter() {
        }

        InstanceFieldSetter(String name, Field field) {
            super(name, 3, field);
        }

        @Override
        void install(RubyClass proxy) {
            proxy.defineFastMethod(this.name, this, this.visibility);
        }

        @Override
        public IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
            if (this.javaField == null) {
                this.javaField = new JavaField(JavaClass.this.getRuntime(), this.field);
            }
            return Java.java_to_ruby(self, this.javaField.set_value(self.getInstanceVariables().fastGetInstanceVariable("@java_object"), Java.ruby_to_java(self, args[0], Block.NULL_BLOCK)), Block.NULL_BLOCK);
        }

        @Override
        public Arity getArity() {
            return Arity.ONE_ARGUMENT;
        }
    }

    private class InstanceFieldGetter
    extends FieldCallback {
        InstanceFieldGetter() {
        }

        InstanceFieldGetter(String name, Field field) {
            super(name, 3, field);
        }

        @Override
        void install(RubyClass proxy) {
            proxy.defineFastMethod(this.name, this, this.visibility);
        }

        @Override
        public IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
            if (this.javaField == null) {
                this.javaField = new JavaField(JavaClass.this.getRuntime(), this.field);
            }
            return Java.java_to_ruby(self, this.javaField.value(self.getInstanceVariables().fastGetInstanceVariable("@java_object")), Block.NULL_BLOCK);
        }

        @Override
        public Arity getArity() {
            return Arity.NO_ARGUMENTS;
        }
    }

    private class StaticFieldSetter
    extends FieldCallback {
        StaticFieldSetter() {
        }

        StaticFieldSetter(String name, Field field) {
            super(name, 1, field);
        }

        @Override
        void install(RubyClass proxy) {
            proxy.getSingletonClass().defineFastMethod(this.name, this, this.visibility);
        }

        @Override
        public IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
            if (this.javaField == null) {
                this.javaField = new JavaField(JavaClass.this.getRuntime(), this.field);
            }
            return Java.java_to_ruby(self, this.javaField.set_static_value(Java.ruby_to_java(self, args[0], Block.NULL_BLOCK)), Block.NULL_BLOCK);
        }

        @Override
        public Arity getArity() {
            return Arity.ONE_ARGUMENT;
        }
    }

    private class StaticFieldGetter
    extends FieldCallback {
        StaticFieldGetter() {
        }

        StaticFieldGetter(String name, Field field) {
            super(name, 1, field);
        }

        @Override
        void install(RubyClass proxy) {
            proxy.getSingletonClass().defineFastMethod(this.name, this, this.visibility);
        }

        @Override
        public IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
            if (this.javaField == null) {
                this.javaField = new JavaField(JavaClass.this.getRuntime(), this.field);
            }
            return Java.java_to_ruby(self, this.javaField.static_value(), Block.NULL_BLOCK);
        }

        @Override
        public Arity getArity() {
            return Arity.NO_ARGUMENTS;
        }
    }

    private static abstract class FieldCallback
    extends NamedCallback {
        Field field;
        JavaField javaField;

        FieldCallback() {
        }

        FieldCallback(String name, int type, Field field) {
            super(name, type);
            this.field = field;
        }
    }

    private static abstract class NamedCallback
    implements Callback {
        static final int STATIC_FIELD = 1;
        static final int STATIC_METHOD = 2;
        static final int INSTANCE_FIELD = 3;
        static final int INSTANCE_METHOD = 4;
        String name;
        int type;
        Visibility visibility = Visibility.PUBLIC;
        boolean isProtected;

        NamedCallback() {
        }

        NamedCallback(String name, int type) {
            this.name = name;
            this.type = type;
        }

        abstract void install(RubyClass var1);

        boolean hasLocalMethod() {
            return true;
        }

        boolean isPublic() {
            return this.visibility == Visibility.PUBLIC;
        }

        boolean isProtected() {
            return this.visibility == Visibility.PROTECTED;
        }
    }

    private static class AssignedName {
        static final int RESERVED = 0;
        static final int METHOD = 1;
        static final int FIELD = 2;
        static final int PROTECTED_METHOD = 3;
        static final int WEAKLY_RESERVED = 4;
        static final int ALIAS = 5;
        static final int PROTECTED_FIELD = 6;
        String name;
        int type;

        AssignedName() {
        }

        AssignedName(String name, int type) {
            this.name = name;
            this.type = type;
        }
    }
}

