/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JavaMethodDescriptor;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.CompiledMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JRubyClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.util.CheckClassAdapter;

public class InvocationMethodFactory
extends MethodFactory
implements Opcodes {
    private static final String COMPILED_SUPER_CLASS = CodegenUtils.p(CompiledMethod.class);
    private static final String COMPILED_CALL_SIG = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class));
    private static final String COMPILED_CALL_SIG_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class, Block.class));
    private static final String COMPILED_CALL_SIG_ZERO_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, Block.class));
    private static final String COMPILED_CALL_SIG_ZERO = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class));
    private static final String COMPILED_CALL_SIG_ONE_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, Block.class));
    private static final String COMPILED_CALL_SIG_ONE = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class));
    private static final String COMPILED_CALL_SIG_TWO_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, Block.class));
    private static final String COMPILED_CALL_SIG_TWO = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class));
    private static final String COMPILED_CALL_SIG_THREE_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
    private static final String COMPILED_CALL_SIG_THREE = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
    private static final String COMPILED_SUPER_SIG = CodegenUtils.sig(Void.TYPE, RubyModule.class, Arity.class, Visibility.class, StaticScope.class, Object.class, CallConfiguration.class);
    private static final String JAVA_SUPER_SIG = CodegenUtils.sig(Void.TYPE, CodegenUtils.params(RubyModule.class, Visibility.class));
    private static final String JAVA_INDEXED_SUPER_SIG = CodegenUtils.sig(Void.TYPE, CodegenUtils.params(RubyModule.class, Visibility.class, Integer.TYPE));
    public static final int THIS_INDEX = 0;
    public static final int THREADCONTEXT_INDEX = 1;
    public static final int RECEIVER_INDEX = 2;
    public static final int CLASS_INDEX = 3;
    public static final int NAME_INDEX = 4;
    public static final int ARGS_INDEX = 5;
    public static final int BLOCK_INDEX = 6;
    private JRubyClassLoader classLoader;

    public InvocationMethodFactory(ClassLoader classLoader) {
        this.classLoader = classLoader instanceof JRubyClassLoader ? (JRubyClassLoader)classLoader : new JRubyClassLoader(classLoader);
    }

    @Override
    public DynamicMethod getCompiledMethod(RubyModule implementationClass, String method, Arity arity, Visibility visibility, StaticScope scope, Object scriptObject, CallConfiguration callConfig) {
        String sup = COMPILED_SUPER_CLASS;
        Class<?> scriptClass = scriptObject.getClass();
        String mname = scriptClass.getName() + "Invoker" + method + arity;
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            Class generatedClass = this.tryClass(implementationClass.getRuntime(), mname);
            try {
                if (generatedClass == null) {
                    String typePath = CodegenUtils.p(scriptClass);
                    String mnamePath = typePath + "Invoker" + method + arity;
                    ClassWriter cw = this.createCompiledCtor(mnamePath, sup);
                    SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cw.visitMethod(1, "call", COMPILED_CALL_SIG_BLOCK, null, null));
                    mv.visitCode();
                    Label line = new Label();
                    mv.visitLineNumber(0, line);
                    if (!callConfig.isNoop()) {
                        this.invokeCallConfigPre(mv, COMPILED_SUPER_CLASS, -1, true);
                    }
                    mv.aconst_null();
                    mv.astore(8);
                    Label tryBegin = new Label();
                    Label tryEnd = new Label();
                    Label doFinally = new Label();
                    Label catchReturnJump = new Label();
                    Label catchRedoJump = new Label();
                    Label normalExit = new Label();
                    mv.trycatch(tryBegin, tryEnd, catchReturnJump, CodegenUtils.p(JumpException.ReturnJump.class));
                    mv.trycatch(tryBegin, tryEnd, catchRedoJump, CodegenUtils.p(JumpException.RedoJump.class));
                    mv.trycatch(tryBegin, tryEnd, doFinally, null);
                    mv.trycatch(catchReturnJump, doFinally, doFinally, null);
                    mv.label(tryBegin);
                    mv.aload(0);
                    mv.getfield(mnamePath, "$scriptObject", CodegenUtils.ci(Object.class));
                    mv.checkcast(typePath);
                    mv.aload(1);
                    mv.aload(2);
                    mv.aload(5);
                    mv.aload(6);
                    mv.invokevirtual(typePath, method, CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class)));
                    mv.astore(8);
                    mv.label(tryEnd);
                    mv.label(normalExit);
                    if (!callConfig.isNoop()) {
                        this.invokeCallConfigPost(mv, COMPILED_SUPER_CLASS);
                    }
                    mv.aload(8);
                    mv.visitInsn(176);
                    this.handleReturn(catchReturnJump, mv, doFinally, normalExit, COMPILED_SUPER_CLASS);
                    this.handleRedo(catchRedoJump, mv, doFinally);
                    mv.label(doFinally);
                    if (!callConfig.isNoop()) {
                        this.invokeCallConfigPost(mv, COMPILED_SUPER_CLASS);
                    }
                    mv.athrow();
                    generatedClass = this.endCall(implementationClass.getRuntime(), cw, mv, mname);
                }
                return (DynamicMethod)generatedClass.getConstructor(RubyModule.class, Arity.class, Visibility.class, StaticScope.class, Object.class, CallConfiguration.class).newInstance(new Object[]{implementationClass, arity, visibility, scope, scriptObject, callConfig});
            }
            catch (Exception e) {
                e.printStackTrace();
                throw implementationClass.getRuntime().newLoadError(e.getMessage());
            }
        }
    }

    @Override
    public DynamicMethod getAnnotatedMethod(RubyModule implementationClass, Method method) {
        JavaMethodDescriptor desc = new JavaMethodDescriptor(method);
        Class<?> type = method.getDeclaringClass();
        String typePath = CodegenUtils.p(type);
        String javaMethodName = method.getName();
        String commonClassSuffix = "Invoker$" + javaMethodName + (desc.isStatic ? "_s" : "") + "_method_" + desc.required + "_" + desc.optional;
        String generatedClassName = type.getName() + commonClassSuffix;
        String generatedClassPath = typePath + commonClassSuffix;
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(implementationClass.getRuntime(), generatedClassName);
            try {
                if (c == null) {
                    int specificArity = -1;
                    if (desc.optional == 0 && !desc.rest) {
                        if (desc.required == 0) {
                            specificArity = desc.actualRequired <= 3 ? desc.actualRequired : -1;
                        } else if (desc.required >= 0 && desc.required <= 3) {
                            specificArity = desc.required;
                        }
                    }
                    boolean block = desc.parameters.length == 0 ? false : desc.parameters[desc.parameters.length - 1] == Block.class;
                    String superClass = CodegenUtils.p(this.selectSuperClass(specificArity, block));
                    ClassWriter cw = this.createJavaMethodCtor(generatedClassPath, superClass);
                    SkinnyMethodAdapter mv = null;
                    mv = this.beginMethod(cw, "call", specificArity, block);
                    mv.visitCode();
                    Label line = new Label();
                    mv.visitLineNumber(0, line);
                    this.createAnnotatedMethodInvocation(desc, mv, superClass, specificArity, block);
                    this.endMethod(mv);
                    c = this.endClass(implementationClass.getRuntime(), cw, generatedClassName);
                }
                JavaMethod ic = (JavaMethod)c.getConstructor(RubyModule.class, Visibility.class).newInstance(new Object[]{implementationClass, desc.anno.visibility()});
                ic.setArity(Arity.fromAnnotation(desc.anno, desc.parameters, desc.isStatic));
                ic.setJavaName(javaMethodName);
                ic.setArgumentTypes(desc.parameters);
                ic.setSingleton(desc.isStatic);
                ic.setCallConfig(CallConfiguration.getCallConfigByAnno(desc.anno));
                return ic;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw implementationClass.getRuntime().newLoadError(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defineIndexedAnnotatedMethods(RubyModule implementationClass, Class type, MethodFactory.MethodDefiningCallback callback) {
        String typePath = CodegenUtils.p(type);
        String superClass = CodegenUtils.p(JavaMethod.class);
        String generatedClassName = type.getName() + "Invoker";
        String generatedClassPath = typePath + "Invoker";
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(implementationClass.getRuntime(), generatedClassName);
            try {
                JRubyMethod jrubyMethod;
                Method[] methods;
                ArrayList<Method> annotatedMethods = new ArrayList<Method>();
                for (Method method : methods = type.getDeclaredMethods()) {
                    jrubyMethod = method.getAnnotation(JRubyMethod.class);
                    if (jrubyMethod == null) continue;
                    annotatedMethods.add(method);
                }
                ArrayList sortedMethods = new ArrayList(annotatedMethods);
                Collections.sort(sortedMethods, new Comparator<Method>(){

                    @Override
                    public int compare(Method a, Method b) {
                        return a.getName().compareTo(b.getName());
                    }
                });
                HashMap indexMap = new HashMap();
                for (int index = 0; index < sortedMethods.size(); ++index) {
                    indexMap.put(sortedMethods.get(index), index);
                }
                if (c == null) {
                    int i;
                    ClassWriter cw = this.createIndexedJavaMethodCtor(generatedClassPath, superClass);
                    SkinnyMethodAdapter mv = null;
                    mv = new SkinnyMethodAdapter(cw.visitMethod(1, "call", COMPILED_CALL_SIG_BLOCK, null, null));
                    mv.visitCode();
                    Label line = new Label();
                    mv.visitLineNumber(0, line);
                    Label label = new Label();
                    Label[] cases = new Label[sortedMethods.size()];
                    for (i = 0; i < cases.length; ++i) {
                        cases[i] = new Label();
                    }
                    mv.aload(0);
                    mv.getfield(generatedClassPath, "methodIndex", CodegenUtils.ci(Integer.TYPE));
                    mv.tableswitch(0, cases.length - 1, label, cases);
                    for (i = 0; i < sortedMethods.size(); ++i) {
                        mv.label(cases[i]);
                        String callName = this.getAnnotatedMethodForIndex(cw, (Method)sortedMethods.get(i), i, superClass);
                        mv.aload(0);
                        mv.aload(1);
                        mv.aload(2);
                        mv.aload(3);
                        mv.aload(4);
                        mv.aload(5);
                        mv.aload(6);
                        mv.invokevirtual(generatedClassPath, callName, COMPILED_CALL_SIG_BLOCK);
                        mv.areturn();
                    }
                    mv.label(label);
                    mv.aload(1);
                    mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class));
                    mv.ldc("Error: fell off switched invoker for class: " + implementationClass.getBaseName());
                    mv.invokevirtual(CodegenUtils.p(Ruby.class), "newRuntimeError", CodegenUtils.sig(RaiseException.class, String.class));
                    mv.athrow();
                    c = this.endCall(implementationClass.getRuntime(), cw, mv, generatedClassName);
                }
                for (int i = 0; i < annotatedMethods.size(); ++i) {
                    Method method;
                    method = (Method)annotatedMethods.get(i);
                    jrubyMethod = method.getAnnotation(JRubyMethod.class);
                    if (jrubyMethod.frame()) {
                        for (String name : jrubyMethod.name()) {
                            ASTInspector.FRAME_AWARE_METHODS.add(name);
                        }
                    }
                    int n = (Integer)indexMap.get(method);
                    JavaMethod ic = (JavaMethod)c.getConstructor(RubyModule.class, Visibility.class, Integer.TYPE).newInstance(new Object[]{implementationClass, jrubyMethod.visibility(), n});
                    ic.setArity(Arity.fromAnnotation(jrubyMethod));
                    ic.setJavaName(method.getName());
                    ic.setArgumentTypes(method.getParameterTypes());
                    ic.setSingleton(Modifier.isStatic(method.getModifiers()));
                    ic.setCallConfig(CallConfiguration.getCallConfigByAnno(jrubyMethod));
                    callback.define(implementationClass, method, ic);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw implementationClass.getRuntime().newLoadError(e.getMessage());
            }
        }
    }

    private void checkArity(JRubyMethod jrubyMethod, SkinnyMethodAdapter method, int specificArity) {
        Label arityError = new Label();
        Label noArityError = new Label();
        switch (specificArity) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return;
            }
        }
        if (jrubyMethod.rest()) {
            if (jrubyMethod.required() > 0) {
                method.aload(5);
                method.arraylength();
                method.ldc(jrubyMethod.required());
                method.if_icmplt(arityError);
            }
        } else if (jrubyMethod.optional() > 0) {
            if (jrubyMethod.required() > 0) {
                method.aload(5);
                method.arraylength();
                method.ldc(jrubyMethod.required());
                method.if_icmplt(arityError);
            }
            method.aload(5);
            method.arraylength();
            method.ldc(jrubyMethod.required() + jrubyMethod.optional());
            method.if_icmpgt(arityError);
        } else {
            method.aload(5);
            method.arraylength();
            method.ldc(jrubyMethod.required());
            method.if_icmpne(arityError);
        }
        method.go_to(noArityError);
        method.label(arityError);
        method.aload(1);
        method.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class));
        method.aload(5);
        method.ldc(jrubyMethod.required());
        method.ldc(jrubyMethod.required() + jrubyMethod.optional());
        method.invokestatic(CodegenUtils.p(Arity.class), "checkArgumentCount", CodegenUtils.sig(Integer.TYPE, Ruby.class, IRubyObject[].class, Integer.TYPE, Integer.TYPE));
        method.pop();
        method.label(noArityError);
    }

    private ClassWriter createCompiledCtor(String namePath, String sup) throws Exception {
        ClassWriter cw = new ClassWriter(1);
        cw.visit(48, 33, namePath, null, sup, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", COMPILED_SUPER_SIG, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitVarInsn(25, 4);
        mv.visitVarInsn(25, 5);
        mv.visitVarInsn(25, 6);
        mv.visitMethodInsn(183, sup, "<init>", COMPILED_SUPER_SIG);
        Label line = new Label();
        mv.visitLineNumber(0, line);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        return cw;
    }

    private ClassWriter createJavaMethodCtor(String namePath, String sup) throws Exception {
        ClassWriter cw = new ClassWriter(1);
        cw.visit(48, 33, namePath, null, sup, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", JAVA_SUPER_SIG, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(183, sup, "<init>", JAVA_SUPER_SIG);
        Label line = new Label();
        mv.visitLineNumber(0, line);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        return cw;
    }

    private ClassWriter createIndexedJavaMethodCtor(String namePath, String sup) throws Exception {
        ClassWriter cw = new ClassWriter(1);
        cw.visit(48, 33, namePath, null, sup, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", JAVA_INDEXED_SUPER_SIG, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(21, 3);
        mv.visitMethodInsn(183, sup, "<init>", JAVA_INDEXED_SUPER_SIG);
        Label line = new Label();
        mv.visitLineNumber(0, line);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        return cw;
    }

    private void handleRedo(Label tryRedoJump, SkinnyMethodAdapter mv, Label tryFinally) {
        mv.label(tryRedoJump);
        mv.pop();
        mv.aload(1);
        mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class));
        mv.invokevirtual(CodegenUtils.p(Ruby.class), "newRedoLocalJumpError", CodegenUtils.sig(RaiseException.class));
        mv.go_to(tryFinally);
    }

    private void handleReturn(Label catchReturnJump, SkinnyMethodAdapter mv, Label doFinally, Label normalExit, String typePath) {
        mv.label(catchReturnJump);
        mv.aload(0);
        mv.swap();
        mv.invokevirtual(typePath, "handleReturnJump", CodegenUtils.sig(IRubyObject.class, JumpException.ReturnJump.class));
        mv.astore(8);
        mv.go_to(normalExit);
    }

    private void invokeCallConfigPost(SkinnyMethodAdapter mv, String superClass) {
        mv.aload(0);
        mv.aload(1);
        mv.invokevirtual(superClass, "post", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class)));
    }

    private void invokeCallConfigPre(SkinnyMethodAdapter mv, String superClass, int specificArity, boolean block) {
        mv.aload(0);
        mv.aload(1);
        mv.aload(2);
        mv.aload(4);
        this.loadArgumentsForPre(mv, specificArity);
        this.loadBlockForPre(mv, specificArity, block);
        mv.invokevirtual(superClass, "pre", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, IRubyObject.class, String.class, IRubyObject[].class, Block.class)));
    }

    private void loadArgumentsForPre(SkinnyMethodAdapter mv, int specificArity) {
        switch (specificArity) {
            default: {
                mv.aload(5);
                break;
            }
            case 0: {
                mv.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
                break;
            }
            case 1: {
                mv.aload(5);
                mv.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "constructObjectArray", CodegenUtils.sig(IRubyObject[].class, IRubyObject.class));
                break;
            }
            case 2: {
                mv.aload(5);
                mv.aload(6);
                mv.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "constructObjectArray", CodegenUtils.sig(IRubyObject[].class, IRubyObject.class, IRubyObject.class));
                break;
            }
            case 3: {
                mv.aload(5);
                mv.aload(6);
                mv.aload(7);
                mv.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "constructObjectArray", CodegenUtils.sig(IRubyObject[].class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
            }
        }
    }

    private void loadArguments(SkinnyMethodAdapter mv, JRubyMethod jrubyMethod, int specificArity) {
        switch (specificArity) {
            default: {
                mv.aload(5);
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                mv.aload(5);
                break;
            }
            case 2: {
                mv.aload(5);
                mv.aload(6);
                break;
            }
            case 3: {
                mv.aload(5);
                mv.aload(6);
                mv.aload(7);
            }
        }
    }

    private void loadBlockForPre(SkinnyMethodAdapter mv, int specificArity, boolean getsBlock) {
        switch (specificArity) {
            default: {
                if (getsBlock) {
                    mv.visitVarInsn(25, 6);
                    break;
                }
                mv.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
                break;
            }
            case 0: {
                if (getsBlock) {
                    mv.visitVarInsn(25, 5);
                    break;
                }
                mv.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
                break;
            }
            case 1: {
                if (getsBlock) {
                    mv.visitVarInsn(25, 6);
                    break;
                }
                mv.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
                break;
            }
            case 2: {
                if (getsBlock) {
                    mv.visitVarInsn(25, 7);
                    break;
                }
                mv.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
                break;
            }
            case 3: {
                if (getsBlock) {
                    mv.visitVarInsn(25, 8);
                    break;
                }
                mv.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
            }
        }
    }

    private void loadBlock(SkinnyMethodAdapter mv, int specificArity, boolean getsBlock) {
        switch (specificArity) {
            default: {
                if (!getsBlock) break;
                mv.visitVarInsn(25, 6);
                break;
            }
            case 0: {
                if (!getsBlock) break;
                mv.visitVarInsn(25, 5);
                break;
            }
            case 1: {
                if (!getsBlock) break;
                mv.visitVarInsn(25, 6);
                break;
            }
            case 2: {
                if (!getsBlock) break;
                mv.visitVarInsn(25, 7);
                break;
            }
            case 3: {
                if (!getsBlock) break;
                mv.visitVarInsn(25, 8);
            }
        }
    }

    private void loadReceiver(String typePath, Class[] signature, Method method, SkinnyMethodAdapter mv) {
        if (Modifier.isStatic(method.getModifiers())) {
            if (signature.length > 1 && signature[0] == ThreadContext.class) {
                mv.aload(1);
            }
            mv.aload(2);
        } else {
            mv.aload(2);
            mv.checkcast(typePath);
            if (signature.length > 0 && signature[0] == ThreadContext.class) {
                mv.aload(1);
            }
        }
    }

    private Class tryClass(Ruby runtime, String name) {
        try {
            if (this.classLoader == null) {
                return Class.forName(name, true, runtime.getJRubyClassLoader());
            }
            return this.classLoader.loadClass(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Class endCall(Ruby runtime, ClassWriter cw, MethodVisitor mv, String name) {
        this.endMethod(mv);
        return this.endClass(runtime, cw, name);
    }

    protected void endMethod(MethodVisitor mv) {
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected Class endClass(Ruby runtime, ClassWriter cw, String name) {
        cw.visitEnd();
        byte[] code = cw.toByteArray();
        CheckClassAdapter.verify(new ClassReader(code), false, new PrintWriter(System.err));
        if (this.classLoader == null) {
            this.classLoader = runtime.getJRubyClassLoader();
        }
        return this.classLoader.defineClass(name, code);
    }

    private void loadArguments(MethodVisitor mv, int argsIndex, int count) {
        for (int i = 0; i < count; ++i) {
            this.loadArgument(mv, argsIndex, i);
        }
    }

    private void loadArgument(MethodVisitor mv, int argsIndex, int argIndex) {
        mv.visitVarInsn(25, argsIndex);
        mv.visitLdcInsn(new Integer(argIndex));
        mv.visitInsn(50);
    }

    private SkinnyMethodAdapter beginMethod(ClassWriter cw, String methodName, int specificArity, boolean block) {
        switch (specificArity) {
            default: {
                if (block) {
                    return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_BLOCK, null, null));
                }
                return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG, null, null));
            }
            case 0: {
                if (block) {
                    return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_ZERO_BLOCK, null, null));
                }
                return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_ZERO, null, null));
            }
            case 1: {
                if (block) {
                    return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_ONE_BLOCK, null, null));
                }
                return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_ONE, null, null));
            }
            case 2: {
                if (block) {
                    return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_TWO_BLOCK, null, null));
                }
                return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_TWO, null, null));
            }
            case 3: 
        }
        if (block) {
            return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_THREE_BLOCK, null, null));
        }
        return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_THREE, null, null));
    }

    private Class selectSuperClass(int specificArity, boolean block) {
        switch (specificArity) {
            default: {
                if (block) {
                    return JavaMethod.class;
                }
                return JavaMethod.JavaMethodNoBlock.class;
            }
            case 0: {
                if (block) {
                    return JavaMethod.JavaMethodZeroBlock.class;
                }
                return JavaMethod.JavaMethodZero.class;
            }
            case 1: {
                if (block) {
                    return JavaMethod.JavaMethodOneBlock.class;
                }
                return JavaMethod.JavaMethodOne.class;
            }
            case 2: {
                if (block) {
                    return JavaMethod.JavaMethodTwoBlock.class;
                }
                return JavaMethod.JavaMethodTwo.class;
            }
            case 3: 
        }
        if (block) {
            return JavaMethod.JavaMethodThreeBlock.class;
        }
        return JavaMethod.JavaMethodThree.class;
    }

    private String getAnnotatedMethodForIndex(ClassWriter cw, Method method, int index, String superClass) {
        String methodName = "call" + index + "_" + method.getName();
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_BLOCK, null, null));
        mv.visitCode();
        Label line = new Label();
        mv.visitLineNumber(0, line);
        this.createAnnotatedMethodInvocation(new JavaMethodDescriptor(method), mv, superClass, -1, true);
        this.endMethod(mv);
        return methodName;
    }

    private void createAnnotatedMethodInvocation(JavaMethodDescriptor desc, SkinnyMethodAdapter method, String superClass, int specificArity, boolean block) {
        String typePath = CodegenUtils.p(desc.method.getDeclaringClass());
        String javaMethodName = desc.method.getName();
        Class<?> ret = desc.method.getReturnType();
        this.checkArity(desc.anno, method, specificArity);
        CallConfiguration callConfig = CallConfiguration.getCallConfigByAnno(desc.anno);
        if (!callConfig.isNoop()) {
            this.invokeCallConfigPre(method, superClass, specificArity, block);
        }
        Label tryBegin = new Label();
        Label tryEnd = new Label();
        Label doFinally = new Label();
        Label catchReturnJump = new Label();
        Label catchRedoJump = new Label();
        Label normalExit = new Label();
        if (!callConfig.isNoop() || block) {
            method.trycatch(tryBegin, tryEnd, catchReturnJump, CodegenUtils.p(JumpException.ReturnJump.class));
            method.trycatch(tryBegin, tryEnd, catchRedoJump, CodegenUtils.p(JumpException.RedoJump.class));
            method.trycatch(tryBegin, tryEnd, doFinally, null);
            method.trycatch(catchReturnJump, doFinally, doFinally, null);
        }
        method.label(tryBegin);
        this.loadReceiver(typePath, desc.parameters, desc.method, method);
        this.loadArguments(method, desc.anno, specificArity);
        this.loadBlock(method, specificArity, block);
        if (Modifier.isStatic(desc.method.getModifiers())) {
            method.invokestatic(typePath, javaMethodName, CodegenUtils.sig(ret, desc.parameters));
        } else {
            method.invokevirtual(typePath, javaMethodName, CodegenUtils.sig(ret, desc.parameters));
        }
        if (!callConfig.isNoop() || block) {
            method.astore(8);
            method.label(tryEnd);
            method.label(normalExit);
            if (!callConfig.isNoop()) {
                this.invokeCallConfigPost(method, superClass);
            }
            method.aload(8);
        }
        method.visitInsn(176);
        if (!callConfig.isNoop() || block) {
            this.handleReturn(catchReturnJump, method, doFinally, normalExit, superClass);
            this.handleRedo(catchRedoJump, method, doFinally);
            method.label(doFinally);
            if (!callConfig.isNoop()) {
                this.invokeCallConfigPost(method, superClass);
            }
            method.athrow();
        }
    }
}

