/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;

public class FullFunctionCallbackMethod
extends DynamicMethod
implements JumpTarget {
    private Callback callback;

    public FullFunctionCallbackMethod(RubyModule implementationClass, Callback callback, Visibility visibility) {
        super(implementationClass, visibility, CallConfiguration.FRAME_ONLY);
        this.callback = callback;
    }

    /*
     * Loose catch block
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
        try {
            IRubyObject iRubyObject;
            block14: {
                this.callConfig.pre(context, self, clazz, this.getArity(), name, args, block, null, this);
                assert (args != null);
                Ruby runtime = context.getRuntime();
                boolean isTrace = runtime.hasEventHooks();
                if (isTrace) {
                    runtime.callEventHooks(context, 5, context.getFile(), context.getLine(), name, this.getImplementationClass());
                }
                try {
                    iRubyObject = this.callback.execute(self, args, block);
                    if (!isTrace) break block14;
                }
                catch (JumpException.ReturnJump rj) {
                    block15: {
                        if (rj.getTarget() != this) break block15;
                        IRubyObject iRubyObject2 = (IRubyObject)rj.getValue();
                        if (isTrace) {
                            runtime.callEventHooks(context, 6, context.getFile(), context.getLine(), name, this.getImplementationClass());
                        }
                        this.callConfig.post(context);
                        return iRubyObject2;
                    }
                    throw rj;
                    {
                        catch (Throwable throwable) {
                            if (isTrace) {
                                runtime.callEventHooks(context, 6, context.getFile(), context.getLine(), name, this.getImplementationClass());
                            }
                            throw throwable;
                        }
                    }
                }
                runtime.callEventHooks(context, 6, context.getFile(), context.getLine(), name, this.getImplementationClass());
            }
            return iRubyObject;
        }
        finally {
            this.callConfig.post(context);
        }
    }

    public Callback getCallback() {
        return this.callback;
    }

    @Override
    public Arity getArity() {
        return this.getCallback().getArity();
    }

    @Override
    public DynamicMethod dup() {
        return new FullFunctionCallbackMethod(this.getImplementationClass(), this.callback, this.getVisibility());
    }
}

