/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.io.File;
import java.io.FileOutputStream;
import org.jruby.Ruby;
import org.jruby.internal.runtime.methods.InvocationMethodFactory;
import org.objectweb.asm.ClassWriter;

public class DumpingInvocationMethodFactory
extends InvocationMethodFactory {
    private String dumpPath;

    public DumpingInvocationMethodFactory(String path, ClassLoader classLoader) {
        super(classLoader);
        this.dumpPath = path;
    }

    @Override
    protected Class endClass(Ruby runtime, ClassWriter cw, String name) {
        cw.visitEnd();
        byte[] code = cw.toByteArray();
        String cname = name.replace('.', '/');
        File f = new File(this.dumpPath, cname + ".class");
        f.getParentFile().mkdirs();
        try {
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(code);
            fos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return runtime.getJRubyClassLoader().defineClass(name, code);
    }
}

