/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import com.sun.jna.ptr.IntByReference;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyNumeric;
import org.jruby.ext.socket.RubyUNIXSocket;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyUNIXServer
extends RubyUNIXSocket {
    private static ObjectAllocator UNIXSERVER_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyUNIXServer(runtime, klass);
        }
    };

    static void createUNIXServer(Ruby runtime) {
        RubyClass rb_cUNIXServer = runtime.defineClass("UNIXServer", runtime.fastGetClass("UNIXSocket"), UNIXSERVER_ALLOCATOR);
        runtime.getObject().fastSetConstant("UNIXserver", rb_cUNIXServer);
        CallbackFactory cfact = runtime.callbackFactory(RubyUNIXServer.class);
        rb_cUNIXServer.defineFastMethod("initialize", cfact.getFastMethod("initialize", IRubyObject.class));
        rb_cUNIXServer.defineFastMethod("accept", cfact.getFastMethod("accept"));
        rb_cUNIXServer.defineFastMethod("accept_nonblock", cfact.getFastMethod("accept_nonblock"));
        rb_cUNIXServer.defineFastMethod("sysaccept", cfact.getFastMethod("sysaccept"));
        rb_cUNIXServer.defineFastMethod("listen", cfact.getFastMethod("listen", IRubyObject.class));
    }

    public RubyUNIXServer(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    @Override
    public IRubyObject initialize(IRubyObject path) throws Exception {
        this.init_unixsock(path, true);
        return this;
    }

    public IRubyObject accept() throws Exception {
        RubyUNIXSocket.LibCSocket.sockaddr_un from = new RubyUNIXSocket.LibCSocket.sockaddr_un();
        int fd2 = INSTANCE.accept(this.fd, from, new IntByReference(106));
        if (fd2 < 0) {
            this.rb_sys_fail(null);
        }
        RubyUNIXSocket sock = (RubyUNIXSocket)this.getRuntime().fastGetClass("UNIXSocket").callMethod(this.getRuntime().getCurrentContext(), "allocate", new IRubyObject[0]);
        sock.fd = fd2;
        sock.fpath = new String(from.sun_path);
        sock.init_sock();
        return sock;
    }

    public IRubyObject accept_nonblock() throws Exception {
        RubyUNIXSocket.LibCSocket.sockaddr_un from = new RubyUNIXSocket.LibCSocket.sockaddr_un();
        IntByReference fromlen = new IntByReference(106);
        int flags = INSTANCE.fcntl(this.fd, 3, 0);
        INSTANCE.fcntl(this.fd, 4, flags | 4);
        int fd2 = INSTANCE.accept(this.fd, from, new IntByReference(106));
        if (fd2 < 0) {
            this.rb_sys_fail(null);
        }
        RubyUNIXSocket sock = (RubyUNIXSocket)this.getRuntime().fastGetClass("UNIXSocket").callMethod(this.getRuntime().getCurrentContext(), "allocate", new IRubyObject[0]);
        sock.fd = fd2;
        sock.fpath = new String(from.sun_path);
        sock.init_sock();
        return sock;
    }

    public IRubyObject sysaccept() throws Exception {
        return this.accept();
    }

    public IRubyObject listen(IRubyObject log) {
        if (INSTANCE.listen(this.fd, RubyNumeric.fix2int(log)) < 0) {
            this.rb_sys_fail("listen(2)");
        }
        return this.getRuntime().newFixnum(0L);
    }
}

