/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import com.sun.jna.Native;
import java.util.HashMap;
import org.jruby.ext.posix.JavaPOSIX;
import org.jruby.ext.posix.LibC;
import org.jruby.ext.posix.LinuxLibC;
import org.jruby.ext.posix.LinuxPOSIX;
import org.jruby.ext.posix.MacOSPOSIX;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXHandler;
import org.jruby.ext.posix.SolarisPOSIX;
import org.jruby.ext.posix.WindowsLibCFunctionMapper;
import org.jruby.ext.posix.WindowsPOSIX;
import org.jruby.ext.posix.util.Platform;

public class POSIXFactory {
    static final String LIBC = "c";
    static LibC libc = null;

    public static POSIX getPOSIX(POSIXHandler handler, boolean useNativePOSIX) {
        POSIX posix;
        block14: {
            posix = null;
            if (useNativePOSIX && Platform.IS_32_BIT) {
                try {
                    if (Platform.IS_MAC) {
                        posix = POSIXFactory.loadMacOSPOSIX(handler);
                    } else if (Platform.IS_LINUX) {
                        posix = POSIXFactory.loadLinuxPOSIX(handler);
                    } else if (Platform.IS_WINDOWS) {
                        posix = POSIXFactory.loadWindowsPOSIX(handler);
                    } else if (Platform.IS_SOLARIS) {
                        posix = POSIXFactory.loadSolarisPOSIX(handler);
                    }
                    if (handler.isVerbose()) {
                        if (posix != null) {
                            System.err.println("Successfully loaded native POSIX impl.");
                        } else {
                            System.err.println("Failed to load native POSIX impl; falling back on Java impl. Unsupported OS.");
                        }
                    }
                }
                catch (Throwable t) {
                    if (!handler.isVerbose()) break block14;
                    System.err.println("Failed to load native POSIX impl; falling back on Java impl. Stacktrace follows.");
                    t.printStackTrace();
                }
            }
        }
        if (posix == null) {
            posix = POSIXFactory.getJavaPOSIX(handler);
        }
        return posix;
    }

    public static POSIX getJavaPOSIX(POSIXHandler handler) {
        return new JavaPOSIX(handler);
    }

    public static POSIX loadLinuxPOSIX(POSIXHandler handler) {
        return new LinuxPOSIX(LIBC, POSIXFactory.loadLibC(LIBC, LinuxLibC.class, new HashMap<Object, Object>()), handler);
    }

    public static POSIX loadMacOSPOSIX(POSIXHandler handler) {
        return new MacOSPOSIX(LIBC, POSIXFactory.loadLibC(LIBC, LibC.class, new HashMap<Object, Object>()), handler);
    }

    public static POSIX loadSolarisPOSIX(POSIXHandler handler) {
        return new SolarisPOSIX(LIBC, POSIXFactory.loadLibC(LIBC, LibC.class, new HashMap<Object, Object>()), handler);
    }

    public static POSIX loadWindowsPOSIX(POSIXHandler handler) {
        String name = "msvcrt";
        HashMap<Object, Object> options = new HashMap<Object, Object>();
        options.put("function-mapper", new WindowsLibCFunctionMapper());
        return new WindowsPOSIX(name, POSIXFactory.loadLibC(name, LibC.class, options), handler);
    }

    public static LibC loadLibC(String libraryName, Class<?> libCClass, HashMap<Object, Object> options) {
        if (libc != null) {
            return libc;
        }
        libc = (LibC)Native.loadLibrary(libraryName, libCClass, options);
        return libc;
    }
}

