/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import java.util.Arrays;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.impl.AbstractVariableCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;

public class HeapBasedVariableCompiler
extends AbstractVariableCompiler {
    protected int scopeIndex;
    protected int varsIndex;

    public HeapBasedVariableCompiler(StandardASMCompiler.AbstractMethodCompiler methodCompiler, SkinnyMethodAdapter method, int scopeIndex, int varsIndex, int argsIndex, int closureIndex, int firstTempIndex) {
        super(methodCompiler, method, argsIndex, closureIndex, firstTempIndex);
        this.scopeIndex = scopeIndex;
        this.varsIndex = varsIndex;
    }

    @Override
    public void beginMethod(CompilerCallback argsCallback, StaticScope scope) {
        if (scope.getNumberOfVariables() > 0) {
            this.methodCompiler.loadThreadContext();
            this.methodCompiler.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class));
            this.method.dup();
            this.method.astore(this.scopeIndex);
            this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class));
            this.method.astore(this.varsIndex);
            this.method.aload(this.varsIndex);
            this.methodCompiler.loadNil();
            this.method.invokestatic(CodegenUtils.p(Arrays.class), "fill", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Object[].class, Object.class)));
        }
        if (argsCallback != null) {
            argsCallback.call(this.methodCompiler);
        }
    }

    @Override
    public void beginClass(CompilerCallback bodyPrep, StaticScope scope) {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class));
        this.method.dup();
        this.method.astore(this.scopeIndex);
        this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class));
        this.method.astore(this.varsIndex);
        bodyPrep.call(this.methodCompiler);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class));
        this.method.dup();
        this.method.astore(this.scopeIndex);
        this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class));
        this.method.astore(this.varsIndex);
        this.method.aload(this.varsIndex);
        this.methodCompiler.loadNil();
        this.method.invokestatic(CodegenUtils.p(Arrays.class), "fill", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Object[].class, Object.class)));
    }

    @Override
    public void beginClosure(CompilerCallback argsCallback, StaticScope scope) {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class));
        this.method.dup();
        this.method.astore(this.scopeIndex);
        this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class));
        this.method.astore(this.varsIndex);
        if (scope != null) {
            this.methodCompiler.loadNil();
            for (int i = 0; i < scope.getNumberOfVariables(); ++i) {
                this.assignLocalVariable(i);
            }
            this.method.pop();
        }
        if (argsCallback != null) {
            this.method.aload(this.argsIndex);
            this.method.ldc(new Integer(0));
            this.method.arrayload();
            argsCallback.call(this.methodCompiler);
            this.method.pop();
        }
    }

    @Override
    public void assignLocalVariable(int index) {
        this.method.dup();
        switch (index) {
            case 0: {
                this.method.aload(this.scopeIndex);
                this.method.swap();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueZeroDepthZero", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(IRubyObject.class)));
                break;
            }
            case 1: {
                this.method.aload(this.scopeIndex);
                this.method.swap();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueOneDepthZero", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(IRubyObject.class)));
                break;
            }
            default: {
                this.method.aload(this.varsIndex);
                this.method.swap();
                this.method.ldc(new Integer(index));
                this.method.swap();
                this.method.arraystore();
            }
        }
    }

    @Override
    public void assignLocalVariable(int index, int depth) {
        if (depth == 0) {
            this.assignLocalVariable(index);
            return;
        }
        this.method.dup();
        this.method.aload(this.scopeIndex);
        while (depth > 0) {
            this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getNextCapturedScope", CodegenUtils.sig(DynamicScope.class));
            --depth;
        }
        switch (index) {
            case 0: {
                this.method.swap();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueZeroDepthZero", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(IRubyObject.class)));
                break;
            }
            case 1: {
                this.method.swap();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueOneDepthZero", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(IRubyObject.class)));
                break;
            }
            default: {
                this.method.swap();
                this.method.ldc(new Integer(index));
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueDepthZero", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(IRubyObject.class, Integer.TYPE)));
            }
        }
    }

    @Override
    public void retrieveLocalVariable(int index) {
        switch (index) {
            case 0: {
                this.method.aload(this.scopeIndex);
                this.methodCompiler.loadNil();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueZeroDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                break;
            }
            case 1: {
                this.method.aload(this.scopeIndex);
                this.methodCompiler.loadNil();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueOneDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                break;
            }
            default: {
                this.method.aload(this.varsIndex);
                this.method.ldc(new Integer(index));
                this.method.arrayload();
            }
        }
    }

    @Override
    public void retrieveLocalVariable(int index, int depth) {
        if (depth == 0) {
            this.retrieveLocalVariable(index);
            return;
        }
        this.method.aload(this.scopeIndex);
        while (depth > 0) {
            this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getNextCapturedScope", CodegenUtils.sig(DynamicScope.class));
            --depth;
        }
        switch (index) {
            case 0: {
                this.methodCompiler.loadNil();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueZeroDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                break;
            }
            case 1: {
                this.methodCompiler.loadNil();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueOneDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                break;
            }
            default: {
                this.method.ldc(new Integer(index));
                this.methodCompiler.loadNil();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Integer.TYPE, IRubyObject.class)));
            }
        }
    }
}

