/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubySymbol;
import org.jruby.compiler.CacheCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.MethodIndex;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;

public class FieldBasedCacheCompiler
implements CacheCompiler {
    protected StandardASMCompiler scriptCompiler;
    Map<String, String> sourcePositions = new HashMap<String, String>();
    Map<String, String> byteLists = new HashMap<String, String>();
    Map<BigInteger, String> bigIntegers = new HashMap<BigInteger, String>();
    Map<String, String> symbols = new HashMap<String, String>();

    public FieldBasedCacheCompiler(StandardASMCompiler scriptCompiler) {
        this.scriptCompiler = scriptCompiler;
    }

    @Override
    public void cacheCallSite(SkinnyMethodAdapter method, String name, CallType callType) {
        String fieldName = this.scriptCompiler.getNewConstant(CodegenUtils.ci(CallSite.class), JavaNameMangler.mangleStringForCleanJavaIdentifier(name));
        SkinnyMethodAdapter initMethod = this.scriptCompiler.getInitMethod();
        initMethod.aload(0);
        initMethod.ldc(name);
        if (callType.equals(CallType.NORMAL)) {
            initMethod.invokestatic(CodegenUtils.p(MethodIndex.class), "getCallSite", CodegenUtils.sig(CallSite.class, CodegenUtils.params(String.class)));
        } else if (callType.equals(CallType.FUNCTIONAL)) {
            initMethod.invokestatic(CodegenUtils.p(MethodIndex.class), "getFunctionalCallSite", CodegenUtils.sig(CallSite.class, CodegenUtils.params(String.class)));
        } else if (callType.equals(CallType.VARIABLE)) {
            initMethod.invokestatic(CodegenUtils.p(MethodIndex.class), "getVariableCallSite", CodegenUtils.sig(CallSite.class, CodegenUtils.params(String.class)));
        }
        initMethod.putfield(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(CallSite.class));
        method.getfield(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(CallSite.class));
    }

    public void cachePosition(SkinnyMethodAdapter method, String file, int line) {
        String cleanName = JavaNameMangler.mangleStringForCleanJavaIdentifier(file + "$" + line);
        String fieldName = this.sourcePositions.get(cleanName);
        if (fieldName == null) {
            SkinnyMethodAdapter clinitMethod = this.scriptCompiler.getClassInitMethod();
            fieldName = this.scriptCompiler.getNewStaticConstant(CodegenUtils.ci(ISourcePosition.class), cleanName);
            this.sourcePositions.put(JavaNameMangler.mangleStringForCleanJavaIdentifier(file + "$" + line), fieldName);
            clinitMethod.ldc(file);
            clinitMethod.ldc(line);
            clinitMethod.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "constructPosition", CodegenUtils.sig(ISourcePosition.class, String.class, Integer.TYPE));
            clinitMethod.putstatic(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(ISourcePosition.class));
        }
        method.getstatic(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(ISourcePosition.class));
    }

    @Override
    public void cacheByteList(SkinnyMethodAdapter method, String contents) {
        String fieldName = this.byteLists.get(contents);
        if (fieldName == null) {
            SkinnyMethodAdapter clinitMethod = this.scriptCompiler.getClassInitMethod();
            fieldName = this.scriptCompiler.getNewStaticConstant(CodegenUtils.ci(ByteList.class), "byteList");
            this.byteLists.put(contents, fieldName);
            clinitMethod.ldc(contents);
            clinitMethod.invokestatic(CodegenUtils.p(ByteList.class), "create", CodegenUtils.sig(ByteList.class, CharSequence.class));
            clinitMethod.putstatic(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(ByteList.class));
        }
        method.getstatic(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(ByteList.class));
    }

    @Override
    public void cacheBigInteger(SkinnyMethodAdapter method, BigInteger bigint) {
        String fieldName = this.bigIntegers.get(bigint);
        if (fieldName == null) {
            SkinnyMethodAdapter clinitMethod = this.scriptCompiler.getClassInitMethod();
            fieldName = this.scriptCompiler.getNewStaticConstant(CodegenUtils.ci(BigInteger.class), "bigInt");
            this.bigIntegers.put(bigint, fieldName);
            clinitMethod.newobj(CodegenUtils.p(BigInteger.class));
            clinitMethod.dup();
            clinitMethod.ldc(bigint.toString());
            clinitMethod.invokespecial(CodegenUtils.p(BigInteger.class), "<init>", CodegenUtils.sig(Void.TYPE, String.class));
            clinitMethod.putstatic(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(BigInteger.class));
        }
        method.getstatic(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(BigInteger.class));
    }

    @Override
    public void cacheSymbol(SkinnyMethodAdapter method, String symbol) {
        String methodName = this.symbols.get(symbol);
        if (methodName == null) {
            String fieldName = this.scriptCompiler.getNewConstant(CodegenUtils.ci(RubySymbol.class), "symbol");
            methodName = "getSymbol" + fieldName;
            this.symbols.put(symbol, methodName);
            ClassVisitor cv = this.scriptCompiler.getClassVisitor();
            SkinnyMethodAdapter symMethod = new SkinnyMethodAdapter(cv.visitMethod(4098, methodName, CodegenUtils.sig(RubySymbol.class, Ruby.class), null, null));
            symMethod.start();
            symMethod.aload(0);
            symMethod.getfield(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(RubySymbol.class));
            symMethod.dup();
            symMethod.astore(2);
            Label ifNullEnd = new Label();
            symMethod.ifnull(ifNullEnd);
            symMethod.aload(2);
            symMethod.areturn();
            symMethod.label(ifNullEnd);
            symMethod.aload(0);
            symMethod.aload(1);
            symMethod.ldc(symbol);
            symMethod.invokevirtual(CodegenUtils.p(Ruby.class), "fastNewSymbol", CodegenUtils.sig(RubySymbol.class, String.class));
            symMethod.dup_x1();
            symMethod.putfield(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(RubySymbol.class));
            symMethod.areturn();
            symMethod.end();
        }
        method.aload(0);
        method.aload(6);
        method.invokevirtual(this.scriptCompiler.getClassname(), methodName, CodegenUtils.sig(RubySymbol.class, CodegenUtils.params(Ruby.class)));
    }
}

