/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.executable;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.ast.executable.RubiniusCMethod;
import org.jruby.ast.executable.RubiniusMachine;
import org.jruby.parser.LocalStaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubiniusRunner
implements Runnable {
    private Ruby runtime;
    public static final int RUBINIUS_BYTECODE_VERSION = 3;
    private Map methods = new HashMap();

    public RubiniusRunner(Ruby runtime, InputStream in, String filename) {
        try {
            this.runtime = runtime;
            this.readMagic(in);
            this.readVersion(in);
            this.readRest(in);
            in.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't read script: " + e);
        }
    }

    private final void readMagic(InputStream in) throws IOException {
        byte[] first = new byte[4];
        in.read(first);
        if (first[0] != 82 || first[1] != 66 || first[2] != 73 || first[3] != 88) {
            throw new RuntimeException("File is not a compiled Rubinius file");
        }
    }

    private final void readVersion(InputStream in) throws IOException {
        int version = RubiniusRunner.readInt(in);
        if (version != 3) {
            throw new RuntimeException("Can't run Rubinius code with version " + version);
        }
    }

    public static int readInt(InputStream in) throws IOException {
        byte[] theInt = new byte[4];
        in.read(theInt);
        int val = 0;
        val += theInt[0] << 24;
        val += theInt[1] << 16;
        val += theInt[2] << 8;
        return val += theInt[3];
    }

    private final void readRest(InputStream in) throws IOException {
        RubiniusCMethod obj = null;
        while ((obj = this.unmarshalCMethod(in)) != null) {
            this.methods.put(obj.name, obj);
        }
    }

    private final byte[] unmarshalCharArray(InputStream in) throws IOException {
        int length = RubiniusRunner.readInt(in);
        byte[] arr = new byte[length];
        in.read(arr);
        return arr;
    }

    private final String unmarshalString(InputStream in) throws IOException {
        int length = RubiniusRunner.readInt(in);
        byte[] arr = new byte[length];
        in.read(arr);
        return String.valueOf(arr);
    }

    private final int unmarshalInt(InputStream in) throws IOException {
        int neg = in.read();
        int val = RubiniusRunner.readInt(in);
        if (neg == 110) {
            val = -val;
        }
        return val;
    }

    private final IRubyObject[] unmarshalTuple(InputStream in) throws IOException {
        int length = RubiniusRunner.readInt(in);
        IRubyObject[] vals = new IRubyObject[length];
        for (int i = 0; i < length; ++i) {
            vals[i] = this.unmarshal(in);
        }
        return vals;
    }

    private final RubiniusCMethod unmarshalCMethod(InputStream in) throws IOException {
        RubyArray obj = (RubyArray)this.unmarshal(in);
        if (obj == null) {
            return null;
        }
        return new RubiniusCMethod(obj);
    }

    private final IRubyObject unmarshal(InputStream in) throws IOException {
        int tag = in.read();
        int len = -1;
        switch (tag) {
            case 105: {
                return this.runtime.newFixnum(this.unmarshalInt(in));
            }
            case 115: {
                return this.runtime.newString(this.unmarshalString(in));
            }
            case 120: {
                return this.runtime.newSymbol(this.unmarshalString(in));
            }
            case 112: {
                return this.runtime.newArray(this.unmarshalTuple(in));
            }
            case 98: {
                return this.runtime.newString(this.unmarshalString(in));
            }
            case 109: {
                return this.runtime.newArray(this.unmarshalTuple(in));
            }
            case 66: {
                System.err.println("B");
                return null;
            }
            case 100: {
                System.err.println("d");
                return null;
            }
            case 114: {
                System.err.println("r");
                return null;
            }
            case 110: {
                return this.runtime.getNil();
            }
            case 116: {
                return this.runtime.getTrue();
            }
            case 102: {
                return this.runtime.getFalse();
            }
        }
        return null;
    }

    @Override
    public void run() {
        RubiniusCMethod method = (RubiniusCMethod)this.methods.get("__script__");
        ThreadContext context = this.runtime.getCurrentContext();
        LocalStaticScope scope = new LocalStaticScope(null);
        if (scope.getModule() == null) {
            scope.setModule(this.runtime.getObject());
        }
        scope.setVariables(new String[method.locals]);
        context.setFile(method.file);
        context.setLine(-1);
        context.preScopedBody(DynamicScope.newDynamicScope(scope, null));
        RubiniusMachine.INSTANCE.exec(context, this.runtime.getObject(), method.code, method.literals, new IRubyObject[0]);
    }
}

