/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Region;
import org.joni.encoding.Encoding;
import org.joni.encoding.specific.ASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.Frame;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.Pack;
import org.jruby.util.Sprintf;

public class RubyString
extends RubyObject {
    private static final ASCIIEncoding ASCII = ASCIIEncoding.INSTANCE;
    private static final int SHARE_LEVEL_NONE = 0;
    private static final int SHARE_LEVEL_BUFFER = 1;
    private static final int SHARE_LEVEL_BYTELIST = 2;
    private volatile int shareLevel = 0;
    private ByteList value;
    private static ObjectAllocator STRING_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            RubyString newString = runtime.newStringShared(ByteList.EMPTY_BYTELIST);
            newString.setMetaClass(klass);
            return newString;
        }
    };
    private static final ByteList SPACE_BYTELIST = new ByteList(ByteList.plain(" "));
    private static final int TRANS_SIZE = 256;

    public static RubyClass createStringClass(Ruby runtime) {
        RubyClass stringClass = runtime.defineClass("String", runtime.getObject(), STRING_ALLOCATOR);
        runtime.setString(stringClass);
        stringClass.index = 4;
        stringClass.kindOf = new RubyModule.KindOf(){

            @Override
            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyString;
            }
        };
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyString.class);
        stringClass.includeModule(runtime.getComparable());
        stringClass.includeModule(runtime.getEnumerable());
        stringClass.defineAnnotatedMethods(RubyString.class);
        stringClass.dispatcher = callbackFactory.createDispatcher(stringClass);
        return stringClass;
    }

    @Override
    public final boolean eql(IRubyObject other) {
        if (other.getMetaClass() == this.getRuntime().getString()) {
            return this.value.equal(((RubyString)other).value);
        }
        return super.eql(other);
    }

    private RubyString(Ruby runtime, RubyClass rubyClass, CharSequence value) {
        super(runtime, rubyClass);
        assert (value != null);
        this.value = new ByteList(ByteList.plain(value), false);
    }

    private RubyString(Ruby runtime, RubyClass rubyClass, byte[] value) {
        super(runtime, rubyClass);
        assert (value != null);
        this.value = new ByteList(value);
    }

    private RubyString(Ruby runtime, RubyClass rubyClass, ByteList value) {
        super(runtime, rubyClass);
        assert (value != null);
        this.value = value;
    }

    private RubyString(Ruby runtime, RubyClass rubyClass, ByteList value, boolean objectSpace) {
        super(runtime, rubyClass, objectSpace);
        assert (value != null);
        this.value = value;
    }

    @Override
    public int getNativeTypeIndex() {
        return 4;
    }

    @Override
    public Class getJavaClass() {
        return String.class;
    }

    @Override
    public RubyString convertToString() {
        return this;
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    public final RubyString strDup() {
        return this.strDup(this.getMetaClass());
    }

    final RubyString strDup(RubyClass clazz) {
        this.shareLevel = 2;
        RubyString dup = new RubyString(this.getRuntime(), clazz, this.value);
        dup.shareLevel = 2;
        dup.infectBy(this);
        return dup;
    }

    public final RubyString makeShared(int index, int len) {
        if (len == 0) {
            RubyString s = RubyString.newEmptyString(this.getRuntime(), this.getMetaClass());
            s.infectBy(this);
            return s;
        }
        if (this.shareLevel == 0) {
            this.shareLevel = 1;
        }
        RubyString shared = new RubyString(this.getRuntime(), this.getMetaClass(), this.value.makeShared(index, len));
        shared.shareLevel = 1;
        shared.infectBy(this);
        return shared;
    }

    private final void modifyCheck() {
        if ((this.flags & 4) != 0) {
            throw this.getRuntime().newFrozenError("string" + this.getMetaClass().getName());
        }
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't modify string");
        }
    }

    private final void modifyCheck(byte[] b, int len) {
        if (this.value.bytes != b || this.value.realSize != len) {
            throw this.getRuntime().newRuntimeError("string modified");
        }
    }

    private final void frozenCheck() {
        if (this.isFrozen()) {
            throw this.getRuntime().newRuntimeError("string frozen");
        }
    }

    public final void modify() {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 2) {
                this.value = this.value.dup();
            } else {
                this.value.unshare();
            }
            this.shareLevel = 0;
        }
        this.value.invalidate();
    }

    public final void modify(int length) {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 2) {
                this.value = this.value.dup(length);
            } else {
                this.value.unshare(length);
            }
            this.shareLevel = 0;
        } else {
            this.value.ensure(length);
        }
        this.value.invalidate();
    }

    private final void view(ByteList bytes) {
        this.modifyCheck();
        this.value = bytes;
        this.shareLevel = 0;
    }

    private final void view(byte[] bytes) {
        this.modifyCheck();
        this.value.replace(bytes);
        this.shareLevel = 0;
        this.value.invalidate();
    }

    private final void view(int index, int len) {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 2) {
                this.value = this.value.makeShared(index, len);
                this.shareLevel = 1;
            } else {
                this.value.view(index, len);
            }
        } else {
            this.value.view(index, len);
            this.shareLevel = 1;
        }
        this.value.invalidate();
    }

    public static String bytesToString(byte[] bytes, int beg, int len) {
        return new String(ByteList.plain(bytes, beg, len));
    }

    public static String byteListToString(ByteList bytes) {
        return RubyString.bytesToString(bytes.unsafeBytes(), bytes.begin(), bytes.length());
    }

    public static String bytesToString(byte[] bytes) {
        return RubyString.bytesToString(bytes, 0, bytes.length);
    }

    public static byte[] stringToBytes(String string) {
        return ByteList.plain(string);
    }

    public static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    public static boolean isUpper(int c) {
        return c >= 65 && c <= 90;
    }

    public static boolean isLower(int c) {
        return c >= 97 && c <= 122;
    }

    public static boolean isLetter(int c) {
        return RubyString.isUpper(c) || RubyString.isLower(c);
    }

    public static boolean isAlnum(int c) {
        return RubyString.isUpper(c) || RubyString.isLower(c) || RubyString.isDigit(c);
    }

    public static boolean isPrint(int c) {
        return c >= 32 && c <= 126;
    }

    @Override
    public RubyString asString() {
        return this;
    }

    @Override
    public IRubyObject checkStringType() {
        return this;
    }

    @Override
    @JRubyMethod(name={"to_s", "to_str"})
    public IRubyObject to_s() {
        if (this.getMetaClass().getRealClass() != this.getRuntime().getString()) {
            return this.strDup(this.getRuntime().getString());
        }
        return this;
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        IRubyObject result;
        if (other instanceof RubyString) {
            return this.getRuntime().newFixnum(this.op_cmp((RubyString)other));
        }
        if (other.respondsTo("to_str") && other.respondsTo("<=>") && (result = other.callMethod(context, MethodIndex.OP_SPACESHIP, "<=>", this)) instanceof RubyNumeric) {
            return ((RubyNumeric)result).op_uminus(context);
        }
        return this.getRuntime().getNil();
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyString)) {
            if (!other.respondsTo("to_str")) {
                return this.getRuntime().getFalse();
            }
            Ruby runtime = this.getRuntime();
            return other.callMethod(context, MethodIndex.EQUALEQUAL, "==", this).isTrue() ? runtime.getTrue() : runtime.getFalse();
        }
        return this.value.equal(((RubyString)other).value) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(IRubyObject other) {
        RubyString str = other.convertToString();
        ByteList result = new ByteList(this.value.realSize + str.value.realSize);
        result.realSize = this.value.realSize + str.value.realSize;
        System.arraycopy(this.value.bytes, this.value.begin, result.bytes, 0, this.value.realSize);
        System.arraycopy(str.value.bytes, str.value.begin, result.bytes, this.value.realSize, str.value.realSize);
        RubyString resultStr = RubyString.newString(this.getRuntime(), result);
        if (this.isTaint() || str.isTaint()) {
            resultStr.setTaint(true);
        }
        return resultStr;
    }

    @JRubyMethod(name={"*"}, required=1)
    public IRubyObject op_mul(IRubyObject other) {
        RubyInteger otherInteger = other.convertToInteger();
        long len = otherInteger.getLongValue();
        if (len < 0L) {
            throw this.getRuntime().newArgumentError("negative argument");
        }
        if (len > 0L && Integer.MAX_VALUE / len < (long)this.value.length()) {
            throw this.getRuntime().newArgumentError("argument too big");
        }
        ByteList newBytes = new ByteList(this.value.length() * (int)len);
        int i = 0;
        while ((long)i < len) {
            newBytes.append(this.value);
            ++i;
        }
        RubyString newString = new RubyString(this.getRuntime(), this.getMetaClass(), newBytes);
        newString.setTaint(this.isTaint());
        return newString;
    }

    @JRubyMethod(name={"%"}, required=1)
    public IRubyObject op_format(IRubyObject arg) {
        RubyString s = Sprintf.sprintf(this.getRuntime(), Locale.US, this.value, arg);
        s.infectBy(this);
        return s;
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.value.hashCode());
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof RubyString) {
            RubyString string = (RubyString)other;
            if (string.value.equal(this.value)) {
                return true;
            }
        }
        return false;
    }

    public static RubyString objAsString(ThreadContext context, IRubyObject obj) {
        if (obj instanceof RubyString) {
            return (RubyString)obj;
        }
        IRubyObject str = obj.callMethod(context, MethodIndex.TO_S, "to_s");
        if (!(str instanceof RubyString)) {
            return (RubyString)obj.anyToString();
        }
        if (obj.isTaint()) {
            str.setTaint(true);
        }
        return (RubyString)str;
    }

    public int op_cmp(RubyString other) {
        return this.value.cmp(other.value);
    }

    @Override
    public String asJavaString() {
        return this.toString();
    }

    public RubyString newString(CharSequence s) {
        return new RubyString(this.getRuntime(), this.getType(), s);
    }

    public RubyString newString(ByteList s) {
        return new RubyString(this.getRuntime(), this.getMetaClass(), s);
    }

    public static RubyString newString(Ruby runtime, CharSequence str) {
        return new RubyString(runtime, runtime.getString(), str);
    }

    public static RubyString newEmptyString(Ruby runtime) {
        return RubyString.newEmptyString(runtime, runtime.getString());
    }

    public static RubyString newEmptyString(Ruby runtime, RubyClass metaClass) {
        RubyString empty = new RubyString(runtime, metaClass, ByteList.EMPTY_BYTELIST);
        empty.shareLevel = 2;
        return empty;
    }

    public static RubyString newUnicodeString(Ruby runtime, String str) {
        try {
            return new RubyString(runtime, runtime.getString(), new ByteList(str.getBytes("UTF8"), false));
        }
        catch (UnsupportedEncodingException uee) {
            return new RubyString(runtime, runtime.getString(), str);
        }
    }

    public static RubyString newString(Ruby runtime, RubyClass clazz, CharSequence str) {
        return new RubyString(runtime, clazz, str);
    }

    public static RubyString newString(Ruby runtime, byte[] bytes) {
        return new RubyString(runtime, runtime.getString(), bytes);
    }

    public static RubyString newString(Ruby runtime, ByteList bytes) {
        return new RubyString(runtime, runtime.getString(), bytes);
    }

    public static RubyString newStringLight(Ruby runtime, ByteList bytes) {
        return new RubyString(runtime, runtime.getString(), bytes, false);
    }

    public static RubyString newStringShared(Ruby runtime, RubyString orig) {
        orig.shareLevel = 2;
        RubyString str = new RubyString(runtime, runtime.getString(), orig.value);
        str.shareLevel = 2;
        return str;
    }

    public static RubyString newStringShared(Ruby runtime, ByteList bytes) {
        return RubyString.newStringShared(runtime, runtime.getString(), bytes);
    }

    public static RubyString newStringShared(Ruby runtime, RubyClass clazz, ByteList bytes) {
        RubyString str = new RubyString(runtime, clazz, bytes);
        str.shareLevel = 2;
        return str;
    }

    public static RubyString newString(Ruby runtime, byte[] bytes, int start, int length) {
        byte[] bytes2 = new byte[length];
        System.arraycopy(bytes, start, bytes2, 0, length);
        return new RubyString(runtime, runtime.getString(), new ByteList(bytes2, false));
    }

    public IRubyObject doClone() {
        return RubyString.newString(this.getRuntime(), this.value.dup());
    }

    public RubyString cat(byte[] str) {
        this.modify(this.value.realSize + str.length);
        System.arraycopy(str, 0, this.value.bytes, this.value.begin + this.value.realSize, str.length);
        this.value.realSize += str.length;
        return this;
    }

    public RubyString cat(byte[] str, int beg, int len) {
        this.modify(this.value.realSize + len);
        System.arraycopy(str, beg, this.value.bytes, this.value.begin + this.value.realSize, len);
        this.value.realSize += len;
        return this;
    }

    public RubyString cat(ByteList str) {
        this.modify(this.value.realSize + str.realSize);
        System.arraycopy(str.bytes, str.begin, this.value.bytes, this.value.begin + this.value.realSize, str.realSize);
        this.value.realSize += str.realSize;
        return this;
    }

    public RubyString cat(byte ch) {
        this.modify(this.value.realSize + 1);
        this.value.bytes[this.value.begin + this.value.realSize] = ch;
        ++this.value.realSize;
        return this;
    }

    @JRubyMethod(name={"replace", "initialize_copy"}, required=1)
    public RubyString replace(IRubyObject other) {
        if (this == other) {
            return this;
        }
        this.modifyCheck();
        RubyString otherStr = RubyString.stringValue(other);
        this.shareLevel = 2;
        otherStr.shareLevel = 2;
        this.value = otherStr.value;
        this.infectBy(other);
        return this;
    }

    @JRubyMethod(name={"reverse"})
    public RubyString reverse() {
        if (this.value.length() <= 1) {
            return this.strDup();
        }
        ByteList buf = new ByteList(this.value.length() + 2);
        buf.realSize = this.value.length();
        int src = this.value.length() - 1;
        int dst = 0;
        while (src >= 0) {
            buf.set(dst++, this.value.get(src--));
        }
        RubyString rev = new RubyString(this.getRuntime(), this.getMetaClass(), buf);
        rev.infectBy(this);
        return rev;
    }

    @JRubyMethod(name={"reverse!"})
    public RubyString reverse_bang() {
        if (this.value.length() > 1) {
            this.modify();
            for (int i = 0; i < this.value.length() / 2; ++i) {
                byte b = (byte)this.value.get(i);
                this.value.set(i, this.value.get(this.value.length() - i - 1));
                this.value.set(this.value.length() - i - 1, b);
            }
        }
        return this;
    }

    public static RubyString newInstance(IRubyObject recv, IRubyObject[] args, Block block) {
        RubyString newString = RubyString.newStringShared(recv.getRuntime(), ByteList.EMPTY_BYTELIST);
        newString.setMetaClass((RubyClass)recv);
        newString.callInit(args, block);
        return newString;
    }

    @JRubyMethod(name={"initialize"}, optional=1, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args, Block unusedBlock) {
        if (args.length == 1) {
            this.replace(args[0]);
        }
        return this;
    }

    @JRubyMethod(name={"casecmp"}, required=1)
    public IRubyObject casecmp(IRubyObject other) {
        int compare = this.value.caseInsensitiveCmp(RubyString.stringValue((IRubyObject)other).value);
        return RubyFixnum.newFixnum(this.getRuntime(), compare);
    }

    @Override
    @JRubyMethod(name={"=~"}, required=1)
    public IRubyObject op_match(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyRegexp) {
            return ((RubyRegexp)other).op_match(context, this);
        }
        if (other instanceof RubyString) {
            throw this.getRuntime().newTypeError("type mismatch: String given");
        }
        return other.callMethod(context, "=~", this);
    }

    @JRubyMethod(name={"~"})
    public IRubyObject op_match2(ThreadContext context) {
        return RubyRegexp.newRegexp(this.getRuntime(), this.value, 0, false).op_match2(context);
    }

    @JRubyMethod(name={"match"}, required=1)
    public IRubyObject match(ThreadContext context, IRubyObject pattern) {
        return this.getPattern(pattern, false).callMethod(context, "match", this);
    }

    @JRubyMethod(name={"capitalize"})
    public IRubyObject capitalize() {
        RubyString str = this.strDup();
        str.capitalize_bang();
        return str;
    }

    @JRubyMethod(name={"capitalize!"})
    public IRubyObject capitalize_bang() {
        if (this.value.realSize == 0) {
            this.modifyCheck();
            return this.getRuntime().getNil();
        }
        this.modify();
        int s = this.value.begin;
        int send = s + this.value.realSize;
        byte[] buf = this.value.bytes;
        boolean modify = false;
        int c = buf[s] & 0xFF;
        if (ASCII.isLower(c)) {
            buf[s] = (byte)ASCIIEncoding.asciiToUpper(c);
            modify = true;
        }
        while (++s < send) {
            c = (char)(buf[s] & 0xFF);
            if (!ASCII.isUpper(c)) continue;
            buf[s] = (byte)ASCIIEncoding.asciiToLower(c);
            modify = true;
        }
        if (modify) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return this.getRuntime().newBoolean(this.op_cmp((RubyString)other) >= 0);
        }
        return RubyComparable.op_ge(context, this, other);
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return this.getRuntime().newBoolean(this.op_cmp((RubyString)other) > 0);
        }
        return RubyComparable.op_gt(context, this, other);
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return this.getRuntime().newBoolean(this.op_cmp((RubyString)other) <= 0);
        }
        return RubyComparable.op_le(context, this, other);
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return this.getRuntime().newBoolean(this.op_cmp((RubyString)other) < 0);
        }
        return RubyComparable.op_lt(context, this, other);
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject str_eql_p(IRubyObject other) {
        if (!(other instanceof RubyString)) {
            return this.getRuntime().getFalse();
        }
        RubyString otherString = (RubyString)other;
        return this.value.equal(otherString.value) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"upcase"})
    public RubyString upcase() {
        RubyString str = this.strDup();
        str.upcase_bang();
        return str;
    }

    @JRubyMethod(name={"upcase!"})
    public IRubyObject upcase_bang() {
        int s;
        if (this.value.realSize == 0) {
            this.modifyCheck();
            return this.getRuntime().getNil();
        }
        this.modify();
        int send = s + this.value.realSize;
        byte[] buf = this.value.bytes;
        boolean modify = false;
        for (s = this.value.begin; s < send; ++s) {
            int c = buf[s] & 0xFF;
            if (!ASCII.isLower(c)) continue;
            buf[s] = (byte)ASCIIEncoding.asciiToUpper(c);
            modify = true;
        }
        if (modify) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"downcase"})
    public RubyString downcase() {
        RubyString str = this.strDup();
        str.downcase_bang();
        return str;
    }

    @JRubyMethod(name={"downcase!"})
    public IRubyObject downcase_bang() {
        int s;
        if (this.value.realSize == 0) {
            this.modifyCheck();
            return this.getRuntime().getNil();
        }
        this.modify();
        int send = s + this.value.realSize;
        byte[] buf = this.value.bytes;
        boolean modify = false;
        for (s = this.value.begin; s < send; ++s) {
            int c = buf[s] & 0xFF;
            if (!ASCII.isUpper(c)) continue;
            buf[s] = (byte)ASCIIEncoding.asciiToLower(c);
            modify = true;
        }
        if (modify) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"swapcase"})
    public RubyString swapcase() {
        RubyString str = this.strDup();
        str.swapcase_bang();
        return str;
    }

    @JRubyMethod(name={"swapcase!"})
    public IRubyObject swapcase_bang() {
        int s;
        if (this.value.realSize == 0) {
            this.modifyCheck();
            return this.getRuntime().getNil();
        }
        this.modify();
        int send = s + this.value.realSize;
        byte[] buf = this.value.bytes;
        boolean modify = false;
        for (s = this.value.begin; s < send; ++s) {
            int c = buf[s] & 0xFF;
            if (ASCII.isUpper(c)) {
                buf[s] = (byte)ASCIIEncoding.asciiToLower(c);
                modify = true;
                continue;
            }
            if (!ASCII.isLower(c)) continue;
            buf[s] = (byte)ASCIIEncoding.asciiToUpper(c);
            modify = true;
        }
        if (modify) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"dump"})
    public IRubyObject dump() {
        RubyString s = new RubyString(this.getRuntime(), this.getMetaClass(), this.inspectIntoByteList(true));
        s.infectBy(this);
        return s;
    }

    @JRubyMethod(name={"insert"}, required=2)
    public IRubyObject insert(IRubyObject indexArg, IRubyObject stringArg) {
        RubyString s = stringArg.convertToString();
        ByteList insert = s.value;
        int index = (int)indexArg.convertToInteger().getLongValue();
        if (index < 0) {
            index += this.value.length() + 1;
        }
        if (index < 0 || index > this.value.length()) {
            throw this.getRuntime().newIndexError("index " + index + " out of range");
        }
        this.modify();
        this.value.unsafeReplace(index, 0, insert);
        this.infectBy(s);
        return this;
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        RubyString s = this.getRuntime().newString(this.inspectIntoByteList(false));
        s.infectBy(this);
        return s;
    }

    private ByteList inspectIntoByteList(boolean ignoreKCode) {
        Ruby runtime = this.getRuntime();
        Encoding enc = runtime.getKCode().getEncoding();
        int length = this.value.length();
        ByteList sb = new ByteList(length + 2 + length / 100);
        sb.append(34);
        for (int i = 0; i < length; ++i) {
            int seqLength;
            int c = this.value.get(i) & 0xFF;
            if (!ignoreKCode && (seqLength = enc.length((byte)c)) > 1 && i + seqLength - 1 < length) {
                sb.append(this.value, i, seqLength);
                i += seqLength - 1;
                continue;
            }
            if (RubyString.isAlnum(c)) {
                sb.append((char)c);
                continue;
            }
            if (c == 34 || c == 92) {
                sb.append(92).append((char)c);
                continue;
            }
            if (c == 35 && this.isEVStr(i, length)) {
                sb.append(92).append((char)c);
                continue;
            }
            if (RubyString.isPrint(c)) {
                sb.append((char)c);
                continue;
            }
            if (c == 10) {
                sb.append(92).append(110);
                continue;
            }
            if (c == 13) {
                sb.append(92).append(114);
                continue;
            }
            if (c == 9) {
                sb.append(92).append(116);
                continue;
            }
            if (c == 12) {
                sb.append(92).append(102);
                continue;
            }
            if (c == 11) {
                sb.append(92).append(118);
                continue;
            }
            if (c == 7) {
                sb.append(92).append(97);
                continue;
            }
            if (c == 8) {
                sb.append(92).append(98);
                continue;
            }
            if (c == 27) {
                sb.append(92).append(101);
                continue;
            }
            sb.append(ByteList.plain(Sprintf.sprintf(runtime, (CharSequence)"\\%03o", c)));
        }
        sb.append(34);
        return sb;
    }

    private boolean isEVStr(int i, int length) {
        if (i + 1 >= length) {
            return false;
        }
        int c = this.value.get(i + 1) & 0xFF;
        return c == 36 || c == 64 || c == 123;
    }

    @JRubyMethod(name={"length", "size"})
    public RubyFixnum length() {
        return this.getRuntime().newFixnum(this.value.length());
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p() {
        return this.isEmpty() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public boolean isEmpty() {
        return this.value.length() == 0;
    }

    public RubyString append(IRubyObject other) {
        this.infectBy(other);
        return this.cat(RubyString.stringValue((IRubyObject)other).value);
    }

    @JRubyMethod(name={"concat", "<<"}, required=1)
    public RubyString concat(IRubyObject other) {
        long value;
        if (other instanceof RubyFixnum && (value = ((RubyFixnum)other).getLongValue()) >= 0L && value < 256L) {
            return this.cat((byte)value);
        }
        return this.append(other);
    }

    @JRubyMethod(name={"crypt"}, required=1)
    public RubyString crypt(IRubyObject other) {
        ByteList salt = RubyString.stringValue(other).getByteList();
        if (salt.realSize < 2) {
            throw this.getRuntime().newArgumentError("salt too short(need >=2 bytes)");
        }
        salt = salt.makeShared(0, 2);
        RubyString s = RubyString.newStringShared(this.getRuntime(), JavaCrypt.crypt(salt, this.getByteList()));
        s.infectBy(this);
        s.infectBy(other);
        return s;
    }

    public static RubyString stringValue(IRubyObject object) {
        return (RubyString)(object instanceof RubyString ? object : object.convertToString());
    }

    @JRubyMethod(name={"sub"}, required=1, optional=1, frame=true)
    public IRubyObject sub(ThreadContext context, IRubyObject[] args, Block block) {
        RubyString str = this.strDup();
        str.sub_bang(context, args, block);
        return str;
    }

    @JRubyMethod(name={"sub!"}, required=1, optional=1, frame=true)
    public IRubyObject sub_bang(ThreadContext context, IRubyObject[] args, Block block) {
        boolean iter;
        RubyString repl = null;
        boolean tainted = false;
        if (args.length == 1 && block.isGiven()) {
            iter = true;
            tainted = false;
        } else if (args.length == 2) {
            repl = args[1].convertToString();
            iter = false;
            if (repl.isTaint()) {
                tainted = true;
            }
        } else {
            throw this.getRuntime().newArgumentError("wrong number of arguments (" + args.length + " for 2)");
        }
        RubyRegexp rubyRegex = this.getPattern(args[0], true);
        Regex regex = rubyRegex.getPattern();
        int range = this.value.begin + this.value.realSize;
        Matcher matcher = regex.matcher(this.value.bytes, this.value.begin, range);
        Frame frame = context.getPreviousFrame();
        if (matcher.search(this.value.begin, range, 0) >= 0) {
            int plen;
            int beg;
            if (iter) {
                byte[] bytes = this.value.bytes;
                int size = this.value.realSize;
                RubyMatchData match = rubyRegex.updateBackRef(this, frame, matcher);
                match.use();
                if (regex.numberOfCaptures() == 0) {
                    repl = RubyString.objAsString(context, block.yield(context, this.substr(matcher.getBegin(), matcher.getEnd() - matcher.getBegin())));
                } else {
                    Region region = matcher.getRegion();
                    repl = RubyString.objAsString(context, block.yield(context, this.substr(region.beg[0], region.end[0] - region.beg[0])));
                }
                this.modifyCheck(bytes, size);
                this.frozenCheck();
                frame.setBackRef(match);
            } else {
                repl = rubyRegex.regsub(repl, this, matcher);
                rubyRegex.updateBackRef(this, frame, matcher);
            }
            if (regex.numberOfCaptures() == 0) {
                beg = matcher.getBegin();
                plen = matcher.getEnd() - beg;
            } else {
                Region region = matcher.getRegion();
                beg = region.beg[0];
                plen = region.end[0] - beg;
            }
            ByteList replValue = repl.value;
            if (replValue.realSize > plen) {
                this.modify(this.value.realSize + replValue.realSize - plen);
            } else {
                this.modify();
            }
            if (repl.isTaint()) {
                tainted = true;
            }
            if (replValue.realSize != plen) {
                int src = this.value.begin + beg + plen;
                int dst = this.value.begin + beg + replValue.realSize;
                int length = this.value.realSize - beg - plen;
                System.arraycopy(this.value.bytes, src, this.value.bytes, dst, length);
            }
            System.arraycopy(replValue.bytes, replValue.begin, this.value.bytes, this.value.begin + beg, replValue.realSize);
            this.value.realSize += replValue.realSize - plen;
            if (tainted) {
                this.setTaint(true);
            }
            return this;
        }
        frame.setBackRef(this.getRuntime().getNil());
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"gsub"}, required=1, optional=1, frame=true)
    public IRubyObject gsub(ThreadContext context, IRubyObject[] args, Block block) {
        return this.gsub(context, args, block, false);
    }

    @JRubyMethod(name={"gsub!"}, required=1, optional=1, frame=true)
    public IRubyObject gsub_bang(ThreadContext context, IRubyObject[] args, Block block) {
        return this.gsub(context, args, block, true);
    }

    private final IRubyObject gsub(ThreadContext context, IRubyObject[] args, Block block, boolean bang) {
        RubyString repl;
        boolean iter;
        boolean tainted = false;
        if (args.length == 1 && block.isGiven()) {
            iter = true;
            repl = null;
        } else if (args.length == 2) {
            iter = false;
            repl = args[1].convertToString();
            if (repl.isTaint()) {
                tainted = true;
            }
        } else {
            throw this.getRuntime().newArgumentError("wrong number of arguments (" + args.length + "for 2)");
        }
        RubyRegexp rubyRegex = this.getPattern(args[0], true);
        Regex regex = rubyRegex.getPattern();
        int begin = this.value.begin;
        int range = begin + this.value.realSize;
        Matcher matcher = regex.matcher(this.value.bytes, begin, range);
        int beg = matcher.search(begin, range, 0);
        Frame frame = context.getPreviousFrame();
        if (beg < 0) {
            frame.setBackRef(this.getRuntime().getNil());
            return bang ? this.getRuntime().getNil() : this.strDup();
        }
        int blen = this.value.realSize + 30;
        ByteList dest = new ByteList(blen);
        dest.realSize = blen;
        int buf = 0;
        int bp = 0;
        int cp = this.value.begin;
        int offset = 0;
        RubyMatchData match = null;
        while (beg >= 0) {
            RubyString val;
            int endz;
            int begz;
            if (iter) {
                byte[] bytes = this.value.bytes;
                int size = this.value.realSize;
                match = rubyRegex.updateBackRef(this, frame, matcher);
                match.use();
                if (regex.numberOfCaptures() == 0) {
                    begz = matcher.getBegin();
                    endz = matcher.getEnd();
                    val = RubyString.objAsString(context, block.yield(context, this.substr(begz, endz - begz)));
                } else {
                    Region region = matcher.getRegion();
                    begz = region.beg[0];
                    endz = region.end[0];
                    val = RubyString.objAsString(context, block.yield(context, this.substr(begz, endz - begz)));
                }
                this.modifyCheck(bytes, size);
                if (bang) {
                    this.frozenCheck();
                }
            } else {
                val = rubyRegex.regsub(repl, this, matcher);
                if (regex.numberOfCaptures() == 0) {
                    begz = matcher.getBegin();
                    endz = matcher.getEnd();
                } else {
                    Region region = matcher.getRegion();
                    begz = region.beg[0];
                    endz = region.end[0];
                }
            }
            if (val.isTaint()) {
                tainted = true;
            }
            ByteList vbuf = val.value;
            int len = bp - buf + (beg - offset) + vbuf.realSize + 3;
            if (blen < len) {
                while (blen < len) {
                    blen <<= 1;
                }
                len = bp - buf;
                dest.realloc(blen);
                dest.realSize = blen;
                bp = buf + len;
            }
            len = beg - offset;
            System.arraycopy(this.value.bytes, cp, dest.bytes, bp, len);
            System.arraycopy(vbuf.bytes, vbuf.begin, dest.bytes, bp += len, vbuf.realSize);
            bp += vbuf.realSize;
            offset = endz;
            if (begz == endz) {
                if (this.value.realSize <= endz) break;
                len = regex.getEncoding().length(this.value.bytes[begin + endz]);
                System.arraycopy(this.value.bytes, begin + endz, dest.bytes, bp, len);
                bp += len;
                offset = endz + len;
            }
            cp = begin + offset;
            if (offset > this.value.realSize) break;
            beg = matcher.search(cp, range, 0);
        }
        if (this.value.realSize > offset) {
            int len = bp - buf;
            if (blen - len < this.value.realSize - offset) {
                blen = len + this.value.realSize - offset;
                dest.realloc(blen);
                bp = buf + len;
            }
            System.arraycopy(this.value.bytes, cp, dest.bytes, bp, this.value.realSize - offset);
            bp += this.value.realSize - offset;
        }
        if (match != null) {
            frame.setBackRef(match);
        } else {
            rubyRegex.updateBackRef(this, frame, matcher);
        }
        dest.realSize = bp - buf;
        if (bang) {
            this.view(dest);
            if (tainted) {
                this.setTaint(true);
            }
            return this;
        }
        RubyString destStr = new RubyString(this.getRuntime(), this.getMetaClass(), dest);
        destStr.infectBy(this);
        if (tainted) {
            destStr.setTaint(true);
        }
        return destStr;
    }

    @JRubyMethod(name={"index"}, required=1, optional=1)
    public IRubyObject index(ThreadContext context, IRubyObject[] args) {
        int pos = args.length == 2 ? RubyNumeric.num2int(args[1]) : 0;
        IRubyObject sub = args[0];
        if (pos < 0 && (pos += this.value.realSize) < 0) {
            if (sub instanceof RubyRegexp) {
                context.getPreviousFrame().setBackRef(this.getRuntime().getNil());
            }
            return this.getRuntime().getNil();
        }
        if (sub instanceof RubyRegexp) {
            RubyRegexp regSub = (RubyRegexp)sub;
            pos = regSub.adjustStartPos(this, pos, false);
            pos = regSub.search(context, this, pos, false);
        } else {
            if (sub instanceof RubyFixnum) {
                int c_int = RubyNumeric.fix2int(sub);
                if (c_int < 0 || c_int > 255) {
                    return this.getRuntime().getNil();
                }
                byte c = (byte)c_int;
                byte[] bytes = this.value.bytes;
                int end = this.value.begin + this.value.realSize;
                pos += this.value.begin;
                while (pos < end) {
                    if (bytes[pos] == c) {
                        return RubyFixnum.newFixnum(this.getRuntime(), pos - this.value.begin);
                    }
                    ++pos;
                }
                return this.getRuntime().getNil();
            }
            if (sub instanceof RubyString) {
                pos = this.strIndex((RubyString)sub, pos);
            } else {
                IRubyObject tmp = sub.checkStringType();
                if (tmp.isNil()) {
                    throw this.getRuntime().newTypeError("type mismatch: " + sub.getMetaClass().getName() + " given");
                }
                pos = this.strIndex((RubyString)tmp, pos);
            }
        }
        return pos == -1 ? this.getRuntime().getNil() : RubyFixnum.newFixnum(this.getRuntime(), pos);
    }

    private int strIndex(RubyString sub, int offset) {
        if (offset < 0 && (offset += this.value.realSize) < 0) {
            return -1;
        }
        if (this.value.realSize - offset < sub.value.realSize) {
            return -1;
        }
        if (sub.value.realSize == 0) {
            return offset;
        }
        return this.value.indexOf(sub.value, offset);
    }

    @JRubyMethod(name={"rindex"}, required=1, optional=1)
    public IRubyObject rindex(ThreadContext context, IRubyObject[] args) {
        int pos;
        IRubyObject sub;
        if (args.length == 2) {
            sub = args[0];
            pos = RubyNumeric.num2int(args[1]);
            if (pos < 0 && (pos += this.value.realSize) < 0) {
                if (sub instanceof RubyRegexp) {
                    context.getPreviousFrame().setBackRef(this.getRuntime().getNil());
                }
                return this.getRuntime().getNil();
            }
            if (pos > this.value.realSize) {
                pos = this.value.realSize;
            }
        } else {
            sub = args[0];
            pos = this.value.realSize;
        }
        if (sub instanceof RubyRegexp) {
            RubyRegexp regSub = (RubyRegexp)sub;
            if (regSub.length() > 0) {
                pos = regSub.adjustStartPos(this, pos, true);
                pos = regSub.search(context, this, pos, true);
            }
            if (pos >= 0) {
                return RubyFixnum.newFixnum(this.getRuntime(), pos);
            }
        } else if (sub instanceof RubyString) {
            if ((pos = this.strRindex((RubyString)sub, pos)) >= 0) {
                return RubyFixnum.newFixnum(this.getRuntime(), pos);
            }
        } else {
            if (sub instanceof RubyFixnum) {
                int c_int = RubyNumeric.fix2int(sub);
                if (c_int < 0 || c_int > 255) {
                    return this.getRuntime().getNil();
                }
                byte c = (byte)c_int;
                byte[] bytes = this.value.bytes;
                int pbeg = this.value.begin;
                int p = pbeg + pos;
                if (pos == this.value.realSize) {
                    if (pos == 0) {
                        return this.getRuntime().getNil();
                    }
                    --p;
                }
                while (pbeg <= p) {
                    if (bytes[p] == c) {
                        return RubyFixnum.newFixnum(this.getRuntime(), p - this.value.begin);
                    }
                    --p;
                }
                return this.getRuntime().getNil();
            }
            throw this.getRuntime().newTypeError("type mismatch: " + sub.getMetaClass().getName() + " given");
        }
        return this.getRuntime().getNil();
    }

    private int strRindex(RubyString sub, int pos) {
        int subLength = sub.value.realSize;
        if (this.value.realSize < subLength) {
            return -1;
        }
        if (this.value.realSize - pos < subLength) {
            pos = this.value.realSize - subLength;
        }
        return this.value.lastIndexOf(sub.value, pos);
    }

    public IRubyObject substr(int beg, int len) {
        int length = this.value.length();
        if (len < 0 || beg > length) {
            return this.getRuntime().getNil();
        }
        if (beg < 0 && (beg += length) < 0) {
            return this.getRuntime().getNil();
        }
        int end = Math.min(length, beg + len);
        return this.makeShared(beg, end - beg);
    }

    public IRubyObject replace(int beg, int len, RubyString replaceWith) {
        if (beg + len >= this.value.length()) {
            len = this.value.length() - beg;
        }
        this.modify();
        this.value.unsafeReplace(beg, len, replaceWith.value);
        return this.infectBy(replaceWith);
    }

    @JRubyMethod(name={"[]", "slice"}, required=1, optional=1)
    public IRubyObject op_aref(ThreadContext context, IRubyObject[] args) {
        if (args.length == 2) {
            if (args[0] instanceof RubyRegexp) {
                if (((RubyRegexp)args[0]).search(context, this, 0, false) >= 0) {
                    return RubyRegexp.nth_match(RubyNumeric.fix2int(args[1]), context.getCurrentFrame().getBackRef());
                }
                return this.getRuntime().getNil();
            }
            return this.substr(RubyNumeric.fix2int(args[0]), RubyNumeric.fix2int(args[1]));
        }
        if (args[0] instanceof RubyRegexp) {
            if (((RubyRegexp)args[0]).search(context, this, 0, false) >= 0) {
                return RubyRegexp.nth_match(0, context.getCurrentFrame().getBackRef());
            }
            return this.getRuntime().getNil();
        }
        if (args[0] instanceof RubyString) {
            return this.value.indexOf(RubyString.stringValue((IRubyObject)args[0]).value) != -1 ? args[0] : this.getRuntime().getNil();
        }
        if (args[0] instanceof RubyRange) {
            long[] begLen = ((RubyRange)args[0]).begLen(this.value.length(), 0);
            return begLen == null ? this.getRuntime().getNil() : this.substr((int)begLen[0], (int)begLen[1]);
        }
        int idx = (int)args[0].convertToInteger().getLongValue();
        if (idx < 0) {
            idx += this.value.length();
        }
        if (idx < 0 || idx >= this.value.length()) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(this.value.get(idx) & 0xFF);
    }

    private void subpatSet(ThreadContext context, RubyRegexp regexp, int nth, IRubyObject repl) {
        int end;
        int start;
        if (regexp.search(context, this, 0, false) < 0) {
            throw this.getRuntime().newIndexError("regexp not matched");
        }
        RubyMatchData match = (RubyMatchData)context.getCurrentFrame().getBackRef();
        if (match.regs == null) {
            if (nth >= 1) {
                throw this.getRuntime().newIndexError("index " + nth + " out of regexp");
            }
            if (nth < 0) {
                if (-nth >= 1) {
                    throw this.getRuntime().newIndexError("index " + nth + " out of regexp");
                }
                ++nth;
            }
            if ((start = match.begin) == -1) {
                throw this.getRuntime().newIndexError("regexp group " + nth + " not matched");
            }
            end = match.end;
        } else {
            if (nth >= match.regs.numRegs) {
                throw this.getRuntime().newIndexError("index " + nth + " out of regexp");
            }
            if (nth < 0) {
                if (-nth >= match.regs.numRegs) {
                    throw this.getRuntime().newIndexError("index " + nth + " out of regexp");
                }
                nth += match.regs.numRegs;
            }
            if ((start = match.regs.beg[nth]) == -1) {
                throw this.getRuntime().newIndexError("regexp group " + nth + " not matched");
            }
            end = match.regs.end[nth];
        }
        int len = end - start;
        this.replace(start, len, RubyString.stringValue(repl));
    }

    @JRubyMethod(name={"[]="}, required=2, optional=1)
    public IRubyObject op_aset(ThreadContext context, IRubyObject[] args) {
        int strLen = this.value.length();
        if (args.length == 3) {
            if (args[0] instanceof RubyRegexp) {
                RubyString repl = RubyString.stringValue(args[2]);
                int nth = RubyNumeric.fix2int(args[1]);
                this.subpatSet(context, (RubyRegexp)args[0], nth, repl);
                return repl;
            }
            RubyString repl = RubyString.stringValue(args[2]);
            int beg = RubyNumeric.fix2int(args[0]);
            int len = RubyNumeric.fix2int(args[1]);
            if (len < 0) {
                throw this.getRuntime().newIndexError("negative length");
            }
            if (beg < 0) {
                beg += strLen;
            }
            if (beg < 0 || beg > 0 && beg > strLen) {
                throw this.getRuntime().newIndexError("string index out of bounds");
            }
            if (beg + len > strLen) {
                len = strLen - beg;
            }
            this.replace(beg, len, repl);
            return repl;
        }
        if (args[0] instanceof RubyFixnum || args[0].respondsTo("to_int")) {
            int idx = RubyNumeric.fix2int(args[0]);
            if (idx < 0) {
                idx += this.value.length();
            }
            if (idx < 0 || idx >= this.value.length()) {
                throw this.getRuntime().newIndexError("string index out of bounds");
            }
            if (args[1] instanceof RubyFixnum) {
                this.modify();
                this.value.set(idx, (byte)RubyNumeric.fix2int(args[1]));
            } else {
                this.replace(idx, 1, RubyString.stringValue(args[1]));
            }
            return args[1];
        }
        if (args[0] instanceof RubyRegexp) {
            RubyString repl = RubyString.stringValue(args[1]);
            this.subpatSet(context, (RubyRegexp)args[0], 0, repl);
            return repl;
        }
        if (args[0] instanceof RubyString) {
            RubyString orig = RubyString.stringValue(args[0]);
            int beg = this.value.indexOf(orig.value);
            if (beg != -1) {
                this.replace(beg, orig.value.length(), RubyString.stringValue(args[1]));
            }
            return args[1];
        }
        if (args[0] instanceof RubyRange) {
            long[] idxs = ((RubyRange)args[0]).getBeginLength(this.value.length(), true, true);
            this.replace((int)idxs[0], (int)idxs[1], RubyString.stringValue(args[1]));
            return args[1];
        }
        throw this.getRuntime().newTypeError("wrong argument type");
    }

    @JRubyMethod(name={"slice!"}, required=1, optional=1)
    public IRubyObject slice_bang(ThreadContext context, IRubyObject[] args) {
        int argc = args.length;
        IRubyObject[] newArgs = new IRubyObject[argc + 1];
        newArgs[0] = args[0];
        if (argc > 1) {
            newArgs[1] = args[1];
        }
        newArgs[argc] = this.newString("");
        IRubyObject result = this.op_aref(context, args);
        if (result.isNil()) {
            return result;
        }
        this.op_aset(context, newArgs);
        return result;
    }

    @JRubyMethod(name={"succ", "next"})
    public IRubyObject succ() {
        return this.strDup().succ_bang();
    }

    @JRubyMethod(name={"succ!", "next!"})
    public IRubyObject succ_bang() {
        int i;
        if (this.value.length() == 0) {
            this.modifyCheck();
            return this;
        }
        this.modify();
        boolean alnumSeen = false;
        int pos = -1;
        int c = 0;
        int n = 0;
        for (i = this.value.length() - 1; i >= 0; --i) {
            c = this.value.get(i) & 0xFF;
            if (!RubyString.isAlnum(c)) continue;
            alnumSeen = true;
            if (RubyString.isDigit(c) && c < 57 || RubyString.isLower(c) && c < 122 || RubyString.isUpper(c) && c < 90) {
                this.value.set(i, (byte)(c + 1));
                pos = -1;
                break;
            }
            pos = i;
            int n2 = RubyString.isDigit(c) ? 49 : (n = RubyString.isLower(c) ? 97 : 65);
            this.value.set(i, (byte)(RubyString.isDigit(c) ? 48 : (RubyString.isLower(c) ? 97 : 65)));
        }
        if (!alnumSeen) {
            for (i = this.value.length() - 1; i >= 0; --i) {
                c = this.value.get(i) & 0xFF;
                if (c < 255) {
                    this.value.set(i, (byte)(c + 1));
                    pos = -1;
                    break;
                }
                pos = i;
                n = 1;
                this.value.set(i, 0);
            }
        }
        if (pos > -1) {
            this.value.insert(pos, (byte)n);
        }
        return this;
    }

    @JRubyMethod(name={"upto"}, required=1, frame=true)
    public IRubyObject upto(ThreadContext context, IRubyObject str, Block block) {
        return this.upto(context, str, false, block);
    }

    public IRubyObject upto(ThreadContext context, IRubyObject str, boolean excl, Block block) {
        RubyString beg = this;
        RubyString end = RubyString.stringValue(str);
        int n = beg.op_cmp(end);
        if (n > 0 || excl && n == 0) {
            return beg;
        }
        RubyString afterEnd = RubyString.stringValue(end.succ());
        RubyString current = beg;
        while (!current.equals(afterEnd)) {
            block.yield(context, current);
            if (!excl && current.equals(end)) break;
            current = (RubyString)current.succ();
            if ((!excl || !current.equals(end)) && current.length().getLongValue() <= end.length().getLongValue()) continue;
            break;
        }
        return beg;
    }

    @JRubyMethod(name={"include?"}, required=1)
    public RubyBoolean include_p(IRubyObject obj) {
        if (obj instanceof RubyFixnum) {
            int c = RubyNumeric.fix2int(obj);
            for (int i = 0; i < this.value.length(); ++i) {
                if (this.value.get(i) != (byte)c) continue;
                return this.getRuntime().getTrue();
            }
            return this.getRuntime().getFalse();
        }
        ByteList str = RubyString.stringValue((IRubyObject)obj).value;
        return this.getRuntime().newBoolean(this.value.indexOf(str) != -1);
    }

    @JRubyMethod(name={"to_i"}, optional=1)
    public IRubyObject to_i(IRubyObject[] args) {
        long base = args.length == 0 ? 10L : args[0].convertToInteger().getLongValue();
        return RubyNumeric.str2inum(this.getRuntime(), this, (int)base);
    }

    @JRubyMethod(name={"oct"})
    public IRubyObject oct() {
        int pos;
        int ix;
        if (this.isEmpty()) {
            return this.getRuntime().newFixnum(0L);
        }
        int base = 8;
        for (ix = this.value.begin; ix < this.value.begin + this.value.realSize && ASCII.isSpace(this.value.bytes[ix] & 0xFF); ++ix) {
        }
        int n = pos = this.value.bytes[ix] == 45 || this.value.bytes[ix] == 43 ? ix + 1 : ix;
        if (pos + 1 < this.value.begin + this.value.realSize && this.value.bytes[pos] == 48) {
            if (this.value.bytes[pos + 1] == 120 || this.value.bytes[pos + 1] == 88) {
                base = 16;
            } else if (this.value.bytes[pos + 1] == 98 || this.value.bytes[pos + 1] == 66) {
                base = 2;
            } else if (this.value.bytes[pos + 1] == 100 || this.value.bytes[pos + 1] == 68) {
                base = 10;
            }
        }
        return RubyNumeric.str2inum(this.getRuntime(), this, base);
    }

    @JRubyMethod(name={"hex"})
    public IRubyObject hex() {
        return RubyNumeric.str2inum(this.getRuntime(), this, 16);
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f() {
        return RubyNumeric.str2fnum(this.getRuntime(), this);
    }

    @JRubyMethod(name={"split"}, optional=2)
    public RubyArray split(ThreadContext context, IRubyObject[] args) {
        RubyArray result;
        IRubyObject spat;
        int i;
        boolean limit;
        int lim;
        if (args.length == 2) {
            lim = RubyNumeric.fix2int(args[1]);
            if (lim <= 0) {
                limit = false;
            } else {
                if (lim == 1) {
                    return this.value.realSize == 0 ? this.getRuntime().newArray() : this.getRuntime().newArray(this);
                }
                limit = true;
            }
            i = 1;
        } else {
            i = 0;
            lim = 0;
            limit = false;
        }
        IRubyObject iRubyObject = spat = args.length == 0 || args[0].isNil() ? null : args[0];
        if (spat == null && (spat = this.getRuntime().getGlobalVariables().get("$;")).isNil()) {
            result = this.awkSplit(limit, lim, i);
        } else if (spat instanceof RubyString && ((RubyString)spat).value.realSize == 1) {
            RubyString strSpat = (RubyString)spat;
            result = strSpat.value.bytes[strSpat.value.begin] == 32 ? this.awkSplit(limit, lim, i) : this.split(context, spat, limit, lim, i);
        } else {
            result = this.split(context, spat, limit, lim, i);
        }
        if (!limit && lim == 0) {
            while (result.size() > 0 && ((RubyString)result.eltInternal((int)(result.size() - 1))).value.realSize == 0) {
                result.pop();
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private RubyArray split(ThreadContext context, IRubyObject pat, boolean limit, int lim, int i) {
        int begin;
        Ruby runtime = this.getRuntime();
        Regex regex = this.getPattern(pat, true).getPattern();
        int start = begin = this.value.begin;
        int beg = 0;
        int range = this.value.begin + this.value.realSize;
        Matcher matcher = regex.matcher(this.value.bytes, this.value.begin, range);
        boolean lastNull = false;
        RubyArray result = runtime.newArray();
        if (regex.numberOfCaptures() == 0) {
            int end;
            while ((end = matcher.search(start, range, 0)) >= 0) {
                block17: {
                    if (start == end + begin && matcher.getBegin() == matcher.getEnd()) {
                        if (this.value.realSize == 0) {
                            result.append(RubyString.newEmptyString(runtime, this.getMetaClass()));
                            break;
                        }
                        if (lastNull) {
                            result.append(this.substr(beg, regex.getEncoding().length(this.value.bytes[begin + beg])));
                            beg = start - begin;
                            break block17;
                        } else {
                            start = start == range ? ++start : (start += regex.getEncoding().length(this.value.bytes[start]));
                            lastNull = true;
                            continue;
                        }
                    }
                    result.append(this.substr(beg, end - beg));
                    beg = matcher.getEnd();
                    start = begin + matcher.getEnd();
                }
                lastNull = false;
                if (!limit || lim > ++i) continue;
                break;
            }
        } else {
            int end;
            while ((end = matcher.search(start, range, 0)) >= 0) {
                Region region;
                block18: {
                    region = matcher.getRegion();
                    if (start == end + begin && region.beg[0] == region.end[0]) {
                        if (this.value.realSize == 0) {
                            result.append(RubyString.newEmptyString(runtime, this.getMetaClass()));
                            break;
                        }
                        if (lastNull) {
                            result.append(this.substr(beg, regex.getEncoding().length(this.value.bytes[begin + beg])));
                            beg = start - begin;
                            break block18;
                        } else {
                            start = start == range ? ++start : (start += regex.getEncoding().length(this.value.bytes[start]));
                            lastNull = true;
                            continue;
                        }
                    }
                    result.append(this.substr(beg, end - beg));
                    beg = start = region.end[0];
                    start += begin;
                }
                lastNull = false;
                for (int idx = 1; idx < region.numRegs; ++idx) {
                    if (region.beg[idx] == -1) continue;
                    if (region.beg[idx] == region.end[idx]) {
                        result.append(RubyString.newEmptyString(runtime, this.getMetaClass()));
                        continue;
                    }
                    result.append(this.substr(region.beg[idx], region.end[idx] - region.beg[idx]));
                }
                if (!limit || lim > ++i) continue;
            }
        }
        context.getCurrentFrame().setBackRef(runtime.getNil());
        if (this.value.realSize <= 0) return result;
        if (!limit && this.value.realSize <= beg) {
            if (lim >= 0) return result;
        }
        if (this.value.realSize == beg) {
            result.append(RubyString.newEmptyString(runtime, this.getMetaClass()));
            return result;
        }
        result.append(this.substr(beg, this.value.realSize - beg));
        return result;
    }

    private RubyArray awkSplit(boolean limit, int lim, int i) {
        int p;
        RubyArray result = this.getRuntime().newArray();
        byte[] bytes = this.value.bytes;
        int endp = p + this.value.realSize;
        boolean skip = true;
        int beg = 0;
        beg = 0;
        int end = 0;
        for (p = this.value.begin; p < endp; ++p) {
            if (skip) {
                if (ASCII.isSpace(bytes[p] & 0xFF)) {
                    ++beg;
                    continue;
                }
                end = beg + 1;
                skip = false;
                if (!limit || lim > i) continue;
                break;
            }
            if (ASCII.isSpace(bytes[p] & 0xFF)) {
                result.append(this.makeShared(beg, end - beg));
                skip = true;
                beg = end + 1;
                if (!limit) continue;
                ++i;
                continue;
            }
            ++end;
        }
        if (this.value.realSize > 0 && (limit || this.value.realSize > beg || lim < 0)) {
            if (this.value.realSize == beg) {
                result.append(RubyString.newEmptyString(this.getRuntime(), this.getMetaClass()));
            } else {
                result.append(this.makeShared(beg, this.value.realSize - beg));
            }
        }
        return result;
    }

    private final RubyRegexp getPattern(IRubyObject obj, boolean quote) {
        if (obj instanceof RubyRegexp) {
            return (RubyRegexp)obj;
        }
        if (!(obj instanceof RubyString)) {
            IRubyObject val = obj.checkStringType();
            if (val.isNil()) {
                throw this.getRuntime().newTypeError("wrong argument type " + obj.getMetaClass() + " (expected Regexp)");
            }
            obj = val;
        }
        return RubyRegexp.newRegexp(this.getRuntime(), ((RubyString)obj).value, 0, quote);
    }

    @JRubyMethod(name={"scan"}, required=1, frame=true)
    public IRubyObject scan(ThreadContext context, IRubyObject arg, Block block) {
        Ruby runtime = this.getRuntime();
        Frame frame = context.getPreviousFrame();
        RubyRegexp rubyRegex = this.getPattern(arg, true);
        Regex regex = rubyRegex.getPattern();
        int range = this.value.begin + this.value.realSize;
        Matcher matcher = regex.matcher(this.value.bytes, this.value.begin, range);
        matcher.value = 0;
        if (!block.isGiven()) {
            RubyArray ary = runtime.newArray();
            if (regex.numberOfCaptures() == 0) {
                IRubyObject result;
                while ((result = this.scanOnceNG(rubyRegex, matcher, range)) != null) {
                    ary.append(result);
                }
            } else {
                IRubyObject result;
                while ((result = this.scanOnce(rubyRegex, matcher, range)) != null) {
                    ary.append(result);
                }
            }
            if (ary.size() > 0) {
                rubyRegex.updateBackRef(this, frame, matcher);
            } else {
                frame.setBackRef(runtime.getNil());
            }
            return ary;
        }
        byte[] bytes = this.value.bytes;
        int size = this.value.realSize;
        IRubyObject match = null;
        if (regex.numberOfCaptures() == 0) {
            IRubyObject result;
            while ((result = this.scanOnceNG(rubyRegex, matcher, range)) != null) {
                match = rubyRegex.updateBackRef(this, frame, matcher);
                ((RubyMatchData)match).use();
                block.yield(context, result);
                this.modifyCheck(bytes, size);
            }
        } else {
            IRubyObject result;
            while ((result = this.scanOnce(rubyRegex, matcher, range)) != null) {
                match = rubyRegex.updateBackRef(this, frame, matcher);
                ((RubyMatchData)match).use();
                block.yield(context, result);
                this.modifyCheck(bytes, size);
            }
        }
        frame.setBackRef(match == null ? runtime.getNil() : match);
        return this;
    }

    private Encoding encodingCheck(RubyRegexp pattern) {
        return pattern.getKCode().getEncoding();
    }

    private IRubyObject scanOnceNG(RubyRegexp regex, Matcher matcher, int range) {
        if (matcher.search(matcher.value + this.value.begin, range, 0) >= 0) {
            int end = matcher.getEnd();
            matcher.value = matcher.getBegin() == end ? (this.value.realSize > end ? end + regex.getPattern().getEncoding().length(this.value.bytes[this.value.begin + end]) : end + 1) : end;
            return this.substr(matcher.getBegin(), end - matcher.getBegin()).infectBy(regex);
        }
        return null;
    }

    private IRubyObject scanOnce(RubyRegexp regex, Matcher matcher, int range) {
        if (matcher.search(matcher.value + this.value.begin, range, 0) >= 0) {
            Region region = matcher.getRegion();
            int end = region.end[0];
            matcher.value = region.beg[0] == end ? (this.value.realSize > end ? end + regex.getPattern().getEncoding().length(this.value.bytes[this.value.begin + end]) : end + 1) : end;
            RubyArray result = this.getRuntime().newArray(region.numRegs);
            for (int i = 1; i < region.numRegs; ++i) {
                int beg = region.beg[i];
                if (beg == -1) {
                    result.append(this.getRuntime().getNil());
                    continue;
                }
                result.append(this.substr(beg, region.end[i] - beg).infectBy(regex));
            }
            return result;
        }
        return null;
    }

    private final IRubyObject justify(IRubyObject[] args, char jflag) {
        int pend;
        byte[] fbuf;
        int f;
        IRubyObject pad;
        Ruby runtime = this.getRuntime();
        int width = RubyFixnum.num2int(args[0]);
        int flen = 0;
        if (args.length == 2) {
            pad = args[1].convertToString();
            ByteList fList = pad.value;
            f = fList.begin;
            flen = fList.realSize;
            if (flen == 0) {
                throw this.getRuntime().newArgumentError("zero width padding");
            }
            fbuf = fList.bytes;
        } else {
            f = RubyString.SPACE_BYTELIST.begin;
            flen = RubyString.SPACE_BYTELIST.realSize;
            fbuf = RubyString.SPACE_BYTELIST.bytes;
            pad = runtime.getNil();
        }
        if (width < 0 || this.value.realSize >= width) {
            return this.strDup();
        }
        ByteList res = new ByteList(width);
        res.realSize = width;
        int p = res.begin;
        byte[] pbuf = res.bytes;
        if (jflag != 'l') {
            int n = width - this.value.realSize;
            pend = p + (jflag == 'r' ? n : n / 2);
            if (flen <= 1) {
                while (p < pend) {
                    pbuf[p++] = fbuf[f];
                }
            } else {
                int q = f;
                while (p + flen <= pend) {
                    System.arraycopy(fbuf, f, pbuf, p, flen);
                    p += flen;
                }
                while (p < pend) {
                    pbuf[p++] = fbuf[q++];
                }
            }
        }
        System.arraycopy(this.value.bytes, this.value.begin, pbuf, p, this.value.realSize);
        if (jflag != 'r') {
            p += this.value.realSize;
            pend = res.begin + width;
            if (flen <= 1) {
                while (p < pend) {
                    pbuf[p++] = fbuf[f];
                }
            } else {
                while (p + flen <= pend) {
                    System.arraycopy(fbuf, f, pbuf, p, flen);
                    p += flen;
                }
                while (p < pend) {
                    pbuf[p++] = fbuf[f++];
                }
            }
        }
        RubyString resStr = new RubyString(runtime, this.getMetaClass(), res);
        resStr.infectBy(this);
        if (flen > 0) {
            resStr.infectBy(pad);
        }
        return resStr;
    }

    @JRubyMethod(name={"ljust"}, required=1, optional=1)
    public IRubyObject ljust(IRubyObject[] args) {
        return this.justify(args, 'l');
    }

    @JRubyMethod(name={"rjust"}, required=1, optional=1)
    public IRubyObject rjust(IRubyObject[] args) {
        return this.justify(args, 'r');
    }

    @JRubyMethod(name={"center"}, required=1, optional=1)
    public IRubyObject center(IRubyObject[] args) {
        return this.justify(args, 'c');
    }

    @JRubyMethod(name={"chop"})
    public IRubyObject chop() {
        RubyString str = this.strDup();
        str.chop_bang();
        return str;
    }

    @JRubyMethod(name={"chop!"})
    public IRubyObject chop_bang() {
        int end = this.value.realSize - 1;
        if (end < 0) {
            return this.getRuntime().getNil();
        }
        if (this.value.bytes[this.value.begin + end] == 10 && end > 0 && this.value.bytes[this.value.begin + end - 1] == 13) {
            --end;
        }
        this.view(0, end);
        return this;
    }

    @JRubyMethod(name={"chomp"}, optional=1)
    public RubyString chomp(IRubyObject[] args) {
        RubyString str = this.strDup();
        str.chomp_bang(args);
        return str;
    }

    @JRubyMethod(name={"chomp!"}, optional=1)
    public IRubyObject chomp_bang(IRubyObject[] args) {
        IRubyObject rsObj;
        if (args.length == 0) {
            int len = this.value.length();
            if (len == 0) {
                return this.getRuntime().getNil();
            }
            byte[] buff = this.value.bytes;
            rsObj = this.getRuntime().getGlobalVariables().get("$/");
            if (rsObj == this.getRuntime().getGlobalVariables().getDefaultSeparator()) {
                int realSize = this.value.realSize;
                int begin = this.value.begin;
                if (buff[begin + len - 1] == 10) {
                    if (--realSize > 0 && buff[begin + realSize - 1] == 13) {
                        --realSize;
                    }
                    this.view(0, realSize);
                } else if (buff[begin + len - 1] == 13) {
                    this.view(0, --realSize);
                } else {
                    this.modifyCheck();
                    return this.getRuntime().getNil();
                }
                return this;
            }
        } else {
            rsObj = args[0];
        }
        if (rsObj.isNil()) {
            return this.getRuntime().getNil();
        }
        RubyString rs = rsObj.convertToString();
        int len = this.value.realSize;
        int begin = this.value.begin;
        if (len == 0) {
            return this.getRuntime().getNil();
        }
        byte[] buff = this.value.bytes;
        int rslen = rs.value.realSize;
        if (rslen == 0) {
            while (len > 0 && buff[begin + len - 1] == 10) {
                if (--len <= 0 || buff[begin + len - 1] != 13) continue;
                --len;
            }
            if (len < this.value.realSize) {
                this.view(0, len);
                return this;
            }
            return this.getRuntime().getNil();
        }
        if (rslen > len) {
            return this.getRuntime().getNil();
        }
        byte newline = rs.value.bytes[rslen - 1];
        if (rslen == 1 && newline == 10) {
            buff = this.value.bytes;
            int realSize = this.value.realSize;
            if (buff[begin + len - 1] == 10) {
                if (--realSize > 0 && buff[begin + realSize - 1] == 13) {
                    --realSize;
                }
                this.view(0, realSize);
            } else if (buff[begin + len - 1] == 13) {
                this.view(0, --realSize);
            } else {
                this.modifyCheck();
                return this.getRuntime().getNil();
            }
            return this;
        }
        if (buff[begin + len - 1] == newline && rslen <= 1 || this.value.endsWith(rs.value)) {
            this.view(0, this.value.realSize - rslen);
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"lstrip"})
    public IRubyObject lstrip() {
        RubyString str = this.strDup();
        str.lstrip_bang();
        return str;
    }

    @JRubyMethod(name={"lstrip!"})
    public IRubyObject lstrip_bang() {
        int i;
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        for (i = 0; i < this.value.realSize && ASCII.isSpace(this.value.bytes[this.value.begin + i] & 0xFF); ++i) {
        }
        if (i > 0) {
            this.view(i, this.value.realSize - i);
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"rstrip"})
    public IRubyObject rstrip() {
        RubyString str = this.strDup();
        str.rstrip_bang();
        return str;
    }

    @JRubyMethod(name={"rstrip!"})
    public IRubyObject rstrip_bang() {
        int i;
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        for (i = this.value.realSize - 1; i >= 0 && this.value.bytes[this.value.begin + i] == 0; --i) {
        }
        while (i >= 0 && ASCII.isSpace(this.value.bytes[this.value.begin + i] & 0xFF)) {
            --i;
        }
        if (i < this.value.realSize - 1) {
            this.view(0, i + 1);
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"strip"})
    public IRubyObject strip() {
        RubyString str = this.strDup();
        str.strip_bang();
        return str;
    }

    @JRubyMethod(name={"strip!"})
    public IRubyObject strip_bang() {
        IRubyObject l = this.lstrip_bang();
        IRubyObject r = this.rstrip_bang();
        if (l.isNil() && r.isNil()) {
            return l;
        }
        return this;
    }

    @JRubyMethod(name={"count"}, required=1, rest=true)
    public IRubyObject count(IRubyObject[] args) {
        if (args.length < 1) {
            throw this.getRuntime().newArgumentError("wrong number of arguments");
        }
        if (this.value.realSize == 0) {
            return this.getRuntime().newFixnum(0L);
        }
        boolean[] table = new boolean[256];
        boolean init = true;
        for (int i = 0; i < args.length; ++i) {
            RubyString s = args[i].convertToString();
            s.setup_table(table, init);
            init = false;
        }
        int s = this.value.begin;
        int send = s + this.value.realSize;
        byte[] buf = this.value.bytes;
        int i = 0;
        while (s < send) {
            if (!table[buf[s++] & 0xFF]) continue;
            ++i;
        }
        return this.getRuntime().newFixnum(i);
    }

    @JRubyMethod(name={"delete"}, required=1, rest=true)
    public IRubyObject delete(IRubyObject[] args) {
        RubyString str = this.strDup();
        str.delete_bang(args);
        return str;
    }

    @JRubyMethod(name={"delete!"}, required=1, rest=true)
    public IRubyObject delete_bang(IRubyObject[] args) {
        int s;
        if (args.length < 1) {
            throw this.getRuntime().newArgumentError("wrong number of arguments");
        }
        boolean[] squeeze = new boolean[256];
        boolean init = true;
        for (int i = 0; i < args.length; ++i) {
            RubyString s2 = args[i].convertToString();
            s2.setup_table(squeeze, init);
            init = false;
        }
        this.modify();
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        int t = s = this.value.begin;
        int send = s + this.value.realSize;
        byte[] buf = this.value.bytes;
        boolean modify = false;
        while (s < send) {
            if (squeeze[buf[s] & 0xFF]) {
                modify = true;
            } else {
                buf[t++] = buf[s];
            }
            ++s;
        }
        this.value.realSize = t - this.value.begin;
        if (modify) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"squeeze"}, rest=true)
    public IRubyObject squeeze(IRubyObject[] args) {
        RubyString str = this.strDup();
        str.squeeze_bang(args);
        return str;
    }

    @JRubyMethod(name={"squeeze!"}, rest=true)
    public IRubyObject squeeze_bang(IRubyObject[] args) {
        int s;
        if (this.value.realSize == 0) {
            this.modifyCheck();
            return this.getRuntime().getNil();
        }
        boolean[] squeeze = new boolean[256];
        if (args.length == 0) {
            for (int i = 0; i < 256; ++i) {
                squeeze[i] = true;
            }
        } else {
            boolean init = true;
            for (int i = 0; i < args.length; ++i) {
                RubyString s2 = args[i].convertToString();
                s2.setup_table(squeeze, init);
                init = false;
            }
        }
        this.modify();
        int t = s = this.value.begin;
        int send = s + this.value.realSize;
        byte[] buf = this.value.bytes;
        int save = -1;
        while (s < send) {
            int c;
            if ((c = buf[s++] & 0xFF) == save && squeeze[c]) continue;
            int n = t++;
            save = c;
            buf[n] = (byte)save;
        }
        if (t - this.value.begin != this.value.realSize) {
            this.value.realSize = t - this.value.begin;
            return this;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"tr"}, required=2)
    public IRubyObject tr(IRubyObject src, IRubyObject repl) {
        RubyString str = this.strDup();
        str.tr_trans(src, repl, false);
        return str;
    }

    @JRubyMethod(name={"tr!"}, required=2)
    public IRubyObject tr_bang(IRubyObject src, IRubyObject repl) {
        return this.tr_trans(src, repl, false);
    }

    private final void setup_table(boolean[] table, boolean init) {
        int c;
        int i;
        boolean[] buf = new boolean[256];
        TR tr = new TR();
        boolean cflag = false;
        tr.p = this.value.begin;
        tr.pend = this.value.begin + this.value.realSize;
        tr.buf = this.value.bytes;
        tr.max = 0;
        tr.now = 0;
        tr.gen = 0;
        if (this.value.realSize > 1 && this.value.bytes[this.value.begin] == 94) {
            cflag = true;
            ++tr.p;
        }
        if (init) {
            for (i = 0; i < 256; ++i) {
                table[i] = true;
            }
        }
        for (i = 0; i < 256; ++i) {
            buf[i] = cflag;
        }
        while ((c = this.trnext(tr)) >= 0) {
            buf[c & 0xFF] = !cflag;
        }
        for (i = 0; i < 256; ++i) {
            table[i] = table[i] && buf[i];
        }
    }

    private final IRubyObject tr_trans(IRubyObject src, IRubyObject repl, boolean sflag) {
        int s;
        int c;
        int i;
        if (this.value.realSize == 0) {
            return this.getRuntime().getNil();
        }
        ByteList replList = repl.convertToString().value;
        if (replList.realSize == 0) {
            return this.delete_bang(new IRubyObject[]{src});
        }
        ByteList srcList = src.convertToString().value;
        TR trsrc = new TR();
        TR trrepl = new TR();
        boolean cflag = false;
        boolean modify = false;
        trsrc.p = srcList.begin;
        trsrc.pend = srcList.begin + srcList.realSize;
        trsrc.buf = srcList.bytes;
        if (srcList.realSize >= 2 && srcList.bytes[srcList.begin] == 94) {
            cflag = true;
            ++trsrc.p;
        }
        trrepl.p = replList.begin;
        trrepl.pend = replList.begin + replList.realSize;
        trrepl.buf = replList.bytes;
        trrepl.gen = 0;
        trsrc.gen = 0;
        trrepl.now = 0;
        trsrc.now = 0;
        trrepl.max = 0;
        trsrc.max = 0;
        int[] trans = new int[256];
        if (cflag) {
            for (i = 0; i < 256; ++i) {
                trans[i] = 1;
            }
            while ((c = this.trnext(trsrc)) >= 0) {
                trans[c & 0xFF] = -1;
            }
            while ((c = this.trnext(trrepl)) >= 0) {
            }
            for (i = 0; i < 256; ++i) {
                if (trans[i] < 0) continue;
                trans[i] = trrepl.now;
            }
        } else {
            for (i = 0; i < 256; ++i) {
                trans[i] = -1;
            }
            while ((c = this.trnext(trsrc)) >= 0) {
                int r = this.trnext(trrepl);
                if (r == -1) {
                    r = trrepl.now;
                }
                trans[c & 0xFF] = r;
            }
        }
        this.modify();
        int send = s + this.value.realSize;
        byte[] sbuf = this.value.bytes;
        if (sflag) {
            int t = s;
            int last = -1;
            while (s < send) {
                byte c0;
                if ((c = trans[(c0 = sbuf[s++]) & 0xFF]) >= 0) {
                    if (last == c) continue;
                    last = c;
                    sbuf[t++] = (byte)(c & 0xFF);
                    modify = true;
                    continue;
                }
                last = -1;
                sbuf[t++] = c0;
            }
            if (this.value.realSize > t - this.value.begin) {
                this.value.realSize = t - this.value.begin;
                modify = true;
            }
        } else {
            for (s = this.value.begin; s < send; ++s) {
                c = trans[sbuf[s] & 0xFF];
                if (c < 0) continue;
                sbuf[s] = (byte)(c & 0xFF);
                modify = true;
            }
        }
        if (modify) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    private final int trnext(TR t) {
        byte[] buf = t.buf;
        while (t.gen == 0) {
            if (t.p == t.pend) {
                return -1;
            }
            if (t.p < t.pend - 1 && buf[t.p] == 92) {
                ++t.p;
            }
            t.now = buf[t.p++];
            if (t.p < t.pend - 1 && buf[t.p] == 45) {
                ++t.p;
                if (t.p < t.pend) {
                    if (t.now > (buf[t.p] & 0xFF)) {
                        ++t.p;
                        continue;
                    }
                    t.gen = 1;
                    t.max = buf[t.p++] & 0xFF;
                }
            }
            return t.now & 0xFF;
        }
        if (++t.now < t.max) {
            return t.now & 0xFF;
        }
        t.gen = 0;
        return t.max & 0xFF;
    }

    @JRubyMethod(name={"tr_s"}, required=2)
    public IRubyObject tr_s(IRubyObject src, IRubyObject repl) {
        RubyString str = this.strDup();
        str.tr_trans(src, repl, true);
        return str;
    }

    @JRubyMethod(name={"tr_s!"}, required=2)
    public IRubyObject tr_s_bang(IRubyObject src, IRubyObject repl) {
        return this.tr_trans(src, repl, true);
    }

    @JRubyMethod(name={"each_line", "each"}, required=0, optional=1, frame=true)
    public IRubyObject each_line(ThreadContext context, IRubyObject[] args, Block block) {
        RubyString line;
        int p = this.value.begin;
        int pend = p + this.value.realSize;
        int ptr = p;
        int len = this.value.realSize;
        IRubyObject _rsep = args.length == 0 ? this.getRuntime().getGlobalVariables().get("$/") : args[0];
        if (_rsep.isNil()) {
            block.yield(context, this);
            return this;
        }
        RubyString rsep = RubyString.stringValue(_rsep);
        ByteList rsepValue = rsep.value;
        byte[] strBytes = this.value.bytes;
        int rslen = rsepValue.realSize;
        byte newline = rslen == 0 ? (byte)10 : rsepValue.bytes[rsepValue.begin + rslen - 1];
        int s = p;
        p += rslen;
        while (p < pend) {
            if (rslen == 0 && strBytes[p] == 10) {
                if (strBytes[++p] == 10) {
                    while (p < pend && strBytes[p] == 10) {
                        ++p;
                    }
                }
            } else if (ptr < p && strBytes[p - 1] == newline && (rslen <= 1 || ByteList.memcmp(rsepValue.bytes, rsepValue.begin, rslen, strBytes, p - rslen, rslen) == 0)) {
                line = RubyString.newStringShared(this.getRuntime(), this.getMetaClass(), this.value.makeShared(s - ptr, p - s));
                line.infectBy(this);
                block.yield(context, line);
                this.modifyCheck(strBytes, len);
                s = p;
            }
            ++p;
        }
        if (s != pend) {
            if (p > pend) {
                p = pend;
            }
            line = RubyString.newStringShared(this.getRuntime(), this.getMetaClass(), this.value.makeShared(s - ptr, p - s));
            line.infectBy(this);
            block.yield(context, line);
        }
        return this;
    }

    @JRubyMethod(name={"each_byte"}, frame=true)
    public RubyString each_byte(ThreadContext context, Block block) {
        Ruby runtime = this.getRuntime();
        for (int i = 0; i < this.value.length(); ++i) {
            block.yield(context, runtime.newFixnum(this.value.get(i) & 0xFF));
        }
        return this;
    }

    public RubySymbol intern() {
        String s = this.toString();
        if (s.length() == 0) {
            throw this.getRuntime().newArgumentError("interning empty string");
        }
        if (s.indexOf(0) >= 0) {
            throw this.getRuntime().newArgumentError("symbol string may not contain '\\0'");
        }
        return this.getRuntime().newSymbol(s);
    }

    @JRubyMethod(name={"to_sym", "intern"})
    public RubySymbol to_sym() {
        return this.intern();
    }

    @JRubyMethod(name={"sum"}, optional=1)
    public RubyInteger sum(IRubyObject[] args) {
        long bitSizeArg;
        if (args.length > 1) {
            throw this.getRuntime().newArgumentError("wrong number of arguments (" + args.length + " for 1)");
        }
        long bitSize = 16L;
        if (args.length == 1 && (bitSizeArg = args[0].convertToInteger().getLongValue()) > 0L) {
            bitSize = bitSizeArg;
        }
        long result = 0L;
        for (int i = 0; i < this.value.length(); ++i) {
            result += (long)(this.value.get(i) & 0xFF);
        }
        return this.getRuntime().newFixnum(bitSize == 0L ? result : result % (long)Math.pow(2.0, bitSize));
    }

    public static RubyString unmarshalFrom(UnmarshalStream input) throws IOException {
        RubyString result = RubyString.newString(input.getRuntime(), input.unmarshalString());
        input.registerLinkTarget(result);
        return result;
    }

    @JRubyMethod(name={"unpack"}, required=1)
    public RubyArray unpack(IRubyObject obj) {
        return Pack.unpack(this.getRuntime(), this.value, RubyString.stringValue((IRubyObject)obj).value);
    }

    public void setValue(CharSequence value) {
        this.view(ByteList.plain(value));
    }

    public void setValue(ByteList value) {
        this.view(value);
    }

    public CharSequence getValue() {
        return this.toString();
    }

    public byte[] getBytes() {
        return this.value.bytes();
    }

    public ByteList getByteList() {
        return this.value;
    }

    public String getUnicodeValue() {
        try {
            return new String(this.value.bytes, this.value.begin, this.value.realSize, "UTF8");
        }
        catch (Exception e) {
            throw new RuntimeException("Something's seriously broken with encodings", e);
        }
    }

    private static final class TR {
        int gen;
        int now;
        int max;
        int p;
        int pend;
        byte[] buf;

        private TR() {
        }
    }

    public static class JavaCrypt {
        private static final int ITERATIONS = 16;
        private static final int[] con_salt = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 0, 0, 0, 0, 0};
        private static final boolean[] shifts2 = new boolean[]{false, false, true, true, true, true, true, true, false, true, true, true, true, true, true, false};
        private static final int[][] skb = new int[][]{{0, 16, 0x20000000, 0x20000010, 65536, 65552, 0x20010000, 0x20010010, 2048, 2064, 0x20000800, 536872976, 67584, 67600, 536938496, 536938512, 32, 48, 0x20000020, 0x20000030, 65568, 65584, 0x20010020, 536936496, 2080, 2096, 0x20000820, 536873008, 67616, 67632, 536938528, 536938544, 524288, 524304, 0x20080000, 537395216, 589824, 589840, 0x20090000, 537460752, 526336, 526352, 0x20080800, 537397264, 591872, 591888, 537462784, 537462800, 524320, 524336, 0x20080020, 537395248, 589856, 589872, 0x20090020, 537460784, 526368, 526384, 0x20080820, 537397296, 591904, 591920, 537462816, 537462832}, {0, 0x2000000, 8192, 0x2002000, 0x200000, 0x2200000, 0x202000, 0x2202000, 4, 0x2000004, 8196, 0x2002004, 0x200004, 0x2200004, 0x202004, 0x2202004, 1024, 0x2000400, 9216, 0x2002400, 0x200400, 0x2200400, 0x202400, 0x2202400, 1028, 0x2000404, 9220, 0x2002404, 0x200404, 0x2200404, 0x202404, 0x2202404, 0x10000000, 0x12000000, 0x10002000, 0x12002000, 0x10200000, 0x12200000, 0x10202000, 0x12202000, 0x10000004, 301989892, 268443652, 301998084, 270532612, 304087044, 270540804, 304095236, 0x10000400, 301990912, 268444672, 301999104, 270533632, 304088064, 270541824, 304096256, 0x10000404, 301990916, 268444676, 301999108, 270533636, 304088068, 270541828, 304096260}, {0, 1, 262144, 262145, 0x1000000, 0x1000001, 0x1040000, 0x1040001, 2, 3, 262146, 262147, 0x1000002, 0x1000003, 17039362, 17039363, 512, 513, 262656, 262657, 0x1000200, 0x1000201, 17039872, 17039873, 514, 515, 262658, 262659, 0x1000202, 16777731, 17039874, 17039875, 0x8000000, 0x8000001, 0x8040000, 134479873, 0x9000000, 0x9000001, 0x9040000, 151257089, 0x8000002, 0x8000003, 134479874, 134479875, 0x9000002, 0x9000003, 151257090, 151257091, 0x8000200, 134218241, 134480384, 134480385, 0x9000200, 150995457, 151257600, 151257601, 0x8000202, 134218243, 134480386, 134480387, 0x9000202, 150995459, 151257602, 151257603}, {0, 0x100000, 256, 0x100100, 8, 0x100008, 264, 0x100108, 4096, 0x101000, 4352, 0x101100, 4104, 0x101008, 4360, 0x101108, 0x4000000, 0x4100000, 0x4000100, 0x4100100, 0x4000008, 68157448, 67109128, 68157704, 0x4001000, 0x4101000, 0x4001100, 0x4101100, 67112968, 68161544, 67113224, 68161800, 131072, 0x120000, 131328, 0x120100, 131080, 1179656, 131336, 1179912, 135168, 0x121000, 135424, 0x121100, 135176, 1183752, 135432, 1184008, 0x4020000, 68288512, 67240192, 68288768, 67239944, 68288520, 67240200, 68288776, 67244032, 68292608, 67244288, 68292864, 67244040, 68292616, 67244296, 68292872}, {0, 0x10000000, 65536, 0x10010000, 4, 0x10000004, 65540, 0x10010004, 0x20000000, 0x30000000, 0x20010000, 0x30010000, 0x20000004, 0x30000004, 536936452, 805371908, 0x100000, 0x10100000, 0x110000, 0x10110000, 0x100004, 0x10100004, 0x110004, 0x10110004, 0x20100000, 0x30100000, 0x20110000, 0x30110000, 537919492, 806354948, 537985028, 806420484, 4096, 0x10001000, 69632, 0x10011000, 4100, 0x10001004, 69636, 0x10011004, 0x20001000, 0x30001000, 0x20011000, 0x30011000, 536875012, 805310468, 536940548, 805376004, 0x101000, 0x10101000, 0x111000, 0x10111000, 0x101004, 0x10101004, 0x111004, 0x10111004, 0x20101000, 0x30101000, 0x20111000, 0x30111000, 537923588, 806359044, 537989124, 806424580}, {0, 0x8000000, 8, 0x8000008, 1024, 0x8000400, 1032, 0x8000408, 131072, 0x8020000, 131080, 0x8020008, 132096, 134349824, 132104, 134349832, 1, 0x8000001, 9, 0x8000009, 1025, 134218753, 1033, 134218761, 131073, 134348801, 131081, 134348809, 132097, 134349825, 132105, 134349833, 0x2000000, 0xA000000, 0x2000008, 0xA000008, 0x2000400, 0xA000400, 33555464, 167773192, 0x2020000, 0xA020000, 0x2020008, 167903240, 0x2020400, 167904256, 33686536, 167904264, 0x2000001, 0xA000001, 0x2000009, 0xA000009, 33555457, 167773185, 33555465, 167773193, 0x2020001, 167903233, 0x2020009, 167903241, 33686529, 167904257, 33686537, 167904265}, {0, 256, 524288, 524544, 0x1000000, 0x1000100, 0x1080000, 0x1080100, 16, 272, 524304, 524560, 0x1000010, 0x1000110, 0x1080010, 0x1080110, 0x200000, 0x200100, 0x280000, 2621696, 0x1200000, 0x1200100, 19398656, 19398912, 0x200010, 0x200110, 2621456, 2621712, 0x1200010, 0x1200110, 19398672, 19398928, 512, 768, 524800, 525056, 0x1000200, 0x1000300, 17302016, 17302272, 528, 784, 524816, 525072, 0x1000210, 0x1000310, 17302032, 17302288, 0x200200, 0x200300, 0x280200, 2622208, 0x1200200, 18875136, 19399168, 19399424, 0x200210, 2097936, 2621968, 2622224, 0x1200210, 18875152, 19399184, 19399440}, {0, 0x4000000, 262144, 0x4040000, 2, 0x4000002, 262146, 0x4040002, 8192, 0x4002000, 270336, 0x4042000, 8194, 0x4002002, 270338, 0x4042002, 32, 0x4000020, 262176, 0x4040020, 34, 0x4000022, 262178, 0x4040022, 8224, 0x4002020, 270368, 0x4042020, 8226, 0x4002022, 270370, 0x4042022, 2048, 0x4000800, 264192, 0x4040800, 2050, 67110914, 264194, 67373058, 10240, 67119104, 272384, 67381248, 10242, 67119106, 272386, 67381250, 2080, 67110944, 264224, 67373088, 2082, 67110946, 264226, 67373090, 10272, 67119136, 272416, 67381280, 10274, 67119138, 272418, 67381282}};
        private static final int[][] SPtrans = new int[][]{{0x820200, 131072, -2139095040, -2138963456, 0x800000, -2147352064, -2147352576, -2139095040, -2147352064, 0x820200, 0x820000, -2147483136, -2139094528, 0x800000, 0, -2147352576, 131072, Integer.MIN_VALUE, 0x800200, 131584, -2138963456, 0x820000, -2147483136, 0x800200, Integer.MIN_VALUE, 512, 131584, -2138963968, 512, -2139094528, -2138963968, 0, 0, -2138963456, 0x800200, -2147352576, 0x820200, 131072, -2147483136, 0x800200, -2138963968, 512, 131584, -2139095040, -2147352064, Integer.MIN_VALUE, -2139095040, 0x820000, -2138963456, 131584, 0x820000, -2139094528, 0x800000, -2147483136, -2147352576, 0, 131072, 0x800000, -2139094528, 0x820200, Integer.MIN_VALUE, -2138963968, 512, -2147352064}, {268705796, 0, 270336, 0x10040000, 0x10000004, 8196, 0x10002000, 270336, 8192, 0x10040004, 4, 0x10002000, 262148, 268705792, 0x10040000, 4, 262144, 268443652, 0x10040004, 8192, 270340, 0x10000000, 0, 262148, 268443652, 270340, 268705792, 0x10000004, 0x10000000, 262144, 8196, 268705796, 262148, 268705792, 0x10002000, 270340, 268705796, 262148, 0x10000004, 0, 0x10000000, 8196, 262144, 0x10040004, 8192, 0x10000000, 270340, 268443652, 268705792, 8192, 0, 0x10000004, 4, 268705796, 270336, 0x10040000, 0x10040004, 262144, 8196, 0x10002000, 268443652, 4, 0x10040000, 270336}, {0x41000000, 0x1010040, 64, 0x41000040, 0x40010000, 0x1000000, 0x41000040, 65600, 0x1000040, 65536, 0x1010000, 0x40000000, 0x41010040, 0x40000040, 0x40000000, 0x41010000, 0, 0x40010000, 0x1010040, 64, 0x40000040, 0x41010040, 65536, 0x41000000, 0x41010000, 0x1000040, 0x40010040, 0x1010000, 65600, 0, 0x1000000, 0x40010040, 0x1010040, 64, 0x40000000, 65536, 0x40000040, 0x40010000, 0x1010000, 0x41000040, 0, 0x1010040, 65600, 0x41010000, 0x40010000, 0x1000000, 0x41010040, 0x40000000, 0x40010040, 0x41000000, 0x1000000, 0x41010040, 65536, 0x1000040, 0x41000040, 65600, 0x1000040, 0, 0x41010000, 0x40000040, 0x41000000, 0x40010040, 64, 0x1010000}, {1049602, 0x4000400, 2, 68158466, 0, 0x4100000, 0x4000402, 0x100002, 0x4100400, 0x4000002, 0x4000000, 1026, 0x4000002, 1049602, 0x100000, 0x4000000, 68157442, 0x100400, 1024, 2, 0x100400, 0x4000402, 0x4100000, 1024, 1026, 0, 0x100002, 0x4100400, 0x4000400, 68157442, 68158466, 0x100000, 68157442, 1026, 0x100000, 0x4000002, 0x100400, 0x4000400, 2, 0x4100000, 0x4000402, 0, 1024, 0x100002, 0, 68157442, 0x4100400, 1024, 0x4000000, 68158466, 1049602, 0x100000, 68158466, 2, 0x4000400, 1049602, 0x100002, 0x100400, 0x4100000, 0x4000402, 1026, 0x4000000, 0x4000002, 0x4100400}, {0x2000000, 16384, 256, 33571080, 33570824, 0x2000100, 16648, 0x2004000, 16384, 8, 0x2000008, 16640, 33554696, 33570824, 33571072, 0, 16640, 0x2000000, 16392, 264, 0x2000100, 16648, 0, 0x2000008, 8, 33554696, 33571080, 16392, 0x2004000, 256, 264, 33571072, 33571072, 33554696, 16392, 0x2004000, 16384, 8, 0x2000008, 0x2000100, 0x2000000, 16640, 33571080, 0, 16648, 0x2000000, 256, 16392, 33554696, 256, 0, 33571080, 33570824, 33571072, 264, 16384, 16640, 33570824, 0x2000100, 264, 8, 16648, 0x2004000, 0x2000008}, {0x20000010, 524304, 0, 0x20080800, 524304, 2048, 536872976, 524288, 2064, 537397264, 526336, 0x20000000, 0x20000800, 0x20000010, 0x20080000, 526352, 524288, 536872976, 537395216, 0, 2048, 16, 0x20080800, 537395216, 537397264, 0x20080000, 0x20000000, 2064, 16, 526336, 526352, 0x20000800, 2064, 0x20000000, 0x20000800, 526352, 0x20080800, 524304, 0, 0x20000800, 0x20000000, 2048, 537395216, 524288, 524304, 537397264, 526336, 16, 537397264, 526336, 524288, 536872976, 0x20000010, 0x20080000, 526352, 0, 2048, 0x20000010, 536872976, 0x20080800, 0x20080000, 2064, 16, 537395216}, {4096, 128, 0x400080, 0x400001, 4198529, 4097, 4224, 0, 0x400000, 4194433, 129, 0x401000, 1, 4198528, 0x401000, 129, 4194433, 4096, 4097, 4198529, 0, 0x400080, 0x400001, 4224, 0x401001, 4225, 4198528, 1, 4225, 0x401001, 128, 0x400000, 4225, 0x401000, 0x401001, 129, 4096, 128, 0x400000, 0x401001, 4194433, 4225, 4224, 0, 128, 0x400001, 1, 0x400080, 0, 4194433, 0x400080, 4224, 129, 4096, 4198529, 0x400000, 4198528, 1, 4097, 4198529, 0x400001, 4198528, 0x401000, 4097}, {0x8200020, 0x8208000, 32800, 0, 0x8008000, 0x200020, 0x8200000, 0x8208020, 32, 0x8000000, 0x208000, 32800, 0x208020, 0x8008020, 0x8000020, 0x8200000, 32768, 0x208020, 0x200020, 0x8008000, 0x8208020, 0x8000020, 0, 0x208000, 0x8000000, 0x200000, 0x8008020, 0x8200020, 0x200000, 32768, 0x8208000, 32, 0x200000, 32768, 0x8000020, 0x8208020, 32800, 0x8000000, 0, 0x208000, 0x8200020, 0x8008020, 0x8008000, 0x200020, 0x8208000, 32, 0x200020, 0x8008000, 0x8208020, 0x200000, 0x8200000, 0x8000020, 0x208000, 32800, 0x8008020, 0x8200000, 32, 0x8208000, 0x208020, 0, 0x8000000, 0x8200020, 32768, 0x208020}};
        private static final int[] cov_2char = new int[]{46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};

        private static final int byteToUnsigned(byte b) {
            return b & 0xFF;
        }

        private static int fourBytesToInt(byte[] b, int offset) {
            int value = JavaCrypt.byteToUnsigned(b[offset++]);
            value |= JavaCrypt.byteToUnsigned(b[offset++]) << 8;
            value |= JavaCrypt.byteToUnsigned(b[offset++]) << 16;
            return value |= JavaCrypt.byteToUnsigned(b[offset++]) << 24;
        }

        private static final void intToFourBytes(int iValue, byte[] b, int offset) {
            b[offset++] = (byte)(iValue & 0xFF);
            b[offset++] = (byte)(iValue >>> 8 & 0xFF);
            b[offset++] = (byte)(iValue >>> 16 & 0xFF);
            b[offset++] = (byte)(iValue >>> 24 & 0xFF);
        }

        private static final void PERM_OP(int a, int b, int n, int m, int[] results) {
            int t = (a >>> n ^ b) & m;
            results[0] = a ^= t << n;
            results[1] = b ^= t;
        }

        private static final int HPERM_OP(int a, int n, int m) {
            int t = (a << 16 - n ^ a) & m;
            a = a ^ t ^ t >>> 16 - n;
            return a;
        }

        private static int[] des_set_key(byte[] key) {
            int[] schedule = new int[32];
            int c = JavaCrypt.fourBytesToInt(key, 0);
            int d = JavaCrypt.fourBytesToInt(key, 4);
            int[] results = new int[2];
            JavaCrypt.PERM_OP(d, c, 4, 0xF0F0F0F, results);
            d = results[0];
            c = results[1];
            c = JavaCrypt.HPERM_OP(c, -2, -859045888);
            d = JavaCrypt.HPERM_OP(d, -2, -859045888);
            JavaCrypt.PERM_OP(d, c, 1, 0x55555555, results);
            d = results[0];
            c = results[1];
            JavaCrypt.PERM_OP(c, d, 8, 0xFF00FF, results);
            c = results[0];
            d = results[1];
            JavaCrypt.PERM_OP(d, c, 1, 0x55555555, results);
            d = results[0];
            c = results[1];
            d = (d & 0xFF) << 16 | d & 0xFF00 | (d & 0xFF0000) >>> 16 | (c & 0xF0000000) >>> 4;
            c &= 0xFFFFFFF;
            int j = 0;
            for (int i = 0; i < 16; ++i) {
                if (shifts2[i]) {
                    c = c >>> 2 | c << 26;
                    d = d >>> 2 | d << 26;
                } else {
                    c = c >>> 1 | c << 27;
                    d = d >>> 1 | d << 27;
                }
                int s = skb[0][(c &= 0xFFFFFFF) & 0x3F] | skb[1][c >>> 6 & 3 | c >>> 7 & 0x3C] | skb[2][c >>> 13 & 0xF | c >>> 14 & 0x30] | skb[3][c >>> 20 & 1 | c >>> 21 & 6 | c >>> 22 & 0x38];
                int t = skb[4][(d &= 0xFFFFFFF) & 0x3F] | skb[5][d >>> 7 & 3 | d >>> 8 & 0x3C] | skb[6][d >>> 15 & 0x3F] | skb[7][d >>> 21 & 0xF | d >>> 22 & 0x30];
                schedule[j++] = (t << 16 | s & 0xFFFF) & 0xFFFFFFFF;
                s = s >>> 16 | t & 0xFFFF0000;
                s = s << 4 | s >>> 28;
                schedule[j++] = s & 0xFFFFFFFF;
            }
            return schedule;
        }

        private static final int D_ENCRYPT(int L, int R, int S, int E0, int E1, int[] s) {
            int v = R ^ R >>> 16;
            int u = v & E0;
            u = u ^ u << 16 ^ R ^ s[S];
            int t = (v &= E1) ^ v << 16 ^ R ^ s[S + 1];
            t = t >>> 4 | t << 28;
            return L ^= SPtrans[1][t & 0x3F] | SPtrans[3][t >>> 8 & 0x3F] | SPtrans[5][t >>> 16 & 0x3F] | SPtrans[7][t >>> 24 & 0x3F] | SPtrans[0][u & 0x3F] | SPtrans[2][u >>> 8 & 0x3F] | SPtrans[4][u >>> 16 & 0x3F] | SPtrans[6][u >>> 24 & 0x3F];
        }

        private static final int[] body(int[] schedule, int Eswap0, int Eswap1) {
            int left = 0;
            int right = 0;
            int t = 0;
            for (int j = 0; j < 25; ++j) {
                for (int i = 0; i < 32; i += 4) {
                    left = JavaCrypt.D_ENCRYPT(left, right, i, Eswap0, Eswap1, schedule);
                    right = JavaCrypt.D_ENCRYPT(right, left, i + 2, Eswap0, Eswap1, schedule);
                }
                t = left;
                left = right;
                right = t;
            }
            t = right;
            right = left >>> 1 | left << 31;
            left = t >>> 1 | t << 31;
            int[] results = new int[2];
            JavaCrypt.PERM_OP(right &= 0xFFFFFFFF, left &= 0xFFFFFFFF, 1, 0x55555555, results);
            right = results[0];
            left = results[1];
            JavaCrypt.PERM_OP(left, right, 8, 0xFF00FF, results);
            left = results[0];
            right = results[1];
            JavaCrypt.PERM_OP(right, left, 2, 0x33333333, results);
            right = results[0];
            left = results[1];
            JavaCrypt.PERM_OP(left, right, 16, 65535, results);
            left = results[0];
            right = results[1];
            JavaCrypt.PERM_OP(right, left, 4, 0xF0F0F0F, results);
            right = results[0];
            left = results[1];
            int[] out = new int[]{left, right};
            return out;
        }

        public static final ByteList crypt(ByteList salt, ByteList original) {
            int i;
            ByteList buffer = new ByteList(new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32}, false);
            byte charZero = salt.bytes[salt.begin];
            byte charOne = salt.bytes[salt.begin + 1];
            buffer.set(0, charZero);
            buffer.set(1, charOne);
            int Eswap0 = con_salt[charZero & 0x7F];
            int Eswap1 = con_salt[charOne & 0x7F] << 4;
            byte[] key = new byte[8];
            for (i = 0; i < key.length; ++i) {
                key[i] = 0;
            }
            for (i = 0; i < key.length && i < original.length(); ++i) {
                int iChar = original.bytes[original.begin + i] & 0xFF;
                key[i] = (byte)(iChar << 1);
            }
            int[] schedule = JavaCrypt.des_set_key(key);
            int[] out = JavaCrypt.body(schedule, Eswap0, Eswap1);
            byte[] b = new byte[9];
            JavaCrypt.intToFourBytes(out[0], b, 0);
            JavaCrypt.intToFourBytes(out[1], b, 4);
            b[8] = 0;
            int y = 0;
            int u = 128;
            for (int i2 = 2; i2 < 13; ++i2) {
                int c = 0;
                for (int j = 0; j < 6; ++j) {
                    c <<= 1;
                    if ((b[y] & u) != 0) {
                        c |= 1;
                    }
                    if ((u >>>= 1) == 0) {
                        ++y;
                        u = 128;
                    }
                    buffer.set(i2, cov_2char[c]);
                }
            }
            return buffer;
        }
    }
}

