/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.EOFException;
import java.io.FileDescriptor;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.HashSet;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProcess;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.posix.util.FieldAccess;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.ShellLauncher;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ChannelStream;
import org.jruby.util.io.FileExistsException;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.OpenFile;
import org.jruby.util.io.PipeException;
import org.jruby.util.io.STDIO;
import org.jruby.util.io.Stream;

public class RubyIO
extends RubyObject {
    protected OpenFile openFile;
    protected static int filenoIndex = 2;
    private static ObjectAllocator IO_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyIO(runtime, klass);
        }
    };
    private static final ByteList NIL_BYTELIST = ByteList.create("nil");
    private static final ByteList RECURSIVE_BYTELIST = ByteList.create("[...]");

    public void registerDescriptor(ChannelDescriptor descriptor) {
        this.getRuntime().getDescriptors().put(new Integer(descriptor.getFileno()), new WeakReference<ChannelDescriptor>(descriptor));
    }

    public void unregisterDescriptor(int aFileno) {
        this.getRuntime().getDescriptors().remove(new Integer(aFileno));
    }

    public ChannelDescriptor getDescriptorByFileno(int aFileno) {
        Reference reference = this.getRuntime().getDescriptors().get(new Integer(aFileno));
        if (reference == null) {
            return null;
        }
        return (ChannelDescriptor)reference.get();
    }

    public static int getNewFileno() {
        return ++filenoIndex;
    }

    public RubyIO(Ruby runtime, RubyClass type) {
        super(runtime, type);
        this.openFile = new OpenFile();
    }

    public RubyIO(Ruby runtime, OutputStream outputStream) {
        super(runtime, runtime.getIO());
        if (outputStream == null) {
            throw runtime.newIOError("Opening invalid stream");
        }
        this.openFile = new OpenFile();
        try {
            this.openFile.setMainStream(new ChannelStream(runtime, new ChannelDescriptor(Channels.newChannel(outputStream), RubyIO.getNewFileno(), new FileDescriptor())));
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.openFile.setMode(66);
        this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
    }

    public RubyIO(Ruby runtime, InputStream inputStream) {
        super(runtime, runtime.getIO());
        if (inputStream == null) {
            throw runtime.newIOError("Opening invalid stream");
        }
        this.openFile = new OpenFile();
        try {
            this.openFile.setMainStream(new ChannelStream(runtime, new ChannelDescriptor(Channels.newChannel(inputStream), RubyIO.getNewFileno(), new FileDescriptor())));
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.openFile.setMode(1);
        this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
    }

    public RubyIO(Ruby runtime, Channel channel) {
        super(runtime, runtime.getIO());
        if (channel == null) {
            throw runtime.newIOError("Opening invalid stream");
        }
        this.openFile = new OpenFile();
        try {
            this.openFile.setMainStream(new ChannelStream(runtime, new ChannelDescriptor(channel, RubyIO.getNewFileno(), new FileDescriptor())));
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.openFile.setMode(this.openFile.getMainStream().getModes().getOpenFileFlags());
        this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
    }

    public RubyIO(Ruby runtime, Process process, ModeFlags modes) {
        block11: {
            super(runtime, runtime.getIO());
            this.openFile = new OpenFile();
            this.openFile.setMode(modes.getOpenFileFlags() | 8);
            this.openFile.setProcess(process);
            try {
                if (this.openFile.isReadable()) {
                    InputStream pipeIn = process.getInputStream();
                    if (pipeIn instanceof FilterInputStream) {
                        try {
                            pipeIn = (InputStream)FieldAccess.getProtectedFieldValue(FilterInputStream.class, "in", pipeIn);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ChannelDescriptor main = new ChannelDescriptor(Channels.newChannel(pipeIn), RubyIO.getNewFileno(), new FileDescriptor());
                    main.setCanBeSeekable(false);
                    this.openFile.setMainStream(new ChannelStream(this.getRuntime(), main));
                    this.registerDescriptor(main);
                }
                if (!this.openFile.isWritable()) break block11;
                OutputStream pipeOut = process.getOutputStream();
                if (pipeOut instanceof FilterOutputStream) {
                    try {
                        pipeOut = (OutputStream)FieldAccess.getProtectedFieldValue(FilterOutputStream.class, "out", pipeOut);
                    }
                    catch (Exception main) {
                        // empty catch block
                    }
                }
                ChannelDescriptor pipe = new ChannelDescriptor(Channels.newChannel(pipeOut), RubyIO.getNewFileno(), new FileDescriptor());
                pipe.setCanBeSeekable(false);
                if (this.openFile.getMainStream() != null) {
                    this.openFile.setPipeStream(new ChannelStream(this.getRuntime(), pipe));
                } else {
                    this.openFile.setMainStream(new ChannelStream(this.getRuntime(), pipe));
                }
                this.registerDescriptor(pipe);
            }
            catch (InvalidValueException e) {
                throw this.getRuntime().newErrnoEINVALError();
            }
        }
    }

    public RubyIO(Ruby runtime, STDIO stdio) {
        super(runtime, runtime.getIO());
        this.openFile = new OpenFile();
        try {
            switch (stdio) {
                case IN: {
                    this.openFile.setMainStream(new ChannelStream(runtime, new ChannelDescriptor(runtime.getIn(), 0, new ModeFlags(0L), FileDescriptor.in), FileDescriptor.in));
                    break;
                }
                case OUT: {
                    this.openFile.setMainStream(new ChannelStream(runtime, new ChannelDescriptor(Channels.newChannel(runtime.getOut()), 1, new ModeFlags(9L), FileDescriptor.out), FileDescriptor.out));
                    this.openFile.getMainStream().setSync(true);
                    break;
                }
                case ERR: {
                    this.openFile.setMainStream(new ChannelStream(runtime, new ChannelDescriptor(Channels.newChannel(runtime.getErr()), 2, new ModeFlags(9L), FileDescriptor.err), FileDescriptor.err));
                    this.openFile.getMainStream().setSync(true);
                }
            }
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.openFile.setMode(this.openFile.getMainStream().getModes().getOpenFileFlags());
        this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
    }

    public OpenFile getOpenFile() {
        return this.openFile;
    }

    protected OpenFile getOpenFileChecked() {
        this.openFile.checkClosed(this.getRuntime());
        return this.openFile;
    }

    public static RubyClass createIOClass(Ruby runtime) {
        RubyClass ioClass = runtime.defineClass("IO", runtime.getObject(), IO_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyIO.class);
        ioClass.kindOf = new RubyModule.KindOf(){

            @Override
            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyIO;
            }
        };
        ioClass.includeModule(runtime.getEnumerable());
        ioClass.defineAnnotatedMethods(RubyIO.class);
        ioClass.fastSetConstant("SEEK_SET", runtime.newFixnum(0L));
        ioClass.fastSetConstant("SEEK_CUR", runtime.newFixnum(1L));
        ioClass.fastSetConstant("SEEK_END", runtime.newFixnum(2L));
        ioClass.dispatcher = callbackFactory.createDispatcher(ioClass);
        return ioClass;
    }

    public OutputStream getOutStream() {
        return this.getOpenFileChecked().getMainStream().newOutputStream();
    }

    public InputStream getInStream() {
        return this.getOpenFileChecked().getMainStream().newInputStream();
    }

    public Channel getChannel() {
        if (this.getOpenFileChecked().getMainStream() instanceof ChannelStream) {
            return ((ChannelStream)this.openFile.getMainStream()).getDescriptor().getChannel();
        }
        return null;
    }

    public Stream getHandler() {
        return this.getOpenFileChecked().getMainStream();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(name={"reopen"}, required=1, optional=1)
    public IRubyObject reopen(IRubyObject[] args) throws InvalidValueException {
        if (args.length < 1) {
            throw this.getRuntime().newArgumentError("wrong number of arguments");
        }
        IRubyObject tmp = TypeConverter.convertToTypeWithCheck(args[0], this.getRuntime().getIO(), MethodIndex.getIndex("to_io"), "to_io");
        if (!tmp.isNil()) {
            try {
                RubyIO ios = (RubyIO)tmp;
                if (ios.openFile == this.openFile) {
                    return this;
                }
                OpenFile originalFile = ios.getOpenFileChecked();
                OpenFile selfFile = this.getOpenFileChecked();
                long pos = 0L;
                if (originalFile.isReadable()) {
                    pos = originalFile.getMainStream().fgetpos();
                }
                if (originalFile.getPipeStream() != null) {
                    originalFile.getPipeStream().fflush();
                } else if (originalFile.isWritable()) {
                    originalFile.getMainStream().fflush();
                }
                if (selfFile.isWritable()) {
                    selfFile.getWriteStream().fflush();
                }
                selfFile.setMode(originalFile.getMode());
                selfFile.setProcess(originalFile.getProcess());
                selfFile.setLineNumber(originalFile.getLineNumber());
                selfFile.setPath(originalFile.getPath());
                selfFile.setFinalizer(originalFile.getFinalizer());
                ChannelDescriptor selfDescriptor = selfFile.getMainStream().getDescriptor();
                ChannelDescriptor originalDescriptor = originalFile.getMainStream().getDescriptor();
                if (selfDescriptor.getChannel() != originalDescriptor.getChannel()) {
                    if (selfDescriptor.getFileno() >= 0 && selfDescriptor.getFileno() <= 2) {
                        selfFile.getMainStream().clearerr();
                        originalDescriptor.dup2Into(selfDescriptor);
                        this.registerDescriptor(selfDescriptor);
                    } else {
                        Stream pipeFile = selfFile.getPipeStream();
                        int mode = selfFile.getMode();
                        selfFile.getMainStream().fclose();
                        selfFile.setPipeStream(null);
                        if (pipeFile != null) {
                            selfFile.setMainStream(ChannelStream.fdopen(this.getRuntime(), originalDescriptor, new ModeFlags()));
                            selfFile.setPipeStream(pipeFile);
                        } else {
                            selfFile.setMainStream(new ChannelStream(this.getRuntime(), originalDescriptor.dup2(selfDescriptor.getFileno())));
                            this.registerDescriptor(selfFile.getMainStream().getDescriptor());
                            selfFile.getMainStream().setSync(selfFile.getMainStream().isSync());
                        }
                        selfFile.setMode(mode);
                    }
                    if (originalFile.isReadable() && pos >= 0L) {
                        selfFile.seek(pos, 0);
                        originalFile.seek(pos, 0);
                    }
                }
                if (selfFile.getPipeStream() == null || selfDescriptor.getFileno() == selfFile.getPipeStream().getDescriptor().getFileno()) return this;
                int fd = selfFile.getPipeStream().getDescriptor().getFileno();
                if (originalFile.getPipeStream() == null) {
                    selfFile.getPipeStream().fclose();
                    selfFile.setPipeStream(null);
                    return this;
                }
                if (fd == originalFile.getPipeStream().getDescriptor().getFileno()) return this;
                selfFile.getPipeStream().fclose();
                ChannelDescriptor newFD2 = originalFile.getPipeStream().getDescriptor().dup2(fd);
                selfFile.setPipeStream(ChannelStream.fdopen(this.getRuntime(), newFD2, RubyIO.getIOModes(this.getRuntime(), "w")));
                this.registerDescriptor(newFD2);
                return this;
            }
            catch (IOException ex) {
                throw this.getRuntime().newIOError("could not reopen: " + ex.getMessage());
            }
            catch (BadDescriptorException ex) {
                throw this.getRuntime().newIOError("could not reopen: " + ex.getMessage());
            }
            catch (PipeException ex) {
                throw this.getRuntime().newIOError("could not reopen: " + ex.getMessage());
            }
        }
        RubyString pathString = args[0].convertToString();
        if (this.openFile == null) {
            this.openFile = new OpenFile();
        }
        try {
            ModeFlags modes;
            if (args.length > 1) {
                RubyString modeString = args[1].convertToString();
                modes = RubyIO.getIOModes(this.getRuntime(), ((Object)modeString).toString());
                this.openFile.setMode(modes.getOpenFileFlags());
            } else {
                modes = RubyIO.getIOModes(this.getRuntime(), "r");
            }
            String path = ((Object)pathString).toString();
            this.openFile.setPath(path);
            if (this.openFile.getMainStream() == null) {
                try {
                    this.openFile.setMainStream(ChannelStream.fopen(this.getRuntime(), path, modes));
                }
                catch (FileExistsException fee) {
                    throw this.getRuntime().newErrnoEEXISTError(path);
                }
                this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
                if (this.openFile.getPipeStream() == null) return this;
                this.openFile.getPipeStream().fclose();
                this.unregisterDescriptor(this.openFile.getPipeStream().getDescriptor().getFileno());
                this.openFile.setPipeStream(null);
                return this;
            }
            this.openFile.getMainStream().freopen(path, RubyIO.getIOModes(this.getRuntime(), this.openFile.getModeAsString(this.getRuntime())));
            this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
            if (this.openFile.getPipeStream() == null) return this;
        }
        catch (PipeException pe) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (IOException ex) {
            throw this.getRuntime().newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        return this;
    }

    public static ModeFlags getIOModes(Ruby runtime, String modesString) throws InvalidValueException {
        return new ModeFlags(RubyIO.getIOModesIntFromString(runtime, modesString));
    }

    public static int getIOModesIntFromString(Ruby runtime, String modesString) {
        int modes = 0;
        int length = modesString.length();
        if (length == 0) {
            throw runtime.newArgumentError("illegal access mode");
        }
        switch (modesString.charAt(0)) {
            case 'r': {
                modes |= 0;
                break;
            }
            case 'a': {
                modes |= 0x109;
                break;
            }
            case 'w': {
                modes |= 0x301;
                break;
            }
            default: {
                throw runtime.newArgumentError("illegal access mode " + modes);
            }
        }
        block9: for (int n = 1; n < length; ++n) {
            switch (modesString.charAt(n)) {
                case 'b': {
                    modes |= 0x8000;
                    continue block9;
                }
                case '+': {
                    modes = modes & 0xFFFEFFFF | 2;
                    continue block9;
                }
                default: {
                    throw runtime.newArgumentError("illegal access mode " + modes);
                }
            }
        }
        return modes;
    }

    private static ByteList getSeparatorFromArgs(Ruby runtime, IRubyObject[] args, int idx) {
        ByteList separator;
        IRubyObject sepVal = args.length > idx ? args[idx] : runtime.getRecordSeparatorVar().get();
        ByteList byteList = separator = sepVal.isNil() ? null : sepVal.convertToString().getByteList();
        if (separator != null && separator.realSize == 0) {
            separator = Stream.PARAGRAPH_DELIMETER;
        }
        return separator;
    }

    private ByteList getSeparatorForGets(IRubyObject[] args) {
        return RubyIO.getSeparatorFromArgs(this.getRuntime(), args, 0);
    }

    public IRubyObject getline(ByteList separator) {
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(this.getRuntime());
            boolean isParagraph = separator == Stream.PARAGRAPH_DELIMETER;
            ByteList byteList = separator = separator == Stream.PARAGRAPH_DELIMETER ? Stream.PARAGRAPH_SEPARATOR : separator;
            if (isParagraph) {
                this.swallow(10);
            }
            if (separator == null) {
                IRubyObject str = this.readAll(null);
                if (((RubyString)str).getByteList().length() == 0) {
                    return this.getRuntime().getNil();
                }
                this.incrementLineno(myOpenFile);
                return str;
            }
            if (separator.length() == 1) {
                return this.getlineFast(separator.get(0));
            }
            Stream readStream = myOpenFile.getMainStream();
            int c = -1;
            int newline = separator.get(separator.length() - 1) & 0xFF;
            ByteList buf = new ByteList(1024);
            boolean update = false;
            while (true) {
                block17: {
                    block18: {
                        block16: {
                            this.readCheck(readStream);
                            readStream.clearerr();
                            try {
                                c = readStream.fgetc();
                            }
                            catch (EOFException e) {
                                c = -1;
                            }
                            if (c != -1) break block16;
                            if (readStream.isBlocking() || !(readStream instanceof ChannelStream)) break block17;
                            if (!this.waitReadable(((ChannelStream)readStream).getDescriptor())) {
                                throw this.getRuntime().newIOError("bad file descriptor: " + this.openFile.getPath());
                            }
                            break block18;
                        }
                        buf.append(c);
                        update = true;
                    }
                    if (c != newline) continue;
                }
                if (c == -1 || c == newline && buf.length() >= separator.length() && 0 == ByteList.memcmp(buf.unsafeBytes(), buf.begin + buf.realSize - separator.length(), separator.unsafeBytes(), separator.begin, separator.realSize)) break;
            }
            if (isParagraph && c != -1) {
                this.swallow(10);
            }
            if (!update) {
                return this.getRuntime().getNil();
            }
            this.incrementLineno(myOpenFile);
            RubyString str = RubyString.newString(this.getRuntime(), buf);
            str.setTaint(true);
            return str;
        }
        catch (PipeException ex) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (EOFException e) {
            return this.getRuntime().getNil();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
    }

    private void incrementLineno(OpenFile myOpenFile) {
        Ruby runtime = this.getRuntime();
        int lineno = myOpenFile.getLineNumber() + 1;
        myOpenFile.setLineNumber(lineno);
        runtime.getGlobalVariables().set("$.", runtime.newFixnum(lineno));
        RubyNumeric.int2fix(this.getRuntime(), myOpenFile.getLineNumber());
    }

    protected boolean swallow(int term) throws IOException, BadDescriptorException {
        int c;
        Stream readStream = this.openFile.getMainStream();
        do {
            this.readCheck(readStream);
            try {
                c = readStream.fgetc();
            }
            catch (EOFException e) {
                c = -1;
            }
            if (c == term) continue;
            readStream.ungetc(c);
            return true;
        } while (c != -1);
        return false;
    }

    public IRubyObject getlineFast(int delim) throws IOException, BadDescriptorException {
        Stream readStream = this.openFile.getMainStream();
        int c = -1;
        ByteList buf = new ByteList(1024);
        boolean update = false;
        do {
            this.readCheck(readStream);
            readStream.clearerr();
            try {
                c = readStream.fgetc();
            }
            catch (EOFException e) {
                c = -1;
            }
            if (c == -1) {
                if (readStream.isBlocking() || !(readStream instanceof ChannelStream)) break;
                if (this.waitReadable(((ChannelStream)readStream).getDescriptor())) continue;
                throw this.getRuntime().newIOError("bad file descriptor: " + this.openFile.getPath());
            }
            buf.append(c);
            update = true;
        } while (c != delim);
        if (!update) {
            return this.getRuntime().getNil();
        }
        this.incrementLineno(this.openFile);
        RubyString str = RubyString.newString(this.getRuntime(), buf);
        str.setTaint(true);
        return str;
    }

    @JRubyMethod(name={"new", "for_fd"}, rest=true, frame=true, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        RubyClass klass = (RubyClass)recv;
        if (block.isGiven()) {
            String className = klass.getName();
            recv.getRuntime().getWarnings().warn(IRubyWarnings.ID.BLOCK_NOT_ACCEPTED, className + "::new() does not take block; use " + className + "::open() instead", className + "::open()");
        }
        return klass.newInstance(context, args, block);
    }

    @JRubyMethod(name={"initialize"}, required=1, optional=1, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args, Block unusedBlock) {
        int argCount = args.length;
        int fileno = RubyNumeric.fix2int(args[0]);
        try {
            ChannelDescriptor descriptor = this.getDescriptorByFileno(fileno);
            if (descriptor == null) {
                throw this.getRuntime().newErrnoEBADFError();
            }
            descriptor.checkOpen();
            ModeFlags modes = argCount == 2 ? (args[1] instanceof RubyFixnum ? new ModeFlags(RubyFixnum.fix2long(args[1])) : RubyIO.getIOModes(this.getRuntime(), args[1].convertToString().toString())) : descriptor.getOriginalModes();
            this.openFile.setMode(modes.getOpenFileFlags());
            this.openFile.setMainStream(this.fdopen(descriptor, modes));
        }
        catch (BadDescriptorException ex) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException ive) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        return this;
    }

    protected Stream fdopen(ChannelDescriptor existingDescriptor, ModeFlags modes) throws InvalidValueException {
        if (existingDescriptor == null) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        return ChannelStream.fdopen(this.getRuntime(), existingDescriptor, modes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"open"}, required=1, optional=2, frame=true, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        Ruby runtime = recv.getRuntime();
        RubyClass klass = (RubyClass)recv;
        RubyIO io = (RubyIO)klass.newInstance(context, args, block);
        if (block.isGiven()) {
            try {
                IRubyObject iRubyObject = block.yield(context, io);
                return iRubyObject;
            }
            finally {
                block8: {
                    try {
                        io.getMetaClass().invoke(context, (IRubyObject)io, "close", IRubyObject.NULL_ARRAY, CallType.FUNCTIONAL, Block.NULL_BLOCK);
                    }
                    catch (RaiseException re) {
                        RubyException rubyEx = re.getException();
                        if (rubyEx.kind_of_p(runtime.getStandardError()).isTrue()) break block8;
                        throw re;
                    }
                }
            }
        }
        return io;
    }

    @JRubyMethod(name={"binmode"})
    public IRubyObject binmode() {
        return this;
    }

    protected void checkInitialized() {
        if (this.openFile == null) {
            throw this.getRuntime().newIOError("uninitialized stream");
        }
    }

    protected void checkClosed() {
        if (this.openFile.getMainStream() == null && this.openFile.getPipeStream() == null) {
            throw this.getRuntime().newIOError("closed stream");
        }
    }

    @JRubyMethod(name={"syswrite"}, required=1)
    public IRubyObject syswrite(IRubyObject obj) {
        try {
            int read;
            RubyString string = obj.asString();
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkWritable(this.getRuntime());
            Stream writeStream = myOpenFile.getWriteStream();
            if (myOpenFile.isWriteBuffered()) {
                this.getRuntime().getWarnings().warn(IRubyWarnings.ID.SYSWRITE_BUFFERED_IO, "syswrite for buffered IO", new Object[0]);
            }
            if (!writeStream.getDescriptor().isWritable()) {
                myOpenFile.checkClosed(this.getRuntime());
            }
            if ((read = writeStream.getDescriptor().write(string.getByteList())) == -1) {
                // empty if block
            }
            return this.getRuntime().newFixnum(read);
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException ex) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newSystemCallError(e.getMessage());
        }
    }

    @JRubyMethod(name={"write_nonblock"}, required=1)
    public IRubyObject write_nonblock(IRubyObject obj) {
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            myOpenFile.checkWritable(this.getRuntime());
        }
        catch (IOException ex) {
            throw this.getRuntime().newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException ex) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        return this.write(obj);
    }

    @JRubyMethod(name={"write"}, required=1)
    public IRubyObject write(IRubyObject obj) {
        this.getRuntime().secure(4);
        RubyString str = obj.asString();
        if (str.getByteList().length() == 0) {
            return this.getRuntime().newFixnum(0L);
        }
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkWritable(this.getRuntime());
            int written = this.fwrite(str.getByteList());
            if (written == -1) {
                // empty if block
            }
            if (!myOpenFile.isSync()) {
                myOpenFile.setWriteBuffered();
            }
            return this.getRuntime().newFixnum(written);
        }
        catch (IOException ex) {
            throw this.getRuntime().newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException ex) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
    }

    protected boolean waitWritable(ChannelDescriptor descriptor) throws IOException {
        Channel channel = descriptor.getChannel();
        if (channel == null || !(channel instanceof SelectableChannel)) {
            return false;
        }
        Selector selector = Selector.open();
        ((SelectableChannel)channel).configureBlocking(false);
        int real_ops = ((SelectableChannel)channel).validOps() & 4;
        SelectionKey key = ((SelectableChannel)channel).keyFor(selector);
        if (key == null) {
            ((SelectableChannel)channel).register(selector, real_ops, descriptor);
        } else {
            key.interestOps(key.interestOps() | real_ops);
        }
        while (selector.select() == 0) {
        }
        for (SelectionKey skey : selector.selectedKeys()) {
            if ((skey.interestOps() & skey.readyOps() & 4) == 0 || skey.attachment() != descriptor) continue;
            return true;
        }
        return false;
    }

    protected boolean waitReadable(ChannelDescriptor descriptor) throws IOException {
        Channel channel = descriptor.getChannel();
        if (channel == null || !(channel instanceof SelectableChannel)) {
            return false;
        }
        Selector selector = Selector.open();
        ((SelectableChannel)channel).configureBlocking(false);
        int real_ops = ((SelectableChannel)channel).validOps() & 0x11;
        SelectionKey key = ((SelectableChannel)channel).keyFor(selector);
        if (key == null) {
            ((SelectableChannel)channel).register(selector, real_ops, descriptor);
        } else {
            key.interestOps(key.interestOps() | real_ops);
        }
        while (selector.select() == 0) {
        }
        for (SelectionKey skey : selector.selectedKeys()) {
            if ((skey.interestOps() & skey.readyOps() & 0x11) == 0 || skey.attachment() != descriptor) continue;
            return true;
        }
        return false;
    }

    protected int fwrite(ByteList buffer) {
        int offset = 0;
        boolean eagain = false;
        Stream writeStream = this.openFile.getWriteStream();
        int len = buffer.length();
        int n = len;
        if (n <= 0) {
            return n;
        }
        try {
            if (this.openFile.isSync()) {
                this.openFile.fflush(writeStream);
                while (offset < len) {
                    int l = n;
                    int r = writeStream.getDescriptor().write(buffer, offset, l);
                    if (r == len) {
                        return len;
                    }
                    if (0 <= r) {
                        offset += r;
                        n -= r;
                        eagain = true;
                    }
                    if (eagain && this.waitWritable(writeStream.getDescriptor())) {
                        this.openFile.checkClosed(this.getRuntime());
                        if (offset >= buffer.length()) {
                            return -1;
                        }
                        eagain = false;
                        continue;
                    }
                    return -1;
                }
            }
            return writeStream.fwrite(buffer);
        }
        catch (IOException ex) {
            throw this.getRuntime().newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    @JRubyMethod(name={"<<"}, required=1)
    public IRubyObject op_append(ThreadContext context, IRubyObject anObject) {
        this.callMethod(context, "write", anObject);
        return this;
    }

    @JRubyMethod(name={"fileno"}, alias={"to_i"})
    public RubyFixnum fileno() {
        return this.getRuntime().newFixnum(this.getOpenFileChecked().getMainStream().getDescriptor().getFileno());
    }

    @JRubyMethod(name={"lineno"})
    public RubyFixnum lineno() {
        return this.getRuntime().newFixnum(this.getOpenFileChecked().getLineNumber());
    }

    @JRubyMethod(name={"lineno="}, required=1)
    public RubyFixnum lineno_set(IRubyObject newLineNumber) {
        this.getOpenFileChecked().setLineNumber(RubyNumeric.fix2int(newLineNumber));
        return this.getRuntime().newFixnum(this.getOpenFileChecked().getLineNumber());
    }

    @JRubyMethod(name={"sync"})
    public RubyBoolean sync() {
        return this.getRuntime().newBoolean(this.getOpenFileChecked().getMainStream().isSync());
    }

    @JRubyMethod(name={"pid"})
    public IRubyObject pid() {
        OpenFile myOpenFile = this.getOpenFileChecked();
        if (myOpenFile.getProcess() == null) {
            return this.getRuntime().getNil();
        }
        int pid = myOpenFile.getProcess().hashCode();
        return this.getRuntime().newFixnum(pid);
    }

    public boolean writeDataBuffered() {
        return this.openFile.getMainStream().writeDataBuffered();
    }

    @JRubyMethod(name={"pos", "tell"})
    public RubyFixnum pos() {
        try {
            return this.getRuntime().newFixnum(this.getOpenFileChecked().getMainStream().fgetpos());
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (BadDescriptorException bde) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (PipeException e) {
            throw this.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
    }

    @JRubyMethod(name={"pos="}, required=1)
    public RubyFixnum pos_set(IRubyObject newPosition) {
        long offset = RubyNumeric.num2long(newPosition);
        if (offset < 0L) {
            throw this.getRuntime().newSystemCallError("Negative seek offset");
        }
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            myOpenFile.getMainStream().lseek(offset, 0);
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException e) {
            throw this.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        myOpenFile.getMainStream().clearerr();
        return (RubyFixnum)newPosition;
    }

    @JRubyMethod(name={"print"}, rest=true)
    public IRubyObject print(ThreadContext context, IRubyObject[] args) {
        if (args.length == 0) {
            args = new IRubyObject[]{context.getCurrentFrame().getLastLine()};
        }
        IRubyObject fs = this.getRuntime().getGlobalVariables().get("$,");
        IRubyObject rs = this.getRuntime().getGlobalVariables().get("$\\");
        for (int i = 0; i < args.length; ++i) {
            if (i > 0 && !fs.isNil()) {
                this.callMethod(context, "write", fs);
            }
            if (args[i].isNil()) {
                this.callMethod(context, "write", this.getRuntime().newString("nil"));
                continue;
            }
            this.callMethod(context, "write", args[i]);
        }
        if (!rs.isNil()) {
            this.callMethod(context, "write", rs);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"printf"}, required=1, rest=true)
    public IRubyObject printf(ThreadContext context, IRubyObject[] args) {
        this.callMethod(context, "write", RubyKernel.sprintf(this, args));
        return this.getRuntime().getNil();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(name={"putc"}, required=1)
    public IRubyObject putc(ThreadContext context, IRubyObject object) {
        int c;
        if (this.getRuntime().getString().isInstance(object)) {
            String value = ((RubyString)object).toString();
            if (value.length() <= 0) throw this.getRuntime().newTypeError("Cannot convert String to Integer");
            c = value.charAt(0);
        } else {
            c = this.getRuntime().getFixnum().isInstance(object) ? RubyNumeric.fix2int(object) : RubyNumeric.fix2int(object.callMethod(context, MethodIndex.TO_I, "to_i"));
        }
        try {
            this.getOpenFileChecked().getMainStream().fputc(c);
            return object;
        }
        catch (BadDescriptorException e) {
            return RubyFixnum.zero(this.getRuntime());
        }
        catch (IOException e) {
            return RubyFixnum.zero(this.getRuntime());
        }
    }

    @JRubyMethod(name={"seek"}, required=1, optional=1)
    public RubyFixnum seek(IRubyObject[] args) {
        long offset = RubyNumeric.num2long(args[0]);
        int whence = 0;
        if (args.length > 1) {
            whence = RubyNumeric.fix2int(args[1].convertToInteger());
        }
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            myOpenFile.seek(offset, whence);
        }
        catch (BadDescriptorException ex) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException e) {
            throw this.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        myOpenFile.getMainStream().clearerr();
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"sysseek"}, required=1, optional=1)
    public RubyFixnum sysseek(IRubyObject[] args) {
        long pos;
        long offset = RubyNumeric.num2long(args[0]);
        int whence = 0;
        if (args.length > 1) {
            whence = RubyNumeric.fix2int(args[1].convertToInteger());
        }
        OpenFile myOpenFile = this.getOpenFileChecked();
        try {
            if (myOpenFile.isReadable() && myOpenFile.isReadBuffered()) {
                throw this.getRuntime().newIOError("sysseek for buffered IO");
            }
            if (myOpenFile.isWritable() && myOpenFile.isWriteBuffered()) {
                this.getRuntime().getWarnings().warn(IRubyWarnings.ID.SYSSEEK_BUFFERED_IO, "sysseek for buffered IO", new Object[0]);
            }
            pos = myOpenFile.getMainStream().getDescriptor().lseek(offset, whence);
        }
        catch (BadDescriptorException ex) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException e) {
            throw this.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        myOpenFile.getMainStream().clearerr();
        return this.getRuntime().newFixnum(pos);
    }

    @JRubyMethod(name={"rewind"})
    public RubyFixnum rewind() {
        OpenFile myOpenfile = this.getOpenFileChecked();
        try {
            myOpenfile.getMainStream().lseek(0L, 0);
            myOpenfile.getMainStream().clearerr();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException e) {
            throw this.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        myOpenfile.setLineNumber(0);
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"fsync"})
    public RubyFixnum fsync() {
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkWritable(this.getRuntime());
            myOpenFile.getWriteStream().sync();
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException ex) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"sync="}, required=1)
    public IRubyObject sync_set(IRubyObject newSync) {
        this.getOpenFileChecked().setSync(newSync.isTrue());
        this.getOpenFileChecked().getMainStream().setSync(newSync.isTrue());
        return this;
    }

    @JRubyMethod(name={"eof?", "eof"})
    public RubyBoolean eof_p() {
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(this.getRuntime());
            if (myOpenFile.getMainStream().feof()) {
                return this.getRuntime().getTrue();
            }
            if (myOpenFile.getMainStream().readDataBuffered()) {
                return this.getRuntime().getFalse();
            }
            this.readCheck(myOpenFile.getMainStream());
            myOpenFile.getMainStream().clearerr();
            int c = myOpenFile.getMainStream().fgetc();
            if (c != -1) {
                myOpenFile.getMainStream().ungetc(c);
                return this.getRuntime().getFalse();
            }
            myOpenFile.checkClosed(this.getRuntime());
            myOpenFile.getMainStream().clearerr();
            return this.getRuntime().getTrue();
        }
        catch (PipeException ex) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
    }

    @JRubyMethod(name={"tty?", "isatty"})
    public RubyBoolean tty_p() {
        return this.getRuntime().newBoolean(this.getRuntime().getPosix().isatty(this.getOpenFileChecked().getMainStream().getDescriptor().getFileDescriptor()));
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject original) {
        if (this == original) {
            return this;
        }
        RubyIO originalIO = (RubyIO)TypeConverter.convertToTypeWithCheck(original, this.getRuntime().getIO(), MethodIndex.TO_IO, "to_io");
        OpenFile originalFile = originalIO.getOpenFileChecked();
        OpenFile newFile = this.openFile;
        try {
            originalFile.checkClosed(this.getRuntime());
            if (originalFile.getPipeStream() != null) {
                originalFile.getPipeStream().fflush();
                originalFile.getMainStream().lseek(0L, 1);
            } else if (originalFile.isWritable()) {
                originalFile.getMainStream().fflush();
            } else {
                originalFile.getMainStream().lseek(0L, 1);
            }
            newFile.setMode(originalFile.getMode());
            newFile.setProcess(originalFile.getProcess());
            newFile.setLineNumber(originalFile.getLineNumber());
            newFile.setPath(originalFile.getPath());
            newFile.setFinalizer(originalFile.getFinalizer());
            ModeFlags modes = newFile.isReadable() ? (newFile.isWritable() ? (newFile.getPipeStream() != null ? new ModeFlags(0L) : new ModeFlags(2L)) : new ModeFlags(0L)) : (newFile.isWritable() ? new ModeFlags(1L) : originalFile.getMainStream().getModes());
            ChannelDescriptor descriptor = originalFile.getMainStream().getDescriptor().dup();
            newFile.setMainStream(ChannelStream.fdopen(this.getRuntime(), descriptor, modes));
            this.registerDescriptor(newFile.getMainStream().getDescriptor());
        }
        catch (IOException ex) {
            throw this.getRuntime().newIOError("could not init copy: " + ex);
        }
        catch (BadDescriptorException ex) {
            throw this.getRuntime().newIOError("could not init copy: " + ex);
        }
        catch (PipeException ex) {
            throw this.getRuntime().newIOError("could not init copy: " + ex);
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newIOError("could not init copy: " + ex);
        }
        return this;
    }

    @JRubyMethod(name={"closed?"})
    public RubyBoolean closed_p() {
        if (this.openFile.getMainStream() == null && this.openFile.getPipeStream() == null) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() {
        if (this.getRuntime().getSafeLevel() >= 4 && this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't close");
        }
        this.openFile.checkClosed(this.getRuntime());
        return this.close2();
    }

    protected IRubyObject close2() {
        if (this.openFile == null) {
            return this.getRuntime().getNil();
        }
        if (this.openFile.getPipeStream() != null) {
            ChannelDescriptor pipe = this.openFile.getPipeStream().getDescriptor();
        } else {
            if (this.openFile.getMainStream() == null) {
                return this.getRuntime().getNil();
            }
            Object pipe = null;
        }
        ChannelDescriptor main = this.openFile.getMainStream().getDescriptor();
        this.openFile.cleanup(this.getRuntime(), true);
        if (this.openFile.getProcess() != null) {
            try {
                RubyProcess.RubyStatus processResult = RubyProcess.RubyStatus.newProcessStatus(this.getRuntime(), this.openFile.getProcess().waitFor());
                this.getRuntime().getGlobalVariables().set("$?", processResult);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"close_write"})
    public IRubyObject close_write() throws BadDescriptorException {
        try {
            if (this.getRuntime().getSafeLevel() >= 4 && this.isTaint()) {
                throw this.getRuntime().newSecurityError("Insecure: can't close");
            }
            OpenFile myOpenFile = this.getOpenFileChecked();
            if (myOpenFile.getPipeStream() == null && myOpenFile.isReadable()) {
                throw this.getRuntime().newIOError("closing non-duplex IO for writing");
            }
            if (myOpenFile.getPipeStream() == null) {
                this.close();
            } else {
                myOpenFile.getPipeStream().fclose();
                myOpenFile.setPipeStream(null);
                myOpenFile.setMode(myOpenFile.getMode() & 0xFFFFFFFD);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    @JRubyMethod(name={"close_read"})
    public IRubyObject close_read() throws BadDescriptorException {
        try {
            if (this.getRuntime().getSafeLevel() >= 4 && this.isTaint()) {
                throw this.getRuntime().newSecurityError("Insecure: can't close");
            }
            OpenFile myOpenFile = this.getOpenFileChecked();
            if (myOpenFile.getPipeStream() == null && myOpenFile.isWritable()) {
                throw this.getRuntime().newIOError("closing non-duplex IO for reading");
            }
            if (myOpenFile.getPipeStream() == null) {
                this.close();
            } else {
                myOpenFile.getMainStream().fclose();
                myOpenFile.setMode(myOpenFile.getMode() & 0xFFFFFFFE);
                myOpenFile.setMainStream(myOpenFile.getPipeStream());
                myOpenFile.setPipeStream(null);
            }
        }
        catch (IOException ioe) {
            throw this.getRuntime().newIOErrorFromException(ioe);
        }
        return this;
    }

    @JRubyMethod(name={"flush"})
    public RubyIO flush() {
        try {
            this.getOpenFileChecked().getWriteStream().fflush();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        return this;
    }

    @JRubyMethod(name={"gets"}, optional=1)
    public IRubyObject gets(ThreadContext context, IRubyObject[] args) {
        ByteList separator = this.getSeparatorForGets(args);
        IRubyObject result = this.getline(separator);
        if (!result.isNil()) {
            context.getCurrentFrame().setLastLine(result);
        }
        return result;
    }

    public boolean getBlocking() {
        return ((ChannelStream)this.openFile.getMainStream()).isBlocking();
    }

    @JRubyMethod(name={"fcntl"}, required=2)
    public IRubyObject fcntl(IRubyObject cmd, IRubyObject arg) {
        return this.ctl(cmd, arg);
    }

    @JRubyMethod(name={"ioctl"}, required=1, optional=1)
    public IRubyObject ioctl(IRubyObject[] args) {
        IRubyObject cmd = args[0];
        IRubyObject arg = args.length == 2 ? args[1] : this.getRuntime().getNil();
        return this.ctl(cmd, arg);
    }

    public IRubyObject ctl(IRubyObject cmd, IRubyObject arg) {
        long realCmd = cmd.convertToInteger().getLongValue();
        long nArg = 0L;
        if (arg.isNil() || arg == this.getRuntime().getFalse()) {
            nArg = 0L;
        } else if (arg instanceof RubyFixnum) {
            nArg = RubyFixnum.fix2long(arg);
        } else if (arg == this.getRuntime().getTrue()) {
            nArg = 1L;
        } else {
            throw this.getRuntime().newNotImplementedError("JRuby does not support string for second fcntl/ioctl argument yet");
        }
        OpenFile myOpenFile = this.getOpenFileChecked();
        if (realCmd == 1L) {
            boolean block = true;
            if ((nArg & 4L) == 4L) {
                block = false;
            }
            try {
                myOpenFile.getMainStream().setBlocking(block);
            }
            catch (IOException e) {
                throw this.getRuntime().newIOError(e.getMessage());
            }
        } else {
            throw this.getRuntime().newNotImplementedError("JRuby only supports F_SETFL for fcntl/ioctl currently");
        }
        return this.getRuntime().newFixnum(0L);
    }

    @JRubyMethod(name={"puts"}, rest=true)
    public IRubyObject puts(ThreadContext context, IRubyObject[] args) {
        assert (this.getRuntime().getGlobalVariables().getDefaultSeparator() instanceof RubyString);
        RubyString separator = (RubyString)this.getRuntime().getGlobalVariables().getDefaultSeparator();
        if (args.length == 0) {
            this.write(context, separator.getByteList());
            return this.getRuntime().getNil();
        }
        for (int i = 0; i < args.length; ++i) {
            ByteList line;
            if (args[i].isNil()) {
                line = NIL_BYTELIST;
            } else if (this.getRuntime().isInspecting(args[i])) {
                line = RECURSIVE_BYTELIST;
            } else {
                if (args[i] instanceof RubyArray) {
                    this.inspectPuts(context, (RubyArray)args[i]);
                    continue;
                }
                line = args[i].asString().getByteList();
            }
            this.write(context, line);
            if (line.length() != 0 && line.endsWith(separator.getByteList())) continue;
            this.write(context, separator.getByteList());
        }
        return this.getRuntime().getNil();
    }

    protected void write(ThreadContext context, ByteList byteList) {
        this.callMethod(context, "write", this.getRuntime().newStringShared(byteList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject inspectPuts(ThreadContext context, RubyArray array) {
        try {
            this.getRuntime().registerInspecting(array);
            IRubyObject iRubyObject = this.puts(context, array.toJavaArray());
            return iRubyObject;
        }
        finally {
            this.getRuntime().unregisterInspecting(array);
        }
    }

    @JRubyMethod(name={"readline"}, optional=1)
    public IRubyObject readline(ThreadContext context, IRubyObject[] args) {
        IRubyObject line = this.gets(context, args);
        if (line.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return line;
    }

    @JRubyMethod(name={"getc"})
    public IRubyObject getc() {
        try {
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(this.getRuntime());
            Stream stream = myOpenFile.getMainStream();
            this.readCheck(stream);
            stream.clearerr();
            int c = myOpenFile.getMainStream().fgetc();
            if (c == -1) {
                return this.getRuntime().getNil();
            }
            return this.getRuntime().newFixnum(c);
        }
        catch (PipeException ex) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
    }

    private void readCheck(Stream stream) {
        if (!stream.readDataBuffered()) {
            this.openFile.checkClosed(this.getRuntime());
        }
    }

    @JRubyMethod(name={"ungetc"}, required=1)
    public IRubyObject ungetc(IRubyObject number) {
        int ch = RubyNumeric.fix2int(number);
        OpenFile myOpenFile = this.getOpenFileChecked();
        if (!myOpenFile.isReadBuffered()) {
            throw this.getRuntime().newIOError("unread stream");
        }
        try {
            myOpenFile.checkReadable(this.getRuntime());
            if (myOpenFile.getMainStream().ungetc(ch) == -1 && ch != -1) {
                throw this.getRuntime().newIOError("ungetc failed");
            }
        }
        catch (PipeException ex) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"readpartial"}, required=1, optional=1)
    public IRubyObject readpartial(ThreadContext context, IRubyObject[] args) {
        if (!(this.openFile.getMainStream() instanceof ChannelStream)) {
            throw this.getRuntime().newNotImplementedError("readpartial only works with Nio based handlers");
        }
        try {
            ByteList buf = ((ChannelStream)this.openFile.getMainStream()).readpartial(RubyNumeric.fix2int(args[0]));
            RubyString strbuf = RubyString.newString(this.getRuntime(), buf == null ? new ByteList(ByteList.NULL_ARRAY) : buf);
            if (args.length > 1) {
                args[1].callMethod(context, MethodIndex.OP_LSHIFT, "<<", strbuf);
                return args[1];
            }
            return strbuf;
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            return this.getRuntime().getNil();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
    }

    @JRubyMethod(name={"sysread"}, required=1, optional=1)
    public IRubyObject sysread(ThreadContext context, IRubyObject[] args) {
        int len = (int)RubyNumeric.num2long(args[0]);
        if (len < 0) {
            throw this.getRuntime().newArgumentError("Negative size");
        }
        try {
            RubyString str;
            if (args.length == 1 || args[1].isNil()) {
                if (len == 0) {
                    RubyString rubyString = RubyString.newStringShared(this.getRuntime(), ByteList.EMPTY_BYTELIST);
                    return rubyString;
                }
                ByteList buffer = new ByteList(len);
                str = RubyString.newString(this.getRuntime(), buffer);
            } else {
                str = args[1].convertToString();
                str.modify(len);
                if (len == 0) {
                    RubyString rubyString = str;
                    return rubyString;
                }
                ByteList buffer = str.getByteList();
            }
            OpenFile myOpenFile = this.getOpenFileChecked();
            myOpenFile.checkReadable(this.getRuntime());
            if (myOpenFile.getMainStream().readDataBuffered()) {
                throw this.getRuntime().newIOError("sysread for buffered IO");
            }
            context.getThread().beforeBlockingCall();
            myOpenFile.checkClosed(this.getRuntime());
            int bytesRead = myOpenFile.getMainStream().getDescriptor().read(len, str.getByteList());
            if (bytesRead == -1 || bytesRead == 0 && len > 0) {
                throw this.getRuntime().newEOFError();
            }
            str.setTaint(true);
            RubyString rubyString = str;
            return rubyString;
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException e) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (EOFException e) {
            throw this.getRuntime().newEOFError();
        }
        catch (IOException e) {
            if ("File not open".equals(e.getMessage())) {
                throw this.getRuntime().newIOError(e.getMessage());
            }
            throw this.getRuntime().newSystemCallError(e.getMessage());
        }
        finally {
            context.getThread().afterBlockingCall();
        }
    }

    @JRubyMethod(name={"read_nonblock"}, required=1, optional=1)
    public IRubyObject read_nonblock(IRubyObject[] args) {
        return this.read(args);
    }

    @JRubyMethod(name={"read"}, optional=2)
    public IRubyObject read(IRubyObject[] args) {
        int argCount = args.length;
        OpenFile myOpenFile = this.getOpenFileChecked();
        if (argCount == 0 || args[0].isNil()) {
            try {
                myOpenFile.checkReadable(this.getRuntime());
                if (args.length == 2) {
                    return this.readAll(args[1]);
                }
                return this.readAll(this.getRuntime().getNil());
            }
            catch (PipeException ex) {
                throw this.getRuntime().newErrnoEPIPEError();
            }
            catch (InvalidValueException ex) {
                throw this.getRuntime().newErrnoEINVALError();
            }
            catch (EOFException ex) {
                throw this.getRuntime().newEOFError();
            }
            catch (IOException ex) {
                throw this.getRuntime().newIOErrorFromException(ex);
            }
            catch (BadDescriptorException ex) {
                throw this.getRuntime().newErrnoEBADFError();
            }
        }
        int length = RubyNumeric.num2int(args[0]);
        if (length < 0) {
            throw this.getRuntime().newArgumentError("negative length " + length + " given");
        }
        RubyString str = null;
        if (args.length != 1 && !args[1].isNil()) {
            str = args[1].convertToString();
            str.modify(length);
            if (length == 0) {
                return str;
            }
        }
        try {
            myOpenFile.checkReadable(this.getRuntime());
            if (myOpenFile.getMainStream().feof()) {
                return this.getRuntime().getNil();
            }
            this.readCheck(myOpenFile.getMainStream());
            ByteList newBuffer = myOpenFile.getMainStream().fread(length);
            if (newBuffer == null || newBuffer.length() == 0) {
                if (myOpenFile.getMainStream() == null) {
                    return this.getRuntime().getNil();
                }
                if (myOpenFile.getMainStream().feof()) {
                    if (str != null) {
                        str.setValue(ByteList.EMPTY_BYTELIST.dup());
                    }
                    return this.getRuntime().getNil();
                }
                if (length > 0) {
                    throw this.getRuntime().newEOFError();
                }
            }
            if (str == null) {
                str = newBuffer == null ? this.getRuntime().newString() : RubyString.newString(this.getRuntime(), newBuffer);
            } else if (newBuffer == null) {
                str.setValue(ByteList.EMPTY_BYTELIST.dup());
            } else {
                str.setValue(newBuffer);
            }
            str.setTaint(true);
            return str;
        }
        catch (EOFException ex) {
            throw this.getRuntime().newEOFError();
        }
        catch (PipeException ex) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (IOException ex) {
            throw this.getRuntime().newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw this.getRuntime().newErrnoEBADFError();
        }
    }

    protected IRubyObject readAll(IRubyObject buffer) throws BadDescriptorException, EOFException, IOException {
        RubyString str = null;
        if (buffer instanceof RubyString) {
            str = (RubyString)buffer;
        }
        if (this.openFile.getMainStream().readDataBuffered()) {
            this.openFile.checkClosed(this.getRuntime());
        }
        ByteList newBuffer = this.openFile.getMainStream().readall();
        if (str == null) {
            str = newBuffer == null ? RubyString.newStringShared(this.getRuntime(), ByteList.EMPTY_BYTELIST) : RubyString.newString(this.getRuntime(), newBuffer);
        } else if (newBuffer == null) {
            str.setValue(ByteList.EMPTY_BYTELIST.dup());
        } else {
            str.setValue(newBuffer);
        }
        str.taint();
        return str;
    }

    @JRubyMethod(name={"readchar"})
    public IRubyObject readchar() {
        IRubyObject c = this.getc();
        if (c.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return c;
    }

    @JRubyMethod
    public IRubyObject stat() {
        this.openFile.checkClosed(this.getRuntime());
        return this.getRuntime().newFileStat(this.getOpenFileChecked().getMainStream().getDescriptor().getFileDescriptor());
    }

    @JRubyMethod(name={"each_byte"}, frame=true)
    public IRubyObject each_byte(ThreadContext context, Block block) {
        try {
            Ruby runtime = this.getRuntime();
            OpenFile myOpenFile = this.getOpenFileChecked();
            while (true) {
                myOpenFile.checkReadable(runtime);
                int c = myOpenFile.getMainStream().fgetc();
                if (c == -1) break;
                assert (c < 256);
                block.yield(context, this.getRuntime().newFixnum(c));
            }
            return this;
        }
        catch (PipeException ex) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException e) {
            return this.getRuntime().getNil();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
    }

    @JRubyMethod(name={"each_line", "each"}, optional=1, frame=true)
    public RubyIO each_line(ThreadContext context, IRubyObject[] args, Block block) {
        ByteList separator = this.getSeparatorForGets(args);
        IRubyObject line = this.getline(separator);
        while (!line.isNil()) {
            block.yield(context, line);
            line = this.getline(separator);
        }
        return this;
    }

    @JRubyMethod(name={"readlines"}, optional=1)
    public RubyArray readlines(IRubyObject[] args) {
        IRubyObject line;
        ByteList separator;
        if (args.length > 0) {
            if (!this.getRuntime().getNilClass().isInstance(args[0]) && !this.getRuntime().getString().isInstance(args[0])) {
                throw this.getRuntime().newTypeError(args[0], this.getRuntime().getString());
            }
            separator = this.getSeparatorForGets(new IRubyObject[]{args[0]});
        } else {
            separator = this.getSeparatorForGets(IRubyObject.NULL_ARRAY);
        }
        RubyArray result = this.getRuntime().newArray();
        while (!(line = this.getline(separator)).isNil()) {
            result.append(line);
        }
        return result;
    }

    @JRubyMethod(name={"to_io"})
    public RubyIO to_io() {
        return this;
    }

    @Override
    public String toString() {
        return "RubyIO(" + this.openFile.getMode() + ", " + this.openFile.getMainStream().getDescriptor().getFileno() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"foreach"}, required=1, optional=1, frame=true, meta=true)
    public static IRubyObject foreach(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        Ruby runtime = recv.getRuntime();
        int count = args.length;
        RubyString filename = args[0].convertToString();
        runtime.checkSafeString(filename);
        ByteList separator = RubyIO.getSeparatorFromArgs(runtime, args, 1);
        RubyIO io = (RubyIO)RubyFile.open(context, runtime.getFile(), new IRubyObject[]{filename}, Block.NULL_BLOCK);
        if (!io.isNil()) {
            try {
                IRubyObject str = io.getline(separator);
                while (!str.isNil()) {
                    block.yield(context, str);
                    str = io.getline(separator);
                }
            }
            finally {
                io.close();
            }
        }
        return runtime.getNil();
    }

    private static RubyIO registerSelect(ThreadContext context, Selector selector, IRubyObject obj, int ops) throws IOException {
        RubyIO ioObj;
        if (!(obj instanceof RubyIO)) {
            if (!obj.respondsTo("to_io")) {
                return null;
            }
            ioObj = (RubyIO)obj.callMethod(context, "to_io");
        } else {
            ioObj = (RubyIO)obj;
        }
        Channel channel = ioObj.getChannel();
        if (channel == null || !(channel instanceof SelectableChannel)) {
            return null;
        }
        ((SelectableChannel)channel).configureBlocking(false);
        int real_ops = ((SelectableChannel)channel).validOps() & ops;
        SelectionKey key = ((SelectableChannel)channel).keyFor(selector);
        if (key == null) {
            ((SelectableChannel)channel).register(selector, real_ops, obj);
        } else {
            key.interestOps(key.interestOps() | real_ops);
        }
        return ioObj;
    }

    @JRubyMethod(name={"select"}, required=1, optional=3, meta=true)
    public static IRubyObject select(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        return RubyIO.select_static(context, recv.getRuntime(), args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject select_static(ThreadContext context, Ruby runtime, IRubyObject[] args) {
        try {
            boolean atLeastOneDescriptor = false;
            HashSet<IRubyObject> pending = new HashSet<IRubyObject>();
            Selector selector = Selector.open();
            if (!args[0].isNil()) {
                atLeastOneDescriptor = true;
                for (IRubyObject obj : ((RubyArray)args[0]).getList()) {
                    RubyIO ioObj = RubyIO.registerSelect(context, selector, obj, 17);
                    if (ioObj == null || !ioObj.writeDataBuffered()) continue;
                    pending.add(obj);
                }
            }
            if (args.length > 1 && !args[1].isNil()) {
                atLeastOneDescriptor = true;
                for (IRubyObject obj : ((RubyArray)args[1]).getList()) {
                    RubyIO.registerSelect(context, selector, obj, 4);
                }
            }
            if (args.length > 2 && !args[2].isNil()) {
                atLeastOneDescriptor = true;
            }
            long timeout = 0L;
            if (args.length > 3 && !args[3].isNil() && (timeout = args[3] instanceof RubyFloat ? Math.round(((RubyFloat)args[3]).getDoubleValue() * 1000.0) : Math.round(((RubyFixnum)args[3]).getDoubleValue() * 1000.0)) < 0L) {
                throw runtime.newArgumentError("negative timeout given");
            }
            if (!atLeastOneDescriptor) {
                return runtime.getNil();
            }
            if (pending.isEmpty()) {
                if (args.length > 3) {
                    if (timeout == 0L) {
                        selector.selectNow();
                    } else {
                        selector.select(timeout);
                    }
                } else {
                    selector.select();
                }
            } else {
                selector.selectNow();
            }
            ArrayList<Object> r = new ArrayList<Object>();
            ArrayList<Object> w = new ArrayList<Object>();
            ArrayList e = new ArrayList();
            for (SelectionKey key : selector.selectedKeys()) {
                if ((key.interestOps() & key.readyOps() & 0x19) != 0) {
                    r.add(key.attachment());
                    pending.remove(key.attachment());
                }
                if ((key.interestOps() & key.readyOps() & 4) == 0) continue;
                w.add(key.attachment());
            }
            r.addAll(pending);
            for (SelectionKey key : selector.keys()) {
                SelectableChannel channel = key.channel();
                Object object = channel.blockingLock();
                synchronized (object) {
                    boolean blocking = ((RubyIO)key.attachment()).getBlocking();
                    key.cancel();
                    channel.configureBlocking(blocking);
                }
            }
            selector.close();
            if (r.size() == 0 && w.size() == 0 && e.size() == 0) {
                return runtime.getNil();
            }
            ArrayList<RubyArray> ret = new ArrayList<RubyArray>();
            ret.add(RubyArray.newArray(runtime, r));
            ret.add(RubyArray.newArray(runtime, w));
            ret.add(RubyArray.newArray(runtime, e));
            return RubyArray.newArray(runtime, ret);
        }
        catch (IOException e) {
            throw runtime.newIOError(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"read"}, required=1, optional=2, meta=true)
    public static IRubyObject read(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        IRubyObject[] fileArguments = new IRubyObject[]{args[0]};
        IRubyObject[] readArguments = args.length >= 2 && !args[1].isNil() ? new IRubyObject[]{args[1].convertToInteger()} : new IRubyObject[]{};
        try (RubyIO file = (RubyIO)RubyKernel.open(context, recv, fileArguments, block);){
            if (args.length == 3 && !args[2].isNil()) {
                file.seek(new IRubyObject[]{args[2].convertToInteger()});
            }
            IRubyObject iRubyObject = file.read(readArguments);
            return iRubyObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"readlines"}, required=1, optional=1, meta=true)
    public static RubyArray readlines(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        IRubyObject[] iRubyObjectArray;
        int count = args.length;
        IRubyObject[] fileArguments = new IRubyObject[]{args[0]};
        if (count >= 2) {
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
            iRubyObjectArray = iRubyObjectArray2;
            iRubyObjectArray2[0] = args[1];
        } else {
            iRubyObjectArray = IRubyObject.NULL_ARRAY;
        }
        IRubyObject[] separatorArguments = iRubyObjectArray;
        try (RubyIO file = (RubyIO)RubyKernel.open(context, recv, fileArguments, block);){
            RubyArray rubyArray = file.readlines(separatorArguments);
            return rubyArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(name={"popen"}, required=1, optional=1, meta=true)
    public static IRubyObject popen(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        IRubyObject iRubyObject;
        Process process;
        Ruby runtime;
        block9: {
            runtime = recv.getRuntime();
            RubyString cmdObj = args[0].convertToString();
            runtime.checkSafeString(cmdObj);
            if ("-".equals(((Object)cmdObj).toString())) {
                throw recv.getRuntime().newNotImplementedError("popen(\"-\") is unimplemented");
            }
            int mode = args.length == 1 ? 0 : (args[1] instanceof RubyFixnum ? RubyFixnum.num2int(args[1]) : RubyIO.getIOModesIntFromString(runtime, args[1].convertToString().toString()));
            ModeFlags modes = new ModeFlags(mode);
            process = ShellLauncher.popen(runtime, cmdObj, modes);
            RubyIO io = new RubyIO(runtime, process, modes);
            if (!block.isGiven()) return io;
            try {
                iRubyObject = block.yield(context, io);
                if (!io.openFile.isOpen()) break block9;
                io.close();
            }
            catch (Throwable throwable) {
                try {
                    if (io.openFile.isOpen()) {
                        io.close();
                    }
                    runtime.getGlobalVariables().set("$?", RubyProcess.RubyStatus.newProcessStatus(runtime, process.waitFor() * 256));
                    throw throwable;
                }
                catch (InvalidValueException ex) {
                    throw runtime.newErrnoEINVALError();
                }
                catch (IOException e) {
                    throw runtime.newIOErrorFromException(e);
                }
                catch (InterruptedException e) {
                    throw runtime.newThreadError("unexpected interrupt");
                }
            }
        }
        runtime.getGlobalVariables().set("$?", RubyProcess.RubyStatus.newProcessStatus(runtime, process.waitFor() * 256));
        return iRubyObject;
    }

    @JRubyMethod(name={"pipe"}, meta=true)
    public static IRubyObject pipe(IRubyObject recv) throws Exception {
        Ruby runtime = recv.getRuntime();
        Pipe pipe = Pipe.open();
        RubyIO source = new RubyIO(runtime, pipe.source());
        RubyIO sink = new RubyIO(runtime, pipe.sink());
        sink.openFile.getMainStream().setSync(true);
        return runtime.newArrayNoCopy(new IRubyObject[]{source, sink});
    }
}

