/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.RDoc;
import org.jruby.common.IRubyWarnings;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;

@RDoc(doc="A <code>Hash</code> is a collection of key-value pairs. It is\nsimilar to an <code>Array</code>, except that indexing is done via\narbitrary keys of any object type, not an integer index. The order\nin which you traverse a hash by either key or value may seem\narbitrary, and will generally not be in the insertion order.\n   \nHashes have a <em>default value</em> that is returned when accessing\nkeys that do not exist in the hash. By default, that value is\n<code>nil</code>.\n\n<code>Hash</code> uses <code>key.eql?</code> to test keys for equality.\nIf you need to use instances of your own classes as keys in a <code>Hash</code>,\nit is recommended that you define both the <code>eql?</code> and <code>hash</code>\nmethods. The <code>hash</code> method must have the property that \n<code>a.eql?(b)</code> implies <code>a.hash == b.hash</code>.\n\n  class MyClass\n    attr_reader :str\n    def initialize(str)\n      @str = str\n    end\n    def eql?(o)\n      o.is_a?(MyClass) && str == o.str\n    end\n    def hash\n      @str.hash\n    end\n  end\n  \n  a = MyClass.new(\"some string\")\n  b = MyClass.new(\"some string\")\n  a.eql? b  #=> true\n  \n  h = {}\n  \n  h[a] = 1\n  h[a]      #=> 1\n  h[b]      #=> 1\n  \n  h[b] = 2\n  h[a]      #=> 2\n  h[b]      #=> \n2", name="Hash")
public class RubyHash
extends RubyObject
implements Map {
    private static final ObjectAllocator HASH_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyHash(runtime, klass);
        }
    };
    private RubyHashEntry[] table;
    private int size = 0;
    private int threshold;
    private static final int PROCDEFAULT_HASH_F = 1024;
    private IRubyObject ifNone;
    private static final int[] MRI_PRIMES = new int[]{11, 19, 37, 67, 131, 283, 521, 1033, 2053, 4099, 8219, 16427, 32771, 65581, 131101, 262147, 524309, 0x100007, 0x200011, 0x40000F, 0x800009, 16777259, 0x2000023, 0x400000F, 134217757, 0x10000003, 0x2000000B, 0x40000055, 0};
    private static final int JAVASOFT_INITIAL_CAPACITY = 8;
    private static final int MRI_INITIAL_CAPACITY = MRI_PRIMES[0];
    private static final int INITIAL_THRESHOLD = 6;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final RubyHashEntry NO_ENTRY = new RubyHashEntry();
    private int generation = 0;
    private final RubyHashEntry head = new RubyHashEntry();
    private static final int HASH_SIGN_BIT_MASK = Integer.MAX_VALUE;
    private static final int MIN_CAPA = 8;
    private static final int ST_DEFAULT_MAX_DENSITY = 5;
    private static boolean MRI_HASH = true;
    private static boolean MRI_HASH_RESIZE = true;
    public static long collisions = 0L;
    private static final EntryMatchType MATCH_KEY = new EntryMatchType(){

        @Override
        public boolean matches(RubyHashEntry entry, Object obj) {
            IRubyObject key = entry.key;
            return obj == key || ((IRubyObject)obj).eql(key);
        }
    };
    private static final EntryMatchType MATCH_ENTRY = new EntryMatchType(){

        @Override
        public boolean matches(RubyHashEntry entry, Object obj) {
            return entry.equals(obj);
        }
    };
    private static final boolean EQUAL_CHECK_DEFAULT_VALUE = false;
    private static final EntryView DIRECT_KEY_VIEW = new EntryView(){

        @Override
        public Object convertEntry(Ruby runtime, RubyHashEntry entry) {
            return entry.key;
        }

        @Override
        public boolean contains(RubyHash hash, Object o) {
            if (!(o instanceof IRubyObject)) {
                return false;
            }
            return hash.internalGet((IRubyObject)o) != null;
        }

        @Override
        public boolean remove(RubyHash hash, Object o) {
            if (!(o instanceof IRubyObject)) {
                return false;
            }
            return hash.internalDelete((IRubyObject)o) != NO_ENTRY;
        }
    };
    private static final EntryView KEY_VIEW = new EntryView(){

        @Override
        public Object convertEntry(Ruby runtime, RubyHashEntry entry) {
            return JavaUtil.convertRubyToJava(entry.key, Object.class);
        }

        @Override
        public boolean contains(RubyHash hash, Object o) {
            return hash.containsKey(o);
        }

        @Override
        public boolean remove(RubyHash hash, Object o) {
            return hash.remove(o) != null;
        }
    };
    private static final EntryView DIRECT_VALUE_VIEW = new EntryView(){

        @Override
        public Object convertEntry(Ruby runtime, RubyHashEntry entry) {
            return entry.value;
        }

        @Override
        public boolean contains(RubyHash hash, Object o) {
            if (!(o instanceof IRubyObject)) {
                return false;
            }
            IRubyObject obj = (IRubyObject)o;
            return hash.hasValue(obj.getRuntime().getCurrentContext(), obj);
        }

        @Override
        public boolean remove(RubyHash hash, Object o) {
            if (!(o instanceof IRubyObject)) {
                return false;
            }
            IRubyObject obj = (IRubyObject)o;
            IRubyObject key = hash.internalIndex(obj.getRuntime().getCurrentContext(), obj);
            if (key == null) {
                return false;
            }
            return hash.internalDelete(key) != NO_ENTRY;
        }
    };
    private final EntryView VALUE_VIEW;
    private final EntryView DIRECT_ENTRY_VIEW;
    private final EntryView ENTRY_VIEW;

    public static RubyClass createHashClass(Ruby runtime) {
        RubyClass hashc = runtime.defineClass("Hash", runtime.getObject(), HASH_ALLOCATOR);
        runtime.setHash(hashc);
        hashc.index = 10;
        hashc.kindOf = new RubyModule.KindOf(){

            @Override
            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyHash;
            }
        };
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyHash.class);
        hashc.includeModule(runtime.getEnumerable());
        hashc.defineAnnotatedMethods(RubyHash.class);
        hashc.dispatcher = callbackFactory.createDispatcher(hashc);
        return hashc;
    }

    @Override
    public int getNativeTypeIndex() {
        return 10;
    }

    @JRubyMethod(name={"[]"}, rest=true, frame=true, meta=true)
    public static IRubyObject create(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        RubyClass klass = (RubyClass)recv;
        if (args.length == 1 && args[0] instanceof RubyHash) {
            RubyHash otherHash = (RubyHash)args[0];
            return new RubyHash(recv.getRuntime(), klass, otherHash);
        }
        if ((args.length & 1) != 0) {
            throw recv.getRuntime().newArgumentError("odd number of args for Hash");
        }
        RubyHash hash = (RubyHash)klass.allocate();
        for (int i = 0; i < args.length; i += 2) {
            hash.op_aset(context, args[i], args[i + 1]);
        }
        return hash;
    }

    public static final RubyHash newHash(Ruby runtime) {
        return new RubyHash(runtime);
    }

    public static final RubyHash newHash(Ruby runtime, Map valueMap, IRubyObject defaultValue) {
        assert (defaultValue != null);
        return new RubyHash(runtime, valueMap, defaultValue);
    }

    private RubyHash(Ruby runtime, RubyClass klass, RubyHash other) {
        super(runtime, klass);
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.VALUE_VIEW = new EntryView(){

            @Override
            public Object convertEntry(Ruby runtime, RubyHashEntry entry) {
                return JavaUtil.convertRubyToJava(entry.value, Object.class);
            }

            @Override
            public boolean contains(RubyHash hash, Object o) {
                return hash.containsValue(o);
            }

            @Override
            public boolean remove(RubyHash hash, Object o) {
                IRubyObject value = JavaUtil.convertJavaToRuby(hash.getRuntime(), o);
                IRubyObject key = hash.internalIndex(hash.getRuntime().getCurrentContext(), value);
                if (key == null) {
                    return false;
                }
                return hash.internalDelete(key) != NO_ENTRY;
            }
        };
        this.DIRECT_ENTRY_VIEW = new EntryView(){

            @Override
            public Object convertEntry(Ruby runtime, RubyHashEntry entry) {
                return entry;
            }

            @Override
            public boolean contains(RubyHash hash, Object o) {
                if (!(o instanceof RubyHashEntry)) {
                    return false;
                }
                RubyHashEntry entry = (RubyHashEntry)o;
                RubyHashEntry candidate = RubyHash.this.internalGetEntry(entry.key);
                return candidate != NO_ENTRY && entry.equals(candidate);
            }

            @Override
            public boolean remove(RubyHash hash, Object o) {
                if (!(o instanceof RubyHashEntry)) {
                    return false;
                }
                return hash.internalDeleteEntry((RubyHashEntry)o) != NO_ENTRY;
            }
        };
        this.ENTRY_VIEW = new EntryView(){

            @Override
            public Object convertEntry(Ruby runtime, RubyHashEntry entry) {
                return new ConvertingEntry(runtime, entry);
            }

            @Override
            public boolean contains(RubyHash hash, Object o) {
                if (!(o instanceof ConvertingEntry)) {
                    return false;
                }
                ConvertingEntry entry = (ConvertingEntry)o;
                RubyHashEntry candidate = hash.internalGetEntry(entry.entry.key);
                return candidate != NO_ENTRY && entry.entry.equals(candidate);
            }

            @Override
            public boolean remove(RubyHash hash, Object o) {
                if (!(o instanceof ConvertingEntry)) {
                    return false;
                }
                ConvertingEntry entry = (ConvertingEntry)o;
                return hash.internalDeleteEntry(entry.entry) != NO_ENTRY;
            }
        };
        this.ifNone = runtime.getNil();
        this.threshold = 6;
        this.table = other.internalCopyTable(this.head);
        this.size = other.size;
    }

    public RubyHash(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.VALUE_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.DIRECT_ENTRY_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.ENTRY_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.ifNone = runtime.getNil();
        this.alloc();
    }

    public RubyHash(Ruby runtime) {
        this(runtime, runtime.getNil());
    }

    public RubyHash(Ruby runtime, IRubyObject defaultValue) {
        super(runtime, runtime.getHash());
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.VALUE_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.DIRECT_ENTRY_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.ENTRY_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.ifNone = defaultValue;
        this.alloc();
    }

    RubyHash(Ruby runtime, boolean objectSpace) {
        super(runtime, runtime.getHash(), objectSpace);
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.VALUE_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.DIRECT_ENTRY_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.ENTRY_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.alloc();
    }

    public RubyHash(Ruby runtime, Map valueMap, IRubyObject defaultValue) {
        super(runtime, runtime.getHash());
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.VALUE_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.DIRECT_ENTRY_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.ENTRY_VIEW = new /* invalid duplicate definition of identical inner class */;
        this.ifNone = defaultValue;
        this.alloc();
        for (Map.Entry e : valueMap.entrySet()) {
            this.internalPut((IRubyObject)e.getKey(), (IRubyObject)e.getValue());
        }
    }

    private final void alloc() {
        this.threshold = 6;
        ++this.generation;
        this.head.nextAdded = (this.head.prevAdded = this.head);
        this.table = new RubyHashEntry[MRI_HASH_RESIZE ? MRI_INITIAL_CAPACITY : 8];
    }

    private static int JavaSoftHashValue(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private static int JavaSoftBucketIndex(int h, int length) {
        return h & length - 1;
    }

    private static int MRIHashValue(int h) {
        return h & Integer.MAX_VALUE;
    }

    private static int MRIBucketIndex(int h, int length) {
        return h % length;
    }

    private final void resize(int newCapacity) {
        RubyHashEntry[] oldTable = this.table;
        RubyHashEntry[] newTable = new RubyHashEntry[newCapacity];
        for (int j = 0; j < oldTable.length; ++j) {
            RubyHashEntry entry = oldTable[j];
            oldTable[j] = null;
            while (entry != null) {
                RubyHashEntry next = entry.next;
                int i = RubyHash.bucketIndex(entry.hash, newCapacity);
                entry.next = newTable[i];
                newTable[i] = entry;
                entry = next;
            }
        }
        this.table = newTable;
    }

    private final void JavaSoftCheckResize() {
        if (this.size > this.threshold) {
            int oldCapacity = this.table.length;
            if (oldCapacity == 0x40000000) {
                this.threshold = Integer.MAX_VALUE;
                return;
            }
            int newCapacity = this.table.length << 1;
            this.resize(newCapacity);
            this.threshold = newCapacity - (newCapacity >> 2);
        }
    }

    private final void MRICheckResize() {
        if (this.size / this.table.length > 5) {
            int forSize = this.table.length + 1;
            int i = 0;
            int newCapacity = 8;
            while (i < MRI_PRIMES.length) {
                if (newCapacity > forSize) {
                    this.resize(MRI_PRIMES[i]);
                    return;
                }
                ++i;
                newCapacity <<= 1;
            }
            return;
        }
    }

    private static int hashValue(int h) {
        return MRI_HASH ? RubyHash.MRIHashValue(h) : RubyHash.JavaSoftHashValue(h);
    }

    private static int bucketIndex(int h, int length) {
        return MRI_HASH ? RubyHash.MRIBucketIndex(h, length) : RubyHash.JavaSoftBucketIndex(h, length);
    }

    private void checkResize() {
        if (MRI_HASH_RESIZE) {
            this.MRICheckResize();
        } else {
            this.JavaSoftCheckResize();
        }
    }

    private final void internalPut(IRubyObject key, IRubyObject value) {
        this.internalPut(key, value, true);
    }

    private final void internalPut(IRubyObject key, IRubyObject value, boolean checkForExisting) {
        this.checkResize();
        int hash = RubyHash.hashValue(key.hashCode());
        int i = RubyHash.bucketIndex(hash, this.table.length);
        if (checkForExisting) {
            RubyHashEntry entry = this.table[i];
            while (entry != null) {
                IRubyObject k;
                if (entry.hash == hash && ((k = entry.key) == key || key.eql(k))) {
                    entry.value = value;
                    return;
                }
                entry = entry.next;
            }
        }
        this.table[i] = new RubyHashEntry(hash, key, value, this.table[i], this.head);
        ++this.size;
    }

    private final IRubyObject internalGet(IRubyObject key) {
        return this.internalGetEntry(key).value;
    }

    private final RubyHashEntry internalGetEntry(IRubyObject key) {
        int hash = RubyHash.hashValue(key.hashCode());
        RubyHashEntry entry = this.table[RubyHash.bucketIndex(hash, this.table.length)];
        while (entry != null) {
            IRubyObject k;
            if (entry.hash == hash && ((k = entry.key) == key || key.eql(k))) {
                return entry;
            }
            entry = entry.next;
        }
        return NO_ENTRY;
    }

    private final RubyHashEntry internalDelete(IRubyObject key) {
        return this.internalDelete(RubyHash.hashValue(key.hashCode()), MATCH_KEY, key);
    }

    private final RubyHashEntry internalDeleteEntry(RubyHashEntry entry) {
        return this.internalDelete(RubyHash.hashValue(entry.key.hashCode()), MATCH_ENTRY, entry);
    }

    private final RubyHashEntry internalDelete(int hash, EntryMatchType matchType, Object obj) {
        int i = RubyHash.bucketIndex(hash, this.table.length);
        RubyHashEntry entry = this.table[i];
        if (entry != null) {
            RubyHashEntry prior = null;
            while (entry != null) {
                if (entry.hash == hash && matchType.matches(entry, obj)) {
                    if (prior != null) {
                        prior.next = entry.next;
                    } else {
                        this.table[i] = entry.next;
                    }
                    entry.detach();
                    --this.size;
                    return entry;
                }
                prior = entry;
                entry = entry.next;
            }
        }
        return NO_ENTRY;
    }

    private final RubyHashEntry[] internalCopyTable(RubyHashEntry destHead) {
        RubyHashEntry[] newTable = new RubyHashEntry[this.table.length];
        RubyHashEntry entry = this.head.nextAdded;
        while (entry != this.head) {
            int i = RubyHash.bucketIndex(entry.hash, this.table.length);
            newTable[i] = new RubyHashEntry(entry.hash, entry.key, entry.value, newTable[i], destHead);
            entry = entry.nextAdded;
        }
        return newTable;
    }

    public void visitAll(Visitor visitor) {
        int startGeneration = this.generation;
        RubyHashEntry entry = this.head.nextAdded;
        while (entry != this.head) {
            if (startGeneration != this.generation) {
                startGeneration = this.generation;
                entry = this.head.nextAdded;
                if (entry == this.head) break;
            }
            if (entry.isLive()) {
                visitor.visit(entry.key, entry.value);
            }
            entry = entry.nextAdded;
        }
    }

    @JRubyMethod(name={"initialize"}, optional=1, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args, Block block) {
        this.modify();
        if (block.isGiven()) {
            if (args.length > 0) {
                throw this.getRuntime().newArgumentError("wrong number of arguments");
            }
            this.ifNone = this.getRuntime().newProc(Block.Type.PROC, block);
            this.flags |= 0x400;
        } else {
            Arity.checkArgumentCount(this.getRuntime(), args, 0, 1);
            if (args.length == 1) {
                this.ifNone = args[0];
            }
        }
        return this;
    }

    @JRubyMethod(name={"default"}, optional=1, frame=true)
    public IRubyObject default_value_get(ThreadContext context, IRubyObject[] args) {
        if ((this.flags & 0x400) != 0) {
            if (args.length == 0) {
                return this.getRuntime().getNil();
            }
            return this.ifNone.callMethod(context, "call", new IRubyObject[]{this, args[0]});
        }
        return this.ifNone;
    }

    @JRubyMethod(name={"default="}, required=1)
    public IRubyObject default_value_set(IRubyObject defaultValue) {
        this.modify();
        this.ifNone = defaultValue;
        this.flags &= 0xFFFFFBFF;
        return this.ifNone;
    }

    @JRubyMethod(name={"default_proc"}, frame=true)
    public IRubyObject default_proc() {
        return (this.flags & 0x400) != 0 ? this.ifNone : this.getRuntime().getNil();
    }

    public void modify() {
        this.testFrozen("hash");
        if (this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't modify hash");
        }
    }

    public IRubyObject inspectHash(final ThreadContext context) {
        Ruby runtime = this.getRuntime();
        final StringBuffer sb = new StringBuffer("{");
        final boolean[] firstEntry = new boolean[]{true};
        this.visitAll(new Visitor(){

            @Override
            public void visit(IRubyObject key, IRubyObject value) {
                if (!firstEntry[0]) {
                    sb.append(", ");
                }
                sb.append(key.callMethod(context, "inspect")).append("=>");
                sb.append(value.callMethod(context, "inspect"));
                firstEntry[0] = false;
            }
        });
        sb.append("}");
        return runtime.newString(sb.toString());
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        if (this.size == 0) {
            return this.getRuntime().newString("{}");
        }
        if (this.getRuntime().isInspecting(this)) {
            return this.getRuntime().newString("{...}");
        }
        try {
            this.getRuntime().registerInspecting(this);
            IRubyObject iRubyObject = this.inspectHash(context);
            return iRubyObject;
        }
        finally {
            this.getRuntime().unregisterInspecting(this);
        }
    }

    @JRubyMethod(name={"size", "length"})
    public RubyFixnum rb_size() {
        return this.getRuntime().newFixnum(this.size);
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p() {
        return this.size == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @Override
    @JRubyMethod(name={"to_a"})
    public RubyArray to_a() {
        final Ruby runtime = this.getRuntime();
        final RubyArray result = RubyArray.newArray(runtime, this.size);
        this.visitAll(new Visitor(){

            @Override
            public void visit(IRubyObject key, IRubyObject value) {
                result.append(RubyArray.newArray(runtime, key, value));
            }
        });
        result.setTaint(this.isTaint());
        return result;
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        if (this.getRuntime().isInspecting(this)) {
            return this.getRuntime().newString("{...}");
        }
        try {
            this.getRuntime().registerInspecting(this);
            IRubyObject iRubyObject = this.to_a().to_s();
            return iRubyObject;
        }
        finally {
            this.getRuntime().unregisterInspecting(this);
        }
    }

    @JRubyMethod(name={"rehash"})
    public RubyHash rehash() {
        this.modify();
        RubyHashEntry[] oldTable = this.table;
        RubyHashEntry[] newTable = new RubyHashEntry[oldTable.length];
        for (int j = 0; j < oldTable.length; ++j) {
            RubyHashEntry entry = oldTable[j];
            oldTable[j] = null;
            while (entry != null) {
                RubyHashEntry next = entry.next;
                entry.hash = entry.key.hashCode();
                int i = RubyHash.bucketIndex(entry.hash, newTable.length);
                entry.next = newTable[i];
                newTable[i] = entry;
                entry = next;
            }
        }
        this.table = newTable;
        return this;
    }

    @JRubyMethod(name={"to_hash"})
    public RubyHash to_hash() {
        return this;
    }

    @Override
    public RubyHash convertToHash() {
        return this;
    }

    public final void fastASet(IRubyObject key, IRubyObject value) {
        this.internalPut(key, value);
    }

    @Deprecated
    public IRubyObject op_aset(IRubyObject key, IRubyObject value) {
        return this.op_aset(this.getRuntime().getCurrentContext(), key, value);
    }

    @JRubyMethod(name={"[]=", "store"}, required=2)
    public IRubyObject op_aset(ThreadContext context, IRubyObject key, IRubyObject value) {
        this.modify();
        if (!(key instanceof RubyString)) {
            this.internalPut(key, value);
        } else {
            RubyHashEntry entry = this.internalGetEntry(key);
            if (entry != NO_ENTRY) {
                entry.value = value;
            } else {
                RubyString realKey = (RubyString)key;
                if (!realKey.isFrozen()) {
                    realKey = realKey.strDup(realKey.getMetaClass().getRealClass());
                    realKey.setFrozen(true);
                }
                this.internalPut(realKey, value, false);
            }
        }
        return value;
    }

    public IRubyObject aset(IRubyObject key, IRubyObject value) {
        return this.op_aset(this.getRuntime().getCurrentContext(), key, value);
    }

    public IRubyObject aref(IRubyObject key) {
        return this.op_aref(this.getRuntime().getCurrentContext(), key);
    }

    public final IRubyObject fastARef(IRubyObject key) {
        return this.internalGet(key);
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject op_aref(ThreadContext context, IRubyObject key) {
        IRubyObject value = this.internalGet(key);
        return value == null ? this.callMethod(context, MethodIndex.DEFAULT, "default", key) : value;
    }

    @JRubyMethod(name={"fetch"}, required=1, optional=1, frame=true)
    public IRubyObject fetch(ThreadContext context, IRubyObject[] args, Block block) {
        IRubyObject value;
        if (args.length == 2 && block.isGiven()) {
            this.getRuntime().getWarnings().warn(IRubyWarnings.ID.BLOCK_BEATS_DEFAULT_VALUE, "block supersedes default value argument", new Object[0]);
        }
        if ((value = this.internalGet(args[0])) == null) {
            if (block.isGiven()) {
                return block.yield(context, args[0]);
            }
            if (args.length == 1) {
                throw this.getRuntime().newIndexError("key not found");
            }
            return args[1];
        }
        return value;
    }

    @JRubyMethod(name={"has_key?", "key?", "include?", "member?"}, required=1)
    public RubyBoolean has_key_p(IRubyObject key) {
        return this.internalGetEntry(key) == NO_ENTRY ? this.getRuntime().getFalse() : this.getRuntime().getTrue();
    }

    private boolean hasValue(final ThreadContext context, final IRubyObject expected) {
        try {
            this.visitAll(new Visitor(){

                @Override
                public void visit(IRubyObject key, IRubyObject value) {
                    if (RubyObject.equalInternal(context, value, expected).isTrue()) {
                        throw new Found();
                    }
                }
            });
            return false;
        }
        catch (Found found) {
            return true;
        }
    }

    @JRubyMethod(name={"has_value?", "value?"}, required=1)
    public RubyBoolean has_value_p(ThreadContext context, IRubyObject expected) {
        return this.getRuntime().newBoolean(this.hasValue(context, expected));
    }

    @JRubyMethod(name={"each"}, frame=true)
    public RubyHash each(final ThreadContext context, final Block block) {
        final Ruby runtime = this.getRuntime();
        this.visitAll(new Visitor(){

            @Override
            public void visit(IRubyObject key, IRubyObject value) {
                block.yield(context, RubyArray.newArray(runtime, key, value), null, null, false);
            }
        });
        return this;
    }

    @JRubyMethod(name={"each_pair"}, frame=true)
    public RubyHash each_pair(final ThreadContext context, final Block block) {
        final Ruby runtime = this.getRuntime();
        this.visitAll(new Visitor(){

            @Override
            public void visit(IRubyObject key, IRubyObject value) {
                block.yield(context, RubyArray.newArray(runtime, key, value), null, null, true);
            }
        });
        return this;
    }

    @JRubyMethod(name={"each_value"}, frame=true)
    public RubyHash each_value(final ThreadContext context, final Block block) {
        this.visitAll(new Visitor(){

            @Override
            public void visit(IRubyObject key, IRubyObject value) {
                block.yield(context, value);
            }
        });
        return this;
    }

    @JRubyMethod(name={"each_key"}, frame=true)
    public RubyHash each_key(final ThreadContext context, final Block block) {
        this.visitAll(new Visitor(){

            @Override
            public void visit(IRubyObject key, IRubyObject value) {
                block.yield(context, key);
            }
        });
        return this;
    }

    @JRubyMethod(name={"sort"}, frame=true)
    public RubyArray sort(Block block) {
        return this.to_a().sort_bang(block);
    }

    @JRubyMethod(name={"index"}, required=1)
    public IRubyObject index(ThreadContext context, IRubyObject expected) {
        IRubyObject key = this.internalIndex(context, expected);
        if (key != null) {
            return key;
        }
        return this.getRuntime().getNil();
    }

    private IRubyObject internalIndex(final ThreadContext context, final IRubyObject expected) {
        try {
            this.visitAll(new Visitor(){

                @Override
                public void visit(IRubyObject key, IRubyObject value) {
                    if (RubyObject.equalInternal(context, value, expected).isTrue()) {
                        throw new FoundKey(key);
                    }
                }
            });
            return null;
        }
        catch (FoundKey found) {
            return found.key;
        }
    }

    @JRubyMethod(name={"indexes", "indices"}, rest=true)
    public RubyArray indices(ThreadContext context, IRubyObject[] indices) {
        return this.values_at(context, indices);
    }

    @JRubyMethod(name={"keys"})
    public RubyArray keys() {
        Ruby runtime = this.getRuntime();
        final RubyArray keys = RubyArray.newArray(runtime, this.size);
        this.visitAll(new Visitor(){

            @Override
            public void visit(IRubyObject key, IRubyObject value) {
                keys.append(key);
            }
        });
        return keys;
    }

    @JRubyMethod(name={"values"})
    @RDoc(callSeq="hsh.values    => array", doc="Returns a new array populated with the values from <i>hsh</i>. See\nalso <code>Hash#keys</code>.\n   \n   h = { \"a\" => 100, \"b\" => 200, \"c\" => 300 }\n   h.values   #=> [100, 200, 300]\n")
    public RubyArray rb_values() {
        final RubyArray values = RubyArray.newArray(this.getRuntime(), this.size);
        this.visitAll(new Visitor(){

            @Override
            public void visit(IRubyObject key, IRubyObject value) {
                values.append(value);
            }
        });
        return values;
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(final ThreadContext context, IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyHash)) {
            if (!other.respondsTo("to_hash")) {
                return this.getRuntime().getFalse();
            }
            return RubyHash.equalInternal(context, other, this);
        }
        final RubyHash otherHash = (RubyHash)other;
        if (this.size != otherHash.size) {
            return this.getRuntime().getFalse();
        }
        Ruby runtime = this.getRuntime();
        try {
            this.visitAll(new Visitor(){

                @Override
                public void visit(IRubyObject key, IRubyObject value) {
                    IRubyObject otherValue = otherHash.internalGet(key);
                    if (otherValue == null || !RubyObject.equalInternal(context, value, otherValue).isTrue()) {
                        throw new Mismatch();
                    }
                }
            });
            return runtime.getTrue();
        }
        catch (Mismatch e) {
            return runtime.getFalse();
        }
    }

    @JRubyMethod(name={"shift"})
    public IRubyObject shift(ThreadContext context) {
        this.modify();
        RubyHashEntry entry = this.head.nextAdded;
        if (entry != this.head) {
            RubyArray result = RubyArray.newArray(this.getRuntime(), entry.key, entry.value);
            this.internalDeleteEntry(entry);
            return result;
        }
        if ((this.flags & 0x400) != 0) {
            return this.ifNone.callMethod(context, "call", new IRubyObject[]{this, this.getRuntime().getNil()});
        }
        return this.ifNone;
    }

    public final boolean fastDelete(IRubyObject key) {
        return this.internalDelete(key) != NO_ENTRY;
    }

    @JRubyMethod(name={"delete"}, required=1, frame=true)
    public IRubyObject delete(ThreadContext context, IRubyObject key, Block block) {
        this.modify();
        RubyHashEntry entry = this.internalDelete(key);
        if (entry != NO_ENTRY) {
            return entry.value;
        }
        if (block.isGiven()) {
            return block.yield(context, key);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"select"}, frame=true)
    public IRubyObject select(final ThreadContext context, final Block block) {
        final RubyArray result = this.getRuntime().newArray();
        final Ruby runtime = this.getRuntime();
        this.visitAll(new Visitor(){

            @Override
            public void visit(IRubyObject key, IRubyObject value) {
                if (block.yield(context, runtime.newArray(key, value), null, null, true).isTrue()) {
                    result.append(runtime.newArray(key, value));
                }
            }
        });
        return result;
    }

    @JRubyMethod(name={"delete_if"}, frame=true)
    public RubyHash delete_if(final ThreadContext context, final Block block) {
        this.modify();
        final Ruby runtime = this.getRuntime();
        final RubyHash self = this;
        this.visitAll(new Visitor(){

            @Override
            public void visit(IRubyObject key, IRubyObject value) {
                if (block.yield(context, RubyArray.newArray(runtime, key, value), null, null, true).isTrue()) {
                    self.delete(context, key, block);
                }
            }
        });
        return this;
    }

    @JRubyMethod(name={"reject"}, frame=true)
    public RubyHash reject(ThreadContext context, Block block) {
        return ((RubyHash)this.dup()).delete_if(context, block);
    }

    @JRubyMethod(name={"reject!"}, frame=true)
    public IRubyObject reject_bang(ThreadContext context, Block block) {
        int n = this.size;
        this.delete_if(context, block);
        if (n == this.size) {
            return this.getRuntime().getNil();
        }
        return this;
    }

    @JRubyMethod(name={"clear"})
    public RubyHash rb_clear() {
        this.modify();
        if (this.size > 0) {
            this.alloc();
            this.size = 0;
        }
        return this;
    }

    @JRubyMethod(name={"invert"})
    public RubyHash invert(final ThreadContext context) {
        final RubyHash result = RubyHash.newHash(this.getRuntime());
        this.visitAll(new Visitor(){

            @Override
            public void visit(IRubyObject key, IRubyObject value) {
                result.op_aset(context, value, key);
            }
        });
        return result;
    }

    @JRubyMethod(name={"merge!", "update"}, required=1, frame=true)
    public RubyHash merge_bang(final ThreadContext context, IRubyObject other, final Block block) {
        this.modify();
        final Ruby runtime = this.getRuntime();
        RubyHash otherHash = other.convertToHash();
        final RubyHash self = this;
        otherHash.visitAll(new Visitor(){

            @Override
            public void visit(IRubyObject key, IRubyObject value) {
                IRubyObject existing;
                if (block.isGiven() && (existing = self.internalGet(key)) != null) {
                    value = block.yield(context, RubyArray.newArrayNoCopy(runtime, new IRubyObject[]{key, existing, value}));
                }
                self.op_aset(context, key, value);
            }
        });
        return this;
    }

    @JRubyMethod(name={"merge"}, required=1, frame=true)
    public RubyHash merge(ThreadContext context, IRubyObject other, Block block) {
        return ((RubyHash)this.dup()).merge_bang(context, other, block);
    }

    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public RubyHash initialize_copy(ThreadContext context, IRubyObject other) {
        return this.replace(context, other);
    }

    @JRubyMethod(name={"replace"}, required=1)
    public RubyHash replace(final ThreadContext context, IRubyObject other) {
        RubyHash otherHash = other.convertToHash();
        if (this == otherHash) {
            return this;
        }
        this.rb_clear();
        final RubyHash self = this;
        otherHash.visitAll(new Visitor(){

            @Override
            public void visit(IRubyObject key, IRubyObject value) {
                self.op_aset(context, key, value);
            }
        });
        this.ifNone = otherHash.ifNone;
        this.flags = (otherHash.flags & 0x400) != 0 ? (this.flags |= 0x400) : (this.flags &= 0xFFFFFBFF);
        return this;
    }

    @JRubyMethod(name={"values_at"}, rest=true)
    public RubyArray values_at(ThreadContext context, IRubyObject[] args) {
        RubyArray result = RubyArray.newArray(this.getRuntime(), args.length);
        for (int i = 0; i < args.length; ++i) {
            result.append(this.op_aref(context, args[i]));
        }
        return result;
    }

    public boolean hasDefaultProc() {
        return (this.flags & 0x400) != 0;
    }

    public IRubyObject getIfNone() {
        return this.ifNone;
    }

    public static void marshalTo(RubyHash hash, final MarshalStream output) throws IOException {
        output.registerLinkTarget(hash);
        output.writeInt(hash.size);
        try {
            hash.visitAll(new Visitor(){

                @Override
                public void visit(IRubyObject key, IRubyObject value) {
                    try {
                        output.dumpObject(key);
                        output.dumpObject(value);
                    }
                    catch (IOException e) {
                        throw new VisitorIOException(e);
                    }
                }
            });
        }
        catch (VisitorIOException e) {
            throw (IOException)e.getCause();
        }
        if (!hash.ifNone.isNil()) {
            output.dumpObject(hash.ifNone);
        }
    }

    public static RubyHash unmarshalFrom(UnmarshalStream input, boolean defaultValue) throws IOException {
        RubyHash result = RubyHash.newHash(input.getRuntime());
        input.registerLinkTarget(result);
        int size = input.unmarshalInt();
        ThreadContext context = input.getRuntime().getCurrentContext();
        for (int i = 0; i < size; ++i) {
            result.op_aset(context, input.unmarshalObject(), input.unmarshalObject());
        }
        if (defaultValue) {
            result.default_value_set(input.unmarshalObject());
        }
        return result;
    }

    @Override
    public Class getJavaClass() {
        return Map.class;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.internalGet(JavaUtil.convertJavaToRuby(this.getRuntime(), key)) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.hasValue(this.getRuntime().getCurrentContext(), JavaUtil.convertJavaToRuby(this.getRuntime(), value));
    }

    public Object get(Object key) {
        return JavaUtil.convertRubyToJava(this.internalGet(JavaUtil.convertJavaToRuby(this.getRuntime(), key)));
    }

    public Object put(Object key, Object value) {
        this.internalPut(JavaUtil.convertJavaToRuby(this.getRuntime(), key), JavaUtil.convertJavaToRuby(this.getRuntime(), value));
        return value;
    }

    public Object remove(Object key) {
        IRubyObject rubyKey = JavaUtil.convertJavaToRuby(this.getRuntime(), key);
        return this.internalDelete(rubyKey).value;
    }

    public void putAll(Map map) {
        Ruby runtime = this.getRuntime();
        for (Object key : map.keySet()) {
            this.internalPut(JavaUtil.convertJavaToRuby(runtime, key), JavaUtil.convertJavaToRuby(runtime, map.get(key)));
        }
    }

    @Override
    public void clear() {
        this.rb_clear();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof RubyHash)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.op_equal(this.getRuntime().getCurrentContext(), (RubyHash)other).isTrue();
    }

    public Set keySet() {
        return new BaseSet(KEY_VIEW);
    }

    public Set directKeySet() {
        return new BaseSet(DIRECT_KEY_VIEW);
    }

    public Collection values() {
        return new BaseCollection(this.VALUE_VIEW);
    }

    public Collection directValues() {
        return new BaseCollection(DIRECT_VALUE_VIEW);
    }

    public Set entrySet() {
        return new BaseSet(this.ENTRY_VIEW);
    }

    public Set directEntrySet() {
        return new BaseSet(this.DIRECT_ENTRY_VIEW);
    }

    private static class ConvertingEntry
    implements Map.Entry {
        private final RubyHashEntry entry;
        private final Ruby runtime;

        public ConvertingEntry(Ruby runtime, RubyHashEntry entry) {
            this.entry = entry;
            this.runtime = runtime;
        }

        public Object getKey() {
            return JavaUtil.convertRubyToJava(this.entry.key, Object.class);
        }

        public Object getValue() {
            return JavaUtil.convertRubyToJava(this.entry.value, Object.class);
        }

        public Object setValue(Object o) {
            return this.entry.setValue(JavaUtil.convertJavaToRuby(this.runtime, o));
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof ConvertingEntry)) {
                return false;
            }
            ConvertingEntry other = (ConvertingEntry)o;
            return this.entry.equals(other.entry);
        }

        @Override
        public int hashCode() {
            return this.entry.hashCode();
        }
    }

    private static abstract class EntryView {
        private EntryView() {
        }

        public abstract Object convertEntry(Ruby var1, RubyHashEntry var2);

        public abstract boolean contains(RubyHash var1, Object var2);

        public abstract boolean remove(RubyHash var1, Object var2);
    }

    private class BaseIterator
    implements Iterator {
        private final EntryView view;
        private RubyHashEntry entry;
        private boolean peeking;
        private int startGeneration;

        public BaseIterator(EntryView view) {
            this.view = view;
            this.entry = RubyHash.this.head;
            this.startGeneration = RubyHash.this.generation;
        }

        private void advance(boolean consume) {
            if (!this.peeking) {
                do {
                    if (this.startGeneration != RubyHash.this.generation) {
                        this.startGeneration = RubyHash.this.generation;
                        this.entry = RubyHash.this.head;
                    }
                    this.entry = this.entry.nextAdded;
                } while (this.entry != RubyHash.this.head && !this.entry.isLive());
            }
            this.peeking = !consume;
        }

        public Object next() {
            this.advance(true);
            if (this.entry == RubyHash.this.head) {
                this.peeking = true;
                throw new NoSuchElementException();
            }
            return this.view.convertEntry(RubyHash.this.getRuntime(), this.entry);
        }

        @Override
        public boolean hasNext() {
            this.advance(false);
            return this.entry != RubyHash.this.head;
        }

        @Override
        public void remove() {
            if (this.entry == RubyHash.this.head) {
                throw new IllegalStateException("Iterator out of range");
            }
            RubyHash.this.internalDeleteEntry(this.entry);
        }
    }

    private class BaseCollection
    extends AbstractCollection {
        final EntryView view;

        public BaseCollection(EntryView view) {
            this.view = view;
        }

        @Override
        public Iterator iterator() {
            return new BaseIterator(this.view);
        }

        @Override
        public boolean contains(Object o) {
            return this.view.contains(RubyHash.this, o);
        }

        @Override
        public void clear() {
            RubyHash.this.clear();
        }

        @Override
        public int size() {
            return RubyHash.this.size;
        }

        @Override
        public boolean remove(Object o) {
            return this.view.remove(RubyHash.this, o);
        }
    }

    private class BaseSet
    extends AbstractSet {
        final EntryView view;

        public BaseSet(EntryView view) {
            this.view = view;
        }

        @Override
        public Iterator iterator() {
            return new BaseIterator(this.view);
        }

        @Override
        public boolean contains(Object o) {
            return this.view.contains(RubyHash.this, o);
        }

        @Override
        public void clear() {
            RubyHash.this.clear();
        }

        @Override
        public int size() {
            return RubyHash.this.size;
        }

        @Override
        public boolean remove(Object o) {
            return this.view.remove(RubyHash.this, o);
        }
    }

    private static class VisitorIOException
    extends RuntimeException {
        VisitorIOException(Throwable cause) {
            super(cause);
        }
    }

    private static class Mismatch
    extends RuntimeException {
        private Mismatch() {
        }
    }

    private static class FoundKey
    extends RuntimeException {
        public IRubyObject key;

        FoundKey(IRubyObject key) {
            this.key = key;
        }
    }

    private class Found
    extends RuntimeException {
        private Found() {
        }
    }

    public static abstract class Visitor {
        public abstract void visit(IRubyObject var1, IRubyObject var2);
    }

    private static abstract class EntryMatchType {
        private EntryMatchType() {
        }

        public abstract boolean matches(RubyHashEntry var1, Object var2);
    }

    static final class RubyHashEntry
    implements Map.Entry {
        private IRubyObject key;
        private IRubyObject value;
        private RubyHashEntry next;
        private RubyHashEntry prevAdded;
        private RubyHashEntry nextAdded;
        private int hash;

        RubyHashEntry() {
            this.key = RubyObject.NEVER;
        }

        RubyHashEntry(int h, IRubyObject k, IRubyObject v, RubyHashEntry e, RubyHashEntry head) {
            this.key = k;
            this.value = v;
            this.next = e;
            this.hash = h;
            this.prevAdded = head.prevAdded;
            this.nextAdded = head;
            this.nextAdded.prevAdded = this;
            this.prevAdded.nextAdded = this;
        }

        public void detach() {
            if (this.prevAdded != null) {
                this.prevAdded.nextAdded = this.nextAdded;
                this.nextAdded.prevAdded = this.prevAdded;
                this.prevAdded = null;
            }
        }

        public boolean isLive() {
            return this.prevAdded != null;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getJavaifiedKey() {
            return JavaUtil.convertRubyToJava(this.key);
        }

        public Object getValue() {
            return this.value;
        }

        public Object getJavaifiedValue() {
            return JavaUtil.convertRubyToJava(this.value);
        }

        public Object setValue(Object value) {
            IRubyObject oldValue = this.value;
            if (!(value instanceof IRubyObject)) {
                throw new UnsupportedOperationException("directEntrySet() doesn't support setValue for non IRubyObject instance entries, convert them manually or use entrySet() instead");
            }
            this.value = (IRubyObject)value;
            return oldValue;
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof RubyHashEntry)) {
                return false;
            }
            RubyHashEntry otherEntry = (RubyHashEntry)other;
            return !(this.key != otherEntry.key && !this.key.eql(otherEntry.key) || this.value != otherEntry.value && !this.value.equals(otherEntry.value));
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }
    }
}

