/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFile;
import org.jruby.RubyIO;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyArgsFile {
    public static void setCurrentLineNumber(IRubyObject recv, int newLineNumber) {
        ArgsFileData.getDataFrom((IRubyObject)recv).currentLineNumber = newLineNumber;
    }

    public static void initArgsFile(Ruby runtime) {
        RubyObject argsFile = new RubyObject(runtime, runtime.getObject());
        runtime.getEnumerable().extend_object(argsFile);
        runtime.defineReadonlyVariable("$<", argsFile);
        runtime.defineGlobalConstant("ARGF", argsFile);
        RubyClass argfClass = argsFile.getMetaClass();
        argfClass.defineAnnotatedMethods(RubyArgsFile.class);
        runtime.defineReadonlyVariable("$FILENAME", runtime.newString("-"));
    }

    @JRubyMethod(name={"fileno", "to_i"})
    public static IRubyObject fileno(ThreadContext context, IRubyObject recv) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        if (!data.startedProcessing && !data.nextArgsFile(context)) {
            throw recv.getRuntime().newArgumentError("no stream");
        }
        return ((RubyIO)data.currentFile).fileno();
    }

    @JRubyMethod(name={"to_io"})
    public static IRubyObject to_io(ThreadContext context, IRubyObject recv) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        if (!data.startedProcessing && !data.nextArgsFile(context)) {
            throw recv.getRuntime().newArgumentError("no stream");
        }
        return data.currentFile;
    }

    public static IRubyObject internalGets(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        if (data.currentFile == null && !data.nextArgsFile(context)) {
            return recv.getRuntime().getNil();
        }
        IRubyObject line = data.currentFile.callMethod(context, "gets", args);
        while (line instanceof RubyNil) {
            data.currentFile.callMethod(context, "close");
            if (!data.nextArgsFile(context)) {
                data.currentFile = null;
                return line;
            }
            line = data.currentFile.callMethod(context, "gets", args);
        }
        ++data.currentLineNumber;
        recv.getRuntime().getGlobalVariables().set("$.", recv.getRuntime().newFixnum(data.currentLineNumber));
        return line;
    }

    @JRubyMethod(name={"gets"}, optional=1, frame=true)
    public static IRubyObject gets(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        IRubyObject result = RubyArgsFile.internalGets(context, recv, args);
        if (!result.isNil()) {
            context.getCurrentFrame().setLastLine(result);
        }
        return result;
    }

    @JRubyMethod(name={"readline"}, optional=1, frame=true)
    public static IRubyObject readline(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        IRubyObject line = RubyArgsFile.gets(context, recv, args);
        if (line.isNil()) {
            throw recv.getRuntime().newEOFError();
        }
        return line;
    }

    @JRubyMethod(name={"readlines"}, optional=1, frame=true)
    public static RubyArray readlines(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        IRubyObject line;
        IRubyObject[] separatorArgument;
        if (args.length > 0) {
            if (!recv.getRuntime().getNilClass().isInstance(args[0]) && !recv.getRuntime().getString().isInstance(args[0])) {
                throw recv.getRuntime().newTypeError(args[0], recv.getRuntime().getString());
            }
            separatorArgument = new IRubyObject[]{args[0]};
        } else {
            separatorArgument = IRubyObject.NULL_ARRAY;
        }
        RubyArray result = recv.getRuntime().newArray();
        while (!(line = RubyArgsFile.internalGets(context, recv, separatorArgument)).isNil()) {
            result.append(line);
        }
        return result;
    }

    @JRubyMethod(name={"each_byte"}, frame=true)
    public static IRubyObject each_byte(ThreadContext context, IRubyObject recv, Block block) {
        IRubyObject bt;
        while (!(bt = RubyArgsFile.getc(context, recv)).isNil()) {
            block.yield(context, bt);
        }
        return recv;
    }

    @JRubyMethod(name={"each_line"}, alias={"each"}, optional=1, frame=true)
    public static IRubyObject each_line(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        IRubyObject nextLine = RubyArgsFile.internalGets(context, recv, args);
        while (!nextLine.isNil()) {
            block.yield(context, nextLine);
            nextLine = RubyArgsFile.internalGets(context, recv, args);
        }
        return recv;
    }

    @JRubyMethod(name={"file"})
    public static IRubyObject file(ThreadContext context, IRubyObject recv) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        if (data.currentFile == null && !data.nextArgsFile(context)) {
            return recv.getRuntime().getNil();
        }
        return data.currentFile;
    }

    @JRubyMethod(name={"skip"})
    public static IRubyObject skip(IRubyObject recv) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        data.currentFile = null;
        return recv;
    }

    @JRubyMethod(name={"close"})
    public static IRubyObject close(ThreadContext context, IRubyObject recv) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        if (data.currentFile == null && !data.nextArgsFile(context)) {
            return recv;
        }
        data.currentFile = null;
        data.currentLineNumber = 0;
        return recv;
    }

    @JRubyMethod(name={"closed?"})
    public static IRubyObject closed_p(ThreadContext context, IRubyObject recv) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        if (data.currentFile == null && !data.nextArgsFile(context)) {
            return recv;
        }
        return ((RubyIO)data.currentFile).closed_p();
    }

    @JRubyMethod(name={"binmode"})
    public static IRubyObject binmode(ThreadContext context, IRubyObject recv) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        if (data.currentFile == null && !data.nextArgsFile(context)) {
            throw recv.getRuntime().newArgumentError("no stream");
        }
        return ((RubyIO)data.currentFile).binmode();
    }

    @JRubyMethod(name={"lineno"})
    public static IRubyObject lineno(IRubyObject recv) {
        return recv.getRuntime().newFixnum(ArgsFileData.getDataFrom((IRubyObject)recv).currentLineNumber);
    }

    @JRubyMethod(name={"tell"}, alias={"pos"})
    public static IRubyObject tell(ThreadContext context, IRubyObject recv) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        if (data.currentFile == null && !data.nextArgsFile(context)) {
            throw recv.getRuntime().newArgumentError("no stream to tell");
        }
        return ((RubyIO)data.currentFile).pos();
    }

    @JRubyMethod(name={"rewind"})
    public static IRubyObject rewind(ThreadContext context, IRubyObject recv) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        if (data.currentFile == null && !data.nextArgsFile(context)) {
            throw recv.getRuntime().newArgumentError("no stream to rewind");
        }
        return ((RubyIO)data.currentFile).rewind();
    }

    @JRubyMethod(name={"eof", "eof?"})
    public static IRubyObject eof(ThreadContext context, IRubyObject recv) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        if (data.currentFile != null && !data.nextArgsFile(context)) {
            return recv.getRuntime().getTrue();
        }
        return ((RubyIO)data.currentFile).eof_p();
    }

    @JRubyMethod(name={"pos="}, required=1)
    public static IRubyObject set_pos(ThreadContext context, IRubyObject recv, IRubyObject offset) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        if (data.currentFile == null && !data.nextArgsFile(context)) {
            throw recv.getRuntime().newArgumentError("no stream to set position");
        }
        return ((RubyIO)data.currentFile).pos_set(offset);
    }

    @JRubyMethod(name={"seek"}, required=1, optional=1)
    public static IRubyObject seek(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        if (data.currentFile == null && !data.nextArgsFile(context)) {
            throw recv.getRuntime().newArgumentError("no stream to seek");
        }
        return ((RubyIO)data.currentFile).seek(args);
    }

    @JRubyMethod(name={"lineno="}, required=1)
    public static IRubyObject set_lineno(IRubyObject recv, IRubyObject line) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        data.currentLineNumber = RubyNumeric.fix2int(line);
        return recv.getRuntime().getNil();
    }

    @JRubyMethod(name={"readchar"})
    public static IRubyObject readchar(ThreadContext context, IRubyObject recv) {
        IRubyObject c = RubyArgsFile.getc(context, recv);
        if (c.isNil()) {
            throw recv.getRuntime().newEOFError();
        }
        return c;
    }

    @JRubyMethod(name={"getc"})
    public static IRubyObject getc(ThreadContext context, IRubyObject recv) {
        IRubyObject bt;
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        while (true) {
            if (data.currentFile == null && !data.nextArgsFile(context)) {
                return recv.getRuntime().getNil();
            }
            bt = !(data.currentFile instanceof RubyFile) ? data.currentFile.callMethod(context, "getc") : ((RubyIO)data.currentFile).getc();
            if (!bt.isNil()) break;
            data.currentFile = null;
        }
        return bt;
    }

    @JRubyMethod(name={"read"}, optional=2)
    public static IRubyObject read(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        IRubyObject str;
        IRubyObject length;
        ArgsFileData data = ArgsFileData.getDataFrom(recv);
        long len = 0L;
        if (args.length > 0) {
            length = args[0];
            str = args.length > 1 ? args[1] : recv.getRuntime().getNil();
        } else {
            length = recv.getRuntime().getNil();
            str = recv.getRuntime().getNil();
        }
        if (!length.isNil()) {
            len = RubyNumeric.num2long(length);
        }
        if (!str.isNil()) {
            str = str.convertToString();
            ((RubyString)str).modify();
            ((RubyString)str).getByteList().length(0);
            args[1] = recv.getRuntime().getNil();
        }
        while (true) {
            if (data.currentFile == null && !data.nextArgsFile(context)) {
                return str;
            }
            IRubyObject tmp = !(data.currentFile instanceof RubyIO) ? data.currentFile.callMethod(context, "read", args) : ((RubyIO)data.currentFile).read(args);
            if (str.isNil()) {
                str = tmp;
            } else if (!tmp.isNil()) {
                ((RubyString)str).append(tmp);
            }
            if (tmp.isNil() || length.isNil()) {
                data.currentFile = null;
                continue;
            }
            if (args.length < 1 || (long)((RubyString)str).getByteList().length() >= len) break;
            args[0] = recv.getRuntime().newFixnum(len -= (long)((RubyString)str).getByteList().length());
        }
        return str;
    }

    @JRubyMethod(name={"filename"}, alias={"path"})
    public static RubyString filename(IRubyObject recv) {
        return (RubyString)recv.getRuntime().getGlobalVariables().get("$FILENAME");
    }

    @JRubyMethod(name={"to_s"})
    public static IRubyObject to_s(IRubyObject recv) {
        return recv.getRuntime().newString("ARGF");
    }

    private static final class ArgsFileData {
        private Ruby runtime;
        public IRubyObject currentFile;
        public int currentLineNumber;
        public boolean startedProcessing = false;
        public boolean finishedProcessing = false;

        public ArgsFileData(Ruby runtime) {
            this.runtime = runtime;
        }

        public boolean nextArgsFile(ThreadContext context) {
            if (this.finishedProcessing) {
                return false;
            }
            RubyArray args = (RubyArray)this.runtime.getGlobalVariables().get("$*");
            if (args.getLength() == 0) {
                if (!this.startedProcessing) {
                    this.currentFile = this.runtime.getGlobalVariables().get("$stdin");
                    ((RubyString)this.runtime.getGlobalVariables().get("$FILENAME")).setValue(new StringBuffer("-"));
                    this.currentLineNumber = 0;
                    this.startedProcessing = true;
                    return true;
                }
                this.finishedProcessing = true;
                return false;
            }
            String filename = args.shift().toString();
            ((RubyString)this.runtime.getGlobalVariables().get("$FILENAME")).setValue(new StringBuffer(filename));
            this.currentFile = filename.equals("-") ? this.runtime.getGlobalVariables().get("$stdin") : RubyFile.open(context, this.runtime.getFile(), new IRubyObject[]{this.runtime.newString(filename)}, Block.NULL_BLOCK);
            this.startedProcessing = true;
            return true;
        }

        public static ArgsFileData getDataFrom(IRubyObject recv) {
            ArgsFileData data = (ArgsFileData)recv.dataGetStruct();
            if (data == null) {
                data = new ArgsFileData(recv.getRuntime());
                recv.dataWrapStruct(data);
            }
            return data;
        }
    }
}

