/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.image.VolatileImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Arrays;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyProc;
import org.jruby.anno.JRubyMethod;
import org.jruby.demo.TextAreaReadline;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class JRubyApplet
extends Applet {
    private Ruby runtime;
    private boolean doubleBuffered = true;
    private Color backgroundColor = Color.WHITE;
    private IRubyObject rubyObject;
    private RubyProc startProc;
    private RubyProc stopProc;
    private RubyProc destroyProc;
    private RubyProc paintProc;
    private Graphics priorGraphics;
    private IRubyObject wrappedGraphics;
    private VolatileImage backBuffer;
    private Graphics backBufferGraphics;
    private Facade facade;

    private static RubyProc blockToProc(Ruby runtime, Block block) {
        if (block.isGiven()) {
            RubyProc proc = block.getProcObject();
            if (proc == null) {
                proc = RubyProc.newProc(runtime, block, block.type);
            }
            return proc;
        }
        return null;
    }

    private boolean getBooleanParameter(String name, boolean default_value) {
        String value = this.getParameter(name);
        if (value != null) {
            return value.equals("true");
        }
        return default_value;
    }

    private InputStream getCodeResourceAsStream(String name) {
        if (name == null) {
            return null;
        }
        try {
            URL directURL = new URL(this.getCodeBase(), name);
            return directURL.openStream();
        }
        catch (IOException iOException) {
            return JRubyApplet.class.getClassLoader().getResourceAsStream(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        super.init();
        this.facade = this.getBooleanParameter("console", false) ? new ConsoleFacade() : new TrivialFacade();
        JRubyApplet jRubyApplet = this;
        synchronized (jRubyApplet) {
            if (this.runtime != null) {
                return;
            }
            RubyInstanceConfig config = new RubyInstanceConfig(){
                {
                    this.setInput(JRubyApplet.this.facade.getInputStream());
                    this.setOutput(JRubyApplet.this.facade.getOutputStream());
                    this.setError(JRubyApplet.this.facade.getErrorStream());
                    this.setObjectSpaceEnabled(JRubyApplet.this.getBooleanParameter("objectspace", false));
                }
            };
            Ruby.setSecurityRestricted(true);
            this.runtime = Ruby.newInstance(config);
            this.rubyObject = JavaUtil.convertJavaToUsableRubyObject(this.runtime, this);
            this.rubyObject.dataWrapStruct(this);
            this.runtime.defineGlobalConstant("JRUBY_APPLET", this.rubyObject);
            this.rubyObject.getMetaClass().defineAnnotatedMethods(RubyMethods.class);
        }
        final String scriptName = this.getParameter("script");
        final InputStream scriptStream = this.getCodeResourceAsStream(scriptName);
        final String evalString = this.getParameter("eval");
        try {
            final JRubyApplet applet = this;
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    applet.setLayout(new BorderLayout());
                    applet.facade.attach(applet.runtime, applet);
                    if (scriptStream != null) {
                        applet.runtime.runFromMain(scriptStream, scriptName);
                    }
                    if (evalString != null) {
                        applet.runtime.evalScriptlet(evalString);
                    }
                }
            });
        }
        catch (InterruptedException applet) {
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error running script", e.getCause());
        }
    }

    private void invokeCallback(final RubyProc proc, final IRubyObject[] args) {
        if (proc == null) {
            return;
        }
        final Ruby runtime = this.runtime;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ThreadContext context = runtime.getCurrentContext();
                    proc.call(context, args, Block.NULL_BLOCK);
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Ruby callback failed", e.getCause());
        }
    }

    public synchronized void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        this.repaint();
    }

    public synchronized Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public synchronized boolean isDoubleBuffered() {
        return this.doubleBuffered;
    }

    public synchronized void setDoubleBuffered(boolean shouldBuffer) {
        this.doubleBuffered = shouldBuffer;
        this.repaint();
    }

    @Override
    public synchronized void start() {
        super.start();
        this.invokeCallback(this.startProc, new IRubyObject[0]);
    }

    @Override
    public synchronized void stop() {
        this.invokeCallback(this.stopProc, new IRubyObject[0]);
        super.stop();
    }

    @Override
    public synchronized void destroy() {
        try {
            this.invokeCallback(this.destroyProc, new IRubyObject[0]);
        }
        finally {
            Ruby runtime = this.runtime;
            this.runtime = null;
            this.rubyObject = null;
            this.startProc = null;
            this.stopProc = null;
            this.destroyProc = null;
            this.paintProc = null;
            this.priorGraphics = null;
            this.wrappedGraphics = null;
            runtime.tearDown();
            super.destroy();
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public synchronized void paint(Graphics g) {
        if (this.doubleBuffered) {
            this.paintBuffered(g);
        } else {
            this.paintUnbuffered(g);
        }
    }

    private synchronized void paintBuffered(Graphics g) {
        do {
            GraphicsConfiguration config = this.getGraphicsConfiguration();
            int width = this.getWidth();
            int height = this.getHeight();
            if (this.backBuffer == null || width != this.backBuffer.getWidth() || height != this.backBuffer.getHeight() || this.backBuffer.validate(config) == 2) {
                if (this.backBuffer != null) {
                    this.backBufferGraphics.dispose();
                    this.backBuffer.flush();
                }
                this.backBuffer = config.createCompatibleVolatileImage(width, height);
                this.backBufferGraphics = this.backBuffer.createGraphics();
            }
            this.backBufferGraphics.setClip(g.getClip());
            this.paintUnbuffered(this.backBufferGraphics);
        } while (this.backBuffer.contentsLost());
        g.drawImage(this.backBuffer, 0, 0, this);
    }

    private synchronized void paintUnbuffered(Graphics g) {
        if (this.backgroundColor != null) {
            g.setColor(this.backgroundColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.paintProc != null) {
            if (this.priorGraphics != g) {
                this.wrappedGraphics = JavaUtil.convertJavaToUsableRubyObject(this.runtime, g);
                this.priorGraphics = g;
            }
            ThreadContext context = this.runtime.getCurrentContext();
            this.paintProc.call(context, new IRubyObject[]{this.wrappedGraphics}, Block.NULL_BLOCK);
        }
        super.paint(g);
    }

    private static class ConsoleFacade
    implements Facade {
        private JTextPane textPane = new JTextPane();
        private JScrollPane scrollPane;
        private TextAreaReadline adaptor;
        private InputStream inputStream;
        private PrintStream outputStream;
        private PrintStream errorStream;

        public ConsoleFacade() {
            this.textPane.setMargin(new Insets(4, 4, 0, 4));
            this.textPane.setCaretColor(new Color(164, 0, 0));
            this.textPane.setBackground(new Color(242, 242, 242));
            this.textPane.setForeground(new Color(164, 0, 0));
            Font font = this.findFont("Monospaced", 0, 14, new String[]{"Monaco", "Andale Mono"});
            this.textPane.setFont(font);
            this.scrollPane = new JScrollPane(this.textPane);
            this.scrollPane.setDoubleBuffered(true);
            this.adaptor = new TextAreaReadline(this.textPane, "  JRuby applet console  \n\n");
            this.inputStream = new PipedInputStream();
            this.outputStream = new PrintStream(this.adaptor);
            this.errorStream = new PrintStream(this.adaptor);
        }

        @Override
        public InputStream getInputStream() {
            return this.inputStream;
        }

        @Override
        public PrintStream getOutputStream() {
            return this.outputStream;
        }

        @Override
        public PrintStream getErrorStream() {
            return this.errorStream;
        }

        @Override
        public void attach(Ruby runtime, Applet applet) {
            this.adaptor.hookIntoRuntime(runtime);
            applet.add(this.scrollPane);
            applet.validate();
        }

        private Font findFont(String otherwise, int style, int size, String[] families) {
            Object[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            Arrays.sort(fonts);
            for (int i = 0; i < families.length; ++i) {
                if (Arrays.binarySearch(fonts, families[i]) < 0) continue;
                return new Font(families[i], style, size);
            }
            return new Font(otherwise, style, size);
        }
    }

    private static class TrivialFacade
    implements Facade {
        @Override
        public InputStream getInputStream() {
            return System.in;
        }

        @Override
        public PrintStream getOutputStream() {
            return System.out;
        }

        @Override
        public PrintStream getErrorStream() {
            return System.err;
        }

        @Override
        public void attach(Ruby runtime, Applet applet) {
        }
    }

    public static class RubyMethods {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod
        public static IRubyObject on_start(IRubyObject recv, Block block) {
            JRubyApplet applet;
            JRubyApplet jRubyApplet = applet = (JRubyApplet)recv.dataGetStruct();
            synchronized (jRubyApplet) {
                applet.startProc = JRubyApplet.blockToProc(applet.runtime, block);
            }
            return recv;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod
        public static IRubyObject on_stop(IRubyObject recv, Block block) {
            JRubyApplet applet;
            JRubyApplet jRubyApplet = applet = (JRubyApplet)recv.dataGetStruct();
            synchronized (jRubyApplet) {
                applet.stopProc = JRubyApplet.blockToProc(applet.runtime, block);
            }
            return recv;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod
        public static IRubyObject on_destroy(IRubyObject recv, Block block) {
            JRubyApplet applet;
            JRubyApplet jRubyApplet = applet = (JRubyApplet)recv.dataGetStruct();
            synchronized (jRubyApplet) {
                applet.destroyProc = JRubyApplet.blockToProc(applet.runtime, block);
            }
            return recv;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod
        public static IRubyObject on_paint(IRubyObject recv, Block block) {
            JRubyApplet applet;
            JRubyApplet jRubyApplet = applet = (JRubyApplet)recv.dataGetStruct();
            synchronized (jRubyApplet) {
                applet.paintProc = JRubyApplet.blockToProc(applet.runtime, block);
                applet.repaint();
            }
            return recv;
        }
    }

    private static interface Facade {
        public InputStream getInputStream();

        public PrintStream getOutputStream();

        public PrintStream getErrorStream();

        public void attach(Ruby var1, Applet var2);
    }
}

