/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jna;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractMemoryPointer;
import org.jruby.ext.ffi.FFIProvider;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.jna.JNAMemory;
import org.jruby.ext.ffi.jna.JNAMemoryIO;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::MemoryPointer"}, parent="FFI::AbstractMemoryPointer")
public class JNABasePointer
extends AbstractMemoryPointer
implements JNAMemory {
    public static final String JNA_POINTER_NAME = "JNAPointer";

    public static RubyClass createJNAPointerClass(Ruby runtime2, RubyModule module) {
        RubyClass result = module.defineClassUnder(JNA_POINTER_NAME, module.getClass("AbstractMemoryPointer"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.defineAnnotatedMethods(JNABasePointer.class);
        result.defineAnnotatedConstants(JNABasePointer.class);
        return result;
    }

    JNABasePointer(Ruby runtime2, MemoryIO io2, long offset2, long size2) {
        this(runtime2, FFIProvider.getModule(runtime2).fastGetClass(JNA_POINTER_NAME), io2, offset2, size2);
    }

    JNABasePointer(Ruby runtime2, Pointer value2) {
        this(runtime2, JNAMemoryIO.wrap(value2), 0L, Long.MAX_VALUE);
    }

    JNABasePointer(Ruby runtime2, RubyClass klass, MemoryIO io2, long offset2, long size2) {
        super(runtime2, klass, io2, offset2, size2);
    }

    JNABasePointer(Ruby runtime2, IRubyObject klass, Pointer value2) {
        this(runtime2, klass, (MemoryIO)JNAMemoryIO.wrap(value2), 0L, Long.MAX_VALUE);
    }

    JNABasePointer(Ruby runtime2, IRubyObject klass, JNABasePointer ptr, long offset2) {
        this(runtime2, klass, ptr.io, ptr.offset + offset2, ptr.size == Long.MAX_VALUE ? Long.MAX_VALUE : ptr.size - offset2);
    }

    JNABasePointer(Ruby runtime2, IRubyObject klass, MemoryIO io2, long offset2, long size2) {
        super(runtime2, (RubyClass)klass, io2, offset2, size2);
    }

    @JRubyMethod(name={"to_s"}, optional=1)
    public IRubyObject to_s(ThreadContext context, IRubyObject[] args2) {
        Pointer address2 = this.getAddress();
        String hex2 = address2 != null ? address2.toString() : "native@0x0";
        return RubyString.newString(context.getRuntime(), "Pointer [address=" + hex2 + "]");
    }

    Pointer getAddress() {
        return ((JNAMemoryIO)this.getMemoryIO()).getAddress();
    }

    public Object getNativeMemory() {
        return ((JNAMemoryIO)this.getMemoryIO()).slice(this.offset).getMemory();
    }

    static final long ptr2long(Pointer ptr) {
        return new PointerByReference(ptr).getPointer().getInt(0L);
    }

    @JRubyMethod(name={"address"})
    public IRubyObject address(ThreadContext context) {
        return context.getRuntime().newFixnum(JNABasePointer.ptr2long(this.getAddress()));
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        String hex2 = Long.toHexString(JNABasePointer.ptr2long(this.getAddress()) + this.offset);
        return RubyString.newString(context.getRuntime(), String.format("#<Pointer address=0x%s>", hex2));
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(ThreadContext context, IRubyObject value2) {
        return new JNABasePointer(context.getRuntime(), (IRubyObject)FFIProvider.getModule(context.getRuntime()).fastGetClass(JNA_POINTER_NAME), this, RubyNumeric.fix2long(value2));
    }

    @JRubyMethod(name={"put_pointer"}, required=2)
    public IRubyObject put_pointer(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        Pointer ptr;
        if (value2 instanceof JNABasePointer) {
            ptr = ((JNABasePointer)value2).getAddress();
        } else if (value2.isNil()) {
            ptr = Pointer.NULL;
        } else {
            throw context.getRuntime().newArgumentError("Cannot convert argument to pointer");
        }
        ((JNAMemoryIO)this.getMemoryIO()).putPointer(this.getOffset(offset2), ptr);
        return this;
    }

    protected AbstractMemoryPointer getPointer(Ruby runtime2, long offset2) {
        return new JNABasePointer(runtime2, this.getMemoryIO().getMemoryIO(this.offset + offset2), 0L, Long.MAX_VALUE);
    }
}

