/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.yarv;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.AndNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.NotNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.executable.YARVInstructions;
import org.jruby.ast.executable.YARVMachine;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.types.INameNode;
import org.jruby.runtime.builtin.IRubyObject;

public class StandardYARVCompiler {
    private YARVMachine.InstructionSequence iseq;
    private Ruby runtime;
    private int last_line = -1;
    private LinkAnchor current_iseq;
    private String[] locals = new String[0];
    private static final int COMPILE_OK = 1;
    private int label_no = 0;

    private Label NEW_LABEL(int l) {
        Label label = new Label(l, this.label_no);
        ++this.label_no;
        return label;
    }

    private static void ADD_LABEL(LinkAnchor anchor, LinkElement elem) {
        anchor.add(elem);
    }

    private static void ADD_ELEM(LinkAnchor anchor, LinkElement elem) {
        anchor.add(elem);
    }

    private static LinkElement POP_ELEMENT(LinkAnchor anchor) {
        return anchor.pop();
    }

    private static boolean LIST_SIZE_ZERO(LinkAnchor anchor) {
        return anchor.isEmpty();
    }

    private static void APPEND_LIST(LinkAnchor anc1, LinkAnchor anc2) {
        anc1.append(anc2);
    }

    private static void ADD_SEQ(LinkAnchor seq1, LinkAnchor seq2) {
        seq1.append(seq2);
    }

    private int debug_compile(String msg, int v) {
        this.debugs(msg);
        return v;
    }

    private int COMPILE(LinkAnchor anchor, String desc, Node node) {
        return this.debug_compile("== " + desc, this.iseq_compile_each(anchor, node, false));
    }

    private int COMPILE(LinkAnchor anchor, String desc, Node node, boolean poped) {
        return this.debug_compile("== " + desc, this.iseq_compile_each(anchor, node, poped));
    }

    private int COMPILE_POPED(LinkAnchor anchor, String desc, Node node) {
        return this.debug_compile("== " + desc, this.iseq_compile_each(anchor, node, true));
    }

    private LinkAnchor DECL_ANCHOR() {
        return new LinkAnchor();
    }

    public StandardYARVCompiler(Ruby runtime2) {
        this.runtime = runtime2;
    }

    private void debugs(String s) {
        System.err.println(s);
    }

    public void compile(Node node) {
        this.iseq_compile(null, node);
    }

    public void compile(Node node, Compiler context) {
        this.compile(node);
    }

    public void iseq_compile(IRubyObject self, Node node) {
        LinkAnchor list_anchor = this.DECL_ANCHOR();
        this.debugs("[compile step 1 (traverse each node)]");
        while (node.nodeId == NodeType.NEWLINENODE) {
            node = ((NewlineNode)node).getNextNode();
        }
        this.COMPILE(list_anchor, "top level node", node);
        this.ADD_INSN(list_anchor, this.last_line, 50);
        this.current_iseq = list_anchor;
    }

    private int nd_line(Node node) {
        if (node.getPosition() != null) {
            return node.getPosition().getEndLine();
        }
        return this.last_line;
    }

    private String nd_file(Node node) {
        if (node.getPosition() != null) {
            return node.getPosition().getFile();
        }
        return null;
    }

    private int iseq_compile_each(LinkAnchor ret, Node node, boolean poped) {
        if (node == null) {
            if (!poped) {
                this.debugs("NODE_NIL(implicit)");
                this.ADD_INSN(ret, 0, 15);
                return 1;
            }
            return 1;
        }
        this.last_line = this.nd_line(node);
        LinkAnchor recv2 = null;
        LinkAnchor args2 = null;
        block26: while (true) {
            switch (node.nodeId) {
                case BLOCKNODE: {
                    List<Node> l = ((BlockNode)node).childNodes();
                    int sz = l.size();
                    for (int i = 0; i < sz; ++i) {
                        boolean p2 = i + 1 != sz || poped;
                        this.COMPILE(ret, "BLOCK body", l.get(i), p2);
                    }
                    break block26;
                }
                case NEWLINENODE: {
                    node = ((NewlineNode)node).getNextNode();
                    continue block26;
                }
                case ROOTNODE: {
                    this.locals = ((RootNode)node).getStaticScope().getAllNamesInScope();
                    node = ((RootNode)node).getBodyNode();
                    continue block26;
                }
                case DEFNNODE: {
                    StandardYARVCompiler c = new StandardYARVCompiler(this.runtime);
                    c.compile(((DefnNode)node).getBodyNode());
                    YARVMachine.InstructionSequence iseqval = c.getInstructionSequence(((DefnNode)node).getName(), this.nd_file(node), "method");
                    ArrayList<String> argNames = new ArrayList<String>();
                    ListNode argsNode = ((DefnNode)node).getArgsNode().getPre();
                    if (argsNode != null) {
                        for (int i = 0; i < argsNode.size(); ++i) {
                            ArgumentNode argumentNode = (ArgumentNode)argsNode.get(i);
                            argNames.add(argumentNode.getName());
                        }
                    }
                    iseqval.args_argc = argNames.size();
                    String[] l1 = iseqval.locals;
                    String[] l2 = new String[l1.length + argNames.size()];
                    System.arraycopy(l1, 0, l2, argNames.size(), l1.length);
                    for (int i = 0; i < argNames.size(); ++i) {
                        l2[i] = (String)argNames.get(i);
                    }
                    iseqval.locals = l2;
                    this.ADD_INSN(ret, this.nd_line(node), 15);
                    this.ADD_INSN3(ret, this.nd_line(node), 40, ((DefnNode)node).getName(), iseqval, 0L);
                    if (poped) break block26;
                    this.ADD_INSN(ret, this.nd_line(node), 15);
                    break block26;
                }
                case STRNODE: {
                    if (poped) break block26;
                    this.ADD_INSN1(ret, this.nd_line(node), 19, ((StrNode)node).getValue().toString());
                    break block26;
                }
                case CONSTNODE: {
                    this.ADD_INSN1(ret, this.nd_line(node), 11, ((ConstNode)node).getName());
                    if (!poped) break block26;
                    this.ADD_INSN(ret, this.nd_line(node), 32);
                    break block26;
                }
                case CONSTDECLNODE: {
                    if (!poped) {
                        this.ADD_INSN(ret, this.nd_line(node), 33);
                    }
                    this.ADD_INSN1(ret, this.nd_line(node), 12, ((ConstDeclNode)node).getName());
                    break block26;
                }
                case LOCALASGNNODE: {
                    int idx = ((LocalAsgnNode)node).getIndex();
                    this.debugs("lvar: " + idx);
                    this.COMPILE(ret, "lvalue", ((LocalAsgnNode)node).getValueNode());
                    if (!poped) {
                        this.ADD_INSN(ret, this.nd_line(node), 33);
                    }
                    this.ADD_INSN1(ret, this.nd_line(node), 2, idx);
                    break block26;
                }
                case LOCALVARNODE: {
                    if (poped) break block26;
                    int idx2 = ((LocalVarNode)node).getIndex();
                    this.debugs("idx: " + idx2);
                    this.ADD_INSN1(ret, this.nd_line(node), 1, idx2);
                    break block26;
                }
                case IFNODE: {
                    LinkAnchor cond_seq = this.DECL_ANCHOR();
                    LinkAnchor then_seq = this.DECL_ANCHOR();
                    LinkAnchor else_seq = this.DECL_ANCHOR();
                    Label then_label = this.NEW_LABEL(this.nd_line(node));
                    Label else_label = this.NEW_LABEL(this.nd_line(node));
                    Label end_label = this.NEW_LABEL(this.nd_line(node));
                    this.compile_branch_condition(cond_seq, ((IfNode)node).getCondition(), then_label, else_label);
                    this.COMPILE(then_seq, "then", ((IfNode)node).getThenBody(), poped);
                    this.COMPILE(else_seq, "else", ((IfNode)node).getElseBody(), poped);
                    StandardYARVCompiler.ADD_SEQ(ret, cond_seq);
                    StandardYARVCompiler.ADD_LABEL(ret, then_label);
                    StandardYARVCompiler.ADD_SEQ(ret, then_seq);
                    this.ADD_INSNL(ret, this.nd_line(node), 53, end_label);
                    StandardYARVCompiler.ADD_LABEL(ret, else_label);
                    StandardYARVCompiler.ADD_SEQ(ret, else_seq);
                    StandardYARVCompiler.ADD_LABEL(ret, end_label);
                    break block26;
                }
                case VCALLNODE: 
                case FCALLNODE: 
                case CALLNODE: {
                    recv2 = this.DECL_ANCHOR();
                    args2 = this.DECL_ANCHOR();
                    if (node.nodeId == NodeType.CALLNODE) {
                        this.COMPILE(recv2, "recv", ((CallNode)node).getReceiverNode());
                    } else {
                        this.ADD_CALL_RECEIVER(recv2, this.nd_line(node));
                    }
                    int argc = 0;
                    int flags = 0;
                    if (!(node instanceof VCallNode)) {
                        int[] argc_flags = this.setup_arg(args2, (IArgumentNode)((Object)node));
                        argc = argc_flags[0];
                        flags = argc_flags[1];
                    } else {
                        argc = 0;
                    }
                    StandardYARVCompiler.ADD_SEQ(ret, recv2);
                    StandardYARVCompiler.ADD_SEQ(ret, args2);
                    switch (node.nodeId) {
                        case VCALLNODE: {
                            flags |= 0x10;
                        }
                        case FCALLNODE: {
                            flags |= 8;
                        }
                    }
                    YARVMachine.Instruction inst = this.ADD_SEND_R(ret, this.nd_line(node), ((INameNode)((Object)node)).getName(), argc, null, flags);
                    if ((flags & 8) == 0) {
                        if (((INameNode)((Object)node)).getName().equals("<")) {
                            this.insn_set_specialized_instruction(inst, 67);
                        } else if (((INameNode)((Object)node)).getName().equals("+")) {
                            this.insn_set_specialized_instruction(inst, 61);
                        } else if (((INameNode)((Object)node)).getName().equals("-")) {
                            this.insn_set_specialized_instruction(inst, 62);
                        }
                    }
                    if (!poped) break block26;
                    this.ADD_INSN(ret, this.nd_line(node), 32);
                    break block26;
                }
                case ARRAYNODE: {
                    this.compile_array(ret, node, true);
                    if (!poped) break block26;
                    this.ADD_INSN(ret, this.nd_line(node), 32);
                    break block26;
                }
                case ZARRAYNODE: {
                    if (poped) break block26;
                    this.ADD_INSN1(ret, this.nd_line(node), 23, 0L);
                    break block26;
                }
                case HASHNODE: {
                    LinkAnchor list2 = this.DECL_ANCHOR();
                    long size2 = 0L;
                    ListNode lnode = ((HashNode)node).getListNode();
                    if (((Node)lnode).childNodes().size() > 0) {
                        this.compile_array(list2, lnode, false);
                        size2 = ((Insn)StandardYARVCompiler.POP_ELEMENT((LinkAnchor)list2)).i.l_op0;
                        StandardYARVCompiler.ADD_SEQ(ret, list2);
                    }
                    this.ADD_INSN1(ret, this.nd_line(node), 29, size2);
                    if (!poped) break block26;
                    this.ADD_INSN(ret, this.nd_line(node), 32);
                    break block26;
                }
                case FIXNUMNODE: {
                    FixnumNode iVisited = (FixnumNode)node;
                    if (poped) break block26;
                    this.ADD_INSN1(ret, this.nd_line(node), 18, iVisited.getFixnum(this.runtime));
                    break block26;
                }
                case WHILENODE: 
                case UNTILNODE: {
                    Label next_label = this.NEW_LABEL(this.nd_line(node));
                    Label redo_label = this.NEW_LABEL(this.nd_line(node));
                    Label break_label = this.NEW_LABEL(this.nd_line(node));
                    Label end_label = this.NEW_LABEL(this.nd_line(node));
                    StandardYARVCompiler.ADD_LABEL(ret, redo_label);
                    Node body = null;
                    if (node instanceof WhileNode) {
                        body = ((WhileNode)node).getBodyNode();
                    } else if (node instanceof UntilNode) {
                        body = ((UntilNode)node).getBodyNode();
                    }
                    this.COMPILE_POPED(ret, "while body", body);
                    StandardYARVCompiler.ADD_LABEL(ret, next_label);
                    if (node instanceof WhileNode) {
                        this.compile_branch_condition(ret, ((WhileNode)node).getConditionNode(), redo_label, end_label);
                    } else if (node instanceof UntilNode) {
                        this.compile_branch_condition(ret, ((UntilNode)node).getConditionNode(), end_label, redo_label);
                    } else {
                        this.ADD_CALL_RECEIVER(ret, this.nd_line(node));
                        this.ADD_INSNL(ret, this.nd_line(node), 54, redo_label);
                    }
                    StandardYARVCompiler.ADD_LABEL(ret, end_label);
                    this.ADD_INSN(ret, this.nd_line(node), 15);
                    StandardYARVCompiler.ADD_LABEL(ret, break_label);
                    if (!poped) break block26;
                    this.ADD_INSN(ret, this.nd_line(node), 32);
                    break block26;
                }
                case SELFNODE: {
                    if (poped) break block26;
                    this.ADD_INSN(ret, this.nd_line(node), 16);
                    break block26;
                }
                case NILNODE: {
                    if (poped) break block26;
                    this.ADD_INSN(ret, this.nd_line(node), 15);
                    break block26;
                }
                case TRUENODE: {
                    if (poped) break block26;
                    this.ADD_INSN1(ret, this.nd_line(node), 18, this.runtime.getTrue());
                    break block26;
                }
                case FALSENODE: {
                    if (poped) break block26;
                    this.ADD_INSN1(ret, this.nd_line(node), 18, this.runtime.getFalse());
                    break block26;
                }
                default: {
                    this.debugs(" ... doesn't handle node: " + node);
                    break block26;
                }
            }
            break;
        }
        return 1;
    }

    private int compile_branch_condition(LinkAnchor ret, Node cond, Label then_label, Label else_label) {
        switch (cond.nodeId) {
            case NOTNODE: {
                this.compile_branch_condition(ret, ((NotNode)cond).getConditionNode(), else_label, then_label);
                break;
            }
            case ANDNODE: {
                Label label = this.NEW_LABEL(this.nd_line(cond));
                this.compile_branch_condition(ret, ((AndNode)cond).getFirstNode(), label, else_label);
                StandardYARVCompiler.ADD_LABEL(ret, label);
                this.compile_branch_condition(ret, ((AndNode)cond).getSecondNode(), then_label, else_label);
                break;
            }
            case ORNODE: {
                Label label = this.NEW_LABEL(this.nd_line(cond));
                this.compile_branch_condition(ret, ((OrNode)cond).getFirstNode(), then_label, label);
                StandardYARVCompiler.ADD_LABEL(ret, label);
                this.compile_branch_condition(ret, ((OrNode)cond).getSecondNode(), then_label, else_label);
                break;
            }
            case STRNODE: 
            case TRUENODE: {
                this.ADD_INSNL(ret, this.nd_line(cond), 53, then_label);
                break;
            }
            case NILNODE: 
            case FALSENODE: {
                this.ADD_INSNL(ret, this.nd_line(cond), 53, else_label);
                break;
            }
            default: {
                this.COMPILE(ret, "branch condition", cond);
                this.ADD_INSNL(ret, this.nd_line(cond), 55, else_label);
                this.ADD_INSNL(ret, this.nd_line(cond), 53, then_label);
            }
        }
        return 1;
    }

    private int compile_array(LinkAnchor ret, Node node_root, boolean opt_p) {
        Node node2 = node_root;
        int len = ((ArrayNode)node2).size();
        int line = this.nd_line(node2);
        LinkAnchor anchor = this.DECL_ANCHOR();
        List<Node> c = node2.childNodes();
        for (Node node2 : c) {
            if (opt_p && !(node2 instanceof ILiteralNode)) {
                opt_p = false;
            }
            this.COMPILE(anchor, "array element", node2);
        }
        if (opt_p) {
            ArrayList<IRubyObject> l = new ArrayList<IRubyObject>();
            block4: for (Node node2 : c) {
                switch (node2.nodeId) {
                    case FIXNUMNODE: {
                        l.add(((FixnumNode)node2).getFixnum(this.runtime));
                        continue block4;
                    }
                }
                this.debugs(" ... doesn't handle array literal node: " + node2);
            }
            this.ADD_INSN1(ret, this.nd_line(node_root), 24, this.runtime.newArray(l));
        } else {
            this.ADD_INSN1(anchor, line, 23, len);
            StandardYARVCompiler.APPEND_LIST(ret, anchor);
        }
        return len;
    }

    private int[] setup_arg(LinkAnchor args2, IArgumentNode node) {
        int[] n = new int[]{0, 0};
        Node argn = node.getArgsNode();
        LinkAnchor arg_block = this.DECL_ANCHOR();
        LinkAnchor args_push = this.DECL_ANCHOR();
        boolean blockArgs = false;
        if (argn != null) {
            if (argn instanceof BlockPassNode) {
                BlockPassNode blockPassNode = (BlockPassNode)argn;
                this.COMPILE(arg_block, "block", blockPassNode.getBodyNode());
                blockArgs = true;
                argn = blockPassNode.getArgsNode();
            }
            switch (argn.nodeId) {
                case SPLATNODE: {
                    break;
                }
                case ARGSCATNODE: {
                    break;
                }
                case ARGSPUSHNODE: {
                    break;
                }
                default: {
                    n[0] = this.compile_array(args2, argn, false);
                    StandardYARVCompiler.POP_ELEMENT(args2);
                }
            }
        }
        if (!StandardYARVCompiler.LIST_SIZE_ZERO(args_push)) {
            StandardYARVCompiler.ADD_SEQ(args2, args_push);
        }
        if (blockArgs) {
            StandardYARVCompiler.ADD_SEQ(args2, arg_block);
        }
        return n;
    }

    private Insn new_insn(YARVMachine.Instruction i) {
        Insn n = new Insn();
        n.i = i;
        n.next = null;
        return n;
    }

    private void insn_set_specialized_instruction(YARVMachine.Instruction instruction, int insn_id) {
        instruction.bytecode = insn_id;
    }

    private void ADD_CALL_RECEIVER(LinkAnchor seq, int line) {
        this.ADD_INSN(seq, line, 15);
    }

    private void ADD_INSN(LinkAnchor seq, int line, int insn) {
        YARVMachine.Instruction i = new YARVMachine.Instruction(insn);
        i.line_no = line;
        this.debugs("ADD_INSN(" + line + ", " + YARVInstructions.name(insn) + ")");
        StandardYARVCompiler.ADD_ELEM(seq, this.new_insn(i));
    }

    private YARVMachine.Instruction ADD_SEND_R(LinkAnchor seq, int line, String name2, int argc, Object block, int flags) {
        YARVMachine.Instruction i = new YARVMachine.Instruction(47);
        i.line_no = line;
        i.s_op0 = name2;
        i.i_op1 = argc;
        i.i_op3 = flags;
        this.debugs("ADD_SEND_R(" + line + ", " + YARVInstructions.name(47) + ", " + name2 + ", " + argc + ", " + flags + ")");
        StandardYARVCompiler.ADD_ELEM(seq, this.new_insn(i));
        return i;
    }

    private void ADD_INSN1(LinkAnchor seq, int line, int insn, IRubyObject obj) {
        YARVMachine.Instruction i = new YARVMachine.Instruction(insn);
        i.line_no = line;
        i.o_op0 = obj;
        this.debugs("ADD_INSN1(" + line + ", " + YARVInstructions.name(insn) + ", " + obj + ")");
        StandardYARVCompiler.ADD_ELEM(seq, this.new_insn(i));
    }

    private void ADD_INSN1(LinkAnchor seq, int line, int insn, long op) {
        YARVMachine.Instruction i = new YARVMachine.Instruction(insn);
        i.line_no = line;
        i.l_op0 = op;
        this.debugs("ADD_INSN1(" + line + ", " + YARVInstructions.name(insn) + ", " + op + ")");
        StandardYARVCompiler.ADD_ELEM(seq, this.new_insn(i));
    }

    private void ADD_INSNL(LinkAnchor seq, int line, int insn, Label l) {
        YARVMachine.Instruction i = new YARVMachine.Instruction(insn);
        i.line_no = line;
        i._tmp = l;
        this.debugs("ADD_INSNL(" + line + ", " + YARVInstructions.name(insn) + ", " + l + ")");
        StandardYARVCompiler.ADD_ELEM(seq, this.new_insn(i));
    }

    private void ADD_INSN1(LinkAnchor seq, int line, int insn, String obj) {
        YARVMachine.Instruction i = new YARVMachine.Instruction(insn);
        i.line_no = line;
        i.s_op0 = obj;
        this.debugs("ADD_INSN1(" + line + ", " + YARVInstructions.name(insn) + ", " + obj + ")");
        StandardYARVCompiler.ADD_ELEM(seq, this.new_insn(i));
    }

    private void ADD_INSN3(LinkAnchor seq, int line, int insn, String name2, YARVMachine.InstructionSequence iseq, long n) {
        YARVMachine.Instruction i = new YARVMachine.Instruction(insn);
        i.line_no = line;
        i.s_op0 = name2;
        i.iseq_op = iseq;
        i.l_op0 = n;
        this.debugs("ADD_INSN3(" + line + ", " + YARVInstructions.name(insn) + ", " + name2 + ", " + iseq + ", " + n + ")");
        StandardYARVCompiler.ADD_ELEM(seq, this.new_insn(i));
    }

    public YARVMachine.InstructionSequence getInstructionSequence(String name2, String filename2, String level2) {
        this.iseq = new YARVMachine.InstructionSequence(this.runtime, name2, filename2, level2);
        ArrayList<YARVMachine.Instruction> l = new ArrayList<YARVMachine.Instruction>();
        IdentityHashMap<Insn, Object> jumps = new IdentityHashMap<Insn, Object>();
        IdentityHashMap<LinkAnchor, Integer> labels = new IdentityHashMap<LinkAnchor, Integer>();
        int real2 = 0;
        LinkElement elm = this.current_iseq;
        while (elm != null) {
            if (elm instanceof Insn) {
                Insn i = (Insn)elm;
                if (this.isJump(i.i.bytecode)) {
                    jumps.put(i, i.i._tmp);
                }
                l.add(i.i);
                ++real2;
            } else if (elm instanceof Label) {
                labels.put((LinkAnchor)elm, new Integer(real2 + 1));
            }
            elm = elm.next;
        }
        for (Insn k : jumps.keySet()) {
            k.i.l_op0 = (Integer)labels.get(jumps.get(k)) - 1;
            k.i._tmp = null;
        }
        this.debugs("instructions: " + l);
        this.iseq.body = l.toArray(new YARVMachine.Instruction[l.size()]);
        this.iseq.locals = this.locals;
        return this.iseq;
    }

    private boolean isJump(int i) {
        return i == 53 || i == 54 || i == 55 || i == 56 || i == 58;
    }

    private static class Insn
    extends LinkElement {
        YARVMachine.Instruction i;

        private Insn() {
        }
    }

    private static class Label
    extends LinkElement {
        int id;

        public Label(int line, int id2) {
            this.next = null;
            this.id = id2;
        }
    }

    private static class LinkAnchor
    extends LinkElement {
        LinkElement last = this;

        public void add(LinkElement element) {
            element.prev = this.last;
            this.last.next = element;
            this.last = element;
            this.verify_list("add");
        }

        public void append(LinkAnchor other) {
            if (other.next != null) {
                this.last.next = other.next;
                other.next.prev = this.last;
                this.last = other.last;
            }
            this.verify_list("append");
        }

        public void insert(LinkAnchor other) {
            if (other.next != null) {
                LinkElement first2 = this.next;
                this.next = other.next;
                this.next.prev = this;
                other.last.next = first2;
                if (first2 != null) {
                    first2.prev = other.last;
                } else {
                    this.last = other.last;
                }
            }
            this.verify_list("append");
        }

        public boolean isEmpty() {
            return this.next == null;
        }

        public LinkElement pop() {
            LinkElement element = this.last;
            this.last = this.last.prev;
            this.last.next = null;
            this.verify_list("pop");
            return element;
        }

        public LinkElement shift() {
            LinkElement elem = this.next;
            if (null != elem) {
                this.next = elem.next;
            }
            return elem;
        }

        public int size() {
            int size2 = 0;
            LinkElement elem = this.next;
            while (elem != null) {
                ++size2;
                elem = elem.next;
            }
            return size2;
        }

        private void verify_list(String info) {
            int flag = 0;
            LinkElement plist = this;
            LinkElement list2 = this.next;
            while (list2 != null) {
                if (plist != list2.prev) {
                    ++flag;
                }
                plist = list2;
                list2 = list2.next;
            }
            if (this.last != plist && this.last != null) {
                flag |= 0x70000;
            }
            if (flag != 0) {
                throw new RuntimeException("list verify error: " + Integer.toString(flag, 16) + " (" + info + ")");
            }
        }

        public LinkElement first() {
            return null;
        }
    }

    private static abstract class LinkElement {
        public LinkElement next;
        public LinkElement prev;

        private LinkElement() {
        }

        public void insert(LinkElement other) {
            other.prev = this.prev;
            other.next = this;
            this.prev = other;
            if (other.prev != null) {
                other.prev.next = other;
            }
        }

        public void remove() {
            this.prev.next = this.next;
            if (this.next != null) {
                this.next.prev = this.prev;
            }
        }

        public void replace(LinkElement other) {
            other.prev = this.prev;
            other.next = this.next;
            if (this.prev != null) {
                this.prev.next = other;
            }
            if (this.next != null) {
                this.next.prev = other;
            }
        }
    }
}

