/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.executable;

import java.util.Arrays;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubySymbol;
import org.jruby.ast.executable.Script;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class AbstractScript
implements Script {
    public CallSite[] callSites;
    public RubySymbol[] symbols;
    public RubyFixnum[] fixnums;
    public String filename;
    public IRubyObject[] constants;
    public int[] constantGenerations;

    public IRubyObject __file__(ThreadContext context, IRubyObject self, Block block) {
        return this.__file__(context, self, IRubyObject.NULL_ARRAY, block);
    }

    public IRubyObject __file__(ThreadContext context, IRubyObject self, IRubyObject arg2, Block block) {
        return this.__file__(context, self, new IRubyObject[]{arg2}, block);
    }

    public IRubyObject __file__(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.__file__(context, self, new IRubyObject[]{arg1, arg2}, block);
    }

    public IRubyObject __file__(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        return this.__file__(context, self, new IRubyObject[]{arg1, arg2, arg3}, block);
    }

    public IRubyObject load(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
        return null;
    }

    public IRubyObject run(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
        return this.__file__(context, self, args2, block);
    }

    public final CallSite getCallSite(int index2) {
        return this.callSites[index2];
    }

    public final RubySymbol getSymbol(Ruby runtime2, int index2, String name2) {
        RubySymbol symbol = this.symbols[index2];
        if (symbol == null) {
            this.symbols[index2] = runtime2.newSymbol(name2);
            return this.symbols[index2];
        }
        return symbol;
    }

    public final RubyFixnum getFixnum(Ruby runtime2, int index2, int value2) {
        RubyFixnum fixnum = this.fixnums[index2];
        if (fixnum == null) {
            this.fixnums[index2] = RubyFixnum.newFixnum(runtime2, value2);
            return this.fixnums[index2];
        }
        return fixnum;
    }

    public final RubyFixnum getFixnum(Ruby runtime2, int index2, long value2) {
        RubyFixnum fixnum = this.fixnums[index2];
        if (fixnum == null) {
            this.fixnums[index2] = RubyFixnum.newFixnum(runtime2, value2);
            return this.fixnums[index2];
        }
        return fixnum;
    }

    public final void initCallSites(int size2) {
        this.callSites = new CallSite[size2];
    }

    public final void initSymbols(int size2) {
        this.symbols = new RubySymbol[size2];
    }

    public final void initFixnums(int size2) {
        this.fixnums = new RubyFixnum[size2];
    }

    public final void initConstants(int size2) {
        this.constants = new IRubyObject[size2];
        this.constantGenerations = new int[size2];
        Arrays.fill(this.constantGenerations, -1);
    }

    public static CallSite[] setCallSite(CallSite[] callSites, int index2, String name2) {
        callSites[index2] = MethodIndex.getCallSite(name2);
        return callSites;
    }

    public static CallSite[] setFunctionalCallSite(CallSite[] callSites, int index2, String name2) {
        callSites[index2] = MethodIndex.getFunctionalCallSite(name2);
        return callSites;
    }

    public static CallSite[] setVariableCallSite(CallSite[] callSites, int index2, String name2) {
        callSites[index2] = MethodIndex.getVariableCallSite(name2);
        return callSites;
    }

    public final void setFilename(String filename2) {
        this.filename = filename2;
    }

    public final IRubyObject getConstant(ThreadContext context, String name2, int index2) {
        IRubyObject value2 = this.getValue(context, name2, index2);
        return value2 != null ? value2 : context.getRubyClass().callMethod(context, "const_missing", context.getRuntime().fastNewSymbol(name2));
    }

    public IRubyObject getValue(ThreadContext context, String name2, int index2) {
        IRubyObject value2 = this.constants[index2];
        return this.isCached(context, value2, index2) ? value2 : this.reCache(context, name2, index2);
    }

    private boolean isCached(ThreadContext context, IRubyObject value2, int index2) {
        return value2 != null && this.constantGenerations[index2] == context.getRuntime().getConstantGeneration();
    }

    public IRubyObject reCache(ThreadContext context, String name2, int index2) {
        IRubyObject value2;
        int newGeneration = context.getRuntime().getConstantGeneration();
        this.constants[index2] = value2 = context.getConstant(name2);
        if (value2 != null) {
            this.constantGenerations[index2] = newGeneration;
        }
        return value2;
    }
}

