/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jna;

import com.sun.jna.Native;
import java.nio.channels.ByteChannel;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ext.ffi.FFIProvider;
import org.jruby.ext.ffi.Factory;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.jna.FileDescriptorByteChannel;
import org.jruby.ext.ffi.jna.JNABasePointer;
import org.jruby.ext.ffi.jna.JNABuffer;
import org.jruby.ext.ffi.jna.JNAMemoryPointer;
import org.jruby.ext.ffi.jna.JNAPlatform;
import org.jruby.ext.ffi.jna.JNAProvider;
import org.jruby.ext.ffi.jna.JNAVariadicInvoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNAFactory
extends Factory {
    private final JNAPlatform platform = new JNAPlatform();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Ruby runtime2, RubyModule ffi2) {
        super.init(runtime2, ffi2);
        RubyModule rubyModule = ffi2;
        synchronized (rubyModule) {
            if (ffi2.fastGetClass("JNAPointer") == null) {
                JNABasePointer.createJNAPointerClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("MemoryPointer") == null) {
                JNAMemoryPointer.createMemoryPointerClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("Buffer") == null) {
                JNABuffer.createBufferClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("VariadicInvoker") == null) {
                JNAVariadicInvoker.createVariadicInvokerClass(runtime2, ffi2);
            }
        }
    }

    @Override
    protected FFIProvider newProvider(Ruby runtime2) {
        return new JNAProvider(runtime2);
    }

    @Override
    public <T> T loadLibrary(String libraryName, Class<T> libraryClass) {
        try {
            return libraryClass.cast(Native.loadLibrary(libraryName, libraryClass));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public Platform getPlatform() {
        return this.platform;
    }

    @Override
    public ByteChannel newByteChannel(int fd) {
        return new FileDescriptorByteChannel(fd);
    }
}

