/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.io.IOException;
import java.nio.channels.ByteChannel;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.ext.ffi.AbstractBuffer;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.AbstractMemoryPointer;
import org.jruby.ext.ffi.AutoPointer;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.FFIProvider;
import org.jruby.ext.ffi.Invoker;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.StructLayout;
import org.jruby.ext.ffi.StructLayoutBuilder;
import org.jruby.ext.ffi.io.FileDescriptorIO;
import org.jruby.runtime.load.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Factory {
    protected Factory() {
    }

    public static final Factory getInstance() {
        return SingletonHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Ruby runtime2, RubyModule ffi2) {
        RubyModule rubyModule = ffi2;
        synchronized (rubyModule) {
            if (ffi2.fastGetClass("Provider") == null) {
                FFIProvider.createProviderClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("Invoker") == null) {
                Invoker.createInvokerClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("AbstractMemory") == null) {
                AbstractMemory.createAbstractMemoryClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("Pointer") == null) {
                Pointer.createPointerClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("AutoPointer") == null) {
                AutoPointer.createAutoPointerClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("AbstractMemoryPointer") == null) {
                AbstractMemoryPointer.createMemoryPointerClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("AbstractBuffer") == null) {
                AbstractBuffer.createBufferClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("CallbackInfo") == null) {
                CallbackInfo.createCallbackInfoClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("StructLayout") == null) {
                StructLayout.createStructLayoutClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("StructLayoutBuilder") == null) {
                StructLayoutBuilder.createStructLayoutBuilderClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("FileDescriptorIO") == null) {
                FileDescriptorIO.createFileDescriptorIOClass(runtime2, ffi2);
            }
            FFIProvider provider = this.newProvider(runtime2);
            ffi2.defineConstant("InvokerFactory", provider);
            ffi2.defineConstant("LastError", provider);
            RubyModule nativeType = ffi2.defineModuleUnder("NativeType");
            for (NativeType type2 : NativeType.values()) {
                nativeType.defineConstant(type2.name(), runtime2.newFixnum(type2.ordinal()));
            }
            Platform.getPlatform().init(runtime2, ffi2);
        }
    }

    protected abstract FFIProvider newProvider(Ruby var1);

    public abstract <T> T loadLibrary(String var1, Class<T> var2);

    public abstract Platform getPlatform();

    public abstract ByteChannel newByteChannel(int var1);

    public static class Service
    implements Library {
        public void load(Ruby runtime2, boolean wrap2) throws IOException {
            if (!RubyInstanceConfig.nativeEnabled) {
                throw runtime2.newLoadError("Native API access is disabled");
            }
            RubyModule ffi2 = runtime2.defineModule("FFI");
            Factory factory = Factory.getInstance();
            factory.init(runtime2, ffi2);
        }
    }

    private static final class SingletonHolder {
        private static final Factory INSTANCE = SingletonHolder.getInstance();

        private SingletonHolder() {
        }

        private static final Factory getInstance() {
            boolean useJNA = Boolean.getBoolean("jruby.ffi.usejna");
            String prefix = FFIProvider.class.getPackage().getName();
            Factory factory = null;
            if (!useJNA) {
                try {
                    factory = (Factory)Class.forName(prefix + ".jffi.JFFIFactory", true, Ruby.getClassLoader()).newInstance();
                }
                catch (Throwable ex) {
                    // empty catch block
                }
            }
            if (factory == null) {
                try {
                    factory = (Factory)Class.forName(prefix + ".jna.JNAFactory", true, Ruby.getClassLoader()).newInstance();
                }
                catch (Throwable ex) {
                    throw new RuntimeException("Could not load FFI provider", ex);
                }
            }
            return factory;
        }
    }
}

