/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.BlockArgNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.RestArgNode;
import org.jruby.ast.UnnamedRestArgNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgsNode
extends Node {
    private final ListNode pre;
    private final int preCount;
    private final ListNode optArgs;
    protected final ArgumentNode restArgNode;
    protected final int restArg;
    private final BlockArgNode blockArgNode;
    protected Arity arity;
    private final int requiredArgsCount;
    protected final boolean hasOptArgs;
    protected int maxArgsCount;
    private final ListNode post;
    private final int postCount;
    private final int postIndex;

    public ArgsNode(ISourcePosition position, ListNode pre, ListNode optionalArguments, RestArgNode rest2, ListNode post, BlockArgNode blockArgNode) {
        super(position, NodeType.ARGSNODE);
        this.pre = pre;
        this.preCount = pre == null ? 0 : pre.size();
        this.post = post;
        this.postCount = post == null ? 0 : post.size();
        this.postIndex = rest2 == null ? 0 : rest2.getIndex() + 1;
        this.optArgs = optionalArguments;
        this.restArg = rest2 == null ? -1 : rest2.getIndex();
        this.restArgNode = rest2;
        this.blockArgNode = blockArgNode;
        this.requiredArgsCount = this.preCount + this.postCount;
        this.hasOptArgs = this.getOptArgs() != null;
        this.maxArgsCount = this.getRestArg() >= 0 ? -1 : this.getRequiredArgsCount() + this.getOptionalArgsCount();
        this.arity = this.calculateArity();
    }

    protected Arity calculateArity() {
        if (this.restArgNode instanceof UnnamedRestArgNode) {
            return Arity.optional();
        }
        if (this.getOptArgs() != null || this.getRestArg() >= 0) {
            return Arity.required(this.getRequiredArgsCount());
        }
        return Arity.createArity(this.getRequiredArgsCount());
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitArgsNode(this);
    }

    public ListNode getPre() {
        return this.pre;
    }

    @Deprecated
    public ListNode getArgs() {
        return this.pre;
    }

    public Arity getArity() {
        return this.arity;
    }

    public int getRequiredArgsCount() {
        return this.requiredArgsCount;
    }

    public int getOptionalArgsCount() {
        return this.optArgs == null ? 0 : this.optArgs.size();
    }

    public ListNode getPost() {
        return this.post;
    }

    public int getMaxArgumentsCount() {
        return this.maxArgsCount;
    }

    public ListNode getOptArgs() {
        return this.optArgs;
    }

    public int getRestArg() {
        return this.restArg;
    }

    public ArgumentNode getRestArgNode() {
        return this.restArgNode;
    }

    @Deprecated
    public BlockArgNode getBlockArgNode() {
        return this.blockArgNode;
    }

    public BlockArgNode getBlock() {
        return this.blockArgNode;
    }

    public void prepare(ThreadContext context, Ruby runtime2, IRubyObject self, IRubyObject[] args2, Block block) {
        DynamicScope scope = context.getCurrentScope();
        if (this.preCount > 0) {
            scope.setArgValues(args2, Math.min(args2.length, this.preCount));
        }
        if (this.postCount > 0) {
            scope.setEndArgValues(args2, this.postIndex, this.postCount);
        }
        if (this.hasOptArgs || this.restArg != -1) {
            this.prepareOptOrRestArgs(context, runtime2, scope, self, args2);
        }
        if (this.getBlock() != null) {
            this.processBlockArg(scope, runtime2, block);
        }
    }

    public void prepare(ThreadContext context, Ruby runtime2, IRubyObject self, Block block) {
        this.prepare(context, runtime2, self, IRubyObject.NULL_ARRAY, block);
    }

    public void prepare(ThreadContext context, Ruby runtime2, IRubyObject self, IRubyObject arg0, Block block) {
        this.prepare(context, runtime2, self, new IRubyObject[]{arg0}, block);
    }

    public void prepare(ThreadContext context, Ruby runtime2, IRubyObject self, IRubyObject arg0, IRubyObject arg1, Block block) {
        this.prepare(context, runtime2, self, new IRubyObject[]{arg0, arg1}, block);
    }

    public void prepare(ThreadContext context, Ruby runtime2, IRubyObject self, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        this.prepare(context, runtime2, self, new IRubyObject[]{arg0, arg1, arg2}, block);
    }

    public void prepare(ThreadContext context, Ruby runtime2, IRubyObject self, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        this.prepare(context, runtime2, self, new IRubyObject[]{arg0, arg1, arg2, arg3}, block);
    }

    public void checkArgCount(Ruby runtime2, int argsLength) {
        Arity.checkArgumentCount(runtime2, argsLength, this.requiredArgsCount, this.maxArgsCount);
    }

    protected void prepareOptOrRestArgs(ThreadContext context, Ruby runtime2, DynamicScope scope, IRubyObject self, IRubyObject[] args2) {
        this.prepareRestArg(context, runtime2, scope, args2, this.prepareOptionalArguments(context, runtime2, self, args2));
    }

    protected int prepareOptionalArguments(ThreadContext context, Ruby runtime2, IRubyObject self, IRubyObject[] args2) {
        return this.hasOptArgs ? this.assignOptArgs(args2, runtime2, context, self, this.preCount) : this.preCount;
    }

    protected void prepareRestArg(ThreadContext context, Ruby runtime2, DynamicScope scope, IRubyObject[] args2, int givenArgsCount) {
        if (this.restArg >= 0) {
            scope.setValue(this.restArg, RubyArray.newArrayNoCopy(runtime2, args2, givenArgsCount, args2.length - this.postCount - givenArgsCount), 0);
        }
    }

    protected int assignOptArgs(IRubyObject[] args2, Ruby runtime2, ThreadContext context, IRubyObject self, int givenArgsCount) {
        int i;
        int j = 0;
        for (i = this.preCount; i < args2.length - this.postCount && j < this.optArgs.size(); ++i, ++j) {
            this.optArgs.get(j).assign(runtime2, context, self, args2[i], Block.NULL_BLOCK, true);
            ++givenArgsCount;
        }
        i = 0;
        while (j < this.optArgs.size()) {
            this.optArgs.get(j).interpret(runtime2, context, self, Block.NULL_BLOCK);
            ++i;
            ++j;
        }
        return givenArgsCount;
    }

    protected void processBlockArg(DynamicScope scope, Ruby runtime2, Block block) {
        scope.setValue(this.getBlock().getCount(), RuntimeHelpers.processBlockArgument(runtime2, block), 0);
    }

    @Override
    public List<Node> childNodes() {
        if (this.post != null) {
            return Node.createList(this.pre, this.optArgs, this.restArgNode, this.post, this.blockArgNode);
        }
        return Node.createList(this.pre, this.optArgs, this.restArgNode, this.blockArgNode);
    }
}

