/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public final class ByteList
implements Comparable,
CharSequence,
Serializable {
    private static final long serialVersionUID = -1286166947275543731L;
    public static final byte[] NULL_ARRAY = new byte[0];
    public static final ByteList EMPTY_BYTELIST = new ByteList(0);
    public byte[] bytes;
    public int begin;
    public int realSize;
    int hash;
    boolean validHash = false;
    String stringValue;
    private static final int DEFAULT_SIZE = 4;
    private static final double FACTOR = 1.5;
    private static final char[] caseTable = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0086', '\u0087', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u008d', '\u008e', '\u008f', '\u0090', '\u0091', '\u0092', '\u0093', '\u0094', '\u0095', '\u0096', '\u0097', '\u0098', '\u0099', '\u009a', '\u009b', '\u009c', '\u009d', '\u009e', '\u009f', '\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};

    public ByteList() {
        this(4);
    }

    public ByteList(int size2) {
        this.bytes = new byte[size2];
        this.realSize = 0;
    }

    public ByteList(byte[] wrap2) {
        this(wrap2, true);
    }

    public ByteList(byte[] wrap2, boolean copy) {
        if (wrap2 == null) {
            throw new NullPointerException("Invalid argument: constructing with null array");
        }
        this.bytes = copy ? (byte[])wrap2.clone() : wrap2;
        this.realSize = wrap2.length;
    }

    public ByteList(ByteList wrap2) {
        this(wrap2.bytes, wrap2.begin, wrap2.realSize);
    }

    public ByteList(ByteList wrap2, boolean copy) {
        this(wrap2.bytes, wrap2.begin, wrap2.realSize, false);
    }

    public ByteList(byte[] wrap2, int index2, int len) {
        this(wrap2, index2, len, true);
    }

    public ByteList(byte[] wrap2, int index2, int len, boolean copy) {
        if (wrap2 == null) {
            throw new NullPointerException("Invalid argument: constructing with null array");
        }
        if (copy || index2 != 0) {
            this.bytes = new byte[len];
            System.arraycopy(wrap2, index2, this.bytes, 0, len);
        } else {
            this.bytes = wrap2;
        }
        this.realSize = len;
    }

    public ByteList(ByteList wrap2, int index2, int len) {
        this(wrap2.bytes, wrap2.begin + index2, len);
    }

    private ByteList(boolean flag) {
    }

    public void delete(int start2, int len) {
        this.realSize -= len;
        System.arraycopy(this.bytes, start2 + len, this.bytes, start2, this.realSize);
    }

    public ByteList append(byte b) {
        this.grow(1);
        this.bytes[this.realSize++] = b;
        return this;
    }

    public ByteList append(int b) {
        this.append((byte)b);
        return this;
    }

    public ByteList append(InputStream input, int length2) throws IOException {
        int read2;
        int n;
        this.grow(length2);
        for (read2 = 0; read2 < length2; read2 += n) {
            n = input.read(this.bytes, this.begin + read2, length2 - read2);
            if (n != -1) continue;
            if (read2 != 0) break;
            throw new EOFException();
        }
        this.realSize += read2;
        return this;
    }

    public void append(ByteBuffer buffer, int len) {
        this.grow(len);
        buffer.get(this.bytes, this.realSize, len);
        this.realSize += len;
    }

    public Object clone() {
        return this.dup();
    }

    public ByteList dup() {
        ByteList dup2 = this.dup(this.realSize);
        dup2.validHash = this.validHash;
        dup2.hash = this.hash;
        dup2.stringValue = this.stringValue;
        return dup2;
    }

    public ByteList dup(int length2) {
        ByteList dup2 = new ByteList(false);
        dup2.bytes = new byte[length2];
        int newRealSize = Math.min(length2, this.realSize);
        System.arraycopy(this.bytes, this.begin, dup2.bytes, 0, newRealSize);
        dup2.realSize = newRealSize;
        dup2.begin = 0;
        return dup2;
    }

    public void ensure(int length2) {
        if (length2 >= this.bytes.length) {
            byte[] tmp = new byte[length2 + (length2 >>> 1)];
            System.arraycopy(this.bytes, this.begin, tmp, 0, this.realSize);
            this.bytes = tmp;
        }
    }

    public ByteList makeShared(int index2, int len) {
        ByteList shared = new ByteList(false);
        shared.bytes = this.bytes;
        shared.realSize = len;
        shared.begin = this.begin + index2;
        return shared;
    }

    public void view(int index2, int len) {
        this.realSize = len;
        this.begin += index2;
    }

    public void unshare() {
        this.unshare(this.realSize);
    }

    public void unshare(int length2) {
        byte[] tmp = new byte[length2];
        System.arraycopy(this.bytes, this.begin, tmp, 0, this.realSize);
        this.bytes = tmp;
        this.begin = 0;
    }

    public void invalidate() {
        this.validHash = false;
        this.stringValue = null;
    }

    public void prepend(byte b) {
        this.grow(1);
        System.arraycopy(this.bytes, 0, this.bytes, 1, this.realSize);
        this.bytes[0] = b;
        ++this.realSize;
    }

    public void append(byte[] moreBytes) {
        this.grow(moreBytes.length);
        System.arraycopy(moreBytes, 0, this.bytes, this.realSize, moreBytes.length);
        this.realSize += moreBytes.length;
    }

    public void append(ByteList moreBytes) {
        this.append(moreBytes.bytes, moreBytes.begin, moreBytes.realSize);
    }

    public void append(ByteList moreBytes, int index2, int len) {
        this.append(moreBytes.bytes, moreBytes.begin + index2, len);
    }

    public void append(byte[] moreBytes, int start2, int len) {
        this.grow(len);
        System.arraycopy(moreBytes, start2, this.bytes, this.realSize, len);
        this.realSize += len;
    }

    public void realloc(int length2) {
        byte[] tmp = new byte[length2];
        System.arraycopy(this.bytes, 0, tmp, 0, this.realSize);
        this.bytes = tmp;
    }

    public int length() {
        return this.realSize;
    }

    public void length(int newLength) {
        this.grow(newLength - this.realSize);
        this.realSize = newLength;
    }

    public int get(int index2) {
        if (index2 >= this.realSize) {
            throw new IndexOutOfBoundsException();
        }
        return this.bytes[this.begin + index2];
    }

    public void set(int index2, int b) {
        if (index2 >= this.realSize) {
            throw new IndexOutOfBoundsException();
        }
        this.bytes[this.begin + index2] = (byte)b;
    }

    public void replace(byte[] newBytes) {
        if (newBytes == null) {
            throw new NullPointerException("Invalid argument: replacing with null array");
        }
        this.bytes = newBytes;
        this.realSize = newBytes.length;
    }

    public void unsafeReplace(int beg, int len, ByteList nbytes) {
        this.unsafeReplace(beg, len, nbytes.bytes, nbytes.begin, nbytes.realSize);
    }

    public void unsafeReplace(int beg, int len, byte[] buf) {
        this.unsafeReplace(beg, len, buf, 0, buf.length);
    }

    public void unsafeReplace(int beg, int len, byte[] nbytes, int index2, int count2) {
        this.grow(count2 - len);
        int newSize = this.realSize + count2 - len;
        System.arraycopy(this.bytes, beg + len, this.bytes, beg + count2, this.realSize - (len + beg));
        System.arraycopy(nbytes, index2, this.bytes, beg, count2);
        this.realSize = newSize;
    }

    public void replace(int beg, int len, ByteList nbytes) {
        this.replace(beg, len, nbytes.bytes, nbytes.begin, nbytes.realSize);
    }

    public void replace(int beg, int len, byte[] buf) {
        this.replace(beg, len, buf, 0, buf.length);
    }

    public void replace(int beg, int len, byte[] nbytes, int index2, int count2) {
        if (len - beg > this.realSize) {
            throw new IndexOutOfBoundsException();
        }
        this.unsafeReplace(beg, len, nbytes, index2, count2);
    }

    public void insert(int index2, int b) {
        if (index2 >= this.realSize) {
            throw new IndexOutOfBoundsException();
        }
        this.grow(1);
        System.arraycopy(this.bytes, index2, this.bytes, index2 + 1, this.realSize - index2);
        this.bytes[index2] = (byte)b;
        ++this.realSize;
    }

    public int indexOf(int c) {
        return this.indexOf(c, 0);
    }

    public int indexOf(int c, int pos2) {
        if (c > 255) {
            return -1;
        }
        byte b = (byte)(c & 0xFF);
        int size2 = this.begin + this.realSize;
        byte[] buf = this.bytes;
        pos2 += this.begin;
        while (pos2 < size2 && buf[pos2] != b) {
            ++pos2;
        }
        return pos2 < size2 ? pos2 - this.begin : -1;
    }

    public int indexOf(ByteList find) {
        return this.indexOf(find, 0);
    }

    public int indexOf(ByteList find, int i) {
        return ByteList.indexOf(this.bytes, this.begin, this.realSize, find.bytes, find.begin, find.realSize, i);
    }

    static int indexOf(byte[] source2, int sourceOffset, int sourceCount, byte[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        byte first2 = target[targetOffset];
        int max2 = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max2; ++i) {
            if (source2[i] != first2) {
                while (++i <= max2 && source2[i] != first2) {
                }
            }
            if (i > max2) continue;
            int j = i + 1;
            int end2 = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end2 && source2[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end2) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    public int lastIndexOf(int c) {
        return this.lastIndexOf(c, this.realSize - 1);
    }

    public int lastIndexOf(int c, int pos2) {
        if (c > 255) {
            return -1;
        }
        byte b = (byte)(c & 0xFF);
        int size2 = this.begin + this.realSize;
        byte[] buf = this.bytes;
        pos2 = (pos2 += this.begin) >= size2 ? size2 : ++pos2;
        while (--pos2 >= this.begin && buf[pos2] != b) {
        }
        return pos2 - this.begin;
    }

    public int lastIndexOf(ByteList find) {
        return this.lastIndexOf(find, this.realSize);
    }

    public int lastIndexOf(ByteList find, int pos2) {
        return ByteList.lastIndexOf(this.bytes, this.begin, this.realSize, find.bytes, find.begin, find.realSize, pos2);
    }

    static int lastIndexOf(byte[] source2, int sourceOffset, int sourceCount, byte[] target, int targetOffset, int targetCount, int fromIndex) {
        int start2;
        int rightIndex = sourceCount - targetCount;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        int strLastIndex = targetOffset + targetCount - 1;
        byte strLastChar = target[strLastIndex];
        int min2 = sourceOffset + targetCount - 1;
        int i = min2 + fromIndex;
        block0: while (true) {
            if (i >= min2 && source2[i] != strLastChar) {
                --i;
                continue;
            }
            if (i < min2) {
                return -1;
            }
            int j = i - 1;
            start2 = j - (targetCount - 1);
            int k = strLastIndex - 1;
            while (j > start2) {
                if (source2[j--] == target[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start2 - sourceOffset + 1;
    }

    public boolean startsWith(ByteList other, int toffset) {
        byte[] ta = this.bytes;
        int to = this.begin + toffset;
        byte[] pa = other.bytes;
        int po = other.begin;
        int pc = other.realSize;
        while (--pc >= 0) {
            if (ta[to++] == pa[po++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(ByteList other) {
        return this.startsWith(other, 0);
    }

    public boolean endsWith(ByteList other) {
        return this.startsWith(other, this.realSize - other.realSize);
    }

    public boolean equals(Object other) {
        if (other instanceof ByteList) {
            return this.equal((ByteList)other);
        }
        return false;
    }

    public boolean equal(ByteList other) {
        if (other == this) {
            return true;
        }
        if (this.validHash && other.validHash && this.hash != other.hash) {
            return false;
        }
        int last2 = this.realSize;
        if (last2 == other.realSize) {
            byte[] buf = this.bytes;
            int first2 = -1;
            while (--last2 > first2 && buf[this.begin + last2] == other.bytes[other.begin + last2] && ++first2 < last2 && buf[this.begin + first2] == other.bytes[other.begin + first2]) {
            }
            return first2 >= last2;
        }
        return false;
    }

    public boolean sample_equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ByteList) {
            ByteList b = (ByteList)other;
            int size2 = this.realSize;
            if (size2 == b.realSize) {
                byte[] buf = this.bytes;
                int first2 = -1;
                int last2 = size2 + 1 & 0xFFFFFFFE;
                while ((last2 -= 2) >= 0 && buf[this.begin + last2] == b.bytes[b.begin + last2] && (first2 += 2) < size2 && buf[this.begin + first2] == b.bytes[b.begin + first2]) {
                }
                return last2 < 0 || first2 == size2;
            }
        }
        return false;
    }

    public int compareTo(Object other) {
        return this.cmp((ByteList)other);
    }

    public int cmp(ByteList other) {
        if (other == this) {
            return 0;
        }
        int size2 = this.realSize;
        int len = Math.min(size2, other.realSize);
        int offset2 = -1;
        while (++offset2 < len && this.bytes[this.begin + offset2] == other.bytes[other.begin + offset2]) {
        }
        if (offset2 < len) {
            return (this.bytes[this.begin + offset2] & 0xFF) > (other.bytes[other.begin + offset2] & 0xFF) ? 1 : -1;
        }
        return size2 == other.realSize ? 0 : (size2 == len ? -1 : 1);
    }

    public int caseInsensitiveCmp(ByteList other) {
        if (other == this) {
            return 0;
        }
        int size2 = this.realSize;
        int len = Math.min(size2, other.realSize);
        int other_begin = other.begin;
        byte[] other_bytes = other.bytes;
        int offset2 = -1;
        while (++offset2 < len) {
            char myCharIgnoreCase = caseTable[this.bytes[this.begin + offset2] & 0xFF];
            char otherCharIgnoreCase = caseTable[other_bytes[other_begin + offset2] & 0xFF];
            if (myCharIgnoreCase < otherCharIgnoreCase) {
                return -1;
            }
            if (myCharIgnoreCase <= otherCharIgnoreCase) continue;
            return 1;
        }
        return size2 == other.realSize ? 0 : (size2 == len ? -1 : 1);
    }

    public byte[] unsafeBytes() {
        return this.bytes;
    }

    public byte[] bytes() {
        byte[] newBytes = new byte[this.realSize];
        System.arraycopy(this.bytes, this.begin, newBytes, 0, this.realSize);
        return newBytes;
    }

    public int begin() {
        return this.begin;
    }

    private void grow(int increaseRequested) {
        if (increaseRequested < 0) {
            return;
        }
        int newSize = this.realSize + increaseRequested;
        if (this.bytes.length < newSize) {
            byte[] newBytes = new byte[(int)((double)newSize * 1.5)];
            if (this.bytes.length != 0) {
                System.arraycopy(this.bytes, 0, newBytes, 0, this.realSize);
            }
            this.bytes = newBytes;
        }
    }

    public int hashCode() {
        if (this.validHash) {
            return this.hash;
        }
        int key = 0;
        int index2 = this.begin;
        int end2 = this.begin + this.realSize;
        while (index2 < end2) {
            key = (key << 16) + (key << 6) - key + this.bytes[index2++];
        }
        key += key >> 5;
        this.validHash = true;
        this.hash = key;
        return this.hash;
    }

    public String toString() {
        try {
            if (this.stringValue == null) {
                this.stringValue = new String(this.bytes, this.begin, this.realSize, "ISO-8859-1");
            }
            return this.stringValue;
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("ISO-8859-1 encoding should never fail; report this at www.jruby.org");
        }
    }

    public static ByteList create(CharSequence s) {
        return new ByteList(ByteList.plain(s), false);
    }

    public static byte[] plain(CharSequence s) {
        if (s instanceof String) {
            try {
                return ((String)s).getBytes("ISO8859-1");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        byte[] bytes = new byte[s.length()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)s.charAt(i);
        }
        return bytes;
    }

    public static byte[] plain(char[] s) {
        byte[] bytes = new byte[s.length];
        for (int i = 0; i < s.length; ++i) {
            bytes[i] = (byte)s[i];
        }
        return bytes;
    }

    public static char[] plain(byte[] b, int start2, int length2) {
        char[] chars = new char[length2];
        for (int i = 0; i < length2; ++i) {
            chars[i] = (char)(b[start2 + i] & 0xFF);
        }
        return chars;
    }

    public static char[] plain(byte[] b) {
        char[] chars = new char[b.length];
        for (int i = 0; i < b.length; ++i) {
            chars[i] = (char)(b[i] & 0xFF);
        }
        return chars;
    }

    public char charAt(int ix) {
        return (char)(this.bytes[this.begin + ix] & 0xFF);
    }

    public CharSequence subSequence(int start2, int end2) {
        return new ByteList(this, start2, end2 - start2);
    }

    public static int memcmp(byte[] first2, int firstStart, int firstLen, byte[] second, int secondStart, int secondLen) {
        if (first2 == second) {
            return 0;
        }
        int len = Math.min(firstLen, secondLen);
        int offset2 = -1;
        while (++offset2 < len && first2[firstStart + offset2] == second[secondStart + offset2]) {
        }
        if (offset2 < len) {
            return (first2[firstStart + offset2] & 0xFF) > (second[secondStart + offset2] & 0xFF) ? 1 : -1;
        }
        return firstLen == secondLen ? 0 : (firstLen == len ? -1 : 1);
    }

    public static int memcmp(byte[] first2, int firstStart, byte[] second, int secondStart, int len) {
        if (first2 == second) {
            return 0;
        }
        int offset2 = -1;
        while (++offset2 < len && first2[firstStart + offset2] == second[secondStart + offset2]) {
        }
        if (offset2 < len) {
            return (first2[firstStart + offset2] & 0xFF) > (second[secondStart + offset2] & 0xFF) ? 1 : -1;
        }
        return 0;
    }
}

