/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.scope;

import org.jruby.RubyArray;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;

public class ManyVarsDynamicScope
extends DynamicScope {
    private IRubyObject[] variableValues;

    public ManyVarsDynamicScope(StaticScope staticScope, DynamicScope parent) {
        super(staticScope, parent);
        this.allocate();
    }

    public ManyVarsDynamicScope(StaticScope staticScope) {
        super(staticScope);
        this.allocate();
    }

    private void allocate() {
        if (this.variableValues == null) {
            int size2 = this.staticScope.getNumberOfVariables();
            this.variableValues = new IRubyObject[size2];
        }
    }

    public DynamicScope cloneScope() {
        return new ManyVarsDynamicScope(this.staticScope, this.parent);
    }

    public IRubyObject[] getValues() {
        return this.variableValues;
    }

    public IRubyObject getValue(int offset2, int depth) {
        if (depth > 0) {
            return this.parent.getValue(offset2, depth - 1);
        }
        this.assertGetValue(offset2, depth);
        return this.variableValues[offset2];
    }

    public IRubyObject getValueOrNil(int offset2, int depth, IRubyObject nil) {
        if (depth > 0) {
            return this.parent.getValueOrNil(offset2, depth - 1, nil);
        }
        return this.getValueDepthZeroOrNil(offset2, nil);
    }

    public IRubyObject getValueDepthZeroOrNil(int offset2, IRubyObject nil) {
        this.assertGetValueDepthZeroOrNil(offset2);
        IRubyObject value2 = this.variableValues[offset2];
        if (value2 == null) {
            return this.setValueDepthZero(value2, offset2);
        }
        return value2;
    }

    public IRubyObject getValueZeroDepthZeroOrNil(IRubyObject nil) {
        this.assertGetValueZeroDepthZeroOrNil();
        IRubyObject value2 = this.variableValues[0];
        if (value2 == null) {
            return this.setValueZeroDepthZero(value2);
        }
        return value2;
    }

    public IRubyObject getValueOneDepthZeroOrNil(IRubyObject nil) {
        this.assertGetValueOneDepthZeroOrNil();
        IRubyObject value2 = this.variableValues[1];
        if (value2 == null) {
            return this.setValueOneDepthZero(value2);
        }
        return value2;
    }

    public IRubyObject getValueTwoDepthZeroOrNil(IRubyObject nil) {
        this.assertGetValueTwoDepthZeroOrNil();
        IRubyObject value2 = this.variableValues[2];
        if (value2 == null) {
            return this.setValueTwoDepthZero(value2);
        }
        return value2;
    }

    public IRubyObject getValueThreeDepthZeroOrNil(IRubyObject nil) {
        this.assertGetValueThreeDepthZeroOrNil();
        IRubyObject value2 = this.variableValues[3];
        if (value2 == null) {
            return this.setValueThreeDepthZero(value2);
        }
        return value2;
    }

    public IRubyObject setValue(int offset2, IRubyObject value2, int depth) {
        if (depth > 0) {
            this.assertParent();
            return this.parent.setValue(offset2, value2, depth - 1);
        }
        this.assertSetValue(offset2, value2);
        return this.setValueDepthZero(value2, offset2);
    }

    public IRubyObject setValueDepthZero(IRubyObject value2, int offset2) {
        this.assertSetValueDepthZero(offset2, value2);
        this.variableValues[offset2] = value2;
        return this.variableValues[offset2];
    }

    public IRubyObject setValueZeroDepthZero(IRubyObject value2) {
        this.assertSetValueZeroDepthZero(value2);
        this.variableValues[0] = value2;
        return this.variableValues[0];
    }

    public IRubyObject setValueOneDepthZero(IRubyObject value2) {
        this.assertSetValueOneDepthZero(value2);
        this.variableValues[1] = value2;
        return this.variableValues[1];
    }

    public IRubyObject setValueTwoDepthZero(IRubyObject value2) {
        this.assertSetValueTwoDepthZero(value2);
        this.variableValues[2] = value2;
        return this.variableValues[2];
    }

    public IRubyObject setValueThreeDepthZero(IRubyObject value2) {
        this.assertSetValueThreeDepthZero(value2);
        this.variableValues[3] = value2;
        return this.variableValues[3];
    }

    public void setArgValues(IRubyObject[] values, int size2) {
        System.arraycopy(values, 0, this.variableValues, 0, size2);
    }

    public void setArgValues(IRubyObject arg0) {
        this.variableValues[0] = arg0;
    }

    public void setArgValues(IRubyObject arg0, IRubyObject arg1) {
        this.variableValues[0] = arg0;
        this.variableValues[1] = arg1;
    }

    public void setArgValues(IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        this.variableValues[0] = arg0;
        this.variableValues[1] = arg1;
        this.variableValues[2] = arg2;
    }

    public IRubyObject[] getArgValues() {
        if (!this.staticScope.isArgumentScope()) {
            return this.parent.getArgValues();
        }
        int totalArgs = this.staticScope.getRequiredArgs() + this.staticScope.getOptionalArgs();
        if (this.staticScope.getRestArg() < 0) {
            IRubyObject[] argValues = new IRubyObject[totalArgs];
            System.arraycopy(this.variableValues, 0, argValues, 0, totalArgs);
            return argValues;
        }
        IRubyObject restArg = this.getValue(this.staticScope.getRestArg(), 0);
        assert (restArg != null);
        RubyArray splattedArgs = RuntimeHelpers.splatValue(restArg);
        IRubyObject[] argValues = new IRubyObject[totalArgs + splattedArgs.size()];
        System.arraycopy(this.variableValues, 0, argValues, 0, totalArgs);
        System.arraycopy(splattedArgs.toJavaArray(), 0, argValues, totalArgs, splattedArgs.size());
        return argValues;
    }

    public void growIfNeeded() {
        int dynamicSize;
        int n = dynamicSize = this.variableValues == null ? 0 : this.variableValues.length;
        if (this.staticScope.getNumberOfVariables() > dynamicSize) {
            IRubyObject[] values = new IRubyObject[this.staticScope.getNumberOfVariables()];
            if (dynamicSize > 0) {
                System.arraycopy(this.variableValues, 0, values, 0, dynamicSize);
            }
            this.variableValues = values;
        }
    }

    public String toString(StringBuffer buf, String indent) {
        buf.append(indent).append("Static Type[" + this.hashCode() + "]: " + (this.staticScope instanceof BlockStaticScope ? "block" : "local") + " [");
        int size2 = this.staticScope.getNumberOfVariables();
        if (size2 != 0) {
            String[] names2 = this.staticScope.getVariables();
            for (int i = 0; i < size2 - 1; ++i) {
                buf.append(names2[i]).append("=");
                if (this.variableValues[i] == null) {
                    buf.append("null");
                } else {
                    buf.append(this.variableValues[i]);
                }
                buf.append(",");
            }
            buf.append(names2[size2 - 1]).append("=");
            assert (this.variableValues.length == names2.length) : "V: " + this.variableValues.length + " != N: " + names2.length + " for " + buf;
            if (this.variableValues[size2 - 1] == null) {
                buf.append("null");
            } else {
                buf.append(this.variableValues[size2 - 1]);
            }
        }
        buf.append("]");
        if (this.parent != null) {
            buf.append("\n");
            this.parent.toString(buf, indent + "  ");
        }
        return buf.toString();
    }

    private void assertGetValue(int offset2, int depth) {
        IRubyObject[] values = this.variableValues;
        assert (values != null && offset2 < values.length) : "No variables or index to big for getValue off: " + offset2 + ", Dep: " + depth + ", O: " + this;
    }

    private void assertGetValueDepthZeroOrNil(int offset2) {
        IRubyObject[] values = this.variableValues;
        assert (values != null && offset2 < values.length) : "No variables or index too big for getValue off: " + offset2 + ", Dep: " + 0 + ", O: " + this;
    }

    private void assertGetValueZeroDepthZeroOrNil() {
        IRubyObject[] values = this.variableValues;
        assert (values != null && 0 < values.length) : "No variables or index to big for getValue off: 0, Dep: 0, O: " + this;
    }

    private void assertGetValueOneDepthZeroOrNil() {
        IRubyObject[] values = this.variableValues;
        assert (values != null && 1 < values.length) : "No variables or index to big for getValue off: 1, Dep: 0, O: " + this;
    }

    private void assertGetValueTwoDepthZeroOrNil() {
        IRubyObject[] values = this.variableValues;
        assert (values != null && 3 < values.length) : "No variables or index to big for getValue off: 3, Dep: 0, O: " + this;
    }

    private void assertGetValueThreeDepthZeroOrNil() {
        IRubyObject[] values = this.variableValues;
        assert (values != null && 2 < values.length) : "No variables or index to big for getValue off: 2, Dep: 0, O: " + this;
    }

    private void assertParent() {
        assert (this.parent != null) : "If depth > 0, then parent should not ever be null";
    }

    private void assertSetValue(int offset2, IRubyObject value2) {
        assert (offset2 < this.variableValues.length) : "Setting " + offset2 + " to " + value2 + ", O: " + this;
    }

    private void assertSetValueDepthZero(int offset2, IRubyObject value2) {
        assert (offset2 < this.variableValues.length) : "Setting " + offset2 + " to " + value2 + ", O: " + this;
    }

    private void assertSetValueZeroDepthZero(IRubyObject value2) {
        assert (0 < this.variableValues.length) : "Setting 0 to " + value2 + ", O: " + this;
    }

    private void assertSetValueOneDepthZero(IRubyObject value2) {
        assert (1 < this.variableValues.length) : "Setting 1 to " + value2 + ", O: " + this;
    }

    private void assertSetValueThreeDepthZero(IRubyObject value2) {
        assert (3 < this.variableValues.length) : "Setting 3 to " + value2 + ", O: " + this;
    }

    private void assertSetValueTwoDepthZero(IRubyObject value2) {
        assert (2 < this.variableValues.length) : "Setting 2 to " + value2 + ", O: " + this;
    }
}

