/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jna;

import com.sun.jna.Function;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ext.ffi.Invoker;
import org.jruby.ext.ffi.jna.CallbackMarshaller;
import org.jruby.ext.ffi.jna.CallbackMethodWithBlock;
import org.jruby.ext.ffi.jna.DynamicMethodOneArg;
import org.jruby.ext.ffi.jna.DynamicMethodThreeArg;
import org.jruby.ext.ffi.jna.DynamicMethodTwoArg;
import org.jruby.ext.ffi.jna.DynamicMethodZeroArg;
import org.jruby.ext.ffi.jna.FunctionInvoker;
import org.jruby.ext.ffi.jna.Invocation;
import org.jruby.ext.ffi.jna.Marshaller;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

final class JNAInvoker
extends Invoker {
    private final Function function;
    private final FunctionInvoker functionInvoker;
    private final Marshaller[] marshallers;

    public JNAInvoker(Ruby runtime2, Function function, FunctionInvoker functionInvoker, Marshaller[] marshallers) {
        super(runtime2, marshallers.length);
        this.function = function;
        this.functionInvoker = functionInvoker;
        this.marshallers = marshallers;
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject[] rubyArgs) {
        Object[] args2 = new Object[rubyArgs.length];
        Invocation invocation = new Invocation();
        for (int i = 0; i < args2.length; ++i) {
            args2[i] = this.marshallers[i].marshal(invocation, rubyArgs[i]);
        }
        IRubyObject retVal = this.functionInvoker.invoke(context.getRuntime(), this.function, args2);
        invocation.finish();
        return retVal;
    }

    public DynamicMethod createDynamicMethod(RubyModule module) {
        if (this.marshallers.length > 0) {
            int cbcount = 0;
            int cbindex = -1;
            for (int i = 0; i < this.marshallers.length; ++i) {
                if (!(this.marshallers[i] instanceof CallbackMarshaller)) continue;
                ++cbcount;
                cbindex = i;
            }
            if (cbcount == 1) {
                return new CallbackMethodWithBlock(module, this.function, this.functionInvoker, this.marshallers, cbindex);
            }
        }
        if (Arity.NO_ARGUMENTS.equals(this.arity)) {
            return new DynamicMethodZeroArg(module, this.function, this.functionInvoker);
        }
        if (Arity.ONE_ARGUMENT.equals(this.arity)) {
            return new DynamicMethodOneArg(module, this.function, this.functionInvoker, this.marshallers);
        }
        if (Arity.TWO_ARGUMENTS.equals(this.arity)) {
            return new DynamicMethodTwoArg(module, this.function, this.functionInvoker, this.marshallers);
        }
        if (Arity.THREE_ARGUMENTS.equals(this.arity)) {
            return new DynamicMethodThreeArg(module, this.function, this.functionInvoker, this.marshallers);
        }
        return super.createDynamicMethod(module);
    }
}

