/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashNode
extends Node {
    private final ListNode listNode;

    public HashNode(ISourcePosition position, ListNode listNode) {
        super(position, NodeType.HASHNODE);
        this.listNode = listNode;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitHashNode(this);
    }

    public ListNode getListNode() {
        return this.listNode;
    }

    @Override
    public List<Node> childNodes() {
        return HashNode.createList(this.listNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        RubyHash hash2 = RubyHash.newHash(runtime2);
        ListNode listNode = this.listNode;
        if (listNode != null) {
            int size2 = listNode.size();
            int i = 0;
            while (i < size2) {
                IRubyObject key = listNode.get(i++).interpret(runtime2, context, self, aBlock);
                IRubyObject value2 = listNode.get(i++).interpret(runtime2, context, self, aBlock);
                hash2.fastASet(key, value2);
            }
        }
        return hash2;
    }
}

