/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Binding"})
public class RubyBinding
extends RubyObject {
    private Binding binding;
    private static ObjectAllocator BINDING_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            RubyBinding instance = new RubyBinding(runtime2, klass);
            return instance;
        }
    };

    public RubyBinding(Ruby runtime2, RubyClass rubyClass, Binding binding2) {
        super(runtime2, rubyClass);
        this.binding = binding2;
    }

    private RubyBinding(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    public static RubyClass createBindingClass(Ruby runtime2) {
        RubyClass bindingClass = runtime2.defineClass("Binding", runtime2.getObject(), BINDING_ALLOCATOR);
        runtime2.setBinding(bindingClass);
        bindingClass.defineAnnotatedMethods(RubyBinding.class);
        return bindingClass;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public static RubyBinding newBinding(Ruby runtime2, Binding binding2) {
        return new RubyBinding(runtime2, runtime2.getBinding(), binding2);
    }

    public static RubyBinding newBinding(Ruby runtime2) {
        ThreadContext context = runtime2.getCurrentContext();
        Frame frame = context.getCurrentFrame();
        Binding binding2 = new Binding(frame, context.getImmediateBindingRubyClass(), context.getCurrentScope());
        return new RubyBinding(runtime2, runtime2.getBinding(), binding2);
    }

    public static RubyBinding newBindingForEval(ThreadContext context) {
        Frame previousFrame = context.getPreviousFrame();
        Frame currentFrame = context.getCurrentFrame();
        currentFrame.setKlazz(previousFrame.getKlazz());
        Binding binding2 = new Binding(previousFrame, context.getEvalBindingRubyClass(), context.getCurrentScope());
        Ruby runtime2 = context.getRuntime();
        return new RubyBinding(runtime2, runtime2.getBinding(), binding2);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context) {
        Frame frame = context.getCurrentFrame();
        this.binding = new Binding(frame, context.getImmediateBindingRubyClass(), context.getCurrentScope());
        return this;
    }

    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject other) {
        RubyBinding otherBinding = (RubyBinding)other;
        this.binding = otherBinding.binding;
        return this;
    }
}

