/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings;

import org.jcodings.AbstractEncoding;
import org.jcodings.IntHolder;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.exception.EncodingException;
import org.jcodings.exception.IllegalCharacterException;

public abstract class MultiByteEncoding
extends AbstractEncoding {
    protected final int[] EncLen;
    protected static final int A = -1;
    protected static final int F = -2;
    protected final int[][] Trans;
    protected final int[] TransZero;

    protected MultiByteEncoding(int minLength, int maxLength, int[] EncLen, int[][] Trans, short[] CTypeTable) {
        super(minLength, maxLength, CTypeTable);
        this.EncLen = EncLen;
        this.Trans = Trans;
        this.TransZero = Trans != null ? Trans[0] : null;
    }

    public int length(byte c) {
        return this.EncLen[c & 0xFF];
    }

    protected final int safeLengthForUptoFour(byte[] bytes, int p2, int end2) {
        int b = bytes[p2] & 0xFF;
        int s = this.TransZero[b];
        if (s < 0) {
            if (s == -1) {
                return 1;
            }
            throw IllegalCharacterException.INSTANCE;
        }
        return this.lengthForTwoUptoFour(bytes, p2, end2, b, s);
    }

    private int lengthForTwoUptoFour(byte[] bytes, int p2, int end2, int b, int s) {
        if (++p2 == end2) {
            return -(this.EncLen[b] - 1);
        }
        if ((s = this.Trans[s][bytes[p2] & 0xFF]) < 0) {
            if (s == -1) {
                return 2;
            }
            throw IllegalCharacterException.INSTANCE;
        }
        return this.lengthForThreeUptoFour(bytes, p2, end2, b, s);
    }

    private int lengthForThreeUptoFour(byte[] bytes, int p2, int end2, int b, int s) {
        if (++p2 == end2) {
            return -(this.EncLen[b] - 2);
        }
        if ((s = this.Trans[s][bytes[p2] & 0xFF]) < 0) {
            if (s == -1) {
                return 3;
            }
            throw IllegalCharacterException.INSTANCE;
        }
        if (++p2 == end2) {
            return -(this.EncLen[b] - 3);
        }
        if ((s = this.Trans[s][bytes[p2] & 0xFF]) == -1) {
            return 4;
        }
        throw IllegalCharacterException.INSTANCE;
    }

    protected final int safeLengthForUptoThree(byte[] bytes, int p2, int end2) {
        int b = bytes[p2] & 0xFF;
        int s = this.TransZero[b];
        if (s < 0) {
            if (s == -1) {
                return 1;
            }
            throw IllegalCharacterException.INSTANCE;
        }
        return this.lengthForTwoUptoThree(bytes, p2, end2, b, s);
    }

    private int lengthForTwoUptoThree(byte[] bytes, int p2, int end2, int b, int s) {
        if (++p2 == end2) {
            return -(this.EncLen[b] - 1);
        }
        if ((s = this.Trans[s][bytes[p2] & 0xFF]) < 0) {
            if (s == -1) {
                return 2;
            }
            throw IllegalCharacterException.INSTANCE;
        }
        return this.lengthForThree(bytes, p2, end2, b, s);
    }

    private int lengthForThree(byte[] bytes, int p2, int end2, int b, int s) {
        if (++p2 == end2) {
            return -(this.EncLen[b] - 2);
        }
        if ((s = this.Trans[s][bytes[p2] & 0xFF]) == -1) {
            return 3;
        }
        throw IllegalCharacterException.INSTANCE;
    }

    protected final int safeLengthForUptoTwo(byte[] bytes, int p2, int end2) {
        int b = bytes[p2] & 0xFF;
        int s = this.TransZero[b];
        if (s < 0) {
            if (s == -1) {
                return 1;
            }
            throw IllegalCharacterException.INSTANCE;
        }
        return this.lengthForTwo(bytes, p2, end2, b, s);
    }

    private int lengthForTwo(byte[] bytes, int p2, int end2, int b, int s) {
        if (++p2 == end2) {
            return -(this.EncLen[b] - 1);
        }
        if ((s = this.Trans[s][bytes[p2] & 0xFF]) == -1) {
            return 2;
        }
        throw IllegalCharacterException.INSTANCE;
    }

    protected final int mbnMbcToCode(byte[] bytes, int p2, int end2) {
        int len = this.length(bytes, p2, end2);
        int n = bytes[p2++] & 0xFF;
        if (len == 1) {
            return n;
        }
        for (int i = 1; i < len && p2 < end2; ++i) {
            int c = bytes[p2++] & 0xFF;
            n <<= 8;
            n += c;
        }
        return n;
    }

    protected final int mbnMbcCaseFold(int flag, byte[] bytes, IntHolder pp, int end2, byte[] lower) {
        int p2 = pp.value++;
        int lowerP = 0;
        if (MultiByteEncoding.isAscii(bytes[p2] & 0xFF)) {
            lower[lowerP] = AsciiTables.ToLowerCaseTable[bytes[p2] & 0xFF];
            return 1;
        }
        int len = this.length(bytes, p2, end2);
        for (int i = 0; i < len; ++i) {
            lower[lowerP++] = bytes[p2++];
        }
        pp.value += len;
        return len;
    }

    protected final int mb2CodeToMbcLength(int code) {
        return (code & 0xFF00) != 0 ? 2 : 1;
    }

    protected final int mb4CodeToMbcLength(int code) {
        if ((code & 0xFF000000) != 0) {
            return 4;
        }
        if ((code & 0xFF0000) != 0) {
            return 3;
        }
        if ((code & 0xFF00) != 0) {
            return 2;
        }
        return 1;
    }

    protected final int mb2CodeToMbc(int code, byte[] bytes, int p2) {
        int p_ = p2;
        if ((code & 0xFF00) != 0) {
            bytes[p_++] = (byte)(code >>> 8 & 0xFF);
        }
        bytes[p_++] = (byte)(code & 0xFF);
        if (this.length(bytes, p2, p_) != p_ - p2) {
            throw new EncodingException("invalid code point value");
        }
        return p_ - p2;
    }

    protected final int mb4CodeToMbc(int code, byte[] bytes, int p2) {
        int p_ = p2;
        if ((code & 0xFF000000) != 0) {
            bytes[p_++] = (byte)(code >>> 24 & 0xFF);
        }
        if ((code & 0xFF0000) != 0 || p_ != p2) {
            bytes[p_++] = (byte)(code >>> 16 & 0xFF);
        }
        if ((code & 0xFF00) != 0 || p_ != p2) {
            bytes[p_++] = (byte)(code >>> 8 & 0xFF);
        }
        bytes[p_++] = (byte)(code & 0xFF);
        if (this.length(bytes, p2, p_) != p_ - p2) {
            throw new EncodingException("invalid code point value");
        }
        return p_ - p2;
    }

    protected final boolean mb2IsCodeCType(int code, int ctype) {
        if (code < 128) {
            return this.isCodeCTypeInternal(code, ctype);
        }
        if (MultiByteEncoding.isWordGraphPrint(ctype)) {
            return this.codeToMbcLength(code) > 1;
        }
        return false;
    }

    protected final boolean mb4IsCodeCType(int code, int ctype) {
        return this.mb2IsCodeCType(code, ctype);
    }
}

