/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Main;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.ext.posix.util.FieldAccess;
import org.jruby.ext.posix.util.Platform;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.ModeFlags;

public class ShellLauncher {
    private static final boolean DEBUG = false;

    private static String[] getCurrentEnv(Ruby runtime2) {
        RubyHash hash2 = (RubyHash)runtime2.getObject().fastGetConstant("ENV");
        String[] ret = new String[hash2.size()];
        int i = 0;
        for (Map.Entry e : hash2.directEntrySet()) {
            ret[i] = e.getKey().toString() + "=" + e.getValue().toString();
            ++i;
        }
        return ret;
    }

    public static int runAndWait(Ruby runtime2, IRubyObject[] rawArgs) {
        return ShellLauncher.runAndWait(runtime2, rawArgs, runtime2.getOutputStream());
    }

    public static int execAndWait(Ruby runtime2, IRubyObject[] rawArgs) {
        String[] args2 = ShellLauncher.parseCommandLine(runtime2, rawArgs);
        if (ShellLauncher.shouldRunInProcess(runtime2, args2)) {
            try {
                int startIndex;
                File pwd = new File(runtime2.getCurrentDirectory());
                String command = args2[0];
                int n = startIndex = command.endsWith(".rb") ? 0 : 1;
                if (command.trim().endsWith("irb")) {
                    startIndex = 0;
                    args2[0] = runtime2.getJRubyHome() + File.separator + "bin" + File.separator + "jirb";
                }
                String[] newargs = new String[args2.length - startIndex];
                System.arraycopy(args2, startIndex, newargs, 0, newargs.length);
                ScriptThreadProcess ipScript = new ScriptThreadProcess(newargs, ShellLauncher.getCurrentEnv(runtime2), pwd, false);
                ipScript.start();
                return ipScript.waitFor();
            }
            catch (IOException e) {
                throw runtime2.newIOErrorFromException(e);
            }
            catch (InterruptedException e) {
                throw runtime2.newThreadError("unexpected interrupt");
            }
        }
        return ShellLauncher.runAndWait(runtime2, rawArgs);
    }

    public static int runAndWait(Ruby runtime2, IRubyObject[] rawArgs, OutputStream output) {
        PrintStream error = runtime2.getErrorStream();
        InputStream input = runtime2.getInputStream();
        try {
            Process aProcess = ShellLauncher.run(runtime2, rawArgs);
            ShellLauncher.handleStreams(aProcess, input, output, error);
            return aProcess.waitFor();
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
        catch (InterruptedException e) {
            throw runtime2.newThreadError("unexpected interrupt");
        }
    }

    public static Process run(Ruby runtime2, IRubyObject string2) throws IOException {
        return ShellLauncher.run(runtime2, new IRubyObject[]{string2});
    }

    public static POpenProcess popen(Ruby runtime2, IRubyObject string2, ModeFlags modes) throws IOException {
        String shell = ShellLauncher.getShell(runtime2);
        POpenProcess aProcess = null;
        Process childProcess = null;
        File pwd = new File(runtime2.getCurrentDirectory());
        String[] args2 = ShellLauncher.parseCommandLine(runtime2, new IRubyObject[]{string2});
        if (ShellLauncher.shouldRunInShell(shell, args2)) {
            String[] argArray = new String[3];
            String cmdline = string2.toString();
            argArray[0] = shell;
            argArray[1] = shell.endsWith("sh") ? "-c" : "/c";
            argArray[2] = cmdline;
            childProcess = Runtime.getRuntime().exec(argArray, ShellLauncher.getCurrentEnv(runtime2), pwd);
        } else {
            childProcess = Runtime.getRuntime().exec(args2, ShellLauncher.getCurrentEnv(runtime2), pwd);
        }
        aProcess = new POpenProcess(childProcess, runtime2, modes);
        return aProcess;
    }

    public static OutputStream unwrapBufferedStream(OutputStream filteredStream) {
        while (filteredStream instanceof FilterOutputStream) {
            try {
                filteredStream = (OutputStream)FieldAccess.getProtectedFieldValue(FilterOutputStream.class, "out", filteredStream);
            }
            catch (Exception e) {
                break;
            }
        }
        return filteredStream;
    }

    public static InputStream unwrapBufferedStream(InputStream filteredStream) {
        while (filteredStream instanceof FilterInputStream) {
            try {
                filteredStream = (InputStream)FieldAccess.getProtectedFieldValue(FilterInputStream.class, "in", filteredStream);
            }
            catch (Exception e) {
                break;
            }
        }
        return filteredStream;
    }

    public static Process run(Ruby runtime2, IRubyObject[] rawArgs) throws IOException {
        String shell = ShellLauncher.getShell(runtime2);
        Process aProcess = null;
        File pwd = new File(runtime2.getCurrentDirectory());
        String[] args2 = ShellLauncher.parseCommandLine(runtime2, rawArgs);
        if (ShellLauncher.shouldRunInProcess(runtime2, args2)) {
            int startIndex;
            String command = args2[0];
            int n = startIndex = command.endsWith(".rb") ? 0 : 1;
            if (command.trim().endsWith("irb")) {
                startIndex = 0;
                args2[0] = runtime2.getJRubyHome() + File.separator + "bin" + File.separator + "jirb";
            }
            String[] newargs = new String[args2.length - startIndex];
            System.arraycopy(args2, startIndex, newargs, 0, newargs.length);
            ScriptThreadProcess ipScript = new ScriptThreadProcess(newargs, ShellLauncher.getCurrentEnv(runtime2), pwd);
            ipScript.start();
            aProcess = ipScript;
        } else if (rawArgs.length == 1 && ShellLauncher.shouldRunInShell(shell, args2)) {
            String[] argArray = new String[3];
            String cmdline = rawArgs[0].toString();
            argArray[0] = shell;
            argArray[1] = shell.endsWith("sh") ? "-c" : "/c";
            argArray[2] = cmdline;
            aProcess = Runtime.getRuntime().exec(argArray, ShellLauncher.getCurrentEnv(runtime2), pwd);
        } else {
            aProcess = Runtime.getRuntime().exec(args2, ShellLauncher.getCurrentEnv(runtime2), pwd);
        }
        return aProcess;
    }

    private static void handleStreams(Process p2, InputStream in, OutputStream out, OutputStream err) throws IOException {
        InputStream pOut = p2.getInputStream();
        InputStream pErr = p2.getErrorStream();
        OutputStream pIn = p2.getOutputStream();
        StreamPumper t1 = new StreamPumper(pOut, out, false, Pumper.Slave.IN);
        StreamPumper t2 = new StreamPumper(pErr, err, false, Pumper.Slave.IN);
        StreamPumper t3 = new StreamPumper(in, pIn, true, Pumper.Slave.OUT);
        t1.start();
        t2.start();
        t3.start();
        try {
            t1.join();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        try {
            t2.join();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        t3.quit();
        try {
            err.flush();
        }
        catch (IOException io2) {
            // empty catch block
        }
        try {
            out.flush();
        }
        catch (IOException io3) {
            // empty catch block
        }
        try {
            pIn.close();
        }
        catch (IOException io4) {
            // empty catch block
        }
        try {
            pOut.close();
        }
        catch (IOException io5) {
            // empty catch block
        }
        try {
            pErr.close();
        }
        catch (IOException io6) {
            // empty catch block
        }
        try {
            t3.interrupt();
        }
        catch (SecurityException se) {
            // empty catch block
        }
    }

    private static String[] parseCommandLine(Ruby runtime2, IRubyObject[] rawArgs) {
        String[] args2;
        if (rawArgs.length == 1) {
            RubyArray parts = (RubyArray)runtime2.evalScriptlet("require 'jruby/path_helper'; JRuby::PathHelper").callMethod(runtime2.getCurrentContext(), "smart_split_command", rawArgs);
            args2 = new String[parts.getLength()];
            for (int i = 0; i < parts.getLength(); ++i) {
                args2[i] = parts.entry(i).toString();
            }
        } else {
            args2 = new String[rawArgs.length];
            for (int i = 0; i < rawArgs.length; ++i) {
                args2[i] = rawArgs[i].toString();
            }
        }
        return args2;
    }

    private static boolean shouldRunInProcess(Ruby runtime2, String[] commands) {
        if (!runtime2.getInstanceConfig().isRunRubyInProcess()) {
            return false;
        }
        for (int i = 0; i < commands.length; ++i) {
            String c = commands[i];
            if (c.trim().length() == 0) continue;
            char[] firstLast = new char[]{c.charAt(0), c.charAt(c.length() - 1)};
            for (int j = 0; j < firstLast.length; ++j) {
                switch (firstLast[j]) {
                    case '<': 
                    case '>': 
                    case '|': {
                        return false;
                    }
                }
            }
        }
        String command = commands[0];
        String[] slashDelimitedTokens = command.split("/");
        String finalToken = slashDelimitedTokens[slashDelimitedTokens.length - 1];
        int indexOfRuby = finalToken.indexOf("ruby");
        return indexOfRuby != -1 && indexOfRuby == finalToken.length() - 4 || finalToken.endsWith(".rb") || finalToken.endsWith("irb");
    }

    private static boolean shouldRunInShell(String shell, String[] args2) {
        return !Platform.IS_WINDOWS || shell != null && args2.length > 1 && !new File(args2[0]).exists();
    }

    private static String getShell(Ruby runtime2) {
        return runtime2.evalScriptlet("require 'rbconfig'; Config::CONFIG['SHELL']").toString();
    }

    private static class ChannelPumper
    extends Thread
    implements Pumper {
        private final FileChannel inChannel;
        private final FileChannel outChannel;
        private final Pumper.Slave slave;
        private volatile boolean quit;

        ChannelPumper(FileChannel inChannel, FileChannel outChannel, Pumper.Slave slave) {
            this.inChannel = inChannel;
            this.outChannel = outChannel;
            this.slave = slave;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            ByteBuffer buf = ByteBuffer.allocateDirect(1024);
            buf.clear();
            try {
                int read2;
                while (!this.quit && this.inChannel.isOpen() && this.outChannel.isOpen() && (read2 = this.inChannel.read(buf)) != -1) {
                    buf.flip();
                    this.outChannel.write(buf);
                    buf.clear();
                }
            }
            catch (Exception e) {
                switch (this.slave) {
                    case OUT: {
                        try {
                            this.outChannel.close();
                        }
                        catch (IOException ioe) {}
                        break;
                    }
                    case IN: {
                        try {
                            this.inChannel.close();
                            break;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                catch (Throwable throwable) {
                    switch (this.slave) {
                        case OUT: {
                            try {
                                this.outChannel.close();
                            }
                            catch (IOException ioe) {}
                            break;
                        }
                        case IN: {
                            try {
                                this.inChannel.close();
                                break;
                            }
                            catch (IOException ioe) {
                                // empty catch block
                            }
                        }
                    }
                    throw throwable;
                }
            }
            switch (this.slave) {
                case OUT: {
                    try {
                        this.outChannel.close();
                    }
                    catch (IOException ioe) {}
                    break;
                }
                case IN: {
                    try {
                        this.inChannel.close();
                        break;
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
            }
        }

        public void quit() {
            this.interrupt();
            this.quit = true;
        }
    }

    private static class StreamPumper
    extends Thread
    implements Pumper {
        private final InputStream in;
        private final OutputStream out;
        private final boolean onlyIfAvailable;
        private final Object waitLock = new Object();
        private final Pumper.Slave slave;
        private volatile boolean quit;

        StreamPumper(InputStream in, OutputStream out, boolean avail, Pumper.Slave slave) {
            this.in = in;
            this.out = out;
            this.onlyIfAvailable = avail;
            this.slave = slave;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            byte[] buf = new byte[1024];
            boolean hasReadSomething = false;
            try {
                while (!this.quit) {
                    int numRead;
                    if (this.onlyIfAvailable && !hasReadSomething) {
                        if (this.in.available() == 0) {
                            Object object = this.waitLock;
                            synchronized (object) {
                                this.waitLock.wait(10L);
                                continue;
                            }
                        }
                        hasReadSomething = true;
                    }
                    if ((numRead = this.in.read(buf)) == -1) {
                        break;
                    }
                    this.out.write(buf, 0, numRead);
                }
            }
            catch (Exception e) {
            }
            finally {
                if (this.onlyIfAvailable && this.slave == Pumper.Slave.OUT) {
                    try {
                        this.out.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void quit() {
            this.quit = true;
            Object object = this.waitLock;
            synchronized (object) {
                this.waitLock.notify();
            }
        }
    }

    private static interface Pumper
    extends Runnable {
        public void start();

        public void quit();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Slave {
            IN,
            OUT;

        }
    }

    public static class POpenProcess
    extends Process {
        private final Process child;
        private final Ruby runtime;
        private final ModeFlags modes;
        private final InputStream in;
        private final OutputStream out;
        private final FileChannel outChannel;
        private final FileChannel inChannel;
        private final Pumper readPumper;
        private final Pumper writePumper;

        public POpenProcess(Process child, Ruby runtime2, ModeFlags modes) {
            this.child = child;
            this.runtime = runtime2;
            this.modes = modes;
            if (modes.isWritable()) {
                this.out = ShellLauncher.unwrapBufferedStream(child.getOutputStream());
                this.outChannel = this.out instanceof FileOutputStream ? ((FileOutputStream)this.out).getChannel() : null;
                this.writePumper = null;
            } else {
                OutputStream childOut = ShellLauncher.unwrapBufferedStream(child.getOutputStream());
                FileChannel childOutChannel = null;
                if (childOut instanceof FileOutputStream) {
                    childOutChannel = ((FileOutputStream)childOut).getChannel();
                }
                InputStream parentIn = ShellLauncher.unwrapBufferedStream(runtime2.getIn());
                FileChannel parentInChannel = null;
                if (parentIn instanceof FileInputStream) {
                    parentInChannel = ((FileInputStream)parentIn).getChannel();
                }
                this.writePumper = parentInChannel != null && childOutChannel != null ? new ChannelPumper(parentInChannel, childOutChannel, Pumper.Slave.OUT) : new StreamPumper(parentIn, childOut, false, Pumper.Slave.OUT);
                this.writePumper.start();
                this.out = null;
                this.outChannel = null;
            }
            if (modes.isReadable()) {
                this.in = ShellLauncher.unwrapBufferedStream(child.getInputStream());
                this.inChannel = this.in instanceof FileInputStream ? ((FileInputStream)this.in).getChannel() : null;
                this.readPumper = null;
            } else {
                InputStream childIn = ShellLauncher.unwrapBufferedStream(child.getInputStream());
                FileChannel childInChannel = null;
                if (childIn instanceof FileInputStream) {
                    childInChannel = ((FileInputStream)childIn).getChannel();
                }
                OutputStream parentOut = ShellLauncher.unwrapBufferedStream(runtime2.getOut());
                FileChannel parentOutChannel = null;
                if (parentOut instanceof FileOutputStream) {
                    parentOutChannel = ((FileOutputStream)parentOut).getChannel();
                }
                this.readPumper = childInChannel != null && parentOutChannel != null ? new ChannelPumper(childInChannel, parentOutChannel, Pumper.Slave.IN) : new StreamPumper(childIn, parentOut, false, Pumper.Slave.IN);
                this.readPumper.start();
                this.in = null;
                this.inChannel = null;
            }
        }

        public OutputStream getOutputStream() {
            return this.out;
        }

        public InputStream getInputStream() {
            return this.in;
        }

        public InputStream getErrorStream() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public FileChannel getInput() {
            return this.inChannel;
        }

        public FileChannel getOutput() {
            return this.outChannel;
        }

        public int waitFor() throws InterruptedException {
            if (this.writePumper == null) {
                try {
                    this.out.close();
                }
                catch (IOException ioe) {}
            } else {
                this.writePumper.quit();
            }
            int result = this.child.waitFor();
            return result;
        }

        public int exitValue() {
            return this.child.exitValue();
        }

        public void destroy() {
            try {
                this.in.close();
                this.out.close();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            this.child.destroy();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScriptThreadProcess
    extends Process
    implements Runnable {
        private final String[] argArray;
        private final String[] env;
        private final File pwd;
        private final boolean pipedStreams;
        private final PipedInputStream processOutput;
        private final PipedInputStream processError;
        private final PipedOutputStream processInput;
        private RubyInstanceConfig config;
        private Thread processThread;
        private int result;

        public ScriptThreadProcess(String[] argArray, String[] env, File dir) {
            this(argArray, env, dir, true);
        }

        public ScriptThreadProcess(String[] argArray, String[] env, File dir, boolean pipedStreams) {
            this.argArray = argArray;
            this.env = env;
            this.pwd = dir;
            this.pipedStreams = pipedStreams;
            if (pipedStreams) {
                this.processOutput = new PipedInputStream();
                this.processError = new PipedInputStream();
                this.processInput = new PipedOutputStream();
            } else {
                this.processError = null;
                this.processOutput = null;
                this.processInput = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.result = new Main(this.config).run(this.argArray);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(this.config.getError());
                this.result = -1;
            }
            finally {
                this.config.getOutput().close();
                this.config.getError().close();
            }
        }

        private Map<String, String> environmentMap(String[] env) {
            HashMap<String, String> m = new HashMap<String, String>();
            for (int i = 0; i < env.length; ++i) {
                String[] kv = env[i].split("=", 2);
                m.put(kv[0], kv[1]);
            }
            return m;
        }

        public void start() throws IOException {
            this.config = new RubyInstanceConfig(){
                {
                    this.setEnvironment(ScriptThreadProcess.this.environmentMap(ScriptThreadProcess.this.env));
                    this.setCurrentDirectory(ScriptThreadProcess.this.pwd.toString());
                }
            };
            if (this.pipedStreams) {
                this.config.setInput(new PipedInputStream(this.processInput));
                this.config.setOutput(new PrintStream(new PipedOutputStream(this.processOutput)));
                this.config.setError(new PrintStream(new PipedOutputStream(this.processError)));
            }
            String procName = "piped";
            if (this.argArray.length > 0) {
                procName = this.argArray[0];
            }
            this.processThread = new Thread((Runnable)this, "ScriptThreadProcess: " + procName);
            this.processThread.setDaemon(true);
            this.processThread.start();
        }

        @Override
        public OutputStream getOutputStream() {
            return this.processInput;
        }

        @Override
        public InputStream getInputStream() {
            return this.processOutput;
        }

        @Override
        public InputStream getErrorStream() {
            return this.processError;
        }

        @Override
        public int waitFor() throws InterruptedException {
            this.processThread.join();
            return this.result;
        }

        @Override
        public int exitValue() {
            return this.result;
        }

        @Override
        public void destroy() {
            if (this.pipedStreams) {
                this.closeStreams();
            }
            this.processThread.interrupt();
        }

        private void closeStreams() {
            try {
                this.processInput.close();
            }
            catch (IOException io2) {
                // empty catch block
            }
            try {
                this.processOutput.close();
            }
            catch (IOException io3) {
                // empty catch block
            }
            try {
                this.processError.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

