/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JavaMethodDescriptor;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.ReflectedCompiledMethod;
import org.jruby.internal.runtime.methods.ReflectedJavaMethod;
import org.jruby.internal.runtime.methods.ReflectedJavaMultiMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionMethodFactory
extends MethodFactory {
    @Override
    public DynamicMethod getCompiledMethodLazily(RubyModule implementationClass, String methodName, Arity arity2, Visibility visibility, StaticScope scope, Object scriptObject, CallConfiguration callConfig) {
        return this.getCompiledMethod(implementationClass, methodName, arity2, visibility, scope, scriptObject, callConfig);
    }

    @Override
    public DynamicMethod getCompiledMethod(RubyModule implementationClass, String methodName, Arity arity2, Visibility visibility, StaticScope scope, Object scriptObject, CallConfiguration callConfig) {
        try {
            Method method2 = scriptObject.getClass().getMethod(methodName, COMPILED_METHOD_PARAMS);
            return new ReflectedCompiledMethod(implementationClass, arity2, visibility, scope, scriptObject, method2, callConfig);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException("No method with name " + methodName + " found in " + scriptObject.getClass());
        }
    }

    @Override
    public DynamicMethod getAnnotatedMethod(RubyModule implementationClass, JavaMethodDescriptor desc) {
        try {
            Method method2 = desc.getDeclaringClass().getDeclaredMethod(desc.name, desc.getParameterClasses());
            ReflectedJavaMethod ic = new ReflectedJavaMethod(implementationClass, method2, desc.anno);
            ic.setJavaName(method2.getName());
            ic.setSingleton(Modifier.isStatic(method2.getModifiers()));
            ic.setCallConfig(CallConfiguration.getCallConfigByAnno(desc.anno));
            return ic;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DynamicMethod getAnnotatedMethod(RubyModule implementationClass, List<JavaMethodDescriptor> descs) {
        try {
            ArrayList<Method> methods2 = new ArrayList<Method>();
            ArrayList<JRubyMethod> annotations2 = new ArrayList<JRubyMethod>();
            for (JavaMethodDescriptor desc : descs) {
                methods2.add(desc.getDeclaringClass().getDeclaredMethod(desc.name, desc.getParameterClasses()));
                annotations2.add(desc.anno);
            }
            Method method0 = (Method)methods2.get(0);
            JRubyMethod anno0 = (JRubyMethod)annotations2.get(0);
            ReflectedJavaMultiMethod ic = new ReflectedJavaMultiMethod(implementationClass, methods2, annotations2);
            ic.setJavaName(method0.getName());
            ic.setSingleton(Modifier.isStatic(method0.getModifiers()));
            ic.setCallConfig(CallConfiguration.getCallConfigByAnno(anno0));
            return ic;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Deprecated
    public void defineIndexedAnnotatedMethods(RubyModule implementationClass, Class type2, MethodFactory.MethodDefiningCallback callback) {
        Method[] methods2;
        for (Method method2 : methods2 = type2.getDeclaredMethods()) {
            JRubyMethod jrubyMethod = method2.getAnnotation(JRubyMethod.class);
            if (jrubyMethod == null) continue;
            callback.define(implementationClass, new JavaMethodDescriptor(method2), this.getAnnotatedMethod(implementationClass, new JavaMethodDescriptor(method2)));
        }
    }
}

