/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.RubyIPSocket;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;

@JRubyClass(name={"UDPSocket"}, parent="IPSocket")
public class RubyUDPSocket
extends RubyIPSocket {
    private static ObjectAllocator UDPSOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyUDPSocket(runtime2, klass);
        }
    };

    static void createUDPSocket(Ruby runtime2) {
        RubyClass rb_cUDPSocket = runtime2.defineClass("UDPSocket", runtime2.fastGetClass("IPSocket"), UDPSOCKET_ALLOCATOR);
        rb_cUDPSocket.includeModule(runtime2.fastGetClass("Socket").fastGetConstant("Constants"));
        rb_cUDPSocket.defineAnnotatedMethods(RubyUDPSocket.class);
        runtime2.getObject().fastSetConstant("UDPsocket", rb_cUDPSocket);
    }

    public RubyUDPSocket(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize() {
        try {
            DatagramChannel channel = DatagramChannel.open();
            this.initSocket(new ChannelDescriptor(channel, RubyIO.getNewFileno(), new ModeFlags(2L), new FileDescriptor()));
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (ConnectException e) {
            throw this.getRuntime().newErrnoECONNREFUSEDError();
        }
        catch (UnknownHostException e) {
            throw RubyUDPSocket.sockerr(this, "initialize: name or service not known");
        }
        catch (IOException e) {
            throw RubyUDPSocket.sockerr(this, "initialize: name or service not known");
        }
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject protocol) {
        return this.initialize();
    }

    public IRubyObject setsockopt(IRubyObject[] args2) {
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject bind(IRubyObject host, IRubyObject port) {
        InetSocketAddress addr2 = null;
        try {
            addr2 = host.isNil() ? new InetSocketAddress(RubyNumeric.fix2int(port)) : new InetSocketAddress(InetAddress.getByName(host.convertToString().toString()), RubyNumeric.fix2int(port));
            ((DatagramChannel)this.getChannel()).socket().bind(addr2);
            return RubyFixnum.zero(this.getRuntime());
        }
        catch (UnknownHostException e) {
            throw RubyUDPSocket.sockerr(this, "bind: name or service not known");
        }
        catch (SocketException e) {
            throw RubyUDPSocket.sockerr(this, "bind: name or service not known");
        }
        catch (Error e) {
            if (e.getCause() instanceof SocketException) {
                throw RubyUDPSocket.sockerr(this, "bind: name or service not known");
            }
            throw e;
        }
    }

    @JRubyMethod
    public IRubyObject connect(IRubyObject host, IRubyObject port) {
        try {
            InetSocketAddress addr2 = new InetSocketAddress(InetAddress.getByName(host.convertToString().toString()), RubyNumeric.fix2int(port));
            ((DatagramChannel)this.getChannel()).connect(addr2);
            return RubyFixnum.zero(this.getRuntime());
        }
        catch (UnknownHostException e) {
            throw RubyUDPSocket.sockerr(this, "connect: name or service not known");
        }
        catch (IOException e) {
            throw RubyUDPSocket.sockerr(this, "connect: name or service not known");
        }
    }

    public IRubyObject recvfrom(IRubyObject[] args2) {
        return this.recvfrom(this.getRuntime().getCurrentContext(), args2);
    }

    @JRubyMethod(required=1, rest=true)
    public IRubyObject recvfrom(ThreadContext context, IRubyObject[] args2) {
        try {
            int length2 = RubyNumeric.fix2int(args2[0]);
            ByteBuffer buf = ByteBuffer.allocate(length2);
            ((DatagramChannel)this.getChannel()).configureBlocking(false);
            context.getThread().select(this, 1);
            InetSocketAddress sender = (InetSocketAddress)((DatagramChannel)this.getChannel()).receive(buf);
            RubyArray addressArray = this.getRuntime().newArray(new IRubyObject[]{this.getRuntime().newString("AF_INET"), this.getRuntime().newFixnum(sender.getPort()), this.getRuntime().newString(sender.getHostName()), this.getRuntime().newString(sender.getAddress().getHostAddress())});
            RubyString result = this.getRuntime().newString(new ByteList(buf.array(), 0, buf.position()));
            return this.getRuntime().newArray(new IRubyObject[]{result, addressArray});
        }
        catch (UnknownHostException e) {
            throw RubyUDPSocket.sockerr(this, "recvfrom: name or service not known");
        }
        catch (IOException e) {
            throw RubyUDPSocket.sockerr(this, "recvfrom: name or service not known");
        }
    }

    public IRubyObject recv(IRubyObject[] args2) {
        try {
            int length2 = RubyNumeric.fix2int(args2[0]);
            ByteBuffer buf = ByteBuffer.allocate(length2);
            ((DatagramChannel)this.getChannel()).receive(buf);
            return this.getRuntime().newString(new ByteList(buf.array(), 0, buf.position()));
        }
        catch (IOException e) {
            throw RubyUDPSocket.sockerr(this, "recv: name or service not known");
        }
    }

    @JRubyMethod(required=1, rest=true)
    public IRubyObject send(IRubyObject[] args2) {
        try {
            if (args2.length >= 3) {
                InetSocketAddress addr2 = new InetSocketAddress(InetAddress.getByName(args2[2].convertToString().toString()), RubyNumeric.fix2int(args2[3]));
                RubyString data = args2[0].convertToString();
                ByteBuffer buf = ByteBuffer.wrap(data.getBytes());
                ((DatagramChannel)this.getChannel()).send(buf, addr2);
                return data.length();
            }
            RubyString data = args2[0].convertToString();
            ByteBuffer buf = ByteBuffer.wrap(data.getBytes());
            ((DatagramChannel)this.getChannel()).write(buf);
            return data.length();
        }
        catch (UnknownHostException e) {
            throw RubyUDPSocket.sockerr(this, "send: name or service not known");
        }
        catch (IOException e) {
            throw RubyUDPSocket.sockerr(this, "send: name or service not known");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(rest=true, frame=true, meta=true)
    public static IRubyObject open(IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyUDPSocket sock = (RubyUDPSocket)recv2.callMethod(recv2.getRuntime().getCurrentContext(), "new", args2);
        if (!block.isGiven()) {
            return sock;
        }
        try {
            IRubyObject iRubyObject = block.yield(recv2.getRuntime().getCurrentContext(), sock);
            return iRubyObject;
        }
        finally {
            if (sock.openFile.isOpen()) {
                sock.close();
            }
        }
    }
}

