/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import com.sun.jna.FromNativeContext;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.jruby.ext.posix.DefaultNativeGroup;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.Group;
import org.jruby.ext.posix.JavaLibCHelper;
import org.jruby.ext.posix.LibC;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXHandler;
import org.jruby.ext.posix.Passwd;

public abstract class BaseNativePOSIX
implements POSIX {
    protected String libraryName;
    protected LibC libc;
    protected POSIXHandler handler;
    protected JavaLibCHelper helper;
    public static final PointerConverter GROUP = new PointerConverter(){

        public Object fromNative(Object arg2, FromNativeContext ctx) {
            return new DefaultNativeGroup((Pointer)arg2);
        }
    };

    public BaseNativePOSIX(String libraryName, LibC libc, POSIXHandler handler) {
        this.libc = libc;
        this.handler = handler;
        this.libraryName = libraryName;
        this.helper = new JavaLibCHelper(handler);
    }

    public int chmod(String filename2, int mode2) {
        return this.libc.chmod(filename2, mode2);
    }

    public int chown(String filename2, int user, int group2) {
        return this.libc.chown(filename2, user, group2);
    }

    public FileStat fstat(FileDescriptor fileDescriptor) {
        FileStat stat2 = this.allocateStat();
        int fd = this.helper.getfd(fileDescriptor);
        if (this.libc.fstat(fd, stat2) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, "" + fd);
        }
        return stat2;
    }

    public int getegid() {
        return this.libc.getegid();
    }

    public int geteuid() {
        return this.libc.geteuid();
    }

    public int getgid() {
        return this.libc.getgid();
    }

    public String getlogin() {
        return this.libc.getlogin();
    }

    public int getpgid() {
        return this.libc.getpgid();
    }

    public int getpgrp() {
        return this.libc.getpgrp();
    }

    public int getpid() {
        return this.libc.getpid();
    }

    public int getppid() {
        return this.libc.getppid();
    }

    public Passwd getpwent() {
        return this.libc.getpwent();
    }

    public Passwd getpwuid(int which) {
        return this.libc.getpwuid(which);
    }

    public Passwd getpwnam(String which) {
        return this.libc.getpwnam(which);
    }

    public Group getgrent() {
        return this.libc.getgrent();
    }

    public Group getgrgid(int which) {
        return this.libc.getgrgid(which);
    }

    public Group getgrnam(String which) {
        return this.libc.getgrnam(which);
    }

    public int setpwent() {
        return this.libc.setpwent();
    }

    public int endpwent() {
        return this.libc.endpwent();
    }

    public int setgrent() {
        return this.libc.setgrent();
    }

    public int endgrent() {
        return this.libc.endgrent();
    }

    public int getuid() {
        return this.libc.getuid();
    }

    public int setegid(int egid2) {
        return this.libc.setegid(egid2);
    }

    public int seteuid(int euid2) {
        return this.libc.seteuid(euid2);
    }

    public int setgid(int gid2) {
        return this.libc.setgid(gid2);
    }

    public int getfd(FileDescriptor descriptor) {
        return this.helper.getfd(descriptor);
    }

    public int getpgid(int pid2) {
        return this.libc.getpgid(pid2);
    }

    public int setpgid(int pid2, int pgid) {
        return this.libc.setpgid(pid2, pgid);
    }

    public int setpgrp(int pid2, int pgrp) {
        return this.libc.setpgrp(pid2, pgrp);
    }

    public int setsid() {
        return this.libc.setsid();
    }

    public int setuid(int uid2) {
        return this.libc.setuid(uid2);
    }

    public int kill(int pid2, int signal2) {
        return this.libc.kill(pid2, signal2);
    }

    public int lchmod(String filename2, int mode2) {
        return this.libc.lchmod(filename2, mode2);
    }

    public int lchown(String filename2, int user, int group2) {
        return this.libc.lchown(filename2, user, group2);
    }

    public int link(String oldpath, String newpath) {
        return this.libc.link(oldpath, newpath);
    }

    public FileStat lstat(String path2) {
        FileStat stat2 = this.allocateStat();
        if (this.libc.lstat(path2, stat2) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, path2);
        }
        return stat2;
    }

    public int mkdir(String path2, int mode2) {
        return this.libc.mkdir(path2, mode2);
    }

    public FileStat stat(String path2) {
        FileStat stat2 = this.allocateStat();
        if (this.libc.stat(path2, stat2) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, path2);
        }
        return stat2;
    }

    public int symlink(String oldpath, String newpath) {
        return this.libc.symlink(oldpath, newpath);
    }

    public String readlink(String oldpath) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        int result = this.libc.readlink(oldpath, buffer, buffer.capacity());
        if (result == -1) {
            return null;
        }
        buffer.position(0);
        buffer.limit(result);
        return Charset.forName("ASCII").decode(buffer).toString();
    }

    public int umask(int mask) {
        return this.libc.umask(mask);
    }

    public int fork() {
        return this.libc.fork();
    }

    public int waitpid(int pid2, int[] status2, int flags) {
        return this.libc.waitpid(pid2, status2, pid2);
    }

    public int wait(int[] status2) {
        return this.libc.wait(status2);
    }

    public int getpriority(int which, int who) {
        return this.libc.getpriority(which, who);
    }

    public int setpriority(int which, int who, int prio) {
        return this.libc.setpriority(which, who, prio);
    }

    public boolean isatty(FileDescriptor fd) {
        return this.libc.isatty(this.helper.getfd(fd)) != 0;
    }

    public abstract FileStat allocateStat();

    protected boolean hasMethod(String name2) {
        try {
            NativeLibrary.getInstance(this.libraryName).getFunction(name2);
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
        return true;
    }

    public static abstract class PointerConverter
    implements FromNativeConverter {
        public Class nativeType() {
            return Pointer.class;
        }
    }
}

