/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.impl.HeapBasedVariableCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.parser.StaticScope;

public class BoxedVariableCompiler
extends HeapBasedVariableCompiler {
    private int baseVariableIndex;

    public BoxedVariableCompiler(StandardASMCompiler.AbstractMethodCompiler methodCompiler, SkinnyMethodAdapter method2, StaticScope scope, boolean specificArity, int argsIndex, int firstTempIndex) {
        super(methodCompiler, method2, scope, specificArity, argsIndex, firstTempIndex);
        this.baseVariableIndex = firstTempIndex;
    }

    public void beginMethod(CompilerCallback argsCallback, StaticScope scope) {
        this.scope = scope;
        if (scope != null && scope.getNumberOfVariables() > 0) {
            this.methodCompiler.loadNil();
            for (int i = 0; i < scope.getNumberOfVariables(); ++i) {
                if (scope.isCaptured(i)) continue;
                this.assignLocalVariable(i);
                ++this.tempVariableIndex;
            }
            this.method.pop();
        }
        super.beginMethod(argsCallback, scope);
    }

    public void beginClass(CompilerCallback bodyPrep, StaticScope scope) {
        assert (false) : "Do not use boxed var compiler for class bodies";
    }

    public void beginClosure(CompilerCallback argsCallback, StaticScope scope) {
        this.scope = scope;
        if (scope != null) {
            this.methodCompiler.loadNil();
            for (int i = 0; i < scope.getNumberOfVariables(); ++i) {
                if (scope.isCaptured(i)) continue;
                this.assignLocalVariable(i);
                ++this.tempVariableIndex;
            }
            this.method.pop();
        }
        super.beginClosure(argsCallback, scope);
    }

    public void assignLocalVariable(int index2) {
        if (this.scope.isCaptured(index2)) {
            super.assignLocalVariable(index2);
        } else {
            this.method.dup();
            this.method.astore(this.baseVariableIndex + index2);
        }
    }

    public void retrieveLocalVariable(int index2) {
        if (this.scope.isCaptured(index2)) {
            super.retrieveLocalVariable(index2);
        } else {
            this.method.aload(this.baseVariableIndex + index2);
        }
    }
}

