/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import java.util.Iterator;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyMatchData;
import org.jruby.ast.AliasNode;
import org.jruby.ast.AndNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BinaryOperatorNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.BreakNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DSymbolNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DXStrNode;
import org.jruby.ast.DefinedNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EnsureNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.NotNode;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpAsgnOrNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.PostExeNode;
import org.jruby.ast.PreExeNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.RescueNode;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StarNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.ToAryNode;
import org.jruby.ast.UndefNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.VAliasNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.XStrNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.ArgumentsCallback;
import org.jruby.compiler.ArrayCallback;
import org.jruby.compiler.BranchCallback;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.MethodCompiler;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.ScriptCompiler;
import org.jruby.compiler.YARVNodesCompiler;
import org.jruby.exceptions.JumpException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CallType;
import org.jruby.runtime.builtin.IRubyObject;

public class ASTCompiler {
    private boolean isAtRoot = true;

    public void compile(Node node, MethodCompiler context) {
        if (node == null) {
            context.loadNil();
            return;
        }
        switch (node.nodeId) {
            case ALIASNODE: {
                this.compileAlias(node, context);
                break;
            }
            case ANDNODE: {
                this.compileAnd(node, context);
                break;
            }
            case ARGSCATNODE: {
                this.compileArgsCat(node, context);
                break;
            }
            case ARGSPUSHNODE: {
                this.compileArgsPush(node, context);
                break;
            }
            case ARRAYNODE: {
                this.compileArray(node, context);
                break;
            }
            case ATTRASSIGNNODE: {
                this.compileAttrAssign(node, context);
                break;
            }
            case BACKREFNODE: {
                this.compileBackref(node, context);
                break;
            }
            case BEGINNODE: {
                this.compileBegin(node, context);
                break;
            }
            case BIGNUMNODE: {
                this.compileBignum(node, context);
                break;
            }
            case BLOCKNODE: {
                this.compileBlock(node, context);
                break;
            }
            case BREAKNODE: {
                this.compileBreak(node, context);
                break;
            }
            case CALLNODE: {
                this.compileCall(node, context);
                break;
            }
            case CASENODE: {
                this.compileCase(node, context);
                break;
            }
            case CLASSNODE: {
                this.compileClass(node, context);
                break;
            }
            case CLASSVARNODE: {
                this.compileClassVar(node, context);
                break;
            }
            case CLASSVARASGNNODE: {
                this.compileClassVarAsgn(node, context);
                break;
            }
            case CLASSVARDECLNODE: {
                this.compileClassVarDecl(node, context);
                break;
            }
            case COLON2NODE: {
                this.compileColon2(node, context);
                break;
            }
            case COLON3NODE: {
                this.compileColon3(node, context);
                break;
            }
            case CONSTDECLNODE: {
                this.compileConstDecl(node, context);
                break;
            }
            case CONSTNODE: {
                this.compileConst(node, context);
                break;
            }
            case DASGNNODE: {
                this.compileDAsgn(node, context);
                break;
            }
            case DEFINEDNODE: {
                this.compileDefined(node, context);
                break;
            }
            case DEFNNODE: {
                this.compileDefn(node, context);
                break;
            }
            case DEFSNODE: {
                this.compileDefs(node, context);
                break;
            }
            case DOTNODE: {
                this.compileDot(node, context);
                break;
            }
            case DREGEXPNODE: {
                this.compileDRegexp(node, context);
                break;
            }
            case DSTRNODE: {
                this.compileDStr(node, context);
                break;
            }
            case DSYMBOLNODE: {
                this.compileDSymbol(node, context);
                break;
            }
            case DVARNODE: {
                this.compileDVar(node, context);
                break;
            }
            case DXSTRNODE: {
                this.compileDXStr(node, context);
                break;
            }
            case ENSURENODE: {
                this.compileEnsureNode(node, context);
                break;
            }
            case EVSTRNODE: {
                this.compileEvStr(node, context);
                break;
            }
            case FALSENODE: {
                this.compileFalse(node, context);
                break;
            }
            case FCALLNODE: {
                this.compileFCall(node, context);
                break;
            }
            case FIXNUMNODE: {
                this.compileFixnum(node, context);
                break;
            }
            case FLIPNODE: {
                this.compileFlip(node, context);
                break;
            }
            case FLOATNODE: {
                this.compileFloat(node, context);
                break;
            }
            case FORNODE: {
                this.compileFor(node, context);
                break;
            }
            case GLOBALASGNNODE: {
                this.compileGlobalAsgn(node, context);
                break;
            }
            case GLOBALVARNODE: {
                this.compileGlobalVar(node, context);
                break;
            }
            case HASHNODE: {
                this.compileHash(node, context);
                break;
            }
            case IFNODE: {
                this.compileIf(node, context);
                break;
            }
            case INSTASGNNODE: {
                this.compileInstAsgn(node, context);
                break;
            }
            case INSTVARNODE: {
                this.compileInstVar(node, context);
                break;
            }
            case ITERNODE: {
                this.compileIter(node, context);
                break;
            }
            case LOCALASGNNODE: {
                this.compileLocalAsgn(node, context);
                break;
            }
            case LOCALVARNODE: {
                this.compileLocalVar(node, context);
                break;
            }
            case MATCH2NODE: {
                this.compileMatch2(node, context);
                break;
            }
            case MATCH3NODE: {
                this.compileMatch3(node, context);
                break;
            }
            case MATCHNODE: {
                this.compileMatch(node, context);
                break;
            }
            case MODULENODE: {
                this.compileModule(node, context);
                break;
            }
            case MULTIPLEASGNNODE: {
                this.compileMultipleAsgn(node, context);
                break;
            }
            case NEWLINENODE: {
                this.compileNewline(node, context);
                break;
            }
            case NEXTNODE: {
                this.compileNext(node, context);
                break;
            }
            case NTHREFNODE: {
                this.compileNthRef(node, context);
                break;
            }
            case NILNODE: {
                this.compileNil(node, context);
                break;
            }
            case NOTNODE: {
                this.compileNot(node, context);
                break;
            }
            case OPASGNANDNODE: {
                this.compileOpAsgnAnd(node, context);
                break;
            }
            case OPASGNNODE: {
                this.compileOpAsgn(node, context);
                break;
            }
            case OPASGNORNODE: {
                this.compileOpAsgnOr(node, context);
                break;
            }
            case OPELEMENTASGNNODE: {
                this.compileOpElementAsgn(node, context);
                break;
            }
            case ORNODE: {
                this.compileOr(node, context);
                break;
            }
            case POSTEXENODE: {
                this.compilePostExe(node, context);
                break;
            }
            case PREEXENODE: {
                this.compilePreExe(node, context);
                break;
            }
            case REDONODE: {
                this.compileRedo(node, context);
                break;
            }
            case REGEXPNODE: {
                this.compileRegexp(node, context);
                break;
            }
            case RESCUEBODYNODE: {
                throw new NotCompilableException("rescue body is handled by rescue compilation at: " + node.getPosition());
            }
            case RESCUENODE: {
                this.compileRescue(node, context);
                break;
            }
            case RETRYNODE: {
                this.compileRetry(node, context);
                break;
            }
            case RETURNNODE: {
                this.compileReturn(node, context);
                break;
            }
            case ROOTNODE: {
                throw new NotCompilableException("Use compileRoot(); Root node at: " + node.getPosition());
            }
            case SCLASSNODE: {
                this.compileSClass(node, context);
                break;
            }
            case SELFNODE: {
                this.compileSelf(node, context);
                break;
            }
            case SPLATNODE: {
                this.compileSplat(node, context);
                break;
            }
            case STRNODE: {
                this.compileStr(node, context);
                break;
            }
            case SUPERNODE: {
                this.compileSuper(node, context);
                break;
            }
            case SVALUENODE: {
                this.compileSValue(node, context);
                break;
            }
            case SYMBOLNODE: {
                this.compileSymbol(node, context);
                break;
            }
            case TOARYNODE: {
                this.compileToAry(node, context);
                break;
            }
            case TRUENODE: {
                this.compileTrue(node, context);
                break;
            }
            case UNDEFNODE: {
                this.compileUndef(node, context);
                break;
            }
            case UNTILNODE: {
                this.compileUntil(node, context);
                break;
            }
            case VALIASNODE: {
                this.compileVAlias(node, context);
                break;
            }
            case VCALLNODE: {
                this.compileVCall(node, context);
                break;
            }
            case WHILENODE: {
                this.compileWhile(node, context);
                break;
            }
            case WHENNODE: {
                assert (false) : "When nodes are handled by case node compilation.";
                break;
            }
            case XSTRNODE: {
                this.compileXStr(node, context);
                break;
            }
            case YIELDNODE: {
                this.compileYield(node, context);
                break;
            }
            case ZARRAYNODE: {
                this.compileZArray(node, context);
                break;
            }
            case ZSUPERNODE: {
                this.compileZSuper(node, context);
                break;
            }
            default: {
                assert (false) : "Unknown node encountered in compiler: " + node;
                break;
            }
        }
    }

    public void compileArguments(Node node, MethodCompiler context) {
        switch (node.nodeId) {
            case ARGSCATNODE: {
                this.compileArgsCatArguments(node, context);
                break;
            }
            case ARGSPUSHNODE: {
                this.compileArgsPushArguments(node, context);
                break;
            }
            case ARRAYNODE: {
                this.compileArrayArguments(node, context);
                break;
            }
            case SPLATNODE: {
                this.compileSplatArguments(node, context);
                break;
            }
            default: {
                this.compile(node, context);
                context.convertToJavaArray();
            }
        }
    }

    public ArgumentsCallback getArgsCallback(Node node) {
        if (node == null) {
            return null;
        }
        while (node.nodeId == NodeType.NEWLINENODE) {
            node = ((NewlineNode)node).getNextNode();
        }
        switch (node.nodeId) {
            case ARGSCATNODE: 
            case ARGSPUSHNODE: 
            case SPLATNODE: {
                return new VariableArityArguments(node);
            }
            case ARRAYNODE: {
                ArrayNode arrayNode = (ArrayNode)node;
                if (arrayNode.size() == 0) {
                    return null;
                }
                if (arrayNode.size() > 3) {
                    return new VariableArityArguments(node);
                }
                return new SpecificArityArguments(node);
            }
        }
        return new SpecificArityArguments(node);
    }

    public void compileAssignment(Node node, MethodCompiler context) {
        switch (node.nodeId) {
            case ATTRASSIGNNODE: {
                this.compileAttrAssignAssignment(node, context);
                break;
            }
            case DASGNNODE: {
                this.compileDAsgnAssignment(node, context);
                break;
            }
            case CLASSVARASGNNODE: {
                this.compileClassVarAsgnAssignment(node, context);
                break;
            }
            case CLASSVARDECLNODE: {
                this.compileClassVarDeclAssignment(node, context);
                break;
            }
            case CONSTDECLNODE: {
                this.compileConstDeclAssignment(node, context);
                break;
            }
            case GLOBALASGNNODE: {
                this.compileGlobalAsgnAssignment(node, context);
                break;
            }
            case INSTASGNNODE: {
                this.compileInstAsgnAssignment(node, context);
                break;
            }
            case LOCALASGNNODE: {
                this.compileLocalAsgnAssignment(node, context);
                break;
            }
            case MULTIPLEASGNNODE: {
                this.compileMultipleAsgnAssignment(node, context);
                break;
            }
            case ZEROARGNODE: {
                throw new NotCompilableException("Shouldn't get here; zeroarg does not do assignment: " + node);
            }
            default: {
                throw new NotCompilableException("Can't compile assignment node: " + node);
            }
        }
    }

    public static YARVNodesCompiler getYARVCompiler() {
        return new YARVNodesCompiler();
    }

    public void compileAlias(Node node, MethodCompiler context) {
        AliasNode alias = (AliasNode)node;
        context.defineAlias(alias.getNewName(), alias.getOldName());
    }

    public void compileAnd(Node node, MethodCompiler context) {
        final AndNode andNode = (AndNode)node;
        this.compile(andNode.getFirstNode(), context);
        BranchCallback longCallback = new BranchCallback(){

            public void branch(MethodCompiler context) {
                ASTCompiler.this.compile(andNode.getSecondNode(), context);
            }
        };
        context.performLogicalAnd(longCallback);
    }

    public void compileArray(Node node, MethodCompiler context) {
        ArrayNode arrayNode = (ArrayNode)node;
        ArrayCallback callback = new ArrayCallback(){

            public void nextValue(MethodCompiler context, Object sourceArray, int index2) {
                Node node = (Node)((Object[])sourceArray)[index2];
                ASTCompiler.this.compile(node, context);
            }
        };
        context.createNewArray(arrayNode.childNodes().toArray(), callback, arrayNode.isLightweight());
    }

    public void compileArgsCat(Node node, MethodCompiler context) {
        ArgsCatNode argsCatNode = (ArgsCatNode)node;
        this.compile(argsCatNode.getFirstNode(), context);
        context.ensureRubyArray();
        this.compile(argsCatNode.getSecondNode(), context);
        context.splatCurrentValue();
        context.concatArrays();
    }

    public void compileArgsPush(Node node, MethodCompiler context) {
        ArgsPushNode argsPush = (ArgsPushNode)node;
        this.compile(argsPush.getFirstNode(), context);
        this.compile(argsPush.getSecondNode(), context);
        context.concatArrays();
    }

    private void compileAttrAssign(Node node, MethodCompiler context) {
        final AttrAssignNode attrAssignNode = (AttrAssignNode)node;
        CompilerCallback receiverCallback = new CompilerCallback(){

            public void call(MethodCompiler context) {
                ASTCompiler.this.compile(attrAssignNode.getReceiverNode(), context);
            }
        };
        ArgumentsCallback argsCallback = this.getArgsCallback(attrAssignNode.getArgsNode());
        context.getInvocationCompiler().invokeAttrAssign(attrAssignNode.getName(), receiverCallback, argsCallback);
    }

    public void compileAttrAssignAssignment(Node node, MethodCompiler context) {
        AttrAssignNode attrAssignNode = (AttrAssignNode)node;
        this.compile(attrAssignNode.getReceiverNode(), context);
        context.swapValues();
        if (attrAssignNode.getArgsNode() != null) {
            this.compileArguments(attrAssignNode.getArgsNode(), context);
            context.swapValues();
            context.appendToObjectArray();
        } else {
            context.createObjectArray(1);
        }
        context.getInvocationCompiler().invokeAttrAssign(attrAssignNode.getName());
    }

    public void compileBackref(Node node, MethodCompiler context) {
        BackRefNode iVisited = (BackRefNode)node;
        context.performBackref(iVisited.getType());
    }

    public void compileBegin(Node node, MethodCompiler context) {
        BeginNode beginNode = (BeginNode)node;
        this.compile(beginNode.getBodyNode(), context);
    }

    public void compileBignum(Node node, MethodCompiler context) {
        context.createNewBignum(((BignumNode)node).getValue());
    }

    public void compileBlock(Node node, MethodCompiler context) {
        BlockNode blockNode = (BlockNode)node;
        Iterator<Node> iter = blockNode.childNodes().iterator();
        while (iter.hasNext()) {
            Node n = iter.next();
            this.compile(n, context);
            if (!iter.hasNext()) continue;
            context.consumeCurrentValue();
        }
    }

    public void compileBreak(Node node, MethodCompiler context) {
        final BreakNode breakNode = (BreakNode)node;
        CompilerCallback valueCallback = new CompilerCallback(){

            public void call(MethodCompiler context) {
                if (breakNode.getValueNode() != null) {
                    ASTCompiler.this.compile(breakNode.getValueNode(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        context.issueBreakEvent(valueCallback);
    }

    public void compileCall(Node node, MethodCompiler context) {
        final CallNode callNode = (CallNode)node;
        CompilerCallback receiverCallback = new CompilerCallback(){

            public void call(MethodCompiler context) {
                ASTCompiler.this.compile(callNode.getReceiverNode(), context);
            }
        };
        ArgumentsCallback argsCallback = this.getArgsCallback(callNode.getArgsNode());
        CompilerCallback closureArg = this.getBlock(callNode.getIterNode());
        context.getInvocationCompiler().invokeDynamic(callNode.getName(), receiverCallback, argsCallback, CallType.NORMAL, closureArg, callNode.getIterNode() instanceof IterNode);
    }

    public void compileCase(Node node, MethodCompiler context) {
        CaseNode caseNode = (CaseNode)node;
        boolean hasCase = false;
        if (caseNode.getCaseNode() != null) {
            this.compile(caseNode.getCaseNode(), context);
            hasCase = true;
        }
        context.pollThreadEvents();
        Node firstWhenNode = caseNode.getFirstWhenNode();
        this.compileWhen(firstWhenNode, context, hasCase);
    }

    public void compileWhen(Node node, MethodCompiler context, final boolean hasCase) {
        if (node == null) {
            if (hasCase) {
                context.consumeCurrentValue();
            }
            context.loadNil();
            return;
        }
        if (!(node instanceof WhenNode)) {
            if (hasCase) {
                context.consumeCurrentValue();
            }
            this.compile(node, context);
            return;
        }
        WhenNode whenNode = (WhenNode)node;
        if (whenNode.getExpressionNodes() instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)whenNode.getExpressionNodes();
            this.compileMultiArgWhen(whenNode, arrayNode, 0, context, hasCase);
        } else {
            if (hasCase) {
                context.duplicateCurrentValue();
            }
            this.compile(whenNode.getExpressionNodes(), context);
            final WhenNode currentWhen = whenNode;
            if (hasCase) {
                context.swapValues();
                context.getInvocationCompiler().invokeEqq();
            }
            BranchCallback trueBranch = new BranchCallback(){

                public void branch(MethodCompiler context) {
                    if (hasCase) {
                        context.consumeCurrentValue();
                    }
                    if (currentWhen.getBodyNode() != null) {
                        ASTCompiler.this.compile(currentWhen.getBodyNode(), context);
                    } else {
                        context.loadNil();
                    }
                }
            };
            BranchCallback falseBranch = new BranchCallback(){

                public void branch(MethodCompiler context) {
                    ASTCompiler.this.compileWhen(currentWhen.getNextCase(), context, hasCase);
                }
            };
            context.performBooleanBranch(trueBranch, falseBranch);
        }
    }

    public void compileMultiArgWhen(final WhenNode whenNode, final ArrayNode expressionsNode, final int conditionIndex, MethodCompiler context, final boolean hasCase) {
        if (conditionIndex >= expressionsNode.size()) {
            this.compileWhen(whenNode.getNextCase(), context, hasCase);
            return;
        }
        Node tag = expressionsNode.get(conditionIndex);
        context.setLinePosition(tag.getPosition());
        if (tag instanceof WhenNode) {
            if (hasCase) {
                context.duplicateCurrentValue();
            } else {
                context.loadNull();
            }
            this.compile(((WhenNode)tag).getExpressionNodes(), context);
            context.checkWhenWithSplat();
        } else {
            if (hasCase) {
                context.duplicateCurrentValue();
            }
            this.compile(tag, context);
            if (hasCase) {
                context.swapValues();
                context.getInvocationCompiler().invokeEqq();
            }
        }
        BranchCallback trueBranch = new BranchCallback(){

            public void branch(MethodCompiler context) {
                if (hasCase) {
                    context.consumeCurrentValue();
                }
                if (whenNode.getBodyNode() != null) {
                    ASTCompiler.this.compile(whenNode.getBodyNode(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        BranchCallback falseBranch = new BranchCallback(){

            public void branch(MethodCompiler context) {
                ASTCompiler.this.compileMultiArgWhen(whenNode, expressionsNode, conditionIndex + 1, context, hasCase);
            }
        };
        context.performBooleanBranch(trueBranch, falseBranch);
    }

    public void compileClass(Node node, MethodCompiler context) {
        final ClassNode classNode = (ClassNode)node;
        final Node superNode = classNode.getSuperNode();
        final Colon3Node cpathNode = classNode.getCPath();
        CompilerCallback superCallback = new CompilerCallback(){

            public void call(MethodCompiler context) {
                ASTCompiler.this.compile(superNode, context);
            }
        };
        if (superNode == null) {
            superCallback = null;
        }
        CompilerCallback bodyCallback = new CompilerCallback(){

            public void call(MethodCompiler context) {
                boolean oldIsAtRoot = ASTCompiler.this.isAtRoot;
                ASTCompiler.this.isAtRoot = false;
                if (classNode.getBodyNode() != null) {
                    ASTCompiler.this.compile(classNode.getBodyNode(), context);
                } else {
                    context.loadNil();
                }
                ASTCompiler.this.isAtRoot = oldIsAtRoot;
            }
        };
        CompilerCallback pathCallback = new CompilerCallback(){

            public void call(MethodCompiler context) {
                if (cpathNode instanceof Colon2Node) {
                    Node leftNode = ((Colon2Node)cpathNode).getLeftNode();
                    if (leftNode != null) {
                        ASTCompiler.this.compile(leftNode, context);
                    } else {
                        context.loadNil();
                    }
                } else if (cpathNode instanceof Colon3Node) {
                    context.loadObject();
                } else {
                    context.loadNil();
                }
            }
        };
        context.defineClass(classNode.getCPath().getName(), classNode.getScope(), superCallback, pathCallback, bodyCallback, null);
    }

    public void compileSClass(Node node, MethodCompiler context) {
        final SClassNode sclassNode = (SClassNode)node;
        CompilerCallback receiverCallback = new CompilerCallback(){

            public void call(MethodCompiler context) {
                ASTCompiler.this.compile(sclassNode.getReceiverNode(), context);
            }
        };
        CompilerCallback bodyCallback = new CompilerCallback(){

            public void call(MethodCompiler context) {
                boolean oldIsAtRoot = ASTCompiler.this.isAtRoot;
                ASTCompiler.this.isAtRoot = false;
                if (sclassNode.getBodyNode() != null) {
                    ASTCompiler.this.compile(sclassNode.getBodyNode(), context);
                } else {
                    context.loadNil();
                }
                ASTCompiler.this.isAtRoot = oldIsAtRoot;
            }
        };
        context.defineClass("SCLASS", sclassNode.getScope(), null, null, bodyCallback, receiverCallback);
    }

    public void compileClassVar(Node node, MethodCompiler context) {
        ClassVarNode classVarNode = (ClassVarNode)node;
        context.retrieveClassVariable(classVarNode.getName());
    }

    public void compileClassVarAsgn(Node node, MethodCompiler context) {
        final ClassVarAsgnNode classVarAsgnNode = (ClassVarAsgnNode)node;
        CompilerCallback value2 = new CompilerCallback(){

            public void call(MethodCompiler context) {
                ASTCompiler.this.compile(classVarAsgnNode.getValueNode(), context);
            }
        };
        context.assignClassVariable(classVarAsgnNode.getName(), value2);
    }

    public void compileClassVarAsgnAssignment(Node node, MethodCompiler context) {
        ClassVarAsgnNode classVarAsgnNode = (ClassVarAsgnNode)node;
        context.assignClassVariable(classVarAsgnNode.getName());
    }

    public void compileClassVarDecl(Node node, MethodCompiler context) {
        final ClassVarDeclNode classVarDeclNode = (ClassVarDeclNode)node;
        CompilerCallback value2 = new CompilerCallback(){

            public void call(MethodCompiler context) {
                ASTCompiler.this.compile(classVarDeclNode.getValueNode(), context);
            }
        };
        context.declareClassVariable(classVarDeclNode.getName(), value2);
    }

    public void compileClassVarDeclAssignment(Node node, MethodCompiler context) {
        ClassVarDeclNode classVarDeclNode = (ClassVarDeclNode)node;
        context.declareClassVariable(classVarDeclNode.getName());
    }

    public void compileConstDecl(Node node, MethodCompiler context) {
        ConstDeclNode constDeclNode = (ConstDeclNode)node;
        Node constNode = constDeclNode.getConstNode();
        if (constNode == null) {
            this.compile(constDeclNode.getValueNode(), context);
            context.assignConstantInCurrent(constDeclNode.getName());
        } else if (constNode.nodeId == NodeType.COLON2NODE) {
            this.compile(((Colon2Node)constNode).getLeftNode(), context);
            this.compile(constDeclNode.getValueNode(), context);
            context.assignConstantInModule(constDeclNode.getName());
        } else {
            this.compile(constDeclNode.getValueNode(), context);
            context.assignConstantInObject(constDeclNode.getName());
        }
    }

    public void compileConstDeclAssignment(Node node, MethodCompiler context) {
        ConstDeclNode constDeclNode = (ConstDeclNode)node;
        Node constNode = constDeclNode.getConstNode();
        if (constNode == null) {
            context.assignConstantInCurrent(constDeclNode.getName());
        } else if (constNode.nodeId == NodeType.COLON2NODE) {
            this.compile(((Colon2Node)constNode).getLeftNode(), context);
            context.swapValues();
            context.assignConstantInModule(constDeclNode.getName());
        } else {
            context.assignConstantInObject(constDeclNode.getName());
        }
    }

    public void compileConst(Node node, MethodCompiler context) {
        ConstNode constNode = (ConstNode)node;
        context.retrieveConstant(constNode.getName());
    }

    public void compileColon2(Node node, MethodCompiler context) {
        final Colon2Node iVisited = (Colon2Node)node;
        Node leftNode = iVisited.getLeftNode();
        final String name2 = iVisited.getName();
        if (leftNode == null) {
            context.loadObject();
            context.retrieveConstantFromModule(name2);
        } else {
            final CompilerCallback receiverCallback = new CompilerCallback(){

                public void call(MethodCompiler context) {
                    ASTCompiler.this.compile(iVisited.getLeftNode(), context);
                }
            };
            BranchCallback moduleCallback = new BranchCallback(){

                public void branch(MethodCompiler context) {
                    receiverCallback.call(context);
                    context.retrieveConstantFromModule(name2);
                }
            };
            BranchCallback notModuleCallback = new BranchCallback(){

                public void branch(MethodCompiler context) {
                    context.getInvocationCompiler().invokeDynamic(name2, receiverCallback, null, CallType.FUNCTIONAL, null, false);
                }
            };
            context.branchIfModule(receiverCallback, moduleCallback, notModuleCallback);
        }
    }

    public void compileColon3(Node node, MethodCompiler context) {
        Colon3Node iVisited = (Colon3Node)node;
        String name2 = iVisited.getName();
        context.loadObject();
        context.retrieveConstantFromModule(name2);
    }

    public void compileGetDefinitionBase(final Node node, MethodCompiler context) {
        BranchCallback reg = new BranchCallback(){

            public void branch(MethodCompiler context) {
                context.inDefined();
                ASTCompiler.this.compileGetDefinition(node, context);
            }
        };
        BranchCallback out = new BranchCallback(){

            public void branch(MethodCompiler context) {
                context.outDefined();
            }
        };
        context.protect(reg, out, String.class);
    }

    public void compileDefined(Node node, MethodCompiler context) {
        this.compileGetDefinitionBase(((DefinedNode)node).getExpressionNode(), context);
        context.stringOrNil();
    }

    public void compileGetArgumentDefinition(Node node, MethodCompiler context, String type2) {
        if (node == null) {
            context.pushString(type2);
        } else if (node instanceof ArrayNode) {
            Object endToken = context.getNewEnding();
            for (int i = 0; i < ((ArrayNode)node).size(); ++i) {
                Node iterNode = ((ArrayNode)node).get(i);
                this.compileGetDefinition(iterNode, context);
                context.ifNull(endToken);
            }
            context.pushString(type2);
            Object realToken = context.getNewEnding();
            context.go(realToken);
            context.setEnding(endToken);
            context.pushNull();
            context.setEnding(realToken);
        } else {
            this.compileGetDefinition(node, context);
            Object endToken = context.getNewEnding();
            context.ifNull(endToken);
            context.pushString(type2);
            Object realToken = context.getNewEnding();
            context.go(realToken);
            context.setEnding(endToken);
            context.pushNull();
            context.setEnding(realToken);
        }
    }

    public void compileGetDefinition(final Node node, MethodCompiler context) {
        switch (node.nodeId) {
            case CLASSVARASGNNODE: 
            case CLASSVARDECLNODE: 
            case CONSTDECLNODE: 
            case DASGNNODE: 
            case GLOBALASGNNODE: 
            case LOCALASGNNODE: 
            case MULTIPLEASGNNODE: 
            case OPASGNNODE: 
            case OPELEMENTASGNNODE: {
                context.pushString("assignment");
                break;
            }
            case BACKREFNODE: {
                context.backref();
                context.isInstanceOf(RubyMatchData.class, new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        context.pushString("$" + ((BackRefNode)node).getType());
                    }
                }, new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        context.pushNull();
                    }
                });
                break;
            }
            case DVARNODE: {
                context.pushString("local-variable(in-block)");
                break;
            }
            case FALSENODE: {
                context.pushString("false");
                break;
            }
            case TRUENODE: {
                context.pushString("true");
                break;
            }
            case LOCALVARNODE: {
                context.pushString("local-variable");
                break;
            }
            case MATCH2NODE: 
            case MATCH3NODE: {
                context.pushString("method");
                break;
            }
            case NILNODE: {
                context.pushString("nil");
                break;
            }
            case NTHREFNODE: {
                context.isCaptured(((NthRefNode)node).getMatchNumber(), new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        context.pushString("$" + ((NthRefNode)node).getMatchNumber());
                    }
                }, new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        context.pushNull();
                    }
                });
                break;
            }
            case SELFNODE: {
                context.pushString("self");
                break;
            }
            case VCALLNODE: {
                context.loadSelf();
                context.isMethodBound(((VCallNode)node).getName(), new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        context.pushString("method");
                    }
                }, new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        context.pushNull();
                    }
                });
                break;
            }
            case YIELDNODE: {
                context.hasBlock(new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        context.pushString("yield");
                    }
                }, new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        context.pushNull();
                    }
                });
                break;
            }
            case GLOBALVARNODE: {
                context.isGlobalDefined(((GlobalVarNode)node).getName(), new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        context.pushString("global-variable");
                    }
                }, new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        context.pushNull();
                    }
                });
                break;
            }
            case INSTVARNODE: {
                context.isInstanceVariableDefined(((InstVarNode)node).getName(), new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        context.pushString("instance-variable");
                    }
                }, new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        context.pushNull();
                    }
                });
                break;
            }
            case CONSTNODE: {
                context.isConstantDefined(((ConstNode)node).getName(), new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        context.pushString("constant");
                    }
                }, new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        context.pushNull();
                    }
                });
                break;
            }
            case FCALLNODE: {
                context.loadSelf();
                context.isMethodBound(((FCallNode)node).getName(), new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        ASTCompiler.this.compileGetArgumentDefinition(((FCallNode)node).getArgsNode(), context, "method");
                    }
                }, new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        context.pushNull();
                    }
                });
                break;
            }
            case COLON2NODE: 
            case COLON3NODE: {
                final Colon3Node iVisited = (Colon3Node)node;
                String name2 = iVisited.getName();
                BranchCallback setup = new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        if (iVisited instanceof Colon2Node) {
                            Node leftNode = ((Colon2Node)iVisited).getLeftNode();
                            ASTCompiler.this.compile(leftNode, context);
                        } else {
                            context.loadObject();
                        }
                    }
                };
                BranchCallback isConstant = new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        context.pushString("constant");
                    }
                };
                BranchCallback isMethod = new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        context.pushString("method");
                    }
                };
                BranchCallback none = new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        context.pushNull();
                    }
                };
                context.isConstantBranch(setup, isConstant, isMethod, none, name2);
                break;
            }
            case CALLNODE: {
                final CallNode iVisited = (CallNode)node;
                Object isnull = context.getNewEnding();
                Object ending = context.getNewEnding();
                this.compileGetDefinition(iVisited.getReceiverNode(), context);
                context.ifNull(isnull);
                context.rescue(new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        ASTCompiler.this.compile(iVisited.getReceiverNode(), context);
                        context.duplicateCurrentValue();
                        context.metaclass();
                        context.duplicateCurrentValue();
                        context.getVisibilityFor(iVisited.getName());
                        context.duplicateCurrentValue();
                        final Object isfalse = context.getNewEnding();
                        Object isreal = context.getNewEnding();
                        Object ending = context.getNewEnding();
                        context.isPrivate(isfalse, 3);
                        context.isNotProtected(isreal, 1);
                        context.selfIsKindOf(isreal);
                        context.consumeCurrentValue();
                        context.go(isfalse);
                        context.setEnding(isreal);
                        context.isMethodBound(iVisited.getName(), new BranchCallback(){

                            public void branch(MethodCompiler context) {
                                ASTCompiler.this.compileGetArgumentDefinition(iVisited.getArgsNode(), context, "method");
                            }
                        }, new BranchCallback(){

                            public void branch(MethodCompiler context) {
                                context.go(isfalse);
                            }
                        });
                        context.go(ending);
                        context.setEnding(isfalse);
                        context.pushNull();
                        context.setEnding(ending);
                    }
                }, JumpException.class, new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        context.pushNull();
                    }
                }, String.class);
                context.go(ending);
                context.setEnding(isnull);
                context.pushNull();
                context.setEnding(ending);
                break;
            }
            case CLASSVARNODE: {
                ClassVarNode iVisited = (ClassVarNode)node;
                final Object ending = context.getNewEnding();
                Object failure = context.getNewEnding();
                Object singleton = context.getNewEnding();
                Object second = context.getNewEnding();
                Object third = context.getNewEnding();
                context.loadCurrentModule();
                context.duplicateCurrentValue();
                context.ifNotNull(second);
                context.consumeCurrentValue();
                context.loadSelf();
                context.metaclass();
                context.duplicateCurrentValue();
                context.isClassVarDefined(iVisited.getName(), new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        context.consumeCurrentValue();
                        context.pushString("class variable");
                        context.go(ending);
                    }
                }, new BranchCallback(){

                    public void branch(MethodCompiler context) {
                    }
                });
                context.setEnding(second);
                context.duplicateCurrentValue();
                context.isClassVarDefined(iVisited.getName(), new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        context.consumeCurrentValue();
                        context.pushString("class variable");
                        context.go(ending);
                    }
                }, new BranchCallback(){

                    public void branch(MethodCompiler context) {
                    }
                });
                context.setEnding(third);
                context.duplicateCurrentValue();
                context.ifSingleton(singleton);
                context.consumeCurrentValue();
                context.go(failure);
                context.setEnding(singleton);
                context.attached();
                context.notIsModuleAndClassVarDefined(iVisited.getName(), failure);
                context.pushString("class variable");
                context.go(ending);
                context.setEnding(failure);
                context.pushNull();
                context.setEnding(ending);
                break;
            }
            case ZSUPERNODE: {
                Object fail = context.getNewEnding();
                Object fail2 = context.getNewEnding();
                Object fail_easy = context.getNewEnding();
                Object ending = context.getNewEnding();
                context.getFrameName();
                context.duplicateCurrentValue();
                context.ifNull(fail);
                context.getFrameKlazz();
                context.duplicateCurrentValue();
                context.ifNull(fail2);
                context.superClass();
                context.ifNotSuperMethodBound(fail_easy);
                context.pushString("super");
                context.go(ending);
                context.setEnding(fail2);
                context.consumeCurrentValue();
                context.setEnding(fail);
                context.consumeCurrentValue();
                context.setEnding(fail_easy);
                context.pushNull();
                context.setEnding(ending);
                break;
            }
            case SUPERNODE: {
                Object fail = context.getNewEnding();
                Object fail2 = context.getNewEnding();
                Object fail_easy = context.getNewEnding();
                Object ending = context.getNewEnding();
                context.getFrameName();
                context.duplicateCurrentValue();
                context.ifNull(fail);
                context.getFrameKlazz();
                context.duplicateCurrentValue();
                context.ifNull(fail2);
                context.superClass();
                context.ifNotSuperMethodBound(fail_easy);
                this.compileGetArgumentDefinition(((SuperNode)node).getArgsNode(), context, "super");
                context.go(ending);
                context.setEnding(fail2);
                context.consumeCurrentValue();
                context.setEnding(fail);
                context.consumeCurrentValue();
                context.setEnding(fail_easy);
                context.pushNull();
                context.setEnding(ending);
                break;
            }
            case ATTRASSIGNNODE: {
                final AttrAssignNode iVisited = (AttrAssignNode)node;
                Object isnull = context.getNewEnding();
                Object ending = context.getNewEnding();
                this.compileGetDefinition(iVisited.getReceiverNode(), context);
                context.ifNull(isnull);
                context.rescue(new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        ASTCompiler.this.compile(iVisited.getReceiverNode(), context);
                        context.duplicateCurrentValue();
                        context.metaclass();
                        context.duplicateCurrentValue();
                        context.getVisibilityFor(iVisited.getName());
                        context.duplicateCurrentValue();
                        final Object isfalse = context.getNewEnding();
                        Object isreal = context.getNewEnding();
                        Object ending = context.getNewEnding();
                        context.isPrivate(isfalse, 3);
                        context.isNotProtected(isreal, 1);
                        context.selfIsKindOf(isreal);
                        context.consumeCurrentValue();
                        context.go(isfalse);
                        context.setEnding(isreal);
                        context.isMethodBound(iVisited.getName(), new BranchCallback(){

                            public void branch(MethodCompiler context) {
                                ASTCompiler.this.compileGetArgumentDefinition(iVisited.getArgsNode(), context, "assignment");
                            }
                        }, new BranchCallback(){

                            public void branch(MethodCompiler context) {
                                context.go(isfalse);
                            }
                        });
                        context.go(ending);
                        context.setEnding(isfalse);
                        context.pushNull();
                        context.setEnding(ending);
                    }
                }, JumpException.class, new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        context.pushNull();
                    }
                }, String.class);
                context.go(ending);
                context.setEnding(isnull);
                context.pushNull();
                context.setEnding(ending);
                break;
            }
            default: {
                context.rescue(new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        ASTCompiler.this.compile(node, context);
                        context.consumeCurrentValue();
                        context.pushNull();
                    }
                }, JumpException.class, new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        context.pushNull();
                    }
                }, String.class);
                context.consumeCurrentValue();
                context.pushString("expression");
            }
        }
    }

    public void compileDAsgn(Node node, MethodCompiler context) {
        final DAsgnNode dasgnNode = (DAsgnNode)node;
        CompilerCallback value2 = new CompilerCallback(){

            public void call(MethodCompiler context) {
                ASTCompiler.this.compile(dasgnNode.getValueNode(), context);
            }
        };
        context.getVariableCompiler().assignLocalVariable(dasgnNode.getIndex(), dasgnNode.getDepth(), value2);
    }

    public void compileDAsgnAssignment(Node node, MethodCompiler context) {
        DAsgnNode dasgnNode = (DAsgnNode)node;
        context.getVariableCompiler().assignLocalVariable(dasgnNode.getIndex(), dasgnNode.getDepth());
    }

    public void compileDefn(Node node, MethodCompiler context) {
        final DefnNode defnNode = (DefnNode)node;
        final ArgsNode argsNode = defnNode.getArgsNode();
        CompilerCallback body = new CompilerCallback(){

            public void call(MethodCompiler context) {
                if (defnNode.getBodyNode() != null) {
                    ASTCompiler.this.compile(defnNode.getBodyNode(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        CompilerCallback args2 = new CompilerCallback(){

            public void call(MethodCompiler context) {
                ASTCompiler.this.compileArgs(argsNode, context);
            }
        };
        ASTInspector inspector = new ASTInspector();
        inspector.inspect(defnNode.getArgsNode());
        inspector.inspect(defnNode.getBodyNode());
        context.defineNewMethod(defnNode.getName(), defnNode.getArgsNode().getArity().getValue(), defnNode.getScope(), body, args2, null, inspector, this.isAtRoot);
    }

    public void compileDefs(Node node, MethodCompiler context) {
        final DefsNode defsNode = (DefsNode)node;
        final ArgsNode argsNode = defsNode.getArgsNode();
        CompilerCallback receiver = new CompilerCallback(){

            public void call(MethodCompiler context) {
                ASTCompiler.this.compile(defsNode.getReceiverNode(), context);
            }
        };
        CompilerCallback body = new CompilerCallback(){

            public void call(MethodCompiler context) {
                if (defsNode.getBodyNode() != null) {
                    ASTCompiler.this.compile(defsNode.getBodyNode(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        CompilerCallback args2 = new CompilerCallback(){

            public void call(MethodCompiler context) {
                ASTCompiler.this.compileArgs(argsNode, context);
            }
        };
        ASTInspector inspector = new ASTInspector();
        inspector.inspect(defsNode.getArgsNode());
        inspector.inspect(defsNode.getBodyNode());
        context.defineNewMethod(defsNode.getName(), defsNode.getArgsNode().getArity().getValue(), defsNode.getScope(), body, args2, receiver, inspector, false);
    }

    public void compileArgs(Node node, MethodCompiler context) {
        final ArgsNode argsNode = (ArgsNode)node;
        int required = argsNode.getRequiredArgsCount();
        int opt = argsNode.getOptionalArgsCount();
        int rest2 = argsNode.getRestArg();
        ArrayCallback requiredAssignment = null;
        ArrayCallback optionalGiven = null;
        ArrayCallback optionalNotGiven = null;
        CompilerCallback restAssignment = null;
        CompilerCallback blockAssignment = null;
        if (required > 0) {
            requiredAssignment = new ArrayCallback(){

                public void nextValue(MethodCompiler context, Object object, int index2) {
                    context.getVariableCompiler().assignLocalVariable(index2);
                }
            };
        }
        if (opt > 0) {
            optionalGiven = new ArrayCallback(){

                public void nextValue(MethodCompiler context, Object object, int index2) {
                    Node optArg = ((ListNode)object).get(index2);
                    ASTCompiler.this.compileAssignment(optArg, context);
                }
            };
            optionalNotGiven = new ArrayCallback(){

                public void nextValue(MethodCompiler context, Object object, int index2) {
                    Node optArg = ((ListNode)object).get(index2);
                    ASTCompiler.this.compile(optArg, context);
                }
            };
        }
        if (rest2 > -1) {
            restAssignment = new CompilerCallback(){

                public void call(MethodCompiler context) {
                    context.getVariableCompiler().assignLocalVariable(argsNode.getRestArg());
                }
            };
        }
        if (argsNode.getBlockArgNode() != null) {
            blockAssignment = new CompilerCallback(){

                public void call(MethodCompiler context) {
                    context.getVariableCompiler().assignLocalVariable(argsNode.getBlockArgNode().getCount());
                }
            };
        }
        context.getVariableCompiler().checkMethodArity(required, opt, rest2);
        context.getVariableCompiler().assignMethodArguments(argsNode.getArgs(), argsNode.getRequiredArgsCount(), argsNode.getOptArgs(), argsNode.getOptionalArgsCount(), requiredAssignment, optionalGiven, optionalNotGiven, restAssignment, blockAssignment);
    }

    public void compileDot(Node node, MethodCompiler context) {
        DotNode dotNode = (DotNode)node;
        this.compile(dotNode.getBeginNode(), context);
        this.compile(dotNode.getEndNode(), context);
        context.createNewRange(dotNode.isExclusive());
    }

    public void compileDRegexp(Node node, MethodCompiler context) {
        final DRegexpNode dregexpNode = (DRegexpNode)node;
        CompilerCallback createStringCallback = new CompilerCallback(){

            public void call(MethodCompiler context) {
                ArrayCallback dstrCallback = new ArrayCallback(){

                    public void nextValue(MethodCompiler context, Object sourceArray, int index2) {
                        ASTCompiler.this.compile(dregexpNode.get(index2), context);
                    }
                };
                context.createNewString(dstrCallback, dregexpNode.size());
            }
        };
        context.createNewRegexp(createStringCallback, dregexpNode.getOptions());
    }

    public void compileDStr(Node node, MethodCompiler context) {
        final DStrNode dstrNode = (DStrNode)node;
        ArrayCallback dstrCallback = new ArrayCallback(){

            public void nextValue(MethodCompiler context, Object sourceArray, int index2) {
                ASTCompiler.this.compile(dstrNode.get(index2), context);
            }
        };
        context.createNewString(dstrCallback, dstrNode.size());
    }

    public void compileDSymbol(Node node, MethodCompiler context) {
        final DSymbolNode dsymbolNode = (DSymbolNode)node;
        ArrayCallback dstrCallback = new ArrayCallback(){

            public void nextValue(MethodCompiler context, Object sourceArray, int index2) {
                ASTCompiler.this.compile(dsymbolNode.get(index2), context);
            }
        };
        context.createNewSymbol(dstrCallback, dsymbolNode.size());
    }

    public void compileDVar(Node node, MethodCompiler context) {
        DVarNode dvarNode = (DVarNode)node;
        context.getVariableCompiler().retrieveLocalVariable(dvarNode.getIndex(), dvarNode.getDepth());
    }

    public void compileDXStr(Node node, MethodCompiler context) {
        final DXStrNode dxstrNode = (DXStrNode)node;
        final ArrayCallback dstrCallback = new ArrayCallback(){

            public void nextValue(MethodCompiler context, Object sourceArray, int index2) {
                ASTCompiler.this.compile(dxstrNode.get(index2), context);
            }
        };
        ArgumentsCallback argsCallback = new ArgumentsCallback(){

            public int getArity() {
                return 1;
            }

            public void call(MethodCompiler context) {
                context.createNewString(dstrCallback, dxstrNode.size());
            }
        };
        context.getInvocationCompiler().invokeDynamic("`", null, argsCallback, CallType.FUNCTIONAL, null, false);
    }

    public void compileEnsureNode(Node node, MethodCompiler context) {
        final EnsureNode ensureNode = (EnsureNode)node;
        if (ensureNode.getEnsureNode() != null) {
            context.protect(new BranchCallback(){

                public void branch(MethodCompiler context) {
                    if (ensureNode.getBodyNode() != null) {
                        ASTCompiler.this.compile(ensureNode.getBodyNode(), context);
                    } else {
                        context.loadNil();
                    }
                }
            }, new BranchCallback(){

                public void branch(MethodCompiler context) {
                    ASTCompiler.this.compile(ensureNode.getEnsureNode(), context);
                    context.consumeCurrentValue();
                }
            }, IRubyObject.class);
        } else if (ensureNode.getBodyNode() != null) {
            this.compile(ensureNode.getBodyNode(), context);
        } else {
            context.loadNil();
        }
    }

    public void compileEvStr(Node node, MethodCompiler context) {
        EvStrNode evStrNode = (EvStrNode)node;
        this.compile(evStrNode.getBody(), context);
        context.asString();
    }

    public void compileFalse(Node node, MethodCompiler context) {
        context.loadFalse();
        context.pollThreadEvents();
    }

    public void compileFCall(Node node, MethodCompiler context) {
        FCallNode fcallNode = (FCallNode)node;
        ArgumentsCallback argsCallback = this.getArgsCallback(fcallNode.getArgsNode());
        CompilerCallback closureArg = this.getBlock(fcallNode.getIterNode());
        context.getInvocationCompiler().invokeDynamic(fcallNode.getName(), null, argsCallback, CallType.FUNCTIONAL, closureArg, fcallNode.getIterNode() instanceof IterNode);
    }

    private CompilerCallback getBlock(Node node) {
        if (node == null) {
            return null;
        }
        switch (node.nodeId) {
            case ITERNODE: {
                final IterNode iterNode = (IterNode)node;
                return new CompilerCallback(){

                    public void call(MethodCompiler context) {
                        ASTCompiler.this.compile(iterNode, context);
                    }
                };
            }
            case BLOCKPASSNODE: {
                final BlockPassNode blockPassNode = (BlockPassNode)node;
                return new CompilerCallback(){

                    public void call(MethodCompiler context) {
                        ASTCompiler.this.compile(blockPassNode.getBodyNode(), context);
                        context.unwrapPassedBlock();
                    }
                };
            }
        }
        throw new NotCompilableException("ERROR: Encountered a method with a non-block, non-blockpass iter node at: " + node);
    }

    public void compileFixnum(Node node, MethodCompiler context) {
        FixnumNode fixnumNode = (FixnumNode)node;
        context.createNewFixnum(fixnumNode.getValue());
    }

    public void compileFlip(Node node, MethodCompiler context) {
        final FlipNode flipNode = (FlipNode)node;
        context.getVariableCompiler().retrieveLocalVariable(flipNode.getIndex(), flipNode.getDepth());
        if (flipNode.isExclusive()) {
            context.performBooleanBranch(new BranchCallback(){

                public void branch(MethodCompiler context) {
                    ASTCompiler.this.compile(flipNode.getEndNode(), context);
                    context.performBooleanBranch(new BranchCallback(){

                        public void branch(MethodCompiler context) {
                            context.loadFalse();
                            context.getVariableCompiler().assignLocalVariable(flipNode.getIndex(), flipNode.getDepth());
                            context.consumeCurrentValue();
                        }
                    }, new BranchCallback(){

                        public void branch(MethodCompiler context) {
                        }
                    });
                    context.loadTrue();
                }
            }, new BranchCallback(){

                public void branch(MethodCompiler context) {
                    ASTCompiler.this.compile(flipNode.getBeginNode(), context);
                    ASTCompiler.this.becomeTrueOrFalse(context);
                    context.getVariableCompiler().assignLocalVariable(flipNode.getIndex(), flipNode.getDepth());
                }
            });
        } else {
            context.performBooleanBranch(new BranchCallback(){

                public void branch(MethodCompiler context) {
                    ASTCompiler.this.compile(flipNode.getEndNode(), context);
                    context.performBooleanBranch(new BranchCallback(){

                        public void branch(MethodCompiler context) {
                            context.loadFalse();
                            context.getVariableCompiler().assignLocalVariable(flipNode.getIndex(), flipNode.getDepth());
                            context.consumeCurrentValue();
                        }
                    }, new BranchCallback(){

                        public void branch(MethodCompiler context) {
                        }
                    });
                    context.loadTrue();
                }
            }, new BranchCallback(){

                public void branch(MethodCompiler context) {
                    ASTCompiler.this.compile(flipNode.getBeginNode(), context);
                    context.performBooleanBranch(new BranchCallback(){

                        public void branch(MethodCompiler context) {
                            ASTCompiler.this.compile(flipNode.getEndNode(), context);
                            ASTCompiler.this.flipTrueOrFalse(context);
                            context.getVariableCompiler().assignLocalVariable(flipNode.getIndex(), flipNode.getDepth());
                            context.consumeCurrentValue();
                            context.loadTrue();
                        }
                    }, new BranchCallback(){

                        public void branch(MethodCompiler context) {
                            context.loadFalse();
                        }
                    });
                }
            });
        }
    }

    private void becomeTrueOrFalse(MethodCompiler context) {
        context.performBooleanBranch(new BranchCallback(){

            public void branch(MethodCompiler context) {
                context.loadTrue();
            }
        }, new BranchCallback(){

            public void branch(MethodCompiler context) {
                context.loadFalse();
            }
        });
    }

    private void flipTrueOrFalse(MethodCompiler context) {
        context.performBooleanBranch(new BranchCallback(){

            public void branch(MethodCompiler context) {
                context.loadFalse();
            }
        }, new BranchCallback(){

            public void branch(MethodCompiler context) {
                context.loadTrue();
            }
        });
    }

    public void compileFloat(Node node, MethodCompiler context) {
        FloatNode floatNode = (FloatNode)node;
        context.createNewFloat(floatNode.getValue());
    }

    public void compileFor(Node node, MethodCompiler context) {
        final ForNode forNode = (ForNode)node;
        CompilerCallback receiverCallback = new CompilerCallback(){

            public void call(MethodCompiler context) {
                ASTCompiler.this.compile(forNode.getIterNode(), context);
            }
        };
        CompilerCallback closureArg = new CompilerCallback(){

            public void call(MethodCompiler context) {
                ASTCompiler.this.compileForIter(forNode, context);
            }
        };
        context.getInvocationCompiler().invokeDynamic("each", receiverCallback, null, CallType.NORMAL, closureArg, true);
    }

    public void compileForIter(Node node, MethodCompiler context) {
        final ForNode forNode = (ForNode)node;
        CompilerCallback closureBody = new CompilerCallback(){

            public void call(MethodCompiler context) {
                if (forNode.getBodyNode() != null) {
                    ASTCompiler.this.compile(forNode.getBodyNode(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        CompilerCallback closureArgs = new CompilerCallback(){

            public void call(MethodCompiler context) {
                if (forNode.getVarNode() != null) {
                    ASTCompiler.this.compileAssignment(forNode.getVarNode(), context);
                }
            }
        };
        boolean hasMultipleArgsHead = false;
        if (forNode.getVarNode() instanceof MultipleAsgnNode) {
            hasMultipleArgsHead = ((MultipleAsgnNode)forNode.getVarNode()).getHeadNode() != null;
        }
        NodeType argsNodeId = null;
        if (forNode.getVarNode() != null) {
            argsNodeId = forNode.getVarNode().nodeId;
        }
        if (argsNodeId == null) {
            context.createNewForLoop(Arity.procArityOf(forNode.getVarNode()).getValue(), closureBody, null, hasMultipleArgsHead, argsNodeId);
        } else {
            context.createNewForLoop(Arity.procArityOf(forNode.getVarNode()).getValue(), closureBody, closureArgs, hasMultipleArgsHead, argsNodeId);
        }
    }

    public void compileGlobalAsgn(Node node, MethodCompiler context) {
        final GlobalAsgnNode globalAsgnNode = (GlobalAsgnNode)node;
        CompilerCallback value2 = new CompilerCallback(){

            public void call(MethodCompiler context) {
                ASTCompiler.this.compile(globalAsgnNode.getValueNode(), context);
            }
        };
        if (globalAsgnNode.getName().length() == 2) {
            switch (globalAsgnNode.getName().charAt(1)) {
                case '_': {
                    context.getVariableCompiler().assignLastLine(value2);
                    return;
                }
                case '~': {
                    context.getVariableCompiler().assignBackRef(value2);
                    return;
                }
            }
        }
        context.assignGlobalVariable(globalAsgnNode.getName(), value2);
    }

    public void compileGlobalAsgnAssignment(Node node, MethodCompiler context) {
        GlobalAsgnNode globalAsgnNode = (GlobalAsgnNode)node;
        if (globalAsgnNode.getName().length() == 2) {
            switch (globalAsgnNode.getName().charAt(1)) {
                case '_': {
                    context.getVariableCompiler().assignLastLine();
                    return;
                }
                case '~': {
                    context.getVariableCompiler().assignBackRef();
                    return;
                }
            }
        }
        context.assignGlobalVariable(globalAsgnNode.getName());
    }

    public void compileGlobalVar(Node node, MethodCompiler context) {
        GlobalVarNode globalVarNode = (GlobalVarNode)node;
        if (globalVarNode.getName().length() == 2) {
            switch (globalVarNode.getName().charAt(1)) {
                case '_': {
                    context.getVariableCompiler().retrieveLastLine();
                    return;
                }
                case '~': {
                    context.getVariableCompiler().retrieveBackRef();
                    return;
                }
            }
        }
        context.retrieveGlobalVariable(globalVarNode.getName());
    }

    public void compileHash(Node node, MethodCompiler context) {
        HashNode hashNode = (HashNode)node;
        if (hashNode.getListNode() == null || hashNode.getListNode().size() == 0) {
            context.createEmptyHash();
            return;
        }
        ArrayCallback hashCallback = new ArrayCallback(){

            public void nextValue(MethodCompiler context, Object sourceArray, int index2) {
                ListNode listNode = (ListNode)sourceArray;
                int keyIndex = index2 * 2;
                ASTCompiler.this.compile(listNode.get(keyIndex), context);
                ASTCompiler.this.compile(listNode.get(keyIndex + 1), context);
            }
        };
        context.createNewHash(hashNode.getListNode(), hashCallback, hashNode.getListNode().size() / 2);
    }

    public void compileIf(Node node, MethodCompiler context) {
        final IfNode ifNode = (IfNode)node;
        this.compile(ifNode.getCondition(), context);
        BranchCallback trueCallback = new BranchCallback(){

            public void branch(MethodCompiler context) {
                if (ifNode.getThenBody() != null) {
                    ASTCompiler.this.compile(ifNode.getThenBody(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        BranchCallback falseCallback = new BranchCallback(){

            public void branch(MethodCompiler context) {
                if (ifNode.getElseBody() != null) {
                    ASTCompiler.this.compile(ifNode.getElseBody(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        context.performBooleanBranch(trueCallback, falseCallback);
    }

    public void compileInstAsgn(Node node, MethodCompiler context) {
        final InstAsgnNode instAsgnNode = (InstAsgnNode)node;
        CompilerCallback value2 = new CompilerCallback(){

            public void call(MethodCompiler context) {
                ASTCompiler.this.compile(instAsgnNode.getValueNode(), context);
            }
        };
        context.assignInstanceVariable(instAsgnNode.getName(), value2);
    }

    public void compileInstAsgnAssignment(Node node, MethodCompiler context) {
        InstAsgnNode instAsgnNode = (InstAsgnNode)node;
        context.assignInstanceVariable(instAsgnNode.getName());
    }

    public void compileInstVar(Node node, MethodCompiler context) {
        InstVarNode instVarNode = (InstVarNode)node;
        context.retrieveInstanceVariable(instVarNode.getName());
    }

    public void compileIter(Node node, MethodCompiler context) {
        final IterNode iterNode = (IterNode)node;
        CompilerCallback closureBody = new CompilerCallback(){

            public void call(MethodCompiler context) {
                if (iterNode.getBodyNode() != null) {
                    ASTCompiler.this.compile(iterNode.getBodyNode(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        CompilerCallback closureArgs = new CompilerCallback(){

            public void call(MethodCompiler context) {
                if (iterNode.getVarNode() != null) {
                    ASTCompiler.this.compileAssignment(iterNode.getVarNode(), context);
                }
            }
        };
        boolean hasMultipleArgsHead = false;
        if (iterNode.getVarNode() instanceof MultipleAsgnNode) {
            hasMultipleArgsHead = ((MultipleAsgnNode)iterNode.getVarNode()).getHeadNode() != null;
        }
        NodeType argsNodeId = BlockBody.getArgumentTypeWackyHack(iterNode);
        ASTInspector inspector = new ASTInspector();
        inspector.inspect(iterNode.getBodyNode());
        inspector.inspect(iterNode.getVarNode());
        if (argsNodeId == null) {
            context.createNewClosure(iterNode.getPosition().getStartLine(), iterNode.getScope(), Arity.procArityOf(iterNode.getVarNode()).getValue(), closureBody, null, hasMultipleArgsHead, argsNodeId, inspector);
        } else {
            context.createNewClosure(iterNode.getPosition().getStartLine(), iterNode.getScope(), Arity.procArityOf(iterNode.getVarNode()).getValue(), closureBody, closureArgs, hasMultipleArgsHead, argsNodeId, inspector);
        }
    }

    public void compileLocalAsgn(Node node, MethodCompiler context) {
        final LocalAsgnNode localAsgnNode = (LocalAsgnNode)node;
        if (ASTInspector.PRAGMAS.contains(localAsgnNode.getName())) {
            context.loadNull();
        } else {
            CompilerCallback value2 = new CompilerCallback(){

                public void call(MethodCompiler context) {
                    ASTCompiler.this.compile(localAsgnNode.getValueNode(), context);
                }
            };
            context.getVariableCompiler().assignLocalVariable(localAsgnNode.getIndex(), localAsgnNode.getDepth(), value2);
        }
    }

    public void compileLocalAsgnAssignment(Node node, MethodCompiler context) {
        LocalAsgnNode localAsgnNode = (LocalAsgnNode)node;
        context.getVariableCompiler().assignLocalVariable(localAsgnNode.getIndex(), localAsgnNode.getDepth());
    }

    public void compileLocalVar(Node node, MethodCompiler context) {
        LocalVarNode localVarNode = (LocalVarNode)node;
        context.getVariableCompiler().retrieveLocalVariable(localVarNode.getIndex(), localVarNode.getDepth());
    }

    public void compileMatch(Node node, MethodCompiler context) {
        MatchNode matchNode = (MatchNode)node;
        this.compile(matchNode.getRegexpNode(), context);
        context.match();
    }

    public void compileMatch2(Node node, MethodCompiler context) {
        Match2Node matchNode = (Match2Node)node;
        this.compile(matchNode.getReceiverNode(), context);
        this.compile(matchNode.getValueNode(), context);
        context.match2();
    }

    public void compileMatch3(Node node, MethodCompiler context) {
        Match3Node matchNode = (Match3Node)node;
        this.compile(matchNode.getReceiverNode(), context);
        this.compile(matchNode.getValueNode(), context);
        context.match3();
    }

    public void compileModule(Node node, MethodCompiler context) {
        final ModuleNode moduleNode = (ModuleNode)node;
        final Colon3Node cpathNode = moduleNode.getCPath();
        CompilerCallback bodyCallback = new CompilerCallback(){

            public void call(MethodCompiler context) {
                if (moduleNode.getBodyNode() != null) {
                    ASTCompiler.this.compile(moduleNode.getBodyNode(), context);
                }
                context.loadNil();
            }
        };
        CompilerCallback pathCallback = new CompilerCallback(){

            public void call(MethodCompiler context) {
                if (cpathNode instanceof Colon2Node) {
                    Node leftNode = ((Colon2Node)cpathNode).getLeftNode();
                    if (leftNode != null) {
                        ASTCompiler.this.compile(leftNode, context);
                    } else {
                        context.loadNil();
                    }
                } else if (cpathNode instanceof Colon3Node) {
                    context.loadObject();
                } else {
                    context.loadNil();
                }
            }
        };
        context.defineModule(moduleNode.getCPath().getName(), moduleNode.getScope(), pathCallback, bodyCallback);
    }

    public void compileMultipleAsgn(Node node, MethodCompiler context) {
        MultipleAsgnNode multipleAsgnNode = (MultipleAsgnNode)node;
        this.compile(multipleAsgnNode.getValueNode(), context);
        this.compileMultipleAsgnAssignment(node, context);
    }

    public void compileMultipleAsgnAssignment(Node node, MethodCompiler context) {
        final MultipleAsgnNode multipleAsgnNode = (MultipleAsgnNode)node;
        ArrayCallback headAssignCallback = new ArrayCallback(){

            public void nextValue(MethodCompiler context, Object sourceArray, int index2) {
                ListNode headNode = (ListNode)sourceArray;
                Node assignNode = headNode.get(index2);
                ASTCompiler.this.compileAssignment(assignNode, context);
            }
        };
        ArrayCallback headNilCallback = new ArrayCallback(){

            public void nextValue(MethodCompiler context, Object sourceArray, int index2) {
                ListNode headNode = (ListNode)sourceArray;
                Node assignNode = headNode.get(index2);
                context.loadNil();
                ASTCompiler.this.compileAssignment(assignNode, context);
            }
        };
        CompilerCallback argsCallback = new CompilerCallback(){

            public void call(MethodCompiler context) {
                Node argsNode = multipleAsgnNode.getArgsNode();
                if (!(argsNode instanceof StarNode)) {
                    ASTCompiler.this.compileAssignment(argsNode, context);
                }
            }
        };
        if (multipleAsgnNode.getHeadNode() == null) {
            if (multipleAsgnNode.getArgsNode() == null) {
                throw new NotCompilableException("Something's wrong, multiple assignment with no head or args at: " + multipleAsgnNode.getPosition());
            }
            if (!(multipleAsgnNode.getArgsNode() instanceof StarNode)) {
                context.ensureMultipleAssignableRubyArray(multipleAsgnNode.getHeadNode() != null);
                context.forEachInValueArray(0, 0, null, null, null, argsCallback);
            }
        } else {
            context.ensureMultipleAssignableRubyArray(multipleAsgnNode.getHeadNode() != null);
            if (multipleAsgnNode.getArgsNode() == null) {
                context.forEachInValueArray(0, multipleAsgnNode.getHeadNode().size(), multipleAsgnNode.getHeadNode(), headAssignCallback, headNilCallback, null);
            } else {
                context.forEachInValueArray(0, multipleAsgnNode.getHeadNode().size(), multipleAsgnNode.getHeadNode(), headAssignCallback, headNilCallback, argsCallback);
            }
        }
    }

    public void compileNewline(Node node, MethodCompiler context) {
        context.lineNumber(node.getPosition());
        context.setLinePosition(node.getPosition());
        NewlineNode newlineNode = (NewlineNode)node;
        this.compile(newlineNode.getNextNode(), context);
    }

    public void compileNext(Node node, MethodCompiler context) {
        final NextNode nextNode = (NextNode)node;
        CompilerCallback valueCallback = new CompilerCallback(){

            public void call(MethodCompiler context) {
                if (nextNode.getValueNode() != null) {
                    ASTCompiler.this.compile(nextNode.getValueNode(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        context.pollThreadEvents();
        context.issueNextEvent(valueCallback);
    }

    public void compileNthRef(Node node, MethodCompiler context) {
        NthRefNode nthRefNode = (NthRefNode)node;
        context.nthRef(nthRefNode.getMatchNumber());
    }

    public void compileNil(Node node, MethodCompiler context) {
        context.loadNil();
        context.pollThreadEvents();
    }

    public void compileNot(Node node, MethodCompiler context) {
        NotNode notNode = (NotNode)node;
        this.compile(notNode.getConditionNode(), context);
        context.negateCurrentValue();
    }

    public void compileOpAsgnAnd(Node node, MethodCompiler context) {
        final BinaryOperatorNode andNode = (BinaryOperatorNode)((Object)node);
        this.compile(andNode.getFirstNode(), context);
        BranchCallback longCallback = new BranchCallback(){

            public void branch(MethodCompiler context) {
                ASTCompiler.this.compile(andNode.getSecondNode(), context);
            }
        };
        context.performLogicalAnd(longCallback);
        context.pollThreadEvents();
    }

    public void compileOpAsgnOr(Node node, MethodCompiler context) {
        final OpAsgnOrNode orNode = (OpAsgnOrNode)node;
        this.compileGetDefinitionBase(orNode.getFirstNode(), context);
        context.isNull(new BranchCallback(){

            public void branch(MethodCompiler context) {
                ASTCompiler.this.compile(orNode.getSecondNode(), context);
            }
        }, new BranchCallback(){

            public void branch(MethodCompiler context) {
                ASTCompiler.this.compile(orNode.getFirstNode(), context);
                context.duplicateCurrentValue();
                context.performBooleanBranch(new BranchCallback(){

                    public void branch(MethodCompiler context) {
                    }
                }, new BranchCallback(){

                    public void branch(MethodCompiler context) {
                        context.consumeCurrentValue();
                        ASTCompiler.this.compile(orNode.getSecondNode(), context);
                    }
                });
            }
        });
        context.pollThreadEvents();
    }

    public void compileOpAsgn(Node node, MethodCompiler context) {
        OpAsgnNode opAsgnNode = (OpAsgnNode)node;
        if (opAsgnNode.getOperatorName().equals("||")) {
            this.compileOpAsgnWithOr(opAsgnNode, context);
        } else if (opAsgnNode.getOperatorName().equals("&&")) {
            this.compileOpAsgnWithAnd(opAsgnNode, context);
        } else {
            this.compileOpAsgnWithMethod(opAsgnNode, context);
        }
        context.pollThreadEvents();
    }

    public void compileOpAsgnWithOr(Node node, MethodCompiler context) {
        final OpAsgnNode opAsgnNode = (OpAsgnNode)node;
        CompilerCallback receiverCallback = new CompilerCallback(){

            public void call(MethodCompiler context) {
                ASTCompiler.this.compile(opAsgnNode.getReceiverNode(), context);
            }
        };
        ArgumentsCallback argsCallback = this.getArgsCallback(opAsgnNode.getValueNode());
        context.getInvocationCompiler().invokeOpAsgnWithOr(opAsgnNode.getVariableName(), opAsgnNode.getVariableNameAsgn(), receiverCallback, argsCallback);
    }

    public void compileOpAsgnWithAnd(Node node, MethodCompiler context) {
        final OpAsgnNode opAsgnNode = (OpAsgnNode)node;
        CompilerCallback receiverCallback = new CompilerCallback(){

            public void call(MethodCompiler context) {
                ASTCompiler.this.compile(opAsgnNode.getReceiverNode(), context);
            }
        };
        ArgumentsCallback argsCallback = this.getArgsCallback(opAsgnNode.getValueNode());
        context.getInvocationCompiler().invokeOpAsgnWithAnd(opAsgnNode.getVariableName(), opAsgnNode.getVariableNameAsgn(), receiverCallback, argsCallback);
    }

    public void compileOpAsgnWithMethod(Node node, MethodCompiler context) {
        final OpAsgnNode opAsgnNode = (OpAsgnNode)node;
        CompilerCallback receiverCallback = new CompilerCallback(){

            public void call(MethodCompiler context) {
                ASTCompiler.this.compile(opAsgnNode.getReceiverNode(), context);
            }
        };
        ArgumentsCallback argsCallback = new ArgumentsCallback(){

            public int getArity() {
                return 1;
            }

            public void call(MethodCompiler context) {
                ASTCompiler.this.compile(opAsgnNode.getValueNode(), context);
            }
        };
        context.getInvocationCompiler().invokeOpAsgnWithMethod(opAsgnNode.getOperatorName(), opAsgnNode.getVariableName(), opAsgnNode.getVariableNameAsgn(), receiverCallback, argsCallback);
    }

    public void compileOpElementAsgn(Node node, MethodCompiler context) {
        OpElementAsgnNode opElementAsgnNode = (OpElementAsgnNode)node;
        if (opElementAsgnNode.getOperatorName() == "||") {
            this.compileOpElementAsgnWithOr(node, context);
        } else if (opElementAsgnNode.getOperatorName() == "&&") {
            this.compileOpElementAsgnWithAnd(node, context);
        } else {
            this.compileOpElementAsgnWithMethod(node, context);
        }
    }

    public void compileOpElementAsgnWithOr(Node node, MethodCompiler context) {
        final OpElementAsgnNode opElementAsgnNode = (OpElementAsgnNode)node;
        CompilerCallback receiverCallback = new CompilerCallback(){

            public void call(MethodCompiler context) {
                ASTCompiler.this.compile(opElementAsgnNode.getReceiverNode(), context);
            }
        };
        ArgumentsCallback argsCallback = new ArgumentsCallback(){

            public int getArity() {
                Node node = opElementAsgnNode.getArgsNode();
                switch (node.nodeId) {
                    case ARGSCATNODE: 
                    case ARGSPUSHNODE: 
                    case SPLATNODE: {
                        return -1;
                    }
                    case ARRAYNODE: {
                        ArrayNode arrayNode = (ArrayNode)node;
                        if (arrayNode.size() == 0) {
                            return 0;
                        }
                        if (arrayNode.size() > 3) {
                            return -1;
                        }
                        return ((ArrayNode)node).size();
                    }
                }
                return 1;
            }

            public void call(MethodCompiler context) {
                if (this.getArity() == 1) {
                    ASTCompiler.this.compile(((ArrayNode)opElementAsgnNode.getArgsNode()).get(0), context);
                } else {
                    ASTCompiler.this.compileArguments(opElementAsgnNode.getArgsNode(), context);
                }
            }
        };
        CompilerCallback valueCallback = new CompilerCallback(){

            public void call(MethodCompiler context) {
                ASTCompiler.this.compile(opElementAsgnNode.getValueNode(), context);
            }
        };
        context.getInvocationCompiler().opElementAsgnWithOr(receiverCallback, argsCallback, valueCallback);
    }

    public void compileOpElementAsgnWithAnd(Node node, MethodCompiler context) {
        final OpElementAsgnNode opElementAsgnNode = (OpElementAsgnNode)node;
        CompilerCallback receiverCallback = new CompilerCallback(){

            public void call(MethodCompiler context) {
                ASTCompiler.this.compile(opElementAsgnNode.getReceiverNode(), context);
            }
        };
        ArgumentsCallback argsCallback = new ArgumentsCallback(){

            public int getArity() {
                Node node = opElementAsgnNode.getArgsNode();
                switch (node.nodeId) {
                    case ARGSCATNODE: 
                    case ARGSPUSHNODE: 
                    case SPLATNODE: {
                        return -1;
                    }
                    case ARRAYNODE: {
                        ArrayNode arrayNode = (ArrayNode)node;
                        if (arrayNode.size() == 0) {
                            return 0;
                        }
                        if (arrayNode.size() > 3) {
                            return -1;
                        }
                        return ((ArrayNode)node).size();
                    }
                }
                return 1;
            }

            public void call(MethodCompiler context) {
                if (this.getArity() == 1) {
                    ASTCompiler.this.compile(((ArrayNode)opElementAsgnNode.getArgsNode()).get(0), context);
                } else {
                    ASTCompiler.this.compileArguments(opElementAsgnNode.getArgsNode(), context);
                }
            }
        };
        CompilerCallback valueCallback = new CompilerCallback(){

            public void call(MethodCompiler context) {
                ASTCompiler.this.compile(opElementAsgnNode.getValueNode(), context);
            }
        };
        context.getInvocationCompiler().opElementAsgnWithAnd(receiverCallback, argsCallback, valueCallback);
    }

    public void compileOpElementAsgnWithMethod(Node node, MethodCompiler context) {
        final OpElementAsgnNode opElementAsgnNode = (OpElementAsgnNode)node;
        CompilerCallback receiverCallback = new CompilerCallback(){

            public void call(MethodCompiler context) {
                ASTCompiler.this.compile(opElementAsgnNode.getReceiverNode(), context);
            }
        };
        ArgumentsCallback argsCallback = this.getArgsCallback(opElementAsgnNode.getArgsNode());
        CompilerCallback valueCallback = new CompilerCallback(){

            public void call(MethodCompiler context) {
                ASTCompiler.this.compile(opElementAsgnNode.getValueNode(), context);
            }
        };
        context.getInvocationCompiler().opElementAsgnWithMethod(receiverCallback, argsCallback, valueCallback, opElementAsgnNode.getOperatorName());
    }

    public void compileOr(Node node, MethodCompiler context) {
        final OrNode orNode = (OrNode)node;
        this.compile(orNode.getFirstNode(), context);
        BranchCallback longCallback = new BranchCallback(){

            public void branch(MethodCompiler context) {
                ASTCompiler.this.compile(orNode.getSecondNode(), context);
            }
        };
        context.performLogicalOr(longCallback);
    }

    public void compilePostExe(Node node, MethodCompiler context) {
        final PostExeNode postExeNode = (PostExeNode)node;
        CompilerCallback closureBody = new CompilerCallback(){

            public void call(MethodCompiler context) {
                if (postExeNode.getBodyNode() != null) {
                    ASTCompiler.this.compile(postExeNode.getBodyNode(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        context.createNewEndBlock(closureBody);
    }

    public void compilePreExe(Node node, MethodCompiler context) {
        final PreExeNode preExeNode = (PreExeNode)node;
        CompilerCallback closureBody = new CompilerCallback(){

            public void call(MethodCompiler context) {
                if (preExeNode.getBodyNode() != null) {
                    ASTCompiler.this.compile(preExeNode.getBodyNode(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        context.runBeginBlock(preExeNode.getScope(), closureBody);
    }

    public void compileRedo(Node node, MethodCompiler context) {
        context.issueRedoEvent();
    }

    public void compileRegexp(Node node, MethodCompiler context) {
        RegexpNode reNode = (RegexpNode)node;
        context.createNewRegexp(reNode.getValue(), reNode.getOptions());
    }

    public void compileRescue(Node node, MethodCompiler context) {
        final RescueNode rescueNode = (RescueNode)node;
        BranchCallback body = new BranchCallback(){

            public void branch(MethodCompiler context) {
                if (rescueNode.getBodyNode() != null) {
                    ASTCompiler.this.compile(rescueNode.getBodyNode(), context);
                } else {
                    context.loadNil();
                }
                if (rescueNode.getElseNode() != null) {
                    context.consumeCurrentValue();
                    ASTCompiler.this.compile(rescueNode.getElseNode(), context);
                }
            }
        };
        BranchCallback rubyHandler = new BranchCallback(){

            public void branch(MethodCompiler context) {
                context.loadException();
                context.unwrapRaiseException();
                context.assignGlobalVariable("$!");
                context.consumeCurrentValue();
                ASTCompiler.this.compileRescueBody(rescueNode.getRescueNode(), context);
            }
        };
        BranchCallback javaHandler = new BranchCallback(){

            public void branch(MethodCompiler context) {
                ASTCompiler.this.compileJavaRescueBody(rescueNode.getRescueNode(), context);
            }
        };
        context.performRescue(body, rubyHandler, javaHandler);
    }

    public void compileRescueBody(Node node, MethodCompiler context) {
        final RescueBodyNode rescueBodyNode = (RescueBodyNode)node;
        context.loadException();
        context.unwrapRaiseException();
        Node exceptionList = rescueBodyNode.getExceptionNodes();
        if (exceptionList == null) {
            context.loadClass("StandardError");
            context.createObjectArray(1);
        } else {
            this.compileArguments(exceptionList, context);
        }
        context.checkIsExceptionHandled();
        BranchCallback trueBranch = new BranchCallback(){

            public void branch(MethodCompiler context) {
                if (rescueBodyNode.getBodyNode() != null) {
                    ASTCompiler.this.compile(rescueBodyNode.getBodyNode(), context);
                    context.loadNil();
                    context.assignGlobalVariable("$!");
                    context.consumeCurrentValue();
                } else {
                    context.loadNil();
                    context.assignGlobalVariable("$!");
                }
            }
        };
        BranchCallback falseBranch = new BranchCallback(){

            public void branch(MethodCompiler context) {
                if (rescueBodyNode.getOptRescueNode() != null) {
                    ASTCompiler.this.compileRescueBody(rescueBodyNode.getOptRescueNode(), context);
                } else {
                    context.rethrowException();
                }
            }
        };
        context.performBooleanBranch(trueBranch, falseBranch);
    }

    public void compileJavaRescueBody(Node node, MethodCompiler context) {
        final RescueBodyNode rescueBodyNode = (RescueBodyNode)node;
        Node exceptionList = rescueBodyNode.getExceptionNodes();
        if (exceptionList == null) {
            if (rescueBodyNode.getOptRescueNode() != null) {
                this.compileJavaRescueBody(rescueBodyNode.getOptRescueNode(), context);
            } else {
                context.rethrowException();
            }
        } else {
            context.loadException();
            this.compileArguments(exceptionList, context);
            context.checkIsJavaExceptionHandled();
            BranchCallback trueBranch = new BranchCallback(){

                public void branch(MethodCompiler context) {
                    if (rescueBodyNode.getBodyNode() != null) {
                        context.wrapJavaException();
                        context.assignGlobalVariable("$!");
                        context.consumeCurrentValue();
                        ASTCompiler.this.compile(rescueBodyNode.getBodyNode(), context);
                        context.loadNil();
                        context.assignGlobalVariable("$!");
                        context.consumeCurrentValue();
                    } else {
                        context.loadNil();
                        context.assignGlobalVariable("$!");
                    }
                }
            };
            BranchCallback falseBranch = new BranchCallback(){

                public void branch(MethodCompiler context) {
                    if (rescueBodyNode.getOptRescueNode() != null) {
                        ASTCompiler.this.compileJavaRescueBody(rescueBodyNode.getOptRescueNode(), context);
                    } else {
                        context.rethrowException();
                    }
                }
            };
            context.performBooleanBranch(trueBranch, falseBranch);
        }
    }

    public void compileRetry(Node node, MethodCompiler context) {
        context.pollThreadEvents();
        context.issueRetryEvent();
    }

    public void compileReturn(Node node, MethodCompiler context) {
        ReturnNode returnNode = (ReturnNode)node;
        if (returnNode.getValueNode() != null) {
            this.compile(returnNode.getValueNode(), context);
        } else {
            context.loadNil();
        }
        context.performReturn();
    }

    public void compileRoot(Node node, ScriptCompiler context, ASTInspector inspector) {
        this.compileRoot(node, context, inspector, true, true);
    }

    public void compileRoot(Node node, ScriptCompiler context, ASTInspector inspector, boolean load2, boolean main2) {
        RootNode rootNode = (RootNode)node;
        context.startScript(rootNode.getStaticScope());
        MethodCompiler methodCompiler = context.startMethod("__file__", null, rootNode.getStaticScope(), inspector);
        Node nextNode = rootNode.getBodyNode();
        if (nextNode != null) {
            if (nextNode.nodeId == NodeType.BLOCKNODE) {
                BlockNode blockNode = (BlockNode)nextNode;
                for (int i = 0; i < blockNode.size(); ++i) {
                    if ((i + 1) % RubyInstanceConfig.CHAINED_COMPILE_LINE_COUNT == 0) {
                        methodCompiler = methodCompiler.chainToMethod("__file__from_line_" + (i + 1), inspector);
                    }
                    this.compile(blockNode.get(i), methodCompiler);
                    if (i + 1 >= blockNode.size()) continue;
                    methodCompiler.consumeCurrentValue();
                }
            } else {
                this.compile(nextNode, methodCompiler);
            }
        } else {
            methodCompiler.loadNil();
        }
        methodCompiler.endMethod();
        context.endScript(load2, main2);
    }

    public void compileSelf(Node node, MethodCompiler context) {
        context.retrieveSelf();
    }

    public void compileSplat(Node node, MethodCompiler context) {
        SplatNode splatNode = (SplatNode)node;
        this.compile(splatNode.getValue(), context);
        context.splatCurrentValue();
    }

    public void compileStr(Node node, MethodCompiler context) {
        StrNode strNode = (StrNode)node;
        context.createNewString(strNode.getValue());
    }

    public void compileSuper(Node node, MethodCompiler context) {
        final SuperNode superNode = (SuperNode)node;
        CompilerCallback argsCallback = new CompilerCallback(){

            public void call(MethodCompiler context) {
                ASTCompiler.this.compileArguments(superNode.getArgsNode(), context);
            }
        };
        if (superNode.getIterNode() == null) {
            if (superNode.getArgsNode() != null) {
                context.getInvocationCompiler().invokeSuper(argsCallback, null);
            } else {
                context.getInvocationCompiler().invokeSuper(null, null);
            }
        } else {
            CompilerCallback closureArg = this.getBlock(superNode.getIterNode());
            if (superNode.getArgsNode() != null) {
                context.getInvocationCompiler().invokeSuper(argsCallback, closureArg);
            } else {
                context.getInvocationCompiler().invokeSuper(null, closureArg);
            }
        }
    }

    public void compileSValue(Node node, MethodCompiler context) {
        SValueNode svalueNode = (SValueNode)node;
        this.compile(svalueNode.getValue(), context);
        context.singlifySplattedValue();
    }

    public void compileSymbol(Node node, MethodCompiler context) {
        context.createNewSymbol(((SymbolNode)node).getName());
    }

    public void compileToAry(Node node, MethodCompiler context) {
        ToAryNode toAryNode = (ToAryNode)node;
        this.compile(toAryNode.getValue(), context);
        context.aryToAry();
    }

    public void compileTrue(Node node, MethodCompiler context) {
        context.loadTrue();
        context.pollThreadEvents();
    }

    public void compileUndef(Node node, MethodCompiler context) {
        context.undefMethod(((UndefNode)node).getName());
    }

    public void compileUntil(Node node, MethodCompiler context) {
        final UntilNode untilNode = (UntilNode)node;
        BranchCallback condition = new BranchCallback(){

            public void branch(MethodCompiler context) {
                ASTCompiler.this.compile(untilNode.getConditionNode(), context);
                context.negateCurrentValue();
            }
        };
        BranchCallback body = new BranchCallback(){

            public void branch(MethodCompiler context) {
                if (untilNode.getBodyNode() == null) {
                    context.loadNil();
                    return;
                }
                ASTCompiler.this.compile(untilNode.getBodyNode(), context);
            }
        };
        if (untilNode.containsNonlocalFlow) {
            context.performBooleanLoopSafe(condition, body, untilNode.evaluateAtStart());
        } else {
            context.performBooleanLoopLight(condition, body, untilNode.evaluateAtStart());
        }
        context.pollThreadEvents();
    }

    public void compileVAlias(Node node, MethodCompiler context) {
        VAliasNode valiasNode = (VAliasNode)node;
        context.aliasGlobal(valiasNode.getNewName(), valiasNode.getOldName());
    }

    public void compileVCall(Node node, MethodCompiler context) {
        VCallNode vcallNode = (VCallNode)node;
        context.getInvocationCompiler().invokeDynamic(vcallNode.getName(), null, null, CallType.VARIABLE, null, false);
    }

    public void compileWhile(Node node, MethodCompiler context) {
        final WhileNode whileNode = (WhileNode)node;
        BranchCallback condition = new BranchCallback(){

            public void branch(MethodCompiler context) {
                ASTCompiler.this.compile(whileNode.getConditionNode(), context);
            }
        };
        BranchCallback body = new BranchCallback(){

            public void branch(MethodCompiler context) {
                if (whileNode.getBodyNode() == null) {
                    context.loadNil();
                } else {
                    ASTCompiler.this.compile(whileNode.getBodyNode(), context);
                }
            }
        };
        if (whileNode.containsNonlocalFlow) {
            context.performBooleanLoopSafe(condition, body, whileNode.evaluateAtStart());
        } else {
            context.performBooleanLoopLight(condition, body, whileNode.evaluateAtStart());
        }
        context.pollThreadEvents();
    }

    public void compileXStr(Node node, MethodCompiler context) {
        final XStrNode xstrNode = (XStrNode)node;
        ArgumentsCallback argsCallback = new ArgumentsCallback(){

            public int getArity() {
                return 1;
            }

            public void call(MethodCompiler context) {
                context.createNewString(xstrNode.getValue());
            }
        };
        context.getInvocationCompiler().invokeDynamic("`", null, argsCallback, CallType.FUNCTIONAL, null, false);
    }

    public void compileYield(Node node, MethodCompiler context) {
        YieldNode yieldNode = (YieldNode)node;
        if (yieldNode.getArgsNode() != null) {
            this.compile(yieldNode.getArgsNode(), context);
        }
        context.getInvocationCompiler().yield(yieldNode.getArgsNode() != null, yieldNode.getCheckState());
    }

    public void compileZArray(Node node, MethodCompiler context) {
        context.createEmptyArray();
    }

    public void compileZSuper(Node node, MethodCompiler context) {
        ZSuperNode zsuperNode = (ZSuperNode)node;
        CompilerCallback closure = this.getBlock(zsuperNode.getIterNode());
        context.callZSuper(closure);
    }

    public void compileArgsCatArguments(Node node, MethodCompiler context) {
        ArgsCatNode argsCatNode = (ArgsCatNode)node;
        this.compileArguments(argsCatNode.getFirstNode(), context);
        context.createNewArray(true);
        this.compile(argsCatNode.getSecondNode(), context);
        context.splatCurrentValue();
        context.concatArrays();
        context.convertToJavaArray();
    }

    public void compileArgsPushArguments(Node node, MethodCompiler context) {
        ArgsPushNode argsPushNode = (ArgsPushNode)node;
        this.compile(argsPushNode.getFirstNode(), context);
        this.compile(argsPushNode.getSecondNode(), context);
        context.appendToArray();
        context.convertToJavaArray();
    }

    public void compileArrayArguments(Node node, MethodCompiler context) {
        ArrayNode arrayNode = (ArrayNode)node;
        ArrayCallback callback = new ArrayCallback(){

            public void nextValue(MethodCompiler context, Object sourceArray, int index2) {
                Node node = (Node)((Object[])sourceArray)[index2];
                ASTCompiler.this.compile(node, context);
            }
        };
        context.setLinePosition(arrayNode.getPosition());
        context.createObjectArray(arrayNode.childNodes().toArray(), callback);
    }

    public void compileSplatArguments(Node node, MethodCompiler context) {
        SplatNode splatNode = (SplatNode)node;
        this.compile(splatNode.getValue(), context);
        context.splatCurrentValue();
        context.convertToJavaArray();
    }

    public static void confirmNodeIsSafe(Node node) {
        switch (node.nodeId) {
            case ARGSNODE: {
                ArgsNode argsNode = (ArgsNode)node;
                if (argsNode.getOptArgs() == null || argsNode.getOptArgs().size() <= 0) break;
                int index2 = argsNode.getRequiredArgsCount() - 1;
                for (int i = 0; i < argsNode.getOptArgs().size(); ++i) {
                    int newIndex = ((LocalAsgnNode)argsNode.getOptArgs().get(i)).getIndex();
                    if (newIndex - index2 != 1) {
                        throw new NotCompilableException("Can't compile def with optional args that assign other variables at: " + node.getPosition());
                    }
                    index2 = newIndex;
                }
                break;
            }
        }
    }

    public class SpecificArityArguments
    implements ArgumentsCallback {
        private int arity;
        private Node node;

        public SpecificArityArguments(Node node) {
            this.arity = node.nodeId == NodeType.ARRAYNODE && ((ArrayNode)node).isLightweight() ? ((ArrayNode)node).size() : 1;
            this.node = node;
        }

        public int getArity() {
            return this.arity;
        }

        public void call(MethodCompiler context) {
            if (this.node.nodeId == NodeType.ARRAYNODE) {
                ArrayNode arrayNode = (ArrayNode)this.node;
                if (arrayNode.isLightweight()) {
                    for (Node n : arrayNode.childNodes()) {
                        ASTCompiler.this.compile(n, context);
                    }
                } else {
                    ASTCompiler.this.compile(arrayNode, context);
                }
            } else {
                ASTCompiler.this.compile(this.node, context);
            }
        }
    }

    public class VariableArityArguments
    implements ArgumentsCallback {
        private Node node;

        public VariableArityArguments(Node node) {
            this.node = node;
        }

        public int getArity() {
            return -1;
        }

        public void call(MethodCompiler context) {
            ASTCompiler.this.compileArguments(this.node, context);
        }
    }
}

